/**
 * SollwerteHalterungspunktController
 */
SollwerteHalterungspunktController = function() {
	SollwerteHalterungspunktController.superclass.constructor.call(this);
};

EasyKat.extend(SollwerteHalterungspunktController, CustomController, 
{
	storePath : "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT",
	
	getValuesAction : function() {
        // @@@ combo: fr das selected item muss hier der bersetzte Text angegeben werden ... nicht schn!!
        // @@@ hier mit Presets vorbelegen, falls noch nichts gewhlt
        
        var lkTyp = caMainController.dataAccess.getLastketteTyp();
        
        var aDisabled	= [];
		var aEnabled	= [];
        
		if ((lkTyp == "EINZEL_SCHELLE") || (lkTyp == "STARR") || (lkTyp == "GELENKSTREBE") || (lkTyp == "STOSSBREMSE")){
			//aDisabled = ['IDC_RICHTUNG_BEWEGUNG_AUF', 'IDC_RICHTUNG_BEWEGUNG_AB', 'IDC_SOLLAST_IST_KALT', 'IDC_SOLLAST_IST_WARM'];
			aDisabled	= ['IDC_SOLLAST_IST_KALT', 'IDC_SOLLAST_IST_WARM'];
		}
		else
			//aEnabled = ['IDC_RICHTUNG_BEWEGUNG_AUF', 'IDC_RICHTUNG_BEWEGUNG_AB', 'IDC_SOLLAST_IST_KALT', 'IDC_SOLLAST_IST_WARM'];
			aEnabled = ['IDC_SOLLAST_IST_KALT', 'IDC_SOLLAST_IST_WARM'];
        /*
		var rBew = caMainController.dataAccess.getSollwerteRichtungBewegung();
		if (rBew == "")
            rBew = "AUF";      // Default
        */
		var artS = caMainController.dataAccess.getSollwerteArtSollast();
        if (artS == "")
            artS = "KALT";      // Default
		
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				//'IDC_RICHTUNG_BEWEGUNG': rBew,
				'IDC_SOLLAST_IST': artS
				},
            enabled		: aEnabled,
			disabled	: aDisabled
			};
		
		echo response.toJSON(); 
	},
	
	getTableAction : function() 
    {
        var lkTyp = caMainController.dataAccess.getLastketteTyp();
        var rohrverlauf = caMainController.dataAccess.getLastketteRohrverlauf();
		
		var pathSysChr	= "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK";
		var VertiRicht	= getstring("SENKR_RICHT", pathSysChr);
		var RohrRicht	= left(getstring("IDC_ROHRRICHTUNG", pathSysChr), 1);
		
		var xDisabledLpl	= false;
		var yDisabledLpl	= false;
		var zDisabledLpl	= false;
		var xDisabledLmi	= false;
		var yDisabledLmi	= false;
		var zDisabledLmi	= false;
		
		var AchsDirInfo	= caMainController.dataAccess.getAchsKSInfo();
		
		switch (AchsDirInfo[0])
		{
			case "X":
			{
				if (VertiRicht == "AUF" && lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					xDisabledLpl	= true;
				else if (lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					xDisabledLmi	= true;
				
				if ((lkTyp == "STARR") || (lkTyp == "GELENKSTREBE"))
					xDisabledB		= true;
				
				break;
			}
			case "Y":
			{
				if (VertiRicht == "AUF" && lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					yDisabledLpl	= true;
				else if (lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					yDisabledLmi	= true;
				
				if ((lkTyp == "STARR") || (lkTyp == "GELENKSTREBE"))
					yDisabledB		= true;
				
				break;
			}
			case "Z":
			{
				if (VertiRicht == "AUF" && lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					zDisabledLpl	= true;
				else if (lkTyp != "GELENKSTREBE" && lkTyp != "STOSSBREMSE")
					zDisabledLmi	= true;
				
				if ((lkTyp == "STARR") || (lkTyp == "GELENKSTREBE"))
					zDisabledB		= true;
				
				break;
			}
			default:
				break;
		}
        
		var table = { rows: [] };
        
		if (lkTyp != "STOSSBREMSE" && lkTyp != "GELENKSTREBE"){		// Auslegung der SSG prfen!!!
		table.rows.push({ 
					'idx'			: 'last_plus',
                    'beschriftung'	: translate('LAST') + " +",
					'x_richtung'	: (xDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 0),
                    'y_richtung'	: (yDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 1),
                    'z_richtung'	: (zDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLpl,
                    'yDisabled'		: yDisabledLpl,
                    'zDisabled'		: zDisabledLpl
                });
				
		table.rows.push({ 
					'idx'			: 'last_minus',
                    'beschriftung'	: translate('LAST') + " -",
					'x_richtung'	: (xDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 0),
                    'y_richtung'	: (yDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 1),
                    'z_richtung'	: (zDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLmi,
                    'yDisabled'		: yDisabledLmi,
                    'zDisabled'		: zDisabledLmi
                });
		}
				
		else{
			table.rows.push({ 
					'idx'			: 'last_plus',
                    'beschriftung'	: translate('LAST') + " (H) +",
					'x_richtung'	: (xDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 0),
                    'y_richtung'	: (yDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 1),
                    'z_richtung'	: (zDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('+', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLpl,
                    'yDisabled'		: yDisabledLpl,
                    'zDisabled'		: zDisabledLpl
					});
				
			table.rows.push({ 
					'idx'			: 'last_minus',
                    'beschriftung'	: translate('LAST') + " (H) -",
					'x_richtung'	: (xDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 0),
                    'y_richtung'	: (yDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 1),
                    'z_richtung'	: (zDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('-', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLmi,
                    'yDisabled'		: yDisabledLmi,
                    'zDisabled'		: zDisabledLmi
					});
			table.rows.push({ 
					'idx'			: 'last_plus_HZ',
                    'beschriftung'	: translate('LAST') + " (HZ) +",
					'x_richtung'	: (xDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HZ+', 1 , 0),
                    'y_richtung'	: (yDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HZ+', 1 , 1),
                    'z_richtung'	: (zDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HZ+', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLpl,
                    'yDisabled'		: yDisabledLpl,
                    'zDisabled'		: zDisabledLpl
					});
				
			table.rows.push({ 
					'idx'			: 'last_minus_HZ',
                    'beschriftung'	: translate('LAST') + " (HZ) -",
					'x_richtung'	: (xDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HZ-', 1 , 0),
                    'y_richtung'	: (yDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HZ-', 1 , 1),
                    'z_richtung'	: (zDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HZ-', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLmi,
                    'yDisabled'		: yDisabledLmi,
                    'zDisabled'		: zDisabledLmi
					});
			table.rows.push({ 
					'idx'			: 'last_plus_HS',
                    'beschriftung'	: translate('LAST') + " (HS) +",
					'x_richtung'	: (xDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HS+', 1 , 0),
                    'y_richtung'	: (yDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HS+', 1 , 1),
                    'z_richtung'	: (zDisabledLpl) ? '' : caMainController.dataAccess.getSollwerteLast('HS+', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLpl,
                    'yDisabled'		: yDisabledLpl,
                    'zDisabled'		: zDisabledLpl
					});
				
			table.rows.push({ 
					'idx'			: 'last_minus_HS',
                    'beschriftung'	: translate('LAST') + " (HS) -",
					'x_richtung'	: (xDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HS-', 1 , 0),
                    'y_richtung'	: (yDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HS-', 1 , 1),
                    'z_richtung'	: (zDisabledLmi) ? '' : caMainController.dataAccess.getSollwerteLast('HS-', 1 , 2),
                    'einheit'		: '[kN]',
                    'xDisabled'		: xDisabledLmi,
                    'yDisabled'		: yDisabledLmi,
                    'zDisabled'		: zDisabledLmi
					});
		}
		table.rows.push({
					'idx': 'zusatzlast',
					'beschriftung' : translate('ZUSATZLAST_GESCHAETZT'),
					'x_richtung' : caMainController.dataAccess.getSollwerteZusatzLast(1, 0),
					'y_richtung' : caMainController.dataAccess.getSollwerteZusatzLast(1, 1),
					'z_richtung' : caMainController.dataAccess.getSollwerteZusatzLast(1, 2),
					'einheit' : '[kN]',
					'xDisabled' : false,
					'yDisabled' : false,
					'zDisabled' : false
				});
			
		if (lkTyp != "EINZEL_SCHELLE")
		{	
			table.rows.push({
                        'idx': 'ueberlast',
                        'beschriftung' : translate('UEBERLAST'),
                        'x_richtung' : caMainController.dataAccess.getSollwerteUeberLast(1, 0),
                        'y_richtung' : caMainController.dataAccess.getSollwerteUeberLast(1, 1),
                        'z_richtung' : caMainController.dataAccess.getSollwerteUeberLast(1, 2),
                        'einheit' : '[kN]',
                        'xDisabled' : false,
                        'yDisabled' : false,
                        'zDisabled' : false
						});
				
            table.rows.push({
                        //'idx': 'bewegung',
						'idx': 'bewegung_plus',
                        'beschriftung' : translate('BEWEGUNG') + ' +',
                        //'x_richtung' : caMainController.dataAccess.getSollwerteBewegung('lateral'),
                        //'y_richtung' : caMainController.dataAccess.getSollwerteBewegung('axial'),
                        //'z_richtung' : (zDisabled) ? '' : caMainController.dataAccess.getSollwerteBewegung('vertikal'),
                        'x_richtung' : (xDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('+', 1, 0),
                        'y_richtung' : (yDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('+', 1, 1),
                        'z_richtung' : (zDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('+', 1, 2),
						'einheit' : '[mm]',
                        'xDisabled' : xDisabledB,
                        'yDisabled' : yDisabledB,
                        'zDisabled' : zDisabledB
                    });
				
			table.rows.push({
                        //'idx': 'bewegung',
						'idx': 'bewegung_minus',
                        'beschriftung' : translate('BEWEGUNG') + ' -',
                        //'x_richtung' : caMainController.dataAccess.getSollwerteBewegung('lateral'),
                        //'y_richtung' : caMainController.dataAccess.getSollwerteBewegung('axial'),
                        //'z_richtung' : (zDisabled) ? '' : caMainController.dataAccess.getSollwerteBewegung('vertikal'),
                        'x_richtung' : (xDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('-', 1, 0),
                        'y_richtung' : (yDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('-', 1, 1),
                        'z_richtung' : (zDisabledB) ? '' : caMainController.dataAccess.getSollwerteBewegung('-', 1, 2),
						'einheit' : '[mm]',
                        'xDisabled' : xDisabledB,
                        'yDisabled' : yDisabledB,
                        'zDisabled' : zDisabledB
                    });
            /**********
            else
            {
                
                var form = Object.fromStorage( "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT");
                if (form)
                {
                    form.IDC_TABLE.bewegung[0] = "";
                    form.IDC_TABLE.bewegung[1] = "";
                    form.IDC_TABLE.bewegung[2] = "";
                    form.toStorage("DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", false);
                }
            }
            *********/
        }
        else    // == EINZEL_SCHELLE
        {
            var form = Object.fromStorage( "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT");
            if (form)
            {
                form.IDC_TABLE.bewegung[0] = "";
                form.IDC_TABLE.bewegung[1] = "";
                form.IDC_TABLE.bewegung[2] = "";
                form.toStorage("DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT", false);
            }
        }
        
        table.rows.push({
                    'idx': 'einfuegepunkt',
                    'beschriftung' : translate('EINFUEGEPUNKT_ROHRMITTE'),
                    'x_richtung' : caMainController.dataAccess.getSollwerteEinfuegepunkt(1, 0),
                    'y_richtung' : caMainController.dataAccess.getSollwerteEinfuegepunkt(1, 1),
                    'z_richtung' : caMainController.dataAccess.getSollwerteEinfuegepunkt(1, 2),
                    'einheit' : '[mm]',
                    'xDisabled' : false,
                    'yDisabled' : false,
                    'zDisabled' : false
                });
        /*        
        if (lkTyp != "EINZEL_SCHELLE")
        {
            var RohrSchraege = caMainController.dataAccess.getSollwerteSchraegzug();
			table.rows.push({
                        'idx': 'schraegzug',
                        'beschriftung' : translate('SCHRAEGER_ROHRLEITUNGSVERLAUF'),
                        'x_richtung' : '',
                        'y_richtung' : (rohrverlauf == 'HORIZONTAL') ? RohrSchraege : '',
                        'z_richtung' : (rohrverlauf == 'VERTIKAL') ? RohrSchraege : '',
                        'einheit' : '[&deg;]',
                        'xDisabled' : true,
                        'yDisabled' : false,
                        'zDisabled' : true
                    });
        }
		*/
		echo table.toJSON();
	},
	
	getDescValuesAction : function()    // @@@ nicht mehr bentigt !?
	{
		var values = Object.fromStorage(this.storePath);
		// Man muss hier wissen dass in IDC_TABLE wieder JSON steckt
		//values.IDC_TABLE = EasyKat.decode( values.IDC_TABLE );
		
		var val = values.toJSON();
		echo val;
	},

	setValuesAction : function() 
    {
        // Nur zu Testzwecken, ob Daten da sind:
		var form = Object.fromStorage( this.storePath );
		var type = typeof form.IDC_TABLE;
        /*
		var l2_x = form.IDC_TABLE.last[0];
		var test = decodeURIComponent("%7B%22last%22%3A%5B%22%22%2C%22%22%2C14%5D%2C%22zusatzlast%22%3A%5B%22%22%2C%22%22%2C%22%22%5D%2C%22bewegung%22%3A%5B%22%22%2C%22%22%2C12%5D%2C%22ueberlast%22%3A%5B%22%22%2C%22%22%2C%22%22%5D%2C%22einfuegepunkt%22%3A%5B%22%22%2C%22%22%2C%22%22%5D%2C%22schraegzug%22%3A%5B%22%22%2C%22%22%2C%22%22%5D%7D");
        var test = 0;
        */
        var AchsDirInfo	= caMainController.dataAccess.getAchsKSInfo();
		
        // Bei Auswahl einzelne Schelle mssen wir hier noch die LGV bestimmen:
        var lkTyp               = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung     = caMainController.dataAccess.getLastketteLastabtragung();
        var lkRohrverlauf       = caMainController.dataAccess.getLastketteRohrverlauf();
        if (lkTyp == "EINZEL_SCHELLE")
        {
            //var last = caMainController.dataAccess.getSollwerteLast("vertikal", 1);
			var last = max(Math.abs(caMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(caMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
            // var passendeLGV = caMainController.sucheLGVzuLast(last);
            // -mw- 2.6.08: LGV bezieht sich auf den Strang, da hier doppelt also die Hlfte
            if (lkRohrverlauf == "VERTIKAL")
                last = last / 2;
            var passendeLGV = caMainController.sucheLGVzuLast(last);    
            caMainController.topologieKlasse.a_lgv = passendeLGV.defaultLgv;        
        }
        // Bei Auswahl SSG/SSB kann direkt die Auslegung erfolgen:
        if (lkTyp == "GELENKSTREBE")
        {
            caMainController.legeSSGAus();
        }
		else if (lkTyp == "STOSSBREMSE")
		{
			caMainController.legeSSBAus();
		}
		
        if ((lkLastabtragung == "STUETZEND_EINFACH") || 
            ((lkLastabtragung == "HAENGEND_DOPPEL") && (lkRohrverlauf == "HORIZONTAL")))
        {
            setstring("IDC_LAGER_ROHRM_X", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN", caMainController.dataAccess.getSollwerteEinfuegepunkt('lateral'));
            setstring("IDC_LAGER_ROHRM_Y", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN", caMainController.dataAccess.getSollwerteEinfuegepunkt('axial'));
            setstring("IDC_LAGER_ROHRM_Z", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN", caMainController.dataAccess.getSollwerteEinfuegepunkt('vertikal'));
        }
	}
});