#include "classes/Sap_rfc.es"


//-------------------------------------------
// Input-Tabellen fr Kundenauftrag

/**
 *
 * @var array
 */
var descZKP_SAK = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "USREX", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "KUNNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "PRONR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "AUSNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "LAISO", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  }
];

/**
 *
 * @var array
 */
var descZKP_SAP = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "MATNR", type: "CHAR", width:18, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "KDMAT", type: "CHAR", width:35, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "KPTYP", type: "CHAR", width:40, dez: 0, align: '', fillchar: ' ', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "VRKME", type: "CHAR", width: 3, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "MENGE", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#014.3f', defval: ''  },
	{ name: "MENGE", type: "CHAR", width:14, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%d', defval: ''  },
	{ name: "GEWEI", type: "CHAR", width: 3, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "BRGEW", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#014.3f', defval: ''  },
	{ name: "BRGEW", type: "CHAR", width:14, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%d', defval: ''  },
	{ name: "WAERS", type: "CHAR", width: 5, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "PREIS", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#014.2f', defval: ''  },
//	{ name: "VERPA", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#08.2f', defval: ''  },
//	{ name: "FRACH", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#08.2f', defval: ''  },
//	{ name: "ABNAE", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#08.2f', defval: ''  },
//	{ name: "ABNAI", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%#08.2f', defval: ''  },
	{ name: "PREIS", type: "CHAR", width:14, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "VERPA", type: "CHAR", width: 8, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "FRACH", type: "CHAR", width: 8, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ABNAE", type: "CHAR", width: 8, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ABNAI", type: "CHAR", width: 8, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ZZ_KZ_POENA", type: "CHAR", width: 1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ZZ_KZ_RUEST", type: "CHAR", width: 1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ZZ_KZ_AKKRE", type: "CHAR", width: 1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ZZ_KZ_EXABN", type: "CHAR", width: 1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "KZKDE", type: "CHAR", width: 1, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ARKTX", type: "CHAR", width: 40, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: '' },
	{ name: "MARK1", type: "CHAR", width: 100, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: '' },
	{ name: "ABGRU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: '' },
	{ name: "LPRIO", type: "CHAR", width: 2, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: '' }

];

/**
 *
 * @var array
 */
var descZKP_SVP = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ATNAM", type: "CHAR", width:30, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ATLFD", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ATWRT", type: "CHAR", width:30, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "NEINS", type: "UNIT", width: 3, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  }
];

/**
 *
 * @var array
 */
var descZKP_SVT = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "TXTID", type: "CHAR", width: 4, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "LAISO", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ZEILE", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "TEXT1", type: "UNIT", width:70, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  }
];

//-------------------------------------------
// Input-Tabellen fr Auftragsstckliste

var descZKP_SASTK = [
	{ name: "MANDT", type: "CHAR", width: 9, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "MATNR", type: "CHAR", width:18, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "DATUV", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "BMENG", type: "CHAR", width:13, dez: 3, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%#013.3f', defval: ''  },
	{ name: "STATU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERDAT", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERZET", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERNAM", type: "CHAR", width:12, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "DOCNUM", type: "CHAR", width:16, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  }
];

var descZKP_SASTP = [
	{ name: "MANDT", type: "CHAR", width: 9, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "MATNR", type: "CHAR", width:18, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "SPOSN", type: "CHAR", width: 4, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "LFDSP", type: "CHAR", width: 4, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "POSTP", type: "CHAR", width: 1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "IDNRK", type: "CHAR", width:18, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "KPMNG", type: "CHAR", width:13, dez: 3, align: '', fillchar: '0', fillpos: 'l', formatstr:'%#013.3f', defval: ''  },
	{ name: "MEINS", type: "CHAR", width: 3, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "FIXMG", type: "CHAR", width: 1, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POTX1", type: "CHAR", width:40, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POTX2", type: "CHAR", width:40, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ROMS1", type: "CHAR", width:13, dez: 3, align: '', fillchar: '0', fillpos: 'l', formatstr:'%#013.3f', defval: ''  },
	{ name: "ROMEI", type: "CHAR", width: 3, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ROMS2", type: "CHAR", width:13, dez: 3, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ROMS3", type: "CHAR", width:13, dez: 3, align: '', fillchar: '0', fillpos: 'l', formatstr:'%#013.3f', defval: ''  },
	{ name: "RFORMT", type: "CHAR", width: 2, dez: 0, align: '', fillchar: ' ', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "DSPST", type: "CHAR", width: 2, dez: 0, align: '', fillchar: ' ', fillpos: 'l', formatstr:'%s', defval: ''  }
];

/**  Felder entfernt -mw- 10.7.2008
	{ name: "STATU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERDAT", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERZET", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0', fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERNAM", type: "CHAR", width:12, dez: 0, align: '', fillchar: ' ', fillpos: 'r', formatstr:'%s', defval: ''  }
**/

//-------------------------------------------
// Input-Tabelle fr Zeichnungsbergabe

var descZKP_PPD = [
//	{ name: "MANDT", type: "CHAR", width: 9, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "SATZART", type: "CHAR", width:3, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
//	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:17, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "MATNR", type: "CHAR", width:18, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "WERKS", type: "CHAR", width: 4, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "PSPNR", type: "CHAR", width:25, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "DOKTY", type: "CHAR", width: 4, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "DATEI", type: "CHAR", width:255, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "BEZEICHNUNG", type: "CHAR", width:40, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "FORMAT", type: "CHAR", width:2, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  },
	{ name: "STATU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERDAT", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERZET", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '0',  fillpos: 'l', formatstr:'%s', defval: ''  },
	{ name: "ERNAM", type: "CHAR", width:12, dez: 0, align: '', fillchar: ' ',  fillpos: 'r', formatstr:'%s', defval: ''  }
];



//-------------------------------------------
// Output-Tabelle fr alle RFC's

/**
 *
 * @var array
 */
var descBAPIRET2 = [
    { name: "TYPE",         type: "CHAR", width:  1, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "ID",           type: "CHAR", width: 20, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "NUMBER",       type: "NUMC", width:  3, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "MESSAGE",      type: "CHAR", width:220, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "LOG_NO",       type: "CHAR", width: 20, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "LOG_MSG_NO",   type: "NUMC", width:  6, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "MESSAGE_V1",   type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "MESSAGE_V2",   type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "MESSAGE_V3",   type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "MESSAGE_V4",   type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "PARAMETER",    type: "CHAR", width: 32, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "ROW",          type: "INT4", width: 10, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "FIELD",        type: "CHAR", width: 30, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  },
    { name: "SYSTEM",       type: "CHAR", width: 10, dez: 0, align: '', fillchar: '', fillpos: 'r', formatstr:'%s', defval: ''  }
];

/**
 * Controller fr alle SAP-RFC's
 */
SapRfcController = function() {
	SapRfcController.superclass.constructor.call( this );
}

EasyKat.extend( SapRfcController, CustomController,
{
    startKundenauftragTestfallAction : function()
    {
        // Testdatei aus dem GUI lesen
        var testFile = getdlgvar("strEdit");
        var strPrgPath  = getstddirectory("PROGRAM");
        var strDataPath = strPrgPath + "catalog\\data\\sap\\";
        this.startKundenauftragPlugin(strDataPath + testFile);
    },

    startAuftragsstuecklisteTestfallAction : function()
    {
        // Testdatei aus dem GUI lesen
        var testFile = getdlgvar("strEdit");
        var strPrgPath  = getstddirectory("PROGRAM");
        var strDataPath = strPrgPath + "catalog\\data\\sap\\";
        this.startAuftragsstuecklistePlugin(strDataPath + testFile);
    },

    getDataDir : function()
    {
        // Bilde temporren Dateinamen aus Auftragsnummer, Datum, Zufallszahl
        // Datei muss in den data/sap-Ordner
        var strPrgPath  = getstddirectory("PROGRAM");
        var dataDir     = strPrgPath;
		if ( checkexist( "CATALOG.SAP", "" ) )
		{
			// get data path
			var strPath = getstring( "CATALOG.SAP.DATAPATH", "" );
			if ( strPath.substring( 0, 2 ) == ".\\" )
			{
				// relative path
				strPath = strPath.substring( 2 );
			}
			else if ( strPath != "" )
			{
				// ----------------------------------------------------------------------
				//dataDir	= strPath;			// absoluter Pfad aus catpaths
				dataDir	= "";
				var IsNotTestsystem		= (getint("IS_TESTSYSTEM", "CATALOG.TESTSYSTEM") ? "" : "not");
				var strSQLStatement		= "select * from DATAPATH where LOCATION " + IsNotTestsystem + " like 'TESTSYSTEM' order by abs(SEQ_ID) ";
				var numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
				var SAP_DATAPATH		= "";
				var SAP_PATH_OPTIONS	= [];
				while (dbiseof("PATH") == 0)
				{
					SAP_DATAPATH		= dbgetstring("PATH", "SAP_DATAPATH");
					
					// hier stehen zum Teil absolute aber auch Netzwerkpfade drin
					if (left(SAP_DATAPATH, 1) == "\\")
						SAP_DATAPATH	= "\\" + SAP_DATAPATH;
					
					if ( SAP_DATAPATH.indexOf( "$TMP$" ) > -1 )
						SAP_DATAPATH = SAP_DATAPATH.replace( "$TMP$", getstddirectory( "TEMP" ) );
					else if ( SAP_DATAPATH.indexOf( "$TEMP$" ) > -1 )
						SAP_DATAPATH = SAP_DATAPATH.replace( "$TEMP$", getstddirectory( "TEMP" ) );
					SAP_PATH_OPTIONS.push(SAP_DATAPATH);
					if(FileName.dirExists(SAP_DATAPATH + "\\"))
						dataDir	= SAP_DATAPATH;		// Pfad aus DB existiert
					
					dbskip("PATH");
				}
				if (dataDir == "" && IsNotTestsystem == "")	// Vorgegebene Pfade fr Testsystem existieren noch nicht
				{
					for (var i=0; i<SAP_PATH_OPTIONS.length; i++){
						var DirExists = FileName.dirExists(SAP_PATH_OPTIONS[i] + "\\");
						if (!DirExists){
							myMainController = new CaController();
							DirExists = myMainController.dataAccess.CreatePath(SAP_PATH_OPTIONS[i]);
						}
						if (DirExists)
							break;
					}
					dataDir = SAP_PATH_OPTIONS[min(i, SAP_PATH_OPTIONS.length-1)];
				}
				if (dataDir == "")
					dataDir	= strPath;
				
				if ( dataDir.indexOf( "$TMP$" ) > -1 )
					dataDir = dataDir.replace( "$TMP$", getstddirectory( "TEMP" ) );
				else if ( dataDir.indexOf( "$TEMP$" ) > -1 )
					dataDir = dataDir.replace( "$TEMP$", getstddirectory( "TEMP" ) );
				// ----------------------------------------------------------------------
				
				// ORIGINAL
				/*
				dataDir = strPath;		// absolute path
				*/
				
			}
        }
		if ( dataDir.charAt( dataDir.length - 1 ) != "\\" )
			dataDir += "\\";
        return dataDir;
    },

    getDateObject : function()
    {
        getdate('CURRENT_TIME','TEMP');
        /*	"YEAR"	"MONTH"	"DAY" "HOUR" "MINUTE" "SECOND"
            // Alles auf einmal: YYYYMMDD.HHMMSS
            "TIME"
        */
        var strDate     = getstring('TIME','TEMP.CURRENT_TIME');
        var strTagSAP   = getstring('DAY','TEMP.CURRENT_TIME');
        var strMonatSAP = getstring('MONTH','TEMP.CURRENT_TIME');
        if (strTagSAP.length <= 1)
            strTagSAP = "0" + strTagSAP;
        if (strMonatSAP.length <= 1)
            strMonatSAP = "0" + strMonatSAP;
        var strDateSAP    = strTagSAP + strMonatSAP + getstring('YEAR','TEMP.CURRENT_TIME');
        var strDateExport = getstring('YEAR','TEMP.CURRENT_TIME') + strMonatSAP + strTagSAP;

        var oDate = { datefile: strDate,
                      datesap : strDateSAP,
                      dateexport: strDateExport };
        return oDate;
    },

    startPlugin : function(nTransferCount, strRfcType, strOutFile, dataDir, response, bTestfall)
    {
        var ernstfall = getstring( "CATALOG.SAP.ERNSTFALL", "" );
        var ret = 1;

        if (nTransferCount <= 0)
        {
            response.message = 'Keine Daten uebertragen, da keine Cascade-Position markiert wurde!';
            ret = -1;
        }
        else if ((ernstfall != "0") && (! bTestfall))
        {
            var SAP_SYSTEM		= toupper(getstring( "CATALOG.SAP.SAPINFO", "" ));
			SAP_SYSTEM			= (rfind(SAP_SYSTEM, "TEST") > -1 ? "K" : "P");
			var strSQLStatement	= "select * from TRANSFER where GATE = 'SAPCONNECT_" + SAP_SYSTEM + "' order by abs(SEQ_ID) ";
			var numRet			= dbselect("CASCADE", strSQLStatement, "SAP");
			var connectString	= "";
			while (dbiseof("SAP") == 0)
			{
				connectString	= dbgetstring("SAP", "CONNECT");
				dbskip("SAP");
			}
			
			if (strRfcType == "KDAUFTRAG")
            {
                response.message = "Kundenauftrag erfolgreich uebertragen";
                ret = this.startKundenauftragPlugin(strOutFile, dataDir, response, connectString);
            }
            else if (strRfcType == "AUFTRSTKLIST")
            {
                response.message = "Auftragsstckliste erfolgreich uebertragen";
                ret = this.startAuftragsstuecklistePlugin(strOutFile, dataDir, response, connectString);
            }
            else if (strRfcType == "ZGUEBERGABE")
            {
                response.message = "Zeichnungsdaten erfolgreich uebertragen";
                ret = this.startZeichnungsuebergabePlugin(strOutFile, dataDir, response, connectString);
            }
            else
            {
                response.message = 'Unbekannter RFC-Typ!';
                ret = -1;
            }
        }
        else
        {
            if (bTestfall)
            {
                response.outfile = strOutFile;  // Wir missbrauchen die Response als Container ...
            }
            else
                response.message = 'Testdatei ' + replace(strOutFile, "\\", "/") + ' erzeugt!';
        }

        //    echo response.toJSON();
        //    _global.MIMETYPE = 'application/json';

        return ret;
    },

    plugInExecAndCheck : function(rfc, plugin, dataDir, response)
    {
		var rv = plugin.getLastErrorTxt();
        logtrace("plugin.getLastErrorTxt returns:"+rv+"\n");
        var ret = 1;

		if(rv == "")
        {
            logtrace("Starte Exec Function Call SAP\n");
			var retExec = plugin.execFunctionCall();
            logtrace("Exec Function Call SAP returns:"+retExec+"\n");
			var errMsg = plugin.getLastErrorTxt();


            if (retExec == 18)
            {
                response.message = "Connection to SAP failed!";
                logtrace("Connection to SAP failed!\n");
                ret = -1;
            }
            else if (retExec != 0)
            {
                // alert(errMsg);
                if (errMsg != "")
                    response.message = replace(errMsg, "\n", "\\n");
                else
                    response.message = "Execution of RFC failed!";
                logtrace("Connection to SAP failed!\n");
                ret = -1;
            }
            else
            {
                rv = plugin.getImportParam("EF_ERROR");
                logtrace("EF_ERROR ist:"+rv+"\n");
                if (toupper(rv) == 'X')
                {
                    ret = -1;
                    // Get Error Table
                    var tabErr = null;				// Error Table
                    // tabErr = rfc.tableReader(dataDir +  "ET_RET.txt", descBAPIRET2);
                    // logtrace("Read table ET_RET returns:"+tabErr+"\n");
                    var strET_RET = readfile(dataDir +  "ET_RET.txt");
                    logtrace("Read table ET_RET returns:\n"+strET_RET+"\n");
                    if (strET_RET != "")
                    {
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "  ", " ");
						strET_RET = replace(strET_RET, "\r", "");
                        response.message = replace(strET_RET, "\n", "\\n");
                    }
                }
            }
		}
        else
        {
			response.message = rv;
            ret = -1;
		}
        logtrace("Return message from plugInExecAndCheck is:\n"+message+"\n");
        return ret;
    },

    checkCompleteBasisdaten :  function()
    {
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";

        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var strProductArea, strSAPcheck;
        var strPosNr, strQTY, strKDMAT, strPrice, strPrAbnE, strPrAbnI;
        var i, nTransferCount = 0;

        var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
        var strKundenNr  = getstring("WI_KDNR",        ProjectSettings);

        var strMessage = "";
        if (strAngebNr == "")
            strMessage += "Angebotsnummer fehlt!\\n";
        if (strKundenNr == "")
            strMessage += "Kundennummer fehlt!\\n";

        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strQTY          = getstring("QTY", Source);
            strKDMAT        = getstring("CUSTOMER_CODE", Source);
            strPosNr        = getstring("POS", Source);

            var strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF_SAP", Source);
            var strCacheDxf     = getstring("CACHE_DRAWING_FILE_DXF", Source);
            var strStatusPreis  = getstring("STATUS_PREIS", Source);
            var strStatusMat    = getstring("STATUS_MATNR", Source);
            var fUnitprice      = getstring("FORCEDUNITPRICE", Source); // Vom VB festgesetzter Stueckpreis, als STRING, kann in Projektliste gendert werden
            fUnitprice      = replace (fUnitprice, ",", ".");

            // Basisdaten mssen fr freie Positionen geprft werden
            if (((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;

                if (strProductArea == "FP")
                {
                    var unitPrice = getstring("UNITPRICE", Source);
                    var matNr = getstring("IDENT", Source);
                    matNr = trimleft(matNr, " ");
                    if ((inputStringToDouble(unitPrice) <= 0) && (inputStringToDouble(fUnitprice) <= 0))
                        strMessage += "Position " + strPosNr + ": Preis fehlt und Positionspreis nicht vorgegeben!\\n";

                    if (matNr == "")
                        strMessage += "Position " + strPosNr + ": Materialnummer fehlt!\\n";
                }
                else
                {
                    if ((strStatusPreis != "OK") && (inputStringToDouble(fUnitprice) <= 0))
                        strMessage += "Position " + strPosNr + ": Einzelteilpreis fehlt und Positionspreis nicht vorgegeben!\\n";

                    if (strStatusMat != "OK")
                        strMessage += "Position " + strPosNr + ": Einzelne Materialnummer fehlt!\\n";
                }
            }
        }
        if (nTransferCount <= 0)
            strMessage += "Keine SAP-relevante Position in Projektliste markiert!";
        return strMessage;
    },

    checkCompleteAuftragsstueckliste :  function()
    {
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";

        var dataDir     = this.getDataDir();
        var oDate       = this.getDateObject();
        var strRand     = rand();
        var strAngebNr  = getstring("WI_ANGEBOTSNR", ProjectSettings);
        // Spezieller Dateiname fr die Check-Funktion:
        var strOutFile  = dataDir + "AS_CHECK_" + strAngebNr + "_" + oDate.datefile + "_" + strRand + ".csv";

        writefile(strOutFile, "// Flexperte auto generated Interface File for SAP-RFC Auftragsstckliste \r\n", "wc");	// write, create

        // Fr die Auftragsstckliste gibt es keinen projektbezogenen Datensatz

        // Iteriere ber die Projektlistenpositionen
        // Bearbeitet werden nur die bei denen SAP angekreuzt ist und die
        // auch tatschlich RH / Cascade-Positionen sind
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strPosNr, strQTY;
        var i;
        var strMessage = "";
        var oAstlRet = {};

        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            // Prfe SAP-Checkbox + Produktbereich!
            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strQTY          = getstring("QTY", Source);
            strPosNr        = getstring("POS", Source);

            // Auftragsstckliste gibt es nicht fr freie Positionen,
            // deshalb muss hier fr freie Positionen nichts geprft werden
            if (((strProductArea == "RH") || (strProductArea == "CA")) &&
                (strSAPcheck == "true"))
            {
                delete(Target, "");
                copy(Source, Target);

                // Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
                tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher
                caMainController = tmpCaMainController;  // just  to be sure ...

                oAstlRet = tmpCaMainController.addPositionToAuftragsStkListe(strOutFile,
                                                                strAngebNr,
                                                                strPosNr,
                                                                strQTY,
                                                                oDate.datesap
                                                                );
                if (oAstlRet.strMessage != "")
                    strMessage += oAstlRet.strMessage;
            }
        }
        return strMessage;
    },

    checkCompleteZeichnungsdaten :  function()
    {
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";

        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var strProductArea, strSAPcheck;
        var strPosNr;
        var i;

        var strMessage = "";

        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strPosNr        = getstring("POS", Source);

            var strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF_SAP", Source);
            var strCacheDxf     = getstring("CACHE_DRAWING_FILE_DXF", Source);
            var strStatusPreis  = getstring("STATUS_PREIS", Source);
            var strStatusMat    = getstring("STATUS_MATNR", Source);
            var fUnitprice      = getstring("FORCEDUNITPRICE", Source); // Vom VB festgesetzter Stueckpreis, als STRING, kann in Projektliste gendert werden
            fUnitprice      = replace (fUnitprice, ",", ".");

            // Auftragsstckliste gibt es nicht fr freie Positionen,
            // deshalb muss hier fr freie Positionen nichts geprft werden
            if (((strProductArea == "RH") || (strProductArea == "CA")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;

                var bCachePdfExists = false;
                if ((strCachePdf != "") && FileName.fileExists(strCachePdf))
                    bCachePdfExists = true;

                if (!bCachePdfExists)
                    strMessage += "Position " + strPosNr + ": Zeichnung noch nicht erstellt!\\n";
            }
        }
        return strMessage;
    },

    // Vorschau des Kundenauftrags
    startSapVorschauFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 1;

        var ret = this.startKundenauftrag(response, bTestfall);

        if (ret > 0)
        {
            var strCsvFile = response.outfile;

            // ... csv konvertieren nach Excel
            // ... Excel mit ShellEx starten ...
			var csvManager = new CascadeCsvManager("KDAUFTRAG");
			csvManager.writeCsvAsXml(strCsvFile);
			if(csvManager.bError)
				response.message = csvManager.msgError;
        }
		var halt;
        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    // Vorschau der Auftragsstckliste
    startSapVorschauAstlFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 1;

        var ret = this.startAuftragsstueckliste(response, bTestfall);

        if (ret > 0)
        {
            var strCsvFile = response.outfile;

            // ... csv konvertieren nach Excel
            // ... Excel mit ShellEx starten ...
			var csvManager = new CascadeCsvManager("ASTL");
			csvManager.writeCsvAsXml(strCsvFile);
			if(csvManager.bError)
				response.message = csvManager.msgError;
        }

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    // start_sap_alle_rfcs_from_projectlist
    startSapAlleRfcsFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 0;
        var i, Source, strProductArea, strSAPcheck;

        alert(translate("MSG_SAP_START_RFC"));


        // Prfung schon vor dem Aufruf der RFC's damit nicht nur ein Teil bergeben wird:
        var strError = this.checkCompleteBasisdaten();
        if (strError == "")
            strError = this.checkCompleteAuftragsstueckliste();
        if (strError == "")
            strError = this.checkCompleteZeichnungsdaten();
        if (strError != "")
        {
            response.message = strError;
            echo response.toJSON();
            _global.MIMETYPE = 'application/json';
            return;
        }

        // Wenn Tests erfolgreich, dann Projektdatei abspeichern:
        // "Projektordner" ("J:\id\teams\FLEX.DAT") mit allen Positionen. Dateiname: Angebots-Nr & Datum & "AUF"
		var prjFileVersionMajor = getstring("CATALOG.PROJECTFILEVERSION.MAJOR", "");
		var prjFileVersionMinor = getstring("CATALOG.PROJECTFILEVERSION.MINOR", "");
		var prjFileVersionSVN   = getstring("CATALOG.PROJECTFILEVERSION.SVN", "");
		setstring("PROJECT.PROJECTFILEVERSION.MAJOR", "", prjFileVersionMajor);
		setstring("PROJECT.PROJECTFILEVERSION.MINOR", "", prjFileVersionMinor);
		setstring("PROJECT.PROJECTFILEVERSION.SVN",   "", prjFileVersionSVN);

		if ( checkexist( "CATALOG.SAP", "" ) )
		{
			// get project path
			var strPath = getstring( "CATALOG.SAP.PROJEKTORDNER", "" );
            // nur absolute Pfade werden untersttzt
			if ( strPath != "" )
            {
				// ----------------------------------------------------------------------
				//dataDir	= strPath;			// absoluter Pfad aus catpaths
				dataDir	= "";
				var IsNotTestsystem		= (getint("IS_TESTSYSTEM", "CATALOG.TESTSYSTEM") ? "" : "not");
				var strSQLStatement		= "select * from DATAPATH where LOCATION " + IsNotTestsystem + " like 'TESTSYSTEM' order by abs(SEQ_ID) ";
				var numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
				var PROJEKTORDNER		= "";
				var PROJEKTORDNER_OPTIONS	= [];
				while (dbiseof("PATH") == 0)
				{
					PROJEKTORDNER		= dbgetstring("PATH", "PATH_PROJEKTORDNER");
					if ( PROJEKTORDNER.indexOf( "$TMP$" ) > -1 )
						PROJEKTORDNER = PROJEKTORDNER.replace( "$TMP$", getstddirectory( "TEMP" ) );
					else if ( PROJEKTORDNER.indexOf( "$TEMP$" ) > -1 )
						PROJEKTORDNER = PROJEKTORDNER.replace( "$TEMP$", getstddirectory( "TEMP" ) );
					PROJEKTORDNER_OPTIONS.push(PROJEKTORDNER);
					if(FileName.dirExists(PROJEKTORDNER + "\\"))
						dataDir	= PROJEKTORDNER;		// Pfad aus DB existiert
					
					dbskip("PATH");
				}
				if (dataDir == "" && IsNotTestsystem == "")	// Vorgegebene Pfade fr Testsystem existieren noch nicht
				{
					for (var i=0; i<PROJEKTORDNER_OPTIONS.length; i++){
						var DirExists = FileName.dirExists(PROJEKTORDNER_OPTIONS[i] + "\\");
						if (!DirExists){
							myMainController = new CaController();
							DirExists = myMainController.dataAccess.CreatePath(PROJEKTORDNER_OPTIONS[i]);
						}
						if (DirExists)
							break;
					}
					dataDir = PROJEKTORDNER_OPTIONS[min(i, PROJEKTORDNER_OPTIONS.length-1)];
				}
				if (dataDir == "")
					dataDir	= strPath;
				
				if ( dataDir.indexOf( "$TMP$" ) > -1 )
					dataDir = dataDir.replace( "$TMP$", getstddirectory( "TEMP" ) );
				else if ( dataDir.indexOf( "$TEMP$" ) > -1 )
					dataDir = dataDir.replace( "$TEMP$", getstddirectory( "TEMP" ) );
				
				strPath = dataDir;
				// ----------------------------------------------------------------------
				
				if ( strPath.charAt( strPath.length - 1 ) != "\\" )
                    strPath += "\\";

                var oDate = this.getDateObject();
                var ProjectSettings = "PROJECT.SETTINGS";
                var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
                strAngebNr = trimleft(strAngebNr, " ");
                strAngebNr = trimright(strAngebNr, " ");
                strAngebNr = replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});

                // Prfen ob Pfad da ist, notfalls anlegen ...
                var strAuftragsPfad = strPath + strAngebNr;
                if (!FileName.dirExists(strAuftragsPfad))
                {
                    var ret = filecommand("mkdir", strAuftragsPfad);
                    if (ret == 0)
                        alert(replace(translate("ERR_FOLDER_ANGEBOT"), "#x#", strAuftragsPfad));
                }

                // Projektdatei abspeichern
                // var Datei = strPath + strAngebNr + "_" + oDate.dateexport + "_AUF.wit";
                var Datei = strAuftragsPfad + "\\" + strAngebNr + "_" + oDate.dateexport + "_AUF.wit";
                savexml("PROJECT", Datei);

                // Massenauszug abspeichern
                Datei = strAuftragsPfad + "\\" + strAngebNr + "_" + oDate.dateexport + "_MASS.xls";
                var dokManager = new CaDokManager(caMainController);
                if(dokManager.xmlSetFileOutput(Datei) == true)
                    dokManager.writeDokFromProjectlist(0);
					
				//****************************************
				// Daten auch in den Sharepoint speichern
				//****************************************
		
				var strQuoteID = getstring("CRMQUOTEID", "");
				var strCRMAction = getstring("CRMACTION", "");
				var strCRMUser = getstring("CRMUSER", "");
				
				if (strCRMQuoteID != "" && strCRMAction != "" && strCRMUser != "")
				{
			
					getdate('CURRENT_TIME','TEMP');
					var strYear  = getstring('YEAR','TEMP.CURRENT_TIME');
					var strMonth = getstring('MONTH','TEMP.CURRENT_TIME');
					var strDay   = getstring('DAY','TEMP.CURRENT_TIME');
					var strHour  = getstring('HOUR','TEMP.CURRENT_TIME');
					var strMin   = getstring('MINUTE','TEMP.CURRENT_TIME');
					var strSec   = getstring('SECOND','TEMP.CURRENT_TIME');
					if (strMonth.length < 2)
						strMonth = "0" + strMonth;
					if (strDay.length < 2)
						strDay = "0" + strDay;
					if (strHour.length < 2)
						strHour = "0" + strHour;
					if (strMin.length < 2)
						strMin = "0" + strMin;

					var strTime = strYear + strMonth + strDay + strHour + strMin + strSec;

					var strAngebNrCRM = getstring("WI_ANGEBOTSNR",  "PROJECT.SETTINGS");
					strAngebNrCRM = trimleft(strAngebNrCRM, " ");
					strAngebNrCRM = trimright(strAngebNrCRM, " ");
					strAngebNrCRM = replaceSpecialChars(strAngebNrCRM, {FuerCSV : 0, FuerDateiname : 1});
					
					//Projektfile
					var strProjektfile = getstddirectory( "TEMP" ) + "AUF_"+strAngebNrCRM+"_"+strTime+".wit";
					savexml("PROJECT", strProjektfile);
					
					//Angebot
					var strAngebotfile = getstddirectory( "TEMP" ) + "AUF_"+strAngebNrCRM+"_"+strTime+".rtf";
					setstring("FILENAME_OFFER_CRM", "", strAngebotfile);
					specialexec("PrintProjectSAP");
					
					//Massenauszug
					var strMassenauszugfile = getstddirectory( "TEMP" ) + "AUF_"+strAngebNrCRM+"_MASS_FL_"+strTime+".xls";
					var strMassenauszugfile_csv = getstddirectory( "TEMP" ) + "AUF_"+strAngebNrCRM+"_MASS_FL_"+strTime+".csv";
					
					var dokManager = new CaDokManager(caMainController);
					if(dokManager.xmlSetFileOutput(strMassenauszugfile) == true) {
						dokManager.writeDokFromProjectlist(0);
						var aParam = [strProjektfile,strAngebotfile,strMassenauszugfile,strMassenauszugfile_csv];
						ret = TransferFilestoCRM(aParam);
						if (! ret) {
							alert("Fehler beim Transfer Massenauszug/SAP in den Sharepoint!");
							break;
						}
					}
				}
				
				//********************************************
				// ENDE Daten auch in den Sharepoint speichern
				//********************************************
		
                // Gepacktes PDF erzeugen und abspeichern ...
                var Source, i, strPdfInputListe= "";
                var bCachePdfExists;
                var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
                var nLastPos = getsize(Projectlist, "") - 1;
                for (i = 0; i <= nLastPos; ++i)
                {
                    Source = Projectlist + "[" + i + "]";
                    var strProductArea  = getstring("PRODUCT_AREA", Source);
                    if ((strProductArea == "RH") || (strProductArea == "CA"))
                    {
                        var strCachePdf = getstring("CACHE_DRAWING_FILE_PDF_SAP", Source);

                        bCachePdfExists = false;
                        if ((strCachePdf != "") && FileName.fileExists(strCachePdf))
                            strPdfInputListe += " \"" + strCachePdf + "\"";
                    }
                }

                var strPrgPath  = getstddirectory( "PROGRAM" ) + "catalog\\plugin\\";    // inkl. trailing Backslash
                var strExecutable = strPrgPath + "pdftk.exe";
                Datei = strAuftragsPfad + "\\" + strAngebNr + "_" + oDate.dateexport + "_ZG.pdf";

                if (Datei != "")
                {
                    var strParams = strPdfInputListe + " cat output \"" + Datei + "\" dont_ask ";

                    var strFileLine = strExecutable + " " + strParams;
                    var strBatfile  = gettempfile(strUserExportPath, "bat");
                    writefile( strBatfile, strFileLine, "wc" );

                    // Datei erzeugen
                    // shellexecuteexblocking( strExecutable, strParams, strUserExportPath, 1, 256000 );    // show = 1
                    shellexecuteexblocking( strBatfile, "", strUserExportPath, 0, 256000 );    // show = 1
                }
				
				
				//Massbild in Sharepoint speichern
				if (strCRMQuoteID != "" && strCRMAction != "" && strCRMUser != "")
				{
					var strtoPath = getstddirectory( "TEMP" )+"AUF_"+ strAngebNr + "_" + oDate.dateexport + "_ZG.pdf";;
					var fName = new FileName(Datei);
					var isOK = fName.copyTo(strtoPath, true);
					
					if(isOK)
					{
						var aParam = [strtoPath];
						ret = TransferFilestoCRM(aParam);
						if (! ret) {
							alert("Fehler beim Transfer MassPDF/SAP in den Sharepoint!");
							break;
						}
					}
				}
            }
        }

        var strSuccessMessage = "";
        var ret = this.startKundenauftrag(response, bTestfall);
        if (ret > 0)
        {
            strSuccessMessage += translate("MSG_RFC_KUNDENAUFTRAG")+"\\n";
            ret = this.startAuftragsstueckliste(response, bTestfall);
            if (ret > 0)
            {
                strSuccessMessage += translate("MSG_RFC_AUFTRAGSTKLST")+"\\n";
                ret = this.startZeichnungsuebergabe(response, bTestfall);
                if (ret > 0)
                {
                    strSuccessMessage += translate("MSG_RFC_ZEICHNUNG")+"\\n";
                    response.message = translate("MSG_RFC_SAP_SUCCESS");

                    // Jetzt die markierten Positionen kennzeichnen, dass erfolgreich bertragen ...
                    var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
                    var nLastPos	    = getsize(Projectlist, "") - 1;

                    for (i = 0; i <= nLastPos; ++i)
                    {
                        Source = Projectlist + "[" + i + "]";

                        strProductArea  = getstring("PRODUCT_AREA", Source);
                        strSAPcheck     = getstring("SAP_CHECK", Source);
                        if (((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP")) &&
                            (strSAPcheck == "true"))
                        {
                            setstring("SAP_ORDER_TRANSMITTED", Source, "true")
                        }
                    }
                }
            }
        }
		
        if (strSuccessMessage != "")
            response.message = strSuccessMessage + response.message;
        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    startKundenauftragFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 0;

        var ret = this.startKundenauftrag(response, bTestfall);

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    addFreiePositionToKundenauftrag : function(Target, strOutFile,
                                            strAngebNr,
                                            strBenutzer,
                                            strKundenNr,
                                            strProjektNr,
                                            strASNr,
                                            strSprache,
                                            strKPoenale,
                                            strKRuestk,
                                            strKAkkred,
                                            strKEAbnahme,
                                            strPosNr,
                                            strQTY,
                                            strKDMAT,
                                            strPrice,
                                            strPrAbnE,
                                            strPrAbnI,
											strWaehrungskuerzel)
    {
		var nRohmasspos = 0;
		if ((atoi(getstring("CA.FORMS.SONDERTEIL.LAENGE", Target)) > 0) ||
			(atoi(getstring("CA.FORMS.SONDERTEIL.BREITE", Target)) > 0))
			nRohmasspos = 1;
		var nObflSchutz = 0;
		if (nRohmasspos && (getstring("FP.IDC_ROHMASSPOS", Target) == "1"))
			nObflSchutz = 1;

        // var strLKMatNr  = getstring("IDENT", Target);
		var strLKMatNr  = trimleft(trimright(getstring("IDENT", Target), " "), " ");
        var strTYP      = "FREI";	
		if (nRohmasspos)
		{
			strLKMatNr  = "995067";	// Neue Konzept -schm- 04/2009 
			strTYP      = "LK1_PR_BL";
			// strLKMatNr  = "612839";	// Neue Konzept -schm- 04/2009 
			// strTYP      = "LK1_SG_SH";
		}
        var strWeight   = getstring("FP.GEWICHT", Target);
        var strMarkierung = getstring("FP.MARKIERUNG", Target);
        strMarkierung   = trimleft(strMarkierung, " ");
        strMarkierung   = stringToSAP(replaceSpecialChars(strMarkierung, {FuerCSV : 1, FuerDateiname : 0}));
		var strZMarkierung = getstring("FP.ZMARKIERUNG", Target);
        strZMarkierung   = trimleft(strZMarkierung, " ");
        strZMarkierung   = stringToSAP(replaceSpecialChars(strZMarkierung, {FuerCSV : 1, FuerDateiname : 0}));
		var strZeichnungsnummer = getstring("FP.ZEICHNUNGSNR", Target);
        strZeichnungsnummer   = trimleft(strZeichnungsnummer, " ");
        strZeichnungsnummer   = stringToSAP(replaceSpecialChars(strZeichnungsnummer, {FuerCSV : 1, FuerDateiname : 0}));


        var strKZKDE   = " ";   // Blank oder X, wenn Sonderabwicklung!
        if ((strMarkierung != "") && ! nRohmasspos)	// 25.5.09 Schubert / Schm.: Bei Rohmasspos kein KDE-Kenner
            strKZKDE   = "X";

        var strText = getstring("FP.FREI_TYP", Target);
        strText     = replaceSpecialChars(strText,   {FuerCSV : 1, FuerDateiname : 0});
        delete("TEMP.TEXTANALYSE_WORK", "");
		var nAnzRows = stringtoarray(strText, "TEMP.TEXTANALYSE_WORK", "\n");

		// 2008-07-01 Positionstext, fr freie Pos derzeit nicht relevant
		// 2009-03-18: Hier soll die 1. Zeile der Textbeschrebung stehen
        var strARKTX = ""; 
		//if (nAnzRows > 0)
		// 2018-11-20: Nicht die 1. Zeile bergeben - SAP-Text der eindeutigen Mat.-Nr. verwenden
		if ((nAnzRows > 0) && (nRohmasspos))
			strARKTX = stringToSAP(replaceSpecialChars(getstring("VALUE", arraypath("TEMP.TEXTANALYSE_WORK",0))));
		
        var strAbsagegrund = "  ";

        var strLPrio   = "  ";
        if (strMarkierung != "")
            strLPrio   = "99";

        // Kopfdatensatz AP fr die Position:
        writefile(strOutFile, "AP;FL;"+strAngebNr+";"+strPosNr+";"+strLKMatNr+";"+strKDMAT+";"+strTYP+";ST;"+strQTY+";KG;"+strWeight+";"+strWaehrungskuerzel+";"+strPrice+";;;"+strPrAbnE+";"+strPrAbnI+";"+strKPoenale+";"+strKRuestk+";"+strKAkkred+";"+strKEAbnahme+";"+strKZKDE+";"+strARKTX+";"+strMarkierung+";"+strAbsagegrund+";"+strLPrio+" \r\n", "a");	// append

        // Satzart VP fr konfigurierbare Merkmale der Lastkette / eines Einzelprodukts:
        // In diesem Fall (keine konf. Merkmale) wenigstens einen leeren Datensatz ausgeben,
        // sonst strzt der RFC ab.
		// Fr Rohmasspositionen mssen hier auch de 3 Merkmale gefllt werden ... allerdings kann es hier nur max 1 Fertigungsverfahren
		// geben, da ja nur eine Position
		if (nRohmasspos)
		{
			var strObflCode = getstring("FP.IDC_OBFLSCHUTZ_COMBO", Target);
			// getstring("CA.FORMS.SONDERTEIL.GEWICHT", Target);
			var strStahlbau = getstring("CA.FORMS.SONDERTEIL.STAHLBAU", Target);
			
			if (nObflSchutz)
			{
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";OBERFL_STAHLB;1;"+Oberflaechenschutz[strObflCode]+";  \r\n", "a");	// append
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";GEWICHT_STAHLB;1;"+strWeight+";KG;  \r\n", "a");	// append
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";STAHLBAU;1;"+strStahlbau+";  \r\n", "a");	// append
			}
			else if (strStahlbau != "")
			{
				// Achtung: keine Laufende Nummer der Zeilen .... immer 1!
				//	writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+"; OBERFL_STAHLB ;01; OHNE ;  \r\n", "a");	// append
				//writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+"; EINBAUMASS ;1; 0; MM;  \r\n", "a");	// append
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";GEWICHT_STAHLB;1;"+strWeight+";KG;  \r\n", "a");	// append
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";STAHLBAU;1;"+strStahlbau+";  \r\n", "a");	// append
			}
			else
			{
				writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+";GEWICHT_STAHLB;1;"+strWeight+";KG;  \r\n", "a");	// append
			}
		}
		else
			writefile(strOutFile, "VP;FL;"+strAngebNr+";"+strPosNr+"; ;01; ;  \r\n", "a");	// append

        setlanguage("DE");
        this.addFreieTexteZuKundenauftrag("0001", Target, strOutFile, strAngebNr, strPosNr, "DE", strMarkierung, strZeichnungsnummer, strZMarkierung, nAnzRows);
        setlanguage("EN");
        this.addFreieTexteZuKundenauftrag("0001", Target, strOutFile, strAngebNr, strPosNr, "EN", strMarkierung, strZeichnungsnummer, strZMarkierung, nAnzRows);
    },

    addFreieTexteZuKundenauftrag : function(strTextTyp, Target, strOutFile, strAngebNr, strPosNr, strSprache, strMarkierung, strZeichnungsnummer, strZMarkierung, nAnzRows)
    {
        var i, nZeilenNr = 1, nZeilenNrZ011 = 1, nZeilenNr0006 = 1;
        var strZeile = "";
		
		for(i = 0; i < nAnzRows; i++)
		{
			strZeile = getstring("VALUE", arraypath("TEMP.TEXTANALYSE_WORK",i));
			if(strZeile == "")
				continue;

            nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(strZeile));
        }
        // Eine Leerzeile muss mindestens in die Texttabelle rein:
        nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, "");

        if (strMarkierung != "")
        {
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ARTIKELBEZ")) + ": ");
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(strMarkierung, " "), " ")));
			if (strSprache == "DE")
			{
			    nZeilenNrZ011 = this.addTextZeileZuKundenauftrag("Z011", 1, strOutFile, strAngebNr, strPosNr, "DE", stringToSAP("Achtung: Markierung!"));
				nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ARTIKELBEZ") + ": "));
				nZeilenNr0006 = this.addTextZeileZuKundenauftrag("0006", nZeilenNr0006, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(strMarkierung, " "), " ")));
			}
        }
		if (strZMarkierung != "")
        {
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("EXTRAMARKIERUNG")) + ": ");
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(strZMarkierung, " "), " ")));
		}
		if (strZeichnungsnummer != "")
        {
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(translate("ZEICHNUNGS_NR")) + ": ");
			nZeilenNr = this.addTextZeileZuKundenauftrag(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, stringToSAP(trimleft(trimright(strZeichnungsnummer, " "), " ")));
		}
    },
	
	/*
    addTextZeileZuKundenauftrag : function(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, strText)
    {
        writefile(strOutFile, "VT;FL;"+strAngebNr+";"+strPosNr+";"+strTextTyp+";"+strSprache+";"+nZeilenNr+";"+strText+" \r\n", "a");	// append
        return nZeilenNr + 1;
    },
	*/
	
	addTextZeileZuKundenauftrag : function(strTextTyp, nZeilenNr, strOutFile, strAngebNr, strPosNr, strSprache, strText)
    {
        /* SAP bricht nach 70 Zeichen je Zeile ab -> Zeilenaufteileung!!! */
		// wir gehen auf 68 Zeichen
		var maxLineLength	= 68;
		// Achtung, hier knnen gewollte Zeilenumbrche drin sein!!!
		var TotalText	= strText.split("\n");
		var TotalLines	= [];
		for (var a = 0; a < TotalText.length; a++){
			if (TotalText[a].length <= maxLineLength)
				TotalLines.push(TotalText[a]);
			else{	// die Zeile ist zu lang und muss aufgeteilt werden
				var Lines		= Math.floor(TotalText[a].length / maxLineLength) + 1;
				var FillUp		= Lines * maxLineLength - TotalText[a].length;
				for (var b = 0; b < FillUp; b++){
					TotalText[a]	+= " ";
				}
				for (b = 0; b < Lines; b++){
					TotalLines.push(right(left(TotalText[a], (b + 1) * maxLineLength), maxLineLength));
				}
			}
		}
		for (a = 0; a<TotalLines.length; a++){
			strText	= TotalLines[a];
			writefile(strOutFile, "VT;FL;"+strAngebNr+";"+strPosNr+";"+strTextTyp+";"+strSprache+";"+nZeilenNr+";"+strText+" \r\n", "a");	// append
			nZeilenNr++;
		}
		return nZeilenNr;
    },

    startKundenauftrag : function(response, bTestfall)
    {
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";

        var strError = this.checkCompleteBasisdaten();
        if (strError != "")
        {
            response.message = strError;
            return -1;
        }
			logtrace("---------------------------------------------------------\n");
			logtrace("Starte RFC Kundenauftrag\n");

        // Sprache umstellen auf Sprache Kommunikation
        var strAktuelleSprache = getlanguage();
        var strSpracheKommunikation = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS");
        setlanguage(strSpracheKommunikation);

        var dataDir     = this.getDataDir();
        var oDate       = this.getDateObject();
        var strRand     = rand();

        var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
        var strBenutzer  = getstring("WI_BENUTZER",    ProjectSettings);  // --->  belegen aus VIS
        if (strBenutzer == "")
            strBenutzer  = "xx";
        var strKundenNr  = getstring("WI_KDNR",        ProjectSettings);  // --->  belegen aus VIS
        var strProjektNr = getstring("WI_PROJEKTNR",   ProjectSettings);  // --->  belegen aus VIS
        var strASNr      = getstring("WI_ASNR",        ProjectSettings);  // --->  belegen aus VIS

        strAngebNr   = replaceSpecialChars(strAngebNr,   {FuerCSV : 1, FuerDateiname : 0});
        strBenutzer  = replaceSpecialChars(strBenutzer,  {FuerCSV : 1, FuerDateiname : 0});
        strKundenNr  = replaceSpecialChars(strKundenNr,  {FuerCSV : 1, FuerDateiname : 0});
        strProjektNr = replaceSpecialChars(strProjektNr, {FuerCSV : 1, FuerDateiname : 0});
        strASNr      = replaceSpecialChars(strASNr,      {FuerCSV : 1, FuerDateiname : 0});

        // Achtung Sonderfall:
        // Projektnr und ASNr mssen mit fhrenden Nullen aufgefllt werden, wenn gegeben (Standard)
        // Sie drfen aber auch ganz leer sein, dann nicht mit Nullen auffllen
        if (strProjektNr == "")
            strProjektNr = "          ";    // Feldlnge = 10
        if (strASNr == "")
            strASNr = "          ";    // Feldlnge = 10

        var strSprache   = getstring("WI_SPRACHEKOMM", ProjectSettings);  // Sprache Ausdruck ... Texte neu generieren !!!
        if (strSprache == "CZ")
            strSprache = "CS";
        var strKPoenaleInp  = getstring("WI_POENALE",     ProjectSettings);
        var strKRuestkInp   = getstring("WI_RUESTKOSTEN", ProjectSettings);
        var strKAkkredInp   = getstring("WI_AKKREDITIV",  ProjectSettings);
        var strKEAbnahmeInp = getstring("WI_EXTABNAHME",  ProjectSettings);
        var strKPoenale  = ' ';
        var strKRuestk   = ' ';
        var strKAkkred   = ' ';
        var strKEAbnahme = ' ';
        if (strKPoenaleInp == "true")
            strKPoenale  = 'X';
        if (strKRuestkInp == "true")
            strKRuestk  = 'X';
        if (strKAkkredInp == "true")
            strKAkkred  = 'X';
        if (strKEAbnahmeInp == "true")
            strKEAbnahme  = 'X';

        var strOutFile  = dataDir + "KA_" + replaceSpecialChars(strAngebNr,   {FuerCSV : 0, FuerDateiname : 1}) + "_" + oDate.datefile + "_" + strRand + ".csv"; // "Test1_Kundenauftrag_040.csv";

        writefile(strOutFile, "// Flexperte auto generated Interface File for SAP-RFC Kundenauftrag \r\n", "wc");	// write, create

        // Den Projektbezogenen AK-Datensatz bereits hier schreiben:
        writefile(strOutFile, "AK;FL;"+strAngebNr+";"+strBenutzer+";"+strKundenNr+";"+strProjektNr+";"+strASNr+";"+strSprache+" \r\n", "a");	// append

        // Iteriere ber die Projektlistenpositionen
        // Bearbeitet werden nur die bei denen SAP angekreuzt ist und die
        // auch tatschlich RH / Cascade-Positionen sind
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strPosNr, strQTY, strKDMAT, strPrice, strPrAbnE, strPrAbnI;
        var i, nTransferCount = 0;

		// Whrungsumrechnung:
		var strWaehrungskuerzel = getstring("CURRENCY_UNIT", "PROJECT.SETTINGS.WUR"); 	// "CZK";
		var strWaehrungsfaktor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR");  // 27.584;	// 1 EUR = xx Fremdwhrung
		var dWaehrungsfaktor = replace(strWaehrungsfaktor, ",", ".") - 0;				// 1 EUR = xx Fremdwhrung
		if (strWaehrungskuerzel == "")
			strWaehrungskuerzel = "EUR";
		if ((dCurrencyFactor < 0.01) || (strWaehrungskuerzel == "EUR"))
			dCurrencyFactor = 1.0;
		
        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            // Prfe SAP-Checkbox + Produktbereich!
            // das Zeug liegt direkt unter DLGDATA ... @@@@ es gibt im C-Code auch Stellen, die es unter PRODUCT.POSDATA. vermuten (recalc-Prices gibt es 2 mal!!!) !!!

            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strQTY          = getstring("QTY", Source);
            strKDMAT        = getstring("CUSTOMER_CODE", Source);
            strPosNr        = getstring("POS", Source);

            strKDMAT   = replaceSpecialChars(strKDMAT,   {FuerCSV : 1, FuerDateiname : 0});

            // Achtung Sonderfall:
            // Wenn PosNr einen Buchstaben enthlt, dann soll sie als Text (d.h. hinten mit Blanks aufgefllt) bergeben werden
            if ((find(strPosNr, "a") >= 0) || (find(strPosNr, "A") >= 0))
            {
				while(strPosNr.length < 6)
                    strPosNr += " ";
            }

            var dUnitprice       = getdouble("DUNITPRICE", 	            Source); // Stckpreis OHNE Prfung, Abnahme
            var fUnitprice       = getstring("FORCEDUNITPRICE",         Source); // Vom VB festgesetzter Stueckpreis, als STRING, kann in Projektliste gendert werden
            var dIntAccCalcprice = getdouble("INT_ACCEPT_CALC_PRICE", 	Source); // Prfung, Abnahme wenn bei WI, berechnete Kosten
            var dExtAccCalcprice = getdouble("EXT_ACCEPT_CALC_PRICE", 	Source); // Prfung, Abnahme extern, berechnete Kosten
            var fIntAccSetprice  = getstring("INT_ACCEPT_SET_PRICE",    Source); // Vom VB festgesetzter Kosten, als STRING, kann in Projektliste gendert werden
            var fExtAccSetprice  = getstring("EXT_ACCEPT_SET_PRICE",    Source); // Vom VB festgesetzter Kosten, als STRING, kann in Projektliste gendert werden

            fUnitprice      = replace (fUnitprice, ",", ".");
            fIntAccSetprice = replace (fIntAccSetprice, ",", ".");
            fExtAccSetprice = replace (fExtAccSetprice, ",", ".");

			// Whrungsumrechnung Achtung: Vorgabepreise in Echt nicht umrechnen!

            if (inputStringToDouble(fUnitprice) > 0)
                strPrice    = fUnitprice;
            else
                strPrice    = fround(dWaehrungsfaktor * dUnitprice, 2);

            if (inputStringToDouble(fIntAccSetprice) > 0)
                strPrAbnI    = fIntAccSetprice;
            else
                strPrAbnI    = fround(dWaehrungsfaktor * dIntAccCalcprice, 2);
            if (strPrAbnI <= 0)
                strPrAbnI = "";

            if (inputStringToDouble(fExtAccSetprice) > 0)
                strPrAbnE    = fExtAccSetprice;
            else
                strPrAbnE    = fround(dWaehrungsfaktor * dExtAccCalcprice, 2);
            if (strPrAbnE <= 0)
                strPrAbnE = "";
			
			/*
			strPrice = fround(dWaehrungsfaktor * strPrice, 2);		// @@@ Wenn Nachkommastellen auch Whrungsabhngig -> Wie kommt SAP damit klar?
			strPrAbnI = fround(dWaehrungsfaktor * strPrAbnI, 2);
			strPrAbnE = fround(dWaehrungsfaktor * strPrAbnE, 2);			
			*/
            if (((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;
                delete(Target, "");
                copy(Source, Target);

                if (strProductArea == "FP")
                {
                    this.addFreiePositionToKundenauftrag(Target, strOutFile,
                                                                    strAngebNr,
                                                                    strBenutzer,
                                                                    strKundenNr,
                                                                    strProjektNr,
                                                                    strASNr,
                                                                    strSprache,
                                                                    strKPoenale,
                                                                    strKRuestk,
                                                                    strKAkkred,
                                                                    strKEAbnahme,
                                                                    strPosNr,
                                                                    strQTY,
                                                                    strKDMAT,
                                                                    strPrice,
                                                                    strPrAbnE,
                                                                    strPrAbnI,
																	strWaehrungskuerzel
                                                                    );
                }
                else
                {
                    // Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
                    tmpCaMainController = new CaController();
                    caMainController = tmpCaMainController;  // just  to be sure ...

                    tmpCaMainController.addPositionToKundenauftrag(strOutFile,
                                                                    strAngebNr,
                                                                    strBenutzer,
                                                                    strKundenNr,
                                                                    strProjektNr,
                                                                    strASNr,
                                                                    strSprache,
                                                                    strKPoenale,
                                                                    strKRuestk,
                                                                    strKAkkred,
                                                                    strKEAbnahme,
                                                                    strPosNr,
                                                                    strQTY,
                                                                    strKDMAT,
                                                                    strPrice,
                                                                    strPrAbnE,
                                                                    strPrAbnI,
																	strWaehrungskuerzel
                                                                    );
                }
            }
        }

        setlanguage(strAktuelleSprache);

        var ret = this.startPlugin(nTransferCount, "KDAUFTRAG", strOutFile, dataDir, response, bTestfall);

			logtrace("Ende RFC Kundenauftrag\n");
			logtrace("---------------------------------------------------------\n");
        return ret;
    },


	startKundenauftragPlugin : function(strCSVfile, dataDir, response, connectString)
	{
			logtrace("Initialisiere Plugin RFC Kundenauftrag\n");

        var rfc = new SAP_RFC( "catalog/plugin/sap/eksaprfc_plugin.dll", "eksaprfc_connect");
        var ret = 1;

        // Einlesen aus Standard-SAP-Format:
        // var tabVT = rfc.tableReader( dataDir + "ZKP_VT_02.txt", descZKP_SVT);

        // Einlesen aus CSV-Format, das mehrere Tabellen enthlt:
        var tabAK = rfc.tableReaderCSV( strCSVfile, descZKP_SAK, "AK");
        var tabAP = rfc.tableReaderCSV( strCSVfile, descZKP_SAP, "AP");
        var tabVP = rfc.tableReaderCSV( strCSVfile, descZKP_SVP, "VP");
        var tabVT = rfc.tableReaderCSV( strCSVfile, descZKP_SVT, "VT");

        if ((tabAK.length <= 0) || (tabAP.length <= 0) || (tabVP.length <= 0) || (tabVT.length <= 0) ||
            !tabAK || !tabAP || !tabVP || !tabVT)
        {
				logtrace("Eine der bergabetabellen ist leer -> Abbruch \n");
            response.message = translate("MSG_ERR_SAP_TABLES");
            // gibts nicht in dr Klasse rfc.cleanUp();
            return -1;
        }

        // Rausschreiben im SAP-Format in mehrere Tabellen:
        rfc.tableWriter(dataDir + "ZKP_AK_02.txt", descZKP_SAK, tabAK);
        rfc.tableWriter(dataDir + "ZKP_AP_02.txt", descZKP_SAP, tabAP);
        rfc.tableWriter(dataDir + "ZKP_VP_02.txt", descZKP_SVP, tabVP);
        rfc.tableWriter(dataDir + "ZKP_VT_02.txt", descZKP_SVT, tabVT);

		// Script Tabelle -> JSON Notation
		// writefile(dataDir + "ZKP_VT_02.json.dump", tabVT.toJSON(), "wt");
		// rfc.tableWriter(dataDir + "ZKP_VT_02.txt.dump", descZKP_SVT, tabVT);

		// SAP - Tests
		var plugin = rfc.getPlugin();	// PlugIn Interface
		var rv;							// result value

        // var connectString = getstring( "CATALOG.SAP.CONNECTSTRING", "" );
        // if (connectString == "")
        //    connectString = "client=100 user=plansoft passwd=plansoft lang=de ashost=aswi01.wi.witzenmann.com sysnr=01";
		rv = plugin.open(connectString);
			logtrace("Plugin Open returns:"+rv+"\n");
        // hier kommt 0 zurck, wennkeine Verbindung da ... prfen was rauskommt, wenn Verbindung da ist!

		rv = plugin.initFunctionCall("Z_KP_SD_RFC");
			logtrace("Plugin initFunctionCall returns:"+rv+"\n");

		rv = plugin.addImportParam("EF_ERROR", " ", 1);
			logtrace("Plugin addImportParam returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_AK", -1, dataDir + "ZKP_AK_02.txt");
			logtrace("Plugin addExportTableFile IT_AK returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_AP", -1, dataDir + "ZKP_AP_02.txt");
			logtrace("Plugin addExportTableFile IT_AP returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_VP", -1, dataDir + "ZKP_VP_02.txt");
			logtrace("Plugin addExportTableFile IT_VP returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_VT", -1, dataDir + "ZKP_VT_02.txt");
			logtrace("Plugin addExportTableFile IT_VT returns:"+rv+"\n");

		var tabWidth = rfc.GetTableWidth(descBAPIRET2);
		rv = plugin.addImportTableFile("ET_RET", tabWidth, dataDir +  "ET_RET.txt");
			logtrace("Plugin addImportTableFile ET_RET returns:"+rv+"\n");
        ret = this.plugInExecAndCheck(rfc, plugin, dataDir, response);
			logtrace("Starte cleanUp\n");
		// gibts nicht in dr Klasse rfc.cleanUp();
			logtrace("Starte plugin.close\n");
		plugin.close();
			logtrace("Ende plugin.close\n");
		plugin = null;

        return ret;
    },

    startAuftragsstuecklisteFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 0;

        // Hier vor Aufruf von startAuftragsstueckliste testen;
        // Testen in dieser Methode wrde dazu fhren, dass der Test
        // bei Komplettbergabe 2 mal gemacht wird und das wre sehr zeitaufwndig
        var strError = this.checkCompleteAuftragsstueckliste();
        if (strError == "")
            var ret = this.startAuftragsstueckliste(response, bTestfall);
        else
            response.message = strError;

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    startAuftragsstueckliste : function(response, bTestfall)
    {
        var strError = this.checkCompleteBasisdaten();
        if (strError != "")
        {
            response.message = strError;
            return -1;
        }
			logtrace("---------------------------------------------------------\n");
			logtrace("Starte RFC Auftragsstckliste\n");

        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";

        var dataDir     = this.getDataDir();
        var oDate       = this.getDateObject();
        var strRand     = rand();
        var strAngebNr  = getstring("WI_ANGEBOTSNR", ProjectSettings);
        strAngebNr   = replaceSpecialChars(strAngebNr,   {FuerCSV : 1, FuerDateiname : 0});

        var strOutFile  = dataDir + "AS_" + replaceSpecialChars(strAngebNr,   {FuerCSV : 0, FuerDateiname : 1}) + "_" + oDate.datefile + "_" + strRand + ".csv";

        writefile(strOutFile, "// Flexperte auto generated Interface File for SAP-RFC Auftragsstckliste \r\n", "wc");	// write, create

        // Fr die Auftragsstckliste gibt es keinen projektbezogenen Datensatz

        // Iteriere ber die Projektlistenpositionen
        // Bearbeitet werden nur die bei denen SAP angekreuzt ist und die
        // auch tatschlich RH / Cascade-Positionen sind
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strPosNr, strQTY;
        var i, nTransferCount = 0, nSAPcheckCount = 0;
        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            // Prfe SAP-Checkbox + Produktbereich!
            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strQTY          = getstring("QTY", Source);
            strPosNr        = getstring("POS", Source);
            // Achtung Sonderfall:
            // Wenn PosNr einen Buchstaben enthlt, dann soll sie als Text (d.h. hinten mit Blanks aufgefllt) bergeben werden
            if ((find(strPosNr, "a") >= 0) || (find(strPosNr, "A") >= 0))
            {
				while(strPosNr.length < 6)
                    strPosNr += " ";
            }

            if (((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;
                nSAPcheckCount++;
                delete(Target, "");
                copy(Source, Target);

                if (strProductArea == "FP")
                {
					if (this.addFreiePositionToAuftragsStkListe(Target, strOutFile,
																	strAngebNr,
																	strPosNr,
																	strQTY,
																	oDate.datesap
																	) <= 0)
						nTransferCount--;
				}
				else
				{
					// Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
					tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher
					caMainController = tmpCaMainController;  // just  to be sure ...

					var oRet = tmpCaMainController.addPositionToAuftragsStkListe(strOutFile,
																	strAngebNr,
																	strPosNr,
																	strQTY,
																	oDate.datesap
																	);
					if (oRet.transferCount <= 0)
						nTransferCount--;
				}
            }
        }

        var ret = 1;
        // Sonderfall, dass fr einzelne Teile gar keine ASTL bertragen werden muss
        if (nTransferCount > 0)
            ret = this.startPlugin(nSAPcheckCount, "AUFTRSTKLIST", strOutFile, dataDir, response, bTestfall);
        else
            response.message = translate("MSG_SAP_NO_TRANSFER_NEEDED");

			logtrace("Ende RFC Auftragsstckliste\n");
			logtrace("---------------------------------------------------------\n");
        return ret;
    },

	addFreiePositionToAuftragsStkListe : function(Target, strOutFile,
                                                strAngebNr,
                                                strPosNr,
                                                strQTY,
                                                strDateSAP
                                                )
    {
		var strLKMatNr  = "995067";
		// var strLKMatNr  = "612839";

        var strMarkierung = getstring("FP.MARKIERUNG", Target);
		// Achtung: Daten des Assi stehen unter CA, der Rest unter FP!!!
		var strLaenge = getstring("CA.FORMS.ASSISTENT_SONDERTEIL.LAENGE", Target);
		var strBreite = getstring("CA.FORMS.ASSISTENT_SONDERTEIL.BREITE", Target);
		strLaenge = trimleft(strLaenge, " ");
		strBreite = trimleft(strBreite, " ");

		var strEINGABEART_STKL = getstring("FP.FP_ASSI_GROUP", Target);
		if (strEINGABEART_STKL != "IDC_FP_ASSI")
			return -1;

		if ((strLaenge == "") && (strBreite == ""))		// Nur Rohmasspositionen bertragen
			return -1;

        // -mw- 6.6.2008 nach Info -schm-: Stckzahl hier immer 1, da es sich um die Bemessungsmenge der Stckliste handelt.
        writefile(strOutFile, "ASTL-KOPF;"+strAngebNr+";"+strPosNr+";FL;"+strLKMatNr+";"+strDateSAP+";1 \r\n", "a");	// append

		
		var i = 0;
		var nKompAnz = 1;	// Auch 1, das hier ist die Stckliste fr ein Teil der KD-Auftragsposition
		var postyp = "R";	// wir duerfen hier nur Rohmasspositionen rausschreiben
		var matnr = getstring("IDENT", Target);
		var postext1 = "";
		var postext2 = "";
		var rm1 = "", rm2 = "", rm3 = "", rm_einheit = "MM";
		var formelzeichen = "L1";		// L1 = Lnge oder F1 (bei Flche)
		var aufloesungssteuerung = "";
		if ((strLaenge != "") && (strBreite != ""))
		{
			rm1 = strLaenge;
			rm2 = strBreite;
			formelzeichen = "F1";
		}
		else if (strLaenge != "")
			rm1 = strLaenge;
		else
			rm1 = strBreite;

        var strText = getstring("FP.FREI_TYP", Target);
        strText     = replaceSpecialChars(strText,   {FuerCSV : 1, FuerDateiname : 0});
        delete("TEMP.TEXTANALYSE_WORK", "");
		var nAnzRows = stringtoarray(strText, "TEMP.TEXTANALYSE_WORK", "\n");

		postext1 = stringToSAP(replaceSpecialChars(getstring("VALUE", arraypath("TEMP.TEXTANALYSE_WORK",0))));
		
        writefile(strOutFile, "ASTL-POS;"+strAngebNr+";"+strPosNr+";FL;"+strLKMatNr+";"+(i+1)+";"+(i+1)+";"+postyp+";"+matnr+";"+nKompAnz+";ST;;"+postext1+";"+postext2+";"+rm1+";"+rm_einheit+";"+rm2+";"+rm3+";"+formelzeichen+";"+aufloesungssteuerung+" \r\n", "a");	// append
		return 1;
	},
	
	startAuftragsstuecklistePlugin : function(strCSVfile, dataDir, response, connectString)
	{
			logtrace("Initialisiere Plugin RFC Auftragsstckliste\n");
		// SAP-RFC Instanz erzeugen
		var rfc = new SAP_RFC( "catalog/plugin/sap/eksaprfc_plugin.dll", "eksaprfc_connect");
        var ret = 1;

		// Script Tabelle -> JSON Notation
		// var tabASTP = rfc.tableReader(dataDir + "ZKP_ASTP.txt", descZKP_SASTP);
		// writefile(dataDir + "ZKP_ASTP.json.dump", tabASTP.toJSON(), "wt");
		// rfc.tableWriter(dataDir + "ZKP_ASTP.txt.dump", descZKP_SASTP, tabASTP);
        var tabASTK = rfc.tableReaderCSV( strCSVfile, descZKP_SASTK, "ASTL-KOPF");
        var tabASTP = rfc.tableReaderCSV( strCSVfile, descZKP_SASTP, "ASTL-POS");

        if ((tabASTK.length <= 0) || (tabASTP.length <= 0) ||
            !tabASTK || !tabASTP)
        {
				logtrace("Eine der bergabetabellen ist leer -> Abbruch \n");
            response.message = "Some interface tables are empty!";
            // gibts nicht in dr Klasse rfc.cleanUp();
            return -1;
        }

		rfc.tableWriter(dataDir + "ZKP_ASTK.txt", descZKP_SASTK, tabASTK);
		rfc.tableWriter(dataDir + "ZKP_ASTP.txt", descZKP_SASTP, tabASTP);

		// SAP - Test's
		var plugin = rfc.getPlugin();	// PlugIn Interface
		var rv;							// result value

        //var connectString = getstring( "CATALOG.SAP.CONNECTSTRING", "" );
        //if (connectString == "")
        //    connectString = "client=100 user=plansoft passwd=plansoft lang=de ashost=aswi01.wi.witzenmann.com sysnr=01";
		rv = plugin.open(connectString);
			logtrace("Plugin Open returns:"+rv+"\n");
		rv = plugin.initFunctionCall("Z_KP_ASTL_RFC");
			logtrace("Plugin initFunctionCall returns:"+rv+"\n");
		rv = plugin.addImportParam("EF_ERROR", " ", 1);
			logtrace("Plugin addImportParam returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_ASTK", -1, dataDir + "ZKP_ASTK.txt");
			logtrace("Plugin addExportTableFile IT_ASTK returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_ASTP", -1, dataDir + "ZKP_ASTP.txt");
			logtrace("Plugin addExportTableFile IT_ASTP returns:"+rv+"\n");

		var tabWidth = rfc.GetTableWidth(descBAPIRET2);
		rv = plugin.addImportTableFile("ET_RET", tabWidth, dataDir +  "ET_RET.txt");
			logtrace("Plugin addImportTableFile ET_RET returns:"+rv+"\n");

        ret = this.plugInExecAndCheck(rfc, plugin, dataDir, response);

			logtrace("Starte cleanUp\n");
		// gibts nicht in dr Klasse rfc.cleanUp();
			logtrace("Starte plugin.close\n");
		plugin.close();
			logtrace("Ende plugin.close\n");
		plugin = null;

        return ret;
    },

    startZeichnungsuebergabeFromProjectlistAction : function()
    {
        var response = {
            success : true,
            message : ''
        };
        var bTestfall = 0;

        var ret = this.startZeichnungsuebergabe(response, bTestfall);

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    startZeichnungsuebergabe : function(response, bTestfall)
    {
        var strError = this.checkCompleteBasisdaten();
        if (strError == "")
            strError = this.checkCompleteZeichnungsdaten();
        if (strError != "")
        {
            response.message = strError;
            return -1;
        }

        logtrace("---------------------------------------------------------\n");
        logtrace("Starte RFC Zeichnungsuebergabe\n");

        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var ProjectSettings = "PROJECT.SETTINGS";

        var dataDir     = this.getDataDir();
        var oDate       = this.getDateObject();
        var strRand     = rand();
        var strAngebNr  = getstring("WI_ANGEBOTSNR", ProjectSettings);
        strAngebNr   = replaceSpecialChars(strAngebNr,   {FuerCSV : 1, FuerDateiname : 0});

        var strWerk     = "1115";   // WERKS = 1115   fr Werdau  (1000 ist Pforzheim)
        var strOutFile  = dataDir + "ZG_" + replaceSpecialChars(strAngebNr,   {FuerCSV : 0, FuerDateiname : 1}) + "_" + oDate.datefile + "_" + strRand + ".csv";

        writefile(strOutFile, "// Flexperte auto generated Interface File for SAP-RFC Zeichnungsbergabe \r\n", "wc");	// write, create

        // Fr die Auftragsstckliste gibt es keinen projektbezogenen Datensatz

        // Iteriere ber die Projektlistenpositionen
        // Bearbeitet werden nur die bei denen SAP angekreuzt ist und die
        // auch tatschlich RH / Cascade-Positionen sind
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strPosNr, strQTY, strCachePdf, strCacheDxf;
        var i, nTransferCount = 0, nSAPcheckCount = 0;
        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";

            // Prfe SAP-Checkbox + Produktbereich!
            strProductArea  = getstring("PRODUCT_AREA", Source);
            strSAPcheck     = getstring("SAP_CHECK", Source);
            strQTY          = getstring("QTY", Source);
            strPosNr        = getstring("POS", Source);
            strCachePdf     = getstring("CACHE_DRAWING_FILE_PDF_SAP", Source);
            strCacheDxf     = getstring("CACHE_DRAWING_FILE_DXF", Source);

            strCachePdf = right(strCachePdf, strCachePdf.length - rfind(strCachePdf, "\\"));

            // Achtung Sonderfall:
            // Wenn PosNr einen Buchstaben enthlt, dann soll sie als Text (d.h. hinten mit Blanks aufgefllt) bergeben werden
            if ((find(strPosNr, "a") >= 0) || (find(strPosNr, "A") >= 0))
            {
				while(strPosNr.length < 6)
                    strPosNr += " ";
            }

            // Test:
            // writefile(strOutFile, "ZG-PPD;ZN;123;10;FL;600546;;;PDF;abc.pdf;bez;A3 \r\n", "a");	// append

            if (((strProductArea == "RH") || (strProductArea == "CA")) &&
                (strSAPcheck == "true"))
            {
                nTransferCount++;
                nSAPcheckCount++;
                delete(Target, "");
                copy(Source, Target);

                // Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
                tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher
                caMainController = tmpCaMainController;  // just  to be sure ...

                if (caMainController.getNichtKonfigurierbaresEinzelprodukt())
                {
                    nTransferCount--;
                }
                else
                {
                    var LKMatInfo   = tmpCaMainController.topologieKlasse.getLastkettenIdent(tmpCaMainController);
                    var strMatnr    = LKMatInfo.matnr;
                    var strBez      = strMatnr;
                    if (LKMatInfo.aTexte[0])
                        strBez = strMatnr + " FL " + stringToSAP(left(LKMatInfo.aTexte[0], 25));

                    writefile(strOutFile, "ZNG;"+strAngebNr+";"+strPosNr+";FL;"+strMatnr+";"+strWerk+";;PDF;"+strCachePdf+";"+strBez+";A4 \r\n", "a");	// append
                }
            }
        }

        var ret = 1;
        // Sonderfall, dass fr einzelne Teile gar keine ASTL bertragen werden muss
        if (nTransferCount > 0)
            ret = this.startPlugin(nSAPcheckCount, "ZGUEBERGABE", strOutFile, dataDir, response, bTestfall);
        else
            response.message = translate("MSG_SAP_NO_TRANSFER_ZEICHNUNG_NEEDED");

			logtrace("Ende RFC Zeichnungsuebergabe\n");
			logtrace("---------------------------------------------------------\n");
        return ret;
    },

	startZeichnungsuebergabePlugin : function(strCSVfile, dataDir, response, connectString)
	{
			logtrace("Initialisiere Plugin RFC Zeichnungsuebergabe\n");
		// SAP-RFC Instanz erzeugen
		var rfc = new SAP_RFC( "catalog/plugin/sap/eksaprfc_plugin.dll", "eksaprfc_connect");
        var ret = 1;

		// Script Tabelle -> JSON Notation
		// var tabASTP = rfc.tableReader(dataDir + "ZKP_ASTP.txt", descZKP_SASTP);
		// writefile(dataDir + "ZKP_ASTP.json.dump", tabASTP.toJSON(), "wt");
		// rfc.tableWriter(dataDir + "ZKP_ASTP.txt.dump", descZKP_SASTP, tabASTP);

        // var tabZGPPD = rfc.tableReaderCSV( strCSVfile, descZKP_PPD, "ZG-PPD");
        var tabZGPPD = rfc.tableReaderCSV( strCSVfile, descZKP_PPD, "ZNG");

        if ((tabZGPPD.length <= 0) || !tabZGPPD)
        {
				logtrace("Eine der bergabetabellen ist leer -> Abbruch \n");
            response.message = translate("MSG_ERR_SAP_TABLES");
            // gibts nicht in dr Klasse rfc.cleanUp();
            return -1;
        }

		rfc.tableWriter(dataDir + "ZKP_PPD.txt", descZKP_PPD, tabZGPPD);

		// SAP - Test's
		var plugin = rfc.getPlugin();	// PlugIn Interface
		var rv;							// result value

        //var connectString = getstring( "CATALOG.SAP.CONNECTSTRING", "" );
        //if (connectString == "")
        //    connectString = "client=100 user=plansoft passwd=plansoft lang=de ashost=aswi01.wi.witzenmann.com sysnr=01";
		rv = plugin.open(connectString);
			logtrace("Plugin Open returns:"+rv+"\n");
		rv = plugin.initFunctionCall("Z_KP_PRUEFDATEI_RFC");
			logtrace("Plugin initFunctionCall returns:"+rv+"\n");
		rv = plugin.addImportParam("EF_ERROR", " ", 1);
			logtrace("Plugin addImportParam returns:"+rv+"\n");
		rv = plugin.addExportTableFile("IT_SPPD", -1, dataDir + "ZKP_PPD.txt");
			logtrace("Plugin addExportTableFile IT_SPPD returns:"+rv+"\n");

		var tabWidth = rfc.GetTableWidth(descBAPIRET2);
		rv = plugin.addImportTableFile("ET_RET", tabWidth, dataDir +  "ET_RET.txt");
			logtrace("Plugin addImportTableFile ET_RET returns:"+rv+"\n");

        ret = this.plugInExecAndCheck(rfc, plugin, dataDir, response);

			logtrace("Starte cleanUp\n");
		// gibts nicht in dr Klasse rfc.cleanUp();
			logtrace("Starte plugin.close\n");
		plugin.close();
			logtrace("Ende plugin.close\n");
		plugin = null;

        return ret;
    }

});