/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Controller 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */

 /**
 * LagerKonfigurationController constructor
 */
LagerKonfigurationController = function() 
{
	// nur an constructor der Basisklasse delegieren
	LagerKonfigurationController.superclass.constructor.call( this );
	
	// Storepfad der UI-Variablen
	this.strStorePath = "DLGDATA.CA.FORMS.LAGER_KONFIGURATION";
};

 /**
 * Klasse LagerKonfigurationController - serverseitige Kontrollerklasse fr Dialog 'Konfiguration des Lagers'
 *                                      (siehe lager_konfiguration.js)
 */
EasyKat.extend( LagerKonfigurationController, CustomController, 
{
	/**
	* action handler fr get-values action; hole die fr den Dialog 'Konfiguration des Lagers' relevanten Werte aus 
	* den Store und transferiere sie ber JSON
	*/
	getValuesAction : function() 
    {
		// Profilarten holen
		var strLagerart = caMainController.dataAccess.LagerDaten.holeLagerart();
		var oProfilarten = Cascade.Lagerkonfiguration.holeProfilarten( strLagerart );
		
		// Trgergren zu ausgewhltem oder erstem Profil der Profilarten holen
		var strProfilart = caMainController.dataAccess.LagerDaten.holeTraegerart();
		if ( !strProfilart )
			strProfilart = oProfilarten.strProfilart;
		var oTraegergroessen = Cascade.Lagerkonfiguration.holeTraegergroessen( strProfilart );
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen
		// UI-Bild fr Lager mit aktuellem Profil und Trgergre holen
		var strTraegergroesse = caMainController.dataAccess.LagerDaten.holeTraegergroesse();
		if ( !strTraegergroesse )
			strTraegergroesse = oTraegergroessen.strTraegergroesse;
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( strProfilart, strTraegergroesse, caMainController.topologieKlasse.getLager() );
		// Daten fr die Antwort zusammenstellen und weiterschicken
		var response = {
			success: true,
			data: {
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				profilarten: oProfilarten.daten,
				traegergroessen: oTraegergroessen.daten,
				strLagerTyp: translate( 'IDC_RH_TYP_LABEL' ) + ' ' + oTraegerdaten.strTyp,
				strLagerBild: oTraegerdaten.strBild,
				// diese Daten werden direkt ins UI gesetzt
				IDC_PROFILART: strProfilart,
				IDC_TRAEGERGROESSE: strTraegergroesse,
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr set-values action; 
	*/
	setValuesAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// setze gewhlte Profilart und Trgergre in aktuell gewhltes Lager und korrigiere Werte des Lagers (Typ, Preis etc.) entsprechend
		caMainController.topologieKlasse.getLager().konfiguriere( submitVars.IDC_PROFILART, submitVars.IDC_TRAEGERGROESSE );
		
		// nur damit es weitergeht
		var response = {
			success: true,
			data: { }
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeTraegergroessen action; hole die zu der aktuellen Profilart gltigen Trgergren, Trgerdaten, den Lagertyp und das Lagerbild
	*/
	holeTraegergroessenAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// Trgergren zu ausgewhltem oder erstem Profil der Profilarten holen
		var oTraegergroessen = Cascade.Lagerkonfiguration.holeTraegergroessen( submitVars.IDC_PROFILART );
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen
		// UI-Bild fr Lager mit aktuellem Profil und Trgergre holen
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( submitVars.IDC_PROFILART, oTraegergroessen.strTraegergroesse, 
		                                                                 caMainController.topologieKlasse.getLager() );
		// Daten fr die Antwort zusammenstellen und weiterschicken
		var response = {
			success: true,
			data: {
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				traegergroessen: oTraegergroessen.daten,
				strLagerTyp: translate( 'IDC_RH_TYP_LABEL' ) + ' ' + oTraegerdaten.strTyp,
				strLagerBild: oTraegerdaten.strBild,
				IDC_TRAEGERGROESSE: oTraegergroessen.strTraegergroesse,
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeTraegerdaten action; hole die zu der aktuellen Trgergre gltigen Trgerdaten, den Lagertyp und das Lagerbild
	*/
	holeTraegerdatenAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen
		// UI-Bild fr Lager mit aktuellem Profil und Trgergre holen
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( submitVars.IDC_PROFILART, submitVars.IDC_TRAEGERGROESSE, 
		                                                                 caMainController.topologieKlasse.getLager() );
		
		var response = {
			success: true,
			data: {
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				strLagerTyp: translate( 'IDC_RH_TYP_LABEL' ) + ' ' + oTraegerdaten.strTyp,
				strLagerBild: oTraegerdaten.strBild,
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke
			}
		};

		echo response.toJSON(); 
	}	
});