/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 - 2009 Plan Software GmbH
 *
 * @category Controller 
 * @package    
 * @copyright  Copyright (c) 2008 - 2009 Plan Software GmbH (http://www.plansoft.de)
 */

 /**
 * LagerHoeheneingabenController constructor
 */
LagerHoeheneingabenController = function() 
{
	// nur an constructor der Basisklasse delegieren
	LagerHoeheneingabenController.superclass.constructor.call( this );
	
	// Storepfad der UI-Variablen
	this.strStorePath = 'DLGDATA.CA.FORMS.LAGER_HOEHENEINGABEN';
};

 /**
 * Klasse LagerHoeheneingabenController - serverseitige Kontrollerklasse fr Dialog 'Zusatzeingaben fr hhenverstellbare Lager'
 *                                      (siehe lager_konfiguration.js)
 */
EasyKat.extend( LagerHoeheneingabenController, CustomController, 
{
	/**
	* action handler fr get-values action; hole die fr den Dialog 'Zusatzeingaben fr hhenverstellbare Lager' relevanten Werte aus 
	* den Store und transferiere sie ber JSON
	*/
	getValuesAction : function() 
    {
		// Hhenintervalle holen
		var oHoehen = caMainController.topologieKlasse.getLager().holeHoehendaten();
		
		// Daten fr die Antwort zusammenstellen und weiterschicken
		var response = {
			success: true,
			data: {
				// Daten werden (zur Anzeige oder zum Testen) transferiert
				strMin: oHoehen.strMin,
				strMax: oHoehen.strMax,
                strHori: oHoehen.strAct,
                strEori: oHoehen.m_Pemass,
				msgBereich: translate( 'ID_ERRORMESSAGE_HOEHENBEREICH' ),
				// diese Daten werden direkt ins UI gesetzt
				IDC_HOEHEN_ACT: oHoehen.strAct,
				IDC_HOEHEN_MINMAX: oHoehen.strMinMax,
                IDC_EMASS_MINMAX: oHoehen.strEMinMax,
                IDC_EMASS_ACT: oHoehen.m_Pemass

			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr set-values action; 
	*/
	setValuesAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// setze gewhlte Profilart und Trgergre in aktuell gewhltes Lager und korrigiere Werte des Lagers (Typ, Preis etc.) entsprechend
		caMainController.topologieKlasse.getLager().setzeHoehendaten( submitVars.IDC_HOEHEN_ACT );
		
		// nur damit es weitergeht
		var response = {
			success: true,
			data: { }
		};

		echo response.toJSON(); 
	},
	
});