/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Controller 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 

 /**
 * LagerBetriebsbedingungenController constructor
 */
LagerBetriebsbedingungenController = function() 
{
	// nur an constructor der Basisklasse delegieren
	LagerBetriebsbedingungenController.superclass.constructor.call( this );
	
	// Storepfad der UI-Variablen
	this.strStorePath = "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN";
};

 /**
 * Klasse LagerBetriebsbedingungenController - serverseitige Kontrollerklasse fr Dialog 'Lager Betriebsbedingungen'
 *                                             (siehe lager_betriebsbedingungen.js)
 */
EasyKat.extend( LagerBetriebsbedingungenController, CustomController, 
{
	/**
	* action handler fr get-values action; hole die fr den Dialog 'Betriebsbedingungen' relevanten Werte aus 
	* den Store und transferiere sie ber JSON
	*/
	getValuesAction : function() 
    {
        var strAuswahlKontext   = caMainController.topologieKlasse.getLagerAuswahlKontext();
		var strSollwHP			= "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE";
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		
		if (getstring("IDC_TEMPERATUR_TS", this.strStorePath) == "")
			var TempTS = "20";
		else
			var TempTS = getstring("IDC_TEMPERATUR_TS", this.strStorePath);
		if (getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "AUF")
			var DirStuetzricht	= "MI_";
		else
			var DirStuetzricht = "PL_";
		
		for (var i=0; i<3; i++)
		{
			switch (AchsDirInfo[i])
			{
				case 'Z':
					if ((i == 0) && (getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "AUF") ||
						(abs(inputStringToDouble(getstring("last_minus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) > abs(inputStringToDouble(getstring("last_plus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)))))
					{
						var IDC_MINUS_FZ	= abs(inputStringToDouble(getstring("last_minus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_FZ			= getstring("last_plus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					else
					{
						var IDC_FZ			= abs(inputStringToDouble(getstring("last_plus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_MINUS_FZ	= getstring("last_minus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					break;
					
				case 'Y':
					if ((i == 0) && (getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "AUF") ||
						(abs(inputStringToDouble(getstring("last_minus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) > abs(inputStringToDouble(getstring("last_plus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)))))
					{
						var IDC_MINUS_FY	= abs(inputStringToDouble(getstring("last_minus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_FY			= getstring("last_plus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					else
					{
						var IDC_FY			= abs(inputStringToDouble(getstring("last_plus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_MINUS_FY	= getstring("last_minus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					break;
					
				case 'X':
					if ((i == 0) && (getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") == "AUF") ||
						(abs(inputStringToDouble(getstring("last_minus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) > abs(inputStringToDouble(getstring("last_plus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)))))
					{
						var IDC_MINUS_FX	= abs(inputStringToDouble(getstring("last_minus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_FX			= getstring("last_plus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					else
					{
						var IDC_FX			= abs(inputStringToDouble(getstring("last_plus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP))) +
									abs(inputStringToDouble(getstring("zusatzlast[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP)));
						var IDC_MINUS_FX	= getstring("last_minus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP);
					}
					break;
			}
		}
		
		if (strAuswahlKontext != "EINZEL_LAGER")
		{
			var aDisabled	= ['IDC_WX_PLUS', 'IDC_WY_PLUS', 'IDC_WZ_PLUS', 'IDC_WX_MINUS', 'IDC_WY_MINUS', 'IDC_WZ_MINUS',
								'IDC_FX', 'IDC_MINUS_FX', 'IDC_FY', 'IDC_MINUS_FY', 'IDC_FZ', 'IDC_MINUS_FZ',
								'IDC_LAGER_ROHRM_X', 'IDC_LAGER_ROHRM_Y', 'IDC_LAGER_ROHRM_Z',
								'IDC_STUETZRICHTUNG_IST_PL_X', 'IDC_STUETZRICHTUNG_IST_MI_X',
								'IDC_STUETZRICHTUNG_IST_PL_Y', 'IDC_STUETZRICHTUNG_IST_MI_Y',
								'IDC_STUETZRICHTUNG_IST_PL_Z', 'IDC_STUETZRICHTUNG_IST_MI_Z'];
			/*
			if (getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN") != "")
				var Stuetzricht	= getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN");
			else*/
				var Stuetzricht	= DirStuetzricht + AchsDirInfo[0];
			
			var response 	= {
				success: true,
				data: {
					IDC_TEMPERATUR_TS: TempTS,
					IDC_DAEMMDICKE_LAGER: getstring("IDC_DAEMMDICKE_LAGER", this.strStorePath),
					IDC_WX_PLUS: getstring("bewegung_plus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_WY_PLUS: getstring("bewegung_plus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_WZ_PLUS: getstring("bewegung_plus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_WX_MINUS: getstring("bewegung_minus[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_WY_MINUS: getstring("bewegung_minus[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_WZ_MINUS: getstring("bewegung_minus[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_MINUS_FZ: IDC_MINUS_FZ,
					IDC_FZ: IDC_FZ,
					IDC_MINUS_FX: IDC_MINUS_FX,
					IDC_FX: IDC_FX,
					IDC_MINUS_FY: IDC_MINUS_FY,
					IDC_FY: IDC_FY,
					IDC_LAGER_ROHRM_X: getstring("einfuegepunkt[0].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_LAGER_ROHRM_Y: getstring("einfuegepunkt[1].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					IDC_STUETZRICHTUNG_IST: Stuetzricht,
					IDC_LAGER_ROHRM_Z: getstring("einfuegepunkt[2].PLAIN_ARRAY_ITEM_VALUE", strSollwHP),
					strAuswahlKontext: strAuswahlKontext
				},
				disabled: aDisabled
			};
		}
		else
		{
			var aDisabled	= [];
			var aEnabled	= [];
			
			if (getstring("IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") != "VERTIKAL")
			{
				aDisabled	= ['IDC_W' + AchsDirInfo[0] + '_PLUS', 'IDC_W' + AchsDirInfo[0] + '_MINUS',
								'IDC_STUETZRICHTUNG_IST_PL_X', 'IDC_STUETZRICHTUNG_IST_MI_X',
								'IDC_STUETZRICHTUNG_IST_PL_Y', 'IDC_STUETZRICHTUNG_IST_MI_Y',
								'IDC_STUETZRICHTUNG_IST_PL_Z', 'IDC_STUETZRICHTUNG_IST_MI_Z'];
				//setstring("IDC_W" + AchsDirInfo[0] + "_PLUS", this.strStorePath, "");
				//setstring("IDC_W" + AchsDirInfo[0] + "_MINUS", this.strStorePath, "");
			}
			else
			{
				aEnabled	= ['IDC_W' + AchsDirInfo[0] + '_PLUS', 'IDC_W' + AchsDirInfo[0] + '_MINUS',
								'IDC_STUETZRICHTUNG_IST_PL_X', 'IDC_STUETZRICHTUNG_IST_MI_X',
								'IDC_STUETZRICHTUNG_IST_PL_Y', 'IDC_STUETZRICHTUNG_IST_MI_Y',
								'IDC_STUETZRICHTUNG_IST_PL_Z', 'IDC_STUETZRICHTUNG_IST_MI_Z'];
				aDisabled	= ['IDC_STUETZRICHTUNG_IST_PL_' + AchsDirInfo[0],
								'IDC_STUETZRICHTUNG_IST_MI_' + AchsDirInfo[0]];
			}
			
			if (getstring("IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK") != "VERTIKAL")
					var Stuetzricht	= DirStuetzricht + AchsDirInfo[0];
			else if ((getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN") != "") &&
				(getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN") != ('PL_' + AchsDirInfo[0])) &&
				(getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN") != ('MI_' + AchsDirInfo[0])))
				var Stuetzricht	= getstring("IDC_STUETZRICHTUNG_IST", "DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN");
			else
				var Stuetzricht	= DirStuetzricht + AchsDirInfo[1];
			
			var response = {
				success: true,
				data: {
					IDC_TEMPERATUR_TS: TempTS,
					IDC_DAEMMDICKE_LAGER: getstring("IDC_DAEMMDICKE_LAGER", this.strStorePath),
					IDC_WX_PLUS: getstring("IDC_WX_PLUS", this.strStorePath),
					IDC_WY_PLUS: getstring("IDC_WY_PLUS", this.strStorePath),
					IDC_WZ_PLUS: getstring("IDC_WZ_PLUS", this.strStorePath),
					IDC_WX_MINUS: getstring("IDC_WX_MINUS", this.strStorePath),
					IDC_WY_MINUS: getstring("IDC_WY_MINUS", this.strStorePath),
					IDC_WZ_MINUS: getstring("IDC_WZ_MINUS", this.strStorePath),
					IDC_MINUS_FZ: getstring("IDC_MINUS_FZ", this.strStorePath),
					IDC_FZ: getstring("IDC_FZ", this.strStorePath),
					IDC_MINUS_FX: getstring("IDC_MINUS_FX", this.strStorePath),
					IDC_FX: getstring("IDC_FX", this.strStorePath),
					IDC_MINUS_FY: getstring("IDC_MINUS_FY", this.strStorePath),
					IDC_FY: getstring("IDC_FY", this.strStorePath),
					IDC_LAGER_ROHRM_X: getstring("IDC_LAGER_ROHRM_X", this.strStorePath),
					IDC_LAGER_ROHRM_Y: getstring("IDC_LAGER_ROHRM_Y", this.strStorePath),
					IDC_LAGER_ROHRM_Z: getstring("IDC_LAGER_ROHRM_Z", this.strStorePath),
					IDC_STUETZRICHTUNG_IST: (Stuetzricht),
					strAuswahlKontext: strAuswahlKontext
				},
				disabled: aDisabled,
				enabled: aEnabled
			};
		}
		
		echo response.toJSON(); 
	},
	
	/**
	* action handler fr set-values action; 
	*/
	setValuesAction : function() 
    {
		// validating actions are supplied directly on the UI (hopefully)

        var submitVars = Object.fromStorage(this.strStorePath);
        setstring( "IDC_DAEMMDICKE", this.strStorePath, submitVars.IDC_DAEMMDICKE_LAGER );
        var halt;
	}
	
});