/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Controller 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */

 /**
 * LagerAuswahlController constructor
 */
LagerAuswahlController = function() 
{
	// nur an constructor der Basisklasse delegieren
	LagerAuswahlController.superclass.constructor.call( this );
	
	// Storepfad der UI-Variablen
	this.strStorePath = "DLGDATA.CA.FORMS.LAGER_AUSWAHL";
};

 /**
 * Klasse LagerAuswahlController - serverseitige Kontrollerklasse fr Dialog 'Auswahl Lager' (siehe lager_auswahl.js)
 */
EasyKat.extend( LagerAuswahlController, CustomController, 
{
	/**
	* action handler fr get-values action; hole die fr den Dialog 'Auswahl' relevanten Werte aus 
	* den Store und transferiere sie ber JSON
	*/
	getValuesAction : function() 
    {
		// hole UI daten fr diesen Dialog
		var strLagerart = caMainController.dataAccess.LagerDaten.holeLagerart();
		var strGleitart = caMainController.dataAccess.LagerDaten.holeGleitart();
		var strIsolierung = caMainController.dataAccess.LagerDaten.holeIsolierung();
		var strWerkstoff = caMainController.dataAccess.LagerDaten.holeWerkstoff();
		var strNennweite = caMainController.dataAccess.LagerDaten.holeNennweite();
		var strAussendurchmesser = caMainController.dataAccess.LagerDaten.holeAussendurchmesser();
		var strManteldurchmesser = caMainController.dataAccess.LagerDaten.holeManteldurchmesser();
		var strGleitelement = caMainController.dataAccess.LagerDaten.holeGleitelement();
		var zusatzbedingungen = caMainController.dataAccess.LagerDaten.holeZusatzbedingungen();
		var betriebsbedingungen = caMainController.dataAccess.LagerDaten.holeBetriebsbedingungen();
		
        var lkTyp               = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung     = caMainController.dataAccess.getLastketteLastabtragung();
        var strAuswahlKontext   = caMainController.topologieKlasse.getLagerAuswahlKontext();
		
		// hier noch das Bild bestimmen
		var LGBildInfo	= caMainController.dataAccess.getBildInfoLGRicht();
		
		// transferiere UI daten zu client
		var response = {
			success: true,
			data: {
				// daten fr den Dialog
				IDC_LAGERART: strLagerart,
				IDC_GLEITART: strGleitart,
				IDC_ISOLIERUNG: strIsolierung,
				IDC_WERKSTOFF: strWerkstoff,
				IDC_NENNWEITE: strNennweite,
				IDC_AUSSENDURCHMESSER: strAussendurchmesser,
				IDC_MANTELDURCHMESSER: strManteldurchmesser,
				IDC_GLEITELEMENT: strGleitelement,
				IDC_ABHEBESICHERUNG: ( zusatzbedingungen.bAbhebesicherung ? 'true' : 'false' ),
				IDC_HOEHENVERSTELLUNG: ( zusatzbedingungen.bHoehenverstellung ? 'true' : 'false' ),
				IDC_GLEITUNTERLAGE: ( zusatzbedingungen.bGleitunterlage ? 'true' : 'false' ),
				IDC_KLEMMBAR: ( zusatzbedingungen.bKlemmbar ? 'true' : 'false' ),
				IDC_SCHRAUBBAR: ( zusatzbedingungen.bSchraubbar ? 'true' : 'false' ),
				IDC_EINSCHELLIG: ( zusatzbedingungen.bEinschellig ? 'true' : 'false' ),
				IDC_BUEGELAUSFUEHRUNG: ( zusatzbedingungen.bBuegelausfuehrung ? 'true' : 'false' ),
				// da ein Teil der Produktlogik zum Client hin verlagert ist, mssen auch einige technische Werte aus dem Betriebsbedingungendialog 
				// transferiert werden, die fr die Logik verwendet werden
				temperatur: betriebsbedingungen.temperatur,
				daemmdicke: betriebsbedingungen.daemmdicke,
				wx: betriebsbedingungen.wx,
				wy: betriebsbedingungen.wy,
                strAuswahlKontext: strAuswahlKontext,
				// einige Meldungen, die bei fehlgeschlagenen Konsistenztests auf der Clientseite verwendet werden
				msgVerschiebungBeiFestlager: translate( 'ID_ERRORMESSAGE_VERSCH_BEI_FEST' ),
				msgFuehrungslagerBei450Grad: translate( 'ID_ERROR_FUEHRLAGER_BEI_450' ),
				msgFuehrungslagerBeiDN600: translate( 'ID_ERROR_FUEHRLAGER_BEI_DN600' ),
				msgVerschiebungBeiFuehrungslager: translate( 'ID_ERRORMESSAGE_VERSCH_BEI_FUER' ),
				msgFuehrungBeiDaemmung: translate( 'ID_ERRORMESSAGE_FUEHRUNG_DAEMM' ),
				msgReibungsarmGleitendDN800: translate( 'ID_ERRORMESSAGE_REIBUNGSARM_GLEITEND_DN800' ),
				msgDaemmungMitUngedaemmt: translate( 'ID_ERRORMESSAGE_DAEMM_UNGED' ),
				msgEinfachGleitend: translate( 'ID_ERRORMESSAGE_EINFACH_GLEITEND' ),
				msgReibungsarmGleitend: translate( 'ID_ERRORMESSAGE_REIBUNGSARM_GLEITEND' ),
				msgFestlagerKlemmbarSchraubbar: translate( 'ID_ERRORMESSAGE_Fest_klemm_schraub' ),
				msgSuche: translate( 'ERROR_SELECT_PRODUCT_FROM_RESULTLIST' ),
				msgGLEITBLECH: translate( 'ID_ERRORMESSAGE_GLEITBLECH' ),
				// Bildvariante
				LG_IMG_VAR: LGBildInfo.strBildVariante,
				LG_RICHT_AKT: LGBildInfo.strLGHauptRicht
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr set-values action; 
	*/
	setValuesAction : function() 
    {
		// aktuell gewhltes Lager als Produkt aus dem aktuellen Tabellenindex und den letzten Suchergebnissen erzeugen
		// und in die zur Zeit gltige Topologie einfgen
		var nIndex = caMainController.dataAccess.LagerDaten.holeIndexGewaehltesLager();
		var oLager = Cascade.Lagersuche.holeLagerAusLagerliste( nIndex );
		
		var LGVar		= getstring("LG_IMG_VAR", "DLGDATA.CA.FORMS.LAGER_AUSWAHL");
		var LGRicht		= getstring("LG_RICHT_AKT", "DLGDATA.CA.FORMS.LAGER_AUSWAHL");
		oLager.strBild	= LGVar + LGRicht + '_' + oLager.strBauform;
		
		caMainController.topologieKlasse.setLager( oLager );
        
        // -mw- 15.9.09: Konfigurationsdaten zurcksetzen, sonst werden evtl. nicht vorhandene Trgerprofile gesetzt:
        delete("DLGDATA.CA.FORMS.LAGER_KONFIGURATION", "");

		// Antwort wird nicht ausgewertet
		var response = {
			success: true,
			data: { // keine
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr sucheLager action; suche nach passenden Lagern und transferiere sie ber JSON
	*/
	sucheLagerAction : function() 
    {
		// hole die fr die Suche relevanten Daten
		var strLagerart = caMainController.dataAccess.LagerDaten.holeLagerart();
		var strGleitart = caMainController.dataAccess.LagerDaten.holeGleitart();
		var strGleitelement = caMainController.dataAccess.LagerDaten.holeGleitelement();
		var strIsolierung = caMainController.dataAccess.LagerDaten.holeIsolierung();
		var strNennweite = caMainController.dataAccess.LagerDaten.holeNennweite();
		var strWerkstoff = caMainController.dataAccess.LagerDaten.holeWerkstoff();
		var strAussendurchmesser = caMainController.dataAccess.LagerDaten.holeAussendurchmesser();
		var strManteldurchmesser = caMainController.dataAccess.LagerDaten.holeManteldurchmesser();
		var oZusatzbedingungen = caMainController.dataAccess.LagerDaten.holeZusatzbedingungen();
		var oBetriebsbedingungen = caMainController.dataAccess.LagerDaten.holeBetriebsbedingungen();
		var strAuswahlKontext   = caMainController.topologieKlasse.getLagerAuswahlKontext();
        
		// suchen
		var oResult = Cascade.Lagersuche.sucheLager( strLagerart, strGleitart, strGleitelement, strIsolierung, strWerkstoff, strNennweite, strAussendurchmesser, 
		                                             strManteldurchmesser, oBetriebsbedingungen, oZusatzbedingungen, strAuswahlKontext );
		
		// Suchergebnisse der letzten Suche persistent speichern
		Cascade.Lagersuche.speichereLagerliste( oResult.bSucheErfolgreich ? oResult.aLager : null );
		
		var response = {
			success: oResult.bSucheErfolgreich,
			data: {
				// Fehlermeldung, wenn Fehler beim Laden aufgetreten
				strMeldung: oResult.strMeldung
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeLagerliste action; suche nach passenden Lagern, transferiere sie ber JSON
	*/
	holeLagerlisteAction : function() 
    {
		// Whrung:
		dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
		if (dCurrencyFactor <= 0.01)
			dCurrencyFactor = 1;
	
		var resultlist = new Array();
		var aListe = Cascade.Lagersuche.rekonstruiereLetzeLagerliste();
		
		if ( aListe )
		{
			var bZeigePreis = ( getstring("PCODE", "CATALOG.SETTINGS") == "630927" );
			
			// hole aus jedem Lager, das als Ergebnis der jeweils letzten Suche zwischengespeichert ist, die Daten zur Anzeige in der Lagertabelle
			var nLager = aListe.length;
			var daten;
			for ( var i = 0; i < nLager; ++i )
			{
				if ( aListe[i] )
				{
					daten = aListe[i].holeDisplayDaten( bZeigePreis, dCurrencyFactor );
					daten.id = i + 1;
					resultlist.push( daten );
				}
			}
		}
		
		var response = {
			rows: resultlist
		};

		echo response.toJSON(); 
	}
	
});