/**
 * KonfigurationHaengerController
 */
KonfigurationHaengerController = function() {
	KonfigurationHaengerController.superclass.constructor.call(this);
};

EasyKat.extend(KonfigurationHaengerController, CustomController, {

	getValuesAction : function() 
    {
        var aDisabled = [];
        var aEnabled = ['BLOCK_NEIN' ];
    
        var strSelHangerType    = getstring("ACT_SELECTED_HANGERTYPE", "DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE"); 

        var strBeschichtung = getstring("IDC_BESCHICHTUNG", "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER");
		var strBlockierung  = getstring("IDC_BLOCKIERUNG",  "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER");

        var strBlockierungVorbelegung = strBlockierung;
        var strBeschichtungVorbelegung = strBeschichtung;
        if (strSelHangerType == "F")
        {
            if (strBlockierungVorbelegung == "")
            {
                if (caMainController.presets.m_nFhBlock != "")
                    strBlockierungVorbelegung = caMainController.presets.m_nFhBlock;
                else
                    strBlockierungVorbelegung = "BLOCK_JA";     // Mittig gibts jetzt auch ...
            }
            if (strBeschichtungVorbelegung == "")
            {
                if (caMainController.presets.TERROSON_FH)
                    strBeschichtungVorbelegung = "TERROSON";
                else
                    strBeschichtungVorbelegung = "OHNE";
            }
        }
        if (strSelHangerType == "K")
        {
            aDisabled = ['BLOCK_NEIN'];
            
            if (strBlockierungVorbelegung == "")
            {
                if (caMainController.presets.m_nKhBlock != "")
                    strBlockierungVorbelegung = caMainController.presets.m_nKhBlock;
                else
                    strBlockierungVorbelegung = "BLOCK_JA";
            }
            if (strBeschichtungVorbelegung == "")
            {
                if (caMainController.presets.TERROSON_KH)
                    strBeschichtungVorbelegung = "TERROSON";
                else
                    strBeschichtungVorbelegung = "OHNE";
            }
        }
        
		var response = {
			success: true,      // wertet die Form standardmssig aus ... bei false werden die Werte nicht bernommen, der onFailure Handler wird aufgerufen.
			data: {
				IDC_BESCHICHTUNG: strBeschichtungVorbelegung,
				IDC_BLOCKIERUNG: strBlockierungVorbelegung
			},
            enabled: aEnabled,
			disabled: aDisabled
		};
		
		echo response.toJSON(); 
	},
	
	setValuesAction : function() 
    {
        var strBeschichtung = getstring("IDC_BESCHICHTUNG", "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER");
		var strBlockierung  = getstring("IDC_BLOCKIERUNG",  "DLGDATA.CA.FORMS.KONFIGURATION_HAENGER");
		caMainController.setHaengerOptions(strBeschichtung, strBlockierung, "FROM_DIALOG");
	}
});