/**
 * Cascade Serverseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category Controller 
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */

 /**
 * KlemmsystemAuswahlController constructor
 */
KlemmsystemAuswahlController = function() 
{
	// nur an constructor der Basisklasse delegieren
	KlemmsystemAuswahlController.superclass.constructor.call( this );
	
	// Storepfad der UI-Variablen
	this.strStorePath = "DLGDATA.CA.FORMS.KLEMMSYSTEM_AUSWAHL";
};

 /**
 * Klasse KlemmsystemAuswahlController - serverseitige Kontrollerklasse fr Dialog 'Auswahl Klemmsystem' (siehe klemmsystem_auswahl.js)
 */
EasyKat.extend( KlemmsystemAuswahlController, CustomController, 
{
	/**
	* action handler fr get-values action; hole die fr den Dialog 'Auswahl' relevanten Werte aus 
	* den Store und transferiere sie ber JSON
	*/
	getValuesAction : function() 
    {	
		// hole UI daten fr diesen Dialog
		var strLagerfunktion = caMainController.dataAccess.KlemmsystemDaten.holeLagerfunktion();
		var oZusatzfunktionen = caMainController.dataAccess.KlemmsystemDaten.holeZusatzfunktionen();
		var strProfilart = caMainController.dataAccess.KlemmsystemDaten.holeTraegerart();
		var strTraegergroesse = caMainController.dataAccess.KlemmsystemDaten.holeTraegergroesse();

		// Daten fr Profilarten und Trgergren sind fr Lager dieselben wie fr Klemmsysteme
		var oProfilarten = Cascade.Lagerkonfiguration.holeProfilarten( strLagerfunktion );
		if ( !strProfilart )
			strProfilart = oProfilarten.strProfilart;
		
		// Trgergren zu ausgewhltem oder erstem Profil der Profilarten holen
		var oTraegergroessen = Cascade.Lagerkonfiguration.holeTraegergroessen( oProfilarten.strProfilart );
		if ( !strTraegergroesse )
			strTraegergroesse = oTraegergroessen.strTraegergroesse;
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen
		// UI-Bild fr Lager mit aktuellem Profil und Trgergre holen
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( oProfilarten.strProfilart, oTraegergroessen.strTraegergroesse, null );
		
		// transferiere UI daten zu client
		var response = {
			success: true,
			data: {
				// daten fr den Dialog
				IDC_LAGERFUNKTION: strLagerfunktion,
				IDC_ABHEBESICHERUNG_K: ( oZusatzfunktionen.bAbhebesicherung ? 'true' : 'false' ),
				IDC_ABHEBESICHERUNG4FACH: ( oZusatzfunktionen.bAbhebesicherung4fach ? 'true' : 'false' ),
				IDC_GLEITUNTERLAGE_K: ( oZusatzfunktionen.bGleitunterlage ? 'true' : 'false' ),
				IDC_LAGERFUSSBREITE: oZusatzfunktionen.strBreite,
				IDC_PROFILART: strProfilart,
				IDC_TRAEGERGROESSE: strTraegergroesse,
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke,
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				profilarten: oProfilarten.daten,
				traegergroessen: oTraegergroessen.daten,
				// einige Meldungen, die bei fehlgeschlagenen Konsistenztests auf der Clientseite verwendet werden
				msgSuche: translate( 'ERROR_SELECT_PRODUCT_FROM_RESULTLIST' ),
				msgTitel: translate( 'IDC_AUSWAHL_KLEMMSYS_LABEL' )
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr set-values action; 
	*/
	setValuesAction : function() 
    {
		// aktuell gewhltes Klemmsystem als Produkt aus dem aktuellen Tabellenindex und den letzten Suchergebnissen erzeugen
		// und in die zur Zeit gltige Topologie einfgen
		// siehe auch mail von -mw- von gestern - Topic 'WG: Aktuelle Daten'
		//alert( 'still todo: denk an die neuen LUR-Lager, die wie LSL behandelt werden mssen - neue Datenbank, sind in derselben Tabelle wie LSL' );
		var nIndex = caMainController.dataAccess.KlemmsystemDaten.holeIndexGewaehltesKlemmsystem();
		var oKlemmsystem = Cascade.Klemmsystem.holeKlemmsystemAusKlemmsystemliste( nIndex );
		caMainController.topologieKlasse.setKlemmsystem( oKlemmsystem );

		// Antwort wird nicht ausgewertet
		var response = {
			success: true,
			data: {	// keine zustzlichen Daten
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr sucheKlemmsystem action; suche nach passenden Klemmsystemen und transferiere sie ber JSON
	*/
	sucheKlemmsystemeAction : function() 
    {
		// hole die fr die Suche relevanten Daten
		var strLagerfunktion = caMainController.dataAccess.KlemmsystemDaten.holeLagerfunktion();
		var strTraegerart = caMainController.dataAccess.KlemmsystemDaten.holeTraegerart();
		var strTraegergroesse = caMainController.dataAccess.KlemmsystemDaten.holeTraegergroesse();
		var oZusatzfunktionen = caMainController.dataAccess.KlemmsystemDaten.holeZusatzfunktionen();
		
		// suchen
		var oResult = Cascade.Klemmsystem.sucheKlemmsystem( strLagerfunktion, strTraegerart, strTraegergroesse, oZusatzfunktionen );
		
		// Suchergebnisse der letzten Suche persistent speichern
		Cascade.Klemmsystem.speichereKlemmsystemliste( oResult.bSucheErfolgreich ? oResult.aKlemmsysteme : null );
		
		var response = {
			success: oResult.bSucheErfolgreich,
			data: {
				// Fehlermeldung, wenn Fehler beim Laden aufgetreten
				strMeldung: oResult.strMeldung
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeKlemmsystemliste action; hole bei letzter Suche gefundene Klemmsysteme, transferiere sie ber JSON
	*/
	holeKlemmsystemlisteAction : function() 
    {
		// Whrung:
		dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
		if (dCurrencyFactor <= 0.01)
			dCurrencyFactor = 1;

		var resultlist = new Array();
		var aListe = Cascade.Klemmsystem.rekonstruiereLetzeKlemmsystemliste();
		
		if ( aListe )
		{
			var bZeigePreis = ( getstring("PCODE", "CATALOG.SETTINGS") == "630927" );
			
			// hole aus jedem Klemmsystem, das als Ergebnis der jeweils letzten Suche zwischengespeichert ist, die Daten zur Anzeige in der Klemmsystemtabelle
			var nSysteme = aListe.length;
			var daten;
			for ( var i = 0; i < nSysteme; ++i )
			{
				if ( aListe[i] )
				{
					daten = aListe[i].holeDisplayDaten( bZeigePreis, dCurrencyFactor );
					daten.id = i + 1;
					resultlist.push( daten );
				}
			}
		}

		var response = {
			rows: resultlist
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeTraegergroessen action; hole die zu der aktuellen Profilart gltigen Trgergren, Trgerdaten, den Lagertyp und das Lagerbild
	*/
	holeTraegergroessenAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// Trgergren zu ausgewhltem oder erstem Profil der Profilarten holen - die Daten sind fr Lager genau dieselben wie fr Klemmsysteme
		var oTraegergroessen = Cascade.Lagerkonfiguration.holeTraegergroessen( submitVars.IDC_PROFILART );
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen - die Daten sind fr Lager genau dieselben wie fr Klemmsysteme
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( submitVars.IDC_PROFILART, oTraegergroessen.strTraegergroesse, null );
		
		// Daten fr die Antwort zusammenstellen und weiterschicken
		var response = {
			success: true,
			data: {
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				traegergroessen: oTraegergroessen.daten,
				IDC_TRAEGERGROESSE: oTraegergroessen.strTraegergroesse,
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke
			}
		};

		echo response.toJSON(); 
	},
	
	/**
	* action handler fr holeTraegerdaten action; hole die zu der aktuellen Trgergre gltigen Trgerdaten, den Lagertyp und das Lagerbild
	*/
	holeTraegerdatenAction : function() 
    {
		// hole Dialogvariablen aus dem Store
		var submitVars = Object.fromStorage( this.strStorePath );
		
		// Trgerdaten fr aktuelle Trgergre holen
		// Typbezeichnung fr Lager mit aktuellem Profil und Trgergre holen - die Daten sind fr Lager genau dieselben wie fr Klemmsysteme
		var oTraegerdaten = Cascade.Lagerkonfiguration.holeTraegerdaten( submitVars.IDC_PROFILART, submitVars.IDC_TRAEGERGROESSE, null );
		
		var response = {
			success: true,
			data: {
				// diese Daten mssen zuerst noch clientseitig weiterverarbeitet werden
				IDC_TRAEGERHOEHE: oTraegerdaten.strTraegerhoehe,
				IDC_TRAEGERBREITE: oTraegerdaten.strTraegerbreite,
				IDC_FLANSCHDICKE: oTraegerdaten.strFlanschdicke
			}
		};

		echo response.toJSON(); 
	}	
});