﻿IndexController = function() {
	IndexController.superclass.constructor.call(this);
};

EasyKat.extend(IndexController, CustomController,
{
    getNextPanelAction : function()
    {
        var activePanel = getdlgvar('activepanel');
		var nextPanel ;
		
		if(rfind(activePanel,"lager.")>0){ //2011 für Lager 
			var oDlgLagerSession 	= getDialogObjectSession("LAGER");
			nextPanel = Controller.Lager.Common.getNextClientPanel(oDlgLagerSession, activePanel, caMainController);
			nextPanel = nextPanel.toJSON();
		}
		else{ //altes Vorgehen
			test = caMainController.topologieKlassenName;
			test2 = caMainController.topologieKlasse;

			nextPanel = caMainController.topologieKlasse.getNextPanel(activePanel);
		}
		
        echo nextPanel;
    },

	// Return the History from store.
	getHistoryAction : function() {
		var history = Object.fromStorage( "DLGDATA.CA.HIST.HISTORY" );
        // Array mit id und title
        for (var i = 0; i < history.length; i++){
            var strHistory;
			if(rfind(history[i].id,"lager.")>0)
				strHistory = history[i].title
			else
				strHistory = translate(toupper(history[i].id));
				
			history[i].title = strHistory;
		}	
        //auswahl_haengergroesse, AUSWAHL_HAENGERGROESSE
        
		echo history.toJSON();
	},
	
	getProductObjectPanelAction : function(){
		var strPanel = HttpRequest.get("value");
		var oRet;
		switch(strPanel){ //ID entspricht den StorePfad OPEN_MODE_CASCADE
			case "LAGER2011" :
					oRet = CaPanels.systemcharakteristik_lager;
				break;
		}
		
		echo oRet.toJSON();
	},

    checkMarkierungLaenge : function()
    {
        // prüfen, ob die maximale Länge für Kennzeichnung überschritten ist:
        // erst mal schauen, ob wir überhaupt einen Hänger haben
        var strWarningMessage = "";
        var nMaxKennzeichnung = 0;
        var i;
        var curHaenger = caMainController.topologieKlasse.getCurrentHaenger();

        if (! curHaenger)
            return strWarningMessage;

        if ( curHaenger.isKHaenger() )
        {
            nMaxKennzeichnung = 22;
        }
        if ( curHaenger.isFHaenger() )
        {
            if ( curHaenger.nennweg == 50 )
                nMaxKennzeichnung = 16;
            else if ( curHaenger.nennweg == 100 )
                nMaxKennzeichnung = 23;
            else
                nMaxKennzeichnung = 58;
        }

        var oLKinfo = caMainController.dataAccess.getLKinfoDaten();
        if ((oLKinfo.markierung != "") && (nMaxKennzeichnung > 0))
        {
            if (oLKinfo.markierung.length > nMaxKennzeichnung)
                strWarningMessage = replace(translate("MSG_ERR_LENGTH_TYPENSCHILD"), "#x#", nMaxKennzeichnung);
        }
        return strWarningMessage;
    },

	checkMarkierungVorhanden : function()
    {
        // Markierung sollte nicht schonmal vorhanden sein!
        var strWarningMessage = "";
        var oLKinfo = caMainController.dataAccess.getLKinfoDaten();
        var thisPos = getstring("POS", "DLGDATA");
        if (oLKinfo.markierung != "")
        {
            var Source, Target, i, j;
            var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
            var nLastPos = getsize(Projectlist, "") - 1;
            for (i = 0; i <= nLastPos; ++i)
            {
                Source = Projectlist + "[" + i + "]";
                var strProductArea  = getstring("PRODUCT_AREA", Source);
                var strPos          = getstring("POS", Source);
                var strCurMarkierung = "";
                if ((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP"))
                {
                    if (strProductArea == "FP")
                        strCurMarkierung = getstring("FP.MARKIERUNG", Source);
                    else
                        strCurMarkierung = getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", Source);

                    if ((oLKinfo.markierung == strCurMarkierung) &&
                        (thisPos != strPos))
                    {
                        // Sonderfall Aufruf aus PDS / PDMS - System: "Alte Position" mit derselben Markierung soll überschrieben werden
                        if (getstring("OUTFILE", "ROOT") != "")
                        {
                            for (j = i+1; j <= nLastPos; ++j)
                            {
                                Source = Projectlist + "[" + j + "]";
                                Target = Projectlist + "[" + (j-1) + "]";
                                delete(Target, "");
                                copy(Source, Target);
                            }
                            delete(Projectlist + "[" + nLastPos + "]", "");
                        }
                        else
                            strWarningMessage = replace(translate("MSG_ERR_MARKIERUNG_EXIST"), "#x#", strPos);
                        break;
                    }
                }
            }
        }
        return strWarningMessage;
    },
	
	checkSonderteileOberflaechenschutz : function()
    {
		var i = 0;
		var sonderteil = null;
		var strOldOberfl = "", strOldOberflFrei = "";
		var strMessage = "";
        for(i = 0; i < caMainController.topologieKlasse.Sonderteile.length; i++)
        {
			sonderteil = caMainController.topologieKlasse.Sonderteile[i];
			if (sonderteil.bOberflaechenschutzFrei > 0)
			{
				if (strOldOberfl == "")
					strOldOberfl = sonderteil.m_Poberfl;
				if (strOldOberflFrei == "")
				{
					if (sonderteil.m_Poberfl == "OB_SONST")
						strOldOberflFrei = sonderteil.m_PoberflFrei;
				}
				if (sonderteil.m_Poberfl != strOldOberfl)
					strMessage = translate("IDP_OBERFLAECHENSCHUTZ_SONDER_GLEICH");	
				if ((sonderteil.m_Poberfl == "OB_SONST") && (strOldOberflFrei != sonderteil.m_PoberflFrei))
					strMessage = translate("IDP_OBERFLAECHENSCHUTZ_SONDER_GLEICH");	
			}
        }
		return strMessage;
	},

	completeSelectionAction : function()
    {
        var bAuslegungOk = true;
        var strErrorMessage = "";
        var strWarningMessage = "";
		var strGoBackPanel = '';

        // Die History zuerst merken. Es kann sein, dass eine Warning
        // gegeben wird und der Anwender trotzdem speichert.
		var history = EasyKat.decode( getdlgvar('history') );
        var values = EasyKat.decode( getdlgvar('values') );

		// das ist sehr schlecht da toStorage mit dem zweiten Parameter das eigentlich machen sollte
		delete( "HIST", "DLGDATA.CA" );
		history.toStorage("DLGDATA.CA.HIST.HISTORY", false);
        values.toStorage("DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE", false );
		
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		/*
		var VertiDir		  	= getstring("SENKR_RICHT", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
		if (VertiDir == "AUF")
			var sollast			= abs(caMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6]));
		else
			var sollast			= abs(caMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6]));
        */
		var sollast				= max(Math.abs(caMainController.dataAccess.getSollwerteLast("-", 1, AchsDirInfo[6])), Math.abs(caMainController.dataAccess.getSollwerteLast("+", 1, AchsDirInfo[6])));
		var schaetzZusatzlast 	= caMainController.dataAccess.getSollwerteZusatzLast(1, AchsDirInfo[6]);
        var istZusatzlast 		= caMainController.topologieKlasse.calculateZusatzlast();
		var berZLast			= fround(atod(getstring("Z_LAST_EG", "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT")),2); // fuer zweiten Durchlauf
		var LKTyp				= caMainController.dataAccess.getLastketteTyp();
		
		// Automatische Neuberechnung nur starten, wenn auch etwas relevantes da ist und der Hänger kein Dynamikteil ist
		if ((berZLast != istZusatzlast) && (LKTyp != "GELENKSTREBE") && (LKTyp != "STOSSBREMSE"))
        {
			// Ist-Wert neu setzen
			caMainController.dataAccess.setSollwerteZusatzLastEG(istZusatzlast);
			// Wir versuchen, den "Hänger" automatisch an die geänderte Last anzupassen, ohne die LGV zu ändern.
			// Wenn dies nicht geht, dann muss der Anwender zurück zur Hängerauswahl
			if (! caMainController.recalcHaenger((sollast + schaetzZusatzlast), istZusatzlast)) 
			{
				// @@@ Hier noch einbauen, dass wir nach der Meldung automatisch zurückgehen ...
				var strErrorMessage = translate("ZUSATZLAST_AUS_EIGENGEWICHT") + ": " + istZusatzlast + "kN" + "<br>" + translate("IDP_ZUSATZLAST_VORSCHLAG");
				bAuslegungOk = false;
				strGoBackPanel = 'sollwerte_halterungspunkt';
			}
        }
		
        if ((caMainController.topologieKlasse.preisStatus == "ERROR") &&
            (getstring("PRICES_ENABLED", "RIGHTS") == "1"))
        {
            strWarningMessage = translate("IDP_WARNING_EINZELTEILPREIS_FEHLT") + "\n";
            bAuslegungOk = false;
        }
        var oLKWinkel    = caMainController.topologieKlasse.getLKWinkel();
        if (!oLKWinkel.bErlaubt)
        {
            var strWinkelMessage = translate("IDP_WARNING_SCHRAEGZUG_MESSAGE") + "\n";
            strWinkelMessage = replace(strWinkelMessage, "XXX", oLKWinkel.a_Schraegzug);
            strWinkelMessage = replace(strWinkelMessage, "YYY", oLKWinkel.Grenzwert);
            strWarningMessage = strWarningMessage + strWinkelMessage;
            bAuslegungOk = false;
        }
        var strMarkierungMessage = this.checkMarkierungLaenge();
        if (strMarkierungMessage != "")
        {
            strWarningMessage = strWarningMessage + strMarkierungMessage + "\n";
            bAuslegungOk = false;
        }
        var strMarkVorhandenMessage = this.checkMarkierungVorhanden();
        if (strMarkVorhandenMessage != "")
        {
            strWarningMessage = strWarningMessage + strMarkVorhandenMessage + "\n";
            bAuslegungOk = false;
        }
        var strVorgabePreis = trimright(getstring("FORCEDUNITPRICE", "DLGDATA"), " ");
        if (strVorgabePreis != "")
        {
            strWarningMessage = strWarningMessage + translate("IDP_WARNING_CHECK_VORGABEPREIS") + "\n";  
            bAuslegungOk = false;
        }
        var strcheckSonderteileMessage = this.checkSonderteileOberflaechenschutz();
        if (strcheckSonderteileMessage != "")
        {
            strErrorMessage = strErrorMessage + strcheckSonderteileMessage + "\n";
            bAuslegungOk = false;
        }
        
        var stkList = [];
        caMainController.topologieKlasse.getStueckliste(stkList);
        if (stkList.length <= 0)
        {
            strErrorMessage = strErrorMessage + translate("IDP_STUECKLISTE_LEER") + "\n";
            bAuslegungOk = false;        
        }

        if (strWarningMessage != "")
            strWarningMessage = strWarningMessage + translate("IDP_WARNING_AUSWAHL_BEENDEN");

        // PDS-Interface: 
        // Hier die STK-Datei schreiben wenn kein Fehler aufgetreten ist???
        // ... Achtung: Pos mit doppelten Markierungen !!
        // ... Projekt speichern ?????  --> in custom.es 
        // ... Hinweis an Anwender, er soll zurückwechseln zu PDS


        var response = {
            success: true,
            strErrorMessage: '',
            strWarningMessage: '',
			strGoBackPanel: ''
        };

        if (! bAuslegungOk)
        {
            response.strErrorMessage = strErrorMessage;
            response.strWarningMessage = strWarningMessage;
			response.strGoBackPanel = strGoBackPanel;
        }
		// hier erst "bearbeitet" setzen; wenn wir aus dem FIN kommen
		var TestFIN = typeof(Object.fromStorage("DLGDATA.CA.FINDATA.REQUIRED")) == 'object' ? true : false;
		if ((TestFIN) && (strGoBackPanel == "") && ((getstring("OPEN_MODE_CASCADE", "") == "NEW") || (getstring("OPEN_MODE_CASCADE", "") == "LAGER2011")))
			//(getstring("status", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA") +"]") == ""))
			// jetzt kommt man immer raus und man kommt auch nicht ueber "Aendern"
		{
			var strStatus	=	translate("IDC_BEARBEITET") + " " + getstring("DATE", "") + " " + getstring("TIME", "");
			setstring("status", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA") +"]", strStatus);
			// -Schu- Pruefung der Schreibrechte im Ordner der FIN/STK-Datei
			var strFINPath	=	getstring("IMPORT_STK_VERZEICHNIS", "") + "\\";
			writefile(strFINPath + "test.txt", "\r\n", "wc");
			var OK			=	FileName.fileExists(strFINPath + "test.txt");
			// -Schu- noch in die FIN-Datei "bearbeitet" schreiben
			if (OK)	// Schreibrechte vorhanden
			{
				OK					=	FileName.deleteFile(strFINPath + "test.txt");
				var strFINFilePath	=	strFINPath + getstring("info", "TEMP.STK_IMPORT_AREA.STKIMPORTLIST_ITEMS["+ getstring("STKIMPORTLIST_TABELLE_SELECTED", "TEMP.STK_IMPORT_AREA") +"]");
				OK					=	FileName.dirExists(strFINPath + "FINOri");
				if (!OK)
					OK	=	FileName.createDir(strFINPath + "FINOri");
				OK	=	FileName.copyFile(strFINFilePath, strFINPath + "FINOri", 1);
				OK	=	FileName.fileExists(strFINPath + "FINOri\\" + FileName.getName(strFINFilePath) + ".OLD")
				if (OK)
					OK	=	FileName.deleteFile(strFINPath + "FINOri\\" + FileName.getName(strFINFilePath) + ".OLD");
				OK	=	FileName.renameFile(strFINPath + "FINOri\\" + FileName.getFullName(strFINFilePath), FileName.getName(strFINFilePath) + ".old");
				writefile(strFINFilePath, "\n" + strStatus, "a" );
			}
		}
		
		echo response.toJSON();
        return;
	},
	
	// -Schu- 20.07.2010 Objekt fuer STK "Required Data" und "SECONDARY_STEEL-DATA" aktualisieren
	makeRequiredValues : function()
	{
		var TestFIN				= typeof(Object.fromStorage( "DLGDATA.CA.FINDATA.REQUIRED" )) == 'object' ? true : false;
		var strpath				= "DLGDATA.CA.FINDATA.REQUIRED";
		var FORMS				= Object.fromStorage( "DLGDATA.CA.FORMS" ); // neu für Update FlexKS
		var HP					= "DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.";
		var HPVal				= "PLAIN_ARRAY_ITEM_VALUE";
		var LK_Typ				= FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTKETTE;
		if (FORMS.LAGER2DATAEXISTS == 'X')
			//var oDlgLagerSession 	= getDialogObjectSession("LAGER");	// aus irgendwelchen Gründen klappt das hier manchmal nicht
			var oDlgLagerSession 	= FORMS.LAGER2DATA;		// die Daten sind hier auch drin
		var AchsDirInfo			= caMainController.dataAccess.getAchsKSInfo();
		var AchsDirInfo2		= caMainController.dataAccess.getInfoRRKSDefault(caMainController.dataAccess.getLastketteRohrverlauf());
		
		// Werte die in FL nicht geaendert werden koennen, bleiben unberuehrt oder leer
		// L_AXES
		// X_/Y_/Z_FORCE_L
		
		var FN = getstring ("FORCE_NORMAL", strpath).split(" ");
		var FA = getstring ("FORCE_ALL", strpath).split(" ");
		if (TestFIN){	// gab es überhaupt ein FIN-FILE?
			if (left(LK_Typ, 5) != "LAGER" && FA[0] == ""){
			// -> Lastkette und Force_all ist nicht da
			// wenn Force_all da ist wird an originalem Force_normal nichts geändert
				var FN_Flex	= [];
				for (var i = 0; i < 3; i++)
					FN_Flex[i] = (-1)*abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus[i]);
				for (i = i; i < 6; i++)
					FN_Flex[i] = abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[i-3]);
				if (FN[0] != "")
					setstring ("FORCE_NORMAL", strpath, FN_Flex[0] + " " + FN_Flex[1] + " " + FN_Flex[2] + " " + FN_Flex[3] + " " + FN_Flex[4] + " " + FN_Flex[5]);
			}
			else if (FA[0] == ""){	// Lager neu
			// -> Force_all nicht da
				var FN_Flex	= [];
				var Test  = AchsDirInfo2.VertiDir;
				var Test1 = AchsDirInfo2.strPipeDir;
				if (AchsDirInfo2.strPipeDir == AchsDirInfo2.VertiDir){	// vertikales Rohr
					switch (AchsDirInfo2.strPipeDir){
					case 'X' :
						FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						break;
					case 'Y' :
						FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FN_Flex[1] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						break;
					default : // case 'Z'
						FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						break;
					}
				}
				else{
					switch (AchsDirInfo2.strPipeDir){
					case 'X' :
						FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						var QuerDir	= (AchsDirInfo2.HoriDir1 == 'X' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
						if (QuerDir == 'Y'){
							FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						else{
							FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						break;
					case 'Y' :
						FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Y' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
						if (QuerDir == 'Z'){
							FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						else{
							FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						break;
					default :	//case 'Z'
						FN_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
						FN_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
						var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Z' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
						if (QuerDir == 'X'){
							FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						else{
							FN_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
							FN_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
							FN_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
							FN_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
						}
						break;
					}
				}
				if (FN[0] != "")
					setstring ("FORCE_NORMAL", strpath, FN_Flex[0] + " " + FN_Flex[1] + " " + FN_Flex[2] + " " + FN_Flex[3] + " " + FN_Flex[4] + " " + FN_Flex[5]);
			}
			
		}
		if (left(LK_Typ, 5) != "LAGER"){	// -> Lastkette
			var FA_Flex	= [];
			for (var i = 0; i < 3; i++)
				FA_Flex[i] = (-1)*abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_minus[i]);
			for (i = i; i < 6; i++)
				FA_Flex[i] = abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.last_plus[i-3]);
			
			var X_Force_Max_FL	= FA_Flex[0];
			if (abs(FA_Flex[3]) > abs(FA_Flex[0]))
				X_Force_Max_FL	= FA_Flex[3];
			var Y_Force_Max_FL	= FA_Flex[1];
			if (abs(FA_Flex[4]) > abs(FA_Flex[1]))
				Y_Force_Max_FL	= FA_Flex[4];
			
			var Z_STATLOAD = max(abs(FA_Flex[2]), abs(FA_Flex[5]));
			
			if ((LK_Typ == "BEWEGLICH" || LK_Typ == "STARR")&&
						getstring("Z_FORCE", "DLGDATA.CA.FINDATA.REQUIRED") != "")
				var Z_Force_Max_FL = FA_Flex[2]	= (-1)*fround(abs(inputStringToDouble(getstring("Z_FORCE", "DLGDATA.CA.FINDATA.REQUIRED"))),1);
			else{
				var Z_Force_Max_FL	= FA_Flex[2];
				if (abs(FA_Flex[5]) > abs(FA_Flex[2]))
					Z_Force_Max_FL	= FA_Flex[5];
			}
			setstring("Z_STATLOAD", strpath, Z_STATLOAD);
			setstring("X_FORCE", strpath, X_Force_Max_FL);
			setstring("Y_FORCE", strpath, Y_Force_Max_FL);
			setstring("Z_FORCE", strpath, Z_Force_Max_FL);
			if (!TestFIN || (TestFIN && FA[0] != ""))
				//setstring ("FORCE_ALL", strpath, FA_Flex[0] + " " + FA_Flex[1] + " " + FA_Flex[2] + " " + FA_Flex[3] + " " + FA_Flex[4] + " " + FA_Flex[5]);
				setstring ("FORCE_ALL", strpath, FA_Flex[3] + " " + FA_Flex[4] + " " + FA_Flex[5] + " " + FA_Flex[0] + " " + FA_Flex[1] + " " + FA_Flex[2]);
		}
		else{	// Lager neu
			var FA_Flex	= [];
			if (AchsDirInfo2.strPipeDir == AchsDirInfo2.VertiDir){	// vertikales Rohr
				switch (AchsDirInfo2.strPipeDir){
				case 'X' :
					FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
					FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
					FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
					FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					break;
				case 'Y' :
					FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
					FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
					FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
					FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					break;
				default : // case 'Z'
					FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
					FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
					FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
					FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					break;
				}
			}
			else{
				switch (AchsDirInfo2.strPipeDir){
				case 'X' :
					FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'X' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'Y'){
						FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					else{
						FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					break;
				case 'Y' :
					FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Y' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'Z'){
						FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					else{
						FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					break;
				default :	//case 'Z'
					FA_Flex[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.axial);
					FA_Flex[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Z' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'X'){
						FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					else{
						FA_Flex[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.quer);
						FA_Flex[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.quer);
						FA_Flex[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_minus.schief);
						FA_Flex[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.last_plus.schief);
					}
					break;
				}
			}
			var X_Force_Max_FL	= (abs(FA_Flex[0]) > abs(FA_Flex[3]) ? (-1)*abs(FA_Flex[0]) : abs(FA_Flex[3]));
			var Y_Force_Max_FL	= (abs(FA_Flex[1]) > abs(FA_Flex[4]) ? (-1)*abs(FA_Flex[1]) : abs(FA_Flex[4]));
			var Z_Force_Max_FL	= (abs(FA_Flex[2]) > abs(FA_Flex[5]) ? (-1)*abs(FA_Flex[2]) : abs(FA_Flex[5]));
				
			setstring("X_FORCE", strpath, X_Force_Max_FL);
			setstring("Y_FORCE", strpath, Y_Force_Max_FL);
			setstring("Z_FORCE", strpath, Z_Force_Max_FL);
			setstring("Z_STATLOAD", strpath, Z_Force_Max_FL);
			if (!TestFIN || (TestFIN && FA[0] != ""))
				//setstring ("FORCE_ALL", strpath, FA_Flex[0] + " " + FA_Flex[1] + " " + FA_Flex[2] + " " + FA_Flex[3] + " " + FA_Flex[4] + " " + FA_Flex[5]);
				setstring ("FORCE_ALL", strpath, FA_Flex[3] + " " + FA_Flex[4] + " " + FA_Flex[5] + " " + FA_Flex[0] + " " + FA_Flex[1] + " " + FA_Flex[2]);
		}
		
		var rh_typ = getstring("rh_typ", "DLGDATA.CA.FINDATA.FINOBJECT.assembly");
		if (getstring("MOV_ALL", strpath) != "")
			var MOV_ALL = getstring("MOV_ALL", strpath).split(" ");
		else if ((rh_typ == "FH" || rh_typ == "KH") && (getstring("MOV_HDW", strpath) != ""))
			var MOV_ALL = getstring("MOV_HDW", strpath).split(" ");
		else if (getstring("MOV_W", strpath) != "")
			var MOV_ALL = getstring("MOV_W", strpath).split(" ");
		
		var MOV_FL = new Array();
		
		if (left(LK_Typ, 5) != "LAGER"){		// Lastkette
			for (var i = 0; i < 3; i++)
				MOV_FL[i] = (-1)*abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_minus[i]);
			for (i = i; i < 6; i++)
				MOV_FL[i] = abs(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.bewegung_plus[i-3]);
		}
		else{	// Lager
			if (AchsDirInfo2.strPipeDir == AchsDirInfo2.VertiDir){	// vertikales Rohr
				switch (AchsDirInfo2.strPipeDir){
				case 'X' :
					MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
					MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
					MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
					MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					break;
				case 'Y' :
					MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
					MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
					MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
					MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					break;
				default : // case 'Z'
					MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
					MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
					MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
					MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					break;
				}
			}
			else{
				switch (AchsDirInfo2.strPipeDir){
				case 'X' :
					MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'X' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'Y'){
						MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					else{
						MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					break;
				case 'Y' :
					MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Y' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'Z'){
						MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					else{
						MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					break;
				default :	//case 'Z'
					MOV_FL[2] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.axial);
					MOV_FL[5] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.axial);
					var QuerDir	= (AchsDirInfo2.HoriDir1 == 'Z' ? AchsDirInfo2.HoriDir2 : AchsDirInfo2.HoriDir1);
					if (QuerDir == 'X'){
						MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					else{
						MOV_FL[1] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.quer);
						MOV_FL[4] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.quer);
						MOV_FL[0] = (-1)*abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_minus.schief);
						MOV_FL[3] = abs(oDlgLagerSession.SollwerteHalterungspunkt.oTable.bewegung_plus.schief);
					}
					break;
				}
			}
		}
		
		var strMovAll	= MOV_FL[3] + " " +MOV_FL[4] + " " + MOV_FL[5] + " " + MOV_FL[0] + " " + MOV_FL[1] + " " + MOV_FL[2];
		if (!MOV_ALL)
		{
			if (abs(MOV_FL[0]) > abs(MOV_FL[3]))
				setstring ("X_MOV", strpath, MOV_FL[0]);
			else
				setstring ("X_MOV", strpath, MOV_FL[3]);
			if (abs(MOV_FL[1]) > abs(MOV_FL[4]))
				setstring ("Y_MOV", strpath, MOV_FL[1]);
			else
				setstring ("Y_MOV", strpath, MOV_FL[4]);
			
			//if ((LK_Typ != "BEWEGLICH") || (TestFIN == "0")){
			if ((LK_Typ != "BEWEGLICH") || (!TestFIN)){
				if (abs(MOV_FL[2]) > abs(MOV_FL[5]))
					setstring ("Z_MOV", strpath, MOV_FL[2]);
				else
					setstring ("Z_MOV", strpath, MOV_FL[5]);
			}
			
			//if (TestFIN == "0")
			if (!TestFIN)
				setstring ("MOV_ALL", strpath, strMovAll);
		}
		else
		{
			if ((rh_typ == "FH" || rh_typ == "KH") && (getstring("MOV_HDW", strpath) != ""))
				setstring ("MOV_HDW", strpath, strMovAll);
			if (getstring("MOV_W", strpath) != "")
				setstring ("MOV_W", strpath, strMovAll);
			if (getstring("MOV_ALL", strpath) != "")
				setstring ("MOV_ALL", strpath, strMovAll);
		}
		
		// die Sollwege Auf/Ab sind für KH und FH gleich desshalb nur eine Auswertung nötig
		if ((FORMS.AUSWAHL_HAENGERGROESSE.IDC_SOLLWEG_KH_AUF)*1 > (FORMS.AUSWAHL_HAENGERGROESSE.IDC_SOLLWEG_KH_AB)*1)
			var FH_KH_MOV	= abs(FORMS.AUSWAHL_HAENGERGROESSE.IDC_SOLLWEG_KH_AUF)*1;
		else
			var FH_KH_MOV	= abs(FORMS.AUSWAHL_HAENGERGROESSE.IDC_SOLLWEG_KH_AB)*(-1);
		if ((LK_Typ != "EINZEL_LAGER") && (LK_Typ != "EINZEL_KLEMMSYSTEM"))
			setstring ("MOV_HANGER", strpath, FH_KH_MOV);
		
		if ((FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[2]*1 != 0) && ((LK_Typ != "EINZEL_LAGER") && (LK_Typ != "EINZEL_KLEMMSYSTEM")))
			setstring ("Z_TEST_LOAD", strpath, fround(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[2]*1,1));
		if ((FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[1]*1 != 0) && ((LK_Typ != "EINZEL_LAGER") && (LK_Typ != "EINZEL_KLEMMSYSTEM")))
			setstring ("Y_TEST_LOAD", strpath, fround(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[1]*1,1));
		if ((FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[0]*1 != 0) && ((LK_Typ != "EINZEL_LAGER") && (LK_Typ != "EINZEL_KLEMMSYSTEM")))
			setstring ("X_TEST_LOAD", strpath, fround(FORMS.SOLLWERTE_HALTERUNGSPUNKT.IDC_TABLE.ueberlast[0]*1,1));
		
		// jetzt noch der Stahlbau
		delete( "SECONDARY_STEEL", "DLGDATA.CA.FINDATA" );
		var SecSteelpath_FL = "DLGDATA.CA.SELECTION.TOPOCLASS.SONDERTEILE.PARTS";
		var SecSteelpath_FIN = "DLGDATA.CA.FINDATA.SECONDARY_STEEL";
		var SecSteelPartAnz = getstring("PART_ANZ", "DLGDATA.CA.SELECTION.TOPOCLASS.SONDERTEILE");
		
		var strAktuelleSprache = getlanguage();
		setstring("STEEL_COUNT ",	SecSteelpath_FIN,	SecSteelPartAnz);
		for (var i=0; i<SecSteelPartAnz; i++)
		{
			var m_Ptyp		= toupper(getstring("m_Ptyp", SecSteelpath_FL + "[" +i+ "].PART")); //noch zerlegen, um gezielt Werte zu suchen
			var strZahl		= "";
			var strTyp		= "";
			var strKlasse	= getstring("Typ", SecSteelpath_FL + "[" +i+ "].PART");
			var j = 0;
			while (j < m_Ptyp.length)
			{
				if ((m_Ptyp[j] >= '0') && (m_Ptyp[j] <= '9'))
					break;
				strTyp += m_Ptyp[j];
				j++;
			}
			while (j < m_Ptyp.length && ((m_Ptyp[j] >= '0' && m_Ptyp[j] <= '9') || m_Ptyp[j] == '.' || m_Ptyp[j] == 'X'))
			{
				strZahl += m_Ptyp[j];
				j++;
			}
			strZahl	= trimleft(trimright(strZahl, " "), " ");
			strTyp	= trimleft(trimright(strTyp, " "), " ");
			
			if (strKlasse == "BLE")
			{
				var STEEL_ART		=	"BOX";
				var STEEL_KLASS		=	"";
				var STEEL_TYP		=	"";
				var STEEL_MASS_X	=	getstring("RMBreite", SecSteelpath_FL + "[" +i+ "].PART");
				var STEEL_MASS_Y	=	getstring("RMLaenge", SecSteelpath_FL + "[" +i+ "].PART");
				var STEEL_MASS_Z	=	strZahl;
				var STEEL_MASS 		=	STEEL_MASS_X + ";" + STEEL_MASS_Y + ";" + STEEL_MASS_Z;
				var STEEL_WERK		=	getstring("m_Pwerkname", SecSteelpath_FL + "[" +i+ "].PART");
			}
			else if (strKlasse == "PRR")
			{
				var STEEL_ART		=	"CYLI";
				var STEEL_KLASS		=	"";
				var STEEL_TYP		=	"";
				var STEEL_MASS_dia	=	strZahl;
				var STEEL_MASS_len	=	getstring("RMLaenge", SecSteelpath_FL + "[" +i+ "].PART");
				var STEEL_MASS		=	STEEL_MASS_dia + ";" + STEEL_MASS_len;
				var STEEL_WERK		=	getstring("m_Pwerkname", SecSteelpath_FL + "[" +i+ "].PART");
			}
			else
			{
				var STEEL_ART		=	"SCTN";
				if (strKlasse == "PRT" && right(strTyp,1) != "P" && right(strTyp,1) != "T")
				{
					var STEEL_KLASS	=	"BEAM";
					if (left(strTyp, 1) == "H")
					{
						var strTypKorr	=	left(strTyp, 2);
						var strTypR		=	right(strTyp, 1);
					}
					else
					{
						var strTypKorr	=	strTyp;
						var strTypR		=	"";
					}
					var STEEL_TYP	=	"/DIN-SPEC/" + strTypKorr + strZahl + strTypR;
				}
				else if (strKlasse == "PRW")
				{
					var STEEL_KLASS	=	"ANG";
					var STEEL_TYP	=	"/DIN-SPEC/L" + strZahl;
				}
				else if (strKlasse == "PRX")
				{
					var STEEL_KLASS	=	"BOX";
					var STEEL_TYP	=	"/DIN-SPEC/RHS" + strZahl;
				}
				else if (strKlasse == "ROM")
				{
					var STEEL_KLASS	=	"TUBE";
					var STEEL_TYP	=	"/DIN-SPEC/OD" + tolower(strZahl);
				}
				else
				{
					var STEEL_KLASS	=	"DIN" + left(strTyp, 1);
					if (left(strTyp, 1) == "U")
						strTyp		= 	"UNP";
					var STEEL_TYP	=	"/DIN-SPEC/" + strTyp + strZahl;
				}
				var STEEL_MASS		=	getstring("RMLaenge", SecSteelpath_FL + "[" +i+ "].PART");
				var STEEL_WERK		=	getstring("m_Pwerkname", SecSteelpath_FL + "[" +i+ "].PART");
			}
			
			setstring("STEEL_ART " +i,		SecSteelpath_FIN, STEEL_ART);
			setstring("STEEL_KLASS " +i,	SecSteelpath_FIN, STEEL_KLASS);
			setstring("STEEL_TYP " +i,		SecSteelpath_FIN, STEEL_TYP);
			setstring("STEEL_MASS " +i,		SecSteelpath_FIN, STEEL_MASS);
			setstring("STEEL_WERK " +i,		SecSteelpath_FIN, STEEL_WERK);
		}
		
	},
	
	makeRequiredPipeOrient : function(orient, AchsInfo, AchsInfo2)
	{
		// leeren Richtungsvektor aufbauen
		orient = (trimright(getstring("pipeorient", "DLGDATA.CA.FINDATA.FINOBJECT.pipe"), " ")).split(" ");
		
		if (orient[0] == "")
		{
			for (var i = 0; i < 3; i++)
			{
				orient[i] = 0;
			}
			
			// Infos ueber Rohrrichtung sammaln
			var RSchraege_Alpha	=	getstring("SCHRAEG_ALPHA","DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK")*1;
			var RSchraege_Beta	=	getstring("SCHRAEG_BETA","DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK")*1;
			var RDreh		=	getstring("DrehungU", "DLGDATA.CA.SELECTION.TOPOCLASS")*1;
			var RVerlauf	=	getstring("IDC_ROHRVERLAUF", "DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK");
			
			// bestimme Hauptrichtung
			if (toupper(RVerlauf) == "VERTIKAL"){
				if (AchsInfo[0] == "X")
					orient[0] = 1;
				else if (AchsInfo[0] == "Y")
					orient[1] = 1;
				else
					orient[2] = 1;
				
			}
			else if ((toupper(RVerlauf) == "HORIZONTAL") && (RDreh == 90) && (RDreh == 180)){
				if (AchsInfo[0] == "X"){
					orient[0] = fround(tandeg(RSchraege_Alpha), 2);
					orient[1] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
					orient[2] = 1;
				}
				else if (AchsInfo[0] == "Y"){
					orient[0] = fround(tandeg(RSchraege_Alpha), 2);
					orient[1] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
					orient[2] = 1;
				}
				else {
					orient[0] = fround(tandeg(RSchraege_Alpha), 2);
					orient[1] = 1;
					orient[2] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
				}
			}
			else{
				if (AchsInfo[0] == "X"){
					orient[0] = fround(tandeg(RSchraege_Alpha), 2);
					orient[1] = 1;
					orient[2] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
				}
				else if (AchsInfo[0] == "Y"){
					orient[0] = 1;
					orient[1] = fround(tandeg(RSchraege_Alpha), 2);
					orient[2] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
				}
				else {
					orient[0] = 1;
					orient[1] = fround(tandeg(RSchraege_Alpha), 2);
					orient[2] = fround(1/cosdeg(RSchraege_Alpha)*tandeg(RSchraege_Beta), 2);
				}
			}
		}
		return orient;
	},
	
	showCadAction : function()
    {
        var index = getdlgvar("strIndex");  // beginnt ab 1
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        if (atoi(index) > 0)
        {
            var Source = Projectlist + "[" + (atoi(index) - 1) + "]";
            var pdfFile = getstring("CACHE_DRAWING_FILE_PDF", Source);

            if (pdfFile != "")
                shellexecuteex( pdfFile, "", "", 1 );    // show = 1
        }
	},

	makePlposDirtyAction : function()
    {
        var index = getdlgvar("strIndex");  // beginnt ab 1
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        if (atoi(index) > 0)
        {
            var Source = Projectlist + "[" + (atoi(index) - 1) + "]";
            setstring("CACHE_DRAWING_FILE_PDF", Source, "");
            setstring("CACHE_DRAWING_FILE_PDF_SAP", Source, "");
            setstring("CACHE_DRAWING_FILE_DXF", Source, "");
        }
	},

	makeAllposDirtyAction : function()
    {
        // Irgendwas wurde geändert --> Zeichnungs-Cache zurücksetzen
        var Source, i;
        var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var nLastPos = getsize(Projectlist, "") - 1;
        for (i = 0; i <= nLastPos; ++i)
        {
            Source = Projectlist + "[" + i + "]";
            setstring("CACHE_DRAWING_FILE_PDF_SAP", Source, "");
            setstring("CACHE_DRAWING_FILE_PDF", Source, "");
            setstring("CACHE_DRAWING_FILE_DXF", Source, "");
        }
	},

    writeStkFromProjectlistAction : function()
    {
        var pdmsManager;
        var Projectlist     = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
        var nLastPos	    = getsize(Projectlist, "") - 1;
        var Source;
        var Target          = "DLGDATA";
        var tmpCaMainController, strProductArea, strSAPcheck;
        var strPosNr;
        var i, nTransferCount = 0;
        var oLKinfo;
        var Datei;
		var msg = "";
        var strProjektName = getstring("PROJEKTNAME",  "PROJECT.SETTINGS");
        strProjektName = trimleft(strProjektName, " ");
        strProjektName = trimright(strProjektName, " ");
        strProjektName = replaceSpecialChars(strProjektName, {FuerCSV : 0, FuerDateiname : 1});
        if (strProjektName != "")
            strProjektName = strProjektName + "_";

        var strPresetOrdner = getstring("EXPORT_STK_VERZEICHNIS", "");
        var Ordner = dirdialog(translate("MSG_DLG_STK_EXPORT"), strPresetOrdner);   
        if (Ordner != "")
        {
            if (right(Ordner, 1) != "\\")
                Ordner += "\\";

            setstring("EXPORT_STK_VERZEICHNIS", "", Ordner);
		    var iniFilename = getinipath();
			writeinistring(iniFilename, "CA_SETTINGS", "EXPORT_STK_VERZEICHNIS", Ordner);

			for (i = 0; i <= nLastPos; ++i)
			{
				Source = Projectlist + "[" + i + "]";

				strProductArea = getstring("PRODUCT_AREA", Source);
				strSAPcheck    = getstring("SAP_CHECK", Source);
				strPosNr       = getstring("POS", Source);

				if (((strProductArea == "RH") || (strProductArea == "CA")) &&
					(strSAPcheck == "true"))
				{
					nTransferCount++;
					delete(Target, "");
					copy(Source, Target);

					// Er serialisiert sich automatisch aus dem aktuellen Dialogbereich rein:
					tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher
					pdmsManager = new CaPdmsManager(tmpCaMainController);

					// var Datei = filedialog(0, "stk", "cascade_"+strPosNr+".stk", "*.stk", "");
					oLKinfo      = tmpCaMainController.dataAccess.getLKinfoDaten();
					
					if (oLKinfo.markierung != "")
                    {
                        var strMarkierung = replaceSpecialChars(oLKinfo.markierung, {FuerCSV : 0, FuerDateiname : 1});
						Datei = Ordner + strMarkierung + ".STK";
                    }
					else
						Datei = Ordner + strProjektName + "POS_" + strPosNr + ".STK";

					if (Datei != "")
					{
						writefile( Datei, "\r\n", "wc" );   // Damit die Datei neu erzeugt wird
						pdmsManager.writeStkFromProjectlist(Datei);
					}
				}
				else if ((strProductArea == "FP") && (strSAPcheck == "true"))
				{
					nTransferCount++;
					delete(Target, "");
					copy(Source, Target);

					var strMarkierung = getstring("FP.MARKIERUNG", Target);
					pdmsManager = new CaPdmsManager(null);
					
					if (strMarkierung != "")
						Datei = Ordner + strMarkierung + ".STK";
					else
						Datei = Ordner + strProjektName + "POS_" + strPosNr + ".STK";

					if (Datei != "")
					{
						writefile( Datei, "\r\n", "wc" );   // Damit die Datei neu erzeugt wird
						pdmsManager.writeFreeStkFromProjectlist(Datei);
					}
				}
			}

			msg = nTransferCount + " " + translate("MSG_FILES_CREATED");
			if (nTransferCount <= 0)
				msg = translate("MSG_NOFILES_CREATED");
        }

        var response = {
            success : true,
            message : msg
        };

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },

    writeDokFromProjectlistAction : function()
    {
        var ProjectSettings = "PROJECT.SETTINGS";
        var response;
        var strAngebNr   = getstring("WI_ANGEBOTSNR",  ProjectSettings);
        if (strAngebNr == "")
            strAngebNr = "RH";
			
		//var TEST001		= getstddirectory( "TEMP" );
		strAngebNr		= replaceSpecialChars(strAngebNr, {FuerCSV : 0, FuerDateiname : 1});
        
		getdate('CURRENT_TIME','TEMP');
        var strDate     = getstring('TIME','TEMP.CURRENT_TIME');
        var strTagSAP   = getstring('DAY','TEMP.CURRENT_TIME');
        var strMonatSAP = getstring('MONTH','TEMP.CURRENT_TIME');
        if (strTagSAP.length <= 1)
            strTagSAP = "0" + strTagSAP;
        if (strMonatSAP.length <= 1)
            strMonatSAP = "0" + strMonatSAP;
        var strDateExport = getstring('YEAR','TEMP.CURRENT_TIME') + strMonatSAP + strTagSAP;
		var strUserExportPath  = getstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS");

		var Datei = filedialog(0, "xls", strAngebNr + "_" + strDateExport + "_MASS.xls", "*.xls", strUserExportPath);

        if (Datei != "")
		{
			var strAktuelleSprache = getlanguage();
			var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();
			if ((strSpracheKomm != "DE") && (strSpracheKomm != "EN"))
				strSpracheKomm = "EN";
            setlanguage(strSpracheKomm);
   		
			var dokManager = new CaDokManager(caMainController);
			if(dokManager.xmlSetFileOutput(Datei) == true)
				dokManager.writeDokFromProjectlist(1);

			setlanguage(strAktuelleSprache);
   
			response = {
				success : true,
				message : (dokManager.bError == false ? dokManager.msgOK : dokManager.msgError)
			};
        }
		else
		{
			response = {
				success : true,
				message : translate("MSG_OPERATION_CANCELED");
			};
		}

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },
	
	getHintForQuotAction : function()
	{
		var Com_Language	= getdlgvar('ComLang');
		var FL_Language		= getstring("EKCURRENTLANGUAGE", "");
		setlanguage(Com_Language);
		var Info	= "(" + translate("IDC_WI_PROJENDPREIS_VORGABE_LABEL") + ")";
		setlanguage(FL_Language);
		
		response = { success : true, message : Info };
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	writePruefFromProjectlistAction : function()
    {
		var strAuftragsnummer	= trimleft(trimright(getstring("WI_SAPNR","PROJECT.SETTINGS"), " "), " ");
		var strAngebotsnummer	= trimleft(trimright(getstring("WI_ANGEBOTSNR","PROJECT.SETTINGS"), " "), " ");
		var strTrennzeichenMark	= trimleft(trimright(getstring("WI_MARK_SIGN","PROJECT.SETTINGS"), " "), " ");
		var response	= {
						success : true,
						message : ""
					};
		var is_FH_KH	= false;
		var is_DYN		= false;
		if (strAuftragsnummer == "")
			response.success	= false;
		if (strAngebotsnummer == "")
			strAngebotsnummer = "AG";
		else
			strAngebotsnummer = replaceSpecialChars(strAngebotsnummer, {FuerCSV : 0, FuerDateiname : 1});
		if (strTrennzeichenMark == "")
			strTrennzeichenMark	= ",";	// Default -> leer führt zu Problemen ACHTUNG ";" nicht zulässig
		
		//var strLW			= "K:";				// Ernstfall
		var SchildPath		= FileName.getTempDir() + "\\";		// damit es weitergeht
		var AuftragPath		= SchildPath;
		var RTWWriteable	= false;
		var RUSWriteable	= false;
		var RTWExists		= getbool("RTWUser", "");
		var RUSExists		= getbool("RUSUser", "");
		//if (RTWExists){
		if (RTWExists || RUSExists){
			//var strLocation	= (RTWExists ? "Werdau" : "Ufa");	// wg. Testzwecken wird WDA bevorzugt
			//var strLocation	= (RTWExists ? "Zwickau" : "Ufa");	// wg. Testzwecken wird Z bevorzugt
			var strLocation	= getstring("UserLocation", "");
			
			var strSQLStatement = "select * from DATAPATH where LOCATION like '" + strLocation + "' order by abs(SEQ_ID) ";
			var numRet  = dbselect("CASCADE", strSQLStatement, "PATH");
			
			// wenn die Daten nicht geschrieben werden sollen, ist das Feld leer - das wird unten entschieden
			// hier werden die Temp-Pfade weiter genutzt, damit der Ablauf funktioniert
			if (dbgetstring("PATH", "SCHILD_PATH") != "")
				SchildPath	= dbgetstring("PATH", "SCHILD_PATH") + "\\";
			if (dbgetstring("PATH", "AUFTRAG_PATH") != "")
				AuftragPath	= dbgetstring("PATH", "AUFTRAG_PATH") + "\\";
			
			// ----------------------------------------
			// for Debugging only
			/*
			strSQLStatement		= "select * from DATAPATH where LOCATION like 'Ufa' order by abs(SEQ_ID) ";
			numRet				= dbselect("CASCADE", strSQLStatement, "PATH");
			if (dbgetstring("PATH", "SCHILD_PATH") != "")
				var SchildPath_RU	= dbgetstring("PATH", "SCHILD_PATH") + "\\";
			else
				var SchildPath_RU	= "Schildpfad_RU leer";
			
			if (dbgetstring("PATH", "AUFTRAG_PATH") != "")
				var AuftragPath_RU	= dbgetstring("PATH", "AUFTRAG_PATH") + "\\";
			else
				var AuftragPath_RU	= "Auftragspfad_RU leer";
			*/
			// ----------------------------------------
			
			// hier stehen zum Teil absolute aber auch Netzwerkpfade drin
			//var TEST = left(AuftragPath, 1);
			if (left(AuftragPath, 1) == "\\")
				AuftragPath	= "\\" + AuftragPath;
			if (left(SchildPath, 1) == "\\")
				SchildPath	= "\\" + SchildPath;
			
			writefile(SchildPath + "test.txt","", "wc");
			writefile(AuftragPath + "test.txt","", "wc");
			var bExists_S	= FileName.fileExists(SchildPath + "test.txt");
			var bExists_A	= FileName.fileExists(AuftragPath + "test.txt");
			
			if (bExists_S && bExists_A){
				//RTWWriteable	= true;
				RTWWriteable	= (strLocation == "Werdau" ? true : false);
				RUSWriteable	= (strLocation == "Ufa" ? true : false);
				FileName.deleteFile(SchildPath + "test.txt");
				FileName.deleteFile(AuftragPath + "test.txt");
				SchildPath		= FileName.getShortPath(SchildPath) + "S" + strAuftragsnummer + "\\";
				AuftragPath		= FileName.getShortPath(AuftragPath) + "A" + strAuftragsnummer + "\\";
				// wenn der Ordner bereits vorhanden ist wurden die Daten bereits mind. 1x erzeugt
				// diese Daten sichern wir in einem separaten Ordner (Timestamp)
				if (FileName.dirExists(SchildPath)){
					delete("TEMP.SCHILD", "");
					getdirectory(SchildPath + "*.*", "TEMP.SCHILD");
					getdate("CURRENT_TIME","TEMP");
					var Timestamp	= getstring("TIME", "TEMP.CURRENT_TIME").replace(".", "");
					for (var i = 0; i < getsize("TEMP.SCHILD", ""); i++){
						if (getstring("IS_DIRECTORY", "TEMP.SCHILD[" + i + "]") != "1"){
							// wenn eine zu sichernde Datei vorhanden ist
							// prüfen ob der Sicherungsordner existiert - wenn nicht -> anlegen
							if (!FileName.dirExists(SchildPath + Timestamp + "\\"))
								FileName.createDir(SchildPath + Timestamp + "\\");
							
							FILENAME = getstring("FILENAME", "TEMP.SCHILD[" + i + "]");
							FileName.moveFile(SchildPath + FILENAME, SchildPath + Timestamp + "\\" + FileName.getName(FILENAME) + ".old", false);
						}
					}
					delete("TEMP.SCHILD", "");
				}
			}
		}
		
		var strUserExportPath	= getstring("PROJECTPATH", "PROJECT");
		
		// wenn ein SharePoint Pfad vorhanden diesen nutzen
		// falls nicht wird automatisch der Pfad der WIT-Datei angesprungen
		// Schu - 20231024 -> Kann so nicht mehr nach SharePoint geschrieben werden
		/*
		var SharePointPath	= getstring("SharePointPath", "PROJECT.SETTINGS");
		SharePointPath		= SharePointPath.replace("https://portal.witzenmann.com", "//portal.witzenmann.com@SSL/DavWWWRoot");
		SharePointPath		= SharePointPath.replace("/", "\\");
		*/
		// Exportpfad neu belegen
		/*
		if (SharePointPath != ""){
			var TempPath	= SharePointPath.split("\\");
			var ShortLeng	= 0;
		}
		*/
		//else{
			var TempPath	= strUserExportPath.split("\\");
			var ShortLeng	= 1;
		//}
		strUserExportPath		= "";
		for (var a = 0; a < (TempPath.length - ShortLeng); a++){	
			strUserExportPath	+= TempPath[a] + "\\";
		}
		
		if (response.success){
			/*
			if ((SharePointPath != "") && (FileName.dirExists(strUserExportPath)))
				var Datei_HLIST	= strUserExportPath + "AUF_Haengerliste_" + strAuftragsnummer + ".csv";
			else
			*/
				var Datei_HLIST	= filedialog(0, "csv", "AUF_Haengerliste_" + strAuftragsnummer + ".csv", "*.csv", strUserExportPath);
			var Datei_MLIST	= FileName.getDir(Datei_HLIST) + "AUF_Markierungsliste_" + strAuftragsnummer + ".csv";
			var Datei_DLIST	= FileName.getDir(Datei_HLIST) + "AUF_Dynamikteilliste_" + strAuftragsnummer + ".csv";	// nur bei Bedarf rausschreiben
			writefile(Datei_HLIST, "", "wc");
			writefile(Datei_DLIST, "", "wc");
			var strError	= translate("MSG_FILES_CREATED") + "\n";
			var strErrorDyn	= "";
		}
		else{
			/*
			if ((SharePointPath != "")&& (FileName.dirExists(strUserExportPath)))
				var Datei_MLIST	= strUserExportPath + "Markierungsliste_" + strAngebotsnummer + ".csv";
			else
			*/
				var Datei_MLIST	= filedialog(0, "csv", "Markierungsliste_" + strAngebotsnummer + ".csv", "*.csv", strUserExportPath);
			var Datei_HLIST	= FileName.getDir(Datei_MLIST) + "Haengerliste_" + strAngebotsnummer + ".csv";		// die wird sowieso nicht geschrieben
			var Datei_DLIST	= FileName.getDir(Datei_MLIST) + "Dynamikteilliste_" + strAngebotsnummer + ".csv";	// die wird sowieso nicht geschrieben
			var strError	= "Keine SAP-Auftragsnummer eingetragen!" + "\n" + "Nur Markierungsliste erzeugt!" + "\n";
			var strErrorDyn	= "";
		}
		
		writefile(Datei_MLIST, "FL-Pos.;Markierung - IST;Markierung - SOLL;Trennzeichen;Anz-LK;Haenger pro LK;Max. Zeichen je Markierung;Zeichn.-Nr. - IST;Zeichn.-Nr. - SOLL;Bemerkung - IST;Bemerkung - SOLL;AnfragePos - IST;AnfragePos - SOLL;urspr. FL-Pos;Kd. Mat.-Nr.\r\n", "wc");
		
		var Projectlist 		= "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
		var nLastPos 			= getsize(Projectlist, "") - 1;
		
		var AnzahlSchilderGes	= 0;
		
		var Blockierung_FH		= (getstring("FH_BLOCKIERUNG", "PROJECT.SETTINGS.CASCADE")).split("_");
		Blockierung_FH			= Blockierung_FH[2];
		var Blockierung_KH		= (getstring("KH_BLOCKIERUNG", "PROJECT.SETTINGS.CASCADE")).split("_");
		Blockierung_KH			= Blockierung_KH[2];
		var LW_Proto_FH			= getbool("LASTWEG_PROT_FH", "PROJECT.SETTINGS.CASCADE");
		var LW_Proto_KH			= getbool("LASTWEG_PROT_KH", "PROJECT.SETTINGS.CASCADE");
		
		for (var i = 0; i <= nLastPos; ++i)
		{
			var ITEM		= Object.fromStorage(Projectlist+"["+i+"]");
			var strPosNr	= ITEM.POS;
			// Freie Positionen bekommen nie ein Schild - haben aber z.T. den Hängerstrang (warum auch immer)
			var isFP		= (ITEM.FP ? true : false);
			// nur was rausschreiben, wenn FH/FS/GFS oder KH/KS und Position "angehakt" und keine Freie Position
			/*
			if (((ITEM.CA.SELECTION.TOPOCLASS.Haenger && left(ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptypid, 2) != "SS") ||
				(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger && left(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptypid, 2) != "SS"))
				&& ITEM.SAP_CHECK == "true" && !isFP)
			*/
			// 20180308 - Schu - jetzt auch SSG und SSB
			var isSchild	= false;
			if ((ITEM.CA.SELECTION.TOPOCLASS.Haenger || ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger)
				&& ITEM.SAP_CHECK == "true" && !isFP)
				isSchild	= true;
			
			var strMarkierung		= (ITEM.FP.MARKIERUNG ? ITEM.FP.MARKIERUNG : ITEM.MARKIERUNG);
			var strBemerkung		= (ITEM.FP ? "" : ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_BEMERKUNGEN);
			var strZeichnungsnr		= (ITEM.FP.ZEICHNUNGSNR ? ITEM.FP.ZEICHNUNGSNR : ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR);
			var strAnfragePos		= (ITEM.FP ? "" : ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANFRAGEPOS);
			var strOriFlexPos		= (ITEM.FP ? ITEM.FP.IDC_ORIFLEXPOS : ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ORIFLEXPOS);
			// Achtung, wenn nicht zusammengefasst wurde ist das "undefined"
			if (typeof(strOriFlexPos) == "undefined" || strOriFlexPos == "")
				strOriFlexPos	= strPosNr;
			// Achtung bei Import von STK-Dateien über den eFIN-Import wird bis FL 5.0.564 die Markierung unter DLGDATA nicht gesetzt
			// das muss hier korrigiert werden, da sonst die Schilddatei bzw. Markierungsliste nicht stimmt
			if (trimleft(trimright(strMarkierung, " "), " ") == ""
				&& trimleft(trimright(ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR, " "), " ") != ""){
					strMarkierung	= trimleft(trimright(ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR, " "), " ");
					setstring		("MARKIERUNG", Projectlist+"["+i+"]", strMarkierung);
				}
			// -20171106 Schu- Kundenmaterialnummer (derzeit kein Rücklesen)
			var strKundenMatNr		= ITEM.CUSTOMER_CODE;
			
			if (isSchild && response.success){
				var year		= right(getstring("DATE", ""), 2);
				var year_compl	= right(getstring("DATE", ""), 4);
				if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
					var strHaengerArt	= toupper(ITEM.CA.SELECTION.TOPOCLASS.Haenger.__CLASSNAME__);
					if (left(ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptypid, 2) == "SS"){
						var strHaengerTyp	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptyp;
						strHaengerArt		= ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptypid;
					}
					else
						var strHaengerTyp	= left(ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptyp, ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Ptyp.length-6);
					var strNennweg		= ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg;
					var strHaengerGr	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.groesse;
					var strBlock		= (ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Pblock == "BLOCK_NEIN" ? "U" : "B");
					var strLGV			= ITEM.CA.SELECTION.TOPOCLASS.Haenger.lgv;
					if (left(strHaengerTyp, 2) == "SS")
						var strSchildTyp	= left(strHaengerTyp, 3);
					else
						var strSchildTyp	= (strHaengerArt == "FEDERHAENGER" ? "FH" + strNennweg : "KH");
					//var FRate			= ITEM.CA.SELECTION.TOPOCLASS.Haenger.federrate + (strSchildTyp != "FH50" ? "\\ N/mm" : "" );
					var FRate			= ITEM.CA.SELECTION.TOPOCLASS.Haenger.federrate;
					//var FRate_Text		= "Springrate";
					var FRate_Text		= "S-RATE";
				}
				else{
					var strHaengerArt	= toupper(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.__CLASSNAME__);
					if (left(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptypid, 2) == "SS"){
						var strHaengerTyp	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptyp;
						strHaengerArt		= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptypid;
					}
					else
						var strHaengerTyp	= left(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptyp, ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Ptyp.length-6);
					var strNennweg		= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg;
					var strHaengerGr	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.groesse;
					var strBlock		= (ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Pblock == "BLOCK_NEIN" ? "U" : "B");
					var strLGV			= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.lgv;
					if (left(strHaengerTyp, 2) == "SS")
						var strSchildTyp	= left(strHaengerTyp, 3);
					else
						var strSchildTyp	= (strHaengerArt == "FEDERHAENGER" ? "FH" + strNennweg : "KH");
					//var FRate			= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.federrate + (strSchildTyp != "FH50" ? "\\ N/mm" : "" );
					var FRate			= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.federrate;
					//var FRate_Text		= "Springrate";
					var FRate_Text		= "S-RATE";
				}
				// Leerzeichen müssen an den Controller mit "\ " übergeben werden -> sonst Fehler!!!
				strHaengerTyp	= strHaengerTyp.replace(" ", "\\ ");
				
				var strAnzahlHaengerPos	= (rfind(ITEM.CA.FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG, "DOPPEL") > 0 ? 2 : 1);
				var strAnzahlPos		= ITEM.QTY;
				var AnzahlSchilderPos	= strAnzahlHaengerPos * strAnzahlPos;
				var Schilder	= {};
				// Seriennummern der Hänger/Stützen für diese Position
				for (var j = 0; j < AnzahlSchilderPos; j++){
					Schilder.push(year + "/" + strAuftragsnummer + "/" + strPosNr + (AnzahlSchilderPos > 1 ? "/" + (j+1) : ""));
				}
				// Markierung der Hänger/Stützen für diese Position
				var MarkierungFlText	= [];		// Inhalt Textfeld Flexperte
				if (rfind(strMarkierung, strTrennzeichenMark) > 1)
					MarkierungFlText	= strMarkierung.split(strTrennzeichenMark);
				else
					MarkierungFlText.push(strMarkierung);
				var Markierung			= [];		// Markierung der Hänger/Stützen
				
				if (MarkierungFlText.length == Schilder.length)	// 1 Markierung je Hänger vorhanden
					Markierung			= MarkierungFlText;
				else if ((strAnzahlHaengerPos*1 == 2) && (((MarkierungFlText.length) * 2) == Schilder.length)){	// je 2 Hänger bekommen die gleiche Markierung (dopplte LK)
					for (var a = 0; a < MarkierungFlText.length; a++){
						Markierung.push(MarkierungFlText[a]);
						Markierung.push(MarkierungFlText[a]);
					}
				}
				// das muss nicht zwingend stimmen (lässt sich aber nicht prüfen)
				
				else if (MarkierungFlText.length == 1)	// alle Hänger bekommen die gleiche Markierung
					for (var a = 0; a < Schilder.length; a++){
						Markierung.push(MarkierungFlText[0]);
					}
				
				else if (MarkierungFlText.length*2 == Schilder.length){	// doppelt so viele Hänger wie Markierungen
					for (var a = 0; a < MarkierungFlText.length; a++){
						Markierung.push(MarkierungFlText[a]);
						Markierung.push(MarkierungFlText[a]);
					}
				}
				
				else if (MarkierungFlText.length < Schilder.length){	// Markierungsdaten ggf. unvollständig (mind. 2 Markierungen aber mind. 3 Hänger)
					for (var a = 0; a < MarkierungFlText.length; a++){
						Markierung.push(MarkierungFlText[a]);
					}
					for (; a < Schilder.length; a++){
						Markierung.push("");
					}
					strError	+= ansi2utf8("Markierung in Position " + strPosNr + " prüfen!" + "\n");
				}
				else{	// mehr Markierungen als Schilder
					for (var a = 0; a < Schilder.length; a++){
						Markierung.push("");
					}
					strError	+= ansi2utf8("Markierung in Position " + strPosNr + " nicht übernommen! Bitte prüfen!" + "\n");
				}
				// Bereinigen von Leerzeichen -> nur Leerzeichen ist keine Markierung
				for (var tmp = 0; tmp < Markierung.length; tmp++){
					Markierung[tmp]	= trimleft(trimright(Markierung[tmp], " "), " ");
					Markierung[tmp]	= Markierung[tmp].replace(" ", "\\ ");
				}
				
				// Auslesen der Prägeparameter für den Schildtyp
				var strSQLStatement = "select * from PraegParam where Schildtyp = '"+strSchildTyp+"' order by Zeilen ";
				var AnzZeilen		= dbselect("CASCADE", strSQLStatement, "PraegParam");
				var PraegeParam		= {};
				for (var z = 1; z <= AnzZeilen; z++){
					strSQLStatement = "select * from PraegParam where Schildtyp = '"+strSchildTyp+"' and abs(Zeilen) = "+z+" ";
					dbselect("CASCADE", strSQLStatement, "PraegParam");
					PraegeParam.push(dbgetstring("PraegParam", "X") + " "
									+ dbgetstring("PraegParam", "Y") + " "
									+ dbgetstring("PraegParam", "Z") + " "
									+ dbgetstring("PraegParam", "W") + " "
									+ dbgetstring("PraegParam", "H") + " "
									+ dbgetstring("PraegParam", "WINKEL") + " "
									+ dbgetstring("PraegParam", "RADIUS") + " "
									+ dbgetstring("PraegParam", "RAUM") + " "
									+ dbgetstring("PraegParam", "KRAFT") + " "
									+ dbgetstring("PraegParam", "QUALITAET") + " "
									+ dbgetstring("PraegParam", "FELD") + " \r\n"
									);
				}
				
				strSQLStatement = "select * from Typenschild ";
				dbselect("CASCADE", strSQLStatement, "Typenschild");
				var SchildLengthMax	= dbgetdouble("Typenschild", (strSchildTyp == "FH50" ? "FH050" : strSchildTyp)) + 1;
				var bOK_Mark	= true;
				var bOK_SerNr	= true;
				
				if (strHaengerArt == "FEDERHAENGER")
				{
					is_FH_KH	= true;
					if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
						var strSQLStatement = "select * from HYDRAFED where LASTGROESSE = '"+strHaengerGr+"' and NENNWEG = '"+strNennweg+"' ";
						var numRet			= dbselect("CASCADE", strSQLStatement, "HYDRAFED");
						var strMinLast		= dbgetstring("HYDRAFED", "MINLAST");
						var strMaxLast		= dbgetstring("HYDRAFED", "MAXLAST");
						if (ITEM.CA.SELECTION.TOPOCLASS.Haenger.kaltlast * 1 < 10)
							var Nachkomma	= 2;
						else if (ITEM.CA.SELECTION.TOPOCLASS.Haenger.kaltlast * 1 < 100)
							var Nachkomma	= 1;
						else
							var Nachkomma	= 0;
						var strKaltlast		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.kaltlast, Nachkomma);
						var strWarmLast1	= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.warmlast, Nachkomma);
						var strWarmLast2	= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.warmlast2, Nachkomma);
						var strBlockPos		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.vorspann, 0);
						var strWarmPos1		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.res_oben, 0);
						var strWarmPos2		= strNennweg*1 - fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.res_unten, 0);
						var strSollweg1		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.sollweg*1, 0);
						// Achtung bei Import von STK-Dateien über den eFIN-Import wird bis FL 5.0.564 der Sollweg mit "0" belegt
						// das muss hier korrigiert werden, da sonst die Hängerliste und die Prüfmaschine nicht stimmt
						//if (strSollweg1 == 0 && (strKaltlast != strWarmLast1 || strKaltlast != strWarmLast2)){	// in diesem Fall muss es eine Bewegung geben
						if (strSollweg1 == 0 && (strKaltlast != strWarmLast1 || (strKaltlast != strWarmLast2 && strWarmLast2 != 0))){
							if (strKaltlast != strWarmLast1 && !strWarmLast2*1 ){	// nur eine Bewegungsrichtung
								strSollweg1	= (strKaltlast > strWarmLast1 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast1)*1000 / FRate , 0);
							}
							else if (abs(strKaltlast-strWarmLast1) > abs(strKaltlast-strWarmLast2)){
								strSollweg1	= (strKaltlast > strWarmLast1 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast1)*1000 / FRate , 0);
							}
							else{
								strSollweg1	= (strKaltlast > strWarmLast2 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast2)*1000 / FRate , 0);
							}
						}
						if (!strWarmLast2*1 ||
							fround(strNennweg - (strWarmPos1 + abs(strSollweg1) + fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.res_unten, 0)), 0)*1 < 2)
						{
							var strSollweg2		= "";
							var strWarmLastGes	= strWarmLast1;
						}
						else
						{
							var strSollweg2		= "/" + fround(strNennweg - (strWarmPos1 + abs(strSollweg1) + fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.res_unten, 0)), 0);
							var strWarmLastGes	= strWarmLast1 + "/" + strWarmLast2;
						}
						var strSollweg		= abs(strSollweg1) + strSollweg2;
						if (strSollweg1 < 0)
							var strBewRicht	= "ab" + (strSollweg2 == "" ? "" : "/auf");
						else
							var strBewRicht	= "auf" + (strSollweg2 == "" ? "" : "/ab");
					}
					else{
						var strSQLStatement = "select * from HYDRAFED where LASTGROESSE = '"+strHaengerGr+"' and NENNWEG = '"+strNennweg+"' ";
						var numRet			= dbselect("CASCADE", strSQLStatement, "HYDRAFED");
						var strMinLast		= dbgetstring("HYDRAFED", "MINLAST");
						var strMaxLast		= dbgetstring("HYDRAFED", "MAXLAST");
						if (ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.kaltlast * 1 < 10)
							var Nachkomma	= 2;
						else if (ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.kaltlast * 1 < 100)
							var Nachkomma	= 1;
						else
							var Nachkomma	= 0;
						var strKaltlast		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.kaltlast, Nachkomma);
						var strWarmLast1	= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.warmlast, Nachkomma);
						var strWarmLast2	= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.warmlast2, Nachkomma);
						var strBlockPos		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.vorspann, 0);
						var strWarmPos1		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.res_oben, 0);
						var strWarmPos2		= strNennweg*1 - fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.res_unten, 0);
						var strSollweg1		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.sollweg*1, 0);
						// Achtung bei Import von STK-Dateien über den eFIN-Import wird bis FL 5.0.564 der Sollweg mit "0" belegt
						// das muss hier korrigiert werden, da sonst die Hängerliste und die Prüfmaschine nicht stimmt
						// Achtung der Sollweg kann auch wirklich "0" sein
						//if (strSollweg1 == 0 && (strKaltlast != strWarmLast1 || strKaltlast != strWarmLast2)){	// in diesem Fall muss es eine Bewegung geben
						if (strSollweg1 == 0 && (strKaltlast != strWarmLast1 || (strKaltlast != strWarmLast2 && strWarmLast2 != 0))){	// in diesem Fall muss es eine Bewegung geben
							if (strKaltlast != strWarmLast1 && !strWarmLast2*1 ){	// nur eine Bewegungsrichtung
								strSollweg1	= (strKaltlast > strWarmLast1 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast1)*1000 / FRate , 0);
							}
							else if (abs(strKaltlast-strWarmLast1) > abs(strKaltlast-strWarmLast2)){
								strSollweg1	= (strKaltlast > strWarmLast1 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast1)*1000 / FRate , 0);
							}
							else{
								strSollweg1	= (strKaltlast > strWarmLast2 ? (1) : (-1)) * fround(abs(strKaltlast - strWarmLast2)*1000 / FRate , 0);
							}
						}
						if (!strWarmLast2*1 ||
							fround(strNennweg - (strWarmPos1 + abs(strSollweg1) + fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.res_unten, 0)), 0)*1 < 2)
						{
							var strSollweg2		= "";
							var strWarmLastGes	= strWarmLast1;
						}
						else
						{
							var strSollweg2		= "/" + fround(strNennweg - (strWarmPos1 + abs(strSollweg1) + fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.res_unten, 0)), 0);
							var strWarmLastGes	= strWarmLast1 + "/" + strWarmLast2;
						}
						var strSollweg		= abs(strSollweg1) + strSollweg2;
						if (strSollweg1 < 0){
							var strBewRicht		= "ab" + (strSollweg2 == "" ? "" : "/auf");
							var strSollwegDown	= abs(strSollweg1) + "";
							var strSollwegUp	= abs(strSollweg2.replace("/", "")) + "";
							var strWarmLastDown	= abs(strWarmLast1) + "";
							var strWarmLastUp	= (abs(strWarmLast2) != 0 ? abs(strWarmLast2) : abs(strKaltlast)) + "";
						}
						else{
							var strBewRicht	= "auf" + (strSollweg2 == "" ? "" : "/ab");
							var strSollwegUp	= abs(strSollweg1) + "";
							var strSollwegDown	= abs(strSollweg2.replace("/", "")) + "";
							var strWarmLastUp	= abs(strWarmLast1) + "";
							var strWarmLastDown	= (abs(strWarmLast2) != 0 ? abs(strWarmLast2) : abs(strKaltlast)) + "";
						}
					}
					// bei nur einer Bewegungsrichtung ist eine Warmposition gleich der Blockposition -> nicht relevant
					// ACHTUNG durch die gerundeten Werte ergeben sich manchmal Differenzen!!!
					// OLD:
					/*
					var strEndlWarm	= "";
					if (strWarmPos1 == strBlockPos)
						strWarmPos1	= "-";
					else
						strEndlWarm	= strWarmPos1;
					if (strWarmPos2 == strBlockPos)
						strWarmPos2	= "-";
					else
						strEndlWarm	+= (strEndlWarm != "" ? "/" + strWarmPos2 : strWarmPos2);
					*/
					// NEW (20150513):
					var strEndlWarm	= "";
					//var TEST	= strBewRicht.length;
					if (abs(strWarmPos1 - strBlockPos) <= 1 && strBewRicht.length <= 3)
						strWarmPos1	= "-";
					else
						strEndlWarm	= strWarmPos1;
					if (abs(strWarmPos2 - strBlockPos) <= 1 && strBewRicht.length <= 3)
						strWarmPos2	= "-";
					else
						strEndlWarm	+= (strEndlWarm != "" ? "|" + strWarmPos2 : strWarmPos2);
					// ACHTUNG wenn man das so macht gibt "ab" auch "1"
					// OLD:
					/*
					var Richtungsfaktor	= (strBewRicht == "ab/auf" ? 0 : 1);
						if (Richtungsfaktor && strSollweg1 < 0)
							Richtungsfaktor = 1;
					*/
					// NEW (20150513):
					var Richtungsfaktor	= 1;			// default "auf"
					if (left(strBewRicht, 2) == "ab")
						Richtungsfaktor	= 0;
					
					if (RUSExists){
						var RichtungsfaktorRUS	= Richtungsfaktor;
						if (abs(strSollwegDown) != 0 && abs(strSollwegUp) != 0)
							RichtungsfaktorRUS	= 2;
					}
					
					// noch die variablen X-Positionen setzen
					PraegeParam[1]	= PraegeParam[1].replace("X_FKALT", strBlockPos*10 + 75 + 15);	// "+15" -> halbe Texthöhe
					PraegeParam[2]	= PraegeParam[2].replace("X_PFEIL", strBlockPos*10 + 75 + 15);
					
					if (!FileName.dirExists(SchildPath))	// wenn nicht da -> anlegen
						var bOk = FileName.createDir(SchildPath);
					//if (!FileName.dirExists(AuftragPath) && LW_Proto_FH)	// wenn nicht da und notwendig -> anlegen
					if (!FileName.dirExists(AuftragPath) && (LW_Proto_FH || RUSExists))	// wenn nicht da und notwendig -> anlegen
						var bOk = FileName.createDir(AuftragPath);
					
					for (var j = 0; j < AnzahlSchilderPos; j++){
						if (Markierung[j].length > SchildLengthMax){
							strError	+= "Markierung in Pos. " + strPosNr + "/" + (j+1) + " zu lang! Keine Daten erzeugt!\n";
							bOK_Mark	= false;
						}
						if (Schilder[j].length > SchildLengthMax){
							strError	+= "Seriennummer in Pos. " + strPosNr + "/" + (j+1) + " zu lang! Keine Daten erzeugt!\n";
							bOK_SerNr	= false;
						}
						if (bOK_Mark && bOK_SerNr){
							// Schilddaten nur RTW
							if (RTWExists){
								//writefile(	SchildPath + "S_" + strSchildTyp + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) + "_" : "_") + strAuftragsnummer + ".txt",
								writefile(	SchildPath + "S_" + strSchildTyp + "_" + strPosNr + "_" + (j+1) + "_" + strAuftragsnummer + ".sic",
										"NEWFILE 5 7 1 FH\r\n"
										+ "INSERTTEXTLINE " + PraegeParam[0].replace("Fmin", strMinLast)
										+ (Blockierung_FH == "BLOCKNEIN" ? "" : "INSERTTEXTLINE " + PraegeParam[1].replace("Fkalt", strKaltlast))
										+ (Blockierung_FH == "BLOCKNEIN" ? "" : "INSERTTEXTLINE " + PraegeParam[2].replace("Pfeil", "<-"))
										+ "INSERTTEXTLINE " + PraegeParam[3].replace("Fmax", strMaxLast)
										//+ (strSchildTyp == "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[4].replace("FRate_Text", FRate_Text))
										//+ (strSchildTyp == "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[5].replace("FRate_Wert", FRate))
										//+ (strSchildTyp != "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[6].replace("FRate_Einh", "N/mm"))
										+ "INSERTTEXTLINE " + PraegeParam[7].replace("Typ", strHaengerTyp)
										+ "INSERTTEXTLINE " + PraegeParam[8].replace("SerNr", Schilder[j])
										+ (Markierung[j] == "" ? "" : "INSERTTEXTLINE " + PraegeParam[9].replace("Mark", Markierung[j]))
										//+ (strSchildTyp != "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[10].replace("FRate_Text_Z4", FRate_Text))
										//+ (strSchildTyp != "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[11].replace("FRate_Wert_Z4", FRate))
										//+ (strSchildTyp != "FH50" ? "" : "INSERTTEXTLINE " + PraegeParam[12].replace("FRate_Einh_Z4", "N/mm")),
										+ "INSERTTEXTLINE " + PraegeParam[10].replace("FRate_Text_Z4", FRate_Text)
										+ "INSERTTEXTLINE " + PraegeParam[11].replace("FRate_Wert_Z4", FRate)
										+ "INSERTTEXTLINE " + PraegeParam[12].replace("FRate_Einh_Z4", "N/mm"),
										"wc");
							}
							// File für Prüfmaschine - wenn notwendig -> Prüfmaschine braucht Komma nicht Punkt als Dezimaltrennzeichen
							//if (LW_Proto_FH){
							// Fall RTW
							if (LW_Proto_FH && RTWExists){
								writefile(	AuftragPath + "A_" + strAuftragsnummer + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) : "_0") + ".txt",
											"Haenger-Typ;Lastgroesse ();Nennweg (mm);"
											+ "Kaltlast (kN);Sollweg (mm);unten/oben Richtungsfaktor ();"
											+ "Federkennzahl ();Zeichnungsnummer ();Besteller ();Bestellnr. ();"
											+ "Anlage/Projekt;Anlagen.-Pos. ();Kommision ();HYDRA-Position ()\r\n"
											+ left(strHaengerTyp, 3) + ";"
											+ strHaengerGr + ";"
											+ strNennweg + ";"
											+ strKaltlast.replace(".",",") + ";"
											+ strSollweg.replace(".",",") + ";"	// Sollweg
											+ Richtungsfaktor + ";"	// Richtungsfaktor
											+ ";"	// Federkennzahl bleibt leer
											+ ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + ";"	// Zeichnungsnummer
											+ getstring("FIRMENNAME_VON", "PROJECT.SETTINGS") + ";"	// Besteller
											+ getstring("ANFRAGENR", "PROJECT.SETTINGS") + ";"	// Bestellnummer
											+ getstring("PROJEKTNAME", "PROJECT.SETTINGS") + " / " + getstring("WI_SYSTEM", "PROJECT.SETTINGS")  + ";"	// Anlage/Projekt
											+ Markierung[j].replace("\\ ", " ") + ";"
											+ strAuftragsnummer + " (" + Schilder[j] + ");"
											+ strPosNr + (AnzahlSchilderPos*1>1 ? "/" + (j+1) : "")
											+ "\r\n",
											"wc");
							}
							// Fall RUS
							//if (LW_Proto_FH && RUSExists){
							// Hier werden die FH-Daten immer benötigt!!!
							if (RUSExists){
								// Sprache noch setzen
								// Hier die Sprache Kommunikation benutzen, nicht die GUI-Sprache
								var strAktuelleSprache = getlanguage();
								var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();
								setlanguage(strSpracheKomm);
								
								var strHName	= "";
								if (left(strHaengerTyp, 3) == "FHG")
									strHName	= translate("ID_CA_ARTIKEL_FH") + " " + translate("ID_CA_ARTIKEL_M_GEWINDEANSCHLUSS");
								else if (left(strHaengerTyp, 3) == "FHD")
									strHName	= translate("ID_CA_ARTIKEL_FH_DOPPELLA");
								else if (left(strHaengerTyp, 3) == "FHS")
									strHName	= translate("ID_CA_ARTIKEL_FH");
								else if (left(strHaengerTyp, 3) == "FDT")
									strHName	= translate("ID_CA_ARTIKEL_FDT");
								else if (left(strHaengerTyp, 2) == "FS")
									strHName	= translate("ID_CA_ARTIKEL_FS");
								else if (left(strHaengerTyp, 3) == "FSG")
									strHName	= translate("ID_CA_ARTIKEL_FSG");
								
								setlanguage(strAktuelleSprache);
									
								writefile(	AuftragPath + "A_" + strAuftragsnummer + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) : "_0") + "_RU.txt",
											"Haenger-Typ (); Haenger-Name ();Lastgroesse ();Nennweg (mm);Lastgruppe ();"
											+ "Nennlast (kN);Anfangslast (kN);Federrate (N/mm);Kaltlast (kN);"
											+ "Sollweg auf (mm);Sollweg ab (mm);unten/oben Richtungsfaktor ();"
											+ "Warmlast auf (kN);Warmlast ab (kN);Federkennzahl ();Zeichnungsnummer ();"
											+ "Besteller ();Bestellnr. ();Anlage/Projekt;Anlagen.-Pos. ();Kommision ();"
											+ "HYDRA-Position ()\r\n"
											+ left(strHaengerTyp, 3) + ";"
											+ strHName + ";"
											+ strHaengerGr + ";"
											+ strNennweg + ";"
											+ strLGV + ";"
											+ strMaxLast + ";"
											+ strMinLast + ";"
											+ FRate + ";"
											+ strKaltlast.replace(".",",") + ";"
											+ strSollwegUp + ";"
											+ strSollwegDown + ";"
											+ RichtungsfaktorRUS + ";"
											+ strWarmLastUp + ";"
											+ strWarmLastDown + ";"
											+ ";"	// Federkennzahl bleibt leer
											+ ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + ";"	// Zeichnungsnummer
											+ getstring("FIRMENNAME_VON", "PROJECT.SETTINGS") + ";"	// Besteller
											+ getstring("ANFRAGENR", "PROJECT.SETTINGS") + ";"	// Bestellnummer
											+ getstring("PROJEKTNAME", "PROJECT.SETTINGS") + " / " + getstring("WI_SYSTEM", "PROJECT.SETTINGS")  + ";"	// Anlage/Projekt
											+ Markierung[j].replace("\\ ", " ") + ";"
											+ strAuftragsnummer + " (" + Schilder[j] + ");"
											+ strPosNr + (AnzahlSchilderPos*1>1 ? "/" + (j+1) : "")
											+ "\r\n",
											"wc");
							}
							writefile( //strUserExportPath + "Hängerliste.csv",
										Datei_HLIST,
										+ strPosNr+"/"+(AnzahlSchilderPos*1>1 ? j+1 : "0") + ";"
										+ (j>0 ? "" : strAnzahlPos) + ";"
										+ (j>0 ? "" : strAnzahlHaengerPos) + ";"
										+ left(strHaengerTyp, 3) + ";"
										+ strHaengerGr + ";"
										+ strNennweg + ";"
										+ strKaltlast.replace(".",",") + ";"
										+ strWarmLastGes.replace(".",",") + ";"
										//+ strWarmLast1.replace(".",",") + "/" + strWarmLast2.replace(".",",") + ";"
										+ strSollweg + ";"
										+ strBewRicht + ";"
										+ strBlockPos + ";"
										+ strEndlWarm + ";"
										//+ "=RC[-1]+RC[-2]" + ";"
										+ (LW_Proto_FH ? "" : utf8toansi("kein Prüfprot. f. FH")) + ";"
										+ ";"
										+ ";"
										+ strBlock + ";"
										+ Markierung[j].replace("\\ ", " ") + ";"
										+ strLGV + ";"
										+ Schilder[j]
										+ "\r\n",
										"a");
						}
					}
				}
				else if (strHaengerArt == "KONSTANTHAENGER")
				{
					is_FH_KH	= true;
					if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
						var strEinstellLast	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.sollast;
						var strWegAb		= fround(abs(ITEM.CA.SELECTION.TOPOCLASS.Haenger.sollweg_ab), 0);
						var strWegAuf		= fround(abs(ITEM.CA.SELECTION.TOPOCLASS.Haenger.sollweg_auf), 0);
						var strBlockPos		= fround((ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg*1 - (strWegAb + strWegAuf)) / 2 + strWegAuf , 0);
						var strWarmPos1		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.weg_res , 0);
						var strWarmPos2		= fround(ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg*1 - ITEM.CA.SELECTION.TOPOCLASS.Haenger.weg_res*1 , 0);
					}
					else{
						var strEinstellLast	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.sollast;
						var strWegAb		= fround(abs(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.sollweg_ab), 0);
						var strWegAuf		= fround(abs(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.sollweg_auf), 0);
						var strBlockPos		= fround((ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg*1 - (strWegAb + strWegAuf)) / 2 + strWegAuf , 0);
						var strWarmPos1		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.weg_res , 0);
						var strWarmPos2		= fround(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg*1 - ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.weg_res*1 , 0);
					}
					
					var strGesArbWeg	= strWegAb + strWegAuf;
					
					var strSkalTeil		= fround(strBlockPos * 100 / strNennweg, 0);
					
					if (strEinstellLast*1 < 10)
						strEinstellLast	= fround(strEinstellLast*1 , 2);
					else if (strEinstellLast*1 < 100)
						strEinstellLast	= fround(strEinstellLast*1 , 1);
					else
						strEinstellLast	= fround(strEinstellLast*1 , 0);
					
					var strSollweg			= "";
					var strBewRicht			= "";
					var Richtungsfaktor		= 0;	// WDA "2 Bewegungsrichtungen"
					var RichtungsfaktorRUS	= 0;	// RUS "Weg ab"
					if (strWegAb > 0){
						strSollweg			+= strWegAb + (strWegAuf > 0 ? "/" : "");
						strBewRicht			= "ab" + (strWegAuf > 0 ? "/" : "");
						Richtungsfaktor		= (-1);
						//RichtungsfaktorRUS	= 1;
					}
					if (strWegAuf > 0){
						strSollweg			+= strWegAuf;
						strBewRicht			+= "auf";
						Richtungsfaktor		= (!Richtungsfaktor ? 1 : 0);	// bei 2 Bewegungsrichtungen wird Richtungsfaktor "0"
						RichtungsfaktorRUS	= (strWegAb > 0 ? 2 : 1);
					}
					
					// bei nur einer Bewegungsrichtung ist eine Wanmposition gleich der Blockposition -> nicht relevant
					// ACHTUNG durch die gerundeten Werte ergeben sich manchmal Differenzen!!!
					// OLD:
					/*
					var strEndlWarm	= "";
					if (strWarmPos1 == strBlockPos)
						strWarmPos1	= "-";
					else
						strEndlWarm	+= strWarmPos1 + "/" + fround(strWarmPos1 * 100 / strNennweg, 0) + "|";
					if (strWarmPos2 == strBlockPos)
						strWarmPos2	= "-";
					else
						strEndlWarm	+= strWarmPos2 + "/" + fround(strWarmPos2 * 100 / strNennweg, 0);
					*/
					// NEW (20150513):
					var strEndlWarm	= "";
					if (abs(strWarmPos1 - strBlockPos) <= 1 && strBewRicht != "ab/auf")
						strWarmPos1	= "-";
					else
						strEndlWarm	+= strWarmPos1 + "/" + fround(strWarmPos1 * 100 / strNennweg, 0) + (strBewRicht == "ab/auf" ? "|" : "");
					if (abs(strWarmPos2 - strBlockPos) <= 1 && strBewRicht != "ab/auf")
						strWarmPos2	= "-";
					else
						strEndlWarm	+= strWarmPos2 + "/" + fround(strWarmPos2 * 100 / strNennweg, 0);
					
					// Berechnung der KH-spez. Werte Lastjust.-skala, Abst. Justierachse (a), Abst. Federteller (XF0)
					// benötigte DB-Werte
					var strSQLStatement = "select * from KH_DATEN_LW where abs(GR) = "+atoi(strHaengerGr)+" ";
					var numRet			= dbselect("CASCADE", strSQLStatement, "KH_DATEN_LW");
					var Fmax200			= dbgetdouble("KH_DATEN_LW", "FMAX200");
					var aErf_Fmax		= dbgetdouble("KH_DATEN_LW", "AERF_FMAX");
					var aErf_Fmin		= dbgetdouble("KH_DATEN_LW", "AERF_FMIN");
					var aErf_115Fmax	= dbgetdouble("KH_DATEN_LW", "AERF_115");
					var aErf_085Fmin	= dbgetdouble("KH_DATEN_LW", "AERF_085");
					var L_Zuglasche		= dbgetdouble("KH_DATEN_LW", "L_ZL");
					var h				= dbgetdouble("KH_DATEN_LW", "H");
					var L0_Feder		= dbgetdouble("KH_DATEN_LW", "FED_L0");
					var R_Feder			= dbgetdouble("KH_DATEN_LW", "FED_R");
					
					var strMaxLast		= Fmax200 * ( 200 / strNennweg);
					if (strMaxLast < 10)
						strMaxLast	= fround(strMaxLast, 2);
					else if (strMaxLast < 100)
						strMaxLast	= fround(strMaxLast, 1);
					else
						strMaxLast	= fround(strMaxLast, 0);
					
					var strSQLStatement = "select * from KH_DATEN_FSR where abs(GR) = "+atoi(strHaengerGr)+" ";
					var numRet			= dbselect("CASCADE", strSQLStatement, "KH_DATEN_FSR");
					if (left(strHaengerTyp, 3) != "KVS")
						var LT_Stern	= dbgetdouble("KH_DATEN_FSR", "LT_STERN");
					else
						var LT_Stern	= dbgetdouble("KH_DATEN_FSR", "LT_STERN_KVS");
					
					// Bestimmung von Abst. Justierachse (a)
					var Fbl_Fmax	= strEinstellLast*1/(Fmax200*200/(strNennweg*1));
					if (Fbl_Fmax < 0.58){
						var Faktor		= (aErf_Fmin - aErf_085Fmin) / (0.58 - 0.493);
						var AbJustAchse	= fround(aErf_085Fmin + Faktor * (Fbl_Fmax - 0.493) , 0);
					}
					else if (Fbl_Fmax < 1){
						var Faktor		= (aErf_Fmax - aErf_Fmin) / (1 - 0.58);
						var AbJustAchse	= fround(aErf_Fmin + Faktor * (Fbl_Fmax - 0.58) , 0);
					}
					else{
						var Faktor		= (aErf_115Fmax - aErf_Fmax) / (1.15 - 1);
						var AbJustAchse	= fround(aErf_Fmax + Faktor * (Fbl_Fmax - 1) , 0);
					}
					// Bestimmung Abst. Federteller (XF0)
					var Winkel	= asindeg((h - AbJustAchse * cosdeg(5)) / L_Zuglasche);
					var F_F0	= strEinstellLast*1 * strNennweg*1 / AbJustAchse * cosdeg(Winkel) * sindeg(60) / cosdeg(5 - Winkel);
					var Del_F0	= F_F0 * 1000 / R_Feder;
					var L_F0	= L0_Feder - Del_F0;
					var XF0		= fround(LT_Stern - L_F0 , 0);
					
					// Bestimmung Lastjust.Skala
					var Fbl_Fmax_115	= strEinstellLast * 1.15 / (Fmax200 * 200 / (strNennweg*1));
					var strSQLStatement = "select * from KH_DATEN_FKORR where abs(PROZ) <= " + Fbl_Fmax_115*100 + " ";
					var numRet			= dbselect("CASCADE", strSQLStatement, "KH_DATEN_FKORR");
					strSQLStatement		= "select * from KH_DATEN_FKORR where abs(PROZ) <= " + Fbl_Fmax_115*100 + " AND abs(SEQ_ID) = " + numRet + " ";
					numRet				= dbselect("CASCADE", strSQLStatement, "KH_DATEN_FKORR");
					var Fkorr_115		= dbgetdouble("KH_DATEN_FKORR", "KORR");
					
					var Fbl_Fmax_085	= strEinstellLast * 0.85 / (Fmax200 * 200 / (strNennweg*1));
					
					var Faktor_115		= (aErf_115Fmax - aErf_085Fmin) / (1.15 - 0.493) * Fkorr_115;
					var Faktor_085		= (aErf_115Fmax - aErf_085Fmin) / (1.15 - 0.493);
					
					var a_115			= aErf_Fmin + Faktor_115 * (Fbl_Fmax_115 - 0.58);
					var a_085			= aErf_085Fmin + Faktor_085 * (Fbl_Fmax_085 - 0.493);
					
					var Del_F0_115		= a_115 - AbJustAchse;
					var Del_F0_085		= a_085 - AbJustAchse;
					
					var TempWert		= (strHaengerGr*1 > 7 ? 1.1 : 1.14) * (abs(Del_F0_115) + abs(Del_F0_085)) / 2
					var strSQLStatement = "select * from KH_DATEN_LJSK where abs(MM_15PR) <= " + TempWert + " ";
					var numRet			= dbselect("CASCADE", strSQLStatement, "KH_DATEN_LJSK");
					strSQLStatement		= "select * from KH_DATEN_LJSK where abs(MM_15PR) <= " + TempWert + " AND abs(SEQ_ID) = " + numRet + " ";
					numRet				= dbselect("CASCADE", strSQLStatement, "KH_DATEN_LJSK");
					
					var Skala			= dbgetstring("KH_DATEN_LJSK", "SKALA");
					
					if (!FileName.dirExists(SchildPath))
						var bOk = FileName.createDir(SchildPath);
					if (!FileName.dirExists(AuftragPath))	// KH hat immer LW-Protokoll auch wenn LW_Proto_KH false ist
						var bOk = FileName.createDir(AuftragPath);
					
					for (var j = 0; j < AnzahlSchilderPos; j++){
						if (Markierung[j].length > SchildLengthMax){
							strError	+= "Markierung in Pos. " + strPosNr + "/" + (j+1) + " zu lang! Keine Daten erzeugt!\n";
							bOK_Mark	= false;
						}
						if (Schilder[j].length > SchildLengthMax){
							strError	+= "Seriennummer in Pos. " + strPosNr + "/" + (j+1) + " zu lang! Keine Daten erzeugt!\n";
							bOK_SerNr	= false;
						}
						if (bOK_Mark && bOK_SerNr){
							// Schilddaten nur RTW
							if (RTWExists){
							//writefile(	SchildPath + "S_" + strSchildTyp + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) + "_" : "_") + strAuftragsnummer + ".txt",
							writefile(	SchildPath + "S_" + strSchildTyp + "_" + strPosNr + "_" + (j+1) + "_" + strAuftragsnummer + ".sic",
										"NEWFILE 5 7 1 KH\r\n"
										+ "INSERTTEXTLINE " + PraegeParam[0].replace("Typ", strHaengerTyp)
										+ "INSERTTEXTLINE " + PraegeParam[1].replace("SerNr", Schilder[j])
										+ (Markierung[j] == "" ? "" : "INSERTTEXTLINE " + PraegeParam[2].replace("Mark", Markierung[j]))
										+ "INSERTTEXTLINE " + PraegeParam[3].replace("EinstLast", strEinstellLast)
										+ (strWegAuf == 0 ? "" : "INSERTTEXTLINE " + PraegeParam[4].replace("WegAuf", strWegAuf))
										+ (strWegAb == 0 ? "" : "INSERTTEXTLINE " + PraegeParam[5].replace("WegAb", strWegAb))
										+ "INSERTTEXTLINE " + PraegeParam[6].replace("BlockPos", strBlockPos),
										"wc");
							
							// File für Prüfmaschine - immer -> Prüfmaschine braucht Komma nicht Punkt als Dezimaltrennzeichen
							// Fall RTW
							writefile(	AuftragPath + "A_" + strAuftragsnummer + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) : "_0") + ".txt",
										"Haenger-Typ;Lastgroesse ();Nennweg (mm);"
										+ "Soll-Last (kN);Sollweg (mm);unten/oben Richtungsfaktor ();"
										+ "Federkennzahl ();Zeichnungsnummer ();Besteller ();Bestellnr. ();"
										+ "Anlage/Projekt;Anlagen.-Pos. ();Kommision ();HYDRA-Position ();"
										+ "F0h ();M1h ();M2h ();F0v ();M21v ();F12v ();M22v ();F21v ()\r\n"
										+ left(strHaengerTyp, 3) + ";"
										+ strHaengerGr + ";"
										+ strNennweg + ";"
										+ strEinstellLast.replace(".",",") + ";"
										+ strGesArbWeg.replace(".",",") + ";"
										+ Richtungsfaktor + ";"
										+ ";"	// Federkennzahl bleibt leer
										+ ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + ";"	// Zeichnungsnummer
										+ getstring("FIRMENNAME_VON", "PROJECT.SETTINGS") + ";"	// Besteller
										+ getstring("ANFRAGENR", "PROJECT.SETTINGS") + ";"	// Bestellnummer
										+ getstring("PROJEKTNAME", "PROJECT.SETTINGS") + " / " + getstring("WI_SYSTEM", "PROJECT.SETTINGS")  + ";"	// Anlage/Projekt
										+ Markierung[j].replace("\\ ", " ") + ";"
										+ strAuftragsnummer + " (" + Schilder[j] + ");"
										+ strPosNr + (AnzahlSchilderPos*1>1 ? "/" + (j+1) : "") + ";"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0\r\n",
										"wc");
							}
							
							// Fall RUS
							if (RUSExists){
							// Hier die Sprache Kommunikation benutzen, nicht die GUI-Sprache
							var strAktuelleSprache = getlanguage();
							var strSpracheKomm = getstring("WI_SPRACHEKOMM", "PROJECT.SETTINGS"); // getlanguage();
							setlanguage(strSpracheKomm);
							
							writefile(	AuftragPath + "A_" + strAuftragsnummer + "_" + strPosNr + (AnzahlSchilderPos > 1 ? "_" + (j+1) : "_0") + "_RU.txt",
										"Haenger-Typ ();Haenger-Name ();Lastgroesse ();Nennweg (mm);Lastgruppe ();"
										+ "Nennlast (kN);Soll-Last (kN);Sollweg auf (mm);Sollweg ab (mm);"
										+ "unten/oben Richtungsfaktor ();Blockier-Pos (mm);Federkennzahl ();"
										+ "Zeichnungsnummer ();Besteller ();Bestellnr. ();Anlage/Projekt;Anlagen.-Pos. ();"
										+ "Kommision ();HYDRA-Position ();"
										+ "F0h ();M1h ();M2h ();F0v ();M21v ();F12v ();M22v ();F21v ()\r\n"
										+ left(strHaengerTyp, 3) + ";"
										+ translate("ID_CA_ARTIKEL_" + left(strHaengerTyp, 3)) + ";"
										+ strHaengerGr + ";"
										+ strNennweg + ";"
										+ strLGV + ";"
										+ strMaxLast + ";"
										+ strEinstellLast + ";"
										+ strWegAuf + ";"
										+ strWegAb + ";"
										+ RichtungsfaktorRUS + ";"
										+ strBlockPos + ";"
										+ ";"	// Federkennzahl bleibt leer
										+ ITEM.CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR + ";"	// Zeichnungsnummer
										+ getstring("FIRMENNAME_VON", "PROJECT.SETTINGS") + ";"	// Besteller
										+ getstring("ANFRAGENR", "PROJECT.SETTINGS") + ";"	// Bestellnummer
										+ getstring("PROJEKTNAME", "PROJECT.SETTINGS") + " / " + getstring("WI_SYSTEM", "PROJECT.SETTINGS")  + ";"	// Anlage/Projekt
										+ Markierung[j].replace("\\ ", " ") + ";"
										+ strAuftragsnummer + " (" + Schilder[j] + ");"
										+ strPosNr + (AnzahlSchilderPos*1>1 ? "/" + (j+1) : "") + ";"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0;"
										+ "0\r\n",
										"wc");
							}
							
							setlanguage(strAktuelleSprache);
							
							writefile( //strUserExportPath + "Hängerliste.csv",
										Datei_HLIST,
										+ strPosNr+"/"+(AnzahlSchilderPos*1>1 ? j+1 : "0") + ";"
										+ (j>0 ? "" : strAnzahlPos) + ";"
										+ (j>0 ? "" : strAnzahlHaengerPos) + ";"
										+ left(strHaengerTyp, 3) + ";"
										+ strHaengerGr + ";"
										+ strNennweg + ";"
										+ strEinstellLast.replace(".",",") + ";"
										+ ";"
										+ strSollweg + ";"
										+ strBewRicht + ";"
										+ strBlockPos + "/" + strSkalTeil + ";"
										+ strEndlWarm + ";"
										//+ "=RC[-1]+RC[-2]" + ";"	// Test Formel
										+ Skala + ";"	// Skalentyp ergänzen
										+ AbJustAchse + ";"	// Abst. Justa. ergänzen
										+ XF0 + ";"	// Abst. Fedt. ergänzen
										+ strBlock + ";"
										+ Markierung[j].replace("\\ ", " ") + ";"
										+ strLGV + ";"
										+ Schilder[j]
										+ "\r\n",
										"a");
						}
					}
				}
				//else if (strHaengerArt == "SSG")
				else if (left(strHaengerArt, 2) == "SS")
				{
					is_DYN	= true;
					/*
					if (!FileName.dirExists(SchildPath))
						var bOk = FileName.createDir(SchildPath);
					*/
					SchildLengthMax		-= 1;	// das eine Zeichen wird oben pauschal dazugezählt (gilt nur bei prägen hier im Haus)
					var TAG_Z1_MAX	= SchildLengthMax - (strHaengerArt == "SSB" ? 4 : 0);	// bei SSB 1. Zeile für die Markierung ist kürzer
					var SNO_Z1_MAX	= SchildLengthMax - (strHaengerArt == "SSB" ? 12 : 0);	// bei SSB 1. Zeile für die Markierung ist kürzer
					var Tag_Max_2Zeilen	= SchildLengthMax + TAG_Z1_MAX;
					var SNo_Max_2Zeilen	= SchildLengthMax + SNO_Z1_MAX;
					
					for (var j = 0; j < AnzahlSchilderPos; j++){
						var MarkLines	= [];
						if (Markierung[j].length > TAG_Z1_MAX){
							//hier gibt es auf dem Schild eine 2. Zeile
							if ((Markierung[j].length) <= Tag_Max_2Zeilen){
								MarkLines.push(left(Markierung[j], TAG_Z1_MAX));
								MarkLines.push(right(Markierung[j], Markierung[j].length - TAG_Z1_MAX));
							}
							else{
								strErrorDyn	+= "Markierung in Pos. " + strPosNr + "/" + (j+1) + " zu lang!\nKein Datensatz erzeugt!";
								bOK_Mark	= false;
							}
						}
						else{
							MarkLines.push(Markierung[j]);
							MarkLines.push("");
						}
						var SerialLines	= [];
						if (Schilder[j].length > SchildLengthMax){
							if (strHaengerArt == "SSB" && (Schilder[j].length + 2 <= SNo_Max_2Zeilen)){ // hier gibt es eine 2. Zeile
								if (Schilder[j].length - 3 <= SchildLengthMax){
									SerialLines.push(year_compl + "/");
									SerialLines.push(right(Schilder[j], Schilder[j].length - 3));
								}
								else{
									SerialLines.push(left(Schilder[j], SNO_Z1_MAX));
									SerialLines.push(right(Schilder[j], Schilder[j].length - SNO_Z1_MAX));
								}
							}
							else{
								strErrorDyn	+= "Seriennummer in Pos. " + strPosNr + "/" + (j+1) + " zu lang!\nKein Datensatz erzeugt!";
								bOK_SerNr	= false;
							}
						}
						else{
							if (strHaengerArt == "SSB")
								SerialLines.push("");
							SerialLines.push(Schilder[j]);
							if (strHaengerArt != "SSB")
								SerialLines.push("-");
						}
						if (bOK_Mark && bOK_SerNr){
							var Verlaengerung	= "-";
							if (ITEM.CA.SELECTION.TOPOCLASS.Verlaengerung)
								Verlaengerung	= ITEM.CA.SELECTION.TOPOCLASS.Verlaengerung.m_Ptyp;
							else if (ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Verlaengerung)
								Verlaengerung	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Verlaengerung.m_Ptyp;
								
							var MA		= "-";
							var CP		= "-";
							var HP		= "-";
							var BauF	= "";
							if (strHaengerArt == "SSG"){
								if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
									var LGG	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_strLGG * 1;
									BauF	= "E" + ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_Psubtyp;
								}
								else{
									var LGG	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_strLGG * 1;
									BauF	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_Psubtyp;
								}
								strSQLStatement	= "select * from SSG_PSS where abs(FN)=" + LGG + " ";
								numRet			= dbselect("CASCADE", strSQLStatement, "SSG");
								MA				= (numRet ? dbgetdouble("SSG", "MA") : "");
								if (MA == 0 || MA == "0"){	// kein Abbruchgrund!
									MA	= "";
									strErrorDyn	+= "Achtung - in Pos. " + strPosNr + "/" + (j+1) + " kein 'MA' gefunden.\n"
													+ "Bitte in Dynamikteilliste nachtragen!\n";
								}
							}
							else{
								if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
									CP	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.Blockpos;
									var strSollwege	= ITEM.CA.SELECTION.TOPOCLASS.Haenger.strSollwege;
									var LGG			= ITEM.CA.SELECTION.TOPOCLASS.Haenger.m_strLGG*1;
								}
								else{
									CP	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.Blockpos;
									var strSollwege	= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.strSollwege;
									var LGG			= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.m_strLGG*1;
								}
								var BauF_Ext	= (Verlaengerung == "-" ? 0 : 1);
								BauF_Ext		+= (LGG < 590 ? 0 : 2);
								BauF_Ext		+= right(strHaengerTyp, 1) + "";
								BauF			= "20" + BauF_Ext;
								strSollwege	= strSollwege.split("/");
								if (strSollwege.length == 2){
									if (strSollwege[0]*1 != 0 && strSollwege[1]*1 != 0)
										HP	= "";	// bei zwei Bewegungsrichtungen keine Warmposition angeben
									else{
										if (strSollwege[0]*1 != 0)	// entspricht S_ein
											HP	= CP*1 - fround(strSollwege[0]*1 ,0);
										else
											HP	= CP*1 + fround(strSollwege[1]*1 ,0);
									}
								}
								else{	// hier liegt ein Fehler vor
									strErrorDyn	+= "Achtung - in Pos. " + strPosNr + "/" + (j+1) + " CP und HP prüfen.\n"
													+ "Bitte in Dynamikteilliste nachtragen/korrigieren!\n";
								}
							}
							writefile(
									Datei_DLIST,
									+ strHaengerTyp.replace("\\ ", " ") + ";"
									+ BauF + ";"
									+ CP + ";"
									+ HP + ";"
									+ MA + ";"
									+ MarkLines[0].replace("\\ ", " ") + ";"
									+ MarkLines[1].replace("\\ ", " ") + ";"
									+ SerialLines[0] + ";"
									+ SerialLines[1] + ";"
									+ Verlaengerung
									+ "\r\n",
									"a");
						}
						//Markierung[j]	+= MarkZeile2
					}
				}
				AnzahlSchilderGes	+= AnzahlSchilderPos*1;
			}
			// Infos für MList
			var HaengProLK	= "-";
			var TypenschildLengthMax	= "";
			if (isSchild){
				if (ITEM.CA.SELECTION.TOPOCLASS.Haenger){
					var HaengerArtSelect	= toupper(ITEM.CA.SELECTION.TOPOCLASS.Haenger.__CLASSNAME__);
					var NennwegSelect		= ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg*1 < 100 ?
												"0"+ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg :
												ITEM.CA.SELECTION.TOPOCLASS.Haenger.nennweg;
				}
				else{
					var HaengerArtSelect	= toupper(ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.__CLASSNAME__);
					var NennwegSelect		= ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg*1 < 100 ?
												"0"+ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg :
												ITEM.CA.SELECTION.TOPOCLASS.SegmentStrang.Haenger.nennweg;
				}
				HaengProLK			= rfind(ITEM.CA.FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG, "DOPPEL") > 0 ? "2" : "1";
				var SchildTypSelect	= (HaengerArtSelect == "FEDERHAENGER" ? "FH" + NennwegSelect : "KH");
				strSQLStatement = "select * from Typenschild ";
				dbselect("CASCADE", strSQLStatement, "Typenschild");
				TypenschildLengthMax	= dbgetdouble("Typenschild", SchildTypSelect);
			}
			
			writefile(	Datei_MLIST,
						strPosNr + ";"
						+ strMarkierung + ";"
						+ ";"
						+ (strTrennzeichenMark == ";" ? '";"' : strTrennzeichenMark) + ";"
						+ ITEM.QTY + ";"
						+ HaengProLK + ";"
						+ TypenschildLengthMax + ";"
						+ strZeichnungsnr + ";"
						+ ";"
						+ strBemerkung + ";"
						+ ";"
						+ strAnfragePos + ";"
						+ ";"
						+ strOriFlexPos + ";"
						+ strKundenMatNr
						+ "\r\n",
						"a");
		}
		
		// Hängerliste erzeugen, wenn alle Markierungen i.O. und FH/KH bzw. FS/KS vorhanden
		if (response.success && strError == (translate("MSG_FILES_CREATED") + "\n") && is_FH_KH){
			var csvManager = new CascadeCsvManager("HLIST");
			csvManager.writeCsvAsXml(Datei_HLIST);
		}
		if (FileName.fileExists(Datei_HLIST))
			// die csv brauchen wir nicht
			FileName.deleteFile(Datei_HLIST);
		
		// Dynamikteilliste erzeugen, wenn alle Markierungen i.O. und Dynamikteile vorhanden
		if (response.success && strError == (translate("MSG_FILES_CREATED") + "\n") && is_DYN){
			var csvManager = new CascadeCsvManager("DLIST");
			if (FileName.fileExists(Datei_DLIST))
				csvManager.writeCsvAsXml(Datei_DLIST);
		}
		if (FileName.fileExists(Datei_DLIST))
			// die csv brauchen wir nicht
			FileName.deleteFile(Datei_DLIST);
		
		// Markierungsliste immer erzeugen
		var csvManager = new CascadeCsvManager("MLIST");
		csvManager.writeCsvAsXml(Datei_MLIST);
		if (FileName.fileExists(Datei_MLIST))	// sollte immer existieren
			// die csv brauchen wir nicht
			FileName.deleteFile(Datei_MLIST);
		
		/*
		// ----------------------------------------------------------------------------------
		// Test Daten nach Excel
		var dbName		= 'EXCEL';
		var TestODBC	= dbconnect(dbName, "ODBC;DRIVER={Microsoft Excel Driver (*.xls, *.xlsx, *.xlsm, *.xlsb)};DBQ="+ getstddirectory("PROGRAM") + "Test.xlsx" +";");
		var sqlstring 	= "SELECT * FROM [PREVIEW$]";
		var dbNameTable = 'HALLO';
		var numRet		= dbselect( dbName, sqlstring, dbNameTable );
		var Info		= dbsetstring(dbNameTable, "SPALTE1", "Hallo");
		dbdisconnect("EXCEL");
		// ----------------------------------------------------------------------------------
		*/
		
		response.success	= true;
		response.message	= strError + strErrorDyn;
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	// Aufruf zur automatischen Zusammenfassung von Positionen in eine WIT
	// ----------- Das geht ----------------
	/*
	doZusammenfassungProjectlistAction : function()
	{
		var response = {success		: true,
						message		: "Zusammenfassung beendet.",
						DoUpdate	: true // Maske aktualisieren?
						};
		
        var AnzPosProjList	= getsize("PROJECT.POSITIONS.PROJECTLIST_ITEMS", "");
		var AnzPosGezeigt	= atoi(getstring("IDC_ANZAHL_PLIST_ROWS_COMBO","MISCSTUFF"));
		
		if (AnzPosGezeigt >= AnzPosProjList){	// Zusammenfassung geht nur, wenn alle Positionen angezeigt werden
			var dokManager = new CaDokManager(caMainController);
			dokManager.prepareDatenStueckliste(1);
			response.NewItems	= caMainController.doMergeItems(dokManager.stueckListe, dokManager.stueckListeFP);
		}
		else{
			response.message	= ansi2utf8("Bitte Anzeige von mind. " + AnzPosProjList + " Positionen wählen und Zusammenfassung neu starten!");
			response.DoUpdate	= false;
		}
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	*/
	// ----------- Das geht besser ----------------
	doZusammenfassungProjectlistAction : function()
	{
		var response = {success		: true,
						message		: "Zusammenfassung vollständig.",
						DoUpdate	: false // Maske aktualisieren?
						};
		
		caMainController.doMergeItems();
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	// Uebernahme der geaenderten Voreinstellungen auf das Projekt
	doSetPresetsAction : function()
	{
		var response = {success		: true,
						message		: "Einstellungen übernommen.",
						};
		
		caMainController.doSetPresetsAction();
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	doExtractSpecialPartsAction : function()
	{
		var response = {success	: true,
						message	: ""};
		
		// TODO - falls gewünscht
			// Sonderteile und Stahlbau aus den Einzelstücklisten entfernen
			// Stand 02.01.2017:
			// - Stahlbau in EINE neue Position - ggf. insich zusammenfassen
			// - Zukaufteile in SEPARATE Positionen
			
			//if (irgendwas gesetzt){
			
				var StahlbauInEinePos	= true;
				var ZukaufInEinePos		= false;
				caMainController.AnalyseSpecialParts(StahlbauInEinePos, ZukaufInEinePos);
				response.message		= "Extrahieren beendet";
				//specialexec("ProjectRecalcPrices");
			//}
		
		//********************************************************************************
		/*
		// Test addNetConnection
		var netShare	= toupper(getstring( "CATALOG.SAP.TRANSFERORDNER", "" ));	// "FLEXPERTERTW"
		var SAPSys		= toupper(getstring( "CATALOG.SAP.SAPINFO", "" ));
		SAPSys			= (rfind(SAPSys, "TEST") > -1 ? "_K" : "_P");	// "P" - Prduktiv / "K" - Test
		var username	= "";
        var passwd		= "";
		var connect		= "";
		
		var sqlstring 	= "SELECT * FROM TRANSFER WHERE GATE = '" + netShare + SAPSys + "' ";
			var dbName		= "CASCADE";
			var dbNameTable = "LogInfo";
			
		if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
				username	= dbgetstring(dbNameTable, "USER");
				//username	= "SAPHEC\\r3sambaflexperte";
				passwd		= dbgetstring(dbNameTable, "PASS");
				//connect		= "\\\\" + dbgetstring(dbNameTable, "CONNECT") + "\\";
				connect		= dbgetstring(dbNameTable, "CONNECT");
				//connect		= "\\\\10001erp-p1.global.witzenmann.com" + "\\";
				//connect		= "\\\\10001erp-t1.global.witzenmann.com" + "\\";
				//connect		= "\\\\192.168.194.70\\";
		}
			
		netShare	= connect + tolower(netShare);	// \\\\192.168.194.70\\flexpertertw
		
		if (connect != ""){
			var res = FileName.addNetConnection(netShare, username, passwd);
			if(res != "") {
				alert("Fehler beim Zeichnungstransfer auf SAP-Laufwerk: " + res);
			}
			else {
				res = FileName.cancelNetConnection(netShare);
			}
		}
		*/
		//********************************************************************************
		
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	importMarkToProjectlistAction : function()
    {
		response = {success : true,
					message : "Daten importiert.\nTexte aktualisieren!"
					};
		var strUserExportPath	= getstring("PROJECTPATH", "PROJECT");
		var Datei_Import	= filedialog(1, "csv", "", "*.csv", strUserExportPath);
		var buffer	= readfile(Datei_Import);
		var lines	= buffer.split("\r\n");
		//var MarkPos	= {FlPos : '', Mark_IST : '', Mark_SOLL : ''};
		var MarkPos	= {FlPos : '', Mark_IST : '', Mark_SOLL : '', ZnNr_IST : '', ZnNr_SOLL : '', Bem_IST : '', Bem_SOLL : '', AnfrPos_IST : '', AnfrPos_SOLL : ''};
		var ITEMS	= Object.fromStorage("PROJECT.POSITIONS");
		for (var a = 0; a < lines.length; a++){
			var Pos	= lines[a].split(";");
			MarkPos.FlPos			= Pos[0] * 1;
			MarkPos.Mark_IST		= Pos[1] + "";
			MarkPos.Mark_SOLL		= Pos[2] + "";
			MarkPos.ZnNr_IST		= Pos[7] + "";
			MarkPos.ZnNr_SOLL		= Pos[8] + "";
			MarkPos.Bem_IST			= Pos[9] + "";
			MarkPos.Bem_SOLL		= Pos[10] + "";
			MarkPos.AnfrPos_IST		= Pos[11] + "";
			MarkPos.AnfrPos_SOLL	= Pos[12] + "";
			//var ITEMS			= Object.fromStorage("PROJECT.POSITIONS");
			for (var b = 0; b < ITEMS.PROJECTLIST_ITEMS.length; b++){
				if (ITEMS.PROJECTLIST_ITEMS[b].POS * 1 == MarkPos.FlPos){
					if (ITEMS.PROJECTLIST_ITEMS[b].MODIFY_ENTRY_SCREEN != "IDD_FREIE_POSITION"){
						setstring("IDC_ANLAGEN_POS_NR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].CA.FORMS.UEBERSICHT_LASTKETTE", MarkPos.Mark_SOLL);
						setstring("MARKIERUNG", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL);
						setstring("IDC_ZEICHNUNGS_NR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].CA.FORMS.UEBERSICHT_LASTKETTE", MarkPos.ZnNr_SOLL);
						setstring("IDC_BEMERKUNGEN", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].CA.FORMS.UEBERSICHT_LASTKETTE", MarkPos.Bem_SOLL);
						setstring("IDC_ANFRAGEPOS", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].CA.FORMS.UEBERSICHT_LASTKETTE", MarkPos.AnfrPos_SOLL);
					}
					else{
						if (ITEMS.PROJECTLIST_ITEMS[b].FP.MARKIERUNG == ""){
							// Anpassen -> die neue Markierung kann auch leer sein
							// dann brauchen wir das "<br>" nicht
							setstring("ORDERCODE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL + "<br>" + ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE);
							setstring("ORDERCODE_PROJECTLIST", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL + "<br>" + ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE_PROJECTLIST);
						}
						else{
							var MarkOldLength	= rfind(ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE, "<br>");
							var OrderCode		= right(ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE, ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE.length-MarkOldLength+1);
							var OrderCode_PList	= right(ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE_PROJECTLIST, ITEMS.PROJECTLIST_ITEMS[b].ORDERCODE_PROJECTLIST.length-MarkOldLength+1);
							setstring("ORDERCODE", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL + OrderCode);
							setstring("ORDERCODE_PROJECTLIST", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL + OrderCode_PList);
						}
						setstring("MARKIERUNG", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].FP", MarkPos.Mark_SOLL);
						setstring("MARKIERUNG", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"]", MarkPos.Mark_SOLL);
						setstring("ZEICHNUNGSNR", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+b+"].FP", MarkPos.ZnNr_SOLL);
					}
					b = ITEMS.PROJECTLIST_ITEMS.length;
				}
			}
		}
		echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	importExcelDataAction : function()
	{
		// Dummy SSG Schild
		/*
		var FA			= "12769831";
		var Ordner		= "1086674020_AN4313356_1"
		var AnzPos		= 65;
		for (var i = 0; i < AnzPos; i++){
			var isDoppel	= false;
			var strPosNr	= (i + 1) * 10;
			var Type		= getstring("m_Ptyp", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+i+"].CA.SELECTION.TOPOCLASS.Haenger");
			Type			= Type.replace(" ", "\\ ");
			var SerNo		= "18/"+FA+"/"+strPosNr+"/";
			var Mark		= getstring("MARKIERUNG", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+i+"]");
			var FN			= getstring("m_dNennlast", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+i+"].CA.SELECTION.TOPOCLASS.Haenger")*1;
			var MA			= "";
			switch (FN){
				case 5	: MA = 21;
					break;
				case 13	: MA = 56;
					break;
				case 32	: MA = 278;
					break;
				case 45	: MA = 392;
					break;
				case 78	: MA = 680;
					break;
				case 130	: MA = 1456;
					break;
				default	:
					break;
			}
			if (getstring("IDC_ROHRVERLAUF", "PROJECT.POSITIONS.PROJECTLIST_ITEMS["+i+"].CA.FORMS.SYSTEMCHARAKTERISTIK") == "VERTIKAL")
				isDoppel	= true;
			writefile(	"K:\\Common\\vertrieb\\Angebote\\Kunden 2017\\BASF_LU\\Acetylenanlage\\Dynamikb\\Bestellungen\\"+Ordner+"\\Schilddateien\\" + "S_SSG_" + strPosNr + "_1_" + FA + ".sic",
							"NEWFILE 5 7 1 SSG\r\n"
							+ "INSERTTEXTLINE 635 615 0 30 30 18000 0 2 5 5 " + Type + "\r\n"
							+ "INSERTTEXTLINE 635 515 0 30 30 18000 0 2 5 5 " + SerNo + "1\r\n"
							+ "INSERTTEXTLINE 635 415 0 30 30 18000 0 2 5 5 " + Mark + "\r\n"
							+ "INSERTTEXTLINE 300 300 0 30 30 18000 0 2 5 5 " + MA + "\r\n",
							"wc");
			if (isDoppel){
				writefile(	"K:\\Common\\vertrieb\\Angebote\\Kunden 2017\\BASF_LU\\Acetylenanlage\\Dynamikb\\Bestellungen\\"+Ordner+"\\Schilddateien\\" + "S_SSG_" + strPosNr + "_2_" + FA + ".sic",
							"NEWFILE 5 7 1 SSG\r\n"
							+ "INSERTTEXTLINE 635 615 0 30 30 18000 0 2 5 5 " + Type + "\r\n"
							+ "INSERTTEXTLINE 635 515 0 30 30 18000 0 2 5 5 " + SerNo + "2\r\n"
							+ "INSERTTEXTLINE 635 415 0 30 30 18000 0 2 5 5 " + Mark + "\r\n"
							+ "INSERTTEXTLINE 300 300 0 30 30 18000 0 2 5 5 " + MA + "\r\n",
							"wc");
			}
		}
		*/
		
		var strXLSXFile = filedialog( 1, 'xls;xlsx;xlsm', '', 'Excel File|*.xls;*.xlsx;*.xlsm||', '' );
		if (strXLSXFile != ""){
			var TestODBC	= dbconnect("EXCEL", "ODBC;DRIVER={Microsoft Excel Driver (*.xls, *.xlsx, *.xlsm, *.xlsb)};DBQ="+ strXLSXFile +";");
			if (!TestODBC){
				TestODBC	= dbconnect("EXCEL", "ODBC;DRIVER={Microsoft Excel Driver (*.xls)};DBQ="+ strXLSXFile +";");
			}
			if (TestODBC){
				var oRet = caMainController.ImportExcel(FileName.getDir(strXLSXFile), FileName.getName(strXLSXFile));
				dbdisconnect("EXCEL");
			}
			else{
				//dbdisconnect ("EXCEL");
				var oRet =	{
							success : false,
							message : "DBConnect failed - check ODBC-Source"
							};
			}
			echo oRet.toJSON();
			_global.MIMETYPE = 'application/json';
		}
		else{
			var response =	{
							success : false,
							message : "Abort by User"
							};
			
			echo response.toJSON();
			_global.MIMETYPE = 'application/json';
		}
		
		return;
	},
	
	importCaesarDataAction : function()
	{
		//var strMDBFile = filedialog( 1, 'mdb', '', 'CII Neutral File|*.mdb;*.MDB||', '' );
		var strMDBFile = filedialog( 1, 'mdb;accdb', '', 'CII Neutral File|*.mdb;*.MDB;*.accdb;*.ACCDB||', '' );
		
		//dbconnect("CAESAR", "ODBC;DRIVER={Microsoft Access Driver (*.mdb)};READONLY=0;DSN='';DBQ=C:\\DATA\\FLEXPERTE_Entwicklung\\FLEXPERTE_SVN\\CAESAR\\C2.mdb;UID=easykat;PWD=easykat");
		if (strMDBFile != "")
			//dbconnect("CAESAR", "ODBC;DRIVER={Microsoft Access Driver (*.mdb)};READONLY=0;DSN='';DBQ="+ strMDBFile +";UID=easykat;PWD=easykat");
			dbconnect("CAESAR", "ODBC;DRIVER={Microsoft Access Driver (*.mdb, *.accdb)};READONLY=0;DSN='';DBQ="+ strMDBFile +";UID=easykat;PWD=easykat");
		else{
			var response =	{
								success : false,
								message : "Abort by User"
							};
			
			echo response.toJSON();
			_global.MIMETYPE = 'application/json';
			
			return;
		}
		var strMDBPath		= FileName.getDir(strMDBFile);
		var strMDBFileName	=  FileName.getName(strMDBFile);
		
		var strSQLStatement = "select * from RESTRAINT_TYPES";
		var numRet			= dbselect("CAESAR", strSQLStatement, "RESTRAINT_TYPES");
		var RESTRAINT_TYPES	= {};
		
		// mögliche Typen der Restraints
		for (var i = 0; i < numRet; i++){
			var strSQLStatement = "select * from RESTRAINT_TYPES where abs(RES_TYPEID) = "+(i+1)+" ";
			dbselect("CAESAR", strSQLStatement, "RESTRAINT_TYPES");
			RESTRAINT_TYPES[i+1]	= dbgetstring("RESTRAINT_TYPES", "RES_TYPE");
		}
		
		// Bestimmung der Restrainttypen zu den Knotennummern
		strSQLStatement		= "select * from OUTPUT_RESTRAINTS order by abs(NODE), abs(LCASE_NUM)";
		numRet				= dbselect("CAESAR", strSQLStatement, "RESTRAINTS");
		var actNODE_NUM		= dbgetdouble("RESTRAINTS", "NODE");
		var RESTRAINTS		= {};
		var RES_TYPE		= {};
		var numRet2			= numRet;
		var isSupport		= false;
		
		while (numRet2 > 0){
			strSQLStatement		= "select * from OUTPUT_RESTRAINTS where abs(NODE) = "+actNODE_NUM+" order by abs(NODE), abs(LCASE_NUM)";
			numRet2				= dbselect("CAESAR", strSQLStatement, "RESTRAINTS");
			while ( dbiseof( "RESTRAINTS") == 0 ){
				var TypeSplit	= dbgetstring("RESTRAINTS", "TYPE").split(" ");
				var Type		= toupper(trimright(trimleft(TypeSplit[TypeSplit.length-1], " "), " "));
				if(Type != "ANC" && Type != "REACTION"){
					var isNew	= true;
					for (i = 0; i < RES_TYPE.length; i++){
						if (RES_TYPE[i] == Type)
							isNew	= false;
					}
					if (isNew){
						RES_TYPE.push(Type);
						isSupport	= true;
					}
				}
				dbskip( "RESTRAINTS" );
			}
			if (isSupport){
				RESTRAINTS.push({
					"NODE_NUM"		: actNODE_NUM,
					"RES_TYPEID"	: RES_TYPE
					});
			}
			RES_TYPE	= {};
			isSupport	= false;
			strSQLStatement		= "select * from OUTPUT_RESTRAINTS where abs(NODE) > "+actNODE_NUM+" order by abs(NODE), abs(LCASE_NUM)";
			numRet2				= dbselect("CAESAR", strSQLStatement, "RESTRAINTS");
			actNODE_NUM			= dbgetdouble("RESTRAINTS", "NODE");
		}
		
		// Bestimmung der Werte des jeweiligen Knoten -> bei letztem Knoten ist z.T. die Abfrage anders
		// die Lastfälle
		for (i = 0; i < RESTRAINTS.length; i++){
			strSQLStatement			= "select * from OUTPUT_RESTRAINTS where abs(NODE) = "+RESTRAINTS[i].NODE_NUM+" order by abs(LCASE_NUM)";
			var Lastfall_Anzahl		= dbselect("CAESAR", strSQLStatement, "LASTFALL");
			var Lastfall			= [];
			RESTRAINTS[i].Lastfall	= [];
			while ( dbiseof( "LASTFALL") == 0 ){
				RESTRAINTS[i].Lastfall.push(dbgetdouble("LASTFALL", "LCASE_NUM"));	// Lastfälle
				dbskip( "LASTFALL" );
			}
			Lastfall	= [];
		}
		
		var COORDINATES	= [];
		var PipeDir		= [];
		for (i = 0; i < RESTRAINTS.length; i++){
			// Koordinaten
			strSQLStatement				= "select * from INPUT_NODAL_COORDINATES where abs(FROM_NODE) = "
											+fround(RESTRAINTS[i].NODE_NUM*1/10,0)*10+" ";
			numRet						= dbselect("CAESAR", strSQLStatement, "NODE");
			// Achtung nicht immer ist der NODE auch in FROM_NODE enthalten -> dann steckt er in "TO_NODE"
			if (numRet > 0){
				COORDINATES.X				= dbgetdouble("NODE", "FROM_NODE_X");
				COORDINATES.Y				= dbgetdouble("NODE", "FROM_NODE_Y");
				COORDINATES.Z				= dbgetdouble("NODE", "FROM_NODE_Z");
				RESTRAINTS[i].COORDINATES	= COORDINATES;
				// Richtungsvektor der Rohrleitung an diesem Punkt - ohne Zuordnung der vertikalen Achse
				PipeDir.X					= dbgetdouble("NODE", "TO_NODE_X") - COORDINATES.X;
				PipeDir.Y					= dbgetdouble("NODE", "TO_NODE_Y") - COORDINATES.Y;
				PipeDir.Z					= dbgetdouble("NODE", "TO_NODE_Z") - COORDINATES.Z;
			}
			else{
				strSQLStatement		= "select * from INPUT_NODAL_COORDINATES where abs(TO_NODE) = "
										+fround(RESTRAINTS[i-1].NODE_NUM*1/10,0)*10+" ";
				numRet				= dbselect("CAESAR", strSQLStatement, "NODE");
				COORDINATES.X				= dbgetdouble("NODE", "TO_NODE_X");
				COORDINATES.Y				= dbgetdouble("NODE", "TO_NODE_Y");
				COORDINATES.Z				= dbgetdouble("NODE", "TO_NODE_Z");
				RESTRAINTS[i].COORDINATES	= COORDINATES;
				PipeDir.X					= COORDINATES.X - dbgetdouble("NODE", "FROM_NODE_X");
				PipeDir.Y					= COORDINATES.Y - dbgetdouble("NODE", "FROM_NODE_Y");
				PipeDir.Z					= COORDINATES.Z - dbgetdouble("NODE", "FROM_NODE_Z");
			}
			PipeDir.ALPHA				= "";
			PipeDir.BETA				= "";
			PipeDir.Achse				= "";
			// normieren
			var NormFaktor				= 1 / (max(abs(PipeDir.X), abs(PipeDir.Y), abs(PipeDir.Z)));
			PipeDir.X					= PipeDir.X * NormFaktor;
			PipeDir.Y					= PipeDir.Y * NormFaktor;
			PipeDir.Z					= PipeDir.Z * NormFaktor;
			RESTRAINTS[i].PipeDir		= PipeDir;
			PipeDir						= [];
			COORDINATES					= [];
			// Reibwertvorgabe
			strSQLStatement			= "select * from INPUT_RESTRAINTS where abs(NODE_NUM) = "+RESTRAINTS[i].NODE_NUM+" ";
			numRet					= dbselect("CAESAR", strSQLStatement, "NODE");
			RESTRAINTS[i].FRICTION	= fround(dbgetdouble("NODE", "FRIC_COEF"), 2);
			// JOBNAME
			RESTRAINTS[i].JOBNAME	= dbgetstring("NODE", "JOBNAME");
			// NODE_NAME
			RESTRAINTS[i].NODE_NAME	= dbgetstring("NODE", "NODE_NAME");
			// PIPENAME / Durchmesser / Dämmdicke / Temperatur
			strSQLStatement			= "select * from INPUT_BASIC_ELEMENT_DATA where abs(FROM_NODE) = "+RESTRAINTS[i].NODE_NUM+" or abs(TO_NODE) = "+RESTRAINTS[i].NODE_NUM+" ";
			numRet					= dbselect("CAESAR", strSQLStatement, "NODE");
			if (numRet <= 0){
				strSQLStatement			= "select * from INPUT_BASIC_ELEMENT_DATA where abs(FROM_NODE) = "
											+floor(RESTRAINTS[i].NODE_NUM*1/10)*10+" or abs(TO_NODE) = "
											+ceil(RESTRAINTS[i].NODE_NUM*1/10)*10+" ";
				numRet					= dbselect("CAESAR", strSQLStatement, "NODE");
			}
			RESTRAINTS[i].PIPENAME	= dbgetstring("NODE", "LINE_NO");
			RESTRAINTS[i].DMR_Rohr	= dbgetdouble("NODE", "DIAMETER");
			RESTRAINTS[i].DaemmDick	= dbgetdouble("NODE", "INSUL_THICK");
			var MedTemp				= dbgetdouble("NODE", "TEMP_EXP_C1");
			for (var check = 2; check < 9; check++){
				if (dbgetdouble("NODE", "TEMP_EXP_C" + check + "") > MedTemp)
					MedTemp	= dbgetdouble("NODE", "TEMP_EXP_C" + check + "");
			}
			RESTRAINTS[i].MedTemp	= MedTemp;
			
			// Prüfen ob es ein Hänger ist
			var isHanger			= false;
			for (check = 0; check < RESTRAINTS[i].RES_TYPEID.length; check++){
				if (right(RESTRAINTS[i].RES_TYPEID[check], 2) == "SH"	// "VSH" oder "CSH"
					|| right(RESTRAINTS[i].RES_TYPEID[check], 3) == "SPR"
					|| right(RESTRAINTS[i].RES_TYPEID[check], 3) == "ROD")	//das ist nur ein starrer Hänger wenn dieser in
																			//der vertikalen Achse liegt Y->YROD / Z->ZROD
																			//kennen wir noch nicht - Korr. bei Bestimmung RH-Typ
				{
				// das sind die Hänger
					strSQLStatement	= "select * from OUTPUT_HANGERS where abs(NODE)="+RESTRAINTS[i].NODE_NUM+" ";
					numRet			= dbselect("CAESAR", strSQLStatement, "HANGER");
					isHanger		= true;
					var TypHanger	= "Starr";	// Default
					var Hanger_Gr	= "";
					var isDoppelt	= false;
					var Emass		= "";
					var Spannweite	= "";
					var MoveHanger	= "";
					var SRate		= "";
					var Instload	= "";
					if (numRet > 0){
						Hanger_Gr		= (dbgetdouble("HANGER", "SIZE") < 10 ? "0" : "") + dbgetdouble("HANGER", "SIZE") + "." + dbgetstring("HANGER", "FIGNUM") + " - " + dbgetstring("HANGER", "MANUF");
						isDoppelt		= (dbgetdouble("HANGER", "NUMREQ") == 2 ? true : isDoppelt);
						MoveHanger		= fround(dbgetdouble("HANGER", "VERT_MOVEMENT"), 2);
						SRate			= fround(dbgetdouble("HANGER", "SPRING_RATE"), 1) * (isDoppelt ? 2 : 1);
						Instload		= fround(dbgetdouble("HANGER", "TH_INSTALL_LOAD")/1000, 2) * (isDoppelt ? 2 : 1);
						strSQLStatement	= "select * from INPUT_HANGERS where abs(NODE)="+RESTRAINTS[i].NODE_NUM+" ";
						numRet			= dbselect("CAESAR", strSQLStatement, "HANGER");
						Emass			= (fround(dbgetdouble("HANGER", "AVAIL_SPACE"), 2) != (-1.01) ? dbgetdouble("HANGER", "AVAIL_SPACE") : 0);
										// -1.01 scheint von "in CII nicht gesetzt" zu stammen
						var isHS		= (Emass < 0 ? "S" : "H");	// Hänger oder Stütze
						if (right(RESTRAINTS[i].RES_TYPEID[check], 3) == "VSH")	// FH/FS
							TypHanger	= "F" + isHS;
						else if (right(RESTRAINTS[i].RES_TYPEID[check], 3) == "CSH")	// KH/KS
							TypHanger	= "K" + isHS;
					}
					else if (isDoppelt){
						strSQLStatement	= "select * from INPUT_RESTRAINTS where abs(NODE_NUM)="+RESTRAINTS[i].NODE_NUM+" ";
						numRet			= dbselect("CAESAR", strSQLStatement, "RESTRAINT");
						Spannweite		= (dbgetdouble("RESTRAINT", "GAP") > 0 ? dbgetdouble("RESTRAINT", "GAP") : 300);	// entweder Wert aus DB oder Default
					}
					else{
						strSQLStatement	= "select * from INPUT_RESTRAINTS where abs(NODE_NUM)="+RESTRAINTS[i].NODE_NUM+" ";
						numRet			= dbselect("CAESAR", strSQLStatement, "RESTRAINT");
						Spannweite		= (dbgetdouble("RESTRAINT", "GAP") > 0 ? dbgetdouble("RESTRAINT", "GAP") : Spannweite);
						isDoppelt		= (Spannweite > 0 ? true : false);
					}
					
					RESTRAINTS[i].TypHanger		= TypHanger;
					RESTRAINTS[i].Hanger_Gr		= Hanger_Gr;
					RESTRAINTS[i].isDoppelt		= isDoppelt;
					RESTRAINTS[i].Spannweite	= Spannweite;
					RESTRAINTS[i].MoveHanger	= MoveHanger;
					RESTRAINTS[i].SRate			= SRate;
					RESTRAINTS[i].Instload		= Instload;
					RESTRAINTS[i].Emass			= Emass;
				}
			}
			RESTRAINTS[i].isHanger	= isHanger;
			
			// Kräfte (als Maximalwerte der Lastfälle) - Unterscheidung zw. Druckprobe oder nicht Druckprobe
			var Kraftmatrix_OPERAT	= [0,0,0,0,0,0,""];	// +X,+Y,+Z,-X,-Y,-Z,Übersicht
			var Kraftmatrix_SUSTAIN	= [0,0,0,0,0,0,""];
			var Kraftmatrix_HYDRO	= [0,0,0,0,0,0,""];
			var Kraftmatrix_ELSE	= [0,0,0,0,0,0,""];
			var Kraftmatrix_NORMAL	= [0,0,0,0,0,0,""];
			var Kraftmatrix_ALL		= [0,0,0,0,0,0,""];
			var Bewegmatrix_OPERAT	= [0,0,0,0,0,0,""];	// +X,+Y,+Z,-X,-Y,-Z,Übersicht
			var Bewegmatrix_SUSTAIN	= [0,0,0,0,0,0,""];
			var Bewegmatrix_HYDRO	= [0,0,0,0,0,0,""];
			var Bewegmatrix_ELSE	= [0,0,0,0,0,0,""];
			var Bewegmatrix_NORMAL	= [0,0,0,0,0,0,""];
			var Bewegmatrix_ALL		= [0,0,0,0,0,0,""];
			for (var j = 0; j < RESTRAINTS[i].Lastfall.length; j++){
				strSQLStatement			= "select * from OUTPUT_RESTRAINTS where abs(NODE) = "+RESTRAINTS[i].NODE_NUM+" and abs(LCASE_NUM) = "+RESTRAINTS[i].Lastfall[j]+" order by abs(LCASE_NUM)";
				numRet	= dbselect("CAESAR", strSQLStatement, "KRAFT");
				var strSQLStatement2	= "select * from OUTPUT_DISPLACEMENTS where abs(NODE) = "+RESTRAINTS[i].NODE_NUM+" and abs(LCASE_NUM) = "+RESTRAINTS[i].Lastfall[j]+" order by abs(LCASE_NUM)";
				numRet2	= dbselect("CAESAR", strSQLStatement2, "WEG");
				//-------------------------------------
				while ( dbiseof( (numRet >= numRet2 ? "KRAFT" : "WEG") ) == 0 ){
				//-------------------------------------
				var Fallanalyse	= dbgetstring("KRAFT", "CASE").split(" ");
				var HYDROTest	= false;
				var OPERATING	= false;
				var SUSTAINED	= false;
				for (var k = 0; k < Fallanalyse.length; k++){
					if (rfind(toupper(trimleft(trimright(Fallanalyse[k], " "), " ")), "HYD") >= 0)
						HYDROTest	= true;
					else if (rfind(toupper(trimleft(trimright(Fallanalyse[k], " "), " ")), "OPE") >= 0)
						OPERATING	= true;
					else if (rfind(toupper(trimleft(trimright(Fallanalyse[k], " "), " ")), "SUS") >= 0)
						SUSTAINED	= true;
				}
				if(OPERATING){		// Operating
					// FX
					var FX	= fround(dbgetdouble("KRAFT", "FX")/1000, 2);
					if (FX >= 0 && FX > Kraftmatrix_OPERAT[0])
						Kraftmatrix_OPERAT[0]	= FX;
					else if (FX < 0 && abs(FX) > abs(Kraftmatrix_OPERAT[3]))
						Kraftmatrix_OPERAT[3]	= FX;
					// FY
					var FY	= fround(dbgetdouble("KRAFT", "FY")/1000, 2);
					if (FY >= 0 && FY > Kraftmatrix_OPERAT[1])
						Kraftmatrix_OPERAT[1]	= FY;
					else if (FY < 0 && abs(FY) > abs(Kraftmatrix_OPERAT[4]))
						Kraftmatrix_OPERAT[4]	= FY;
					// FZ
					var FZ	= fround(dbgetdouble("KRAFT", "FZ")/1000, 2);
					if (FZ >= 0 && FZ > Kraftmatrix_OPERAT[2])
						Kraftmatrix_OPERAT[2]	= FZ;
					else if (FZ < 0 && abs(FZ) > abs(Kraftmatrix_OPERAT[5]))
						Kraftmatrix_OPERAT[5]	= FZ;
					// DX
					var DX	= fround(dbgetdouble("WEG", "DX"), 2);
					if (DX >= 0 && DX > Bewegmatrix_OPERAT[0])
						Bewegmatrix_OPERAT[0]	= DX;
					else if (DX < 0 && abs(DX) > abs(Bewegmatrix_OPERAT[3]))
						Bewegmatrix_OPERAT[3]	= DX;
					// DY
					var DY	= fround(dbgetdouble("WEG", "DY"), 2);
					if (DY >= 0 && DY > Bewegmatrix_OPERAT[1])
						Bewegmatrix_OPERAT[1]	= DY;
					else if (DY < 0 && abs(DY) > abs(Bewegmatrix_OPERAT[4]))
						Bewegmatrix_OPERAT[4]	= DY;
					// DZ
					var DZ	= fround(dbgetdouble("WEG", "DZ"), 2);
					if (DZ >= 0 && DZ > Bewegmatrix_OPERAT[2])
						Bewegmatrix_OPERAT[2]	= DZ;
					else if (DZ < 0 && abs(DZ) > abs(Bewegmatrix_OPERAT[5]))
						Bewegmatrix_OPERAT[5]	= DZ;
				}
				else if(SUSTAINED){		// Sustained - Kaltlast
					// FX
					var FX	= fround(dbgetdouble("KRAFT", "FX")/1000, 2);
					if (FX >= 0 && FX > Kraftmatrix_SUSTAIN[0])
						Kraftmatrix_SUSTAIN[0]	= FX;
					else if (FX < 0 && abs(FX) > abs(Kraftmatrix_SUSTAIN[3]))
						Kraftmatrix_SUSTAIN[3]	= FX;
					// FY
					var FY	= fround(dbgetdouble("KRAFT", "FY")/1000, 2);
					if (FY >= 0 && FY > Kraftmatrix_SUSTAIN[1])
						Kraftmatrix_SUSTAIN[1]	= FY;
					else if (FY < 0 && abs(FY) > abs(Kraftmatrix_SUSTAIN[4]))
						Kraftmatrix_SUSTAIN[4]	= FY;
					// FZ
					var FZ	= fround(dbgetdouble("KRAFT", "FZ")/1000, 2);
					if (FZ >= 0 && FZ > Kraftmatrix_SUSTAIN[2])
						Kraftmatrix_SUSTAIN[2]	= FZ;
					else if (FZ < 0 && abs(FZ) > abs(Kraftmatrix_SUSTAIN[5]))
						Kraftmatrix_SUSTAIN[5]	= FZ;
					// DX
					var DX	= fround(dbgetdouble("WEG", "DX"), 2);
					if (DX >= 0 && DX > Bewegmatrix_SUSTAIN[0])
						Bewegmatrix_SUSTAIN[0]	= DX;
					else if (DX < 0 && abs(DX) > abs(Bewegmatrix_SUSTAIN[3]))
						Bewegmatrix_SUSTAIN[3]	= DX;
					// DY
					var DY	= fround(dbgetdouble("WEG", "DY"), 2);
					if (DY >= 0 && DY > Bewegmatrix_SUSTAIN[1])
						Bewegmatrix_SUSTAIN[1]	= DY;
					else if (DY < 0 && abs(DY) > abs(Bewegmatrix_SUSTAIN[4]))
						Bewegmatrix_SUSTAIN[4]	= DY;
					// DZ
					var DZ	= fround(dbgetdouble("WEG", "DZ"), 2);
					if (DZ >= 0 && DZ > Bewegmatrix_SUSTAIN[2])
						Bewegmatrix_SUSTAIN[2]	= DZ;
					else if (DZ < 0 && abs(DZ) > abs(Bewegmatrix_SUSTAIN[5]))
						Bewegmatrix_SUSTAIN[5]	= DZ;
				}
				else if (HYDROTest){	// Druckprobe
					// FX
					var FX	= fround(dbgetdouble("KRAFT", "FX")/1000, 2);
					if (FX >= 0 && FX > Kraftmatrix_HYDRO[0])
						Kraftmatrix_HYDRO[0]	= FX;
					else if (FX < 0 && abs(FX) > abs(Kraftmatrix_HYDRO[3]))
						Kraftmatrix_HYDRO[3]	= FX;
					// FY
					var FY	= fround(dbgetdouble("KRAFT", "FY")/1000, 2);
					if (FY >= 0 && FY > Kraftmatrix_HYDRO[1])
						Kraftmatrix_HYDRO[1]	= FY;
					else if (FY < 0 && abs(FY) > abs(Kraftmatrix_HYDRO[4]))
						Kraftmatrix_HYDRO[4]	= FY;
					// FZ
					var FZ	= fround(dbgetdouble("KRAFT", "FZ")/1000, 2);
					if (FZ >= 0 && FZ > Kraftmatrix_HYDRO[2])
						Kraftmatrix_HYDRO[2]	= FZ;
					else if (FZ < 0 && abs(FZ) > abs(Kraftmatrix_HYDRO[5]))
						Kraftmatrix_HYDRO[5]	= FZ;
					// DX
					var DX	= fround(dbgetdouble("WEG", "DX"), 2);
					if (DX >= 0 && DX > Bewegmatrix_HYDRO[0])
						Bewegmatrix_HYDRO[0]	= DX;
					else if (DX < 0 && abs(DX) > abs(Bewegmatrix_HYDRO[3]))
						Bewegmatrix_HYDRO[3]	= DX;
					// DY
					var DY	= fround(dbgetdouble("WEG", "DY"), 2);
					if (DY >= 0 && DY > Bewegmatrix_HYDRO[1])
						Bewegmatrix_HYDRO[1]	= DY;
					else if (DY < 0 && abs(DY) > abs(Bewegmatrix_HYDRO[4]))
						Bewegmatrix_HYDRO[4]	= DY;
					// DZ
					var DZ	= fround(dbgetdouble("WEG", "DZ"), 2);
					if (DZ >= 0 && DZ > Bewegmatrix_HYDRO[2])
						Bewegmatrix_HYDRO[2]	= DZ;
					else if (DZ < 0 && abs(DZ) > abs(Bewegmatrix_HYDRO[5]))
						Bewegmatrix_HYDRO[5]	= DZ;
				}
				else{	// alle anderen
					// FX
					var FX	= fround(dbgetdouble("KRAFT", "FX")/1000, 2);
					if (FX >= 0 && FX > Kraftmatrix_ELSE[0])
						Kraftmatrix_ELSE[0]	= FX;
					else if (FX < 0 && abs(FX) > abs(Kraftmatrix_ELSE[3]))
						Kraftmatrix_ELSE[3]	= FX;
					// FY
					var FY	= fround(dbgetdouble("KRAFT", "FY")/1000, 2);
					if (FY >= 0 && FY > Kraftmatrix_ELSE[1])
						Kraftmatrix_ELSE[1]	= FY;
					else if (FY < 0 && abs(FY) > abs(Kraftmatrix_ELSE[4]))
						Kraftmatrix_ELSE[4]	= FY;
					// FZ
					var FZ	= fround(dbgetdouble("KRAFT", "FZ")/1000, 2);
					if (FZ >= 0 && FZ > Kraftmatrix_ELSE[2])
						Kraftmatrix_ELSE[2]	= FZ;
					else if (FZ < 0 && abs(FZ) > abs(Kraftmatrix_ELSE[5]))
						Kraftmatrix_ELSE[5]	= FZ;
					// DX
					var DX	= fround(dbgetdouble("WEG", "DX"), 2);
					if (DX >= 0 && DX > Bewegmatrix_ELSE[0])
						Bewegmatrix_ELSE[0]	= DX;
					else if (DX < 0 && abs(DX) > abs(Bewegmatrix_ELSE[3]))
						Bewegmatrix_ELSE[3]	= DX;
					// DY
					var DY	= fround(dbgetdouble("WEG", "DY"), 2);
					if (DY >= 0 && DY > Bewegmatrix_ELSE[1])
						Bewegmatrix_ELSE[1]	= DY;
					else if (DY < 0 && abs(DY) > abs(Bewegmatrix_ELSE[4]))
						Bewegmatrix_ELSE[4]	= DY;
					// DZ
					var DZ	= fround(dbgetdouble("WEG", "DZ"), 2);
					if (DZ >= 0 && DZ > Bewegmatrix_ELSE[2])
						Bewegmatrix_ELSE[2]	= DZ;
					else if (DZ < 0 && abs(DZ) > abs(Bewegmatrix_ELSE[5]))
						Bewegmatrix_ELSE[5]	= DZ;
				}
				//---------------------------------
				if (numRet >= numRet2){
					dbskip( "KRAFT" );
					if (numRet2 > 1){
						dbskip( "WEG" );
						numRet2	-= 1;
					}
				}
				else{
					dbskip( "WEG" );
					if (numRet > 1){
						dbskip( "KRAFT" );
						numRet	-= 1;
					}
				}
				//---------------------------------
				}
			}
			
			for (check = 0; check < 6; check++){
				// Matrix für "..._NORMAL" und "..._ALL"
				Kraftmatrix_NORMAL[check]	= (check < 3 ? (1) : (-1)) * max(abs(Kraftmatrix_OPERAT[check]), abs(Kraftmatrix_SUSTAIN[check]));
				Kraftmatrix_ALL[check]		= (check < 3 ? (1) : (-1)) * max(abs(Kraftmatrix_NORMAL[check]), abs(Kraftmatrix_ELSE[check]));
				Bewegmatrix_NORMAL[check]	= (check < 3 ? (1) : (-1)) * max(abs(Bewegmatrix_OPERAT[check]), abs(Bewegmatrix_SUSTAIN[check]));
				Bewegmatrix_ALL[check]		= (check < 3 ? (1) : (-1)) * max(abs(Bewegmatrix_NORMAL[check]), abs(Bewegmatrix_ELSE[check]));
				// Übersicht anhängen
				Kraftmatrix_OPERAT[6]		+= Kraftmatrix_OPERAT[check]	+ (check < 5 ? " " : "");
				Kraftmatrix_SUSTAIN[6]		+= Kraftmatrix_SUSTAIN[check]	+ (check < 5 ? " " : "");
				Kraftmatrix_HYDRO[6]		+= Kraftmatrix_HYDRO[check]		+ (check < 5 ? " " : "");
				Kraftmatrix_ELSE[6]			+= Kraftmatrix_ELSE[check]		+ (check < 5 ? " " : "");
				Kraftmatrix_NORMAL[6]		+= Kraftmatrix_NORMAL[check]	+ (check < 5 ? " " : "");
				Kraftmatrix_ALL[6]			+= Kraftmatrix_ALL[check]		+ (check < 5 ? " " : "");
				Bewegmatrix_OPERAT[6]		+= Bewegmatrix_OPERAT[check]	+ (check < 5 ? " " : "");
				Bewegmatrix_SUSTAIN[6]		+= Bewegmatrix_SUSTAIN[check]	+ (check < 5 ? " " : "");
				Bewegmatrix_HYDRO[6]		+= Bewegmatrix_HYDRO[check]		+ (check < 5 ? " " : "");
				Bewegmatrix_ELSE[6]			+= Bewegmatrix_ELSE[check]		+ (check < 5 ? " " : "");
				Bewegmatrix_NORMAL[6]		+= Bewegmatrix_NORMAL[check]	+ (check < 5 ? " " : "");
				Bewegmatrix_ALL[6]			+= Bewegmatrix_ALL[check]		+ (check < 5 ? " " : "");
			}
			// Kräfte
			RESTRAINTS[i].FORCES_OPERATING	= Kraftmatrix_OPERAT;
			RESTRAINTS[i].FORCES_SUSTAINED	= Kraftmatrix_SUSTAIN;
			RESTRAINTS[i].FORCES_HYDROTEST	= Kraftmatrix_HYDRO;
			RESTRAINTS[i].FORCES_ELSE		= Kraftmatrix_ELSE;
			RESTRAINTS[i].FORCES_NORMAL		= Kraftmatrix_NORMAL;
			RESTRAINTS[i].FORCES_ALL		= Kraftmatrix_ALL;
			// Bewegungen
			RESTRAINTS[i].MOVE_OPERATING	= Bewegmatrix_OPERAT;
			RESTRAINTS[i].MOVE_SUSTAINED	= Bewegmatrix_SUSTAIN;
			RESTRAINTS[i].MOVE_HYDROTEST	= Bewegmatrix_HYDRO;
			RESTRAINTS[i].MOVE_ELSE			= Bewegmatrix_ELSE;
			RESTRAINTS[i].MOVE_NORMAL		= Bewegmatrix_NORMAL;
			RESTRAINTS[i].MOVE_ALL			= Bewegmatrix_ALL;
		}
		
		var VertiAchs	= "TODO";
		var Positon		= "";
		var Gefunden	= false;
		/*
		// das geht so nicht - es gibt z.B. auch RIGID +XROD was nicht bedeutet das X senkrecht ist
		// in CII nur Y oder Z als Senkrecht möglich
		for (i = 0; i < RESTRAINTS.length; i++){
			if (RESTRAINTS[i].isHanger && RESTRAINTS[i].TypHanger == "Starr"){	// sobald eine gefunden wurde, wird diese aus Voreinstellung gesetzt
				for (check = 0; check < RESTRAINTS[i].RES_TYPEID.length; check++){
					if (rfind(toupper(trimleft(trimright(RESTRAINTS[i].RES_TYPEID[check], " "), " ")), "ROD") >= 0 && !Gefunden){
						VertiAchs	= toupper(left(RESTRAINTS[i].RES_TYPEID[check], strlen(RESTRAINTS[i].RES_TYPEID[check])-3));
						if (strlen(VertiAchs) > 1){
							Gefunden	= true;
							switch (VertiAchs){
								case "-X" :
									Positon	= 0;
									break;
								case "-Y" :
									Positon	= 1;
									break;
								case "-Z" :
									Positon	= 2;
									break;
								case "+X" :
									Positon	= 3;
									break;
								case "+Y" :
									Positon	= 4;
									break;
								case "+Z" :
									Positon	= 5;
									break;
								default :
									Gefunden = false;
									break;
							}
						}
					}
					
				}
			}
		}
		*/
		if (!Gefunden){
			for (i = 0; i < RESTRAINTS.length; i++){
				if (RESTRAINTS[i].isHanger && RESTRAINTS[i].Instload != "" && RESTRAINTS[i].Instload*1 != 0){
				// sobald eine gefunden wurde, wird diese aus Voreinstellung gesetzt
					// das geht so nicht - auch die anderen Richtungen sind z.T. gesetzt
					/*
					for (check = 0; check < RESTRAINTS[i].FORCES_HYDROTEST.length; check++){
						if (!Gefunden && abs(RESTRAINTS[i].FORCES_HYDROTEST[check]) > 0){
							Positon		= check;
							Gefunden	= true;
						}
						else if (Gefunden && abs(RESTRAINTS[i].FORCES_HYDROTEST[check]) > 0){ // mehr als ein Wert belegt
							Positon		= "";
						}
					}
					*/
					//if (Positon == ""){
						// wir versuchen die Hängerkaltlast in SUSTAINED zu finden
						strSQLStatement		= "select * from OUTPUT_HANGERS where abs(NODE)="+RESTRAINTS[i].NODE_NUM+" ";
						numRet	= dbselect("CAESAR", strSQLStatement, "HANGER");
						//if (numRet > 0){
							var Tolerance	= 0.02;	// +/-2% Toleranz
							var Instload	= RESTRAINTS[i].Instload;
							for (check = 0; check < RESTRAINTS[i].FORCES_SUSTAINED.length; check++){
								if ((1+Tolerance)*abs(Instload) >= abs(RESTRAINTS[i].FORCES_SUSTAINED[check]*1)
										&& (1-Tolerance)*abs(Instload) <= abs(RESTRAINTS[i].FORCES_SUSTAINED[check]*1)
										&& !Gefunden){
									Positon		= check;
									Gefunden	= true;
								}
							}
						//}
					//}
					// das kann man hier noch weiter treiben ... TODO
				}
			}
		}
		if (Gefunden){	// rausschreiben nach 'pipe' / 'vertikaldir_up'
			// in CII ist nur "VertiAchs = 2" oder "VertiAchs = 3" möglich
			switch (Positon){
				case 0		:
				case "0"	:
					VertiAchs = -1;	// X-Achse senkrecht - positive Richtung nach unten
					break;
				case 1		:
				case "1"	:
					VertiAchs = -2;	// Y-Achse senkrecht - positive Richtung nach unten
					break;
				case 2		:
				case "2"	:
					VertiAchs = -3;	// Z-Achse senkrecht - positive Richtung nach unten
					break;
				case 3		:
				case "3"	:
					VertiAchs = 1;	// X-Achse senkrecht - positive Richtung nach oben
					break;
				case 4		:
				case "4"	:
					VertiAchs = 2;	// Y-Achse senkrecht - positive Richtung nach oben
					break;
				case 5		:
				case "5"	:
					VertiAchs = 3;	// Z-Achse senkrecht - positive Richtung nach oben
					break;
				default		:
					Gefunden = false;
					break;
			}
		}
		
		// Bestimmung von "RH_TYP"
		FindRHTyp (RESTRAINT_TYPES, RESTRAINTS, VertiAchs);
		
		
		var tmpCaMainController	= new CaController();
		var pdmsManager			= new CaPdmsManager(tmpCaMainController);
		var FIN	= pdmsManager.writeFINfromCAESAR(RESTRAINTS, VertiAchs, strMDBPath, strMDBFileName);
		
		var response = {
			success : FIN.success,
			message : FIN.message
		};
		
		dbdisconnect("CAESAR");
		
        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},

	FindRHTyp : function (RESTRAINT_TYPES, RESTRAINTS, VertiAchs)
	{
		var Senkrechte	= (VertiAchs*1 == 2 ? "+Y" : "+Z");
		for (var check = 0; check < RESTRAINTS.length; check++){
			// wir bestimmen die Winkel
			if (Senkrechte == "+Y"){
				RESTRAINTS[check].PipeDir.ALPHA	= (RESTRAINTS[check].PipeDir.Z*1 != 0 ?
													atandeg((RESTRAINTS[check].PipeDir.X*1) / (RESTRAINTS[check].PipeDir.Z*1)) : 90);
				// ALPHA=0 -> Z-Achse - ALPHA=90 -> X-Achse
				if (abs(RESTRAINTS[check].PipeDir.ALPHA) == 0)
					RESTRAINTS[check].PipeDir.Achse	= "ACHSE_Z";
				else if (abs(RESTRAINTS[check].PipeDir.ALPHA) == 90)
					RESTRAINTS[check].PipeDir.Achse	= "ACHSE_X";
				else
					RESTRAINTS[check].PipeDir.Achse	= "SCHRAEG_ZX";
				
				RESTRAINTS[check].PipeDir.BETA	= (RESTRAINTS[check].PipeDir.Y*1 != 0 ?
													atandeg((RESTRAINTS[check].PipeDir.Y*1) / sqrt(pow(RESTRAINTS[check].PipeDir.X, 2) + pow(RESTRAINTS[check].PipeDir.Z, 2))) : 0);
				if (RESTRAINTS[check].PipeDir.Y*1 != 0){
					if (abs(RESTRAINTS[check].PipeDir.BETA) >= 86 && abs(RESTRAINTS[check].PipeDir.BETA) <= 94)	// senkrecht
						RESTRAINTS[check].PipeDir.Achse	= "ACHSE_Y";
					else{
						var TempSplit	= RESTRAINTS[check].PipeDir.Achse.split("_");
						RESTRAINTS[check].PipeDir.Achse	= "SCHRAEG_" + TempSplit[1] + "Y";
					}
				}
			}
			else{
				RESTRAINTS[check].PipeDir.ALPHA	= (RESTRAINTS[check].PipeDir.X*1 != 0 ?
													atandeg((RESTRAINTS[check].PipeDir.Y*1) / (RESTRAINTS[check].PipeDir.X*1)) : 90);
				// ALPHA=0 -> X-Achse - ALPHA=90 -> Y-Achse
				if (abs(RESTRAINTS[check].PipeDir.ALPHA) == 0)
					RESTRAINTS[check].PipeDir.Achse	= "ACHSE_X";
				else if (abs(RESTRAINTS[check].PipeDir.ALPHA) == 90)
					RESTRAINTS[check].PipeDir.Achse	= "ACHSE_Y";
				else
					RESTRAINTS[check].PipeDir.Achse	= "SCHRAEG_XY";
				
				RESTRAINTS[check].PipeDir.BETA	= (RESTRAINTS[check].PipeDir.Z*1 != 0 ?
													atandeg(RESTRAINTS[check].PipeDir.Z*1 / sqrt(pow(RESTRAINTS[check].PipeDir.X, 2) + pow(RESTRAINTS[check].PipeDir.Y, 2))) : 0);
				if (RESTRAINTS[check].PipeDir.Z*1 != 0){
					if (abs(RESTRAINTS[check].PipeDir.BETA) >= 86 && abs(RESTRAINTS[check].PipeDir.BETA) <= 94)	// senkrecht
						RESTRAINTS[check].PipeDir.Achse	= "ACHSE_Z";
					else{
						var TempSplit	= RESTRAINTS[check].PipeDir.Achse.split("_");
						RESTRAINTS[check].PipeDir.Achse	= "SCHRAEG_" + TempSplit[1] + "Z";
					}
				}
			}
			RESTRAINTS[check].RHTyp	= "";
			var again				= false;	// Wiederholung falls Typänderung
			if (RESTRAINTS[check].isHanger){	// alle Hänger (auch "Starr") und Stützen
				// Starr nur wenn ROD in senkrechter Achse
				for (var checkROD = 0; checkROD < RESTRAINTS[i].RES_TYPEID.length; checkROD++){
					if (rfind(toupper(trimleft(trimright(RESTRAINTS[check].RES_TYPEID[checkROD], " "), " ")), right(Senkrechte, 1) + "ROD") > 0
						|| rfind(toupper(trimleft(trimright(RESTRAINTS[check].RES_TYPEID[checkROD], " "), " ")), "ROD") < 0){
						// do nothing
					}
					else {	//was auch immer das ist - wir machen ein GL daraus
						RESTRAINTS[check].isHanger	= 0;
						RESTRAINTS[check].TypHanger	= "";
						RESTRAINTS[check].FRICTION	= 0.5;
						again						= true;
					}
				}
				switch (toupper(RESTRAINTS[check].TypHanger)){
					case "FH" :
						RESTRAINTS[check].RHTyp	= "FH";
						break;
					case "FS" :
						RESTRAINTS[check].RHTyp	= "FF";
						break;
					case "KH" :
						RESTRAINTS[check].RHTyp	= "KH";
						break;
					case "KS" :
						RESTRAINTS[check].RHTyp	= "KF";
						break;
					case "STARR" :
						RESTRAINTS[check].RHTyp	= "SH";
						break;
					case "SNUBBER" :
						RESTRAINTS[check].RHTyp	= "DB";
						break;
					default :
						break;
				}
				// ggf. noch doppelt setzen wenn wir in einer vertikalen sind
				if (!RESTRAINTS[check].isDoppelt){
					if (VertiAchs*1 == 2 && RESTRAINTS[check].PipeDir.Y*1 != 0
						&& RESTRAINTS[check].PipeDir.X*1 == 0
						&& RESTRAINTS[check].PipeDir.Z*1 == 0){
							RESTRAINTS[check].isDoppelt		= true;
							RESTRAINTS[check].Spannweite	= 300;	// Default
					}
					else if (VertiAchs*1 != 2 && RESTRAINTS[check].PipeDir.Z*1 != 0
						&& RESTRAINTS[check].PipeDir.X*1 == 0
						&& RESTRAINTS[check].PipeDir.Y*1 == 0){
							RESTRAINTS[check].isDoppelt		= true;
							RESTRAINTS[check].Spannweite	= 300;	// Default
					}
				}
			}
			else{	// das sind alle Lager
				if (RESTRAINTS[check].FRICTION*1 < 0){
					// das ist ein Festpunkt
					RESTRAINTS[check].RHTyp	= "FP";
				}
				else{
					// Gleitlager, Führungen, ...
					// mögliche Begrenzungen
					var Begr_Auflage	= false;
					var Begr_Abhebe		= false;
					var Begr_quer		= false;
					var Begr_axial		= false;
					
					for (var ResTyp = 0; ResTyp < RESTRAINTS[check].RES_TYPEID.length; ResTyp++){
						//rfind(ITEM.CA.FORMS.SYSTEMCHARAKTERISTIK.IDC_LASTABTRAGUNG, "DOPPEL")
						if (rfind(RESTRAINTS[check].RES_TYPEID[ResTyp], "SNB") != (-1)){
							RESTRAINTS[check].isHanger	= true;
							RESTRAINTS[check].TypHanger	= "SNUBBER";
							ResTyp						= RESTRAINTS[check].RES_TYPEID.length;
							check						-= 1;
						}
						else{
							switch (Senkrechte){
								case "+Y" :
									if (RESTRAINTS[check].PipeDir.Achse != "ACHSE_Y"){
										switch (RESTRAINTS[check].RES_TYPEID[ResTyp]){
											case "Y"	:
												Begr_Auflage	= true;
												Begr_Abhebe		= true;
												break;
											case "+Y"	:
												Begr_Auflage	= true;
												break;
											case "-Y"	:
												Begr_Abhebe		= true;
												break;
											case "X"	:
											case "-X"	:
											case "+X"	:
												if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_X")
													Begr_axial	= true;
												else if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_Z")
													Begr_quer	= true;
												break;
											case "Z"	:
											case "-Z"	:
											case "+Z"	:
												if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_Z")
													Begr_axial	= true;
												else if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_X")
													Begr_quer	= true;
												break;
											case "LIM"	:
											case "-LIM"	:
											case "+LIM"	:
													Begr_axial	= true;
												break;
											case "GUI"	:
											case "-GUI"	:
											case "+GUI"	:
													Begr_quer	= true;
											default :
												break;
										}
									}
									else {	// hier ist unklar in welche Richtung der Lagerfuss zeigt
										switch (RESTRAINTS[check].RES_TYPEID[ResTyp]){
											case "Y" :
											case "+Y" :
											case "-Y" :
												Begr_axial	= true;
												break;
											default :
												break;
										}
									}
									break;
								case "+Z" :
									if (RESTRAINTS[check].PipeDir.Achse != "ACHSE_Z"){
										switch (RESTRAINTS[check].RES_TYPEID[ResTyp]){
											case "Z"	:
												Begr_Auflage	= true;
												Begr_Abhebe		= true;
												break;
											case "+Z"	:
												Begr_Auflage	= true;
												break;
											case "-Z"	:
												Begr_Abhebe		= true;
												break;
											case "X"	:
											case "-X"	:
											case "+X"	:
												if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_X")
													Begr_axial	= true;
												else if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_Z")
													Begr_quer	= true;
												break;
											case "Y"	:
											case "-Y"	:
											case "+Y"	:
												if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_Y")
													Begr_axial	= true;
												else if (RESTRAINTS[check].PipeDir.Achse == "ACHSE_X")
													Begr_quer	= true;
												break;
											case "LIM"	:
											case "-LIM"	:
											case "+LIM"	:
													Begr_axial	= true;
												break;
											case "GUI"	:
											case "-GUI"	:
											case "+GUI"	:
													Begr_quer	= true;
											default :
												break;
										}
									}
									else {	// hier ist unklar in welche Richtung der Lagerfuss zeigt
										switch (RESTRAINTS[check].RES_TYPEID[ResTyp]){
											case "Z" :
											case "+Z" :
											case "-Z" :
												Begr_axial	= true;
												break;
											default :
												break;
										}
									}
									break;
								default	:
									break;
							}
						}
					}
					if (Begr_Auflage && Begr_Abhebe && Begr_axial && Begr_quer)
						RESTRAINTS[check].RHTyp	= "FP";
					else if (Begr_axial)
						RESTRAINTS[check].RHTyp	= "AX";
					else if (Begr_Auflage && Begr_quer)
						RESTRAINTS[check].RHTyp	= "FL";
					else if (Begr_quer)
						RESTRAINTS[check].RHTyp	= "QS";
					else
						RESTRAINTS[check].RHTyp	= "GL";
					
				}
			}
		}
	},
	
	/**
		Aufgerufen aus der Projektliste ermöglicht es diese Funktion, eine oder mehrere Typenschlüssel zu analysieren.
		Diese können entweder in eine Textarea in der Projektliste eingegeben oder aus einer Datei eingelesen werden.
		Die Ergebnisse werden in einer eigenen Vorschautabelle angezeigt, die von der Struktur her der Projektliste
		entspricht. Dort kann über Checkboxen gewählt werden, welche der analysierten Positionen in die eigentliche
		Projektliste übernommen werden sollen.
		Die angezeigte Tabelle steht in: TEMP.TYPNUMMER_ITEMS
	*/
    analysiereTypnummerAction : function()
    {
		var i;
		var strMsg = "";
		var strResults = "";

		/* 	-mw- 7.5.2015:
			Es gibt hier das Grundproblem, dass einige C++-Funktionen hart auf der Projektliste arbeiten
			und deshalb die Typenschlüssel-Analyse dort zum Teil ausgeführt wird. Das bewirkt ein ständiges
			Hin- und herkopieren. Das wird jetzt geändert, di C++_Funktionen werden nicht mehr aufgerufen,
			sie werden durch Skript-Funktionen ersetzt ...
		*/

		// Original sichern
		delete("DLGDATA", "TEMP");
		copy("DLGDATA", "TEMP.DLGDATA")

		var typManager = new CaTypsucheManager(caMainController);
		var strTyp = getstring("TYPNUMMER", "TEMP");
		// Wenn mehrere Typenschlüssel eingegeben wurden, werden diese hier aufgesplittet:
		var nAnzRows = stringtoarray(strTyp, "TEMP.TYPNUMMERN_WORK", "\n");
		for(i = 0; i < nAnzRows; i++)
		{
			strTyp = getstring("VALUE", arraypath("TEMP.TYPNUMMERN_WORK",i));
			if(strTyp == "")
				continue;

			setint("TYPNUMMER_WORK_INDEX", "TEMP", i);
			typManager.analysiereTypnummer(strTyp);

			// Ergebnisse sammeln: 1-ok, 0-false
			strResults += (typManager.bError==false) ? "1;" : "0;";

			// nur Meldung bei Fehlern
			strMsg += (typManager.bError==false ? "" : typManager.msgError + (nAnzRows > 1 ? "\r\n" : ""));
			// immer Meldung
			//strMsg += (typManager.bError==false ? typManager.msgOK : typManager.msgError) + (nAnzRows > 1 ? "\\r" : "");
		}
		delete("TYPNUMMERN_WORK", "TEMP");
	
		// Original wiederherstellen
		delete("", "DLGDATA");
		copy("TEMP.DLGDATA", "DLGDATA")
		delete("DLGDATA", "TEMP");

		// Ergebnis speichern
		setstring("TYPNUMMER_RESULT", "TEMP", left(strResults, strlen(strResults)-1));

        var response;
		response = {
			success : true,
			message : strMsg
		};

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
    },


    importiereEfinAction : function()
    {
		// Was wird gerade importiert
		var ImportFormat = getdlgvar("Was");
		// eFIN	... Import mit Bauteilen aus eFIN-File
		// FIN	... Import mit Bauteilen laut Default-Einstellungen
		var aResultLog = [];
		efinManager = new CaEfinImportManager();
		efinManager.importAllEFINtoProjectlist(aResultLog, ImportFormat);

		var strMsg = 'Analyzing positions has been completed.\nThe project list will be updated now.\n';
		var strMsg2 = '';
		var anzOK = 0, anzSkipped = 0, anzWarnings = 0, anzFailed = 0;
		for (var i = 0; i < aResultLog.length; i++) {
			if (aResultLog[i].nResult > 0){
				anzOK++;
				// Positon ist OK kann aber trotzdem eine Message haben
				if (aResultLog[i].strMessage != '')
					strMsg2 += 'Flexperte position ' + aResultLog[i].strFLPos + (aResultLog[i].strMark != '' ? ' (' + aResultLog[i].strMark + ')' : '' ) + ':\n' + aResultLog[i].strMessage + '\n';
			}
			else if (aResultLog[i].nResult == 0){
				anzSkipped++;
				strMsg2 += 'Import position ' + aResultLog[i].strPos + (aResultLog[i].strMark != '' ? ' (' + aResultLog[i].strMark + ') ' : '' ) + ( aResultLog[i].strMessage != '' ? ':\n' + aResultLog[i].strMessage : ':\nskipped\n' ) + '\n';
			}
			else if (aResultLog[i].nResult == -1) {
				strMsg2 += 'Flexperte position ' + aResultLog[i].strFLPos + (aResultLog[i].strMark != '' ? ' (' + aResultLog[i].strMark + ')' : '' ) + ':\n' + aResultLog[i].strMessage + '\n';
				anzWarnings++;
			}
			else if (aResultLog[i].nResult < -1) {
				strMsg2 += 'Import position ' + aResultLog[i].strPos + (aResultLog[i].strMark != '' ? ' (' + aResultLog[i].strMark + ')' : '' ) + ':\n' + aResultLog[i].strMessage + '\n\n';
				anzFailed++;
			}
		}
		strMsg += 'Total count positions: ' + i + '\n';
		if (anzOK > 0)       strMsg += 'Positions analyzed OK: ' + anzOK + '\n';
		if (anzSkipped > 0)  strMsg += 'Positions skipped    : ' + anzSkipped + '\n';
		if (anzWarnings > 0) strMsg += 'Positions w. warnings: ' + anzWarnings + '\n';
		if (anzFailed > 0)   strMsg += 'Positions FAILED     : ' + anzFailed + '\n';
		
		strMsg	+= '\n';
		
		if (strMsg2 != '')
			strMsg += strMsg2;
		
		// das Ergebnis noch in eine Datei schreiben
		var strUserExportPath	= getstring("IMPORT_STK_VERZEICHNIS", "");
		var Datei_Result		= filedialog(0, "rtf", "eFIN_Import_Result.rtf", "*.rtf", strUserExportPath);
		if (Datei_Result != ""){
			setstring("PROJECT.PROJECTPATH", "", left(Datei_Result, Datei_Result.length - 3) + "wit");
			setstring("EXPORT_CAD_VERZEICHNIS", "PROJECT.SETTINGS", strUserExportPath);
			setstring("EXPORT_STK_VERZEICHNIS", "", strUserExportPath);
			specialexec("SaveProject");
			strMsg	+= 'Import saved:\n' + getstring ("PROJECT.PROJECTPATH", "");
			writefile(Datei_Result, strMsg, "wc");
			shellexecuteex( Datei_Result, "", "", 1 );    // show = 1
			// da die Ergebnisdatei gespeichert wurde, müssen die einzelnen Ergebnisse nicht direkt angezeigt werden
			var TmpMsg	= strMsg.split('\n');
			var weiter	= true;
			var zeile	= 0;
			strMsg		= '';
			while (weiter){
				strMsg	+= TmpMsg[zeile] + '\n';
				if (TmpMsg[zeile] == '')
					weiter	= false;
				zeile++;
			}
		}
		else{
			strMsg	+= "Result data not saved!"
		}
		
		var response = {
			success : true,
			message : strMsg
		};

        echo response.toJSON();
        _global.MIMETYPE = 'application/json';
	},
	
	/**
	 * @deprecated Heart beat - Session to prevent loss -
	 */
    heartbeatAction: function(){
		var m_result = new Object();				
		m_result.message= 'Heartbeat';
		
		echo m_result.toJSON();		
	}

});
