/**
 * Custom Controller
 */
CustomController = function()
{
	CustomController.superclass.constructor.call(this);
}

EasyKat.extend( CustomController, EasyKat.Controller.Action,
{
	// Called before Action
	preDispatch: function() 
    {
        // immer Zufallszahl neu erzeugen, damit die Skripte auf der Index-HTML-Seite im Falle
        // des neu Ladens vom Browser auch wirklich neu geladen werden:
        setstring("randid", "", rand());
		
		// --gl-- Wurde aus der Klassendefinition hierher verlegt,
		// da die exe zum Zeitpunkt der Initialisierung in einem
		// undefinierten Zustand ist.
		// Trotzdem ist das hier nicht so glcklich. Aber zunchst funktioniert
		// es mal.
		caMainController = new CaController();
		
        if (getstring("EKSUBMITEVENT","") == "IDC_BASKET")
        {
            caMainController.topologieKlasse.serializeOut("DLGDATA.CA.SELECTION.TOPOCLASS");

            var strHaengerText = "";
            var strFHTerroson = "";
            var strKHTerroson = "";
            var myHaenger = caMainController.topologieKlasse.getCurrentHaenger();
            if (myHaenger)
            {
                strHaengerText = myHaenger.m_Ptyp;
                if (myHaenger.isFHaenger() && (myHaenger.m_Pbeschicht == "TERROSON"))
                    strFHTerroson = "TERROSON";
                if (myHaenger.isKHaenger() && (myHaenger.m_Pbeschicht == "TERROSON"))
                    strKHTerroson = "TERROSON";
            }

            var strTarget 		= "DLGDATA";
            var strShorttext    = "";   // "Lastkette";
            var strTyp          = "";   // "Lastkette mit " + strHaengerText;

            if (atoi(getstring("QTY", strTarget) <= 0))
                setstring("QTY", strTarget ,  "1");

            var oPruefungAbnahme = caMainController.getPruefungAbnahme(atoi(getstring("QTY", strTarget)));
            var oLKinfo          = caMainController.dataAccess.getLKinfoDaten();
                
            var stkList             = [];
            caMainController.topologieKlasse.getStueckliste(stkList);
            var bSetTyp = false;
            var strSingleTyp = "";
            if (stkList.length == 1)
            {
                bSetTyp = true;
                strSingleTyp = stkList[0].produkt.m_Ptyp;
            }

            var LKMatInfo       = caMainController.topologieKlasse.getLastkettenIdent(caMainController);
            var strIdent        = LKMatInfo.matnr;
            if (LKMatInfo.aTexte.length > 0)
                strTyp = LKMatInfo.aTexte[0];
            if (bSetTyp)
                strTyp = strTyp + "<br>" + strSingleTyp;
            else if (LKMatInfo.aTexte.length > 1)
                strTyp = strTyp + "<br>" + LKMatInfo.aTexte[1];
                
            if (LKMatInfo.aTexte.length > 2)
            {
                for (var i = 0; i < LKMatInfo.aTexte.length; ++i)
                {
                    strShorttext = strShorttext + LKMatInfo.aTexte[i];
                    if (i < LKMatInfo.aTexte.length - 1)
                        strShorttext = strShorttext + "<br>";
                }
            }
            if (oLKinfo.markierung != "")
                strTyp = oLKinfo.markierung + "<br>" + strTyp;
                
            setstring("SHORTTEXT", 	strTarget ,  strShorttext);
            setstring("ORDERCODE", 	strTarget ,  strTyp);
            setstring("ORDERCODE_PROJECTLIST", 	strTarget ,  strTyp);
            setstring("IDENT", 		strTarget ,  strIdent);
            setstring("MARKIERUNG", strTarget ,  oLKinfo.markierung);

            setstring("FHTERROSON", strTarget ,  strFHTerroson);
            setstring("KHTERROSON", strTarget ,  strKHTerroson);

            setstring("CACHE_DRAWING_FILE_PDF", strTarget, ""); 
            setstring("CACHE_DRAWING_FILE_PDF_SAP",	strTarget, "");
            setstring("CACHE_DRAWING_FILE_DXF", strTarget, ""); 
            setstring("STATUS_PREIS", strTarget, caMainController.topologieKlasse.preisStatus);
            setstring("STATUS_MATNR", strTarget, caMainController.topologieKlasse.matStatus);

            // Preise / Kalkulation: hier nicht vorgesehen ...
            // hier nur Techwert oder double merken, formatieren bernimmt zentrale Projekt-Funktion:
            
            setdouble("DUNITWEIGHT", 	 strTarget, caMainController.topologieKlasse.gesamtGewicht);    // Gesamtgewicht
            if (caMainController.topologieKlasse.preisStatus == "ERROR")
				setdouble("DUNITPRICE", 	 strTarget, 0);		// wenn Einzelpreise fehlen den ermittelten Preis nicht anzeigen
			else
				setdouble("DUNITPRICE", 	 strTarget, caMainController.topologieKlasse.gesamtPreis);	// Stckpreis OHNE Prfung, Abnahme
            // -mw- 08/2008: Vertrieb will nicht, dass dieser Wert berschrieben wird, statt dessen Warnung ausgeben
            // setstring("FORCEDUNITPRICE", strTarget,"");	        // Vom VB festgesetzter Stueckpreis, als STRING, kann in Projektliste gendert werden
            setdouble("INT_ACCEPT_CALC_PRICE", 	strTarget, oPruefungAbnahme.dKostenDokumentation);      // dKostenPruefungAbnahme -mw- 04/2008 auf Wunsch Geiger Prfung, Abnahme wenn bei WI, berechnete Kosten
            setdouble("EXT_ACCEPT_CALC_PRICE", 	strTarget, 0);  // Prfung, Abnahme extern, berechnete Kosten
            setstring("INT_ACCEPT_SET_PRICE",   strTarget, "");	// Vom VB festgesetzter Kosten, als STRING, kann in Projektliste gendert werden
            setstring("EXT_ACCEPT_SET_PRICE",   strTarget, "");	// Vom VB festgesetzter Kosten, als STRING, kann in Projektliste gendert werden
            
            // ALT:
            setdouble("DADDEDPOSPRICE", strTarget, "");	// Zus. Kosten fr die Position (f. Dokumentation o..)
            setstring("FORCEDPOSPRICE", strTarget, "");	// Vom VB festgesetzter Positionspreis, als STRING, kann in Projektliste gendert werden
            
            
            // Wichtig: den letzten Screen merken, der zu diesem Weg gefhrt hat:
            setstring("MODIFY_ENTRY_SCREEN", strTarget ,	"IDD_CASCADE");

            // Sowie den Produktbereich (welcher "Experte" ist zustndig?)
            setstring("PRODUCT_AREA", strTarget , "CA");

            // Bei bernahme Auslegung in Projektliste diese ankreuzen; in der Regel will man diese ja auch verwenden
            setstring("SAP_CHECK", strTarget , "true");

            specialexec("UebernehmeAuswahlInProjektliste");
            
            // Sonderfall Aufruf aus PDS / PDMS - System: Wir mssen das Projekt speichern, STK-File erzeugen
            var outFile = getstring("OUTFILE", "ROOT");
            if (outFile != "")
            {
                specialexec("SaveProject");
                pdmsManager = new CaPdmsManager(caMainController);
                writefile( outFile, "\r\n", "wc" );   // Damit die Datei neu erzeugt wird
                pdmsManager.writeStkFromProjectlist(outFile);
            }
            
        }
	},
	
	// Called after Action
	postDispatch: function() {
        if (getstring("KILL_CAMAINCONTROLLER", "") == "true");
        {
            setstring("KILL_CAMAINCONTROLLER", "", "");
            caMainController = null;
        }
        if (caMainController)
            caMainController.topologieKlasse.serializeOut("DLGDATA.CA.SELECTION.TOPOCLASS");

            
	},
	
	initEnv : function() 
	{
		CustomController.superclass.initEnv.call(this);
        // ekstoragesubmit();
		specialexec("DoAction");
	}
});