/**
 * AuswahlSchelleController
 */
AuswahlSchelleController = function() {
	AuswahlSchelleController.superclass.constructor.call(this);
};

EasyKat.extend(AuswahlSchelleController, CustomController, {

	getImagesAction : function() 
	{
		var rows = { images: [] };
        var lkTyp               = caMainController.dataAccess.getLastketteTyp();
        var lkLastabtragung     = caMainController.dataAccess.getLastketteLastabtragung();
        var refTemp             = caMainController.dataAccess.getReferenzTemperatur(1);
		var VorgabeWS			= caMainController.dataAccess.getSchellenWerkstoffVorgabeAsInteger();
		var showClamps			= false;
		var isExpertMode		= getstring("EXPERT_MODE", "RIGHTS");
		var strSQLStatement		= "select * from AUSLTEMPMAX where EXPERT = " + isExpertMode + " ";
		var numret				= dbselect("CASCADE", strSQLStatement, "TEMPMAX");
		if (numret){
			var ClampMaxTemp	= dbgetdouble("TEMPMAX", "MAXTEMPSCHELL");
			if (ClampMaxTemp >= refTemp)
				showClamps	= true;
		}
		

        var strHangerTypId = "";
        var strLGG = "";
        var Haenger = caMainController.topologieKlasse.getCurrentHaenger();
        if (Haenger)
            strHangerTypId = Haenger.m_Ptypid;
        if (Haenger && Haenger.isFHaenger())
            strLGG = Haenger.m_strLGG;
 
        var passendeSchellen;
		var passendeS_Lasche;
		
        var strSchellenTyp;
        if (caMainController.topologieKlasse.bVertikal)
        {
            passendeSchellen = caMainController.legeVSchellenAus(strLGG);
			passendeS_Lasche = caMainController.legeHSchellenAus(lkTyp);
            if ((lkLastabtragung == "STUETZEND_DOPPEL") || (lkTyp == "GELENKSTREBE") || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
                strSchellenTyp = "VS";   // Vertikalschelle fr Sttzen
            else
                strSchellenTyp = "VH";   // Vertikalschelle fr Hnger
        }
        else
        {
            // Bei Auswahl FSG / SSG / SSB einzeln gibt es spezielle Schellen:
            if ((lkTyp == "GELENKSTREBE") || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
            {
                //strSchellenTyp = "MSN";
				strSchellenTyp = "DYN";
            }
            else if ((lkLastabtragung == "STUETZEND_EINFACH") ||
                (lkLastabtragung == "HAENGEND_DOPPEL"))
            {
                // Lagerauslegung hat separaten lngeren Auswahlweg
                if (lkLastabtragung == "STUETZEND_EINFACH")
                    strSchellenTyp = "LS";   // Lager fr Sttze
                else
                    strSchellenTyp = "LH";   // Lager fr Hnger, d.h. Traverse gehrt dazu
            }
            else
            {   
                passendeSchellen = caMainController.legeHSchellenAus(lkTyp);
                strSchellenTyp = "H";   // Horizontalschelle
            }
        }

        /*
                // Return-Objekt fr die V-Schellensuche:
                // retObjSuche = {success : success, message : "", vbk : vbk, vxk : vxk, vxr : vxr, vgr : vgr, vsr : vsr, vpr : vpr};
                
                // VSR / VPR bei Federsttzen
                // VPR bei Konstantsttzen
                // VGR bei SSG / FSG doppelt
                // VBK, VJR, VJK bei Federhngern, Konstanthngern

                // VJK / VKK und VJR / VKR sind jeweils Zwillinge, Unterscheidung anhand der Grunddaten
                // Bilder gibts nur fr ... VBK, VJK, VJR

                // VGR ist fr FSG / SSG
                // VSR ist fr FSS
                // VPR ist fr FSP / KSP
                // KSR ist fr sttzend doppel nicht zugelassen!
        */
        
        if (showClamps){
			if ((strSchellenTyp == "VS") || (lkTyp == "EINZEL_SCHELLE"))
			{
				if (passendeSchellen.vgr && ((strHangerTypId == "FSG")|| (strHangerTypId == "SSG") || (strHangerTypId == "SSB") || (lkTyp == "EINZEL_SCHELLE")))
					rows.images.push( { id : "VGR" , src : "catalog/client/custom/img/panels/ISO/TVGR.png", qtip : "", shortName: passendeSchellen.vgr.m_Ptyp } );
				if (passendeSchellen.vsr && ((strHangerTypId == "FSS") /*|| (strHangerTypId == "SSG")*/ || (lkTyp == "EINZEL_SCHELLE")))
					rows.images.push( { id : "VSR" , src : "catalog/client/custom/img/panels/ISO/TVSR.png", qtip : "", shortName: passendeSchellen.vsr.m_Ptyp } );
				if (passendeSchellen.vpr && ((strHangerTypId == "FSP")||(strHangerTypId == "KSP") || (lkTyp == "EINZEL_SCHELLE")))
					rows.images.push( { id : "VPR" , src : "catalog/client/custom/img/panels/ISO/TVPR.png", qtip : "", shortName: passendeSchellen.vpr.m_Ptyp } );
				
				if ((lkTyp == "GELENKSTREBE") || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
				{
					if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" || (lkTyp == "GELENKSTUETZE")){
						if (caMainController.topologieKlasse.bHaengend)
							rows.images.push( { id : "MBS" , src : "catalog/client/custom/img/panels/ISO/TMBSU.png", qtip : "", shortName: "MBS" } );
						else
							rows.images.push( { id : "MBS" , src : "catalog/client/custom/img/panels/ISO/TMBSO.png", qtip : "", shortName: "MBS" } );
					}
					else{
						if (caMainController.topologieKlasse.bHaengend)
							rows.images.push( { id : "MBW" , src : "catalog/client/custom/img/panels/ISO/TMBWU.png", qtip : "", shortName: "MBW" } );
						else
							rows.images.push( { id : "MBW" , src : "catalog/client/custom/img/panels/ISO/TMBWO.png", qtip : "", shortName: "MBW" } );
					}
				}
			}
			if ((strSchellenTyp == "VH") || (lkTyp == "EINZEL_SCHELLE"))
			{
				if (passendeSchellen.vbk)
					rows.images.push( { id : "VBK" , src : "catalog/client/custom/img/panels/ISO/TVBK.png", qtip : "", shortName: passendeSchellen.vbk.m_Ptyp } );
				if (passendeSchellen.vxk)
					rows.images.push( { id : "VXK" , src : "catalog/client/custom/img/panels/ISO/TVKK.png", qtip : "", shortName: passendeSchellen.vxk.m_Ptyp } );
				if (passendeSchellen.vxr)
					rows.images.push( { id : "VXR" , src : "catalog/client/custom/img/panels/ISO/TVKR.png", qtip : "", shortName: passendeSchellen.vxr.m_Ptyp } );
				if ((lkTyp != "EINZEL_SCHELLE") && (refTemp <= 80))
					rows.images.push( { id : "ZLN" , src : "catalog/client/custom/img/panels/ISO/TZLNU.png", qtip : "", shortName: "ZLN" } );
				if ((passendeS_Lasche.s_lasche_v) && (lkTyp != "EINZEL_SCHELLE"))
					rows.images.push( { id : "S_Lasche_V" , src : "catalog/client/custom/img/panels/ISO/TZLV.png", qtip : "", shortName: passendeS_Lasche.s_lasche_v.m_Ptyp } );
				if ((passendeS_Lasche.s_lasche_b) && (lkTyp != "EINZEL_SCHELLE"))
					rows.images.push( { id : "S_Lasche_B" , src : "catalog/client/custom/img/panels/ISO/TZLB.png", qtip : "", shortName: passendeS_Lasche.s_lasche_b.m_Ptyp } );
			}
			if (strSchellenTyp == "LH")
			{
				// Erstmal gibts nur die Traverse
				rows.images.push( { id : "LAGER_DUMMY" , src : "catalog/client/custom/img/panels/THAN.png", qtip : "", shortName: 'Platzhalter Lager' } );
				if (! caMainController.topologieKlasse.isFDTAuswahl())
					rows.images.push( { id : "ZTN" , src : "catalog/client/custom/img/panels/ISO/TZTN.png", qtip : "", shortName: 'Traverse' } ); 
			}
			if (strSchellenTyp == "LS")
			{
				// vorlufig nur einen Dummy hier reinsetzen
				rows.images.push( { id : "LAGER_DUMMY" , src : "catalog/client/custom/img/panels/THAN.png", qtip : "", shortName: 'Platzhalter Lager' } );
			}
			if ((strSchellenTyp == "H") || (lkTyp == "EINZEL_SCHELLE"))
			{
				if (passendeSchellen.zwei)
					rows.images.push( { id : "ZWEILOCHSCHELLE" , src : "catalog/client/custom/img/panels/ISO/THZN.png", qtip : "", shortName: passendeSchellen.zwei.m_Ptyp } );
				if (passendeSchellen.drei)
					rows.images.push( { id : "DREILOCHSCHELLE" , src : "catalog/client/custom/img/panels/ISO/THDN.png", qtip : "", shortName: passendeSchellen.drei.m_Ptyp } );
				if (passendeSchellen.grip)
					rows.images.push( { id : "GRIPSCHELLE" , src : "catalog/client/custom/img/panels/ISO/THGN.png", qtip : "", shortName: passendeSchellen.grip.m_Ptyp } );
				if (passendeSchellen.bgel)
					rows.images.push( { id : "BUEGELSCHELLE" , src : "catalog/client/custom/img/panels/ISO/THBN.png", qtip : "", shortName: passendeSchellen.bgel.m_Ptyp } );
				
				if ((lkTyp != "EINZEL_SCHELLE") && (refTemp <= 80) && (VorgabeWS < 4))
					rows.images.push( { id : "ZLN" , src : "catalog/client/custom/img/panels/ISO/TZLNU.png", qtip : "", shortName: "ZLN" } );
				//if ((passendeSchellen.s_lasche_v) && (lkTyp != "EINZEL_SCHELLE"))
				if (passendeSchellen.s_lasche_v)
					rows.images.push( { id : "S_Lasche_V" , src : "catalog/client/custom/img/panels/ISO/TZLV.png", qtip : "", shortName: passendeSchellen.s_lasche_v.m_Ptyp } );
				//if ((passendeSchellen.s_lasche_b) && (lkTyp != "EINZEL_SCHELLE"))
				if (passendeSchellen.s_lasche_b)
					rows.images.push( { id : "S_Lasche_B" , src : "catalog/client/custom/img/panels/ISO/TZLB.png", qtip : "", shortName: passendeSchellen.s_lasche_b.m_Ptyp } );
			}
			
			rows.message = "";
			
			//if (strSchellenTyp == "MSN")
			if (strSchellenTyp == "DYN")
			{
				// oben / unten ...
				// Platzhalter MBS, sowie ohne
				var oRet = caMainController.CompShowDYN(caMainController.topologieKlasse.getLGG());
				//if (oRet.success)   // wird einmal hier und dann unten nochmal ausgelegt, um das Zwischenspeichern zu sparen
				if (oRet.msn)
				{
					if (caMainController.topologieKlasse.bHaengend)
						rows.images.push( { id : "MSN" , src : "catalog/client/custom/img/panels/ISO/TMSNU.png", qtip : "", shortName: 'MSN' } );
					else
						rows.images.push( { id : "MSN" , src : "catalog/client/custom/img/panels/ISO/TMSNO.png", qtip : "", shortName: 'MSN' } );
				}
				//if (oRet.success)   // wird einmal hier und dann unten nochmal ausgelegt, um das Zwischenspeichern zu sparen
				// MSL nicht fr VC
				//if (oRet.msl && toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) != "TRUE")
				if (!getbool("CLIENTVERSION", "RIGHTS"))
				{
					if (caMainController.topologieKlasse.bHaengend)
						rows.images.push( { id : "MSL" , src : "catalog/client/custom/img/panels/ISO/TMSLU.png", qtip : "", shortName: 'MSL' } );
					else
						rows.images.push( { id : "MSL" , src : "catalog/client/custom/img/panels/ISO/TMSLO.png", qtip : "", shortName: 'MSL' } );
				}
				if (toupper(getstring("IDC_SSG_LISEGA_CHECK", "PROJECT.SETTINGS.CASCADE")) == "TRUE" || (lkTyp == "GELENKSTUETZE")){
					if (caMainController.topologieKlasse.bHaengend)
						rows.images.push( { id : "MBS" , src : "catalog/client/custom/img/panels/ISO/TMBSU.png", qtip : "", shortName: "MBS" } );
					else
						rows.images.push( { id : "MBS" , src : "catalog/client/custom/img/panels/ISO/TMBSO.png", qtip : "", shortName: "MBS" } );
				}
				else{
					if (caMainController.topologieKlasse.bHaengend)
						rows.images.push( { id : "MBW" , src : "catalog/client/custom/img/panels/ISO/TMBWU.png", qtip : "", shortName: "MBW" } );
					else
						rows.images.push( { id : "MBW" , src : "catalog/client/custom/img/panels/ISO/TMBWO.png", qtip : "", shortName: "MBW" } );
				}
				if (oRet.message != "")
					rows.message = oRet.message;
			}
        }
		
		if (getstring("EXPERT_MODE", "RIGHTS") == "1")
		{
			rows.images.push( { id : "OHNE" , src : "catalog/client/custom/img/panels/ISO/TEMPTY.png", qtip : "", shortName: translate('ID_OHNE') } );
		}
		
		else if (((lkTyp != "EINZEL_SCHELLE") && /*(strSchellenTyp != "MSN")*/ (strSchellenTyp != "DYN")) || !showClamps)
            rows.images.push( { id : "OHNE" , src : "catalog/client/custom/img/panels/ISO/TEMPTY.png", qtip : "", shortName: translate('ID_OHNE') } );   
        
        rows.selected = rows.images[0].id;
        
        //rows.message = "";
        
        // Message aus SollwerteRohrumschliessendesTeilController
        if (getstring("HINWEIS_SONDERDRUCH", "TMP") != "")
        {
            rows.message = getstring("HINWEIS_SONDERDRUCH", "TMP");
            setstring("HINWEIS_SONDERDRUCH", "TMP", "");
        }
        // Diese Message ist aber wichtiger und demnach als zweites dran:
        if (passendeSchellen.message && (passendeSchellen.message != ""))
            rows.message = passendeSchellen.message;
		
		echo rows.toJSON();
	},
	
	setValuesAction : function() {
        // selektiertes Bild setzen ...
		// Eigentlich bernimmt das das Framework
		// var submitValues = Object.fromStorage( "DLGDATA.CA.FORMS.AUSWAHL_SCHELLENTYP" );
		var extversion = getstring("VERSION","CATALOG.UI");
        var lkTyp               = caMainController.dataAccess.getLastketteTyp();
		
		if ( extversion == "2" ) {
			// Hier noch die ausgewhlte Schelle ins Topologie-Objekt bernehmen ....
			var strSelectedSchelle = getstring("IDC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_SCHELLE"); // = wie oben die ID!
		} else {
			// Hier noch die ausgewhlte Schelle ins Topologie-Objekt bernehmen ....
			var strSelectedSchelle = getstring("IDC_AWSC_IMAGE_ID", "DLGDATA.CA.FORMS.AUSWAHL_SCHELLENTYP"); // = wie oben die ID!
		}
			
        caMainController.topologieKlasse.Lasche = null;
		
		// var TEST	= caMainController.topologieKlasse;

        if (strSelectedSchelle == "OHNE")
        {
            caMainController.topologieKlasse.Schelle = null;
			if (typeof(caMainController.topologieKlasse.Bock1) == "object")
				caMainController.topologieKlasse.setBockSchelle("NULL");
        }
        else if (strSelectedSchelle == "ZLN")
        {

            // ZLN sollte dazu nur bei Hngend einfach auftreten ...
            // bei hngend doppel im Moment nicht vorgesehen ...
            // --> wenn doch bei Schelle, dann verhindern, dass sie im Massenauszug kommt
            // und aufpassen bei getSchelleDaten! Wir knnen die Sollwerte RuT nicht an der
            // Lasche unterbringen oder wir mssen das Projektfileformat updaten!
            caMainController.topologieKlasse.Schelle = null;
            var myUntererAnschluss = new Zubehoer();    
            if (myUntererAnschluss.Init( "ZLN", caMainController.topologieKlasse.a_lgv, "IDL_C_ZLN_U") >= 0)
                caMainController.topologieKlasse.Schelle = myUntererAnschluss;
        }
		
		else if (((strSelectedSchelle == "S_Lasche_V") || (strSelectedSchelle == "S_Lasche_B")) && (caMainController.topologieKlasse.bDoppelt))
        {
			caMainController.topologieKlasse.Schelle = null;
            var myUntererAnschluss = new Horizontalschelle()
			myUntererAnschluss.serializeIn("TMP.CASELECTIONS.SCHELLE." + strSelectedSchelle);
                caMainController.topologieKlasse.Schelle = myUntererAnschluss;
		}
		
		else if (caMainController.topologieKlasse.bDoppelt)
        {
            if (caMainController.topologieKlasse.bVertikal)
            {
                if (strSelectedSchelle == "MBS" || strSelectedSchelle == "MBW")
                {
                    caMainController.topologieKlasse.Schelle = null;
                    caMainController.topologieKlasse.setBockSchelle("SET");
                }
                else
                {
                    var mySchelle = new Vertikalschelle();    
					mySchelle.serializeIn("TMP.CASELECTIONS.SCHELLE." + strSelectedSchelle);
					
					if ((lkTyp == "GELENKSTREBE") || (lkTyp == "GELENKSTUETZE") || (lkTyp == "STOSSBREMSE"))
                        caMainController.topologieKlasse.setSchelle(mySchelle, 0);
                    else
                        caMainController.topologieKlasse.Schelle = mySchelle;
                }
            }
            else
            {
                // Da wir bei der Lagerauswahl nicht mehr hier durch kommen, wird auch die Traverse hier nicht mehr angelegt!
                // D.h. verlegt in den Controller fr Sollwerte Spannweite einzel?
                var myTraverse = new Zubehoer();    
                myTraverse.InitZTN(caMainController.topologieKlasse.a_lgv, caMainController.dataAccess.getSpannweite(1));
                caMainController.topologieKlasse.Traverse = myTraverse;
            }
        }
        else
        {
            if (strSelectedSchelle == "MSN")
            {
				var oRet = caMainController.CompShowDYN(caMainController.topologieKlasse.getLGG());
                if (oRet.success)
                    caMainController.topologieKlasse.setSchelle(oRet.msn, 1);
            }
			else if (strSelectedSchelle == "MSL"){
				var oRet = caMainController.CompShowDYN(caMainController.topologieKlasse.getLGG());
                if (oRet.success)
                    caMainController.topologieKlasse.setSchelle(oRet.msl, 1);
			}
            else if (strSelectedSchelle == "MBS" || strSelectedSchelle == "MBW")
            {
                caMainController.topologieKlasse.Schelle = null;
                caMainController.topologieKlasse.setBockSchelle("SET");
            }
            else if ((strSelectedSchelle != "LAGER_DUMMY") && (strSelectedSchelle != "OHNE"))
            {
                var mySchelle = new Horizontalschelle();
                mySchelle.serializeIn("TMP.CASELECTIONS.SCHELLE." + strSelectedSchelle);
                caMainController.topologieKlasse.Schelle = mySchelle;
                // die Lasche ....
                if (strSelectedSchelle == "ZWEILOCHSCHELLE")
                {
                    var myLasche = new Zubehoer();    
                    if (myLasche.serializeIn("TMP.CASELECTIONS.SCHELLE.LASCHE") >= 0)
                        caMainController.topologieKlasse.Lasche = myLasche;
                }
            }
        }
        
	}
});