/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4
 *
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * 
 * EasyKat Base Class ported from Ext JS (c) 2007 Jack Slocum (http://extjs.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */
if ( typeof EasyKat == "undefined" )
	var EasyKat = {};


/**
 * Copies all the properties of config to obj.
 * @param {Object} obj The receiver of the properties
 * @param {Object} config The source of the properties
 * @param {Object} defaults A different object that will also be applied for default values
 * @return {Object} returns obj
 * @member EasyKat apply
 */
EasyKat.apply = function(o, c, defaults){
    if(defaults){
        // no "this" reference for friendly out of scope calls
        EasyKat.apply(o, defaults);
    }
    if(o && c && typeof c == 'object'){
        for(var p in c){
            o[p] = c[p];
        }
    }
    return o;
};

(function(){
	if (! _global.HEADER)
		_global.HEADER = '';
	var header = _global.HEADER.split("\r\n");
	var headers = {};
		
	for (var i=0; i < header.length; i++ ) {
		var info = header[i].split(":");
		
		headers[info[0]] = info[1];
	}
	
	if (! headers['User-Agent'])
		headers['User-Agent'] = '';
		
	var ua = headers['User-Agent'].toLowerCase();
		
	var isOpera = ua.indexOf("opera") > -1,
        isSafari = (/webkit|khtml/).test(ua),
        isIE = ua.indexOf("msie") > -1,
        isIE7 = ua.indexOf("msie 7") > -1,
        isGecko = !isSafari && ua.indexOf("gecko") > -1,
        isWindows = (ua.indexOf("windows") != -1 || ua.indexOf("win32") != -1),
        isMac = (ua.indexOf("macintosh") != -1 || ua.indexOf("mac os x") != -1),
        isLinux = (ua.indexOf("linux") != -1);
		
	EasyKat.apply(EasyKat, 
	{
		emptyFn : function(){},
		
		/**
		 * Copies all the properties of config to obj if they don't already exist.
		 * @param {Object} obj The receiver of the properties
		 * @param {Object} config The source of the properties
		 * @return {Object} returns obj
		 */
		applyIf : function(o, c){
			if(o && c){
				for(var p in c){
					if(typeof o[p] == "undefined"){ o[p] = c[p]; }
				}
			}
			return o;
		},
		
		/**
		 * Extends one class with another class and optionally overrides members with the passed literal. This class
		 * also adds the function "override()" to the class that can be used to override
		 * members on an instance.
		 * @param {Object} subclass The class inheriting the functionality
		 * @param {Object} superclass The class being extended
		 * @param {Object} overrides (optional) A literal with members
		 * @method extend
		 */
		extend : function(){
			// inline overrides
			var io = function(o){
				for(var m in o){
					this[m] = o[m];
				}
			};
			return function(sb, sp, overrides){
				if(typeof sp == 'object'){
					overrides = sp;
					sp = sb;
					sb = function(){sp.apply(this, arguments);};
				}
				var F = function(){}, sbp, spp = sp.prototype;
				F.prototype = spp;
				sbp = sb.prototype = new F();
				sbp.constructor=sb;
				sb.superclass=spp;
				if(spp.constructor == Object.prototype.constructor){
					spp.constructor=sp;
				}
				sb.override = function(o){
					EasyKat.override(sb, o);
				};
				sbp.override = io;
				sbp.__extcls = sb;
				EasyKat.override(sb, overrides);
				return sb;
			};
		}(),
		
		/**
		 * Adds a list of functions to the prototype of an existing class, overwriting any existing methods with the same name.
		 * Usage:<pre><code>
	Ext.override(MyClass, {
	newMethod1: function(){
		// etc.
	},
	newMethod2: function(foo){
		// etc.
	}
	});
	</code></pre>
		 * @param {Object} origclass The class to override
		 * @param {Object} overrides The list of functions to add to origClass.  This should be specified as an object literal
		 * containing one or more methods.
		 * @method override
		 */
		override : function(origclass, overrides){
			if(overrides){
				var p = origclass.prototype;
				for(var method in overrides){
					p[method] = overrides[method];
				}
			}
		},
		
		/**
		 * Creates namespaces.
		 * @param {String} namespace1
		 * @param {String} namespace2
		 * @param {String} etc
		 * @method namespace
		 */
		namespace : function(){
			var a=arguments, o=null, i, j, d, rt;
			for (i=0; i<a.length; ++i) {
				d=a[i].split(".");
				rt = d[0];
				eval('if (typeof ' + rt + ' == "undefined"){' + rt + ' = {};} o = ' + rt + ';');
				for (j=1; j<d.length; ++j) {
					o[d[j]]=o[d[j]] || {};
					o=o[d[j]];
				}
			}
		},
		
		isReadable : function(path) {
			// @@@@ MW ACHTUNG !!!! das funktioniert nicht mehr, wenn irgendjemand das cwd umsetzt!!!!
			// path = "./" + path;
			path = getstddirectory( "PROGRAM" ) + path;
			var dir = new FindFiles();
			return dir.findFile(path);
		},
		
		encode : function( json ){
			return json.toJSON();
		},
		
		decode : function( json ){
			return eval("(" + json + ')');
		},
		
		/** @type Boolean */
        isOpera : isOpera,
        /** @type Boolean */
        isSafari : isSafari,
        /** @type Boolean */
        isIE : isIE,
        /** @type Boolean */
        isIE7 : isIE7,
        /** @type Boolean */
        isGecko : isGecko,
        /** @type Boolean */
        isWindows : isWindows,
        /** @type Boolean */
        isLinux : isLinux,
        /** @type Boolean */
        isMac : isMac
	});
})();

/**
 * @class String
 * These functions are available as static methods on the JavaScript String object.
 */
EasyKat.applyIf(String, {

    /**
     * Escapes the passed string for ' and \
     * @param {String} string The string to escape
     * @return {String} The escaped string
     * @static
     */
    escape : function(string) {
        return string.replace(/('|\\)/g, "\\$1");
    },

    /**
     * Pads the left side of a string with a specified character.  This is especially useful
     * for normalizing number and date strings.  Example usage:
     * <pre><code>
var s = String.leftPad('123', 5, '0');
// s now contains the string: '00123'
</code></pre>
     * @param {String} string The original string
     * @param {Number} size The total length of the output string
     * @param {String} char (optional) The character with which to pad the original string (defaults to empty string " ")
     * @return {String} The padded string
     * @static
     */
    leftPad : function (val, size, ch) {
        var result = new String(val);
        if(ch === null || ch === undefined || ch === '') {
            ch = " ";
        }
        while (result.length < size) {
            result = ch + result;
        }
        return result;
    },

    /**
     * Allows you to define a tokenized string and pass an arbitrary number of arguments to replace the tokens.  Each
     * token must be unique, and must increment in the format {0}, {1}, etc.  Example usage:
     * <pre><code>
var cls = 'my-class', text = 'Some text';
var s = String.format('<div class="{0}">{1}</div>', cls, text);
// s now contains the string: '<div class="my-class">Some text</div>'
</code></pre>
     * @param {String} string The tokenized string to be formatted
     * @param {String} value1 The value to replace token {0}
     * @param {String} value2 Etc...
     * @return {String} The formatted string
     * @static
     */
    format : function(format){
        var args = Array.prototype.slice.call(arguments, 1);
        return format.replace(/\{(\d+)\}/g, function(m, i){
            return args[i];
        });
    }
});

//Force overwrite of replace function
EasyKat.apply( String.prototype, 
{
	// Save original replace method
	_replace : String.prototype.replace,

	// Patch in possibility to pass an array of replacement strings
	/**
	 *
	 * @param {String} regExp
	 * @param {String} repl
	 */
	replace : function(regExp, repl ) {
		if ( regExp instanceof Array ) {
			for (var i=0; i < regExp.length; i++ ) 
				this = this._replace(regExp[i], repl);
				
			return this;
		}
		
		return this._replace( regExp, repl );
	}
});

// String goodies
EasyKat.applyIf( String.prototype, 
{
	/**
	 * The first character of each word in a string 
	 * delimited by a given delimiter are converted to uppecase.
	 *
	 * @param {String} delim
	 * @return {String}
	 */
	camelize : function(delim) {
		delim = delim || '-';
		var parts = this.split(delim), len = parts.length;
		if (len == 1) return parts[0];

		var camelized = this.charAt(0) == delim
		  ? parts[0].charAt(0).toUpperCase() + parts[0].substring(1)
		  : parts[0];

		for (var i = 1; i < len; i++)
		  camelized += parts[i].charAt(0).toUpperCase() + parts[i].substring(1);

		return camelized;
	},
	
	/**
	 * Capitalizes first character of the string, while the rest is lowercased.
	 *
	 * @return {String}
	 */
	capitalize : function() {
		return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();
	},

	/**
	 * Capitalizes first character of string without touching the rest.
	 * 
	 * @return {String}
	 */
	ucfirst : function() {
		return this.charAt(0).toUpperCase() + this.substring(1);
	},

	/**
	 * Capitalizes each word in string
	 *
	 * @param {String} delim Word delimiter, defaults to blank.
	 * @return {String} returns the modified string.
	 */
	ucwords : function(delim) {
		delim = delim || " ";
		return this.camelize(delim).ucfirst();
	}
});

// Array Goodies
EasyKat.applyIf( Array.prototype,
{
	/**
	 * Searches for an entry in an array.
	 *
	 * @param {Mixed} entry
	 * @return {Mixed} When the entry is found the key is returned, false otherwise.
	 */
	search : function(entry) {
		for (var i=0; i < this.length; i++) {
			if ( entry == this[i] ) {
				return i;
			}
		}
		
		return false;
	},
	
	indexOf : function(elt /*, from*/){
		var len = this.length;

		var from = Number(arguments[1]) || 0;
		from = (from < 0)
			 ? Math.ceil(from)
			 : Math.floor(from);
		if (from < 0)
		  from += len;

		for (; from < len; from++)
		{
		  if (from in this &&
			  this[from] === elt)
			return from;
		}
		return -1;
	},
	
	lastIndexOf : function(elt /*, from*/)
	{
		var len = this.length;

		var from = Number(arguments[1]);
		if (isNaN(from))
		{
		  from = len - 1;
		}
		else
		{
		  from = (from < 0)
			   ? Math.ceil(from)
			   : Math.floor(from);
		  if (from < 0)
			from += len;
		  else if (from >= len)
			from = len - 1;
		}

		for (; from > -1; from--)
		{
		  if (from in this &&
			  this[from] === elt)
			return from;
		}
		return -1;
	},
	
	every : function(fun /*, thisp*/)
	{
		var len = this.length;
		if (typeof fun != "function")
		  throw new TypeError();

		var thisp = arguments[1];
		for (var i = 0; i < len; i++)
		{
		  if (i in this &&
			  !fun.call(thisp, this[i], i, this))
			return false;
		}

		return true;
	},
	
	filter : function(fun /*, thisp*/)
	{
		var len = this.length;
		if (typeof fun != "function")
		  throw new TypeError();

		var res = new Array();
		var thisp = arguments[1];
		for (var i = 0; i < len; i++)
		{
		  if (i in this)
		  {
			var val = this[i]; // in case fun mutates this
			if (fun.call(thisp, val, i, this))
			  res.push(val);
		  }
		}

		return res;
	}
});

// EasyKat Namespaces
EasyKat.namespace(
	"EasyKat",
	"EasyKat.Exception",
	"EasyKat.Controller",
	"EasyKat.Controller.Exception",
	"EasyKat.Controller.Action",
	"EasyKat.Controller.Dispatcher",
	"EasyKat.Controller.Front",
	"EasyKat.Controller.Plugin",
	"EasyKat.Controller.Router",
	"EasyKat.Transformer",
	"EasyKat.ux"
);

function object(o) {
    function F() {}
    F.prototype = o;
    return new F();
}

// Transform a token object into an exception object and throw it.

function error(message, t) {
    t = t || this;
    t.name = "SyntaxError";
    t.message = message;
    throw t;
}