/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4 
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat.Controller
 * @subpackage Router
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */ 
 
/**
 * Simple first implementation of a router, to be replaced
 * with rules-based URI processor.
 *
 */
EasyKat.Controller.Router = function()
{}

EasyKat.Controller.Router.prototype = 
{
	route : function(dispatcher)
    {
        /**
         * @todo Replace with EasyKat.Request object
         */
		var path = PATH;
		
		var params = URL_PARAM;
		var content = CONTENT;
		
		CONTENT += "&" + URL_PARAM;
		
        path = path.replace('?' + URL_PARAM, '' );
		path = path.trimLeft("/").trimRight('/').split('/');

        /**
         * The controller is always the first piece of the URI, and
         * the action is always the second:
         *
         * http://plansoft.de/controller-name/action-name/
         */
        var controller = path[0];
        var action     = ( typeof path[1] != "undefined" ) ? path[1] : null;

        /**
         * If no controller has been set, IndexController::index()
         * will be used.
         */
        if (controller.length == 0 || controller == "easygui.php" || controller == "easygui.plso") {
           controller = 'index';
           action = 'index';
        }

        /**
         * Any optional parameters after the action are stored in
         * an array of key/value pairs:
         *
         * http://www.plansoft.de/controller-name/action-name/param-1/3/param-2/7
         *
         * params = array(2) {
         *              ["param-1"]=> string(1) "3"
         *              ["param-2"]=> string(1) "7"
         * }
         */
        var params = {};
        for (i=2; i<path.length; i=i+2) {
            params[path[i]] = (typeof path[i+1] != "undefined") ? path[i+1] : null;
        }

        var actionObj = new EasyKat.Controller.Dispatcher.Token(controller, action, params);

        if (!dispatcher.isDispatchable(actionObj)) {
            /**
             * @todo error handling for 404's
             */
            throw new EasyKat.Controller.Router.Exception('Request could not be mapped to a route.');
        } else {
            return actionObj;
        }
    }
}