/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4 
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat.Controller
 * @subpackage Plugins
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */
EasyKat.Controller.Plugin.Broker = function() {
	EasyKat.Controller.Plugin.Broker.superclass.constructor.call(this);
}

EasyKat.extend( EasyKat.Controller.Plugin.Broker, EasyKat.Controller.Plugin.Abstract,
{
    /**
     * Array of instance of objects implementing EasyKat.Controller.Plugin.Interface
     *
     * @var EasyKat.Controller.Plugin.Interface
     */
    _plugins : [],

    /**
     * Register a plugin.
     *
     * @param EasyKat.Controller.Plugin.Interface plugin
     * @return EasyKat.Controller.Plugin.Broker
     */
    registerPlugin : function(plugin)
    {
        if (this.plugins.search(plugin) != false) {
            throw new EasyKat.Controller.Exception('Plugin already registered.');
        }
        this._plugins.push(plugin);
        return this;
    },

    /**
     * Unregister a plugin.
     *
     * @param EasyKat.Controller.Plugin plugin
     * @return EasyKat.Controller.Plugin.Broker
     */
    unregisterPlugin : function(plugin)
    {
        var key = this._plugins.search(plugin);
        if (key==false) {
            throw new EasyKat.Controller.Exception('Plugin never registered.');
        }
        delete(this._plugins[key]);
        return this;
    },

	/**
	 * Called before EasyKat.Controller.Front begins evaluating the
	 * request against its routes.
	 *
	 * @return void
	 */
	routeStartup : function()
	{
	    for (var i=0; i < this._plugins.length; i++) {
	        this._plugins[i].routeStartup();
	    }
	},

	/**
	 * Called before EasyKat.Controller.Front exists its iterations over
	 * the route set.
	 *
	 * @param  EasyKat.Controller.Dispatcher.Token|boolean action
	 * @return EasyKat.Controller.Dispatcher.Token|boolean
	 */
	routeShutdown : function(action)
	{
	    for (var i=0; i < this._plugins.length; i++) {
	        var action = this._plugins[i].routeShutdown(action);
	    }
	    return action;
	},

	/**
	 * Called before EasyKat.Controller.Front enters its dispatch loop.
	 * During the dispatch loop, EasyKat_Controller_Front keeps a stack of
	 * EasyKat.Controller.Dispatcher.Token objects, and uses EasyKat.Controller.Dispatcher to dispatch the
	 * EasyKat.Controller.Dispatcher.Token objects to controllers/actions.
	 *
	 * @param  EasyKat.Controller.Dispatcher.Token|boolean action
	 * @return EasyKat.Controller.Dispatcher.Token|boolean
	 */
	dispatchLoopStartup : function(action)
	{
	    for (var i=0; i < this._plugins.length; i++) {
	        var action = this._plugins[i].dispatchLoopStartup(action);
	    }
	    return action;
	},

	/**
	 * Called before an action is dispatched by EasyKat_Controller_Dispatcher.
	 *
	 * @param  EasyKat.Controller.Dispatcher.Token|boolean action
	 * @return EasyKat.Controller.Dispatcher.Token|boolean
	 */
	preDispatch : function(action)
	{
	    for (var i=0; i < this._plugins.length; i++) {
	        var action = this._plugins[i].preDispatch(action);
	    }
	    return action;
	},

	/**
	 * Called after an action is dispatched by EasyKat_Controller_Dispatcher.
	 *
	 * @param  EasyKat.Controller.Dispatcher.Token|boolean action
	 * @return EasyKat.Controller.Dispatcher.Token|boolean
	 */
	postDispatch : function(action)
	{
	    for (var i=0; i < this._plugins.length; i++) {
	        var action = this._plugins[i].postDispatch(action);
	    }
	    return action;
	},
	
	/**
	 * Called before EasyKat_Controller_Front exists its dispatch loop.
	 *
	 * @param  EasyKat.Controller.Dispatcher.Token|boolean action
	 * @return EasyKat.Controller.Dispatcher.Token|boolean
	 */
	dispatchLoopShutdown : function()
	{
	   for (var i=0; i < this._plugins.length; i++) {
	        var action = this._plugins[i].dispatchLoopShutdown();
	   }
	}
});