/**
 * EasyKat Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.EasyKat.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@EasyKat.com so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat_Controller
 * @subpackage Plugins
 * @copyright  Copyright (c) 2006 EasyKat Technologies USA Inc. (http://www.EasyKat.com)
 * @license    http://framework.EasyKat.com/license/new-bsd     New BSD License
 */ 

/**
 * @category   EasyKat
 * @package    EasyKat_Controller
 * @subpackage Plugins
 * @copyright  Copyright (c) 2006 EasyKat Technologies USA Inc. (http://www.EasyKat.com)
 * @license    http://framework.EasyKat.com/license/new-bsd     New BSD License
 */
EasyKat.Controller.Plugin.Abstract = function()
{}

EasyKat.Controller.Plugin.Abstract.prototype =
{
	/**
	 * Called before EasyKat_Controller_Front begins evaluating the
	 * request against its routes.
	 *
	 * @return void
	 */
	routeStartup : function(){
	
	},

	/**
	 * Called after EasyKat_Controller_Router exits.
	 *
	 * This callback allows for proxy or filter behavior.  The
	 * action must be returned for the EasyKat_Controller_Dispatcher_Token
	 * to enter the dispatch loop.  To abort before the dispatch loop is
	 * entered, return FALSE.
	 *
	 * @param  EasyKat_Controller_Dispatcher_Token|boolean action
	 * @return EasyKat_Controller_Dispatcher_Token|boolean
	 */
	routeShutdown : function(action)
	{
	    return action;
	},

	/**
	 * Called before EasyKat_Controller_Front enters its dispatch loop.
	 * During the dispatch loop.
	 *
	 * This callback allows for proxy or filter behavior.  The
	 * action must be returned for the EasyKat_Controller_Dispatcher_Token
	 * to enter the dispatch loop.  To abort before the dispatch loop is
	 * entered, return FALSE.
	 *
	 * @param  EasyKat_Controller_Dispatcher_Token|boolean action
	 * @return EasyKat_Controller_Dispatcher_Token|boolean
	 */
	dispatchLoopStartup : function(action)
	{
	    return action;
	},

	/**
	 * Called before an action is dispatched by EasyKat_Controller_Dispatcher.
	 *
	 * This callback allows for proxy or filter behavior.  The
	 * action must be returned for the EasyKat_Controller_Dispatcher_Token
	 * to be dispatched.  To abort the dispatch, return FALSE.
	 *
	 * @param  EasyKat_Controller_Dispatcher_Token|boolean action
	 * @return EasyKat_Controller_Dispatcher_Token|boolean
	 */
	preDispatch : function(action)
	{
	    return action;
	},

	/**
	 * Called after an action is dispatched by EasyKat_Controller_Dispatcher.
	 *
	 * This callback allows for proxy or filter behavior.  The
	 * action must be returned, otherwise the next action
	 * will not be dispatched.  To exit the dispatch loop without
	 * dispatching the action, return FALSE.
	 *
	 * @param  EasyKat_Controller_Dispatcher_Token|boolean action
	 * @return EasyKat_Controller_Dispatcher_Token|boolean
	 */
	postDispatch : function(action)
	{
	    return action;
	},

	/**
	 * Called before EasyKat_Controller_Front exists its dispatch loop.
	 *
	 * @return void
	 */
	dispatchLoopShutdown : function()
	{}
};