/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4 
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat.Controller
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */
EasyKat.Controller.Front = function()
{
    /**
     * Instance of EasyKat.Controller.Router
     * @var EasyKat.Controller.Router
     */
    var _router;

    /**
     * Instance of EasyKat.Controller.Dispatcher
     * @var EasyKat.Controller.Dispatcher
     */
    var _dispatcher;

    /**
     * Instance of EasyKat.Controller.Plugin.Broker
     * @var EasyKat.Controller.Plugin.Broker
     */
    var _plugins;
	
	/**
	 * Wether to log Ajax Requests or not
	 * @var boolean
	 */
	var logRequests = false;
	
    return {
		/**
		 * Convenience feature, calls setControllerDirectory().dispatch()
		 *
		 * @param string controllerDirectory
		 */
		initialize : function(controllerDirectory)
		{
			_plugins = new EasyKat.Controller.Plugin.Broker();
			this.setControllerDirectory(controllerDirectory).dispatch();
		},

		/**
		 * Enables Request Logging
		 */
		enableRequestLog: function() 
		{
			this.logRequests = true;
		},
		
		/**
		 * Disables Request Logging
		 */
		disableRequestLog: function()
		{
			this.logRequests = false;
		},
		
		/**
		 * Convenience method, passthru to EasyKat.Controller.Dispatcher::setControllerDirectory()
		 *
		 * @param string directory
		 */
		setControllerDirectory : function(directory)
		{
			var dispatcher = this.getDispatcher();

			if (typeof dispatcher['setControllerDirectory'] == "undefined") {
				var errorObj = new EasyKat.Controller.Front.Exception('Custom dispatcher does not support setting controller directory.');
			}

			dispatcher.setControllerDirectory(directory);
			return this;
		},


		/**
		 * Set the router object.  The router is responsible for mapping
		 * the request to a EasyKat.Controller.Dispatcher.Token object for dispatch.
		 *
		 * @param EasyKat.Controller.Router router
		 */
		setRouter : function(router)
		{
			_router = router;
		},

		/**
		 * Return the router object.
		 *
		 * @return EasyKat.Controller.Router
		 */
		getRouter : function()
		{
			/**
			 * Instantiate the default router if one was not set.
			 */
			if ( typeof _router == "undefined") {
				_router = new EasyKat.Controller.Router();
			}
			return _router;
		},

		/**
		 * Set the dispatcher object.  The dispatcher is responsible for
		 * taking a EasyKat.Controller.Dispatcher.Token object, instantiating the controller, and
		 * call the action method of the controller.
		 *
		 * @param EasyKat.Controller.Dispatcher dispatcher
		 * @return EasyKat.Controller.Front
		 */
		setDispatcher : function(dispatcher)
		{
			_dispatcher = dispatcher;
			return this;
		},


		/**
		 * Return the dispatcher object.
		 *
		 * @return EasyKat.Controller.Dispatcher
		 */
		getDispatcher : function()
		{
			/**
			 * Instantiate the default dispatcher if one was not set.
			 */
			if ( typeof _dispatcher == "undefined" ) {
				_dispatcher = new EasyKat.Controller.Dispatcher();
			}
			return _dispatcher;
		},


		/**
		 * Register a plugin.
		 *
		 * @param EasyKat.Controller.Plugin plugin
		 * @return EasyKat.Controller.Front
		 */
		registerPlugin : function(plugin)
		{
			_plugins.registerPlugin(plugin);
			return this;
		},


		/**
		 * Unregister a plugin.
		 *
		 * @return EasyKat.Controller.Front
		 */
		unregisterPlugin : function(plugin)
		{
			_plugins.unregisterPlugin(plugin);
			return this;
		},


		/**
		 * Dispatch an HTTP request to a controller/action.
		 */
		dispatch : function()
		{
			/* @var action EasyKat.Controller.Dispatcher.Token */

			try {
				// notify plugins that the router is startup up
				_plugins.routeStartup();

                /** 
                 * -mw- PDS Interface fr Offline-Katalog: 
                 * Injection of code into browser in order to trigger EasyKat from the outside ...
                 * Wir werden aus einer PDS-DLL heraus per HTTP-Request gerufen; hier lsen wir
                 * zwangsweise in der Browser-Control ein Submit aus.
                 * Teil 2 der Arie findet dann in navigation.es statt; dort wird das Submit-Event
                 * abgefangen und verarbeitet: Wir starten eine neue Produktauswahl.
                 */
                var path = PATH;
                if (left(PATH, 17) == "/external_request") {
                    // if (HttpRequest.getUrlPath() == "/external_request") {
                    HttpRequest.init(false);
                    var reqFile = HttpRequest.get("reqfile");   // URL_PARAM
                    var outFile = HttpRequest.get("outfile");   // URL_PARAM
                    setstring("REQFILE", "ROOT", reqFile);
                    setstring("OUTFILE", "ROOT", outFile);
                    // var reqJS = "document.forms[0].submit();ekSubmit('bla');alert('reqfile=" + reqFile + "');";
                    var reqJS = "self.ekSubmit('START_NEW_FIN_IMPORT','_self')";
                    injectjs("", reqJS);
                    // throw new EasyKat.Controller.Router.Exception('Request forbidden.');

                    return 403; // 403 Forbidden zurck an netupd.
                }

				/**
				 * Route a URI to a controller/action.  If the route cannot be
				 * made, an exception is thrown.
				 */
				
				try {
					var action = this.getRouter().route(this.getDispatcher());
				} catch(e) {
					// Failed routing (basically a 404, no controller found)
					// change the action to standard easykat
					action = new EasyKat.Controller.Dispatcher.Token('index', 'no-route' );
				}

				// notify plugins that the router is shutting down
				action = _plugins.routeShutdown(action);

				// notify plugins that the dispatch loop is starting up
				action = _plugins.dispatchLoopStartup(action);

				/**
				 * Attempt to dispatch to the controller/action.  On return, either
				 * false will be given to indicate completion, or EasyKat.Controller.Dispatcher.Token will be
				 * given to indicate a forward to another controller/action must
				 * be performed.
				 */
				while (action instanceof EasyKat.Controller.Dispatcher.Token) {
					// notify plugins that a dispatch is about to occur
					action = _plugins.preDispatch(action);
					//var dispatcher = ;
					action = this.getDispatcher().dispatch(action);
					
					// notify plugins that the dispatch has finish
					action = _plugins.postDispatch(action);
				}

				// notify plugins that the dispatch loop is shutting down
				_plugins.dispatchLoopShutdown();
			} catch (e) {
				// Output Error Message !
				if ( e instanceof Error ) {
					alert('Error in Front.es - Exception: ' + e.message);
					echo e.message;
				} else {
					echo e.getMessage();
				}
			}
		}
	};
}();