/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4 
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat.Controller
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */ 
 
/**
 * Class constructor.  A EasyKat.Controller.Dispatcher.Token object must be built with a controller
 * name and an action, but parameters are optional.
 *
 * @param string controllerName
 * @param string actionName
 * @param array params
 * @constructor
 */
EasyKat.Controller.Dispatcher.Token = function(controllerName, actionName, params)
{
	params = params || {};
	this._controller = controllerName;
	this._action     = actionName;
	this._params     = params;
}

EasyKat.Controller.Dispatcher.Token.prototype = 
{
    /**
     * Name of the controller to dispatch.  This is the raw name, such as
     * it would be extracted from the URI.  It is the responsibility of the
     * dispatcher to format it.
     * @var string
     */
    _controller : null,

    /**
     * Name of the action to dispatch.  The action is usually a method of
     * the controller.  This is the raw name, such as it would be extracted
     * from the URI.  It is the responsibility of the dispatcher to format it.
     * @var string
     */
	_action : null,

	/**
	 * Array of key/value pairs to pass as parameters to the controller.
	 * @var array
	 */
	_params : null,


	/**
	 * Sets the controller name.  This is the raw name, such as it would
	 * be extracted from the URI.  It is the responsibility of the dispatcher
	 * to format it.
	 *
	 * @param string controllerName
	 * @return EasyKat.Controller.Dispatcher.Token
	 */
	setControllerName : function(controllerName)
	{
	    this._controller = controllerName;
	    return this;
	},


	/**
	 * Returns the controller name, in the raw form.
	 *
	 * @return string
	 */
	getControllerName : function()
	{
	    return this._controller;
	},


	/**
	 * Returns the action name, in the raw form.
	 *
	 * @return string
	 */
	getActionName : function()
	{
	    return this._action;
	},


	/**
	 * Sets the action name.  This is the raw name, such as it would be
	 * extracted from the URI.  It is the responsibility of the dispatcher
	 * to format it.
	 *
	 * @param string actionName
	 * @return EasyKat.Controller.Dispatcher.Token
	 */
	setActionName : function(actionName)
	{
	    this._action = actionName;
	    return this;
	},


	/**
	 * Get the parameters array.
	 *
	 * @return array
	 */
    getParams : function()
    {
       return this._params;
    },


    /**
     * Sets the parameters array.
     *
     * @param string params
     * @return EasyKat.Controller.Dispatcher.Token
     */
    setParams : function(params)
    {
        if (typeof params != "object" ) {
            throw new EasyKat.Controller.Dispatcher.Exception('Parameters must be set as an anonymous object.');
        }
        //this._params = paramsArray;
		EasyKat.apply( this._params, params )
        return this;
    }
};
