/**
 * EasyKat Framework
 * 
 * ported from Zend Framework 0.1.4 
 * Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.plansoft.de/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@plansoft.de so we can send you a copy immediately.
 *
 * @category   EasyKat
 * @package    EasyKat.Controller
 * @copyright  Copyright (c) 2007 Plan Software GmbH (http://www.plansoft.de)
 * @license    http://www.plansoft.de/license/new-bsd     New BSD License
 */
EasyKat.Controller.Action = function()
{
	/**
     * EasyKat.Controller.Dispatcher.Token object wrapping this controller/action call.
     * @var EasyKat.Controller.Dispatcher.Token
     */
	this._action = {};
	
	/**
     * Parameters, copied from EasyKat.Controller.Dispatcher.Token object
     * @var array
     */
	this._params = {};
	
	/**
     * EasyKat.Controller.Dispatcher.Token object wrapping the controller/action for the next
     * call.  This is set by EasyKat.Controller.Action::_forward().
     * @var EasyKat.Controller.Dispatcher.Token
     */
	this._nextAction = null;	
}

EasyKat.Controller.Action.prototype = {
	/**
     * Any controller extending EasyKat.Controller.Action must provide an index()
     * method.  The index() method is the default action for the controller
     * when no action is specified.
     *
     * This only handles a controller which has been called with no action
     * specified in the URI.
     *
	 * This is the Default Index Action inside the EasyKat Framework
	 * Everything we need is handled here. If you use xml or eks templates. the old
	 * style transformer transforms the view templates to html with easygui widgets.
	 * If you want to use whatever library you want, just name your view templates with
	 * html or htm file extension.
	 * For Desktop apps or special intranet solutions based on firefox with
	 * a rich user interfaces you can also use xul file extension
	 *
     * For handling nonexistant actions in controllers (bad action part of URI),
     * the controller class must provide a __call() method or an exception
     * will be thrown.
     */
    indexAction : function() 
	{
		var nextDlg = scriptexec( "navigation.es");
		
		var tplPath 	= getstring("CATALOG.TEMPLATES.DIR","ROOT") + "\\" + nextDlg;
		var tplEndings 	= ['xml','eks','html','htm','xul','txt'];
		
		for (var i=0; i < tplEndings.length; i++ ) {
			var tplFile = tplPath + "." + tplEndings[i];
			
			var bRet = EasyKat.isReadable( tplFile );
			if ( bRet )
				break;
		}
		
		if ( tplEndings[i] == "xml" || tplEndings[i] == "eks" ) {
			setstring("INFILE", "EASYGUITRANSFORM", tplFile);
			
			var transformer = new EasyKat.Transformer.EasyGUI();
			var result = transformer.transform();
		
			echo readfile(result);
			_global.MIMETYPE = "text/html";
		} else {
			var fileContent = readfile(tplFile);
			var replacer = new TextReplacer("$","\\", false);
			// var test = replacer.exec(fileContent);
			echo replacer.exec(fileContent);
			
			var mimetypes = Object.fromStorage("ROOT.MIMETYPE");
			var type = mimetypes[tplEndings[i].toUpperCase()].TYPE;
			_global.MIMETYPE = (typeof type == "undefined") ? "text/plain" : type;
		}
	},
	
	/**
     * Pre-dispatch routines
     *
     * Called before action method. If using class with 
     * {@link EasyKat.Controller.Front}, it may modify the 
     * {@link $_request Request object} and reset its dispatched flag in order 
     * to skip processing the current action.
     * 
	 * This is just a quick fix
	 * The Framework should be reimplemented on the newest Codebase.
     * @return void
     */
	preDispatch : function() {},
	
	/**
     * Post-dispatch routines
     *
     * Called after action method execution. If using class with 
     * {@link Zend_Controller_Front}, it may modify the 
     * {@link $_request Request object} and reset its dispatched flag in order 
     * to process an additional action.
     *
     * Common usages for postDispatch() include rendering content in a sitewide 
     * template, link url correction, setting headers, etc.
     * 
     * @return void
     */
	postDispatch : function() {},
	
	noRouteAction : function() 
	{
		echo "EasyKat Error: No Route found !";
	},
	
    /**
     * Proxy for undefined methods.  Default behavior is to throw an
     * exception on undefined methods, however this function can be
     * overrided to implement magic (dynamic) actions.
     *
     * @param string methodName
     * @param array args
     */
    __call : function(methodName, args)
    {
        if (methodName == "") {
            var msg = 'No action specified and no default action has been defined in __call() for ' + this.toString();
        } else {
            var msg = this.toString() + '.' + methodName + '() does not exist and was not trapped in __call().';
        }

        throw new EasyKat.Controller.Action.Exception(msg);
    },


    /**
     * Initialize the class instance variables and then call the action.
	 * Also initialize all dlgvars
     *
     * @param EasyKat.Controller.Dispatcher.Token action
     */
    initialize : function(dispatcher, action)
    {
		//////////////////////////////////////////////////////////////////////////
        this._action     = action;
        this._params     = action.getParams();
		
		// Init Environment only 1 time
		if ( typeof this._params._forward == "undefined" )
			this.initEnv();

		this.preDispatch();
		
        if (action.getActionName() == null) {
			// Set to noRoute ?
            action.setActionName('index');
        }

        var methodName = dispatcher.formatActionName(action.getActionName());

        if (typeof this[methodName] == "undefined" ) {
            this.__call(methodName, []);
        } else {
			this[methodName]();
        }

		this.postDispatch();
		
        var nextAction = this._nextAction;
        this._nextAction = null;
        return nextAction;
    },
	
	initEnv : function() 
	{
		initdlgvars( CONTENT );
		
		var logRequests	= getstring("CATALOG.REQUESTLOG.ENABLED","ROOT");
		var newSession	= false;
		
		var sessionId	= getdlgvar("sessionid");
		var stateId		= getdlgvar("stateid");
		var event 		= getdlgvar("EKSUBMITEVENT");
		
		// Postvars Targets
		var dlgId		= getdlgvar("DLG_ID");
		var storePath 	= getdlgvar("__STORE_PATH__");
		
		var sessionPath;
		
		setstring( "SESSION_TIMEDOUT", "", false );
		
		if(sessionId != "") {
			var sessionPath = getsessionpath(sessionId);
			// Prfe Session Timeout
			if ( typeof sessionPath == "undefined" )
				setstring( "SESSION_TIMEDOUT", "", true )
		}

		if(typeof sessionPath == "undefined") {
			setsessionpath( createsession() );
			sessionId 	= getstring("sessionid","");
			stateId 	= getstring("stateid","");
			newSession 	= true;
		}
		else {
			setsessionpath(sessionPath);
		}
		
		if ( storePath != "" ) {
			dlgvarstostorage( storePath );
		}
		else if ( dlgId != "" ) {
			dlgvarstostorage( dlgId );
		}
		else {
			dlgvarstostorage();
		}
		
		ekstoragesubmit();
		
		var urlparam = URL_PARAM;
		urlparam = urlparam.trimLeft("/?").trimRight('/').split('&');
		if (newSession && (urlparam.lengthUtf8 > 0)) {
			var url1param = urlparam[0].split('=');
			if  ((url1param[1] == 'ms') || (url1param[1] == 'kp') || (url1param[1] == 'mb') || (url1param[1] == 'rh')) {
				setstring('EK_PRODUCT_GROUP', '', url1param[1]);
			}
		}
		
		setstring("EKSUBMITEVENT","",event);
		setstring("EVENT","",event);
		if (dlgId != "")	// Sonst werden bei EXT-Requests die AktuelleMaske zurckgesetzt und darauffolgendem EasyGui-Requests kommen keine Variablen mehr ber die DLGVARS-Tabelle rein
			setstring("AKTUELLE_MASKE", "", dlgId); // Alles heit EKCURRENTxxx nur hier machen wir mal eine Ausnahme
	
		if ( logRequests ) {
			var date 	= new Date();
			var file 	= getstring("CATALOG.REQUESTLOG.FILE","ROOT") || 'request.log';
			var writer 	= new FileStream(file, 'a');
			
			if ( newSession ) {
				writer.writeLine('[' + date.toLocaleString() +'] Created new Session ID: [' + sessionId + ']');
			}
				
			writer.writeLine('[' + date.toLocaleString() +'][' + sessionId + /*':' + stateid +*/ '][' + dlgId + ':' + event + '] ' + this._action.getControllerName() + '/' + this._action.getActionName() );
		}
	},
	
    /**
     * Gets a parameter that was passed to this controller.  If the
     * parameter does not exist, FALSE will be return.
     *
     * If the parameter does not exist and default is set, then
     * default will be returned instead of FALSE.
     *
     * @param string paramName
     * @param string default
     * @return boolean
     */
    _getParam : function(paramName, defaultValue)
    {
		defaultValue = defaultValue || null;
		
        if (typeof _params[paramName] != "undefined") {
            return _params[paramName];
        }

        if (defaultValue == null) {
            return false;
        } else {
            return defaultValue;
        }
    },


    /**
     * Return all parameters that were passed to the controller
     * as an associative array.
     *
     * @return array
     */
    _getAllParams : function()
    {
        return this._params;
    },


    /**
     * Forward to another controller/action.
     *
     * It is important to supply the unformatted names, i.e. "article"
     * rather than "ArticleController".  The dispatcher will do the
     * appropriate formatting when the EasyKat.Controller.Dispatcher.Token item is received.
     *
     * @param string controllerName
     * @param string actionName
     * @param array params
     */
    _forward : function(controllerName, actionName, params)
    {
		params = params || {}
		params._forward = true;
        this._nextAction = new EasyKat.Controller.Dispatcher.Token(controllerName, actionName, params);
    },


    /**
     * Redirect to another URL
     *
     * @param string url
	 * @todo implement
     */
    _redirect : function(url)
    {
		/*
        if (headers_sent()) {
            throw new EasyKat_Controller_Action_Exception('Cannot redirect because headers have already been sent.');
        }
		*/
		/*
        // prevent header injections
        url = str_replace(array("\n", "\r"), '', url);

        // redirect
        header("Location: url");
        exit();
		*/
    }
}