/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

////////////////////////////////////////////////////////////
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-12-10 <MD>
// 				2008-10-16 <mb>
////////////////////////////////////////////////////////////

// ======================================================================================
// UEBERNAHME DER AUSGEWAEHLTEN INFORMATIONEN IN DIE PROJEKTLISTE:
// ======================================================================================

{
	var strPathAuslegung = "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG";
	var strPathAuslegungATL = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_LINKS";
	var strPathAuslegungATR = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_RECHTS";

	setstring("NENNLAENGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG", getstring("WS_NENNLAENGE","DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT"));

	// =====================================================================
	// Wir aktualisieren die Bestellisten-Infos unter den Dialogdaten,
	// spter werden sie automatisch mitkopiert:
	// =====================================================================

	var strTarget 		= "DLGDATA"
	var strSchlauchArt	= translate("WS_PRINT_SCHLAUCHART_" + getstring("SCHLAUCHART", "DLGDATA.WS"));
	var strDN			= getstring("WS_GEWAEHLTER_SCHLAUCH_DN", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	var strIdent 		= getstring("ID", strPathAuslegung); 				// Identnummer:
	var strTyp 			= getstring("TYP", strPathAuslegung);				// Typbezeichnung:
	var strATLTyp		= getstring("TYP_AT", strPathAuslegungATL);
	var strATRTyp		= getstring("TYP_AT", strPathAuslegungATR);
	var strNennlaenge 	= getstring("NENNLAENGE", strPathAuslegung);

	// ----------------------------------------------------------------
	// Beschreibungstext fr die Projektliste aufbauen:
	// ----------------------------------------------------------------
	var strShorttext = strSchlauchArt + ", "+ strDN ;
	if(strNennlaenge != "")
		strShorttext = strShorttext + " ["+strNennlaenge+" "+translate("WS_UNIT_MM")+"] ";

	setstring("SHORTTEXT", 	strTarget ,  strShorttext);

	// ----------------------------------------------------------------
	// Typbezeichnung und Ident fr die Projektliste aufbauen:
	// ----------------------------------------------------------------

	if((strATLTyp != "") || (strATRTyp != ""))
	{
		// wenn ein Anschlussteil gewhlt wurde, steht als letzter Buchstabe
		// des Schlauchtyps ein "L"
		strTyp = left(strTyp, (strlen(strTyp) - 1) );
		strTyp = strTyp + "L";

		if(strATLTyp != "")
			strTyp = strTyp + ", " + strATLTyp;

		if(strATRTyp != "")
			strTyp = strTyp + ", " + strATRTyp;

		// Wenn Anschluteile gewhlt sind, gibt es keinen eindeutigen Ident:
		strIdent = "-";
	}

	setstring("ORDERCODE", strTarget, strTyp);
	setstring("ORDERCODE_PROJECTLIST", strTarget, strTyp);
	setstring("IDENT", strTarget, strIdent);

	// ----------------------------------------------------------------
	// Preisinformation fr Projektliste setzen
	// ----------------------------------------------------------------
	// DERZEIT SIND KEINE PREISE FR WICKELSCHLUCHE VERFGBAR!

	// Preise / Kalkulation: hier nicht vorgesehen ...
	// hier nur Techwert oder double merken, formatieren bernimmt zentrale Projekt-Funktion:

	setstring("DUNITPRICE", 	strTarget, "-"); 	// Stckpreis inkl. Prfung, Abnahme
	setstring("DADDEDPOSPRICE", strTarget, "-");	// Zus. Kosten fr die Position (f. Dokumentation o..)
	setstring("FORCEDPOSPRICE", strTarget, "-");	// Vom VB festgesetzter Positionspreis, als STRING, kann in Projektliste gendert werden

	// Wichtig: den letzten Screen merken, der zu diesem Weg gefhrt hat:
	setstring("MODIFY_ENTRY_SCREEN", strTarget, "IDD_WS_TYPEN_ANSCHLUESSE");

	// Sowie den Produktbereich (welcher "Experte" ist zustndig?)
	setstring("PRODUCT_AREA", strTarget , "WS");
}
