/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

////////////////////////////////////////////////////////////
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-10-07 <MD>
// 				2008-10-16 <mb>
////////////////////////////////////////////////////////////


// ==================================================================================
//
//	Funktion:	initializeComboDepencies
//				Schreibt ein JavaScript, das in den Screen IDD_WS_TYPEN_SCHLAEUCHE
//				bernommen wird. Das JavaScript enthlt eine Tabelle mit allen
//				mglichen Beziehungen zwischen Ausfhrung, Werkstoff und Temperatur,
//				so da clientseitig alle Informationen fr die berprfung der
//				Abhngigkeiten zur Verfgung stehen.
// 	Parameter:
//
//	Returnwert:
// ==================================================================================

function searchTypenSchlauch(aStrAUSFUEHRUNG, aStrNENNWEITE, aStrTEMPERATUR, aStrWERKSTOFF)
{
	aStrNENNWEITE = replace(aStrNENNWEITE, "DN", "");

	var strSCHLAUCHART	= getstring("SCHLAUCHART","DLGDATA.WS");
	var resultList 		= "DLGDATA.WS.TYPEN_SCHLAEUCHE.RESULT_TABLE.RESULTLISTE_WS_SCHLAUCH";

	var strSQLStatement = "SELECT DISTINCT * FROM DATEN_SCHLAUCH WHERE ";

	if((aStrAUSFUEHRUNG != "") && (aStrAUSFUEHRUNG != "ID_ALLE"))
		strSQLStatement = strSQLStatement + "AUSFUEHRUNG = '"+aStrAUSFUEHRUNG+"' AND ";

	if((aStrNENNWEITE != "") && (aStrNENNWEITE != "ID_ALLE"))
		strSQLStatement = strSQLStatement + "DN = '"+aStrNENNWEITE+"' AND ";

	if((aStrTEMPERATUR != "") && (aStrTEMPERATUR != "ID_ALLE"))
		strSQLStatement = strSQLStatement + "TMAX >= abs('"+aStrTEMPERATUR+"') AND ";

	if((aStrWERKSTOFF != "") && (aStrWERKSTOFF != "ID_ALLE"))
		strSQLStatement = strSQLStatement + "WS_SCHLAUCH = '"+aStrWERKSTOFF+"' AND ";

	if(strSCHLAUCHART == "SGA")
		strSQLStatement = strSQLStatement + "( SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
	else
		strSQLStatement = strSQLStatement + "SCHLAUCHART = '"+strSCHLAUCHART+"' ";

	strSQLStatement = strSQLStatement + "ORDER BY abs(DN), TYP, WS_SCHLAUCH ";

	// ------------------------------------------------------------------------------------
	// Tabelle mit allen Abhngigkeiten zwischen Ausfhrung, Temperatur und Werkstoff beim
	// Client verfgbar machen:
	// ------------------------------------------------------------------------------------

	var rowsCount = dbselect("WSDATA", strSQLStatement, "RSSuche");
	var resultList = "DLGDATA.WS.TYPEN_SCHLAEUCHE.RESULT_TABLE.RESULTLISTE_WS_SCHLAUCH";

	var i = 0;
	var resultListI;
	var strTYP, strDN, strRMIN, strAUSFUEHRUNG, strWS_SCHLAUCH, strSCHUTZART, strKENNZEICHNUNG, strGEWICHT, strDICHTUNG;

	if(rowsCount > 0)
	{
		while ((dbiseof("RSSuche") == 0) && (i < 100))
		{
			resultListI = resultList + "[" + i + "]";
			dbcopy("RSSuche", resultListI); // Produkt-Info kopieren

			if(i == 1)
				setstring("RESULTLISTE_WS_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_SCHLAEUCHE", "1");

			strTYP 				= dbgetstring("RSSuche","TYP");
			strDN 				= dbgetstring("RSSuche","DN");
			strRMIN  			= dbgetstring("RSSuche","RMIN");
			strAUSFUEHRUNG		= dbgetstring("RSSuche","AUSFUEHRUNG");
			strWS_SCHLAUCH		= dbgetstring("RSSuche","WS_SCHLAUCH");
			strSCHUTZART		= dbgetstring("RSSuche","SCHUTZART");
			strKENNZEICHNUNG	= dbgetstring("RSSuche","KENNZEICHNUNG");
			strGEWICHT 			= dbgetstring("RSSuche","GEWICHT");
			strDICHTUNG			= dbgetstring("RSSuche","DICHTUNG");

			// Produktinfo in die Ergebnistabelle bernehmen:
			setstring("TYP", 			resultListI, strTYP);
			setstring("NENNWEITE", 		resultListI, strDN);
			setstring("RMIN", 			resultListI, strRMIN);
			setstring("AUSFUEHRUNG",	resultListI, strAUSFUEHRUNG);
			setstring("WERKSTOFF", 		resultListI, strWS_SCHLAUCH);
			setstring("SCHUTZART", 		resultListI, strSCHUTZART);

			if(strSCHLAUCHART == "SS")
				setstring("KENNZEICHNUNG", resultListI, strKENNZEICHNUNG);
			else
				setstring("KENNZEICHNUNG", resultListI, translate("WS_DICHTUNG_"+strDICHTUNG));

			setstring("GEWICHT", resultListI, strGEWICHT);

			i = i + 1;
			dbskip("RSSuche");
		}
	}

	if(rowsCount >= 100)
	{
		setstring("IDC_SUCHE_WS_MESSAGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE", translate("IDC_HINWEIS_SUCHE_MEHRALS100"));
		rowsCount = 0;
	}
	else
	{
		setstring("IDC_SUCHE_WS_MESSAGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE", "IDC_SUCHE_WS_MESSAGE");
		rowsCount = 0;
	}
}


//=======================================================================================
// MAIN SCRIPT
//=======================================================================================
{
	// Ergebnisse von vorheriger Suche lschen:

	var currentEvent = getstring("EKSUBMITEVENT",""); // Event aus der aktuellen Maske
	var currentDlg = getstring("AKTUELLE_MASKE","");
	var strPathInput	= "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT";

	if(currentEvent == "IDC_SUCHEN_BUT")
	{
		delete("","DLGDATA.WS.TYPEN_SCHLAEUCHE.RESULT_TABLE");

		var strAUSFUEHRUNG 	= getstring("AUSFUEHRUNG", 	strPathInput);
		var strNENNWEITE	= getstring("NENNWEITE", 	strPathInput);
		var strTEMPERATUR	= getstring("TEMPERATUR", 	strPathInput);
		var strWERKSTOFF	= getstring("WERKSTOFF", 	strPathInput);

		searchTypenSchlauch(strAUSFUEHRUNG, strNENNWEITE, strTEMPERATUR, strWERKSTOFF);
	}
}
