/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

#include "WS_GENERAL_FUNC_ANSCHLUSS_TYPEN.b"

////////////////////////////////////////////////////////////
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-11-18 <MD>
// 				2008-10-16 <mb>
////////////////////////////////////////////////////////////


// ==================================================================================
//	Funktion:	searchTypenAnschluss
// 	Parameter:
//
//	Returnwert:
// ==================================================================================

function searchTypenAnschluss(aStrANSCHLUSSART, aStrMONTAGEART, aStrWERKSTOFF, strSeite)
{
	aStrMONTAGEART = utf8toansi(aStrMONTAGEART);

	var strPathSEL_Product = "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG";
	var strPathAT  = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG";
	var resultList = "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";
	var strSCHLAUCHART = getstring("SCHLAUCHART", "DLGDATA.WS");
	var strSchlauchTyp = getstring("TYP", strPathSEL_Product);
	var strNennweite = getstring("DN", strPathSEL_Product);
	var strTMax = getstring("TMAX",	strPathSEL_Product);
	var imgPath = "catalog/System/STATIC_IMAGES/WITcad/WS/";
	var strAT_STOREVAR = "AT"+strSeite;

	var numPos, i;
	var resultListI, rowsCount;
	var strSQLStatement, strSQLStatementAT;
	var strDB_SCHLAUCH, strAT_MUSTER, strMUSTER;
	var strResultsMUSTER = "";
	var strPathAuslegung = "";

	strSQLStatement = "SELECT DISTINCT "
			+ "SYSTEMATIK_AT.ID, SYSTEMATIK_AT.MUSTER, SYSTEMATIK_AT.ID, "
			+ "SYSTEMATIK_AT.CAD, SYSTEMATIK_AT.CAD_EIN "
			+ "FROM SYSTEMATIK_AT "
			+ "WHERE ";

	if(strSCHLAUCHART != "SS")
	{
		if ((aStrANSCHLUSSART != "") && (aStrANSCHLUSSART != "ID_ALLE") )
			strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ANSCHLUSS = '" + aStrANSCHLUSSART + "' AND ";
		if ((aStrMONTAGEART != "") && (aStrMONTAGEART != "ID_ALLE") )
			strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ART = '" + aStrMONTAGEART + "' AND ";
	}
	else
	{
		if ((aStrMONTAGEART != "") && (aStrMONTAGEART != "ID_ALLE") )
			strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ART = '" + aStrMONTAGEART + "' AND ";
		if (aStrANSCHLUSSART != "ID_ALLE")
			strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ANSCHLUSS = '" + aStrANSCHLUSSART + "' AND ";
	}

	if ((aStrWERKSTOFF != "") && (aStrWERKSTOFF != "ID_ALLE") )
		strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.WERKSTOFF = '"+aStrWERKSTOFF+"' AND ";

	strSQLStatement = strSQLStatement
		+ "( "
		+ "abs('"+ strNennweite + "') >= SYSTEMATIK_AT.DN_VON AND "
		+ "abs('"+ strNennweite + "') <= SYSTEMATIK_AT.DN_BIS ) "
		+ "ORDER BY MUSTER ";

		logtrace( "\n\tSQL SYSTEMATIK_AT:\n\t"+strSQLStatement+" \n\n");
		logtrace("\nSchlauchtyp="+strSchlauchTyp+"\n");


	i = 0;
	strResultsMUSTER = "''"	;
	if (dbselect("WSDATA", strSQLStatement, "RS_Muster") > 0)
	{
		while (dbiseof("RS_Muster") == 0)
		{
			strDB_SCHLAUCH = "";
			strMUSTER = dbgetstring("RS_Muster", "MUSTER");
			if(strMUSTER != "")
			{
				strAT_MUSTER = "";
				numPos = -1;
				numPos = find(strMUSTER, "_");
				if(numPos > -1);
				{
					strAT_MUSTER = left(strMUSTER, (numPos - 1)) + "%";
				}
				else
				{
					numPos = -1;
					numPos = find(strMUSTER, ".");
					if(numPos > -1)
					{
						strAT_MUSTER = left(strMUSTER, (numPos - 1)) + "%";
						strDB_SCHLAUCH = right(strMUSTER, numPos);
					}
					else
					{
						strAT_MUSTER = strMUSTER;
					}
				}

				// -------------------------------------------------------------
				// SUCHE IN DATEN_AT
				// -------------------------------------------------------------

				if(strAT_MUSTER != "")
				{
					if (((strDB_SCHLAUCH != "") && (replace(strDB_SCHLAUCH, " ", "") == replace(strSchlauchTyp, " ", ""))) || (strDB_SCHLAUCH == ""))
					{
						strSQLStatementAT = "SELECT DISTINCT DATEN_AT.* FROM DATEN_AT WHERE ";

						if(strSCHLAUCHART != "SS")
						{
							if ((aStrANSCHLUSSART != "") && (aStrANSCHLUSSART != "ID_ALLE") )
								strSQLStatementAT = strSQLStatementAT + "DATEN_AT.ANSCHLUSSART = '" + aStrANSCHLUSSART + "' AND ";
						}
						else
						{
							strSQLStatementAT = strSQLStatementAT + "DATEN_AT.ANSCHLUSSART = 'Verschraubung' AND ";
						}

						if ((aStrMONTAGEART != "") && (aStrMONTAGEART != "ID_ALLE") )
					    	strSQLStatementAT = strSQLStatementAT + "DATEN_AT.MONTAGEART = '" + aStrMONTAGEART + "' AND ";

						if ((aStrWERKSTOFF != "") && (aStrWERKSTOFF != "ID_ALLE") )
							strSQLStatementAT = strSQLStatementAT + "DATEN_AT.WERKSTOFF = '"	+ aStrWERKSTOFF + "' AND ";

						strSQLStatementAT = strSQLStatementAT
							+ "( "
							+ "DATEN_AT.G_S_FREI = '"+ strSchlauchTyp	+ "' OR "
							+ "DATEN_AT.G_S_FREI = '"+ replace(strSchlauchTyp, " ","")+ "' OR "
							+ "DATEN_AT.G_S_FREI = ''"
							+ ") AND "
							+ "DATEN_AT.DN = '" + strNennweite + "' AND "
							+ "DATEN_AT.TYP_AT LIKE '"+strAT_MUSTER+"' "
							+ "ORDER BY TYP_AT LIMIT 1000";

						// ------------------------------------------------------------------------------------
						// Ergebnis-Tabelle mit allen Abhngigkeiten beim Client verfgbar machen:
						// ------------------------------------------------------------------------------------
						rowsCount = dbselect("WSDATA", strSQLStatementAT, "RS_AT_Suche");
						if(rowsCount > 0)
						{
							while (dbiseof("RS_AT_Suche") == 0)
							{
								resultListI = resultList+"[" + i + "]";

								dbcopy("RS_AT_Suche", resultListI);	// Produkt-Info kopieren
								dbcopy("RS_Muster", resultListI);	// Systematik-Info kopieren

								if(i == 1)
									setstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE", "1");

								// Produktinfo in die Ergebnistabelle bernehmen:
								setstring("TYP", resultListI, dbgetstring("RS_AT_Suche","TYP_AT"));
								setstring("NENNWEITE", resultListI, dbgetstring("RS_AT_Suche","DN"));
								setstring("TMAX", resultListI, dbgetstring("RS_AT_Suche","TMAX"));
								setstring("WERKSTOFF", resultListI, translate(dbgetstring("RS_AT_Suche","WERKSTOFF")));
								setstring("BESCHREIBUNG", resultListI, translate(dbgetstring("RS_Muster", "ID")));

								i = i + 1;
								dbskip("RS_AT_Suche");
							}

							// 1. Eintrag der Liste als selektiert setzen:
							resultListI = resultList+"[1]";
							copy(resultListI, "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT"+strSelSide);
							copy(resultListI, strPathAT+"."+strAT_STOREVAR);
							setstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE", "0" );
						}
					}
				}
			}
			dbskip("RS_Muster");
		}
	}

	if (getsize("","DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH") == 0)
	{
		strPicPath = ""; // steht im Template!
		strPic = strPicPath + "empty.gif";
		strSelSide = getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		strPathAuslegung = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT" + strSelSide;
		delete("", strPathAuslegung);

		var strIMGSchlauch = getstring("WS_IMG_SCHLAUCH"+strSelSide, "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
		setstring("WS_AT_IMAGE"+strSelSide, "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strIMGSchlauch);
		setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "ws_nl.gif");
		setstring("WS_AT_WAHL"+strSelSide,	"DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("CAD_PIC", strPathAuslegung, strPic);
		setstring("MSG_NOTHING_FOUND","DLGDATA.WS.SEARCH", translate("msg_kein_typ_vorhanden"));
	}
	else
		setstring("MSG_NOTHING_FOUND","DLGDATA.WS.SEARCH", "");

	storeAT(strSelSide);
}


//=======================================================================================
// MAIN SCRIPT
//=======================================================================================

{
	// Ergebnisse von vorheriger Suche lschen:
	// Event aus der aktuellen Maske
	var currentEvent = getstring("EVENT","");
	var currentDlg = getstring("AKTUELLE_MASKE","");
	var strPathInput = "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT";
	setstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE", "");

	if ((currentEvent == "IDC_BUTTON_SUCHEN_LINKS") || (currentEvent == "IDC_BUTTON_SUCHEN_RECHTS"))
	{
		var strSeite = replace(currentEvent, "IDC_BUTTON_SUCHEN", "");
		setstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE", strSeite);
		delete("","DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE");

		var strANSCHLUSSART	= getstring("WS_AT_ANSCHLUSSART"+strSeite, strPathInput);
		var strMONTAGEART	= getstring("WS_AT_ANSCHLUSSTYP"+strSeite, strPathInput);
		var strWERKSTOFF	= getstring("WS_AT_WERKSTOFF"	+strSeite, strPathInput);

		searchTypenAnschluss(strANSCHLUSSART, strMONTAGEART, strWERKSTOFF, strSeite);
	}
}