/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

////////////////////////////////////////////////////////////
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-10-07 <MD>
//				2008-10-16 <mb>
////////////////////////////////////////////////////////////


// ==================================================================================
//
//	Funktion:	initializeComboDepencies
//				Schreibt ein JavaScript, das in den Screen IDD_WS_TYPEN_SCHLAEUCHE
//				bernommen wird. Das JavaScript enthlt eine Tabelle mit allen
//				mglichen Beziehungen zwischen Ausfhrung, Werkstoff und Temperatur,
//				so da clientseitig alle Informationen fr die berprfung der
//				Abhngigkeiten zur Verfgung stehen.
// 	Parameter:
//
//	Returnwert:
// ==================================================================================

function initializeComboDepencies()
{
	var strPathInput	= "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT";
	var strSCHLAUCHART	= getstring("SCHLAUCHART", "DLGDATA.WS");
	var strAUSFUEHRUNG 	= getstring("AUSFUEHRUNG", strPathInput);
	var strNENNWEITE	= getstring("NENNWEITE", strPathInput);
	var strTEMPERATUR	= getstring("TEMPERATUR", strPathInput);
	var strWERKSTOFF	= getstring("WERKSTOFF", strPathInput);

	var strJSScript 	= "";
	var strSQLStatement = "";

	// ------------------------------------------------------------------------------------
	// Ausfhrung neu setzen:
	// ------------------------------------------------------------------------------------

	strSQLStatement	= "SELECT DISTINCT AUSFUEHRUNG as id, AUSFUEHRUNG as text FROM DATEN_SCHLAUCH ";

	if(strSCHLAUCHART == "SGA")
	{
		strSQLStatement = strSQLStatement + "WHERE (SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
	}
	else
		strSQLStatement = strSQLStatement + "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

	strSQLStatement = strSQLStatement + "ORDER BY AUSFUEHRUNG";
	setstring("WS_SELECT_AUSFUEHRUNG", "DLGDATA.WS", strSQLStatement);

	// ------------------------------------------------------------------------------------
	// Temperaturwerte initialisieren:
	// ------------------------------------------------------------------------------------

	strSQLStatement	= "SELECT DISTINCT TMAX as id, 'IDC_LABEL_BIS_'||TMAX as text FROM DATEN_SCHLAUCH ";

	if(strSCHLAUCHART == "SGA")
		strSQLStatement = strSQLStatement + "WHERE (SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
	else
		strSQLStatement = strSQLStatement + "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

//	print ("Hallo");


	if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
		strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";


	if((strNENNWEITE != "ID_OHNE") && (strNENNWEITE != "ID_ALLE") && (strNENNWEITE != ""))
		strSQLStatement = strSQLStatement + "AND DN = '"+strNENNWEITE+"' ";

	if((strWERKSTOFF != "ID_OHNE") && (strWERKSTOFF != "ID_ALLE") && (strWERKSTOFF != ""))
		strSQLStatement = strSQLStatement + "AND WS_SCHLAUCH = '"+strWERKSTOFF+"' ";

	strSQLStatement = strSQLStatement + "ORDER BY abs(TMAX)";

	if(dbselect("WSDATA", strSQLStatement, "RS") <= 0)
	{
		strSQLStatement	= "SELECT DISTINCT TMAX as id, "
			+ "'IDC_LABEL_BIS_'||TMAX as text "
			+ "FROM DATEN_SCHLAUCH ";

		if(strSCHLAUCHART == "SGA")
			strSQLStatement = strSQLStatement + "WHERE (SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
		else
			strSQLStatement = strSQLStatement + "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

		if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
			strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

		strSQLStatement = strSQLStatement + "ORDER BY abs(TMAX)";
	}
	setstring("WS_SELECT_TEMPERATUR", "DLGDATA.WS", strSQLStatement);

	// ------------------------------------------------------------------------------------
	// Werkstoff neu setzen:
	// ------------------------------------------------------------------------------------

	strSQLStatement	= "SELECT DISTINCT "
		+ "WS_SCHLAUCH as id, "
		+ "WS_SCHLAUCH as text "
		+ "FROM DATEN_SCHLAUCH ";

	if(strSCHLAUCHART == "SGA")
		strSQLStatement = strSQLStatement + "WHERE (SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
	else
		strSQLStatement = strSQLStatement + "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

	if((strTEMPERATUR != "ID_OHNE") && (strTEMPERATUR != "ID_ALLE") && (strTEMPERATUR != ""))
		strSQLStatement = strSQLStatement + "AND abs(TMAX) >= abs('"+strTEMPERATUR+"') ";

	if((strNENNWEITE != "ID_OHNE") && (strNENNWEITE != "ID_ALLE") && (strNENNWEITE != ""))
		strSQLStatement = strSQLStatement + "AND DN = '"+strNENNWEITE+"' ";

	if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
		strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

	strSQLStatement = strSQLStatement + "ORDER BY WS_SCHLAUCH ";

	if(dbselect("WSDATA", strSQLStatement, "RS") <= 0)
	{
		strSQLStatement	= "SELECT DISTINCT "
			+ "WS_SCHLAUCH as id, "
			+ "WS_SCHLAUCH as text "
			+ "FROM DATEN_SCHLAUCH ";

		if(strSCHLAUCHART == "SGA")
			strSQLStatement = strSQLStatement + "WHERE (SCHLAUCHART = '"+strSCHLAUCHART+"' or SCHLAUCHART = 'AGS') ";
		else
			strSQLStatement = strSQLStatement + "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

		strSQLStatement = strSQLStatement + "ORDER BY WS_SCHLAUCH ";
		setstring("WERKSTOFF", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT", "ID_ALLE");
	}
	setstring("WS_SELECT_WERKSTOFF", "DLGDATA.WS", strSQLStatement);

	// ------------------------------------------------------------------------------------
	// Nennweite neu setzen:
	// ------------------------------------------------------------------------------------

	if(getstring("EKSUBMITEVENT", "") != "IDC_COMBO_NENNWEITE")
	{
		if(strSCHLAUCHART != "SS")
		{
			strSQLStatement = "SELECT DISTINCT "
				+ "DN as id, "
				+ "'DN '||DN as text "
				+ "FROM DATEN_SCHLAUCH "
				+ "WHERE ";

			if(strSCHLAUCHART == "SGA")
				strSQLStatement = strSQLStatement + "(SCHLAUCHART = '"+strSCHLAUCHART+"' OR SCHLAUCHART = 'AGS' ) ";
			else
				strSQLStatement = strSQLStatement + "SCHLAUCHART = '"+strSCHLAUCHART+"' ";

			if((strTEMPERATUR != "ID_OHNE") && (strTEMPERATUR != "ID_ALLE") && (strTEMPERATUR != ""))
				strSQLStatement = strSQLStatement + "AND abs(TMAX) >= abs('"+strTEMPERATUR+"') ";

			if((strWERKSTOFF != "ID_OHNE") && (strWERKSTOFF != "ID_ALLE") && (strWERKSTOFF != ""))
				strSQLStatement = strSQLStatement + "AND WS_SCHLAUCH = '"+strWERKSTOFF+"' ";

			if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
				strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

			strSQLStatement = strSQLStatement + "ORDER BY abs(DN)";
		}
		else
		{
			strSQLStatement  = "SELECT DISTINCT "
				+ "DN as id, "
				+ "'DN '||DN as text "
				+ "FROM DATEN_SCHLAUCH "
				+ "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

			if((strTEMPERATUR != "ID_OHNE") && (strTEMPERATUR != "ID_ALLE") && (strTEMPERATUR != ""))
				strSQLStatement = strSQLStatement + "AND abs(TMAX) >= abs('"+strTEMPERATUR+"') ";

			if((strWERKSTOFF != "ID_OHNE") && (strWERKSTOFF != "ID_ALLE") && (strWERKSTOFF != ""))
				strSQLStatement = strSQLStatement + "AND WS_SCHLAUCH = '"+strWERKSTOFF+"' ";

			if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
				strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

			strSQLStatement = strSQLStatement
				+ "AND NOT TYP LIKE 'SV%' "
				+ "UNION SELECT DISTINCT "
				+ "DN as id, "
				+ "'NG '||DN as text "
				+ "FROM DATEN_SCHLAUCH "
				+ "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' ";

			if((strTEMPERATUR != "ID_OHNE") && (strTEMPERATUR != "ID_ALLE") && (strTEMPERATUR != ""))
				strSQLStatement = strSQLStatement + "AND abs(TMAX) >= abs('"+strTEMPERATUR+"') ";

			if((strWERKSTOFF != "ID_OHNE") && (strWERKSTOFF != "ID_ALLE") && (strWERKSTOFF != ""))
				strSQLStatement = strSQLStatement + "AND WS_SCHLAUCH = '"+strWERKSTOFF+"' ";

			if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
				strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

			strSQLStatement = strSQLStatement + "AND TYP LIKE 'SV%' ";
		}

		if(dbselect("WSDATA", strSQLStatement, "RS") <= 0)
		{
			if(strSCHLAUCHART == "SS")
			{
				strSQLStatement = "SELECT DISTINCT "
					+ "DN as id, "
					+ "'DN '||DN as text "
					+ "FROM DATEN_SCHLAUCH "
					+ "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' "
					+ "AND NOT TYP LIKE 'SV%' ";

				if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
					strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";

				strSQLStatement = "UNION SELECT DISTINCT "
					+ "DN as id, "
					+ "'NG '||DN as text "
					+ "FROM DATEN_SCHLAUCH "
					+ "WHERE SCHLAUCHART = '"+strSCHLAUCHART+"' "
					+ "AND TYP LIKE 'SV%'";

				if((strAUSFUEHRUNG != "ID_OHNE") && (strAUSFUEHRUNG != "ID_ALLE") && (strAUSFUEHRUNG != ""))
					strSQLStatement = strSQLStatement + "AND AUSFUEHRUNG = '"+strAUSFUEHRUNG+"' ";
			}
			else
			{
				strSQLStatement = "SELECT DISTINCT "
					+ "DN as id, "
					+ "'DN '||DN as text "
					+ "FROM DATEN_SCHLAUCH "
					+ "WHERE ";

				if(strSCHLAUCHART == "SGA")
					strSQLStatement = strSQLStatement + "(SCHLAUCHART = '"+strSCHLAUCHART+"' OR SCHLAUCHART = 'AGS') ";
				else
					strSQLStatement = strSQLStatement + "SCHLAUCHART = '"+strSCHLAUCHART+"' ";

				strSQLStatement = strSQLStatement + "ORDER BY abs(DN)";
			}
		}
		setstring("WS_SELECT_NENNWEITE", "DLGDATA.WS", strSQLStatement);
	}
}


//=======================================================================================
// MAIN SCRIPT
//=======================================================================================
{
	var currentEvent = getstring("EVENT", ""); 			// Event aus der aktuellen Maske
	var currentSubmitEvent 	= getstring("EKSUBMITEVENT", ""); 	// Event aus der vorherigen Maske
	var currentDlg = getstring("AKTUELLE_MASKE", "");

	// =================================================================================
	// Tabellenkopf abhngig der Schlauchart setzen:
	// =================================================================================

	var strSCHLAUCHART = getstring("SCHLAUCHART", "DLGDATA.WS");

	if(strSCHLAUCHART == "SS")
	{
		setstring("WS_TCH_SCHUTZART", "DLGDATA.WS.TYPEN_SCHLAUCH", translate("TCH_SCHUTZART"));
		setstring("WS_TCH_KENNZEICHNUNG", "DLGDATA.WS.TYPEN_SCHLAUCH", translate("TCH_KENNZEICHNUNG"));
	}
	else
	{
		setstring("WS_TCH_SCHUTZART", "DLGDATA.WS.TYPEN_SCHLAUCH", "" );
		setstring("WS_TCH_KENNZEICHNUNG", "DLGDATA.WS.TYPEN_SCHLAUCH", "Dichtung");
	}

	// =================================================================================
	// Ergebnisliste lschen, falls Eingabewerte gendert wurden:
	// =================================================================================

	if(	(currentEvent=="IDC_COMBO_TEMPERATUR") || (currentEvent=="IDC_COMBO_WERKSTOFF") ||
		(currentEvent=="IDC_COMBO_AUSFUEHRUNG") || (currentEvent=="IDC_COMBO_NENNWEITE"))
	{
		delete("WS_GEWAEHLTER_SCHLAUCH", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
		delete("RESULTLISTE_WS_SCHLAUCH", "DLGDATA.WS.TYPEN_SCHLAEUCHE.RESULT_TABLE");
		setstring("IDC_SUCHE_WS_MESSAGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE", "IDC_SUCHE_WS_MESSAGE");
	}

	// =================================================================================
	// Ordnung schaffen, falls die Schlauchart gewechselt wurde
	// Alle Informationen lschen
	// =================================================================================

	if((currentSubmitEvent == "IDC_BUTTON_SCHUTZSCHLAUCH") || (currentSubmitEvent == "IDC_BUTTON_ABGASSCHLAUCH") ||
		(currentSubmitEvent == "IDC_BUTTON_FOERDERSCHLAUCH") || (currentSubmitEvent == "IDC_ZURUECK_BUT"))
	{
		setstring("AUSFUEHRUNG", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT", "ID_ALLE");
		setstring("WERKSTOFF", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT", "ID_ALLE");
		setstring("TEMPERATUR", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT", "ID_ALLE");
		setstring("NENNWEITE", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT", "ID_ALLE");

		delete("RESULT_TABLE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("WS_STATIC_SCRIPT_AT", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("INPUT", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("AUSLEGUNG", "DLGDATA.WS.TYPEN_ANSCHLUESSE");

		setstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE", "");
		setstring("WS_AT_IMAGE_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
		setstring("WS_AT_IMAGE_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
		setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic );
		setstring("WS_AT_WAHL_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("WS_AT_WAHL_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("WS_NENNLAENGE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("IDC_SUCHE_WS_MESSAGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE", "IDC_SUCHE_WS_MESSAGE");
	}

	// =================================================================================
	// Aufklapplisten neu fllen
	// =================================================================================
	initializeComboDepencies();
}
