/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

#include "WS_GENERAL_FUNC_ANSCHLUSS_TYPEN.b"

////////////////////////////////////////////////////////////
//
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-10-07 <MD>
//
////////////////////////////////////////////////////////////


	// ==================================================================================
	//
	//	Funktion:	initializeComboStatements
	//				Bildet anhand der Daten des ausgewhlten Schlauchs die
	//				SQL-Statements zum fllen der Comboboxen im Dialog IDD_TYPEN_ANSCHLUESSE
	//				und setzt diese im Store, so dass die Comboboxen gefllt werden knnen
	// 	Parameter:
	//
	//	Returnwert:
	// ==================================================================================

function initializeComboStatements()
{
	var strPathAuslegung 	= "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG";
	var strPathSEL_Product 	= "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG";
	var strATmoeglich		= getstring("ANSCHLUSS",	strPathAuslegung);
	var strNennweite		= getstring("NENNWEITE", 	strPathAuslegung);
	var strTMax				= getstring("TMAX", 		strPathAuslegung);
	var strSchlauchTyp		= getstring("TYP",			strPathSEL_Product);

	var strJSScript = "";
	var strSQLStatement = "";
	var strSCHLAUCHART = "";
	var i = 0;
	var rowsCount = 0;
	var strJSScript = "";

	if(strATmoeglich == "x")
	{
		strSCHLAUCHART = getstring("SCHLAUCHART","DLGDATA.WS");
		setstring("WS_AT_ERLAUBT", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "true");

		// ----------------------------------
		// ANSCHLUSSART:
		// ----------------------------------

		if(strSCHLAUCHART == "SS")
		{
			strSQLStatement = "SELECT DISTINCT "
				+ "SYSTEMATIK_AT.ANSCHLUSS AS id, "
				+ "'LABEL_ANSCHLUSSART_'||SYSTEMATIK_AT.ANSCHLUSS AS text "
				+ "FROM SYSTEMATIK_AT "
				+ "WHERE "
				+ "ZUSATZ <> 'ENDE' "
				+ "AND SYSTEMATIK_AT.ANSCHLUSS LIKE 'Verschraubung%%' "
				+ "ORDER BY SYSTEMATIK_AT.ZUSATZ ";
		}
		else
		{
			strSQLStatement = "SELECT DISTINCT "
				+ "SYSTEMATIK_AT.ANSCHLUSS AS id, "
				+ "'LABEL_ANSCHLUSSART_'||SYSTEMATIK_AT.ANSCHLUSS AS text, "
				+ "ANSCHLUSSART_SORT.SORTIERUNG "
				+ "FROM SYSTEMATIK_AT, ANSCHLUSSART_SORT  "
				+ "WHERE ";

			if(strSCHLAUCHART == "SS")
			{
				strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ANSCHLUSS = 'Verschraubung' ";
			}
			else if(strSCHLAUCHART == "SGA") || (strSCHLAUCHART == "FS") || (strSCHLAUCHART == "AGS")
			{
				strSQLStatement = strSQLStatement + "SYSTEMATIK_AT.ANSCHLUSS <> 'Verschraubung' ";
			}

			strSQLStatement = strSQLStatement
				+ "AND SYSTEMATIK_AT.ANSCHLUSS = ANSCHLUSSART_SORT.ANSCHLUSSART "
				+ "ORDER BY ANSCHLUSSART_SORT.SORTIERUNG, SYSTEMATIK_AT.ANSCHLUSS ";
		}
		setstring("WS_AT_SELECT_ANSCHLUSSART", "DLGDATA.WS", strSQLStatement);

	// ----------------------------------
	// WERKSTOFF:
	// ----------------------------------
		strSchlauchTyp = replace(strSchlauchTyp, " ", "");

		strSQLStatement = "SELECT DISTINCT "
			+ "WERKSTOFF AS id, "
			+ "'LABEL_WERKSTOFF_'||WERKSTOFF AS text "
			+ "FROM DATEN_AT "
			+ "WHERE WERKSTOFF <> '' AND WERKSTOFF <> 'ENDE' AND "
			+ "( G_S_FREI = '"+strSchlauchTyp+"' OR G_S_FREI = '') ";

		if(strSCHLAUCHART == "SS")
			strSQLStatement = strSQLStatement + "AND WERKSTOFF = 'Messing-vernickelt' ";

		strSQLStatement = strSQLStatement + "ORDER BY WERKSTOFF ";
		setstring("WS_AT_SELECT_WERKSTOFF", "DLGDATA.WS", strSQLStatement);

	// ----------------------------------
	// MONTAGEART:
	// ----------------------------------
		strSQLStatement = "SELECT DISTINCT "
			+ "ART AS id, "
			+ "'LABEL_MONTAGEART_'||ART AS text "
			+ "FROM SYSTEMATIK_AT "
			+ "WHERE ART <> '' AND ART <> 'ENDE' ";

		if(strSCHLAUCHART == "SS")
			strSQLStatement = strSQLStatement + "AND ART = 'geklemmt' ";

		strSQLStatement = strSQLStatement + "ORDER BY ART ";

		setstring("WS_AT_SELECT_MONTAGEART", "DLGDATA.WS", strSQLStatement);

	// =========================================================================
	// JavaScript fr die Abhngigkeiten zwischen den Comboboxen schreiben:
	// =========================================================================

		strSQLStatement = ""
			+ "SELECT DISTINCT "
			+ "SYSTEMATIK_AT.ANSCHLUSS, SYSTEMATIK_AT.ART, SYSTEMATIK_AT.ZUSATZ, SYSTEMATIK_AT.WERKSTOFF "
			+ "FROM SYSTEMATIK_AT, DATEN_AT "
			+ "WHERE "
			+ "( G_S_FREI = '"+strSchlauchTyp+"' OR G_S_FREI = '') AND "
			+ "SYSTEMATIK_AT.ANSCHLUSS = DATEN_AT.ANSCHLUSSART AND "
			+ "SYSTEMATIK_AT.ART = DATEN_AT.MONTAGEART AND "
			+ "SYSTEMATIK_AT.WERKSTOFF = DATEN_AT.WERKSTOFF AND "
			+ "( abs(DATEN_AT.DN)> abs(SYSTEMATIK_AT.DN_VON) AND abs(DATEN_AT.DN) < abs(SYSTEMATIK_AT.DN_BIS)) ";

		if(strSCHLAUCHART == "SS")
		{
			strSQLStatement = strSQLStatement
				+ "AND SYSTEMATIK_AT.ANSCHLUSS = 'Verschraubung' "
				+ "AND SYSTEMATIK_AT.WERKSTOFF = 'Messing-vernickelt' ";
		}
		else if(strSCHLAUCHART == "SGA") || (strSCHLAUCHART == "FS") || (strSCHLAUCHART == "AGS")
		{
			strSQLStatement = strSQLStatement + "AND SYSTEMATIK_AT.ANSCHLUSS <> 'Verschraubung' ";
		}

		strSQLStatement = strSQLStatement + "ORDER BY SYSTEMATIK_AT.ANSCHLUSS, SYSTEMATIK_AT.ART, SYSTEMATIK_AT.WERKSTOFF ";

		i = 0;
		rowsCount = dbselect("WSDATA", strSQLStatement, "JS_ZEUGS");
		strJSScript = "var comboDepencies = new Array("+rowsCount+"); \n";

		if(rowsCount > 0)
		{
			while (dbiseof("JS_ZEUGS") == 0)
			{
				var dbANSCHLUSS = dbgetstring("JS_ZEUGS","ANSCHLUSS");
				var dbART		= dbgetstring("JS_ZEUGS","ART");
				var dbZUSATZ	= dbgetstring("JS_ZEUGS","ZUSATZ");
				var dbWERKSTOFF = dbgetstring("JS_ZEUGS","WERKSTOFF");
				if((dbANSCHLUSS != "") && (dbART != "") && (dbWERKSTOFF != "")) // && (dbZUSATZ != "")
				{
					strJSScript = strJSScript
						+ "comboDepencies["+i+"] = new Array(5); \n"
						+ "comboDepencies["+i+"]['ANSCHLUSSART'] 	= '" + dbANSCHLUSS		+ "'; \n"
						+ "comboDepencies["+i+"]['MONTAGEART'] 	= '" + dbART			+ "'; \n"
						+ "comboDepencies["+i+"]['ZUSATZ'] 		= '" + dbZUSATZ			+ "'; \n"
						+ "comboDepencies["+i+"]['WERKSTOFF'] 	= '" + dbWERKSTOFF		+ "'; \n"
						+ "comboDepencies["+i+"]['SCHLAUCHART'] 	= '" + strSCHLAUCHART	+ "'; \n";
					i = i+1;
				}
				dbskip("JS_ZEUGS");
			}
		}
		setstring("WS_STATIC_SCRIPT_AT", "DLGDATA.WS.TYPEN_ANSCHLUESSE", strJSScript);
	}
	else
	{
		setstring("WS_AT_ERLAUBT", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "false");
		setstring("WS_AT_SELECT_ANSCHLUSSART", 	"DLGDATA.WS.SQL", "");
		setstring("WS_AT_SELECT_WERKSTOFF", 	"DLGDATA.WS.SQL", "");
		setstring("WS_AT_SELECT_MONTAGEART", 	"DLGDATA.WS.SQL", "");
	}
}

// ==================================================================================
//
//	Funktion:	writeResultsJSArray
//				schreibt die Ergebnisliste in ein JS-Array, so dass diese auch beim
//				beim Client verfgbar ist. Daten wie Bildinfo etc. knnen dann je nach
//				nach Selektion per JavaScript ausgelesen werden.
// 	Parameter:
//
//	Returnwert:
// ==================================================================================

function writeResultsJSArray()
{
	var currentEvent = getstring("EKSUBMITEVENT",""); // Event aus dem letzten Submit
	var resultList = "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";

	var i = 0;
	var resultListI = "";
	var rowsCount = getsize("", resultList);
	var strJSScript = "var resultListAT = new Array("+rowsCount+"); \n";

	if(rowsCount > 0)
	{
		for (i=0; i <= (rowsCount - 1); i++)
		{
			resultListI = resultList+"["+i+"]";
			strJSScript = strJSScript
				+ "resultListAT["+i+"] = new Array("+4+"); \n"
				+ "resultListAT["+i+"]['TYP_AT'] 	= '"+getstring("TYP_AT",	resultListI)+"'; \n"
				+ "resultListAT["+i+"]['ID'] 		= '"+getstring("ID",		resultListI)+"'; \n"
				+ "resultListAT["+i+"]['CAD_EIN'] = '"+getstring("CAD_EIN",resultListI)+"'; \n"
				+ "resultListAT["+i+"]['SIDE'] 	= '"+(replace(currentEvent, "IDC_BUTTON_SUCHEN_", ""))+"'; \n";
		}
	}
	setstring("WS_STATIC_SCRIPT_AT", "DLGDATA.WS.TYPEN_ANSCHLUESSE", strJSScript);
}



//=======================================================================================
// MAIN SCRIPT
//=======================================================================================
{
	var currentEvent 	= getstring("EVENT",""); 			// Event aus der aktuellen Maske
	var currentEvent1	= getstring("EKSUBMITEVENT",""); 	// Event aus der aktuellen Maske
	var currentDlg 		= getstring("AKTUELLE_MASKE","");

	var strPicPath			= "";							 // steht im Template!
	var strPic 				= strPicPath + "empty.gif";
	var strPathInput		= "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT";
	var strAnschlussartLi	= getstring("WS_AT_ANSCHLUSSART_LINKS", strPathInput);
	var strAnschlussartRe	= getstring("WS_AT_ANSCHLUSSART_RECHTS", strPathInput);

	setstring( "NENNLAENGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG", getstring("WS_NENNLAENGE","DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT"));

	var strIMGSchlauchLi = getstring("WS_IMG_SCHLAUCH_LINKS", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	var strIMGSchlauchRe = getstring("WS_IMG_SCHLAUCH_RECHTS", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	var strWS_AT_WAHL_LINKS = getstring("WS_AT_WAHL_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");
	var strWS_AT_WAHL_RECHTS = getstring("WS_AT_WAHL_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");

	if ((currentEvent == "INIT") || (currentEvent == "IDC_BUTTON_ANSCHLUESSE"))
	{
		if(strAnschlussartLi == "ID_OHNE") || (strWS_AT_WAHL_LINKS == "")
		{
			setstring("WS_AT_IMAGE_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strIMGSchlauchLi);
			setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "ws_nl.gif");
			setstring("AT_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG", "");
			setstring("WS_AT_WAHL_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
			delete("AT_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG");
		}

		if(strAnschlussartRe == "ID_OHNE") || (strWS_AT_WAHL_RECHTS == "")
		{
			setstring("WS_AT_IMAGE_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strIMGSchlauchRe);
			setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "ws_nl.gif");
			setstring("WS_AT_WAHL_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
			delete("AT_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG");
		}
	}

	if ((currentEvent == "INIT") || (currentEvent == "IDC_BUTTON_ANSCHLUESSE"))
		initializeComboStatements();

	var strSelSide = "";
	var resultList = "";
	var strSelected = "";

	if((currentEvent == "IDC_BUTTON_SUCHEN_LINKS") || (currentEvent == "IDC_BUTTON_SUCHEN_RECHTS"))
	{
		strSelSide = replace(currentEvent, "IDC_BUTTON_SUCHEN", "");
		setstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE", strSelSide);
	}

	if(	(currentEvent == "IDC_TABLE_WS_ANSCHLUESSE_ERGEBNIS") || (currentEvent == "INIT") ||
		(currentEvent == "IDC_BUTTON_SUCHEN_LINKS") || (currentEvent == "IDC_BUTTON_SUCHEN_RECHTS") || (currentEvent == "IDC_BUTTON_ANSCHLUESSE"))
	{
		strSelSide  = "";
		resultList 	= "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";
		strSelected	= getstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		if(strSelected	!= "")
		{
			strSelSide 	= getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
			storeAT(strSelSide);
			setstring("WS_AT_WAHL"+strSelSide, "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", getstring("TYP_AT", resultList+"["+strSelected+"]"));
		}
		setstring("NENNLAENGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG", getstring("WS_NENNLAENGE","DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT"));
	}

	// Werte neu initialisieren beim Rcksprung zur Startseite

	if(currentEvent == "IDC_HOME_BUT")
	{
		delete("RESULT_TABLE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("WS_STATIC_SCRIPT_AT", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("INPUT", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		delete("AUSLEGUNG", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
		setstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE", 	  "");
		setstring("WS_AT_IMAGE_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
		setstring("WS_AT_IMAGE_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
		setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic );
		setstring("WS_AT_WAHL_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("WS_AT_WAHL_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
		setstring("WS_NENNLAENGE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "");
	}
}


