/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */


////////////////////////////////////////////////////
// Author:		M.Derschang / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2008-10-16 <mb>
////////////////////////////////////////////////////


// ==================================================================================
//	Funktion:	openRTF
//				ffnet eine RTF-Vorlage
// 	Parameter:	aStrTemplName - Name der Vorlage
//	Returnwert:	-
// ==================================================================================

function openRTF(aStrTemplName)
{
	var strPath = getstddirectory("PROGRAM") + "catalog\\data\\doctemplates\\";
	rtfreadtemplate("WS_DATASHEET", strPath + aStrTemplName + ".rtf");
}

// ==================================================================================
//
//	Funktion:	setAT_Masse()
//				Setzt die Bemaungen fr das Anschluteil, dessen Mae im
//				berlieferten Pfad stehen im Datenblatt
// 	Parameter:	aStrPathAuslegungAT - Pfad in dem die AT-Mae stehen
//	Returnwert:	-
// ==================================================================================

function setAT_Masse(aStrPathAuslegungAT, aStrSelSide)
{
	var strConstProgVar = "";
	if(aStrSelSide == "LINKS")
		strConstProgVar	= "WS_PRINT_ATL_DATA_MASS_";
	else
		strConstProgVar	= "WS_PRINT_ATR_DATA_MASS_";

	var i, x;
	var mass_l, mass_l1, mass_l2, mass_l3, mass_l4;
	var mass_d, mass_d1, mass_d2, mass_d3, mass_d4, mass_d5, mass_d6, mass_d7;
	var mass_f, mass_s, mass_t, mass_k;
	var mass_b, mass_b1, mass_a_x_Dm, mass_a_x_Dm, mass_GEWINDE, mass_SW;

	i = 1;
	if(aStrPathAuslegungAT != "")
	{
		mass_l = "";
		mass_l = getstring("L", aStrPathAuslegungAT);
		if(mass_l != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_l"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_l+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_l == "+mass_l)
			i = i + 1;
		}

		mass_l1 = "";
		mass_l1 = getstring("L1", aStrPathAuslegungAT);
		if(mass_l1 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_l1"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_l1+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_l1 == "+mass_l1)
			i = i + 1;
		}

		mass_l2 = "";
		mass_l2 = getstring("L2", aStrPathAuslegungAT);
		if(mass_l2 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_l2"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_l2+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_l2 == "+mass_l2)
			i = i + 1;
		}

		mass_l3	= "";
		mass_l3 = getstring("L3", aStrPathAuslegungAT);
		if(mass_l3 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_l3"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_l3+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_l3 == "+mass_l3)
			i = i + 1;
		}

		mass_l4	= "";
		mass_l4 = getstring("L4", aStrPathAuslegungAT);
		if(mass_l4 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_l4"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_l4+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_l4 == "+mass_l4)
			i = i + 1;
		}

		mass_d = "";
		mass_d = getstring("D", aStrPathAuslegungAT);
		if(mass_d != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d == "+mass_d)
			i = i + 1;
		}

		mass_d1 = "";
		mass_d1 = getstring("D1", aStrPathAuslegungAT);

		if(mass_d1 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d1"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d1+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d1 == "+mass_d1)
			i = i + 1;
		}

		mass_d2 = "";
		mass_d2 = getstring("D2", aStrPathAuslegungAT);
		if(mass_d2 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d2"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d2+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d2 == "+mass_d2)
			i = i + 1;
		}

		mass_d3 = "";
		mass_d3 = getstring("D3", aStrPathAuslegungAT);

	// SONDERFALL: Ma D3 entspriche AD_D aus der Schlauchtabelle lesen:
		if((mass_d3 == "";) && (getstring("SCHLAUCHART", "DLGDATA.WS") != "SS"))
			mass_d3 = getstring("AD_D", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG");

		if(mass_d3 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d3"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d3+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d3 == "+mass_d3)
			i = i + 1;
		}

		mass_d4 = "";
		mass_d4 = getstring("D4", aStrPathAuslegungAT);
		if(mass_d4 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d4"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d4+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d4 == "+mass_d4)
			i = i + 1;
		}

		mass_d5 = "";
		mass_d5 = getstring("D5", aStrPathAuslegungAT);
		if(mass_d5 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d5"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d5+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d5 == "+mass_d5)
			i = i + 1;
		}

		mass_d6 = "";
		mass_d6 = getstring("D6", aStrPathAuslegungAT);
		if(mass_d6 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d6"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d6+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d6 == "+mass_d6)
			i = i + 1;
		}

		mass_d7 = "";
		mass_d7 = getstring("D7", aStrPathAuslegungAT);
		if(mass_d7 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_d7"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_d7+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_d7 == "+mass_d7)
			i = i + 1;
		}

		mass_f = "";
		mass_f = getstring("F", aStrPathAuslegungAT);
		if(mass_f != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_f"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_f)
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_f == "+mass_f)
			i = i + 1;
		}

		mass_s = "";
		mass_s = getstring("S", aStrPathAuslegungAT);
		if(mass_s != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_s"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_s+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_s == "+mass_s)
			i = i + 1;
		}

		mass_b = "";
		mass_b = getstring("B", aStrPathAuslegungAT);
		if(mass_b != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_b"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_b)
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_b == "+mass_b)
			i = i + 1;
		}

		mass_b1 = "";
		mass_b1 = getstring("B1", aStrPathAuslegungAT);
		if(mass_b1 != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_b1"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_b1)
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_b1 == "+mass_b1)
			i = i + 1;
		}

		mass_a_x_Dm = "";
		mass_a_x_Dm = getstring("A_X_DM", aStrPathAuslegungAT);
		if(mass_a_x_Dm != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_a_x_Dm"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_a_x_Dm+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_a_x_Dm == "+mass_a_x_Dm)
			i = i + 1;
		}

		mass_DIN24154_Reihe = "";
		mass_DIN24154_Reihe = getstring("DIN24154_REIHE", aStrPathAuslegungAT);
		if(mass_DIN24154_Reihe != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_DIN24154_Reihe"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_DIN24154_Reihe)
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_DIN24154_Reihe == "+mass_DIN24154_Reihe)
			i = i + 1;
		}

		mass_t = "";
		mass_t = getstring("T", aStrPathAuslegungAT);
		if(mass_t != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_t"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_t+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_t == "+mass_t)
			i = i + 1;
		}

		mass_k = "";
		mass_k = getstring("K", aStrPathAuslegungAT);
		if(mass_k != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_k"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_k+" "+translate("WS_UNIT_MM"));
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_k == "+mass_k)
			i = i + 1;
		}

		mass_GEWINDE = "";
		mass_GEWINDE = getstring("GEWINDE", aStrPathAuslegungAT);
		if(mass_GEWINDE != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_GEWINDE"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_GEWINDE )
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_k == "+mass_GEWINDE)
			i = i + 1;
		}

		mass_SW = "";
		mass_SW = getstring("SW", aStrPathAuslegungAT);
		if(mass_SW != "")
		{
			setstring(strConstProgVar+i, 			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_SW"));
			setstring(strConstProgVar+i+"_VALUE", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", mass_SW )
			//logtrace("\n\t"+strConstProgVar+i+"_VALUE: mass_k == "+mass_SW)
			i = i + 1;
		}
	}

	for (x = i; x <= 9; x++)
	{
		setstring(strConstProgVar+x, "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "");
		setstring(strConstProgVar+x+"_VALUE", "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "");
	}
}


// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

{
	delete("WS_DATASHEET", "DLGDATA.WS.AUSLEGUNG");
	setstring("DATA_SHEET", "DLGDATA.WS.AUSLEGUNG", "");

	strPathAuslegung 	= "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG";
	strPathAuslegungATL	= "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_LINKS";
	strPathAuslegungATR	= "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_RECHTS";

    var TEMPDIR = trimright(getstring("CATALOG.HTMLTEMP","ROOT"),"\\")+"\\";

	var strTempRTFfile = gettempfile(TEMPDIR,"rtf");
    var RTF_FILENAME = replace(strTempRTFfile,TEMPDIR,"");
	var strProgdir = getstddirectory("PROGRAM");
	var strImagePath = getstddirectory("PROGRAM") + "catalog\\client\\custom\\img\\WITcad\\WS\\";

	// -------------------------------------------------------------------------
	// Bild Initialisieren:
	// -------------------------------------------------------------------------

	var strAnschlussartLi = getstring("WS_AT_ANSCHLUSSART_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");
	var strAnschlussartRe = getstring("WS_AT_ANSCHLUSSART_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");
	var strWS_AT_WAHL_LINKS = getstring("WS_AT_WAHL_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");
	var strWS_AT_WAHL_RECHTS = getstring("WS_AT_WAHL_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT");
	var strIMGSchlauchLi = getstring("WS_IMG_SCHLAUCH_LINKS", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	var strIMGSchlauchRe = getstring("WS_IMG_SCHLAUCH_RECHTS", "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");

	strIMGSchlauchLi = replace(strIMGSchlauchLi, ".gif", ".png");
	strIMGSchlauchRe = replace(strIMGSchlauchRe, ".gif", ".png");

	if(strAnschlussartLi == "ID_OHNE") || (strWS_AT_WAHL_LINKS == "";)
	{
		setstring("WS_AT_IMAGE_LINKS", 	"DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strIMGSchlauchLi);
		setstring("WS_AT_BILD_MITTE", 	"DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "ws_nl.gif");
		delete("AT_LINKS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG");
		setstring("CAD_RTFPIC", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_LINKS", strIMGSchlauchLi);
	}

	if(strAnschlussartRe == "ID_OHNE") || (strWS_AT_WAHL_RECHTS == "")
	{
		setstring("WS_AT_IMAGE_RECHTS",	"DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strIMGSchlauchRe);
		setstring("WS_AT_BILD_MITTE", 	"DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", "ws_nl.gif");
		delete("AT_RECHTS", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG");
		setstring("CAD_RTFPIC", "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_RECHTS", strIMGSchlauchRe);
	}

	setstring("NENNLAENGE", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG", getstring("WS_NENNLAENGE","DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT"));

	// -------------------------------------------------------------------------
	// Einlesen aller bentigten Daten fr das Datenblatt:
	// -------------------------------------------------------------------------

	var strAusfuehrung = translate(getstring("AUSFUEHRUNG", strPathAuslegung)+"_datenblatt");
	var strWerkstoff = translate(getstring("WERKSTOFF", strPathAuslegung));
	var strSchlauchTypOrg = getstring("TYP", strPathAuslegung);
	var strSchlauchTyp = getstring("TYP", strPathAuslegung);
	var strSchlauchArt, strATSchlauchArt;

	if(left(strSchlauchTypOrg, 2) == "FA")
	{
		strSchlauchArt = translate("WS_PRINT_SCHLAUCHART_AGS");
		strATSchlauchArt = translate("WS_PRINT_AT_SCHLAUCHART_AGS");
	}
	else
	{
		strSchlauchArt = translate("WS_PRINT_SCHLAUCHART_" 	+ getstring("SCHLAUCHART", "DLGDATA.WS"));
		strATSchlauchArt = translate("WS_PRINT_AT_SCHLAUCHART_" 	+ getstring("SCHLAUCHART", "DLGDATA.WS"));
	}

	var strMinBiegeRadius 	= getstring("RMIN", 		strPathAuslegung)+" "+translate("WS_UNIT_MM");
	var strNennweite		= getstring("NENNWEITE", 	strPathAuslegung);
	var strTMax				= getstring("TMAX", 		strPathAuslegung)+" "+translate("WS_UNIT_GRAD_CELSIUS");
	var strHerstellLaenge	= getstring("MAX_HERSTELL",	strPathAuslegung)+" "+translate("WS_UNIT_M");
	var strD_aussen			= getstring("AD_D",			strPathAuslegung)+" "+translate("WS_UNIT_MM");
	var strD_innen			= getstring("ID_D",			strPathAuslegung)+" "+translate("WS_UNIT_MM");
	var strSchlauchIdent	= getstring("ID",			strPathAuslegung);

	var strNennlaenge = "";
	if(getstring("NENNLAENGE",	strPathAuslegung) != "")
		strNennlaenge = getstring("NENNLAENGE",	strPathAuslegung)+" "+translate("WS_UNIT_MM");

	var strImgProfil		= getstring("WS_IMG_PROFIL", 		"DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	var strImgQuerschnitt	= getstring("WS_IMG_QUERSCHNITT", 	"DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
	strImgProfil		= strImagePath + replace(strImgProfil, 	 ".gif", ".png");
	strImgQuerschnitt	= strImagePath + replace(strImgQuerschnitt, ".gif", ".png");

	var strDichtung			= getstring("DICHTUNG",		strPathAuslegung);
	var strSchutzart        = getstring("SCHUTZART",    strPathAuslegung);
	var strKennzeichnung    = getstring("KENNZEICHNUNG",strPathAuslegung);
	var strGewicht			= getstring("GEWICHT",		strPathAuslegung)+" "+translate("WS_UNIT_KG_M");

	var strATLText			= getstring("ID", 		strPathAuslegungATL);
	var strATLTMax			= getstring("TMAX", 	strPathAuslegungATL)+" "+translate("WS_UNIT_GRAD_CELSIUS");
	var strATLTyp			= getstring("TYP_AT", 	strPathAuslegungATL);
	var strATLMontageart    = translate("LABEL_MONTAGEART_"+getstring("MONTAGEART",   strPathAuslegungATL));
	var strATLWerkstoff 	= translate( getstring("WERKSTOFF", strPathAuslegungATL));

	var strATRText			= getstring("ID", strPathAuslegungATR);
	var strATRTMax			= getstring("TMAX", 	strPathAuslegungATR)+" "+translate("WS_UNIT_GRAD_CELSIUS");
	var strATRTyp			= getstring("TYP_AT", 	strPathAuslegungATR);
	var strATRMontageart    = translate("LABEL_MONTAGEART_"+getstring("MONTAGEART",   strPathAuslegungATR));
	var strATRWerkstoff	 	= translate( getstring("WERKSTOFF", strPathAuslegungATR));

	var strATLImage			= strImagePath+getstring("CAD_RTFPIC", 	"DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_LINKS");
	var strATRImage			= strImagePath+getstring("CAD_RTFPIC", 	"DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_RECHTS");
	var strATMImage			= strImagePath+"ws_nl.png";

	// -------------------------------------------------------------------------
	// Setzen aller bentigten Daten fr das Datenblatt:
	// -------------------------------------------------------------------------

	setstring("WS_PRINT_DATA_SCHLAUCHART",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strSchlauchArt);
	setstring("WS_PRINT_DATA_TYP_SCHLAUCH",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strSchlauchTyp);
	setstring("WS_PRINT_DATA_TYP_SCHLAUCH_ORIGINAL","DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strSchlauchTypOrg);
	setstring("WS_PRINT_DATA_NENNWEITE",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strNennweite);
	setstring("WS_PRINT_DATA_NENNLAENGE",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strNennlaenge);
	setstring("WS_PRINT_DATA_HERSTELLAENGE",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strHerstellLaenge);
	setstring("WS_PRINT_DATA_AUSFUEHRUNG",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strAusfuehrung);

	//bersetzung vom Innen- und Auendurchmesser hngt ab vom Wert:
	if(find(strD_aussen, "x") > -1)
		setstring("WS_PRINT_DATA_AUSSEN_D_HEADER",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_AUSSEN_D1_D2"));
	else
		setstring("WS_PRINT_DATA_AUSSEN_D_HEADER",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_AUSSEN_D"));
	setstring("WS_PRINT_DATA_AUSSEN_D",				"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strD_aussen);

	if(find(strD_innen, "x") > -1)
		setstring("WS_PRINT_DATA_INNEN_D_HEADER",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_INNEN_D1_D2"));
	else
		setstring("WS_PRINT_DATA_INNEN_D_HEADER",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_INNEN_D"));
	setstring("WS_PRINT_DATA_INNEN_D",				"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strD_innen);

	setstring("WS_PRINT_DATA_DICHTUNG",				"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_DICHTUNG_"+strDichtung));

    var strSchutzart_KZG = "-";

    if(getstring("SCHLAUCHART","DLGDATA.WS") == "SS")
    {
        if((strSchutzart != "") || (strKennzeichnung != ""))
        {
            strSchutzart_KZG = "";

            if((strSchutzart != "") && (strKennzeichnung != ""))
                strSchutzart_KZG = strSchutzart+" / "+strKennzeichnung;
            else if((strSchutzart == "";) && (strKennzeichnung != ""))
                strSchutzart_KZG = strKennzeichnung;
            else if((strSchutzart != "") && (strKennzeichnung == ""))
                strSchutzart_KZG = strSchutzart;
        }
        else
            strSchutzart_KZG = "-";
    }
    else
	{
        strSchutzart_KZG = "-";
	}

    setstring("WS_PRINT_DATA_SCHUTZART_KZG",        "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strSchutzart_KZG);
	setstring("WS_PRINT_DATA_IMG_PROFIL",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strImgProfil);
	setstring("WS_PRINT_DATA_IMG_QUERSCHNITT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strImgQuerschnitt);
	setstring("WS_PRINT_DATA_MIN_BIEGERADIUS",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strMinBiegeRadius);
	setstring("WS_PRINT_DATA_SCHLAUCH_IDENT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strSchlauchIdent);
	setstring("WS_PRINT_DATA_TMAX",					"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strTMax);
	setstring("WS_PRINT_DATA_WERKSTOFF_SCHLAUCH",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strWerkstoff);
	setstring("WS_PRINT_DATA_AT_LINKS",				"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLImage);
	setstring("WS_PRINT_DATA_AT_MITTE",				"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATMImage);
	setstring("WS_PRINT_DATA_AT_RECHTS",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRImage);
	setstring("WS_PRINT_DATA_AT_SCHLAUCH",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATSchlauchArt);

	// --------------------------------------------------
	// Anschluss links:

	if(strATLTyp != "")
	{
		setstring("WS_PRINT_DATA_ATL_LANGTEXT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLText);
		setstring("WS_PRINT_DATA_ATL_TMAX",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLTMax);
		setstring("WS_PRINT_DATA_ATL_TYP",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLTyp);
		setstring("WS_PRINT_DATA_ATL_WERKSTOFF",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLWerkstoff);
        setstring("WS_PRINT_DATA_ATL_MONTAGEART",   "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATLMontageart);

		// Mae schreiben fr linken Anschlu:
		setAT_Masse("DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_LINKS", "LINKS");
	}
	else
	{
		setstring("WS_PRINT_DATA_ATL_LANGTEXT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATL_TMAX",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATL_TYP",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATL_WERKSTOFF",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_GRAD_CELSIUS", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "");
        setstring("WS_PRINT_DATA_ATL_MONTAGEART",   "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "");

		// Mae schreiben fr linken Anschlu:
		setAT_Masse("", "LINKS");
	}

	// --------------------------------------------------
	// Anschluss rechts:

	if(strATRTyp != "")
	{
		setstring("WS_PRINT_DATA_ATR_LANGTEXT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRText );
		setstring("WS_PRINT_DATA_ATR_TMAX",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRTMax );
		setstring("WS_PRINT_DATA_ATR_TYP",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRTyp );
		setstring("WS_PRINT_DATA_ATR_WERKSTOFF",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRWerkstoff );
        setstring("WS_PRINT_DATA_ATR_MONTAGEART",   "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", strATRMontageart );

		if(strATRMax != "")
			setstring("WS_PRINT_DATA_GRAD_CELSIUS", "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", translate("WS_PRINT_GRAD_CELSIUS"));
		else
			setstring("WS_PRINT_DATA_GRAD_CELSIUS", "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "" );

		setAT_Masse("DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT_RECHTS", "RECHTS");
	}
	else
	{
		setstring("WS_PRINT_DATA_ATR_LANGTEXT",		"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATR_TMAX",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATR_TYP",			"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_ATR_WERKSTOFF",	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "-");
		setstring("WS_PRINT_DATA_GRAD_CELSIUS", 	"DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "" );
        setstring("WS_PRINT_DATA_ATR_MONTAGEART",   "DLGDATA.WS.AUSLEGUNG.WS_DATASHEET", "" );

		setAT_Masse("", "RECHTS");
	}

	// -------------------------------------------------------------------------
	// Dokument ffnen, Variablen ersetzen und temporre Datei erzeugen:
	// -------------------------------------------------------------------------

	openRTF("DB_WS");

	rtfparseandreplace("WS_DATASHEET");
	rtfkilltabrowiterators("WS_DATASHEET");

	var strResultRTF 		= rtfgetdoc("WS_DATASHEET");
	var doctemplatespath 	= getstddirectory("PROGRAM") + "catalog\\data\\doctemplates\\";

	rtfread("DS_TEMPLATE", doctemplatespath+"db_ws_ds.rtf");
	rtfreplace("DS_TEMPLATE", "$CONTENT_DATASHEET$", strResultRTF);
	rtfwrite("DS_TEMPLATE", strTempRTFfile);

	// Pfad setzen, damit die Datei beim Client geffnet werden kann;
	setstring("DATA_SHEET", "DLGDATA.WS.AUSLEGUNG", "WITtmp/" + RTF_FILENAME);
	setstring("DATA_SHEET_CONTENT", "DLGDATA.WS.AUSLEGUNG", strResultRTF);
}
