/**
 * Cascade Serverseitige Logik
 *
 * Copyright (c) 2004-2008 Plan Software GmbH
 *
 * @category
 * @package
 * @copyright  Copyright (c) 2004-2008 Plan Software GmbH (http://www.plansoft.de)
 */

////////////////////////////////////////////////////////////
// Author:		M.Derschang
// Copyright:	Plan Software GmbH, Saarbrcken
//
// last change:	2004-12-10 <MD>
//				2008-10-16 <mb>
////////////////////////////////////////////////////////////


// ==================================================================================
//	Funktion:	storeAT()
//				Speichert das selektierte Anschluteil im Store
//
// 	Parameter:	aStrSelSide - Selektierte Seite des Schlauchs
//
//	Returnwert:	-
// ==================================================================================

function storeAT(aStrSelSide)
{
	var strPathAuslegung = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT"+aStrSelSide;
	delete("", strPathAuslegung);

	var resultList = "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";
	var strSelected = getstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
	var resultListI = "";

	if(strSelected != "")
	{
		resultListI = resultList + "[" + strSelected + "]";
		copy(resultListI, strPathAuslegung);
	}
	setATPicture();
	setATDatasheetPicture();
}

// ==================================================================================
//	Funktion:	setATPicture()
//				Speichert den Pfad fr das selektierte Bild im Store
//
// 	Parameter:	aStrSelSide - Selektierte Seite des Schlauchs
//				aStrPicture - Bildpfad
//
//	Returnwert:	-
// ==================================================================================

function storeATPicture(aStrSelSide, aStrPicture)
{
	var strPathAuslegung = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT"+aStrSelSide;
	setstring("CAD_PIC", strPathAuslegung, aStrPicture);
}

// ==================================================================================
//	Funktion:	storeATDatasheetPicture()
//				Speichert den Pfad fr das selektierte Bild fr das Datenblatt
//				im Store
//
// 	Parameter:	aStrSelSide - Selektierte Seite des Schlauchs
//				aStrPicture - Bildpfad
//
//	Returnwert:	-
// ==================================================================================

function storeATDatasheetPicture(aStrSelSide, aStrPicture)
{
	strPathAuslegung = "DLGDATA.WS.TYPEN_ANSCHLUESSE.AUSLEGUNG.AT"+aStrSelSide;
	setstring("CAD_RTFPIC", strPathAuslegung, aStrPicture);
}

// ==================================================================================
//	Funktion:	setATPicture()
//				Setzt den Pfad fr das selektierte Bild im Store
//
// 	Parameter:	-
//	Returnwert:	-
// ==================================================================================

function setATPicture()
{
	var strPicPath		 = ""; // steht im Template!
	var strPic 			 = strPicPath + "empty.gif";
	var strNLPic 		 = strPicPath + "ws_nl.gif";

	var resultList 	= "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";
	var strSelected	= getstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
	var strSelSide 	= getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");

	var resultListI = "";
	var currentSide = "";
	var strTYP_AT = "";
	var strPic = "";
	var strPicSide = "";
	var strPicLeft = "";
	var strPicRight = "";
	var pos = 0;

	if(strSelected	!= "")
	{
		resultListI = resultList+"["+strSelected+"]";
		currentSide	= getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");

		// ------------------------------------------------
		// Selektiertes Anschlussteil speichern:
		// ------------------------------------------------
		strTYP_AT = getstring("TYP_AT", resultListI);
		strPic = getstring("CAD_EIN", resultListI);

		if(strPic != "")
		{
			strPicSide = "";
			strPicLeft = "";
			strPicRight = "";

			if(strSelSide == "_LINKS")
				strPicSide = "links.";
			else
				strPicSide = "rechts.";

			pos = find(strPic, ".");
			if(pos > -1)
			{
				strPicRight = right(strPic, (strlen(strPic) - pos));
				strPicLeft = left(strPic, pos);
			}

			strPic = strPicLeft + strPicSide + strPicRight;
			strPic = replace(strPic, "dwg", "");
			strSchlauchTyp = getstring("TYP",  "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG");

			if((strSchlauchTyp == "SD-S-G") || (strSchlauchTyp == "SD-S-B") || (strSchlauchTyp == "SD-S-K") || (strSchlauchTyp == "SD-E-G") || (strSchlauchTyp == "SD-E-B") || (strSchlauchTyp == "SD-E-K"))
				strPic = strPicPath + strPic + "3000.gif";
			else
				strPic = strPicPath + strPic + "2000.gif";

			setstring("WS_AT_IMAGE"+strSelSide, "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
			setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strNLPic);
		}
		else
		{
			strPic = strPicPath + "no_pix.gif"
			setstring("WS_AT_IMAGE"+strSelSide, "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
			setstring("WS_AT_BILD_MITTE", "DLGDATA.WS.TYPEN_ANSCHLUESSE.INPUT", strPic);
		}
	}
	storeATPicture(strSelSide, strPic);
}

// ==================================================================================
//	Funktion:	setATDatasheetPicture()
//				Setzt den Pfad fr das selektierte RTF-Bild im Store
//
// 	Parameter:	-
//	Returnwert:	-
// ==================================================================================

function setATDatasheetPicture()
{
	var strPicPath = ""; // steht im Template!
	var strPic = strPicPath + "empty.gif";
	var strNLPic = strPicPath + "ws_nl.gif";

	var resultList = "DLGDATA.WS.TYPEN_ANSCHLUESSE.RESULT_TABLE.RESULTLISTE_WS_AT_SCHLAUCH";
	var strSelected	= getstring("RESULTLISTE_WS_AT_SCHLAUCH_SELECTED", "DLGDATA.WS.TYPEN_ANSCHLUESSE");
	var strSelSide = getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");

	var resultListI = "";
	var currentSide = "";
	var strTYP_AT = "";
	var strPic = "";
	var strPicSide = "";
	var strPicLeft = "";
	var strPicRight = "";
	var strSchlauchTyp = "";
	var pos = 0;

	if(strSelected	!= "")
	{
		resultListI = resultList+"["+strSelected+"]";
		currentSide	= getstring("SELECTED_SIDE", "DLGDATA.WS.TYPEN_ANSCHLUESSE");

		// ------------------------------------------------
		// Selektiertes Anschlussteil speichern:
		// ------------------------------------------------
		strTYP_AT = getstring("TYP_AT", resultListI);
		strPic = getstring("CAD", resultListI);

		if(strPic != "")
		{
			strPicSide 	= "";
			strPicLeft 	= "";
			strPicRight = "";

			if(strSelSide == "_LINKS")
				strPicSide = "links.";
			else
				strPicSide = "rechts.";

			pos = find(strPic, ".");
			if(pos > -1)
			{
				strPicRight = right(strPic, (strlen(strPic) - pos));
				strPicLeft = left(strPic, pos);
			}

			strPic = strPicLeft + strPicSide + strPicRight;
			strPic = replace(strPic, "dwg", "");
			strSchlauchTyp = getstring("TYP", "DLGDATA.WS.TYPEN_SCHLAEUCHE.AUSLEGUNG");

			if( (strSchlauchTyp == "SD-S-G") || (strSchlauchTyp == "SD-S-B") || (strSchlauchTyp == "SD-S-K") || (strSchlauchTyp == "SD-E-G") || (strSchlauchTyp == "SD-E-B") || (strSchlauchTyp == "SD-E-K"))
				strPic = strPicPath + strPic + "3000.png";
			else
				strPic = strPicPath + strPic + "2000.png";
		}
		else
		{
			// sonst Schlauchbild anzeigen
			strPic = getstring("WS_IMG_SCHLAUCH"+strSelSide, "DLGDATA.WS.TYPEN_SCHLAEUCHE.INPUT");
		}
		storeATDatasheetPicture(strSelSide, strPic);
	}
}

