////////////////////////////////////////////////////////////////////////////////////////
//
//Author:		M.Derschang
//Copyright:	Plan Software GmbH, Saarbrcken
//
//last change:	2004-12-01 md
//				2008-04-15 mb	Sktipt konvertieren
//
////////////////////////////////////////////////////////////////////////////////////////

#include "custom/controllers/classes/CascadeUtilityFunctions.es"

// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function main()
{

	// welchen Auswahlweg haben wir genommen?
	var strAuswahlweg  = getstring("AUSWAHLWEG", "DLGDATA.MS.AUSLEGUNG")
	var strEinsatzfall = getstring("ART_BEWEGUNG_COMBO", "DLGDATA.MS.AUSLEGUNG")

	var strclient = tolower(getstring("CLIENTVERSION_COMMENT_START", "DLGDATA"));
	if(strclient == "true")
		setstring("PWINTCOMMENT_START", "DLGDATA", "false");
	else
		setstring("PWINTCOMMENT_START", "DLGDATA", "true");

	var strATLaengeLinks = getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS");
	var strATLaengeRechts = getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS");
	var dNennLaenge	= gettechval("NENNLAENGE", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE");
	var dbRN = atod(getstring("RN",	"DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH"), -1);
	var dbRMIN = atod(getstring("RMIN", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH"), -1);
	var dVorgabeRadius = gettechval("WAERMEDEHNUNG_R", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE");
	var dInnendurchmesser = atod(getstring("ID_D", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH"), -1);
	var dDruck = gettechval("BETRIEBSDRUCK", "DLGDATA.MS.AUSLEGUNG", "bar", "DRUCK")

	var dRadius = 0;
	var dATLaengeLinks = atod(strATLaengeLinks, -1);
	var dATLaengeRechts = atod(strATLaengeRechts, -1);
	var dSchlauchLaenge = dNennLaenge - (dATLaengeLinks + dATLaengeRechts)

	var dMindestRadius = dbRMIN
	if(strAuswahlweg == "AUSWAHL_EINSATZFALL" && strEinsatzfall != "ID_MONTAGE_LATERAL")
		dMindestRadius = dbRN

	if(strAuswahlweg == "AUSWAHL_EINSATZFALL" && dVorgabeRadius > dMindestRadius)
		dRadius = dVorgabeRadius;
	else
		dRadius	= dMindestRadius;
		// -mw- 04/2007: ist jetzt nicht mehr so, siehe Nennweitennderung: Hier greift immer RMIN

	settechval("BETRIEBSDRUCK_ABSOLUT", "DLGDATA.MS.AUSLEGUNG", (dDruck + 1), "bar", "DRUCK_STOFFDATEN")
	setstring("INNENDURCHMESSER", "DLGDATA.MS.AUSLEGUNG", "" + dInnendurchmesser)
	setstring("SCHLAUCHLAENGE_L", "DLGDATA.MS.AUSLEGUNG", "" + dSchlauchLaenge)
	settechval("BIEGERADIUS", "DLGDATA.MS.AUSLEGUNG", dRadius, "MM","LAENGE")

	// Vorbelegung fuer den Druckverlust (inkl. Einheit):
	settechval("DRUCKVERLUST", "DLGDATA.MS.AUSLEGUNG", 0, "mbar", "DRUCK")
	settechval("ROHRRAUIGKEIT", "DLGDATA.MS.AUSLEGUNG", 0.1, "MM", "LAENGE_GENAU")

	// Nennweiten-Combo fuer die Druckverlustberechnung:
	var strSelectedDN = getstring("DN", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH")
	var strInnendurchmesser = getstring("ID_D", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH")
	var strWellenlaenge = getstring("LW", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH")
	var strSuchtyp = getstring("TYP", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH")

	var strNennweiten, dbDN;
	strNennweiten = "";
	var sql = "Select DN from DATEN_SCHLAUCH Where TYP='" + strSuchtyp + "'";
	var numRet = dbselect("MSDATA_SQL", sql, "MS_DATEN")
	while(dbiseof("MS_DATEN") == 0)
	{
		dbDN = dbgetstring("MS_DATEN", "DN");
		strNennweiten += "ID_" + dbDN + "=DN " + dbDN + "|";
		dbskip("MS_DATEN")
	}
	// minus |
	strNennweiten = left(strNennweiten, strlen(strNennweiten)-1);

	setstring("DRUCKVERLUST_NENNWEITEN", "DLGDATA.MS.AUSLEGUNG", strNennweiten)
	setstring("DRUCKVERLUST_NENNWEITE", "DLGDATA.MS.AUSLEGUNG", "ID_" + strSelectedDN)
	setstring("DRUVERL_ID", "DLGDATA.MS.AUSLEGUNG", strInnendurchmesser)
	setstring("DRUVERL_LW", "DLGDATA.MS.AUSLEGUNG", strWellenlaenge)

	// Bei bestimmten Einsatzfllen gleich den Winkel bernehmen:
	if(strAuswahlweg == "AUSWAHL_EINSATZFALL")
	{
		settechval("UMLENKWINKEL", "DLGDATA.MS.AUSLEGUNG", 0, "grad", "WINKEL")
		if(strEinsatzfall == "ID_HUB_BGN180")
			settechval("UMLENKWINKEL", "DLGDATA.MS.AUSLEGUNG", 180, "grad", "WINKEL")
		else if(strEinsatzfall == "ID_WAERME_BGN090")
			settechval("UMLENKWINKEL", "DLGDATA.MS.AUSLEGUNG", 90, "grad", "WINKEL")
		else if(strEinsatzfall == "ID_WAERME_BGN180")
			settechval("UMLENKWINKEL", "DLGDATA.MS.AUSLEGUNG", 180, "grad", "WINKEL")
	}
}