////////////////////////////////////////////////////////////////////////////////////////
//
//Author:		M.Derschang
//Copyright:	Plan Software GmbH, Saarbrcken
//
//last change:	2004-12-01 md
//				2008-04-15 mb	Sktipt konvertieren
//
////////////////////////////////////////////////////////////////////////////////////////

#include "custom/controllers/classes/CascadeUtilityFunctions.es"

// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function Knickschutzlaenge (strNennweite)
{
		var strLaengeKS="";
		
		if(strNennweite == "10")
			strLaengeKS = "50 mm";
		else if(strNennweite == "12")
			strLaengeKS = "65 mm";
		else if(strNennweite == "16")
			strLaengeKS = "75 mm";	
		else if(strNennweite == "20")
			strLaengeKS = "100 mm";
		else if(strNennweite == "25")
			strLaengeKS = "125 mm";
		else if(strNennweite == "32")
			strLaengeKS = "160 mm";
		else if(strNennweite == "40")
			strLaengeKS = "200 mm";
		else if(strNennweite == "50")
			strLaengeKS = "250 mm";
		else if(strNennweite == "65")
			strLaengeKS = "325 mm";
		else if(strNennweite == "80")
			strLaengeKS = "400 mm";
		else if(strNennweite == "100")
			strLaengeKS = "500 mm";
			
	return (strLaengeKS);
}

function main()
{
	var megaEvent		= getstring("EVENT", "")
    // @@@ Bug im neuen System: INIT wird nicht ausgelst,
    // darum dieses Skript jetzt auch aus dem Weiter des Vor-Dialogs aufgerufen!
    if (megaEvent == "IDC_WEITER_BUT")
        megaEvent = "INIT";
	var currentEvent 	= getstring("EKSUBMITEVENT", "")
	var currentDlg 		= getstring("AKTUELLE_MASKE", "")
    var zubehoerEvent   = getstring("ZUBEHOER_EVENT", "DLGDATA")
		//print "currentEvent: "+currentEvent+"\nmegaEvent: "+megaEvent

    //Beim Zurckkommen aus der Projektliste sollen alle Informationen unverndert bleiben:
    if(zubehoerEvent == "PROJECTLIST_CHANGE")
    {
        setstring("ZUBEHOER_EVENT", "DLGDATA", "")
    }
    else
    {
    	var strPathInput	= "DLGDATA.MS.AUSLEGUNG"
    	var strPathSQL		= "DLGDATA.MS.AUSLEGUNG.SQL"
    	var strPathProduct	= "DLGDATA.MS.AUSLEGUNG.SELPRODUCT"

    	var strListItems			= ""
    	var strAusfuehrung 			= getstring("MS_ZUBEHOER_DIN_2827", strPathInput)
    	var strAusfuehrungErlaubt 	= getstring("GRAT_U_SPALTFREI_CHECK", strPathInput)
    	var strAuswahlweg 			= getstring("AUSWAHLWEG", "DLGDATA.MS.AUSLEGUNG")
		var strDIN2827				= getstring("IDC_MS_AUSLEGUNG_DIN2827_CHECKBOX", "DLGDATA.MS.AUSLEGUNG")

	//----------------------------------------------
	//Informationen ber Schlauch sammeln:
	//----------------------------------------------
    	var strNennweite 			= getstring("SCHLAUCH.DN", strPathProduct)

			//print "strAuswahlweg = "+getstring("AUSWAHLWEG", "DLGDATA.MS.AUSLEGUNG")
			//print strNennweite

	//----------------------------------------------
	//Informationen zur den Anschluteilen sammeln:
	//----------------------------------------------
    	var strATLinks_DIN_2827 = "false"
    	var strATLinks_iA_DIN_2827 = "false"
    	var strATRechts_DIN_2827 = "false"
    	var strATRechts_iA_DIN_2827 = "false"
    	var strATLinks_Typ = getstring("TYP_AT", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS")
    	var strATRechts_Typ = getstring("TYP_AT", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS")
		var strMuster_rechts = getstring("MUSTER", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS")
		var strMuster_links = getstring("MUSTER", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS")
		
		var strATRechts_Werkstoff = getstring("WERKSTOFF", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS")
		var strATLinks_Werkstoff = getstring("WERKSTOFF", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS")
		
		setstring("SHOWTEMPERGUSSPDF", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT","FALSE")
		if(currentEvent=="IDC_WEITER_BUT")
		{
			if(strATRechts_Werkstoff == "Temperguss" || strATLinks_Werkstoff == "Temperguss")
			{
				var strDruck = getstring("P_AUSGABE", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
				var dDruck = parseFloat(strDruck);
				
				if(dDruck > 25.0 && dDruck < 65.0)
					setstring("SHOWTEMPERGUSSPDF", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT",translate("IDC_MS_BESTAETIGUNGSTEXT_TEMPERGUSS"))
			}
		}
		
    	var numBetriebsTemperatur = gettechval("BETRIEBSTEMPERATUR", "DLGDATA.MS.AUSLEGUNG", "C", "TEMPERATUR")
    	/*
		// nicht benutzt
		var numATLinks_TMin = atod(getstring("TMIN", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS"), -1);
    	var numATLinks_TMax = atod(getstring("TMAX", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS"), -1);
    	var numATRechts_TMin = atod(getstring("TMIN", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS"), -1);
    	var numATRechts_TMax = atod(getstring("TMAX", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS"), -1);
		*/

	// Vars
		var breakWhile, rowsCount;
		var strCombo1, strCombo2, strCombo3, strMuster, strText, strTextAusfuehrung, strBild;
		var dbMUSTER, dbDIN_2827, dbiA_DIN_2827;
		var strDIN2827_global;
		var strListItems;

	//-----------------------------------------------------------------------------------
	//ZUBEHOERTAB ANZEIGEN UND FLLEN:
	//-----------------------------------------------------------------------------------
    	if(strATLinks_Typ != "" && strATRechts_Typ != "")
    	{
    		setstring("SHOW_ZUBEHOER", "DLGDATA.MS.AUSLEGUNG", "true")
    		setstring("COMMENT_ZUBEHOER_START", "DLGDATA", "false")

    		if (megaEvent == "INIT")
    		{
    			//-----------------------------------------------------------------------------------
    			//Eintrge fr ComboBox "Ausfhrung" setzen:
    			//-----------------------------------------------------------------------------------
				
				if(strDIN2827 == "false")
				{
					strListItems = "ID_DIN_OHNE=" + translate("IDC_MS_ZUBEHOER_DIN_OHNE")
					setstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG", "ID_DIN_OHNE" )
				}
				else
				{
					var sql = "Select * from SYSTEMATIK_AT WHERE MUSTER='"+strMuster_links+"' ";
					var numRet = dbselect("MSDATA_SQL", sql, "MS_SYS_AT")
					if(numRet == 1)
					{
						dbDIN_2827 = dbgetstring("MS_SYS_AT", "DIN_2827");
						dbiA_DIN_2827 = dbgetstring("MS_SYS_AT", "iA_DIN_2827");
						
						if(dbDIN_2827 == "x")
							strATLinks_DIN_2827	= "true";
						if(dbiA_DIN_2827 == "x")
							strATLinks_iA_DIN_2827	= "true";
					}
					else
					{
						//Fehler!!
						//Darf nur ein Ergebnis herauskommen
					}
					
					sql = "Select * from SYSTEMATIK_AT WHERE MUSTER='"+strMuster_rechts+"' ";
					numRet = dbselect("MSDATA_SQL", sql, "MS_SYS_AT")
					if(numRet == 1)
					{
						dbDIN_2827 = dbgetstring("MS_SYS_AT", "DIN_2827");
						dbiA_DIN_2827 = dbgetstring("MS_SYS_AT", "iA_DIN_2827");
						
						if(dbDIN_2827 == "x")
							strATRechts_DIN_2827	= "true";
						if(dbiA_DIN_2827 == "x")
							strATRechts_iA_DIN_2827	= "true";
					}
					else
					{
						//Fehler!!
						//Darf nur ein Ergebnis herauskommen
					}
					
					
					if(strATRechts_DIN_2827	= "true" && strATLinks_DIN_2827 == "true")
					{
						strDIN2827_global = "true"; // DIN 2827
					}
					else if (strATRechts_DIN_2827 = "false" || strATLinks_DIN_2827 == "false")
					{
						strDIN2827_global = "false"; // in Anlehnung an DIN 2827
					}
					
					
					if(strDIN2827_global == "true")
					{
						strListItems = "ID_DIN_MIT=" + translate("IDC_MS_ZUBEHOER_DIN_MIT")
						setstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG", "ID_DIN_MIT" )
					}
					else
					{
						strListItems = "ID_DIN_IN_ANLEHNUNG=" + translate("IDC_MS_ZUBEHOER_DIN_IN_ANLEHNUNG")
						setstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG", "ID_DIN_IN_ANLEHNUNG" )
					}
				
				}
	
				setstring("MS_ZUBEHOER_DIN_2827_ITEMS", "DLGDATA.MS.AUSLEGUNG", strListItems )
				
				
    		}

		//-----------------------------------------------------------------------------------
		//Aufklappliste 1 fllen:
		//-----------------------------------------------------------------------------------
            strCombo1 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput)
            strCombo2 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput)
            strCombo3 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_3", strPathInput)

            if(megaEvent == "INIT" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_AUSFUEHRUNG")
    		{
    			var strSQLStatement	= "SELECT DISTINCT "
					+ "AUFKLAPP1 AS id, 'MS_ZUBEHOER_'||AUFKLAPP1 AS text "
					+ "FROM MS_ZUBEHOER "
					+ "WHERE "
					+ "abs(DN_VON)<=" +strNennweite + " AND abs(DN_BIS)>=" +strNennweite

    			if(strAuswahlweg == "AUSWAHL_BETRIEBSDATEN" || strAuswahlweg == "AUSWAHL_EINSATZFALL")
    			{
    				strSQLStatement	+= " AND (0+T_VON)<=" + numBetriebsTemperatur
						+ " AND (0+T_BIS)>=" + numBetriebsTemperatur
    			}

                if(strDIN2827 != "false")
                {
					if(getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_MIT" )
                        strSQLStatement	+= " AND DIN2827 ='mit'"
					else if( getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_IN_ANLEHNUNG" )
                        strSQLStatement	+= " AND (DIN2827 = 'mit' OR DIN2827 = 'in Anlehnung')"
                }
				
				//Abfrage, ob Knickschutz berhaupt mglich ist
				//betrifft nur ID_2 und ID_3 (siehe MSZubehoer.db)
				//Flexible Schlaulnge mu grer sein als 4*Knickschutzlnge
				
				var nNL_Knickschutz             = double(gettechval("NENNLAENGE", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE"));
				var nATL_Laenge_Knickschutz     = double(getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS"));
				var nATR_Laenge_Knickschutz     = double(getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS"));
				var FlexibleLaenge_Knickschutz 	= nNL_Knickschutz - (nATL_Laenge_Knickschutz + nATR_Laenge_Knickschutz);
				
				var nLaengeKS_Knickschutz = atod(Knickschutzlaenge(strNennweite));
				
				if(FlexibleLaenge_Knickschutz < (nLaengeKS_Knickschutz*4))
					strSQLStatement	+= " AND AUFKLAPP1 <> 'ID_2' AND AUFKLAPP1 <> 'ID_3'";
				
                strSQLStatement	+= " ORDER BY abs(SEQ)"
					//write("SQLTest1.txt", strSQLStatement)

				breakWhile = "false"

    			if(strCombo1 != "ID_OHNE")
    			{
                    if(dbselect("MSZUBEHOER", strSQLStatement, "RS1") > 0)
                    {
                        while(dbiseof("RS1") == 0 && breakWhile == "false")
                        {
                            if(dbgetstring("RS1", "id") == strCombo1)
							{
                                breakWhile = "true"
								break;
							}
							dbskip("RS1")
                        }
                    }
                }
				//immer mit "ohne" vorbelegen!
    			if(breakWhile == "false")
                    strCombo1 = "ID_OHNE"

    			setstring("MS_SELECT_ZUBEHOER_1", strPathSQL, strSQLStatement)
                setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput, strCombo1)
    		}

		//-----------------------------------------------------------------------------------
		//Aufklappliste 2 fllen:
		//-----------------------------------------------------------------------------------
            if(megaEvent == "INIT" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_SCHUTZ_ISO_1" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_AUSFUEHRUNG")
    		{
                if(strCombo1 == "")
    				strCombo1 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput)

    			var strSQLStatement_2 = "SELECT DISTINCT "
    				+ "AUFKLAPP2 AS id, 'MS_ZUBEHOER_'||AUFKLAPP2 AS text "
    				+ "FROM MS_ZUBEHOER "
    				+ "WHERE "
    				+ "AUFKLAPP1 = '" + strCombo1 + "' AND "
    				+ "abs(DN_VON)<=" + strNennweite + " AND abs(DN_BIS)>=" + strNennweite

    			if(strAuswahlweg == "AUSWAHL_BETRIEBSDATEN" || strAuswahlweg == "AUSWAHL_EINSATZFALL")
    			{
    				strSQLStatement_2 += " AND T_VON<= " + numBetriebsTemperatur
						+ " AND T_BIS>= " + numBetriebsTemperatur
    			}

				if(strDIN2827 != "false")
                {
					if(getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_MIT" )
                        strSQLStatement_2	+= " AND DIN2827 ='mit'"
					else if( getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_IN_ANLEHNUNG" )
                        strSQLStatement_2	+= " AND (DIN2827 = 'mit' OR DIN2827 = 'in Anlehnung')"
                }
                strSQLStatement_2 += " ORDER BY abs(SEQ)"
					//write("SQLTest2.txt", strSQLStatement_2)

    			rowsCount = dbselect("MSZUBEHOER", strSQLStatement_2, "RS2")
    			if(rowsCount == 0)
    			{
    				setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "HIDDEN")
    				setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "HIDDEN")
    				setstring("MS_SELECT_ZUBEHOER_2", strPathSQL, "")
    				setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput, "")
    			}
    			else if(rowsCount > 0)
    			{
    				if(rowsCount == 1 && dbgetstring("RS2", "id") == "")
    				{
    					setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "HIDDEN")
    					setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "HIDDEN")
    					setstring("MS_SELECT_ZUBEHOER_2", strPathSQL, "")
    					setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput, "")
    				}
    				else
    				{
    					if(strCombo2 == "")
							strCombo2 = dbgetstring("RS2", "id")
    					setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "COMBOBOX_NORMAL")
    					setstring("MS_ZUBEHOER_COMBO_2_VISIBLE", strPathInput, "COMBOBOX_NORMAL")
    					setstring("MS_SELECT_ZUBEHOER_2", strPathSQL, strSQLStatement_2)
    					setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput, strCombo2)
    				}
    			}
    		}

		//-----------------------------------------------------------------------------------
		//Aufklappliste 3 fllen:
		//-----------------------------------------------------------------------------------
            if(megaEvent == "INIT" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_SCHUTZ_ISO_1" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_SCHUTZ_ISO_2" ||
				currentEvent == "IDC_COMBO_MS_ZUBEHOER_AUSFUEHRUNG")
    		{
    			if(strCombo1 == "")
    				strCombo1 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput)

    			if(strCombo2 == "")
    				strCombo2 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput)

    			var strSQLStatement_3 = "SELECT DISTINCT "
    				+ "AUFKLAPP3 AS id, 'MS_ZUBEHOER_'||AUFKLAPP3 AS text "
    				+ "FROM MS_ZUBEHOER "
    				+ "WHERE "
    				+ "AUFKLAPP1 = '" + strCombo1 + "' AND "
    				+ "AUFKLAPP2 = '" + strCombo2 + "' AND "
    				+ "AUFKLAPP3 <> '' AND "
    				+ "abs(DN_VON)<=" + strNennweite + " AND "
    				+ "abs(DN_BIS)>=" + strNennweite

    			if(strAuswahlweg == "AUSWAHL_BETRIEBSDATEN" || strAuswahlweg == "AUSWAHL_EINSATZFALL")
    			{
    				strSQLStatement_3 += " AND  T_VON<= " + numBetriebsTemperatur
						+ " AND T_BIS>= " + numBetriebsTemperatur
    			}

                if(strDIN2827 != "false")
                {
					if(getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_MIT" )
                        strSQLStatement_3	+= " AND DIN2827 ='mit'"
					else if( getstring("MS_ZUBEHOER_DIN_2827", "DLGDATA.MS.AUSLEGUNG") == "ID_DIN_IN_ANLEHNUNG" )
                        strSQLStatement_3	+= " AND (DIN2827 = 'mit' OR DIN2827 = 'in Anlehnung')"
                }
    			strSQLStatement_3 += " ORDER BY SEQ"
					//write("SQLTest3.txt", strSQLStatement_3)

    			rowsCount = dbselect("MSZUBEHOER", strSQLStatement_3, "RS3")
    			if(rowsCount == 0)
    			{
    				setstring("MS_ZUBEHOER_COMBO_3_VISIBLE", strPathInput, "HIDDEN")
    				setstring("MS_ZUBEHOER_COMBO_3_VISIBLE", strPathInput, "HIDDEN")
    				setstring("MS_SELECT_ZUBEHOER_3", strPathSQL, "")
    				setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_3", strPathInput, "")
    			}
    			else
    			{
    				strCombo3 = dbgetstring("RS3", "id")
    				setstring("MS_SELECT_ZUBEHOER_3", strPathSQL, strSQLStatement_3)
    				setstring("MS_ZUBEHOER_COMBO_3_VISIBLE", strPathInput, "COMBOBOX_NORMAL")
    				setstring("MS_ZUBEHOER_COMBO_3_VISIBLE", strPathInput, "COMBOBOX_NORMAL")
    				setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_3", strPathInput, strCombo3)
    			}
    		}

		//-----------------------------------------------------------------------------------
		// Editfelder initialisieren:
		//-----------------------------------------------------------------------------------
//    		if(currentEvent == "IDC_COMBO_MS_ZUBEHOER_SCHUTZ_ISO_1") or (megaEvent == "INIT")
//    		{
//			}
			var l1, l2, lx, strLaenge;
			var nGesamtlaenge, nMindestlaenge, nNL, nATL_Laenge, nATR_Laenge;

			if(strCombo1 == "")
				strCombo1 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput)

			if(strCombo1 == "ID_5" || strCombo2 == "ID_5" || strCombo3 == "ID_5")
			{
				setstring("MS_ZUBEHOER_EDIT_VISIBLE", strPathInput, "COMBOBOX_NORMAL")

				l1 = 0 + gettechval("MS_ZUBEHOER_LAENGE_1", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
				l2 = 0 + gettechval("MS_ZUBEHOER_LAENGE_2", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
					//print "l1: "+l1+" / l2:"+l2

				if(l1 > 0 && l2 > 0)
				{
					nGesamtlaenge   = 0
					nMindestlaenge  = getdouble("BERECHNETE_LAENGE", "DLGDATA.MS.AUSLEGUNG");
					nNL             = atod(gettechval("NENNLAENGE", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE"), -1);
					nATL_Laenge     = getdouble("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS");
					nATR_Laenge     = getdouble("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS");

					if(nNL > 0 && nNL > nMindestlaenge)
						nGesamtlaenge = nNL - (nATL_Laenge + nATR_Laenge)
					else
						nGesamtlaenge = nMindestlaenge - (nATL_Laenge + nATR_Laenge)

						//print "nMindestlaenge: "+nMindestlaenge+"\nnNL: "+nNL+"\nnATR_Laenge: "+nATR_Laenge+"\nnATL_Laenge: "+nATL_Laenge
						//print "nGesamtlaenge: "+nGesamtlaenge

					lx = l1 + l2
					if(lx > nGesamtlaenge)
					{
						var errorMSG = translate("ERRORMSG_MS_ZUBEHOER_LAENGEN_1") + " " + nGesamtlaenge + translate("ERRORMSG_MS_ZUBEHOER_LAENGEN_2")
						setstring("ERRORMSG_WRONG_INPUT", "DLGDATA.MS", errorMSG)
						setstring("EKSUBMITEVENT", "", "DONOTHING")
						setstring("EVENT", "", "DONOTHING")
						settechval("MS_ZUBEHOER_LAENGE_1", "DLGDATA.MS.AUSLEGUNG", "0", "MM", "LAENGE")
						settechval("MS_ZUBEHOER_LAENGE_2", "DLGDATA.MS.AUSLEGUNG", "0", "MM", "LAENGE")
							//print("Die Lnge der Enden darf "+nGesamtlaenge+" [mm] nicht berschreiten!" )
					}
				}
			}
			else
			{
				setstring("MS_ZUBEHOER_EDIT_VISIBLE", strPathInput, "HIDDEN")

				l1 = gettechval("MS_ZUBEHOER_LAENGE_1", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
				l2 = gettechval("MS_ZUBEHOER_LAENGE_2", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
				if(l1 > 0 && l2 > 0)
				{
					settechval("MS_ZUBEHOER_LAENGE_1", "DLGDATA.MS.AUSLEGUNG", 0, "MM", "LAENGE")
					settechval("MS_ZUBEHOER_LAENGE_2", "DLGDATA.MS.AUSLEGUNG", 0, "MM", "LAENGE")
				}
			}

    		//-----------------------------------------------------------------------------------
    		//Setzen der Werte fr's Datenblatt:
    		//-----------------------------------------------------------------------------------
    		strText = ""
    		strCombo1 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", strPathInput)
    		strCombo2 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", strPathInput)
    		strCombo3 = getstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_3", strPathInput)
				//print "strCombo1 == "+strCombo1+"\nstrCombo2 == "+strCombo2+"\nstrCombo3 == "+strCombo3

		//-------------------------------------------------
		//Bild whlen fr's Datenblatt:
		//-------------------------------------------------
    		if(strCombo1 != "ID_OHNE")
    		{
    			var strSQLStatementImg	= "SELECT DISTINCT "
    				+ "NAME_BILD "
    				+ "FROM MS_ZUBEHOER "
    				+ "WHERE "
    				+ "AUFKLAPP1 = '" + strCombo1 + "' AND "
    				+ "AUFKLAPP2 = '" + strCombo2 + "' AND "
    				+ "AUFKLAPP3 = '" + strCombo3 + "' "
					+ "ORDER BY abs(SEQ)"

    			rowsCount = dbselect("MSZUBEHOER", strSQLStatementImg, "RSBild")
				strBild = ""
    			if(rowsCount > 0)
    				strBild = "./catalog/client/custom/img/WITcad/MS/" + dbgetstring("RSBild", "NAME_BILD") + ".png"

    			setstring("PRINT_MS_ZUBEHOER_IMG", strPathInput, strBild)
				//print strBild

			//-------------------------------------------------
			//Optionen fr's Datenblatt:
			//-------------------------------------------------
                //Lnge fr den Knickschutz bestimmen und an den Ausdruck anhngen
				var strLaengeKS = "";
				if(strCombo1 == "ID_2" || strCombo1 == "ID_3")
				{
					strLaengeKS = Knickschutzlaenge(strNennweite);
					
					if(strLaengeKS != "")
						strLaengeKS = "("+translate("LAENGE")+" "+strLaengeKS+")";
				}
				
				var strCombo1ID = ""
                var strCombo2ID = ""
                var strCombo3ID = ""

    			if(strCombo1 != "")
    			{
                    strCombo1ID = strCombo1
    				strCombo1 = translate("PRINT_MS_ZUBEHOER_"+strCombo1)+strLaengeKS;
    			}
    			setstring("PRINT_MS_ZUBEHOER_OPTION_1", strPathInput, strCombo1)

    			if(strCombo2 != "")
    			{
                    strCombo2ID = strCombo2
    				strCombo2 = translate("PRINT_MS_ZUBEHOER_"+strCombo2)
    		    }
    			setstring("PRINT_MS_ZUBEHOER_OPTION_2", strPathInput, strCombo2)

    			if(strCombo3 != "")
                {
                    strCombo3ID = strCombo3
    				strCombo3 = translate("PRINT_MS_ZUBEHOER_"+strCombo3)
    		    }
    			setstring("PRINT_MS_ZUBEHOER_OPTION_3", strPathInput, strCombo3)

                if(strCombo1ID == "ID_5" || strCombo2ID == "ID_5" || strCombo3ID == "ID_5")
                {
                    strLaenge = ""
                    l1 = gettechval("MS_ZUBEHOER_LAENGE_1", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
                    l2 = gettechval("MS_ZUBEHOER_LAENGE_2", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE")
                    if(l1 > 0)
                        strLaenge = strLaenge + translate("IDC_LABEL_LAENGE_LINKS") + " " + l1 + "[mm]"
                    if(l2 > 0)
                        strLaenge = strLaenge + " / " + translate("IDC_LABEL_LAENGE_RECHTS") + " " + l2 + "[mm]"
                    setstring("PRINT_MS_ZUBEHOER_LAENGE", strPathInput, strLaenge)
                }
                else
				{
                    setstring("PRINT_MS_ZUBEHOER_LAENGE", strPathInput, "")
				}
    		}
    		else
    		{
    			setstring("PRINT_MS_ZUBEHOER_DIN2827_INFO", strPathInput, "")
    			setstring("PRINT_MS_ZUBEHOER_OPTION_1", strPathInput, "")
    			setstring("PRINT_MS_ZUBEHOER_OPTION_2", strPathInput, "")
    			setstring("PRINT_MS_ZUBEHOER_OPTION_3", strPathInput, "")
    			setstring("PRINT_MS_ZUBEHOER_LAENGE", strPathInput, "")
				setstring("PRINT_MS_ZUBEHOER_IMG", strPathInput, "")
    		}
		
		//Ausgabe Datenblatt fr Strmungszustand anpassen
		var strStroemungszustand = getstring("STROEMUNGSZUSTAND", strPathInput)
		if(strStroemungszustand == "STROEM2")
		{
			var strDruck = getstring("P_AUSGABE", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
			var dDruck = round(parseFloat(strDruck)/4)+" bar";
			
			var strText = translate("STROEM2");
			strText = replace(strText, "PN/4", dDruck+" (PN/4)");
			
			setstring("STROEMUNGSZUSTAND_DATENBLATT", strPathInput, strText);		
		}
		else
		{
			setstring("STROEMUNGSZUSTAND_DATENBLATT", strPathInput, strStroemungszustand);		
		}
		
		//-------------------------------------------------
		//DIN2827-Text fr's Datenblatt:
		//-------------------------------------------------
            strText = getstring("MS_ZUBEHOER_DIN_2827", strPathInput)
            if(strText == "ID_DIN_MIT")
            {
                strText = translate("PRINT_MS_ZUBEHOER_DIN_KENNZEICHNUNG")+"<br>"+translate("MS_ZUBEHOER_DB_TEXT_DIN_2827")
                strTextAusfuehrung = translate("IDC_MS_ZUBEHOER_DIN_MIT")
            }
            else if(strText == "ID_DIN_IN_ANLEHNUNG")
            {
                strText = translate("PRINT_MS_ZUBEHOER_DIN_KENNZEICHNUNG")+"<br>"+translate("MS_ZUBEHOER_DB_TEXT_DIN_2827")
                strTextAusfuehrung = translate("IDC_MS_ZUBEHOER_DIN_IN_ANLEHNUNG")
            }
            else
            {
                strText = ""
                strTextAusfuehrung = ""
            }
            setstring("PRINT_MS_ZUBEHOER_KENNZ_PRUEFDRUCK", strPathInput, strText)
            setstring("PRINT_MS_ZUBEHOER_DIN2827_INFO", strPathInput, strTextAusfuehrung)
    	}
    	else
    	{
    		setstring("COMMENT_ZUBEHOER_START", "DLGDATA", "true")
    		setstring("SHOW_ZUBEHOER", "DLGDATA.MS.AUSLEGUNG", "false")
    		setstring("MS_ZUBEHOER_DIN_2827", 			 	strPathInput, "ID_DIN_OHNE")
    		setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_1", 	strPathInput, "ID_OHNE")
    		setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_2", 	strPathInput, "ID_OHNE")
    		setstring("MS_ZUBEHOER_SCHUTZ_ISOLIERUNG_3", 	strPathInput, "ID_OHNE")
    		setstring("PRINT_MS_ZUBEHOER_IMG", 				strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_KENNZ_PRUEFDRUCK", strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_DIN2827_INFO", 	strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_OPTION_1", 		strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_OPTION_2", 		strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_OPTION_3", 		strPathInput, "")
    		setstring("PRINT_MS_ZUBEHOER_LAENGE", 			strPathInput, "")
    	}
    }
}