////////////////////////////////////////////////////////////////////////////////////////
//
//Author:		M.Derschang
//Copyright:	Plan Software GmbH, Saarbrcken
//
//last change:	2004-12-01 md
//				2008-04-15 mb	Sktipt konvertieren
//
////////////////////////////////////////////////////////////////////////////////////////

#include "custom/controllers/classes/CascadeUtilityFunctions.es"

// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function main()
{

// Nennweiten-Combo fuer die Druckverlustberechnung:
	var strSuchtyp = getstring("TYP", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
	var strMaskeDN = getstring("DRUCKVERLUST_NENNWEITE", "DLGDATA.MS.AUSLEGUNG");
	var dBiegeradius = gettechval("BIEGERADIUS", "DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE");
	var strAuswahlweg  = getstring("AUSWAHLWEG", "DLGDATA.MS.AUSLEGUNG")
	var strEinsatzfall = getstring("ART_BEWEGUNG_COMBO", "DLGDATA.MS.AUSLEGUNG")
	var dVolumenstrom = gettechval("VOLUMENSTROM", "DLGDATA.MS.AUSLEGUNG", "m3/h", "VOLUMENSTROM");

// Vars
	var dbTyp, dbDN, dbID_D, dbLW, dbRN, dbRMIN, dMindestRadius;
	var dInnendurchmesser, dStroemgeschw;

	var sql = "Select ID_D, LW, RN, RMIN from DATEN_SCHLAUCH" +
		" Where TYP='" + strSuchtyp + "' And DN='" + replace(strMaskeDN, "ID_","") + "'";
	var numRet = dbselect("MSDATA_SQL", sql, "MS_DATEN")
// EIN Datensatz ?
	dbID_D = dbLW = "";
	dbRN = dbRMIN = 0
	if(dbiseof("MS_DATEN") == 0)
	{
		dbID_D  = dbgetstring("MS_DATEN", "ID_D");
		dbLW    = dbgetstring("MS_DATEN", "LW");
		dbRN    = dbgetdouble("MS_DATEN", "RN");
		dbRMIN  = dbgetdouble("MS_DATEN", "RMIN");
		//dbskip("MS_DATEN");
	}

	dMindestRadius = dbRMIN;
	if(strAuswahlweg == "AUSWAHL_EINSATZFALL" && strEinsatzfall != "ID_MONTAGE_LATERAL")
		 dMindestRadius = dbRN;

	// -mw- 04/2007: Vorgabe Herr Zachmann vom 26.3.2007:
	// Biegeradius soll immer zurckgesetzt werden
	// if(dBiegeradius < dMindestRadius)
	settechval("BIEGERADIUS", "DLGDATA.MS.AUSLEGUNG", dMindestRadius, "MM",	"LAENGE");
	setstring("INNENDURCHMESSER", "DLGDATA.MS.AUSLEGUNG", dbID_D);
	setstring("DRUVERL_ID", "DLGDATA.MS.AUSLEGUNG", dbID_D);
	setstring("DRUVERL_LW", "DLGDATA.MS.AUSLEGUNG", dbLW);

// Stroemungsgeschwindigkeit neu berechnen:
	dInnendurchmesser = atod(dbID_D, -1);
	dStroemgeschw = dVolumenstrom / (3600 * 3.141592653589793238 * (pow(dInnendurchmesser / 1000, 2) / 4));

	settechval("STROEM_GESCHW", "DLGDATA.MS.AUSLEGUNG", dStroemgeschw, "m/s", "GESCHWINDIGKEIT");

// Druckverlustberechnung neu starten
	result = scriptexec("MS_CALCDRUCKVERLUST");
}