////////////////////////////////////////////////////////////////////////////////////////
//
//Author:		M.Derschang
//Copyright:	Plan Software GmbH, Saarbrcken
//
//last change:	2004-12-01 md
//				2008-04-15 mb	Sktipt konvertieren
//
////////////////////////////////////////////////////////////////////////////////////////


// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function ms_calcstoffdaten(bStartDruckverlustCalculation)
{

	var strMedium = getstring("MEDIUM", "DLGDATA.MS.AUSLEGUNG");
	if(strMedium == "IDC_USERDEFINED")
		return false;

	var dTemperatur	= gettechval("BETRIEBSTEMPERATUR", "DLGDATA.MS.AUSLEGUNG", "C", "TEMPERATUR");
	var dDruck = gettechval("BETRIEBSDRUCK_ABSOLUT", "DLGDATA.MS.AUSLEGUNG", "bar", "DRUCK_STOFFDATEN");
	var dDichte   = 0;
	var dKinVisco = 0;
	var dDynVisco = 0;
	settechval("DYN_VISCO", "DLGDATA.MS.AUSLEGUNG", dDynVisco, "kg/m s", "DYNAMISCHE_VISCOSITAET");
	settechval("KIN_VISCO", "DLGDATA.MS.AUSLEGUNG", dKinVisco, "m2/s", "KINEMATISCHE_VISCOSITAET");
	settechval("FLUIDDICHTE", "DLGDATA.MS.AUSLEGUNG", dDichte, "kg/m^3", "DICHTE");

	var L2 = dDruck;
	var L3 = dTemperatur;

// Vars
	var dGasKonstante;

	if(strMedium == "IDC_WASSER_FLUESSIG")
	{
		if(dTemperatur < 0 || dTemperatur > 300)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		if(dTemperatur < 20)
			dDichte = 0.0000566824 * pow(L3,3)
				- 0.0084871027 * pow(L3,2)
				+ 0.065016062 * L3
				+ 999.8433171789;
		else  if(dTemperatur <= 300)
			dDichte = -0.00000002498429 * pow(L3,4)
				+ 0.00001383863677 * pow(L3,3)
				- 0.00496639386326 * pow(L3,2)
				- 0.04035121016259 * L3
				+ 1000.86060535123;

		if(dTemperatur < 25)
			dKinVisco = 0.00000039898452 * pow(L3,4)
				- 0.00003599323042 * pow(L3,3)
				+ 0.00170996945936 * pow(L3,2)
				- 0.06243727927138 * L3
				+ 1.79177101463467;
		else if(dTemperatur < 100)
			dKinVisco = -0.00000107413333 * pow(L3,3)
				+ 0.00029968 * pow(L3,2)
				- 0.03134466666667 * L3
				+ 1.50580000000003;
		else if(dTemperatur <= 300)
			dKinVisco = 0.00000000015221 * pow(L3,4)
				- 0.00000014940152 * pow(L3,3)
				+ 0.00005676207617 * pow(L3,2)
				- 0.01023732742784 * L3
				+ 0.88424472467951;

		dDynVisco = dDichte * dKinVisco;
	}

	if(strMedium == "IDC_WASSER-GLYKOL")
	{
		if(dTemperatur < -30 || dTemperatur > 100)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dDichte = -0.001 * pow(L3,2) - 0.6223 * L3 + 1056;

		if(dTemperatur < 20)
			dKinVisco = 0.0000465 * pow(L3,4)
				- 0.00196 * pow(L3,3)
				+ 0.03365 * pow(L3,2)
				- 0.821 * L3
				+ 17;
		else if(dTemperatur <=100)
		    dKinVisco = 0.000000286458 * pow(L3,4)
				- 0.000084375 * pow(L3,3)
				+ 0.009510416667 * pow(L3,2)
				- 0.51375 * L3
				+ 12.900000000003;

		dDynVisco = dDichte * dKinVisco;
	}

	if(strMedium == "IDC_WAERMETRAEGEROEL")
	{
		if(dTemperatur < 0 || dTemperatur > 320)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dDichte = -0.6495 * L3 + 878.12;

		if(dTemperatur < 60)
			dKinVisco = 0.00002792 * pow(L3,4)
				- 0.00608958 * pow(L3,3)
				+ 0.49345833 * pow(L3,2)
				- 18.35666667 * L3
				+ 293;
		else if(dTemperatur < 100)
			dKinVisco = 0.00002792 * pow(L3,4)
				- 0.00608958 * pow(L3,3)
				+ 0.49345833 * pow(L3,2)
				- 18.35666667 * L3
				+ 293;
		else if(dTemperatur <= 320)
			dKinVisco = 0.000000004997 * pow(L3,4)
				- 0.000005151026 * pow(L3,3)
				+ 0.002003861848 * pow(L3,2)
				- 0.354660942424 * L3
				+ 25.277926891559;

		dDynVisco = dDichte * dKinVisco;
	}

	if(strMedium == "IDC_LUFT")
	{
		if(dTemperatur < 0 || dTemperatur > 1000)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}
		if(dDruck < 0 || dDruck > 100)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dGasKonstante = 287.22

		dDichte = (L2 * pow(10,5)) / (dGasKonstante * (L3 + 273.15));

		dDynVisco = -0.00000000000724 * pow(L3,4)
			+ 0.0000000222238 * pow(L3,3)
			- 0.00003098266081 * pow(L3,2)
			+ 0.04955266509624 * L3
			+ 17.2589188072309;

		dKinVisco = dDynVisco / dDichte;
	}

	if(strMedium == "IDC_WASSERSTOFF_G")
	{
		if(dTemperatur < -100 || dTemperatur > 1000)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}
		if(dDruck < 0 || dDruck > 100)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dGasKonstante = 4126.00

		dDichte = (L2 * pow(10,5)) / (dGasKonstante * (L3 + 273.15))

		dDynVisco =  -0.00000000000103 * pow(L3,4)
			+ 0.0000000052802 * pow(L3,3)
			- 0.00000986992391 * pow(L3,2)
			+ 0.02126866323345 * L3
			+ 8.34803390784763;

		dKinVisco = dDynVisco / dDichte;
	}

	if(strMedium == "IDC_SAUERSTOFF_G")
	{
		if(dTemperatur < -150 || dTemperatur > 1000)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}
		if(dDruck < 0 || dDruck > 100)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dGasKonstante = 260.00

		dDichte = (L2 * pow(10,5)) / (dGasKonstante * (L3 + 273.15))

		dDynVisco =  -0.00000000001286 * pow(L3,4)
			+ 0.00000003662147 * pow(L3,3)
			- 0.0000441397511 * pow(L3,2)
			+ 0.05885339654738 * L3
			+ 19.2244927388044;

		dKinVisco = dDynVisco / dDichte;
	}

	if(strMedium == "IDC_ERDGAS_H")
	{
		if(dTemperatur < 0 || dTemperatur > 100)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}
		if(dDruck < 1 || dDruck > 10)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		dGasKonstante = 482.00;

		dDichte   = (L2 * pow(10,5)) / (dGasKonstante * (L3 + 273.15));

		dDynVisco = 9.85;

		dKinVisco = dDynVisco / dDichte;
	}

	if(strMedium == "IDC_WASSERDAMPF_GESAETTIGT")
	{
		if(dTemperatur < 0 || dTemperatur > 300)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}
		if(dDruck < 0 || dDruck > 86)
		{
			setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_MEDIENGRENZEN"));
			return false;
		}

		if(dTemperatur < 100)
			dDichte   = 0.000000004344 * pow(L3,4)
				- 0.000000042703 * pow(L3,3)
				+ 0.000017740126 * pow(L3,2)
				+ 0.000238246658 * L3
				+ 0.005060919509;
		else if(dTemperatur < 200)
			dDichte   = 0.000000009044 * pow(L3,4)
				- 0.000002087712 * pow(L3,3)
				+ 0.000368513811 * pow(L3,2)
				- 0.027453405981 * L3
				+ 0.841922890408;
		else if(dTemperatur <= 300)
			dDichte   = 0.000000079977 * pow(L3,4)
				- 0.000065167444 * pow(L3,3)
				+ 0.021501893939 * pow(L3,2)
				- 3.184722591275 * L3
				+ 178.111419346232;

		dDynVisco = 0.000000001041 * pow(L3,4)
			- 0.000000605591 * pow(L3,3)
			+ 0.00012764889 * pow(L3,2)
			+ 0.022771193951 * L3
			+ 9.223608439443;

		dKinVisco = dDynVisco / dDichte;
	}

	settechval("DYN_VISCO", "DLGDATA.MS.AUSLEGUNG", dDynVisco, "kg/m s", "DYNAMISCHE_VISCOSITAET");
	settechval("KIN_VISCO", "DLGDATA.MS.AUSLEGUNG", dKinVisco, "m2/s",   "KINEMATISCHE_VISCOSITAET");
	settechval("FLUIDDICHTE", "DLGDATA.MS.AUSLEGUNG", dDichte, "kg/m^3", "DICHTE");

	// Druckverlustberechnung neu starten
	var bRet = true;
	if (bStartDruckverlustCalculation)
		bRet = ms_calcdruckverlust();	// scriptexec("MS_CALCDRUCKVERLUST");
		
	return bRet;
}