////////////////////////////////////////////////////////////////////////////////////////
//
//Author:		M.Derschang
//Copyright:	Plan Software GmbH, Saarbrcken
//
//last change:	2004-12-01 md
//				2008-04-15 mb	Sktipt konvertieren
//
////////////////////////////////////////////////////////////////////////////////////////


// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function ms_calcdruckverlust()
{

	settechval("DRUCKVERLUST", "DLGDATA.MS.AUSLEGUNG", 0, "mbar", "DRUCK");
	settechval("REYN_ZAHL",    "DLGDATA.MS.AUSLEGUNG", 0, "-", "DIMENSIONSLOS_GROSS");
	settechval("REIB_ZAHL",    "DLGDATA.MS.AUSLEGUNG", 0, "-", "DIMENSIONSLOS");
	settechval("AEQUI_LAENGE", "DLGDATA.MS.AUSLEGUNG", 0, "M", "LAENGE");

	var dDichte			= gettechval("FLUIDDICHTE",		"DLGDATA.MS.AUSLEGUNG", "kg/m^3", "DICHTE");
	var dDynVisco		= gettechval("DYN_VISCO",		"DLGDATA.MS.AUSLEGUNG", "kg/m s", "DYNAMISCHE_VISCOSITAET");
	var dKinVisco		= gettechval("KIN_VISCO",		"DLGDATA.MS.AUSLEGUNG", "m2/s", "KINEMATISCHE_VISCOSITAET");
	var dVolumenstrom	= gettechval("VOLUMENSTROM",	"DLGDATA.MS.AUSLEGUNG", "m3/h", "VOLUMENSTROM");
	var dStroemgeschw	= gettechval("STROEM_GESCHW",	"DLGDATA.MS.AUSLEGUNG", "m/s", "GESCHWINDIGKEIT");


	if(dDynVisco <= 0 && dKinVisco <= 0) {
		ms_calcstoffdaten(false);
		dDichte			= gettechval("FLUIDDICHTE",		"DLGDATA.MS.AUSLEGUNG", "kg/m^3", "DICHTE");
		dDynVisco		= gettechval("DYN_VISCO",		"DLGDATA.MS.AUSLEGUNG", "kg/m s", "DYNAMISCHE_VISCOSITAET");
		dKinVisco		= gettechval("KIN_VISCO",		"DLGDATA.MS.AUSLEGUNG", "m2/s", "KINEMATISCHE_VISCOSITAET");
	}

	if(dDichte <= 0 || (dDynVisco <= 0 && dKinVisco <= 0) || (dStroemgeschw <= 0 && dVolumenstrom <= 0))
		return false;


	var dDruck   		= gettechval("BETRIEBSDRUCK_ABSOLUT","DLGDATA.MS.AUSLEGUNG", "bar", "DRUCK");
	var dTemperatur		= gettechval("BETRIEBSTEMPERATUR",  "DLGDATA.MS.AUSLEGUNG", "C", "TEMPERATUR");
	var dBiegeradius	= gettechval("BIEGERADIUS",			"DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE");
	var dUmlenkwinkel	= gettechval("UMLENKWINKEL",		"DLGDATA.MS.AUSLEGUNG", "grad", "WINKEL");
	var dRauh			= gettechval("ROHRRAUIGKEIT",		"DLGDATA.MS.AUSLEGUNG", "MM", "LAENGE_GENAU");

	// -mw- 2013-12-11: Nennlnge soll editierbar sein ...
	// var dNennLaenge		= gettechval("NENNLAENGE",			"DLGDATA.MS.AUSLEGUNG", "MM","LAENGE");
	var dNennLaenge		= getstring("DRUVERL_NENNLAENGE", "DLGDATA.MS.AUSLEGUNG") - 0;

	//strNennweiteDN = getstring("NENNWEITE", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH")
	var strNennweiteDN	= getstring("DRUCKVERLUST_NENNWEITE", "DLGDATA.MS.AUSLEGUNG");
	strNennweiteDN		= replace(strNennweiteDN, "DN ", "");
	strNennweiteDN		= replace(strNennweiteDN, "ID_", "");
	var dNennweite		= atod(strNennweiteDN, -1);

	var strATLaengeLinks = getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATLINKS");
	var strATLaengeRechts = getstring("l", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.ATRECHTS");
	var dATLaengeLinks = atod(strATLaengeLinks, -1);
	var dATLaengeRechts = atod(strATLaengeRechts, -1);

	// nderung: wir sollen mit der Nennlnge rechnen, nicht mir der Schlauchlnge:
	// dSchlauchLaenge = dNennLaenge - (dATLaengeLinks + dATLaengeRechts)
	var dSchlauchLaenge = dNennLaenge;

	//strInnendurchmesser = getstring("ID_D", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
	//strWellenlaenge = getstring("LW", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
	var strInnendurchmesser = getstring("DRUVERL_ID", "DLGDATA.MS.AUSLEGUNG");
	var dInnendurchmesser = atod(strInnendurchmesser, -1);
	var strWellenlaenge = getstring("DRUVERL_LW", "DLGDATA.MS.AUSLEGUNG");
	var dWellenlaenge = atod(strWellenlaenge, -1);

// Vars
	var dLambda, dLambda1, dRe1, dRe2, dRe3, dFormwiderstand, dRDI;
	var dReynoldszahl, dReibungszahl, dDruckverlust, ZahlE, dTmp1, dTmp2, alpha, dAequi;
	var dKompo1, dKompo2, dKompo3, dKompo4, dKompo5;
	var dFormKoeffA, dFormKoeffB, dFormKoeffC, dFormKoeffD, dFormKoeffE, dFormKoeffF;
	var strSchlauchTyp;

	dLambda1 = 4 * pow( 1 / (4.35 + 4 * log(dInnendurchmesser / dWellenlaenge)), 2);
	dRe1	 = 170 * dInnendurchmesser / (dWellenlaenge * sqrt(0.25 * dLambda1));
	dRe2	 = 1400 * dInnendurchmesser / (dWellenlaenge * sqrt(0.25 * dLambda1));
	dLambda2 = 4 * pow( 1 / (2.28 + 4 * log(dInnendurchmesser / dWellenlaenge)), 2);
	dRe3	 = 11000 * dInnendurchmesser / (dWellenlaenge * sqrt(0.25 * dLambda2));
	//dRe3	 = 11000 * dInnendurchmesser / (dWellenlaenge * sqrt(0.25 * dLambda1));

	// Nachher aus DB (Schlauchdaten?):
	strSchlauchTyp = getstring("TYP", "DLGDATA.MS.AUSLEGUNG.SELPRODUCT.SCHLAUCH");
	strSchlauchTyp = substr(strSchlauchTyp, 1, 5);

	dFormKoeffA = 0;
	dFormKoeffB = 0;
	dFormKoeffC = 0;
	dFormKoeffD = 0;
	dFormKoeffE = 0;
	dFormKoeffF = 0;

	if(strSchlauchTyp == "RS 33")
	{
		dFormKoeffA = 0.0576;
		dFormKoeffB = -0.1186;
		dFormKoeffC = 0.857;
		dFormKoeffD = -0.1381;
		dFormKoeffE = 5.8870;
		dFormKoeffF = -0.1824;
	}
	else if(strSchlauchTyp == "RS 32")
	{
		dFormKoeffA = 0.0362;
		dFormKoeffB = -0.0334;
		dFormKoeffC = 0.5229;
		dFormKoeffD = -0.0422;
		dFormKoeffE = 3.6254;
		dFormKoeffF = -0.1032;
	}
	else if(strSchlauchTyp == "RS 34")
	{
		dFormKoeffA = 0.0850;
		dFormKoeffB = -0.2189;
		dFormKoeffC = 1.2800;
		dFormKoeffD = -0.2374;
		dFormKoeffE = 8.8438;
		dFormKoeffF = -0.2792;
	}
	else if(strSchlauchTyp == "RS 53")
	{
		dFormKoeffA = 0.0695;
		dFormKoeffB = -0.1988;
		dFormKoeffC = 1.0259;
		dFormKoeffD = -0.2081;
		dFormKoeffE = 6.667;
		dFormKoeffF = -0.2177;
	}
	else if(strSchlauchTyp == "RS 43")
	{
		dFormKoeffA = 0.0695;
		dFormKoeffB = -0.1988;
		dFormKoeffC = 1.0259;
		dFormKoeffD = -0.2081;
		dFormKoeffE = 6.667;
		dFormKoeffF = -0.2177;
	}
	else if(strSchlauchTyp == "IX 33")
	{
		dFormKoeffA = 0.0850;
		dFormKoeffB = -0.2189;
		dFormKoeffC = 1.2800;
		dFormKoeffD = -0.2374;
		dFormKoeffE = 8.8438;
		dFormKoeffF = -0.2792;
	}
	else if(strSchlauchTyp == "RS 35")
	{
		dFormKoeffA = 0.0850;
		dFormKoeffB = -0.2189;
		dFormKoeffC = 1.2800;
		dFormKoeffD = -0.2374;
		dFormKoeffE = 8.8438;
		dFormKoeffF = -0.2792;
	}
	else
	{
		setstring("DRUVERL_ALERT_MSG", "DLGDATA.MS.AUSLEGUNG", translate("IDC_ERROR_DRUVERL_FORMWIDERSTAND"));
	}

	dRDI = dBiegeradius / dInnendurchmesser;
	if(dRDI < 2)
		dFormwiderstand = pow(2, 2 - dRDI)
			* dFormKoeffA * pow(dNennweite, dFormKoeffB) * 4
			- dFormKoeffC * pow(dNennweite, dFormKoeffD) * 2
			+  dFormKoeffE * pow(dNennweite, dFormKoeffF);
	else if(dRDI > 10)
		dFormwiderstand = dFormKoeffA
			* pow(dNennweite, dFormKoeffB) * 100
			- dFormKoeffC * pow(dNennweite, dFormKoeffD)* 10
			+ dFormKoeffE * pow(dNennweite, dFormKoeffF);
	else
		dFormwiderstand = dFormKoeffA * pow(dNennweite, dFormKoeffB) * pow(dRDI,2)
			- dFormKoeffC * pow(dNennweite, dFormKoeffD) * dRDI
			+ dFormKoeffE * pow(dNennweite, dFormKoeffF);

	if(dFormwiderstand > 0)
		dFormwiderstand = dFormwiderstand * (dUmlenkwinkel / 180);


// nur wenn nicht vom Anwender spezifiziert:
	if(dStroemgeschw <= 0)
	{
		dStroemgeschw = dVolumenstrom / (3600 * 3.141592653589793238 * (pow(dInnendurchmesser / 1000, 2) / 4));
		settechval("STROEM_GESCHW", "DLGDATA.MS.AUSLEGUNG", dStroemgeschw, "m/s", "GESCHWINDIGKEIT");
	}
	if(dVolumenstrom <= 0)
	{
		dVolumenstrom = dStroemgeschw * (3600 * 3.141592653589793238 * (pow(dInnendurchmesser / 1000, 2) / 4));
		settechval("VOLUMENSTROM", "DLGDATA.MS.AUSLEGUNG", dVolumenstrom, "m3/h", "VOLUMENSTROM");
	}

// nur wenn nicht vom Anwender spezifiziert:
	if(dDynVisco <= 0)
	{
		dDynVisco = dDichte * dKinVisco;
		settechval("DYN_VISCO", "DLGDATA.MS.AUSLEGUNG", dDynVisco, "kg/m s", "DYNAMISCHE_VISCOSITAET");
	}
	if(dKinVisco <= 0)
	{
		dKinVisco = dDynVisco / dDichte;
		settechval("KIN_VISCO", "DLGDATA.MS.AUSLEGUNG", dKinVisco, "m2/s", "KINEMATISCHE_VISCOSITAET");
	}

	dReynoldszahl = dStroemgeschw * dInnendurchmesser / dKinVisco * 1000;
	dReibungszahl = dLambda1;
	if(dReynoldszahl > dRe3)
		dReibungszahl = dLambda2;
	if(dReynoldszahl >= dRe2 && dReynoldszahl <= dRe3)
		dReibungszahl = ((dLambda2 - dLambda1) * (dReynoldszahl - dRe2) / (dRe3 - dRe2)) + dLambda1;

	dDruckverlust = (dReibungszahl * (dSchlauchLaenge / dInnendurchmesser) + dFormwiderstand)
		* (dDichte / 2) * pow(dStroemgeschw, 2)
		/ 100;

		//	print "Innendurchmesser="+dInnendurchmesser+"  Schlauchlaenge="+dSchlauchLaenge+"  Wellenlaenge="+dWellenlaenge
		//	print "RE1="+dRe1+" RE2="+dRe2+" RE3="+dRe3+"    Lambda1="+dLambda1+" Lambda2="+dLambda2
		//	print "Formwiderstand: " + dFormwiderstand + " Druckverlust: " + dDruckverlust

	settechval("DRUCKVERLUST", "DLGDATA.MS.AUSLEGUNG", dDruckverlust, "mbar", "DRUCK");
	settechval("REYN_ZAHL",    "DLGDATA.MS.AUSLEGUNG", dReynoldszahl, "-", "DIMENSIONSLOS_GROSS");
	settechval("REIB_ZAHL",    "DLGDATA.MS.AUSLEGUNG", dReibungszahl, "-", "DIMENSIONSLOS");

// jetzt noch die quivalente Lnge berechnen:
	ZahlE = 2.718281828459;
	dTmp1 = -1 * (0.0033 * dReynoldszahl - 8.75);
	dTmp2 = pow(ZahlE, dTmp1);
	alpha = pow(ZahlE, -1 * dTmp2);
	dKompo1 = (64 / dReynoldszahl) * (1 - alpha);
	dKompo2 = (1 / 3.71) * (dRauh / dInnendurchmesser);
	dKompo3 = 2.7 * pow(log(dReynoldszahl), 1.2) / dReynoldszahl;
	dKompo4 = -2 * log(dKompo2 + dKompo3);
	dKompo5 = alpha * pow(dKompo4, -2);
	dLambda = dKompo1 + dKompo5;

	// dAequi = (dDruckverlust / (1000 * dLambda)) * dInnendurchmesser * 2 / (dDichte * dStroemgeschw * dStroemgeschw)
	// Vorgabe Hr. Seeger 18.5.04: Korrekturwert 1/10 statt 1/1000
	dAequi = 0
	if(dLambda > 0 && dDichte > 0 && dStroemgeschw > 0)
	{
		dAequi = (dDruckverlust / (10 * dLambda))
			* dInnendurchmesser * 2
			/ (dDichte * dStroemgeschw * dStroemgeschw);
	}

	if(dUmlenkwinkel > 0 && dAequi > 0)
	{
		settechval("AEQUI_LAENGE", "DLGDATA.MS.AUSLEGUNG", 0, "M", "LAENGE");
			// print "Aequivalente Laenge kann nicht berechnet werden, da Umlenkwinkel vorgegeben ist."
	}
	else
	{
		settechval("AEQUI_LAENGE", "DLGDATA.MS.AUSLEGUNG", dAequi, "M", "LAENGE");
			//print "Aequivalente Laenge -> Alpha: " + alpha + " Lambda: " + dLambda + " Ergebnis: " + dAequi + " m"
	}

	return true;
}