//#############################################################################
//
// Author:		H.M. Bauer / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################


#include "custom/controllers/classes/CascadeUtilityFunctions.es"


// ======================================================================================
// MAIN ROUTINE
// ======================================================================================

function main()
{
    var Target = "DLGDATA";
    var FPData = "DLGDATA.FP";

    // berflssigen Krempel anderer Auswahlen wegputzen
    delete("MS", Target);

	if (getstring("FP_ASSI_GROUP", FPData) == "IDC_FP_NO_ASSI")
		delete("CA", Target); // --> Da stehen die Daten des Sonderteil-Assis

	var strWiMat = getstring("FREI_NUMMER", FPData);
    var strZeichnungsnr = getstring("ZEICHNUNGSNR", FPData);
	var strMarkierung = getstring("MARKIERUNG", FPData);
	var strZMarkierung = getstring("ZMARKIERUNG", FPData);
    strMarkierung = trimleft(strMarkierung, " ");
    strZMarkierung = trimleft(strZMarkierung, " ");

    var strTyp = "";
    if (strMarkierung != "")
        strTyp = strMarkierung + "<br>";
    strTyp = strTyp + left(getstring("FREI_TYP", FPData), 30) + "...";


	setstring("ORDERCODE", Target, strTyp);    // Fr Projektliste
	setstring("ORDERCODE_PROJECTLIST", Target, strTyp);    // Fr Projektliste
	setstring("ORDERCODE_SHORT", Target, getstring("FREI_TYP", FPData));
	setstring("SHORTTEXT", Target, getstring("FREI_TYP", FPData));          // fr Ausdruck
	setstring("IDENT", Target, strWiMat);

	var dCurrencyFactor = getstring("CURRENCY_FACTOR", "PROJECT.SETTINGS.WUR") - 0;
	if (dCurrencyFactor < 0.01)
		dCurrencyFactor = 1.0;
	var dPreis = atod(getstring("FREI_PREIS", FPData), 2);
	var dPreisEuro = dPreis / dCurrencyFactor;
	setstring("FREI_PREIS_EURO", FPData, dPreisEuro);

	setstring("UNITPRICE", Target, ""+dPreisEuro);
	setstring("FORCEDUNITPRICE", Target, "");
	setstring("EXT_ACCEPT_SET_PRICE",  Target, "");
	setstring("INT_ACCEPT_SET_PRICE",  Target, "");
	setdouble("EXT_ACCEPT_CALC_PRICE", Target, 0);
	setdouble("INT_ACCEPT_CALC_PRICE", Target, 0);

    setdouble("DUNITWEIGHT",	Target, 0);    		// Gesamtgewicht
    setdouble("DUNITPRICE",		Target, dPreisEuro);	// Stckpreis OHNE Prfung, Abnahme
    setdouble("DADDEDPOSPRICE",	Target, "");		// NICHT MEHR RELEVANT Zus. Kosten fr die Position (f. Dokumentation o..)
    setstring("FORCEDPOSPRICE",	Target, "");		// NICHT MEHR RELEVANT Vom VB festgesetzter Positionspreis, als STRING, kann in Projektliste gendert werden
	setstring("PRODUCT_AREA", 	Target, "FP");

	setstring("UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", "DLGDATA.CA.FORMS", strMarkierung);
	setstring("UEBERSICHT_LASTKETTE.IDC_ZEICHNUNGS_NR", "DLGDATA.CA.FORMS", strZeichnungsnr);
	setstring("SUB_TYP", Target, getstring("IDC_RH_TYP_COMBOBOX", FPData));
	
	setstring("EXTRAMARKIERUNG.IDC_EXTRAMARKIERUNG", "DLGDATA.CA.FORMS", strZMarkierung);
	
    // Wichtig: den letzten Screen merken, der zu diesem Weg gefhrt hat:
    setstring("MODIFY_ENTRY_SCREEN", Target, "IDD_FREIE_POSITION")

	// Bei bernahme Auslegung in Projektliste diese ankreuzen; in der Regel will man diese ja auch verwenden
	setstring("SAP_CHECK", Target , "true");

    specialexec("UebernehmeAuswahlInProjektliste");
}
