
//#############################################################################
//
// Author:		T. Freichel / M. Wille
// Copyright:	Plan Software GmbH, Saarbrcken
//
//#############################################################################


#include "base/index.es"
#include "custom/index.es"



// ======================================================================================
// MAIN ROUTINE
// Wird aufgerufen aus C++, ProjectRebuildTexts() - fr jede Position einzeln ... Posdaten stehen dann in DLGDATA bereit
// ======================================================================================

function main()
{
    var tmpCaMainController = new CaController();   // hoffentlich nimmt das nicht zu viel Speicher

    caMainController = tmpCaMainController;  // just  to be sure ...

    var LKMatInfo = tmpCaMainController.topologieKlasse.getLastkettenIdent(tmpCaMainController);
    var oOptions  = tmpCaMainController.presets.getPreisOptions();

    // Preise aktualisieren: Rabatte knnen sich gendert haben ...
    var strTarget 		= "DLGDATA";

    var stkList             = [];
    var gesPreis = 0;
    tmpCaMainController.topologieKlasse.getStueckliste(stkList);
    for (var i = 0; i < stkList.length; i++)
    {
        var einzelPreis	= stkList[i].produkt.getPreis(oOptions);
		if (einzelPreis <= 0)
			einzelPreis	= 0;
		//gesPreis   += (stkList[i].anz * stkList[i].produkt.getPreis(oOptions));  // berechneter oder Vorgabe
		gesPreis   += (stkList[i].anz * einzelPreis);  // berechneter oder Vorgabe
    }
    if (oOptions.ZUSATZLEISTUNG_KOSTEN != 0)
        gesPreis   += oOptions.ZUSATZLEISTUNG_KOSTEN;

    tmpCaMainController.topologieKlasse.gesamtPreis = gesPreis;
   	//if (tmpCaMainController.topologieKlasse.matStatus != "ERROR")
	if (tmpCaMainController.topologieKlasse.preisStatus != "ERROR")
		setdouble("dUnitprice", "TMP", gesPreis);
	else
		setdouble("dUnitprice", "TMP", 0);
    var oPruefungAbnahme = tmpCaMainController.getPruefungAbnahme(atoi(getstring("QTY", strTarget)));
   	setdouble("dintAccCalcPrice", "TMP", oPruefungAbnahme.dKostenDokumentation);    // dKostenPruefungAbnahme -mw- 04/2008 auf Wunsch Geiger 

    // Preise, die auf Projektebene zusammenaddiert werden sollen:
    // Summe in PROJECT.SETTINGS.WI_KENNZPOSPREIS
   	setdouble("dKennzeichnungHaengerPreis", "TMP", oPruefungAbnahme.dKennzeichnungHaengerPreis);
   	setdouble("dKennzeichnungStrebenPreis", "TMP", oPruefungAbnahme.dKennzeichnungStrebenPreis);
   	setdouble("dVormontageZubehoerPreis", "TMP", oPruefungAbnahme.dVormontageZubehoerPreis);
   	setdouble("dPositionierungPreis", "TMP", oPruefungAbnahme.dPositionierungPreis);
   	setdouble("dSummeKennzeichnungPreis", "TMP", oPruefungAbnahme.dKostenKennzeichnung);     // Summe der vorherigen 4

    var bSetTyp = false;
    var strSingleTyp = "";
    if (stkList.length == 1)
    {
        bSetTyp = true;
        strSingleTyp = stkList[0].produkt.m_Ptyp;
    }

    // Texte aktualisieren: Sprache kann sich gendert haben ...
    var strShorttext    = "";   // "Lastkette";
    var strTyp          = "";   // "Lastkette mit " + strHaengerText;
    var oLKinfo          = tmpCaMainController.dataAccess.getLKinfoDaten();

	if(getstring("PRODUCT_AREA_SOURCE", "DLGDATA") == "Typsuche")
		strTyp = "Typsuche<br>";

	// strShorttext = strTyp; --> im AUsdruck soll der Text nicht erscheinen ...

    if (oLKinfo.markierung != "")
        strTyp = strTyp + oLKinfo.markierung + "<br>";

    if (LKMatInfo.aTexte.length > 0)
        strTyp = strTyp + LKMatInfo.aTexte[0];
    if (bSetTyp)
        strTyp = strTyp + "<br>" + strSingleTyp;
    else if (LKMatInfo.aTexte.length > 1)
        strTyp = strTyp + "<br>" + LKMatInfo.aTexte[1];
        
    if (LKMatInfo.aTexte.length > 2)
    {
        for (var i = 0; i < LKMatInfo.aTexte.length; ++i)
        {
            strShorttext = strShorttext + LKMatInfo.aTexte[i];
            if (i < LKMatInfo.aTexte.length - 1)
                strShorttext = strShorttext + "<br>";
        }
    }

	setstring("strSHORTTEXT", "TMP", strShorttext);
	setstring("strORDERCODE", "TMP", strTyp);
    setstring("strMATNR", "TMP", LKMatInfo.matnr);
	
	setstring("STATUS_PREIS", "TMP", caMainController.topologieKlasse.preisStatus);
	setstring("STATUS_MATNR", "TMP", caMainController.topologieKlasse.matStatus);
	

}
