/**
 * @category   update
 * @package    Core
 * @copyright  Copyright (c) 2009-2015 Plan Software GmbH (http://www.plansoft.de)
 */

// building the namespace
if ( typeof( Base ) == "undefined" )
	Base = {};	

/**
 * test if one should do autoupdate on start
 *
 * @return boolean - true: perform update on start
 *                   false: don't perform update on start
 */
Base.isUpdateOnStart = function()
{
	// autoupdate only in CDROM-mode
	if ( getstring( "CATALOG.AUTOSTARTINTERNETSERVER", "ROOT" ) == "true" )
		return( false );
		
	// ... and only if set by the presets
	var strAutomaticUpdate = getstring( "CATALOG.INTERNAL.UPDATEONSTART", "ROOT" );
	return( strAutomaticUpdate == "true" );
}


/**
 * handle the autoupdate on start - functionality
 *
 * @return boolean - true: set next dialog to update dialog
 *                   false: don't change next dialog
 */
Base.handleUpdateOnStart = function()
{
	// autoupdate only in CDROM-mode
	// if ( getstring( "CATALOG.AUTOSTARTINTERNETSERVER", "ROOT" ) == "true" )
	if ( getstring( "CATALOG.AUTOSTARTINTERNETSERVER", "ROOT" ) == "true"
		|| getstring("ONLINEUPDATE","RIGHTS") == "0" )	// nur User ohne zentrale Softwareverteilung updaten online
		
		return( false );
	
	// init autoupdate variables		
	var strPathData = "AUTOUPDATE";
	var strVersion = getstring( "CATVERSION", "DLGDATA" );
	var strURL = getstring( "UPDATEURL", "DLGDATA" );
	
	// parameters for start function
	var nUpdateNewer = 0;
	var strShow = "hidden";
	var strMode = "0";
	var strStartTextID = "";
	
	// alle WITZENMANN-User holen die Updates hier --> wenn wir hier Zugriff haben, holen wir den Krempel hierher
	// das ist leider so nicht gewollt -> wegen der Datenmenge!?
	// ------------------------------------------------------------------------------------------------------------------ //
	/*
	var netShare		= getstring( "CATALOG.SAP.TRANSFERORDNER", "" );
	var netShareExists	= FileName.dirExists(netShare);
	var WISecondTry		= false;
	
	if (netShareExists){
		var TMPGate		= netShare.split("\\");
		var GATE		= toupper(TMPGate[TMPGate.length-1]);
		var sqlstring 	= "SELECT * FROM TRANSFER WHERE GATE = '" + GATE + "' ";
		var dbName		= "CASCADE";
		var dbNameTable = "LogInfo";
		
		if ( dbselect( dbName, sqlstring, dbNameTable ) > 0 ){
				var username	= dbgetstring(dbNameTable, "USER");
				var passwd		= dbgetstring(dbNameTable, "PASS");
		}
		else
			WISecondTry	= true;		// Versuch ber Onlinevariante -> ggf. funktioniert das irgendwann auch fr WI
		
		if (FileName.addNetConnection(netShare, username, passwd) == ""
			&&
			FileName.fileExists("C:\\DATA\\TEMP\\FL_UPD\\FLEXPERTE\\update.ini"))	// TEST
			//FileName.fileExists(getstring(netShare + "\\FL_UPD\\update.ini"))	// Ernstfall
		{
			var UpdateINI	= readfile("C:\\DATA\\TEMP\\FL_UPD\\FLEXPERTE\\update.ini").split("\r\n");	// TEST
			//var UpdateINI	= readfile(netShare + "\\FL_UPD\\update.ini").split("\r\n");	// Ernstfall
			for (var up = 0; up < UpdateINI.length; up++){
				if (rfind(toupper(UpdateINI[up]),"TO=") != (-1))
					setstring("NEWEST_UPDATE_VERSION",	strPathData,	trimright(right(UpdateINI[up], UpdateINI[up].length - 3), " "));
				if (rfind(toupper(UpdateINI[up]),"UPDATE=") != (-1))
					setstring("UPDATE_FILE_NAME",		strPathData,	trimright(right(UpdateINI[up], UpdateINI[up].length - 7), " "));
			}
			setstring("SHOW_POPUP",	strPathData,	"false");
			setstring("WI_NETWORK",	strPathData,	"true");	// zustzlich zur spteren Unterscheidung
			setstring("GATE_USER",	strPathData,	username);
			setstring("GATE_PASS",	strPathData,	passwd);
			FileName.cancelNetConnection(netShare);
		}
		else
			WISecondTry	= true;		// Versuch ber Onlinevariante -> ggf. funktioniert das irgendwann auch fr WI
	}
	// ------------------------------------------------------------------------------------------------------------------ //
	*/
	
	// alle anderen holen die Updates hier
	// get data for update from webserver
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
	//if (!netShareExists || WISecondTry){		
		var nRes = setupdatedatatostore( strURL, "FLEXPERTE", strVersion, "DE", strPathData );
	//	setstring("WI_NETWORK",			strPathData,	"false");	// zustzlich zur spteren Unterscheidung
	//}
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
	
	var strNewestUpdateVersion = getstring( "NEWEST_UPDATE_VERSION", strPathData );
	
	// handle events
	if ( strNewestUpdateVersion == "" )
	{
		strStartTextID = "START_MESSAGE_NO_VERSION";
		strMode = "1";
	}
	else 
	{
		var bCompared = true;
		var nPos = find( strNewestUpdateVersion, "." );
		var nPos2 = find( strVersion, "." );
		// version format x.y.zzz(z) - extract x, y, z 
		if ( ( nPos > -1 ) && ( nPos2 > -1 ) )
		{
			// extract primary version and compare
			var x1 = left( strNewestUpdateVersion, nPos - 1 ) - 0;
			var x2 = left( strVersion, nPos2 - 1 ) - 0;
			if ( x1 == x2 )
			{
				var nPos21 = findex( strNewestUpdateVersion, ".", nPos + 1, 1 );
				var nPos22 = findex( strVersion, ".", nPos2 + 1, 1 );
				if ( ( nPos21 > -1 ) && ( nPos22 > -1 ) )
				{
					// extract middle version and compare
					var y1 = mid( strNewestUpdateVersion, nPos + 1, nPos21 - nPos - 1 ) - 0;
					var y2 = mid( strVersion, nPos2 + 1, nPos22 - nPos2 - 1 ) - 0;
					if ( y1 == y2 )
					{
						var z1 = right( strNewestUpdateVersion, strlen( strNewestUpdateVersion ) - nPos21 ) - 0;
						var z2 = right( strVersion, strlen( strVersion ) - nPos22 ) - 0;
						if ( z1 <= z2 )
							nRes = -1;
						else nRes = 1;
					}
					else if ( y1 < y2 )
						nRes = -1;
					else nRes = 1;						
				}
				else bCompared = false;		// strange unknown format -> use standard string compare
			}				
			else if ( x1 < x2 )
				nRes = -1;
			else nRes = 1;
		}
		else bCompared = false;		// strange unknown format -> use standard string compare
		if ( !bCompared )
			nRes = strcmp( strNewestUpdateVersion, strVersion );
			
		// set message texts
		if ( nRes <= 0 )
		{
			strStartTextID = "START_MESSAGE_NEWEST_VERSION";
			strMode = "2";
		}
		else 
		{
			strStartTextID = "START_MESSAGE_OLD_VERSION";
			strMode = "3";
			nUpdateNewer = 1;
		}
	}
	
	// set start function and text
	setint( "UPDATE_NEWER", strPathData, nUpdateNewer );
	if ( !Base.isUpdateOnStart() )
	{
		// no autoupdates if we are in CD-mode or the user has disabled autoupdates
		strShow = "hidden";
		strMode = 0;
		nUpdateNewer = 0;
		strStartTextID = "";
	}
	else strShow = "visible"

	// -og- 110927 temporarily disabled for the next test version until the update feature is available again
	// -og- 141124 enabled again (next version - HAH, see BT #15386)
	//var strStartFunction = "modifyStartText( 'IDC_START_MESSAGE_TEXT', 'hidden', '0' );";
	var strStartFunction = "modifyStartText( 'IDC_START_MESSAGE_TEXT', '" + strShow + "', '" + strMode + "' );";
	setstring( "ON_START", strPathData, strStartFunction );
	setstring( "START_MESSAGE_ID", strPathData, strStartTextID );
	setstring( "START_MESSAGE_TEXT", strPathData, translate( strStartTextID ) );
	
	return( nUpdateNewer > 0 );
}


