

///////////////////////////////////////////////////////////
// SAP_RFC - Klasse

var descZKP_SAK = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "USREX", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "KUNNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "PRONR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "AUSNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "LAISO", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  }
];


var descZKP_SAP = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MATNR", type: "CHAR", width:18, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "KDMAT", type: "CHAR", width:35, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "KPTYP", type: "CHAR", width:40, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "VRKME", type: "CHAR", width: 3, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MENGE", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "GEWEI", type: "CHAR", width: 3, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "BRGEW", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "WAERS", type: "CHAR", width: 5, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "PREIS", type: "CHAR", width:14, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "VERPA", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "FRACH", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ABNAE", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ABNAI", type: "CHAR", width: 8, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  }
];


var descZKP_SVP = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ATNAM", type: "CHAR", width:30, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ATLFD", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ATWRT", type: "CHAR", width:30, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "NEINS", type: "UNIT", width: 3, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  }
];


var descZKP_SVT = [
	{ name: "SAART", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "HERKU", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ANGNR", type: "CHAR", width:10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "POSNR", type: "CHAR", width: 6, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "TXTID", type: "CHAR", width: 4, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "LAISO", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ZEILE", type: "CHAR", width: 2, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "TEXT1", type: "UNIT", width:70, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  }
];


var descBAPIRET2 = [
	{ name: "TYPE", 		type: "CHAR", width:  1, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ID", 			type: "CHAR", width: 20, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "NUMBER", 		type: "NUMC", width:  3, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MESSAGE", 		type: "CHAR", width:220, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "LOG_NO", 		type: "CHAR", width: 20, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "LOG_MSG_NO", 	type: "NUMC", width:  6, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MESSAGE_V1", 	type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MESSAGE_V2", 	type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MESSAGE_V3", 	type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "MESSAGE_V4", 	type: "CHAR", width: 50, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "PARAMETER", 	type: "CHAR", width: 32, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "ROW", 			type: "INT4", width: 10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "FIELD", 		type: "CHAR", width: 30, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  },
	{ name: "SYSTEM", 		type: "CHAR", width: 10, dez: 0, align: '', fillchar: '', formatstr:'%s', defval: ''  }
];




///////////////////////////////////////////////////////////
// SAP_RFC - Klasse

class SAP_RFC
{

	SAP_RFC(plugIn, exportClass)
	{
		this.rfcPlugin = new saprfc_plugin(plugIn, exportClass);
	}
	
	
	function getPlugin() {
		return this.rfcPlugin;
	}


	// SAP Tabelle -> Script Tabelle
	function tableReader(filePath, tabFormat)
	{
		var resultTable = new Array;
		var nCols = tabFormat.length;
		
		var f = new FileStream(filePath, "rt");
		
		while( f.ok() )
		{
			var rowData = new Object;
			var row = f.readLine();
			var width, val, pos=0;
			
			for(var i=0 ; i<nCols ; i++)
			{
				width = tabFormat[i].width;
				val = row.substring(pos, pos + width);
				
				rowData[tabFormat[i].name] = val;
				pos += width;
			}
			
			resultTable.push(rowData);
			rowData = null;
		}
		
		return resultTable;
	}



	// Script Tabelle -> SAP Tabelle
	function tableWriter(filePath, tabFormat, inTable)
	{
		var nCols = tabFormat.length;
		var nLines = inTable.length;
			
		var f = new FileStream(filePath, "wt");
		
		for(var n=0 ; n<nLines ; n++)
		{
			var rowData = inTable[n];
			var width, fmt, fillc, val;
			var row="";

			for(var i=0 ; i<nCols ; i++)
			{
				width = tabFormat[i].width;
				fmt = tabFormat[i].formatstr || '%s';
				fillc = tabFormat[i].fillchar || ' ';
				
				val = rowData[tabFormat[i].name];
				val = formatstring(val, fmt);
				
				while(val.length < width)
					val += fillc;
					
				val = val.substring(0, width-1);
				row+= val;
			}
			
			f.writeLine(row);
		}
		
		f.close();
	}
	
	function GetTableWidth(tabFormat)
	{
		var tabWidth = 0;
		var nCols = tabFormat.length;
		
		for(var i=0 ; i<nCols ; i++) {
			tabWidth+= parseInt(tabFormat[i].width);
		}
		return tabWidth;
	}
}



main()
{
	// Test's
	//var dataDir = "plugin\\sap\\";
	var dataDir = "D:/proj/witzenmann/plugins/eksaprfc/testsystem/";


	// SAP-RFC Instanz erzeugen
	var rfc = new SAP_RFC(dataDir+"eksaprfc_plugin.dll", "eksaprfc_connect");


	var tabVT = rfc.tableReader(dataDir + "ZKP_VT_02.txt", descZKP_SVT);

	// Script Tabelle -> JSON Notation
	writefile(dataDir + "ZKP_VT_02.json.dump", tabVT.toJSON(), "wt");

	rfc.tableWriter(dataDir + "ZKP_VT_02.txt.dump", descZKP_SVT, tabVT);


	// SAP - Test's
	var plugin = rfc.getPlugin();	// PlugIn Interface
	var tabErr = null;				// Error Table
	var rv;							// result value

	rv = plugin.open("client=100 user=plansoft passwd=plansoft lang=de ashost=aswi01.wi.witzenmann.com sysnr=01");

	rv = plugin.initFunctionCall("Z_KP_SD_RFC");

	rv = plugin.addImportParam("EF_ERROR", " ", 1);
	rv = plugin.addExportTableFile("IT_AK", -1, dataDir + "ZKP_AK_02.txt");
	rv = plugin.addExportTableFile("IT_AP", -1, dataDir + "ZKP_AP_02.txt");
	rv = plugin.addExportTableFile("IT_VP", -1, dataDir + "ZKP_VP_02.txt");
	rv = plugin.addExportTableFile("IT_VT", -1, dataDir + "ZKP_VT_02.txt");
	
	var tabWidth = rfc.GetTableWidth(descBAPIRET2);
	rv = plugin.addImportTableFile("ET_RET", tabWidth, dataDir +  "ET_RET.txt");

	rv = plugin.getLastErrorTxt();
	if(rv == "") {
		rv = plugin.execFunctionCall();
		
		rv = plugin.getImportParam("EF_ERROR");
		if(rv == 'X') {
			// Get Error Table
			tabErr = rfc.tableReader(dataDir +  "ET_RET.txt", descBAPIRET2);
		}
	}

	rfc.cleanUp();	
	plugin.close();
	plugin = null;
}