Cascade.panel.uebersicht_lastkette = function() {
	var form;
	var store, grid;
	var wndExtramarkierung;
    var wndLageplan;
    var wndSonderteil;
    var wndAssistent;
	var formAssistent;

	// Also es msste in der Selektionsroutine
	// geprft werden ob es sich um ein Sonderteil handelt
	// Wenn das so ist, werden bearbeiten und lschen eingeschalten
	// Neu sollte immer on sein
	
	var initSonderteil = function(mode) {
		// Insert Panel Function without History Entry
		var sm = grid.getSelectionModel();
		var id;
		
		if ( sm && mode == "edit") {
			var rec = sm.getSelected();
			var isSonderteil = false;
			
			if ( rec ) { 
				isSonderteil = rec.get('sonderteil');
			}
			
			if ( !rec || !isSonderteil ) {
				//
				Ext.Msg.alert('$BITTE_SONDERTEIL_MARKIEREN$');
				return;
			}
			
			id = rec.get('id');
		}
		
		var panel 		= Ext.getCmp('center-panel');
		var layout 		= panel.layout;
		var formPanel 	= layout.activeItem;
							
		var idx 		= panel.items.indexOfKey( formPanel.id );
		var nextIdx 	= panel.items.indexOfKey( 'sonderteil-formpanel' );
		idx = ( nextIdx == -1 ) ? idx++ : nextIdx;

        Cascade.panel.sonderteil.setMode({
			mode: mode,
			id: id 
		});
		
		Cascade.panel.sonderteil.init(idx);
		layout.setActiveItem( idx );
	};
	
	var deleteSonderteil = function() {
		var sm = grid.getSelectionModel();
		
        var id = -1;
        var indexSonderteil;
		if ( sm ) {
			var rec = sm.getSelected();
			indexSonderteil = -1;
			
			if ( rec ) { 
				indexSonderteil = rec.get('sonderteil');
			}
			
			if ( !rec || (indexSonderteil <= 0) ) {
				Ext.Msg.alert('$BITTE_SONDERTEIL_MARKIEREN$');
				return;
			}
			
			id = rec.get('id');
		}
		
        /* entfernt Teil im Datastore ...
		var ds = grid.getStore();
		ds.remove(rec);
		ds.commitChanges();
        */
		
		// Cascade.panel.uebersicht_lastkette.mySubmitForm();
        
        Ext.Ajax.request({ 
            url: 'uebersicht_lastkette/delete-stklist-item',
            params : { 
                index: indexSonderteil
            }, 
            success: function() { grid.getStore().load(); }
        });
	};
	
	var showExtramarkierung = function() {
		if ( !wndExtramarkierung )
		{
			wndExtramarkierung = new Ext.Window({
				id			:	'extramarkierung-window',
				layout		:	'fit',
				width		:	750,
                height		:	400,
                closeAction	:	'hide',
                plain		:	true,
                title		:	'$EXTRAMARKIERUNG$',
				modal		:	true,
				
				items: [
					
					new Ext.FormPanel(
					{
					
						id				:	'extramarkierung-formpanel',
                        layout			:	'form',
						frame			:	true,
                        plain			:	true,
                        
						layoutConfig	:	{
							labelSeparator : ''
							},
						
						items: [{
								xtype			:	'textarea',
								id				:	'IDC_EXTRAMARKIERUNG',
								fieldLabel		:	'',
								autoScroll		:	true,
								width			:	510,
								height			:	310
						}]
					
					})
					
				],
				
				buttons: [{
					id			:	'extramarkierung-uebernehmen',
					disabled	:	false,
                    text		:	'$UEBERNEHMEN$',
						handler: function() {
							var strMark	= Ext.getCmp('extramarkierung-formpanel').getForm().findField('IDC_EXTRAMARKIERUNG').getValue();
							Ext.getCmp('extramarkierung-formpanel').getForm().load({
															url: 'extramarkierung/set-values',
															params: {Extramarkierung : strMark}
															});
							wndExtramarkierung.hide();
						}
					},
					{
                    text		:	'$ABBRECHEN$',
						handler: function(){
							wndExtramarkierung.hide();
						}
				}]
			});
		}
		Ext.getCmp('extramarkierung-formpanel').getForm().load({ url: 'extramarkierung/get-values'});
        wndExtramarkierung.show(this);
	};

	var showLageplan = function() {
		if( !wndLageplan )
		{
            wndLageplan = new Ext.Window({
				id: 'lageplan-window',
                layout:'fit',
                width:500,
                height:300,
                closeAction: 'hide',
                plain: true,
                title: '$LAGEPLAN$',
				modal: true,

				items: [
                    new Ext.FormPanel(
                   {
                        id: 'lageplan-formpanel',
                        layout: 'form',
                        frame: true,
                        plain: true,
                        layoutConfig: {
                            labelSeparator: ''
                        },
						
                        url: 'lageplan/set-values',
                        baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.LAGEPLAN' },
                        listeners: {
							'actioncomplete': setLageplanImage
						},
						
						items:
                        [
                            {
                                html: '<img id="lageplan-image" src_="catalog/client/custom/img/uela.PNG" />',
                                style: 'position: absolute; left: 50px; top: 50px;'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_A',
                                value: '',
                                style: 'position: absolute; left: 10px; top: 50px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_B',
                                value: '',
                                style: 'position: absolute; left: 10px; top: 130px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_C',
                                value: '',
                                style: 'position: absolute; left: 60px; top: 10px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_D',
                                value: '',
                                style: 'position: absolute; left: 150px; top: 1px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_X',
                                value: '',
                                style: 'position: absolute; left: 80px; top: 40px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_Y',
                                value: '',
                                style: 'position: absolute; left: 160px; top: 20px; width: 50px'
                            },
                            {
                                xtype: 'textfield',
                                name:  'LAGEPLAN_Z',
                                value: '',
                                style: 'position: absolute; left: 170px; top: 60px; width: 50px'
                            }
                        ]
                    })
                ],

                buttons: [{

					id: 'lageplan-uebernehmen',
					disabled: false,
                    text:'$UEBERNEHMEN$',
                    handler: function() {
						Ext.getCmp('lageplan-formpanel').getForm().submit();
						wndLageplan.hide();
					}
                },{
                    text: '$ABBRECHEN$',
                    handler: function(){
                        wndLageplan.hide();
                    }
                }]
            });
        }

		Ext.getCmp('lageplan-formpanel').getForm().load({ url: 'lageplan/get-values'});
        wndLageplan.show(this);
	};

	var setLageplanImage = function(form, action) {
		if ( action.type == "load" )
			Ext.getDom('lageplan-image').src = action.result.img;
	};

	return {
		init: function(idx) {
			if ( !form ) {
				grid = new Ext.grid.EditorGridPanel({
					store: new Ext.data.Store({
						proxy: new Ext.data.HttpProxy({
							url: 'uebersicht_lastkette/get_stueckliste'
						})
						,reader: new Ext.data.JsonReader({
							root: 'rows',
							//totalProperty: 'totalCount',
							id: 'id'
						},[
							{name: 'id'},
							{name: 'text'},
							{name: 'stck'},
							{name: 'gewicht'},
							{name: 'preis'},
							{name: 'preis_vorgabe'},
							{name: 'werkstoff'},
							{name: 'werkstoff_sonder'},
							{name: 'oberflaechenschutz'},
							{name: 'oberflaechenschutz_data'},
							// {name: 'blockierung'},
							// {name: 'gewindeanschluss'},
							// {name: 'gewindeanschluss_data'},
                            {name: 'matnr'},
							{name: 'bemerkungen'},
							{name: 'sonderteil'}						])
						/*,autoLoad: true*/
					}),

					columns: [
						// Position
						{
							header: 'Pos',
							width: 25,
							sortable: false,
							locked: true,
							dataIndex: 'id'
						},{
						// Bezeichnung
							header: '$BEZEICHNUNG$',
							width: 140,
							sortable: false,
							dataIndex: 'text'
						},{
						// Stckzahl
							header: '$IDS_STUECK$',
							width: 30,
							sortable: false,
							dataIndex: 'stck'
						},{
						// Gewicht
							header: '$GEWICHT$',
							width: 50,
							sortable: false,
                            align: 'right',
							dataIndex: 'gewicht'
						},{
						// Preis
						//	header: '$PREIS$',
							header: '$*.TMP.HEADER.TCH_PREIS$',
							width: 50,
							sortable: false,
                            align: 'right',
							dataIndex: 'preis'
						},/*{
						// Vorgabe
							header: '$VORGABE$',
							width: 50,
							dataIndex: 'preis_vorgabe',
							editor: new Ext.form.NumberField( {
								allowNegative: false
							} )
						},*/{
						// Werkstoff
							header: '$WERKSTOFF$',
							width: 70,
							sortable: false,
							dataIndex: 'werkstoff'/* ,
							editor: new Ext.form.TextField( {
							})*/
						}/*
						,{
						// Sonder
							header: '$SONDER$',
							//width: 20,
							dataIndex: 'werkstoff_sonder',
							editor: new Ext.form.Checkbox( {} )
						}*/,{
						// Oberflchenschutz
							header: '$OBERFLAECHENSCHUTZ$',
							width: 130,
							sortable: false,
							dataIndex: 'oberflaechenschutz',
							editor: new Ext.form.ComboBox({
								typeAhead: true,
								triggerAction: 'all',
								mode: 'local',
								displayField:'text',
								store: new Ext.data.SimpleStore({
									fields: ['value', 'text']
								}),
								lazyRender:true,
                                editable: false,
								listClass: 'x-combo-list-small'
							})

						},/*{
						// Blockierung
							header: '$BLOCKIERUNG$',
							width: 20,
							dataIndex: 'blockierung'
						},{
						// Gewindeanschluss
							header: '$GEWINDEANSCHLUSS$',
							width: 40,
							dataIndex: 'gewindeanschluss',
							editor: new Ext.form.ComboBox({
								typeAhead: true,
								triggerAction: 'all',
								mode: 'local',
								displayField:'text',
								store: new Ext.data.SimpleStore({
									fields: ['value','text']
								}),
								lazyRender:true,
								listClass: 'x-combo-list-small'
							})
						},*/{
						// Bemerkungen
							header: '$BEMERKUNGEN$',
							width: 100,
							sortable: false,
							dataIndex: 'bemerkungen'/*,
							editor: new Ext.form.TextField( {
							})*/
						},{
						// Bemerkungen
							header: '$ID_BESTELL_NR$',
							width: 70,
							sortable: false,
							dataIndex: 'matnr'/*,
							editor: new Ext.form.TextField( {
							})*/
						}
					],
					/*
					viewConfig: {
						forceFit: true
					},
					*/
					sm: new Ext.grid.RowSelectionModel({singleSelect:true}),

					bbar: [
							new Ext.Toolbar.TextItem('$SONDERTEIL$: '),
						{
							id: 'sonderteil-new',
							text: '$NEW$',
							icon: 'catalog/client/custom/img/icons/table_row_insert.png',
							cls: 'x-btn-text-icon',
							tooltip: '<b>$NEW$</b>',
							handler: initSonderteil.createDelegate(this, ['insert']),
							disabled: false
						},{
							id: 'sonderteil-edit',
							text: '$EDIT$',
							icon: 'catalog/client/custom/img/icons/table_edit.png',
							cls: 'x-btn-text-icon',
							tooltip: '<b>$EDIT$</b>',
							handler: initSonderteil.createDelegate(this, ['edit']),
							disabled: false
						},{
							id: 'sonderteil-delete',
							text: '$DELETE$',
							icon: 'catalog/client/custom/img/icons/table_row_delete.png',
							cls: 'x-btn-text-icon',
							tooltip: '<b>$DELETE$</b>',
							handler: deleteSonderteil.createDelegate(this),
							disabled: false
						},'->',
						
						{
							id: 'extramarkierung',
							text: '$EXTRAMARKIERUNG$',
							icon: 'catalog/client/custom/img/icons/page_white_text.png',
							cls: 'x-btn-text-icon',
							//tooltip: '$LAGEPLAN$',
							handler: showExtramarkierung.createDelegate(this)
						},
						
						{
							id: 'lageplan',
							text: '$LAGEPLAN$',
							icon: 'catalog/client/custom/img/icons/map.png',
							cls: 'x-btn-text-icon',
							tooltip: '$LAGEPLAN$',
							handler: showLageplan.createDelegate(this)
						},
						{
							id: 'stueckliste-reload',
							text: '$AKTUALISIEREN$',
							icon: 'catalog/client/custom/img/icons/table_refresh.png',
							cls: 'x-btn-text-icon',
							tooltip: '<b>$AKTUALISIEREN$</b>',
							handler: function() {
								form.getForm().submit();
							}
						}
					],

					width: 680,
					//autoWidth: true,
					height: 200,
					frame:true,
					title:'$STUECKLISTE$',
					iconCls:'icon-grid',
					clicksToEdit: 1,

					listeners: {
						'beforeedit' : function(e) {
							var cellEditor = e.grid.getColumnModel().getCellEditor(e.column,e.row);

							if ( cellEditor.field.isXType('combo') ) {
								var data = e.record.get(e.field + '_data');
								cellEditor.field.store.loadData(data);
							}
						}
					}
				});

				form = new Ext.FormPanel( {
					url:'uebersicht-lastkette/set-values',
					frame: true,
					//labelAlign: 'top',
					title: '$UEBERSICHT_LASTKETTE$',
					id: 'uebersicht_lastkette',
					bodyStyle:'padding:5px 5px 0',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.UEBERSICHT_LASTKETTE' },
					listeners: {
						/*'actioncomplete': Cascade.app.getNextPanel,*/
						'actioncomplete': function() {
							grid.getStore().load();
						},
						'beforeaction': this.onBeforeAction
					},
					//width: 700,

					autoScroll: true,

					items: [{
						// Obere Zeile
						layout: 'column',
						items: [
						// Links Eingabefelder
						{
							layout: 'form',
							width: 340,

							items: [
							{
								xtype:'textfield',
								id: 'IDC_ANLAGEN_POS_NR',
								fieldLabel: '$ARTIKELBEZ$',     // vorher: ANLAGEN_POS_NR
								width: 190,
								labelSeparator: ''
							},{
								xtype: 'textfield',
								id: 'IDC_ZEICHNUNGS_NR',
								fieldLabel: '$ZEICHNUNGS_NR$',
								width: 190,
								labelSeparator: ''
							}]
						},
						// Rechts Bild mit Eingabefeldern
						{
							layout: 'form',
							width: 340,
							items: [{
								xtype: 'textfield',
								id: 'IDC_BEMERKUNGEN',
								//fieldLabel: '$BEMERKUNGEN$ / $SONDERAUSFUEHRUNG$',
								fieldLabel: '$BEMERKUNGEN$',
								width: 190,
								labelSeparator: ''
							},{
								xtype: 'textfield',
								id: 'IDC_ANFRAGEPOS',
								//fieldLabel: '$ANFRAGEPOS$',
								fieldLabel: '$IDC_ANFRAGE_LABEL$ $WS_PRINT_POS$',
								width: 190,
								labelSeparator: ''
							},{
								xtype: 'hidden',
								id: "IDC_STUECKLISTE"
							}]
						}]
					},{
						// Untere Zeile
						layout: 'form',
						width: 690,
						items: [grid]
					}]
				});

				//grid.getStore().load();
				var cp = Ext.getCmp('center-panel');

				cp.insert(idx,form);
				cp.doLayout();
			}

			grid.getStore().load();

			form.getForm().reset();
			form.load(
			{
				url: 'uebersicht_lastkette/get-values'
			} );
			Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="catalog/client/custom/img/WITgifs/RH/blank.png" /></center>' );
		},

        mySubmitForm : function()
        {
            form.getForm().submit();
        },

		onEingabeartStklCheck : function(radio, checked)
		{
			var f = Ext.getCmp('sonderteil-formpanel').getForm();
            var but = Ext.getCmp('IDC_START_ASSISTENT');
			if((radio.id=='IDC_FREIE_EINGABE' && checked) ||
				(radio.id=='IDC_AUSWAHLASSISTENT' && !checked))
			{
				f.findField('IDC_EINBAUMASS').enable();
				f.findField('IDC_ZEICHNR_BEMERKUNG').enable();
				f.findField('IDC_WI_MATNR').enable();
				f.findField('IDC_STUECKZAHL').enable();
				f.findField('IDC_GEWICHT').enable();
				f.findField('IDC_PREIS').enable();
				f.findField('IDC_WERKSTOFF').enable();

				but.disable();
			}
			if((radio.id=='IDC_AUSWAHLASSISTENT' && checked) ||
				(radio.id=='IDC_FREIE_EINGABE' && !checked))
			{
				but.enable();

				f.findField('IDC_EINBAUMASS').disable();
				f.findField('IDC_ZEICHNR_BEMERKUNG').disable();
				f.findField('IDC_WI_MATNR').disable();
				f.findField('IDC_STUECKZAHL').disable();
				f.findField('IDC_GEWICHT').disable();
				f.findField('IDC_PREIS').disable();
				f.findField('IDC_WERKSTOFF').disable();
			}
		},

		// Collect Grid Data and serialize it to JSON perhaps a reasonable extension for Ext
		onBeforeAction : function(form, action)
		{
			if ( action.type == "submit" ) {
				var ds = grid.getStore();
				ds.commitChanges();

				var count = ds.getCount();
				var values = [];

				for ( var i=0; i < count; i++ ) {
					var record = ds.getAt(i);

					values.push( {
						id : record.get('id'),
						text : record.get('text'),
						stck : record.get('stck'),
						gewicht : record.get('gewicht'),
						preis : record.get('preis'),
						preis_vorgabe : record.get('preis_vorgabe'),
						werkstoff : record.get('werkstoff'),
						werkstoff_sonder : record.get('werkstoff_sonder'),
						oberflaechenschutz : record.get('oberflaechenschutz'),
						blockierung : record.get('blockierung'),
						gewindeanschluss : record.get('gewindeanschluss'),
						matnr : record.get('matnr'),
						bemerkungen : record.get('bemerkungen')
					} );
				}

				var json = Ext.util.JSON.encode( values );

				// form.findField('IDC_STUECKLISTE').setValue( json );
                var myField = form.findField('IDC_STUECKLISTE');
                var ret = myField.setValue( json );
                // alert (ret);
			}
		},
		
		getGrid: function() {
			return grid;
		}
	}
}();
