Cascade.panel.systemcharakteristik2 = function() {
	// Basisform
	//var _form;
	var form;
	
	function _enableFields( strGewaehlteLastkette, strGewaehlterRohrverlauf )
	{
		// var bDisable = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_HAENGER' ) || 
		//                 ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) );

		var bDisableHorVer = (strGewaehlteLastkette == 'IDC_EINZEL_KLEMMSYSTEM');
		
		// .. fr Groupbox 'Rohrverlauf'
		_enableField( 'HORIZONTAL', !bDisableHorVer );
		_enableField( 'VERTIKAL', !bDisableHorVer );
		
		// .. fr Groupbox 'Rohrrichtung'
		var SENKR_ACHSE	= form.getForm().findField( 'SENKR_ACHSE' ).value;
		var SENKR_RICHT	= form.getForm().findField( 'SENKR_RICHT' ).value;
		var bDisableX	= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "X") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "X") || (strGewaehlteLastkette == 'IDC_EINZEL_KLEMMSYSTEM'));
		var bDisableY	= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "Y") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "Y") || (strGewaehlteLastkette == 'IDC_EINZEL_KLEMMSYSTEM'));
		var bDisableZ	= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "Z") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "Z") || (strGewaehlteLastkette == 'IDC_EINZEL_KLEMMSYSTEM'));
		var bDisableSch	= (strGewaehlteLastkette == 'IDC_EINZEL_KLEMMSYSTEM');
		
		_enableField( 'X_ACHSE', !bDisableX );
		_enableField( 'Y_ACHSE', !bDisableY );
		_enableField( 'Z_ACHSE', !bDisableZ );
		_enableField( 'SCHRAEG_ACHSE', !bDisableSch );
	}
	
	function _enableField( strID, bEnable )
	{
		var field = form.getForm().findField( strID );
		if ( field )
		{
			if ( bEnable )
				field.enable();
			else field.disable();
		}
	}
	
	function _showImg(strGewaehlterRohrverlauf, SENKR_ACHSE)
	{
		var valRR = form.getForm().findField('X_ACHSE').getGroupValue();
		var strPipeDir = "";
		if (valRR == "X_ACHSE")
			valRR = strPipeDir = "X";
		else if (valRR == "Y_ACHSE")
			valRR = strPipeDir = "Y";
		else if (valRR == "Z_ACHSE")
			valRR = strPipeDir = "Z";
		else if (valRR == "SCHRAEG_ACHSE")
			valRR = strPipeDir = "S";
		
		var KoordImgS = "";
		if (valRR == "S")
			KoordImgS = "S_";
		
		var KoordImgVar = form.getForm().findField('KOORD_IMG_VAR').value;
		
		if (strGewaehlterRohrverlauf != "HORIZONTAL")
			var PipeImage	= "RH_KOORD_V" + SENKR_ACHSE + "_Rohr_V_" + KoordImgS + KoordImgVar + ".jpg";
		else
			var PipeImage	= "RH_KOORD_V" + SENKR_ACHSE + "_Rohr_H_" + strPipeDir + "_" + KoordImgVar + ".jpg";
		
		form.getForm().findField('KOORD_IMG').setValue(PipeImage);
		var strFile		= 'catalog/client/custom/img/WITgifs/RH/' + PipeImage;
		Ext.getCmp( 'rohrrichtung-panel' ).body.update( '<center><img src="' + strFile + '" /></center>' );
	}
	
	function _hideWinkel()
	{
		var valRR		= form.getForm().findField('X_ACHSE').getGroupValue();
		var fieldalpha	= form.getForm().findField( 'SCHRAEG_ALPHA' );
		var fieldbeta	= form.getForm().findField( 'SCHRAEG_BETA' );
		if (valRR != "SCHRAEG_ACHSE")
		{
			fieldalpha.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
			fieldalpha.hide();
			fieldbeta.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
			fieldbeta.hide();
		}
		else
		{
			fieldalpha.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
			fieldalpha.show();
			fieldbeta.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
			fieldbeta.show();
		}
	}
	
	// public functions
	return {
		init : function( idx ) 
		{
			//if ( !_form ) 
			if ( !form ) 
			{
				//_form = new Ext.FormPanel({
				form = new Ext.FormPanel({
					id: 'systemcharakteristik2',
					title: '$SYSTEMCHARAKTERISTIK$',
					url:'systemcharakteristik2/set-values',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK2' },
					
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					frame: true,
					labelWidth: 130,
					//bodyStyle:'padding:5px 5px 5px 5px',
					labelStyle: 'font-size:11px',

					items: [
					{
						layout:'column',
						
						items: [ 
						{
							xtype:'fieldset',
							width: 200,
							autoHeight: true,
							title: '$SYSTEMCHARAKTERISTIK2$',
							defaultType: 'radio',
							hideLabels: true,
							style: 'padding: 10px',
							items: [ 
							{
								id: 'IDC_EINZEL_LAGER',
								inputValue: 'EINZEL_LAGER',
								boxLabel:'$EINZEL_LAGER$',
								name:'IDC_LASTKETTE',
								listeners: {
                                    'check': this.produktbereichClicked
                                }
							},
							{
								id: 'IDC_EINZEL_KLEMMSYSTEM',
								inputValue: 'EINZEL_KLEMMSYSTEM',
								boxLabel:'$EINZEL_KLEMMSYSTEM$',
								style: 'margin-top: 10px',
								name:'IDC_LASTKETTE',
								listeners: {
                                    'check': this.produktbereichClicked
                                }
							}]
						},{
							xtype:'fieldset',
							title: '$ROHRVERLAUF$',
							width: 200,
							autoHeight: true,
							defaultType: 'radio',
							hideLabels: true,
							style: 'margin-left: 10px ; padding: 10px',
							
							items: [ {
								id: 'HORIZONTAL',
								inputValue: 'HORIZONTAL',
								boxLabel:'$HORIZONTAL$',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': this.rohrverlaufClicked
                                }
							},{
								id: 'VERTIKAL',
								inputValue: 'VERTIKAL',
								boxLabel:'$VERTIKAL$',
								style: 'margin-top: 10px',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': this.rohrverlaufClicked
                                }
							}]
						},{
							xtype:'fieldset',
							width: 200,
							title: '$ROHRRICHTUNG$',
							autoHeight: true,
							defaultType: 'radio',
							style: 'margin-left: 10px; padding: 10px',
							items: [ {
								id: 'X_ACHSE',
								hideLabel: true,
								inputValue: 'X_ACHSE',
								boxLabel:'$X_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'Y_ACHSE',
								hideLabel: true,
								inputValue: 'Y_ACHSE',
								boxLabel:'$Y_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'Z_ACHSE',
								hideLabel: true,
								inputValue: 'Z_ACHSE',
								boxLabel:'$Z_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'SCHRAEG_ACHSE',
								hideLabel: true,
								inputValue: 'SCHRAEG_ACHSE',
								boxLabel:'$SCHRAEG_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								xtype: 'numberfield',
								id: 'SCHRAEG_ALPHA',
								inputValue: 'SCHRAEG_ALPHA',
								fieldLabel: '$ALPHA$',
								labelSeparator: '',
								width: 50,
								style: 'margin: 0 0 0 -80px',
								maxValue: 90,
								minValue: -90
							},{
								xtype: 'numberfield',
								id: 'SCHRAEG_BETA',
								inputValue: 'SCHRAEG_BETA',
								fieldLabel: '$BETA$',
								labelSeparator: '',
								width: 50,
								style: 'margin: 0 0 0 -80px',
								maxValue: 45,
								minValue: -45
							}]
						},{
							xtype: 'fieldset',
							style: 'padding: 5px',
							autoWidth: true,
							autoHeight: true,
							//hidden: false,
							hidden: true,
							defaultType: 'textfield',
							hideLabels: true,
							disabled: true,
							items: [{
								id: 'SENKR_ACHSE',
								name: 'SENKR_ACHSE'
								},{
								id: 'SENKR_RICHT',
								name: 'SENKR_RICHT'
								},{
								id: 'KOORD_IMG_VAR',
								name: 'KOORD_IMG_VAR'
								},{
								id: 'KOORD_IMG',
								name: 'KOORD_IMG'
								}]
						}]
					} ]
				});
				
				// First do the Layout and render the form
				var cp = Ext.getCmp( 'center-panel' );
				
				//cp.insert( idx, _form );
				cp.insert( idx, form );
				cp.doLayout();
			}
			
			//_form.getForm().reset();
			//_form.load(
			form.getForm().reset();
			form.load(
			{   
			    url: 'systemcharakteristik2/get-values',
				success: function( response, options)
				{
					_enableFields( form.getForm().findField( 'IDC_EINZEL_LAGER' ).getGroupValue(),  form.getForm().findField( 'HORIZONTAL' ).getGroupValue());
					_showImg(form.getForm().findField('HORIZONTAL').getGroupValue(), (form.getForm().findField('SENKR_ACHSE').value));
					_hideWinkel();
				}
			} );			
		},
		
		rohrverlaufClicked : function(clickedObject, bChecked )
		{
            // dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;
			
            var valLK = form.getForm().findField('IDC_EINZEL_LAGER').getGroupValue();
			//var valLA = form.getForm().findField('HAENGEND_EINFACH').getGroupValue();
			var valRR = form.getForm().findField('X_ACHSE').getGroupValue();
			var valRV = clickedObject.id;
			if ((valRV == "VERTIKAL") && (valRR != (form.getForm().findField('SENKR_ACHSE').value + '_ACHSE')) &&
					(valRR != ('SCHRAEG_ACHSE')))
				form.getForm().findField(form.getForm().findField('SENKR_ACHSE').value + '_ACHSE').setValue('true');
			if ((valRV == "HORIZONTAL") && (valRR == (form.getForm().findField('SENKR_ACHSE').value + '_ACHSE')))
			{
				if (form.getForm().findField('SENKR_ACHSE').value != "X")
					form.getForm().findField('X_ACHSE').setValue('true');
				else
					form.getForm().findField('Y_ACHSE').setValue('true');
			}
			
			_enableFields( ("IDC_" + valLK), valRV );
			_showImg(valRV, (form.getForm().findField('SENKR_ACHSE').value));	//-Schu- jetz noch das korr. Bild
			
        },
		
		rohrrichtungClicked : function(clickedObject, bChecked)
		{
			// dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;
			var valRV = form.getForm().findField('HORIZONTAL').getGroupValue();
			_showImg(valRV, (form.getForm().findField('SENKR_ACHSE').value));		//-Schu- jetz noch das korr. Bild
			_hideWinkel();
		},
		
		produktbereichClicked : function(clickedObject, bChecked)
		{
			// dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;
			var valLK = clickedObject.id;
			var valRV = form.getForm().findField('HORIZONTAL').getGroupValue();
			_enableFields( valLK, valRV );
		}
	}
}();
