Cascade.panel.systemcharakteristik = function() {
	// Basisform
	var form;
	
	/**
     * verndert den enable/disable status einiger Elemente, je nach dem, welche Lastkette aktuell gewhlt ist
	 *
	 * @params string strGewaehlteLastkette - gewhlte Lastkette
	 * @returns	-
	 */
	function _enableFields( strGewaehlteLastkette, strGewaehlterRohrverlauf )
	{
		// var bDisable = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_HAENGER' ) || 
		//                 ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) );
		
		var isEinzel			= (strGewaehlteLastkette.indexOf('EINZEL') < 0 ? false : true);
		var isEinzelHaenger		= (strGewaehlteLastkette.indexOf('EINZEL_HAENGER') < 0 ? false : true);
		var isEinzelSchelle		= (strGewaehlteLastkette.indexOf('EINZEL_SCHELLE') < 0 ? false : true);
		var isEinzelZubehoer	= (strGewaehlteLastkette.indexOf('EINZEL_ZUBEHOER') < 0 ? false : true);
		var isEinzelLager		= (strGewaehlteLastkette.indexOf('EINZEL_LAGER') < 0 ? false : true);
		if (strGewaehlteLastkette.indexOf('GELENKS') < 0 && strGewaehlteLastkette.indexOf('STOSSB') < 0)
				var isDynamik	= false;
		else
				var isDynamik	= true;
		var isHorizontal		= (strGewaehlterRohrverlauf.indexOf('HORIZONTAL') < 0 ? false : true);
		/*
		var bDisableHorVer = ( ( strGewaehlteLastkette == 'IDC_EINZEL_HAENGER' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) ||
							( strGewaehlteLastkette == 'EINZEL_HAENGER' ) || ( strGewaehlteLastkette == 'EINZEL_ZUBEHOER' ) );
		
		var bDisablekeinRuT = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_HAENGER' ) || 
		                       ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) ||
                               ( strGewaehlteLastkette == 'IDC_GELENKSTUETZE' ) || ( strGewaehlteLastkette == 'IDC_GELENKSTREBE' ) ||
							   ( strGewaehlteLastkette == 'IDC_STOSSBREMSE' ));
		
		var bDisableHaengend  = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) ||  
		                       ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) );
		
		var bDisableStuetzendE = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) ||  
		                       ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) );
		
		var bDisableStuetzendD = ( ( strGewaehlteLastkette == 'IDC_EINZEL_LAGER' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_HAENGER' ) || 
		                       ( strGewaehlteLastkette == 'IDC_EINZEL_SCHELLE' ) || ( strGewaehlteLastkette == 'IDC_EINZEL_ZUBEHOER' ) );
		*/
		var bDisableHorVer		= (isEinzelHaenger || isEinzelZubehoer);
		var bDisablekeinRuT		= (isEinzel || isDynamik);
		var bDisableHaengend	= (isEinzelLager || isEinzelSchelle || isEinzelZubehoer);
		var bDisableStuetzendE	= bDisableHaengend;
		var bDisableStuetzendD	= isEinzel;
		
		// .. fr Groupbox 'Rohrverlauf'
		_enableField( 'HORIZONTAL', !bDisableHorVer );
		_enableField( 'VERTIKAL', !bDisableHorVer );
        if (bDisablekeinRuT)
            form.getForm().findField('IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL').setValue('false');
		_enableField( 'IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL', !bDisablekeinRuT );
        
		// .. fr Groupbox 'Lastabtragung'
		_enableField( 'HAENGEND_EINFACH', !bDisableHaengend );
		_enableField( 'STUETZEND_EINFACH', !bDisableStuetzendE );
		_enableField( 'HAENGEND_DOPPEL', !bDisableHaengend );
		_enableField( 'STUETZEND_DOPPEL', !bDisableStuetzendD );
		_enableField( 'IDC_ASYMETRISCH', false );
		
		// .. fr Groupbox 'Rohrrichtung'
		var SENKR_ACHSE		= form.getForm().findField( 'SENKR_ACHSE' ).value;
		//var SENKR_RICHT		= form.getForm().findField( 'SENKR_RICHT' ).value;
		/*
		var bDisableX		= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "X") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "X"));
		var bDisableY		= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "Y") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "Y"));
		var bDisableZ		= ((strGewaehlterRohrverlauf == "HORIZONTAL" && SENKR_ACHSE == "Z") || (strGewaehlterRohrverlauf == "VERTIKAL" && SENKR_ACHSE != "Z"));
		var bDisableSchr	= (strGewaehlterRohrverlauf == "VERTIKAL");
		*/
		var bDisableX		= ((isHorizontal && SENKR_ACHSE == "X") || (!isHorizontal && SENKR_ACHSE != "X"));
		var bDisableY		= ((isHorizontal && SENKR_ACHSE == "Y") || (!isHorizontal && SENKR_ACHSE != "Y"));
		var bDisableZ		= ((isHorizontal && SENKR_ACHSE == "Z") || (!isHorizontal && SENKR_ACHSE != "Z"));
		var bDisableSchr	= (!isHorizontal);
		
		_enableField( 'X_ACHSE', !bDisableX );
		_enableField( 'Y_ACHSE', !bDisableY );
		_enableField( 'Z_ACHSE', !bDisableZ );
		_enableField( 'SCHRAEG_ACHSE', !bDisableSchr );
		
		if (bDisableSchr)
			_hideWinkel();
		
		//Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="catalog/client/custom/img/prinzip/Empty.gif" /></center>' );
		
	}
	
	/**
     * verndert den enable/disable status eines UI-Elementes
	 *
	 * @params string strID - id des Elementes
	 *         boolean bEnable - true: Element enablen
	 *                           false: Element disablen
	 * @returns -
	 */
	function _enableField( strID, bEnable )
	{
		var field = form.getForm().findField( strID );
		if ( field )
		{
			if ( bEnable )
				field.enable();
			else field.disable();
		}
	}
	
	function _showImg(strGewaehlterRohrverlauf, SENKR_ACHSE)
	{
		var valRR = form.getForm().findField('X_ACHSE').getGroupValue();
		var strPipeDir = "";
		if (valRR == "X_ACHSE")
			valRR = strPipeDir = "X";
		else if (valRR == "Y_ACHSE")
			valRR = strPipeDir = "Y";
		else if (valRR == "Z_ACHSE")
			valRR = strPipeDir = "Z";
		else if (valRR == "SCHRAEG_ACHSE")
			valRR = strPipeDir = "S";
		
		var KoordImgS = "";
		if (valRR == "S")
			KoordImgS = "S_";
		
		var KoordImgVar = form.getForm().findField('KOORD_IMG_VAR').value;
		
		if (strGewaehlterRohrverlauf != "HORIZONTAL")
			var PipeImage	= "RH_KOORD_V" + SENKR_ACHSE + "_Rohr_V_" + KoordImgS + KoordImgVar + ".jpg";
		else
			var PipeImage	= "RH_KOORD_V" + SENKR_ACHSE + "_Rohr_H_" + strPipeDir + "_" + KoordImgVar + ".jpg";
		
		form.getForm().findField('KOORD_IMG').setValue(PipeImage);
		var strFile		= 'catalog/client/custom/img/WITgifs/RH/' + PipeImage;
		Ext.getCmp( 'rohrrichtung-panel' ).body.update( '<center><img src="' + strFile + '" /></center>' );
	}
	
	function _hideWinkel()
	{
		var valRR		= form.getForm().findField('X_ACHSE').getGroupValue();
		var fieldalpha	= form.getForm().findField( 'SCHRAEG_ALPHA' );
		var fieldbeta	= form.getForm().findField( 'SCHRAEG_BETA' );
		if (valRR != "SCHRAEG_ACHSE")
		{
			fieldalpha.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
			form.getForm().findField( 'SCHRAEG_ALPHA' ).setValue("");
			fieldalpha.hide();
			fieldbeta.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
			form.getForm().findField( 'SCHRAEG_BETA' ).setValue("");
			fieldbeta.hide();
		}
		else
		{
			fieldalpha.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
			fieldalpha.show();
			fieldbeta.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
			fieldbeta.show();
		}
	}
	// public functions
	return {
		init : function(idx) {
			if (!form) {
				form = new Ext.FormPanel({
					id: 'systemcharakteristik',
					title: '$SYSTEMCHARAKTERISTIK$',
					url:'systemcharakteristik/set-values',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.SYSTEMCHARAKTERISTIK' },
					
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					frame: true,
					labelWidth: 130,
					//bodyStyle:'padding:5px 5px 5px 5px',
					labelStyle: 'font-size:11px',

					items: [{
						layout:'column',
						
						items: [ {
							xtype:'fieldset',
							//autoWidth: true,
							width: 170,
							height: 200,
							title: '$LASTKETTE$',
							defaultType: 'radio',
							hideLabels: true,
							style: 'padding: 5px',
							items: [ {
								id: 'IDC_BEWEGLICH',
								inputValue: 'BEWEGLICH',
								boxLabel:'$BEWEGLICH$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							{
								id: 'IDC_STARR',
								inputValue: 'STARR',
								boxLabel:'$STARR$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							{
								id: 'IDC_GELENKSTUETZE',
								inputValue: 'GELENKSTUETZE',
								boxLabel:'$GELENKSTUETZE$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							// Dynamikteile
							{
								id: 'IDC_GELENKSTREBE',
								inputValue: 'GELENKSTREBE',
								boxLabel:'$GELENKSTREBE$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							
							{
								id: 'IDC_STOSSBREMSE',
								inputValue: 'STOSSBREMSE',
								boxLabel:'$STOSSBREMSE$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							
							{
								id: 'IDC_EINZEL_HAENGER',
								inputValue: 'EINZEL_HAENGER',
								boxLabel:'$EINZEL_HAENGER$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							{
								id: 'IDC_EINZEL_SCHELLE',
								inputValue: 'EINZEL_SCHELLE',
								boxLabel:'$EINZEL_SCHELLE$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},
							/*{
								id: 'IDC_EINZEL_LAGER',
								inputValue: 'EINZEL_LAGER',
								boxLabel:'$EINZEL_LAGER$',
								name:'IDC_LASTKETTE',
								disabled : true,
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							},*/
							{
								id: 'IDC_EINZEL_ZUBEHOER',
								inputValue: 'EINZEL_ZUBEHOER',
								boxLabel:'$EINZEL_ZUBEHOER$',
								name:'IDC_LASTKETTE',
                                listeners: {
                                    'check': this.lastketteClicked
                                }
							}]
						},{
							xtype:'fieldset',
							//autoWidth: true,
							title: '$ROHRVERLAUF$',
							height: 200,
							width: 170,
							defaultType: 'radio',
							hideLabels: true,
							//style: 'padding: 5px',
							style: 'margin: 0 0 0 5px; padding: 5px',
							
							items: [ {
								id: 'HORIZONTAL',
								inputValue: 'HORIZONTAL',
								boxLabel:'$HORIZONTAL$',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': this.rohrverlaufClicked
                                }
							},{
								id: 'VERTIKAL',
								inputValue: 'VERTIKAL',
								boxLabel:'$VERTIKAL$',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': this.rohrverlaufClicked
                                }
							},
/*                          {
								id: 'ROHRBOGEN',
								inputValue: 'ROHRBOGEN',
								boxLabel:'$ROHRBOGEN$',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': this.rohrverlaufClicked
                                }
							},
*/
                            {
								xtype: 'checkbox',
								inputValue: 'KEIN_ROHRUMSCHLIESSENDES_TEIL',
								boxLabel:'$KEIN_ROHRUMSCHLIESSENDES_TEIL$',
								id:'IDC_KEIN_ROHRUMSCHLIESSENDES_TEIL'
							}
/*                          ,{
								xtype: 'checkbox',
								inputValue: 'NUR_ROHRUMSCHLIESSENDES_TEIL',
								boxLabel:'$NUR_ROHRUMSCHLIESSENDES_TEIL$',
								id:'IDC_NUR_ROHRUMSCHLIESSENDES_TEIL'
							}
*/
                            ]
						},{
							xtype:'fieldset',
							width: 170,
							//autoWidth: true,
							title: '$LASTABTRAGUNG$',
							height: 200,
							defaultType: 'radio',
							hideLabels: true,
							style: 'margin: 0 0 0 5px; padding: 5px',
							items: [ {
								id: 'HAENGEND_EINFACH',
								inputValue: 'HAENGEND_EINFACH',
								boxLabel:'$HAENGEND_EINFACH$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							},{
								id: 'STUETZEND_EINFACH',
								inputValue: 'STUETZEND_EINFACH',
								boxLabel:'$STUETZEND_EINFACH$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							},{
								id: 'HAENGEND_DOPPEL',
								inputValue: 'HAENGEND_DOPPEL',
								boxLabel:'$HAENGEND_DOPPEL$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							},{
								id: 'STUETZEND_DOPPEL',
								inputValue: 'STUETZEND_DOPPEL',
								boxLabel:'$STUETZEND_DOPPEL$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							},{
								xtype: 'checkbox',
								id: 'IDC_ASYMETRISCH',
								inputValue: 'ASYMETRISCH',
								boxLabel: '$ASYMETRISCH$',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
								
							},{
								id: 'HAENGEND_VERZWEIGT',
								inputValue: 'HAENGEND_VERZWEIGT',
								boxLabel:'$HAENGEND_VERZWEIGT$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							}, {
								id: 'SONDERFAELLE',
								inputValue: 'SONDERFAELLE',
								boxLabel:'$SONDERFAELLE$',
								name:'IDC_LASTABTRAGUNG',
                                listeners: {
                                    'check': this.lastabtragungClicked
                                }
							}, {
								xtype: 'combo',
								fieldLabel: 'Nennweite DN',
								id: 'IDC_SONDERFAELLE_COMBO',
								hiddenName:'IDC_SONDERFAELLE_COMBO',
								store: new Ext.data.SimpleStore({
									fields: ['value', 'text']
								}),
								displayField:'text',
								valueField:'value',
								typeAhead: false,
								mode: 'local',
								triggerAction: 'all',
								emptyText:'$WAEHLEN$',
								selectOnFocus:true,
								width:185,
								hideMode: 'visibility'
							}]
						},{
							xtype:'fieldset',
							width: 170,
							//autoWidth: true,
							title: '$ROHRRICHTUNG$',
							height: 200,
							defaultType: 'radio',
							style: 'margin: 0 0 0 5px; padding: 5px',
							items: [ {
								id: 'X_ACHSE',
								hideLabel: true,
								inputValue: 'X_ACHSE',
								boxLabel:'$X_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'Y_ACHSE',
								hideLabel: true,
								inputValue: 'Y_ACHSE',
								boxLabel:'$Y_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'Z_ACHSE',
								hideLabel: true,
								inputValue: 'Z_ACHSE',
								boxLabel:'$Z_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								id: 'SCHRAEG_ACHSE',
								hideLabel: true,
								inputValue: 'SCHRAEG_ACHSE',
								boxLabel:'$SCHRAEG_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': this.rohrrichtungClicked
                                }
							},{
								xtype: 'numberfield',
								id: 'SCHRAEG_ALPHA',
								inputValue: 'SCHRAEG_ALPHA',
								fieldLabel: '$ALPHA$',
								labelSeparator: '',
								width: 50,
								style: 'margin: 0 0 0 -80px',
								maxValue: 90,
								minValue: -90
							},{
								xtype: 'numberfield',
								id: 'SCHRAEG_BETA',
								inputValue: 'SCHRAEG_BETA',
								fieldLabel: '$BETA$',
								labelSeparator: '',
								width: 50,
								style: 'margin: 0 0 0 -80px',
								maxValue: 45,
								minValue: -45
							}]
						},/*{
							xtype:'fieldset',
							//width: 97,
							autoWidth: true,
							title: '$KOORDINATENSYS_ROHR$',
							height: 185,
							//autoHeight: true,
							hideLabels: true,
							id: 'KOORDINATENSYS_ROHR',
							style: 'margin: 0 0 0 5px; padding: 5px',
							//html: '<img src="catalog/client/custom/img/RH_KOORD_mit_Rohr.jpg" />'
							html: '<img src="catalog/client/custom/img/WITgifs/RH/blank.png"/>'
						},*/{
							xtype: 'fieldset',
							style: 'padding: 5px',
							autoWidth: true,
							autoHeight: true,
							//hidden: false,
							hidden: true,
							defaultType: 'textfield',
							hideLabels: true,
							//disabled: true,
							items: [{
								id: 'SENKR_ACHSE',
								name: 'SENKR_ACHSE'
								},{
								id: 'SENKR_RICHT',
								name: 'SENKR_RICHT'
								},{
								id: 'KOORD_IMG_VAR',
								name: 'KOORD_IMG_VAR'
								},{
								id: 'KOORD_IMG',
								name: 'KOORD_IMG'
								}]
						}]
					}/*,{
						xtype: 'panel',
						frame: true,
						style: "margin: 5px 0 0 0",
						//autoWidth: true,
						width: 140,
						
						bbar: [
							{
                                // -mw- Achtung: diese ID nicht gleich benennen wie Drehen-Knopf im Toolbar
								id: 'IDC_DREHEN_KOORD',
								icon: 'catalog/client/custom/img/icons/arrow_rotate_anticlockwise.png',
								cls: 'x-btn-text-icon',
								text: 'Drehen',
								tooltip: '<b>Drehen</b>',
								handler: function() {
                                    alert( form.getForm().findField('HAENGEND_EINFACH').getGroupValue() );
									// alert( 'noch nicht implementiert');
								}
							}
						],
						
						html: '<img src="catalog/client/custom/img/RH_KOORD_mit_Rohr.jpg" />'
						
					}*/]
				});
				
				// First do the Layout and render the form
				var cp = Ext.getCmp('center-panel');
				
				cp.insert(idx,form);
				cp.doLayout();
				
				form.findById('IDC_SONDERFAELLE_COMBO').hide();
				var checkbox = form.findById('IDC_ASYMETRISCH').hide();
				checkbox.hideContainer();
				//_enableField( 'IDC_GELENKSTUETZE', false );
				//_enableField( 'IDC_GELENKSTREBE', false );
				_enableField( 'HAENGEND_VERZWEIGT', false );
				_enableField( 'SONDERFAELLE', false );
				
			}
			
			form.getForm().reset();
			form.load(
			{   
			    url: 'systemcharakteristik/get-values',
				success: function( response, options)
				{
					_enableFields( form.getForm().findField( 'IDC_BEWEGLICH' ).getGroupValue(),  form.getForm().findField( 'HORIZONTAL' ).getGroupValue());
					_showImg(form.getForm().findField('HORIZONTAL').getGroupValue(), (form.getForm().findField('SENKR_ACHSE').value));
					_hideWinkel();
				}
			} );			
		},
		
		lastketteClicked : function(clickedObject, bChecked )
		{
            // dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;

            // alert(clickedObject.id);
            // var x = form.getForm().findField('HAENGEND_EINFACH');
            // var y = x.getGroupValue();
            // alert(y);
            var valLK = clickedObject.id;
            // alert(valLK);  Achtung: hier die ID, unten der Name ;-(
            if ((valLK == "IDC_STARR") && (valLA == "STUETZEND_EINFACH"))
                form.getForm().findField('HAENGEND_EINFACH').setValue('true');
            if ((valLK == "IDC_STARR") && (valLA == "STUETZEND_DOPPEL"))
                form.getForm().findField('HAENGEND_DOPPEL').setValue('true');
            if ((valLK == "IDC_GELENKSTUETZE") && (valLA == "HAENGEND_EINFACH"))
                form.getForm().findField('STUETZEND_EINFACH').setValue('true');
            if ((valLK == "IDC_GELENKSTUETZE") && (valLA == "HAENGEND_DOPPEL"))
                form.getForm().findField('STUETZEND_DOPPEL').setValue('true');

            if (((valLK == "IDC_GELENKSTUETZE") || (valLK == "IDC_GELENKSTREBE") || (valLK == "IDC_STOSSBREMSE"))
                && ((valLA == "HAENGEND_DOPPEL") || (valLA == "STUETZEND_DOPPEL")))
                form.getForm().findField('VERTIKAL').setValue('true');

            if (valLK == "IDC_EINZEL_HAENGER")
            {
                form.getForm().findField('HORIZONTAL').setValue('true');
            }
            if (valLK == "IDC_EINZEL_SCHELLE")
            {
                form.getForm().findField('HAENGEND_EINFACH').setValue('true');
            }
            if (valLK == "IDC_EINZEL_LAGER")
            {
                //form.getForm().findField('HORIZONTAL').setValue('true');
                form.getForm().findField('STUETZEND_EINFACH').setValue('true');
            }
            if (valLK == "IDC_EINZEL_ZUBEHOER")
            {
                form.getForm().findField('HORIZONTAL').setValue('true');
                form.getForm().findField('HAENGEND_EINFACH').setValue('true');
            }
			
			Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="catalog/client/custom/img/WITgifs/RH/blank.png" /></center>' );
            
			var valLA = form.getForm().findField('HAENGEND_EINFACH').getGroupValue();
			var valRV = form.getForm().findField('HORIZONTAL').getGroupValue();
			// je nach gewhlter Lastkette einige Felder disablen/enablen
			_enableFields( valLK, valRV );
        },
        
        rohrverlaufClicked : function(clickedObject, bChecked )
		{
            // dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;

            var valLK = form.getForm().findField('IDC_BEWEGLICH').getGroupValue();
			var valLA = form.getForm().findField('HAENGEND_EINFACH').getGroupValue();
			var valRR = form.getForm().findField('X_ACHSE').getGroupValue();
			var valRV = clickedObject.id;
            
            // alert(valLK + " " + valLA + " " + valRV);

            if ((valRV == "VERTIKAL") && (valLA == "HAENGEND_EINFACH"))
                form.getForm().findField('HAENGEND_DOPPEL').setValue('true');
            if ((valRV == "VERTIKAL") && (valLA == "STUETZEND_EINFACH") && (valLK != "EINZEL_LAGER"))
                form.getForm().findField('STUETZEND_DOPPEL').setValue('true');
			if ((valRV == "VERTIKAL") && (valRR != (form.getForm().findField('SENKR_ACHSE').value + '_ACHSE')) //&&
				//	(valRR != ('SCHRAEG_ACHSE'))
					)
				form.getForm().findField(form.getForm().findField('SENKR_ACHSE').value + '_ACHSE').setValue('true');
				
            if ((valRV == "HORIZONTAL") && (valLK == "EINZEL_SCHELLE"))
                form.getForm().findField('HAENGEND_EINFACH').setValue('true');
            if ((valRV == "HORIZONTAL") && (valLA == "STUETZEND_DOPPEL"))
                form.getForm().findField('HAENGEND_DOPPEL').setValue('true');
            if ((valRV == "HORIZONTAL") && ((valLK == "GELENKSTREBE") || (valLK == "STOSSBREMSE")) && (valLA == "STUETZEND_DOPPEL"))
                form.getForm().findField('STUETZEND_EINFACH').setValue('true');
            if ((valRV == "HORIZONTAL") && ((valLK == "GELENKSTREBE") || (valLK == "STOSSBREMSE")) && (valLA == "HAENGEND_DOPPEL"))
                form.getForm().findField('HAENGEND_EINFACH').setValue('true');
			if ((valRV == "HORIZONTAL") && (valRR == (form.getForm().findField('SENKR_ACHSE').value + '_ACHSE')))
			{
				if (form.getForm().findField('SENKR_ACHSE').value != "X")
					form.getForm().findField('X_ACHSE').setValue('true');
				else
					form.getForm().findField('Y_ACHSE').setValue('true');
			}
			
			_enableFields( ("IDC_" + valLK), valRV );
			_showImg(valRV, (form.getForm().findField('SENKR_ACHSE').value));	//-Schu- jetz noch das korr. Bild
        },
        
        lastabtragungClicked : function(clickedObject, bChecked )
		{
            // dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            
            // Mal nur so als kleiner Hinweis: -gl-
            // var f = form.getForm();
            // var beweglich = f.findField('BEWEGLICH');
            // var horizontal = f.findField('HORIZONTAL');
            // var valLK = beweglich.getGroupValue();
            // var ...
            // beweglich.setValue('true');
            
            if (!bChecked)
                return;

            var valLK = form.getForm().findField('IDC_BEWEGLICH').getGroupValue();
			var valLA = clickedObject.id;
			var valRV = form.getForm().findField('HORIZONTAL').getGroupValue();
            // alert(valLK);
            if ((valLK == "STARR") && (valLA == "STUETZEND_EINFACH"))
                form.getForm().findField('IDC_BEWEGLICH').setValue('true');
            if ((valLK == "STARR") && (valLA == "STUETZEND_DOPPEL"))
                form.getForm().findField('IDC_BEWEGLICH').setValue('true');
            if ((valLK == "GELENKSTUETZE") && (valLA == "HAENGEND_EINFACH"))
                form.getForm().findField('IDC_BEWEGLICH').setValue('true');
            if ((valLK == "GELENKSTUETZE") && (valLA == "HAENGEND_DOPPEL"))
                form.getForm().findField('IDC_BEWEGLICH').setValue('true');

            if (((valLK == "GELENKSTUETZE") || (valLK == "GELENKSTREBE") || (valLK == "STOSSBREMSE"))
                && ((valLA == "HAENGEND_DOPPEL") || (valLA == "STUETZEND_DOPPEL")))
                form.getForm().findField('VERTIKAL').setValue('true');

            if ((valRV == "VERTIKAL") && (valLA == "HAENGEND_EINFACH"))
                form.getForm().findField('HORIZONTAL').setValue('true');
            if ((valRV == "VERTIKAL") && (valLA == "STUETZEND_EINFACH") && (valLK != "EINZEL_LAGER"))
                form.getForm().findField('HORIZONTAL').setValue('true');
            if ((valRV == "HORIZONTAL") && (valLA == "STUETZEND_DOPPEL"))
                form.getForm().findField('VERTIKAL').setValue('true');
        },
		
		rohrrichtungClicked : function(clickedObject, bChecked)
		{
			if (!bChecked)
                return;
			
			var valLK = form.getForm().findField('IDC_BEWEGLICH').getGroupValue();
			var valRV = form.getForm().findField('HORIZONTAL').getGroupValue();
			_showImg(valRV, (form.getForm().findField('SENKR_ACHSE').value));		//-Schu- jetz noch das korr. Bild
			_hideWinkel();
		}
        
	}
}();
