Cascade.panel.sollwerte_zubehoer_einzel = function() 
{
	var form;
	var comboStore;
	
	return {
		init: function(idx) {
			if (!form) {
				comboStore = new Ext.data.Store({
					proxy: new Ext.data.HttpProxy({url: 'sollwerte_zubehoer_einzel/get_lgv' }),
					reader: new Ext.data.JsonReader({
						root: 'lgv'
						/*totalProperty: 'count',*/
						/*id: 'id'*/
					}, [
						{name: 'value'},
						{name: 'text'}
					   ])
				});
				
				form = new Ext.FormPanel( {
					url:'sollwerte-zubehoer-einzel/set-values',
					frame: true,
					labelAlign: 'top',
					title: '$SOLLWERTE_ZUBEHOER_EINZEL$',
					id: 'sollwerte_zubehoer_einzel',
					bodyStyle:'padding:5px 5px 0',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.SOLLWERTE_ZUBEHOER_EINZEL' },
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					items: [ 
                        {
                            xtype: 'textfield',
                            id: 'IDC_LAST',
                            fieldLabel: '$IDC_LAST$',
                            width: 75,
                            listeners: {
                                'change': this.getNewLGV
                            }
                        },
                        {
                            xtype: 'combo',
                            labelAlign: 'top',
                            fieldLabel: '$LGV$',
                            hiddenName:'LGV',
                            store: comboStore,
                            displayField:'text',
                            typeAhead: true,
                            forceSelection: true,
                            editable: false,
                            mode: 'local',
                            triggerAction: 'all',
                            selectOnFocus: false
                        }
					]
                });
				
				var cp = Ext.getCmp('center-panel');
					
				cp.insert(idx, form);
				cp.doLayout();
				
				Ext.DomHelper.insertAfter('IDC_LAST', {tag:'span', html:'&nbsp;kN'});
			}
			
			form.getForm().reset();

			comboStore.load( { params: { betriebslast: form.getForm().findField('IDC_LAST').getValue() } } );
				
			form.load({ url: 'sollwerte-zubehoer-einzel/get-values' });
			Ext.getCmp('move-next').enable();
		},
		
		getNewLGV : function(field, newValue, oldValue )
		{
            comboStore.reload({ params: { betriebslast : newValue },
                                callback: Cascade.panel.sollwerte_zubehoer_einzel.setDefault });
        },
        
        setDefault : function(r, options, success) 
        {
			var f = form.getForm();
			var combo = f.findField('LGV');
            // combo.select(0);

            var record = combo.store.getAt(0);
            combo.setValue(record.get('value'));
            
            // form.getForm().findField('LGV').select(0);
        }
	}
}();