Cascade.panel.sollwerte_spannweite = function() 
{
	var form;
	var comboStore;
	
	return {
		init: function(idx) {
			if (!form) {
				comboStore = new Ext.data.Store({
					proxy: new Ext.data.HttpProxy({url: 'sollwerte_spannweite/get_spannweiten' }),
					reader: new Ext.data.JsonReader({
						root: 'spannweiten'
						/*totalProperty: 'count',*/
						/*id: 'id'*/
					}, [
						{name: 'value'},
						{name: 'text'}
					   ])
				});
				
				form = new Ext.FormPanel( {
					url:'sollwerte_spannweite/set-values',
					frame: true,
					labelAlign: 'top',
					title: '$SOLLWERTE_SPANNWEITE$',
					id: 'sollwerte_spannweite',
					bodyStyle:'padding:5px 5px 0',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.SOLLWERTE_SPANNWEITE' },
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					items: [ 
                        {
                            xtype: 'combo',
                            labelAlign: 'top',
                            fieldLabel: '$SPANNWEITE$',
                            hiddenName:'SPANNWEITE',
                            store: comboStore,
                            displayField:'text',
                            typeAhead: true,
                            forceSelection: true,
                            editable: false,
                            mode: 'local',
                            triggerAction: 'all',
                            selectOnFocus:true
                        },{
                            xtype: 'checkbox',
                            boxLabel:'$SONDER$',
                            labelSeparator: '',
                            name:'IDC_SPANNWEITE_EINZEL_SONDER_CHECK',
                            listeners: {
                                'check' : function( combo, checked ) {
                                    var f = form.getForm();
                                    var edit = f.findField('IDC_SPANNWEITE_EINZEL_SONDER');
                                    var combo = f.findField('SPANNWEITE');
                                    
                                    if (checked) {
                                        combo.disable();
                                        edit.enable();
                                    } else {
                                        combo.enable();
                                        edit.setValue('');
                                        edit.disable();
                                    }
                                }
                            }
                        },{
                            xtype: 'numberfield',
                            id: 'IDC_SPANNWEITE_EINZEL_SONDER',
                            width: 50,
                            //disabled: true,
                            labelSeparator: '&nbsp;'
						}
					]
                });
				
				var cp = Ext.getCmp('center-panel');
					
				cp.insert(idx, form);
				cp.doLayout();
				
				Ext.DomHelper.insertAfter('IDC_SPANNWEITE_EINZEL_SONDER', {tag:'span', html:'&nbsp;mm'});
				
			}

			form.getForm().reset();

            // rausgezogen, damit es bei jedem Aufblenden derForm ausgefhrt wird
			comboStore.load( { params: {  } } );
			
            // wird hier eigentlich nicht gebraucht, weil es nur eine Combo gibt, soll aber der Default bergeben werden:
			form.load({ url: 'sollwerte_spannweite/get-values' });

			Ext.getCmp('move-next').enable();
		}
	}
}();