/**
 * 
 */
Cascade.panel.sollwerte_rohrumschliessendes_teil = function()
{
	var form;
	
	return {
		init: function(idx) 
		{
			if (!form) {
				form = new Ext.FormPanel({
					//labelAlign: 'top',
					url: 'sollwerte-rohrumschliessendes-teil/set-values',
					frame:true,
					id: 'sollwerte_rohrumschliessendes_teil',
					title: '$SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL$',
					bodyStyle:'padding:5px 5px 0',
					//width: 600,
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL' },
					listeners: {
						'actioncomplete': this.onActionComplete
					},
					
					items: [{
						xtype: 'fieldset',
						width: 200,
						title: '$IDC_TEMPERATUR_LABEL$',
						height: 40,
						
						items:[{
							layout:'column',
							items:[{
								width: 190,
								layout: 'form',
									
								items: [{
									xtype:'numberfield',
									id: 'IDC_TEMPERATUR_MEDIUM',
									fieldLabel: '$MEDIUM$',
									labelWidth: 75,
									labelSeparator: '',
									width: 45,
									maxValue: 900,
									minValue: -10,
									listeners: {
										'change': this.onMediumTemperaturChange
									}
								}]
							},/*{
								width: 190,
								layout: 'form',
								items: [{
									xtype:'numberfield',
									id: 'IDC_TEMPERATUR_UMGEBUNG',
									fieldLabel: '$UMGEBUNG$',
									
									labelSeparator: '',
									width: 45,
									maxValue: 80,
									minValue: -10
								}]
							},*/{
								width: 190,
								layout: 'form',
								items: [{
									xtype:'numberfield',
									id: 'IDC_TEMPERATUR_REFERENZ',
									//fieldLabel: '$REFERENZ$',
									hidden: true,
									labelWidth: 75,
									labelSeparator: '',
									width: 45,
									maxValue: 900,
									minValue: -10,
									listeners: {
										'change': this.onReferenzTemperaturChange
									}
								}]
							}]
						}]
					},{items: [{
						xtype: 'fieldset',
						width: 380,
						title: '$UMGEBUNGSTEMPERATUR$',
						height: 40,
						items: [{
							style: 'margin-left: -105px',
							xtype: 'checkbox',
							boxLabel: '$UMGEBUNGSTEMP_GRENZEN$',
							labelSeparator: '',
							checked: true,
							disabled: true
							}]
						}]
					},{
						layout: 'column',
						
						items: [{
							width: 225,
							layout: 'form',
							
							items: [{
								xtype: 'combo',
								fieldLabel: '$NENNWEITE_DN$',
								labelSeparator: '',
								labelWidth: 320,
								hiddenName:'IDC_NENNWEITE_DN',
								store: new Ext.data.SimpleStore({
									fields: ['value', 'text'],
									data : [
										['15', '15'],
										['20', '20'],
										['25', '25'],
										['32', '32'],
										['40', '40'],
										['50', '50'],
										['65', '65'],
										['80', '80'],
										['100', '100'],
										['125', '125'],
										['150', '150'],
										['200', '200'],
										['250', '250'],
										['300', '300'],
										['350', '350'],
										['400', '400'],
										['450', '450'],
										['500', '500'],
										['550', '550'],
										['600', '600'],
										['700', '700'],
										['800', '800'],
										//['850', '850'],
										['900', '900'],
										['1000', '1000'],
										['1100', '1100'],
										['1200', '1200']
									]
								}),
								
								listeners: {
									'select': function(combo, record, idx) {
										var f = form.getForm();
										var combo = f.findField('IDC_AUSSENDURCHMESSER');
										var record = combo.store.getAt(idx);
										combo.setValue( record.get('value') );
									}
								},
								
								displayField:'text',
								typeAhead: true,
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								width: 80,
								editable: false
							}]
						},{
							width: 200,
							layout: 'form',
							
							items: [ {
								xtype: 'numberfield',
								id: 'IDC_DAEMMDICKE',
								fieldLabel: '$DAEMMDICKE$',
								labelSeparator: '&nbsp;',
								width: 50
							}] 
						}]
					},{
						layout: 'column',
						
						items: [{
							width: 225,
							layout: 'form',
							
							items: [{
								xtype: 'combo',
								fieldLabel: '$AUSSENDURCHMESSER$',
								labelWidth: 220,
								labelSeparator: '',
								labelAlign: 'left',
								hiddenName:'IDC_AUSSENDURCHMESSER',
								store: new Ext.data.SimpleStore({
									fields: ['value', 'text'],
									data : [
										['21,3', '21,3'],
										['26,9', '26,9'],
										['33,7', '33,7'],
										['42,4', '42,4'],
										['48,3', '48,3'],
										['60,3', '60,3'],
										['76,1', '76,1'],
										['88,9', '88,9'],
										['114,3', '114,3'],
										['139,7', '139,7'],
										['168,3', '168,3'],
										['219,1', '219,1'],
										['273', '273'],
										['323,9', '323,9'],
										['355,6', '355,6'],
										['406,4', '406,4'],
										['457', '457'],
										['508', '508'],
										['559', '550'],
										['610', '610'],
										['711', '711'],
										['813', '813'],
										//['863', '863'],
										['914', '914'],
										['1016', '1016'],
										['1120', '1120'],
										['1220', '1220']
									]
								}),
								
								listeners: {
									'select' : function(combo, record, idx) {
										var f = form.getForm();
										var combo = f.findField('IDC_NENNWEITE_DN');
										var record = combo.store.getAt(idx);
										combo.setValue(record.get('value'));
									}
								},
								displayField:'text',
								typeAhead: true,
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								width: 80,
								editable: false
							}]
						},{
							width: 175,
							layout: 'form',
							
							items: [ {
								xtype: 'checkbox',
								boxLabel:'$SONDER$',
								labelSeparator: '',
								name:'IDC_AUSSENDURCHMESSER_SONDER_CHECK',
								listeners: {
									'check' : function( combo, checked ) {
										var f = form.getForm();
										var edit = f.findField('IDC_AUSSENDURCHMESSER_SONDER');
										var combo = f.findField('IDC_AUSSENDURCHMESSER');
										
										if (checked) {
											combo.disable();
											edit.enable();
										} else {
											combo.enable();
											edit.setValue('');
											edit.disable();
										}
									}
								}
							}] 
						},{
							width: 200,
							layout: 'form',
							items: [{
								xtype: 'numberfield',
								id: 'IDC_AUSSENDURCHMESSER_SONDER',
								labelSeparator: '&nbsp;',
								width: 50//,
								//disabled: true
							}]
						}]
					},{
						layout: 'column',
						
						items: [{
							width: 225,
							layout: 'form',
							
							items: [{
								xtype: 'combo',
								labelWidth: 220,
								fieldLabel: '$SPANNWEITE$',
								labelSeparator: '',
								hiddenName:'IDC_SPANNWEITE',
								store: new Ext.data.SimpleStore({
									fields: ['value', 'text'],
									data : [
										['300', '300'],
										['400', '400'],
										['500', '500'],
										['600', '600'],
										['800', '800'],
										['1000', '1000'],
										['1200', '1200'],
										['1400', '1400'],
										['1600', '1600'],
										['1800', '1800'],
										['2000', '2000'],
										['2200', '2200'],
										['2400', '2400']                    
									]
								}),
								
								
								displayField:'text',
								typeAhead: true,
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								width: 80,
								editable: false
							}]
						},{
							width: 175,
							layout: 'form',
							
							items: [ {
								xtype: 'checkbox',
								boxLabel:'$SONDER$',
								labelSeparator: '',
								name:'IDC_SPANNWEITE_SONDER_CHECK',
								listeners: {
									'check' : function( combo, checked ) {
										var f = form.getForm();
										var edit = f.findField('IDC_SPANNWEITE_SONDER');
										var combo = f.findField('IDC_SPANNWEITE');
										
										if (checked) {
											combo.disable();
											edit.enable();
										} else {
											combo.enable();
											edit.setValue('');
											edit.disable();
										}
									}
								}
							}] 
						},{
							width: 200,
							layout: 'form',
							items: [{
								xtype: 'numberfield',
								id: 'IDC_SPANNWEITE_SONDER',
								width: 50,
								//disabled: true,
								labelSeparator: '&nbsp;'
							}]
						}]
					}, {
						xtype: 'fieldset',
						width: 600,
						title: '$WERKSTOFF_SCHELLE_LAGER$', 
						bodyStyle:'margin-top: 5px ',
						style:'margin-top: 10px ',
						autoHeight: true,
						//autoWidth: true,
						
						items: [ {
							layout: 'column',
							
							items: [ {
								width: 150,
								layout: 'form',
								hideLabels: true,
								defaultType: 'radio',
								items: [{
                                    id: 'S235 JRG2',
									inputValue: 'S235 JRG2',
									boxLabel:'$S235 JRG2$',
									name:'IDC_WERKSTOFF',
									checked: true
								},{
                                    id: '10CrMo9-10',
									inputValue: '10CrMo9-10',
									boxLabel:'$10CrMo9-10$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X10CrMoVNb9-1',
									inputValue: 'X10CrMoVNb9-1',
									boxLabel:'$X10CrMoVNb9-1$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X5CrNi18-10',
									inputValue: 'X5CrNi18-10',
									//boxLabel:'$X5CrNi18-10$',
									name:'IDC_WERKSTOFF',
									hidden: true
								}]
							},{
								width: 150,
								layout: 'form',
								hideLabels: true,
								defaultType: 'radio',
								items: [{
                                    id: '16Mo3',
									inputValue: '16Mo3',
									boxLabel:'$16Mo3$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X6CrNiTi18-10',
									inputValue: 'X6CrNiTi18-10',
									boxLabel:'$X6CrNiTi18-10$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X5CrAITi31-20',
									inputValue: 'X5CrAITi31-20',
									boxLabel:'$X5CrAITi31-20$',
									name:'IDC_WERKSTOFF'
								}]
							},{
								width: 150,
								layout: 'form',
								hideLabels: true,
								defaultType: 'radio',
								items: [{
                                    id: '13CrMo4-5',
									inputValue: '13CrMo4-5',
									boxLabel:'$13CrMo4-5$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X6CrNiMoTi17-12-2',
									inputValue: 'X6CrNiMoTi17-12-2',
									boxLabel:'$X6CrNiMoTi17-12-2$',
									name:'IDC_WERKSTOFF'
								},{
                                    id: 'X8CrNiTi18-10',
									inputValue: 'X8CrNiTi18-10',
									boxLabel:'$X8CrNiTi18-10$',
									name:'IDC_WERKSTOFF'
								}]
							}]
						}]
					}]
				});
				
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx, form);
				cp.doLayout();
				
				Ext.DomHelper.insertAfter('IDC_TEMPERATUR_MEDIUM', {tag:'span', html:'&nbsp;&deg;C'});
				//Ext.DomHelper.insertAfter('IDC_TEMPERATUR_UMGEBUNG', {tag:'span', html:'&nbsp;&deg;C'});
				//Ext.DomHelper.insertAfter('IDC_TEMPERATUR_REFERENZ', {tag:'span', html:'&nbsp;&deg;C'});
				Ext.DomHelper.insertAfter('IDC_AUSSENDURCHMESSER_SONDER', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_SPANNWEITE_SONDER', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_DAEMMDICKE', {tag:'span', html:'&nbsp;mm'});
				//Ext.DomHelper.insertAfter('IDC_AUSSENDURCHMESSER', {tag:'span', html:'&nbsp;mm'});
				//Ext.DomHelper.insertAfter('IDC_SPANNWEITE', {tag:'span', html:'&nbsp;mm'});
			}
			
			form.getForm().reset();
			form.load({ url: 'sollwerte-rohrumschliessendes-teil/get-values' });
			Ext.getCmp('move-next').enable();
		},
		
		toggleCombo : function(combo, record, idx) {
			
			if ( combo.hiddenName == 'IDC_NENNWEITE_DN' ) {
				form.findField('IDC_AUSSENDURCHMESSER').setValue(aussendurchmesser[idx][1]);
			} else {
				form.findField('IDC_NENNWEITE_DN').setValue(nennweiten[idx][1]);
			}
		},
        
		onMediumTemperaturChange: function( field, newValue, oldValue )
        {
            var UmgebungTemp = 0;   // wird aktuell nicht gebraucht
            var tf1 = 1;
            var tf2 = 0;
            var tf3 = -20;
            var Reftemp = 0;

            /* Regel nach VGB:
                Wenn Medium-Temp < 20C:  			Reftemp = Medium-Temp
                Wenn Medium-Temp zwischen 20 und 40C: 	Reftemp = 20C
                Wenn Medium-Temp > 350C			Reftemp = Medium-Temp
            */
            if ((newValue < 20) || (newValue > 350))
                Reftemp = newValue;
            else if ((newValue >= 20) && (newValue <= 40))
                Reftemp = 20;
            else
                Reftemp = tf1 * newValue + tf2 * UmgebungTemp + tf3;
                
			form.getForm().findField('IDC_TEMPERATUR_REFERENZ').setValue(Reftemp);
            Cascade.panel.sollwerte_rohrumschliessendes_teil.onReferenzTemperaturChange( null, Reftemp, 0 );
        },
        
        setWerkstoffe: function(response, options)
        {
            var result = Ext.util.JSON.decode(response.responseText);
            // die ganze Group erstmal enablen ... 
            form.getForm().findField( 'S235 JRG2' ).enableGroup();

            if ( typeof result.disabled != "undefined" ) 
            {
                for ( var i=0, len = result.disabled.length; i < len; ++i) 
                {
                    form.getForm().findField( result.disabled[i] ).disable();
                }
            }
            if ( typeof result.recommended != "undefined" ) 
            {
                form.getForm().findField(result.recommended).setValue('true');
            }
        },
        
		onReferenzTemperaturChange: function( field, newValue, oldValue ) 
        {
			var medienTemp = form.getForm().findField('IDC_TEMPERATUR_MEDIUM').getValue();
            var actWerkstoff = form.getForm().findField('IDC_WERKSTOFF').getGroupValue();
            
			Ext.Ajax.request({ 
				url: 'sollwerte-rohrumschliessendes-teil/get-referenz-temperatur-values',
				params : { 
					refTemp: newValue, 
                    medienTemp: medienTemp,
                    actWerkstoff: actWerkstoff
				}, 
				success: Cascade.panel.sollwerte_rohrumschliessendes_teil.setWerkstoffe 
			});
		},
        
        /**
         * Form after Action
         */
         onActionComplete: function(form, action) {
			var Reftemp = form.findField('IDC_TEMPERATUR_REFERENZ').getValue();
            Cascade.panel.sollwerte_rohrumschliessendes_teil.onReferenzTemperaturChange( null, Reftemp, 0 );
            
            Cascade.app.getNextPanel(form,action);
         }
	}
}();