Cascade.panel.sollwerte_halterungspunkt = function()
{
	var form;
    var myCm;
    var myStore;
    var myCellRenderer;

    //define a renderer to pass into the column model config later
    myCellRenderer = function(value, metaData, record, rowIndex, colIndex, store) {
        //current value of cell = value
        //previous value of cell:
        if ((colIndex == 1) && (record.get('xDisabled') == 1)) 
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
        if ((colIndex == 2) && (record.get('yDisabled') == 1)) 
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
        if ((colIndex == 3) && (record.get('zDisabled') == 1))
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
         
        //metaData.css: String: A CSS class name to add to the cell's TD element.
       //metaData.attr: String: An html attribute definition string to apply to
       //                         the data container element within the table
       //                         cell (e.g. 'style="color:red;"').
       // metaData.css = 'name-of-css-class-you-will-define';
      return value;
    };

    myCm = new Ext.grid.ColumnModel(
        [{
            header: "&nbsp;",
            dataIndex: 'beschriftung',
            width: 160
        },{
            header: "$X_RICHTUNG$",
            dataIndex: 'x_richtung',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "$Y_RICHTUNG$",
            dataIndex: 'y_richtung',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "$Z_RICHTUNG$",
            dataIndex: 'z_richtung',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "&nbsp;",
            dataIndex: 'einheit',
            width: 60
        }]
    );
    
    myCm.isCellEditable = function(col, row) {
        var field = this.getDataIndex(col);
        var record = myStore.getAt(row);

        if ((field == 'x_richtung') && (record.get('xDisabled') == 1)) 
            return false;
        if ((field == 'y_richtung') && (record.get('yDisabled') == 1)) 
            return false;
        if ((field == 'z_richtung') && (record.get('zDisabled') == 1)) 
            return false;

        return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
    };
	
	return {
		init: function(idx) {
			if (!form) {

                myStore = new Ext.data.JsonStore({
								url: 'sollwerte-halterungspunkt/get-table',
								root: 'rows',
								fields: [
									'idx', 
									'beschriftung', 
									{name:'x_richtung', type: 'float'}, 
									{name:'y_richtung', type: 'float'},
									{name:'z_richtung', type: 'float'},
									'einheit',
                                    'xDisabled',
                                    'yDisabled',
                                    'zDisabled'
								]
								
						});
                        
				form = new Ext.FormPanel({
					id: 'sollwerte_halterungspunkt',
					url: 'sollwerte-halterungspunkt/set-values',
					title: '$SOLLWERTE_HALTERUNGSPUNKT$',
					
					frame:true,
					width: 350,
					labelWidth: 200, // label settings here cascade unless overridden
					bodyStyle: 'padding:5px 5px 0',
					
					baseParams: { 
						__STORE_PATH__ : 'DLGDATA.CA.FORMS.SOLLWERTE_HALTERUNGSPUNKT' 
					},
					
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel,
						'beforeaction': this.onBeforeAction
					},
					
					layout:'table',
					layoutConfig: {
					columns: 2
					},
					
					items: [{
						xtype: 'editorgrid',
						id: 'SWHP_GRID',
						clicksToEdit: 1,
						width: 550,
						//height:220,
						height:285,
						frame:true,
						store: myStore,
                        cm:  myCm,
						colspan: 2
					}/*,{
						xtype:'fieldset',
						//autoWidth: true,
						width: 180,
						title: '$IDC_LABEL_RICHTUNG_BEWEGUNG$',
						autoHeight: true,
						defaultType: 'radio',
						hideLabels: true,
						style: 'padding: 5px',
						items: [
						{
							boxLabel:'$IDC_LABEL_RICHTUNG_AUF$',
							name:'IDC_RICHTUNG_BEWEGUNG',
							inputValue: 'AUF',
							id: 'IDC_RICHTUNG_BEWEGUNG_AUF'
						},
						{
							boxLabel:'$IDC_LABEL_RICHTUNG_AB$',
							name:'IDC_RICHTUNG_BEWEGUNG',
							inputValue: 'AB',
							id: 'IDC_RICHTUNG_BEWEGUNG_AB'
						}]
                    }*/,{
						xtype:'fieldset',
						//autoWidth: true,
						width: 180,
						title: '$IDC_LABEL_SOLLAST_IST$',
						//autoHeight: true,
						height: 50,
						defaultType: 'radio',
						hideLabels: true,
						style: 'padding: 5px',
						items: [
						{
							boxLabel:'$IDC_LABEL_KALTLAST$',
							name: 'IDC_SOLLAST_IST',
							inputValue: 'KALT',
							id: 'IDC_SOLLAST_IST_KALT'
						},
						{
							boxLabel:'$IDC_LABEL_WARMLAST$',
							name: 'IDC_SOLLAST_IST',
							inputValue: 'WARM',
							id: 'IDC_SOLLAST_IST_WARM'
						}]
                    },/*{
						xtype: 'fieldset',
						style: 'padding: 5px',
						autoWidth: true,
						autoHeight: true,
						hidden: false,
						//hidden: true,
						defaultType: 'textfield',
						hideLabels: true,
						//disabled: true,
						items: [{
								id: 'Z_LAST_EG',
								name: 'Z_LAST_EG'
								}]
					},*/{
						xtype: 'hidden',
						id: "IDC_TABLE",
						hidden: true,
						inputType: 'text'
					}]
				});
				var cp = Ext.getCmp('center-panel');
				
				cp.insert(idx,form);
				cp.doLayout();
			}
			
			Ext.getCmp('SWHP_GRID').getStore().load();
			form.getForm().reset();
			form.load({url: 'sollwerte-halterungspunkt/get-values'});
			Ext.getCmp('move-next').enable();
		},
		
		// Collect Grid Data and serialize it to JSON perhaps a reasonable extension for Ext
		onBeforeAction : function(form, action) 
		{
			if ( action.type == "submit" ) {
				// var ds = Ext.getCmp('SWHP_GRID').getStore();
                var ds = myStore;
			
				var count = ds.getCount();
				var values = {};
				
				for ( var i=0; i < count; i++ ) {
					var record = ds.getAt(i);
					var idx = record.get('idx');
					values[idx] = [record.get('x_richtung'), record.get('y_richtung'), record.get('z_richtung') ];
				}
				
				var json = Ext.util.JSON.encode( values );
				// alert( json );
                // debugger; 
				form.findField('IDC_TABLE').setValue( json );
				ds.commitChanges();
			}
		},
	}
}();