/**
 * Cascade Clientseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category UI
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
Cascade.panel.lager_konfiguration = function() 
{
	// Basisform
	var _form;
	// Daten fr die Combobox 'Profilart'
	var _storeProfilart;
	// Daten fr die Combobox 'Trgergre'
	var _storeTraegergroesse;
	
	/**
	 * setze den Lagertyp
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeTyp( response )
	{
		var strText = response.data.strLagerTyp;
		Ext.getCmp( 'IDC_TYP_TEXT' ).body.update( '<label class="x-form-item-label" >' + strText + '</label>' );
	}
	
	/**
	 * setze das Bild fr den Lagertyp
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeBild( response )
	{
		// setze das Bild
		var strFile = 'catalog/client/custom/img/WITgifs/RH/' + response.data.strLagerBild;
		//Ext.getCmp( 'IDC_LAGER_KONFIG_IMAGE' ).body.update( '<img src="' + strFile + '" />' );
		Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="' + strFile + '" /></center>' );
	}
	
	/**
	 * setze die mglichen Profilarten
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeProfilarten( response )
	{
		var cbProfilarten = _form.getForm().findField( 'IDC_PROFILART' );
		var newStore = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data: response.data.profilarten
		} );
		cbProfilarten.bindStore( newStore );
		cbProfilarten.setValue( response.data.IDC_PROFILART );
	}
	
	/**
	 * setze die mglichen Trgergren
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeTraegergroessen( response )
	{
		var cbTraegergroessen = _form.getForm().findField( 'IDC_TRAEGERGROESSE' );
		var newStore = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data: response.data.traegergroessen
		} );
		cbTraegergroessen.bindStore( newStore );
		cbTraegergroessen.setValue( response.data.IDC_TRAEGERGROESSE );
	}
	
	/**
	 * setze die Trgerdaten fr die aktuelle Trgergre, also Trgerhhe, Trgerbreite und Flanschdicke
	 * sie werden nach einem Submit nicht automatisch neu gesetzt; ein neues 'load' spare ich mir besser
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeTraegerdaten( response )
	{
		var f = _form.getForm();
		f.findField( 'IDC_TRAEGERHOEHE' ).setValue( response.data.IDC_TRAEGERHOEHE );
		f.findField( 'IDC_TRAEGERBREITE' ).setValue( response.data.IDC_TRAEGERBREITE );
		f.findField( 'IDC_FLANSCHDICKE' ).setValue( response.data.IDC_FLANSCHDICKE );
	}
	
	/**
     * initialisiere die Datenstrukturen fr die Comboboxen
	 *
	 * @params -
	 * @returns	-
	 */
	function _initStaticData()
	{
		// Daten fr die Combobox 'Profilart'
		_storeProfilart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		// Daten fr die Combobox 'Trgergre'
		_storeTraegergroesse = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
	}
	
	// public functions
	return {
		init: function( idx ) 
		{
			if ( !_form ) 
			{
				// private Daten fr Comboboxen etc. initialisieren
				_initStaticData();
				
				// UI erzeugen
				_form = new Ext.FormPanel( 
				{
					url:'lager_konfiguration/set-values',
					frame: true,
					labelAlign: 'top',
					title: '$LAGER_KONFIGURATION$',
					id: 'lager_konfiguration',
					bodyStyle:'padding:5px 5px 0',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.LAGER_KONFIGURATION' },
					listeners: 
					{
						'actioncomplete': this.onActionComplete
					},
					
					items: [ 
					{
						layout: 'column',
						items: [
						{
							//width: 200, 
							layout: 'form',
							items: [
							{
								xtype: 'combo',
								hiddenName:'IDC_PROFILART',
								fieldLabel: '$IDC_PROFILART_RH_LABEL$',
								labelWidth: 180,
								store: _storeProfilart,
								listeners: {
									'select' : this.onChangedProfilart 
								},
								displayField: 'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
								listWidth: 130,
								editable: false
							},
							{
								xtype: 'combo',
								hiddenName:'IDC_TRAEGERGROESSE',
								fieldLabel: '$IDC_TRAEGERGROESSE_LABEL$',
								style: 'margin-bottom:15px',
								labelWidth: 160,
								store: _storeTraegergroesse,
								listeners: {
									'select' : this.onChangedTraegergroesse
								},
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 80,
								listWidth: 80,
								editable: false
							},
							{
								layout: 'column',
								items: [
								{
									layout: 'form',
									width: 140,
									items: [								
									{
										xtype:'numberfield',
										id: 'IDC_TRAEGERHOEHE',
										fieldLabel: '$IDC_TRAEGERHOEHE_LABEL$',
										width: 80,
										disabled: true,
										name: 'IDC_TRAEGERHOEHE'
									} ]
								},
								{
									layout: 'form',
									width: 140,
									items: [								
									{
										xtype:'numberfield',
										id: 'IDC_TRAEGERBREITE',
										fieldLabel: '$IDC_TRAEGERBREITE_LABEL$',
										width: 80,
										disabled: true,
										name: 'IDC_TRAEGERBREITE'
									} ]
								} ]
							},
							{
								xtype:'numberfield',
								id: 'IDC_FLANSCHDICKE',
								fieldLabel: '$IDC_FLANSCHDICKE_LABEL$',
								width: 80,
								disabled: true,
								name: 'IDC_FLANSCHDICKE'
							} ]
						},
						{
							layout: 'form',
							items: [
							{
								// ein Label, nur ein Label und sonst nichts
								xtype: 'panel',
								id: 'IDC_TYP_TEXT',
								style: 'margin-left:30px;width:auto;font-size:12px;',
								html: '<label class="x-form-item-label" >Typ:</label>'
							},
							{
								xtype: 'panel',
								id: 'IDC_LAGER_KONFIG_IMAGE',
								style: 'margin-left: 30px; margin-top:20px',
								html: '<img src="catalog/client/custom/img/WITgifs/RH/blank.png" />'
							} ]
						} ]
					} ]
                } );
				
				// insert panel into main form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, _form );
				cp.doLayout();
				
				// insert labels
				Ext.DomHelper.insertAfter( 'IDC_TRAEGERHOEHE', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_TRAEGERBREITE', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_FLANSCHDICKE', { tag:'span', html:'&nbsp;[mm]' } );				
			}
			
			_form.getForm().reset();
			_form.load( 
			{ 
				url: 'lager-konfiguration/get-values',
 				success: function( response, options ) 
				{
					_setzeTyp( options.result );
					_setzeBild( options.result );
					_setzeProfilarten( options.result );
					_setzeTraegergroessen( options.result );
				}
			} );
			Ext.getCmp( 'move-next' ).enable();
		},
		
		/**
		 * Event, wenn ein Ajax-Request vollstndig bearbeitet ist
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
        onActionComplete : function( form, action ) 
		{
			// das Panel soll nur dann gewechselt werden, wenn der Submit wegen Click des 'next' Buttons erfolgt ist
			if ( action.options.url == form.url )
				Cascade.app.getNextPanel( form, action );
		},
		
		/**
		 * Event, wenn die Profilart gewechselt wurde
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
        onChangedProfilart : function( combo, record, idx ) 
		{
			// hole neue Trgergrssen, Trgerdaten und den aktuellen Lagertyp
			_form.getForm().submit(
			{
				url : 'lager-konfiguration/hole-traegergroessen',
				success: function( response, options ) 	// wenn das Load ein Submit auslsen wrde, knnte man sich vieles sparen
				{
					_setzeTyp( options.result );
					_setzeBild( options.result );
					_setzeTraegergroessen( options.result );
					_setzeTraegerdaten( options.result );
				}
			} );
		},

		/**
		 * Event, wenn die Trgergre gewechselt wurde
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
        onChangedTraegergroesse : function( combo, record, idx ) 
		{
			// hole neue Trgerdaten fr die aktuelle Trgergre und den aktuellen Lagertyp
			_form.getForm().submit(
			{
				url : 'lager-konfiguration/hole-traegerdaten',
				success: function( response, options )	// wenn das Load ein Submit auslsen wrde, knnte man sich vieles sparen
				{
					_setzeTyp( options.result );
					_setzeBild( options.result );
					_setzeTraegerdaten( options.result );
				}
			} );
		}
	}
}();
