/**
 * Cascade Clientseitige Logik
 * 
 * Copyright (c) 2008-2009 Plan Software GmbH
 *
 * @category UI
 * @package    
 * @copyright  Copyright (c) 2008-2009 Plan Software GmbH (http://www.plansoft.de)
 */
 
Cascade.panel.lager_hoeheneingaben = function() 
{
	var _form;
	var _dMin, _dMax, _dHori, _dEori; 
	var _strMessage;
	
	return {
		init: function( idx ) 
		{
			// generate dialog
			if ( !_form ) 
			{
				_form = new Ext.FormPanel( 
				{
					url:'lager_hoeheneingaben/set-values',
					
					title: '$LAGER_HOEHENEINGABEN$',
					id: 'lager_hoeheneingaben',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.LAGER_HOEHENEINGABEN' },
					listeners: 
					{
						'actioncomplete': Cascade.app.getNextPanel,
						'beforeaction': this.onBeforeAction
					},
					
					frame: true,
					labelAlign: 'center',
					bodyStyle:'padding-left:15px;padding-top:30px',
					labelStyle: 'font-size:11px',

					items: [ 
					{
						layout: 'form',
						items: [
                        {
                            xtype: 'fieldset',
                            autoHeight: true,
                            width: 350,
                            title: '',
                            defaultType: 'numberfield',
                            style: 'margin-top: 21px',
                            items: [
                            {
                                xtype: 'numberfield',
                                id: 'IDC_HOEHEN_ACT',
                                labelStyle: 'width: 200px;',
                                fieldLabel: '$IDC_HOEHEN_ACT_LABEL$',
                                style: 'margin-left: -30px',
                                width: 50,
                                name: 'IDC_HOEHEN_ACT',
                                listeners: {
                                    'change': this.onHoeheChange
                                }
                            },
                            {
                                xtype: 'textfield',
                                id: 'IDC_HOEHEN_MINMAX',
                                labelStyle: 'width: 200px;',
                                fieldLabel: '$IDC_HOEHEN_MINMAX_LABEL$',
                                style: 'margin-left: -30px',
                                disabled: true,
                                width: 100,
                                name: 'IDC_HOEHEN_MINMAX'
                            } ]
                        },
                        {
                            xtype: 'fieldset',
                            autoHeight: true,
                            width: 350,
                            title: '',
                            defaultType: 'numberfield',
                            style: 'margin-top: 21px',
                            items: [
                            {
                                xtype: 'numberfield',
                                id: 'IDC_EMASS_ACT',
                                labelStyle: 'width: 200px;',
                                fieldLabel: '$IDC_EMASS_ACT_LABEL$',
                                style: 'margin-left: -30px',
                                width: 50,
                                name: 'IDC_EMASS_ACT',
                                listeners: {
                                    'change': this.onEmassChange
                                }
                            },
                            {
                                xtype: 'textfield',
                                id: 'IDC_EMASS_MINMAX',
                                labelStyle: 'width: 200px;',
                                fieldLabel: '$IDC_EMASS_MINMAX_LABEL$',
                                style: 'margin-left: -30px',
                                disabled: true,
                                width: 100,
                                name: 'IDC_EMASS_MINMAX'
                            }]
                        }]
					} ]
                });
				
				// insert panel into main form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, _form );
				cp.doLayout();

				Ext.DomHelper.insertAfter('IDC_HOEHEN_ACT', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_HOEHEN_MINMAX', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_EMASS_ACT', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_EMASS_MINMAX', {tag:'span', html:'&nbsp;mm'});
			}
			
			_form.getForm().reset();
			_form.load( { url: 'lager-hoeheneingaben/get-values',
 				success: function( response, options ) 
				{
					_dMin = options.result.data.strMin - 0;
					_dMax = options.result.data.strMax - 0;
					_dHori = options.result.data.strHori - 0;
					_dEori = options.result.data.strEori - 0;
					_strMessage = options.result.data.msgBereich;
				}
            } );
			Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="catalog/client/custom/img/WITgifs/RH/blank.png" /></center>' );
			Ext.getCmp( 'move-next' ).enable();
		},

		onHoeheChange: function( field, newValue, oldValue )
        {
            var diff = newValue - _dHori;
            var newEmass = _dEori + diff;
            // alert(newEmass);
			_form.getForm().findField('IDC_EMASS_ACT').setValue(newEmass);
        },

		onEmassChange: function( field, newValue, oldValue )
        {
            var diff = newValue - _dEori;
            var newHoehe = _dHori + diff;
            // alert(newHoehe);
			_form.getForm().findField('IDC_HOEHEN_ACT').setValue(newHoehe);
        },
		
		/**
		 * Event, der aufgerufen wird, bevor ein Ajax-Request ausgelst wird
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
		onBeforeAction : function( form, action ) 
		{
			if ( action.type == 'submit'  ) 
			{
				// der Submit wegen Click des 'next' Buttons soll nur dann erfolgen, wenn die eingegebene Hhe im zulssigen Bereich ist
				if ( action.options.url == form.url )
				{
					var dAct = form.findField( 'IDC_HOEHEN_ACT' ).getValue() - 0;
					if ( ( _dMin > dAct ) || ( _dMax < dAct ) )
					{
						Ext.Msg.alert( '', _strMessage );
						return( false );
					}
				}
			}
		}
	}
}();
