/**
 * Cascade Clientseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category UI
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
Cascade.panel.lager_betriebsbedingungen = function() 
{
	var _form;
	
	function _enableFields( strStuetzRicht )
	{
		var bDisableWX = ((strStuetzRicht == "MI_X") ||(strStuetzRicht == "PL_X"));
		var bDisableWY = ((strStuetzRicht == "MI_Y") ||(strStuetzRicht == "PL_Y"));
		var bDisableWZ = ((strStuetzRicht == "MI_Z") ||(strStuetzRicht == "PL_Z"));
		
		_enableField( 'IDC_WX_PLUS', !bDisableWX );
		_enableField( 'IDC_WX_MINUS', !bDisableWX );
		_enableField( 'IDC_WY_PLUS', !bDisableWY );
		_enableField( 'IDC_WY_MINUS', !bDisableWY );
		_enableField( 'IDC_WZ_PLUS', !bDisableWZ );
		_enableField( 'IDC_WZ_MINUS', !bDisableWZ );
	}
	
	function _enableField( strID, bEnable )
	{
		var openMode = '$*.OPEN_MODE_CASCADE$';
		var field = _form.getForm().findField( strID );
		if ( field )
		{
			if ( bEnable )
				field.enable();
			else 
			{
				field.disable();
				if (openMode == 'LAGER')
					field.setValue('');
			}
		}
	}
	
	return {
		init: function( idx ) 
		{
			// generate dialog
			if ( !_form ) 
			{
				_form = new Ext.FormPanel( 
				{
					url:'lager-betriebsbedingungen/set-values',
					
					title: '$LAGER_BETRIEBSBEDINGUNGEN$',
					id: 'lager_betriebsbedingungen',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.LAGER_BETRIEBSBEDINGUNGEN' },
					listeners: 
					{
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					frame: true,
					labelAlign: 'center',
					bodyStyle:'padding-left:15px;padding-top:30px',
					labelStyle: 'font-size:11px',

					items: [ 
					{
						layout: 'column',
						items: [
						{
							layout: 'form',
							items: [
							{
								xtype:'numberfield',
								id: 'IDC_TEMPERATUR_TS',
								labelStyle: 'width: 110px;margin-left: 10px;margin-bottom:10px',
								fieldLabel: '$IDC_TEMPERATUR_TS_LABEL$',
								style: 'margin-left: -20px',
								width: 50,
								name: 'IDC_TEMPERATUR_TS',
								minValue : -274
							},
							{
								xtype:'numberfield',
								id: 'IDC_DAEMMDICKE_LAGER',
								labelStyle: 'width: 110px;margin-left: 10px;',
								fieldLabel: '$IDC_DAEMMDICKE_LABEL$',
								style: 'margin-left: -20px',
								width: 50,
								name: 'IDC_DAEMMDICKE_LAGER',
								minValue: 0,
								minText: '$ID_ERRORMESSAGE_DAEMM0$'
							},
							{
								xtype: 'fieldset',
								autoHeight: true,
								width: 210,
								title: '$IDC_VERSCHIEBUNGEN_LABEL$',
								defaultType: 'numberfield',
								style: 'margin-top: 21px',
								items: [
								{
									id: 'IDC_WX_PLUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WX_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WX_PLUS'
								},
								{
									id: 'IDC_WX_MINUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WX_MINUS_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WX_MINUS'
								},
								{
									id: 'IDC_WY_PLUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WY_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WY_PLUS'
								},
								{
									id: 'IDC_WY_MINUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WY_MINUS_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WY_MINUS'
								},
								{
									id: 'IDC_WZ_PLUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WZ_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WZ_PLUS'
								},
								{
									id: 'IDC_WZ_MINUS',
									labelStyle: 'width: 110px;',
									fieldLabel: '$IDC_VERSCH_WZ_MINUS_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_WZ_MINUS'
								} ]
							} ]
						},
						{
							layout: 'form',
							items: [
							{
								xtype: 'fieldset',
								autoHeight: true,
								width: 210,
								title: '$IDC_BELASTUNG_LABEL$',
								defaultType: 'numberfield',
								style: 'margin-left: 20px',
								items: [
								{
									id: 'IDC_FX',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_LAST_FX_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_FX',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								},
								{
									id: 'IDC_MINUS_FX',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_MINUS_FX_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_MINUS_FX',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								},
								{
									id: 'IDC_FY',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_LAST_FY_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_FY',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								},
								{
									id: 'IDC_MINUS_FY',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_MINUS_FY_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_MINUS_FY',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								},
								{
									id: 'IDC_FZ',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_LAST_FAB_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_FZ',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								},
								{
									id: 'IDC_MINUS_FZ',
									labelStyle: 'width: 70px;',
									fieldLabel: '$IDC_LAST_FZ_LABEL$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_MINUS_FZ',
									minValue : 0,
									minText: '$ID_ERRORMESSAGE_BELASTUNG0$'
								}]
							}]
						},
						{
							layout: 'form',
							items: [
							{
								xtype: 'fieldset',
								autoHeight: true,
								width: 210,
								title: '$EINFUEGEPUNKT_ROHRMITTE$',
								defaultType: 'numberfield',
								style: 'margin-left: 20px',
								items: [
								{
									id: 'IDC_LAGER_ROHRM_X',
									labelStyle: 'width: 110px;',
									fieldLabel: '$X$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_LAGER_ROHRM_X'
								},
								{
									id: 'IDC_LAGER_ROHRM_Y',
									labelStyle: 'width: 110px;',
									fieldLabel: '$Y$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_LAGER_ROHRM_Y'
								},
								{
									id: 'IDC_LAGER_ROHRM_Z',
									labelStyle: 'width: 110px;',
									fieldLabel: '$Z$',
									style: 'margin-left: -20px',
									width: 50,
									name: 'IDC_LAGER_ROHRM_Z'
								} ]
							},{
								xtype: 'fieldset',
								//layout: 'column',
								autoHeight: true,
								autoWidth: true,
								title: '$STUETZRICHTUNG$',
								style: 'margin-left: 20px; padding: 5px',
								defaultType: 'radio',
								hideLabels: true,
								items: [
								{
									boxLabel:'$IDC_DIR_POSITIV$ $X_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'PL_X',
									id: 'IDC_STUETZRICHTUNG_IST_PL_X',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								},
								{
									boxLabel:'$IDC_DIR_NEGATIV$ $X_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'MI_X',
									id: 'IDC_STUETZRICHTUNG_IST_MI_X',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								},{
									boxLabel:'$IDC_DIR_POSITIV$ $Y_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'PL_Y',
									id: 'IDC_STUETZRICHTUNG_IST_PL_Y',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								},
								{
									boxLabel:'$IDC_DIR_NEGATIV$ $Y_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'MI_Y',
									id: 'IDC_STUETZRICHTUNG_IST_MI_Y',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								},{
									boxLabel:'$IDC_DIR_POSITIV$ $Z_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'PL_Z',
									id: 'IDC_STUETZRICHTUNG_IST_PL_Z',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								},
								{
									boxLabel:'$IDC_DIR_NEGATIV$ $Z_RICHTUNG$',
									name: 'IDC_STUETZRICHTUNG_IST',
									inputValue: 'MI_Z',
									id: 'IDC_STUETZRICHTUNG_IST_MI_Z',
									style: 'margin: 0 20px 0 10px',
									listeners: {
                                    'check': this.stuetzrichtungClicked
									}
								} ]
							}]
						}/*,
						{
							xtype: 'panel',
							id: 'IDC_FORCES_IMAGE',
							style: "margin-left: 25px; margin-top:15px",
							html: '<img src="catalog/client/custom/img/RH_KOORD_mit_Rohr.jpg" />'
						}*/ ]
					} ]
                });
				
				// insert panel into main form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, _form );
				cp.doLayout();

				// insert labels
				Ext.DomHelper.insertAfter( 'IDC_TEMPERATUR_TS', { tag:'span', html:'&nbsp;[&deg;C]' } );
				Ext.DomHelper.insertAfter( 'IDC_DAEMMDICKE_LAGER', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WX_PLUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WY_PLUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WZ_PLUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WX_MINUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WY_MINUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_WZ_MINUS', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_MINUS_FZ', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_FZ', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_MINUS_FX', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_FX', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_MINUS_FY', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_FY', { tag:'span', html:'&nbsp;[kN]' } );
				Ext.DomHelper.insertAfter( 'IDC_LAGER_ROHRM_X', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_LAGER_ROHRM_Y', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_LAGER_ROHRM_Z', { tag:'span', html:'&nbsp;[mm]' } );
			}
			
			/*_form.getForm().reset();
			_form.load( { url: 'lager-betriebsbedingungen/get-values',
 				success: function( response, options ) 
				{
                    var f = _form.getForm();
                    var cbFZ        = f.findField( 'IDC_FZ' );
                    var cbMinusFZ   = f.findField( 'IDC_MINUS_FZ' );
                    var cbWX        = f.findField( 'IDC_WX' );
                    var cbWY        = f.findField( 'IDC_WY' );

                    var cbRX        = f.findField( 'IDC_LAGER_ROHRM_X' );
                    var cbRY        = f.findField( 'IDC_LAGER_ROHRM_Y' );
                    var cbRZ        = f.findField( 'IDC_LAGER_ROHRM_Z' );
                    if (options.result.data.strAuswahlKontext != "EINZEL_LAGER")
                    {
                        cbFZ.disable();
                        cbMinusFZ.disable();
                        cbRX.disable();
                        cbRY.disable();
                        cbRZ.disable();
                    }
                    else
                    {
                        cbFZ.enable();
                        cbMinusFZ.enable();
                        cbRX.enable();
                        cbRY.enable();
                        cbRZ.enable();
                    }
                    if (options.result.data.strAuswahlKontext == "TRAVERSE")
                    {
                        cbWX.disable();
                        cbWY.disable();
                    }
                    else
                    {
                        cbWX.enable();
                        cbWY.enable();
                    }
				}
            } );*/
			_form.getForm().reset();
			_form.load(
			{ 
				url: 'lager-betriebsbedingungen/get-values',
				success: function( response, options)
				{
					_enableFields(_form.getForm().findField('IDC_STUETZRICHTUNG_IST_PL_X').getGroupValue());
				}
			} );
			Ext.getCmp( 'move-next' ).enable();
		},
		
		stuetzrichtungClicked : function(clickedObject, bChecked )
		{
            // dieser Check ist unbedingt notwendig, weil das Event zig mal und in
            // seltsamen Kontexten gefeuert wird ...
            if (!bChecked)
                return;
			var valSR	= clickedObject.inputValue;
			_enableFields( valSR );
		}
	}
}();
