/**
 * Cascade Clientseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category UI
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
Cascade.panel.lager_auswahl = function() 
{
	// Basisform
	var _form;
	// Tabelle fr Resultate eines Suchvorganges
	var _table;
	// Daten fr die Combobox 'Lagerart'
	var _storeLagerart;
	// Daten fr die Combobox 'Gleitart fr Los- und Fhrungslager'
	var _storeGleitart;
	// Daten fr die Combobox 'Gleitelement fr Los- und Fhrungslager'
	var _storeGleitelement;
	// Daten fr die Combobox 'Leitungsart fr Festlager'
	var _storeLeitungsart;
	// Daten fr die Combobox 'Art der Rohrsttze'
	var _storeRohrstuetzenart;
	// Daten fr die Combobox 'Isolierung'
	var _storeIsolierung;
	// Daten fr die Combobox 'Werkstoff'
	var _storeWerkstoff;
	// Daten fr die Combobox 'Nennweiten'
	var _storeNennweite;
	// Daten fr die Combobox 'Auendurchmesser'
	var _storeAussendurchmesser;
	// Daten fr Combobox 'Manteldurchmesser'
	var _dataManteldurchmesser;
	// Daten aus dem BetriebsbedingungenDialog
	var _betriebsbedingungen;
	// Meldungstexte
	var _meldungen;
	// wenn dieser Wert true ist, werden 'check' events fr Checkboxen nicht verarbeitet (diese werden jedesmal abgesetzt, wenn 
	// der Wert der Checkbox gendert wird, egal, ob durch einen Klick oder durch Setzen im Script
	var _bCheckboxHandlerNichtAktivieren;
    
    var _strAuswahlKontext = 'EINZEL_LAGER';
	
	/**
     * initialisiere die Datenstrukturen fr die Comboboxen
	 *
	 * @params -
	 * @returns	-
	 */
	function _initStaticData()
	{
		// Daten fr die Combobox 'Lagerart'
		_storeLagerart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_LOSLAGER', '$ID_LOSLAGER$' ],
				[ 'ID_FUEHRUNGSLAGER', '$ID_FUEHRUNGSLAGER$' ],
                [ 'ID_FUEHRUNGSLAGER_W', '$ID_FUEHRUNGSLAGER_W$' ], // Schmidsberger
				[ 'ID_FESTLAGER', '$ID_FESTLAGER$' ],
				[ 'ID_LEER', '--------------------------' ],
				[ 'ID_FUEHRUNG_W2_180', '$ID_FUEHRUNG_W2_180$' ],
				[ 'ID_FUEHRUNG_W2_180_PLUS', '$ID_FUEHRUNG_W2_180_PLUS$' ],
				[ 'ID_FUEHRUNG_W2_090', '$ID_FUEHRUNG_W2_090$' ],
				[ 'ID_FUEHRUNG_W3', '$ID_FUEHRUNG_W3$' ],
				[ 'ID_FUEHRUNG_W4', '$ID_FUEHRUNG_W4$' ],
				[ 'ID_LEER', '--------------------------' ],
				[ 'ID_FESTLAGER_D', '$ID_FESTLAGER_D$' ]
			]
		} );
		// Daten fr die Combobox 'Gleitart fr Los- und Fhrungslager'
		_storeGleitart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_EINFACH', '$ID_EINFACH$' ],
				[ 'ID_REIBUNGSARM', '$ID_REIBUNGSARM$' ],
				[ 'ID_GLEITBLECH', '$ID_GLEITBLECH$' ]
			]
		} );
		// Daten fr die Combobox 'Gleitelement fr Los- und Fhrungslager'
		_storeGleitelement = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_OHNE',	'$ID_OHNE$' ],
				[ 'ID_LGA',		'$ID_LGA$' ],
				[ 'ID_LGV',		'$ID_LGV$' ],
				[ 'ID_LGE',		'$ID_LGE$' ]
			]
		} );
		// Daten fr die Combobox 'Leitungsart fr Festlager'
		_storeLeitungsart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_FESTLAGER_HORIZONTAL', '$ID_FESTLAGER_HORIZONTAL$' ]
			]
		} );
		// Daten fr die Combobox 'Art der Rohrsttze'
		_storeRohrstuetzenart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_ROHR_GLATT', '$ID_ROHR_GLATT$' ],
				[ 'ID_ROHR_BOGEN_10D', '$ID_ROHR_BOGEN_10D$' ],
				[ 'ID_ROHR_BOGEN_15D', '$ID_ROHR_BOGEN_15D$' ]
			]
		} );
		// Daten fr die Combobox 'Isolierung'
		_storeIsolierung = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_UNGEDAEMMT', '$IDC_UNGEDAEMMT$' ],
				[ 'ID_WAERMEGEDAEMMT', '$IDC_WAERMEGEDAEMMT$' ],
				[ 'ID_VORISOLIERT', '$IDC_VORISOLIERT$' ]
			]
		} );
		// Daten fr die Combobox 'Werkstoff'
		_storeWerkstoff = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_FERRIT', '$ID_FERRIT$' ],
				[ 'ID_AUSTENIT', '$ID_AUSTENIT$' ]
			]
		} );
		// Daten fr die Combobox 'Nennweiten'
		_storeNennweite = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				['15', '15'],
				['20', '20'],
				['25', '25'],
				['32', '32'],
				['40', '40'],
				['50', '50'],
				['65', '65'],
				['80', '80'],
				['100', '100'],
				['125', '125'],
				['150', '150'],
				['200', '200'],
				['250', '250'],
				['300', '300'],
				['350', '350'],
				['400', '400'],
				['450', '450'],
				['500', '500'],
				['550', '550'],
				['600', '600'],
				['650', '650'],
				['700', '700'],
				['800', '800'],
				['900', '900'],
				['1000', '1000']
			]
		} );		
		// Daten fr die Combobox 'Auendurchmesser'
		_storeAussendurchmesser = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				['21,3', '21,3'],
				['26,9', '26,9'],
				['33,7', '33,7'],
				['42,4', '42,4'],
				['48,3', '48,3'],
				['60,3', '60,3'],
				['76,1', '76,1'],
				['88,9', '88,9'],
				['114,3', '114,3'],
				['139,7', '139,7'],
				['168,3', '168,3'],
				['219,1', '219,1'],
				['273', '273'],
				['323,9', '323,9'],
				['355,6', '355,6'],
				['406,4', '406,4'],
				['457', '457'],
				['508', '508'],
				['559', '559'],
				['610', '610'],
				['660', '660'],
				['711', '711'],
				['813', '813'],
				['914', '914'],
				['1016', '1016']
			]
		} );
		// Daten fr Combobox 'Manteldurchmesser'
		_dataManteldurchmesser = {};
		_dataManteldurchmesser[ '15' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		_dataManteldurchmesser[ '20' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '90', '90' ] ]
		} );
		_dataManteldurchmesser[ '25' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '90', '90' ] ]
		} );
		_dataManteldurchmesser[ '32' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '110', '110' ] ]
		} );
		_dataManteldurchmesser[ '40' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '110', '110' ] ]
		} );
		_dataManteldurchmesser[ '50' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '125', '125' ] ]
		} );
		_dataManteldurchmesser[ '65' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '140', '140' ], [ '160', '160' ] ]
		} );
		_dataManteldurchmesser[ '80' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '160', '160' ], [ '180', '180' ] ]
		} );
		_dataManteldurchmesser[ '100' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '200', '200' ] ]
		} );
		_dataManteldurchmesser[ '125' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '200', '200' ], [ '225', '225' ] ]
		} );
		_dataManteldurchmesser[ '150' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '250', '250' ] ]
		} );
		_dataManteldurchmesser[ '200' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '315', '315' ], [ '355', '355' ], [ '400', '400' ] ]
		} );
		_dataManteldurchmesser[ '250' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '400', '400' ], [ '450', '450' ] ]
		} );
		_dataManteldurchmesser[ '300' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '450', '450' ] ]
		} );
		_dataManteldurchmesser[ '350' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '500', '500' ] ]
		} );
		_dataManteldurchmesser[ '400' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '560', '560' ], [ '600', '600' ] ]
		} );
		_dataManteldurchmesser[ '450' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '630', '630' ] ]
		} );
		_dataManteldurchmesser[ '500' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '670', '670' ] ]
		} );
		_dataManteldurchmesser[ '550' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '670', '670' ] ]
		} );
		_dataManteldurchmesser[ '600' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : [ [ '800', '800' ] ]
		} );
		_dataManteldurchmesser[ '650' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		_dataManteldurchmesser[ '700' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		_dataManteldurchmesser[ '800' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		_dataManteldurchmesser[ '900' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		_dataManteldurchmesser[ '1000' ] = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
	}
		
	/**
     * modifiziere den Inhalt der Combobox fr den Manteldurchmesser abhngig von der gewhlten Isolierung, basierend auf der ausgewhlten Nennweite
	 *
	 * @params boolean bSetDefault: setze den Defaultwert des Manteldurchmessers
	 * @returns	-
	 */
	function _modifyComboManteldurchmesser( bSetDefault )
	{
		var f = _form.getForm();		
		var cbNennweite = f.findField( 'IDC_NENNWEITE' );
		var strValue = cbNennweite.getValue();
		var data = _dataManteldurchmesser[ strValue ];
		
		// set data
		// the function 'bindStore' is undocumented and marked as private in the ext sources, so using it may not be supported 
		// in subsequent ext versions
		var cbManteldurchmesser = f.findField( 'IDC_MANTELDURCHMESSER' );
		cbManteldurchmesser.bindStore( data );
		
		if ( data && bSetDefault )
		{
			// set default value
			var strDefault = '';
			if ( data.getCount() > 0 )
				strValue = data.getAt( 0 ).get( 'value' );
			cbManteldurchmesser.setValue( strValue );
		}
	}
	
	/**
	 * anzeigen/verstecken der Combobox (und des Labels!) fr Manteldurchmesser
	 *
	 * @params boolean bShow: true - anzeigen, false - verstecken
	 * @returns	-
	 */
	function _showManteldurchmesser( bShow )
	{
		var cbManteldurchmesser = _form.getForm().findField( 'IDC_MANTELDURCHMESSER' );
		if ( bShow )
		{
			// show combo and label
			cbManteldurchmesser.show();
			cbManteldurchmesser.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
		}
		else
		{
			// hide combo and label
			cbManteldurchmesser.hide();
			cbManteldurchmesser.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
		}
	}
	
	/**
	 * anzeigen/verstecken der Combobox (und des Labels!) fr Gleitelement
	 *
	 * @params boolean bShow: true - anzeigen, false - verstecken
	 * @returns	-
	 */
	function _showGleitelement( bShow )
	{
		var cbGleitelement = _form.getForm().findField( 'IDC_GLEITELEMENT' );
		if ( bShow )
		{
			// show combo and label
			cbGleitelement.show();
			cbGleitelement.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
		}
		else
		{
			// hide combo and label
			cbGleitelement.setValue('ID_OHNE');
			cbGleitelement.hide();
			cbGleitelement.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
		}
	}
	
	/**
	 * modifiziere die Inhalte und Label der Combobox 'Gleitart'
	 *
	 * @params integer nGleitartModus: 0 - Gleitart
	 *                                 1 - Leitungsart
	 *                                 2 - Rohrstuetzenart
	 *         string strDefaultValue - defaultwert fr die Combobox
	 * @returns	-
	 */
	function _showGleitart( nGleitartModus, strDefaultValue )
	{
		var cbGleitart = _form.getForm().findField( 'IDC_GLEITART' );
		
		// setze Label
		var strLabel = '$IDC_GLEIT_LABEL$';
		if ( nGleitartModus == 1 )
			strLabel = '$ID_FESTLAGER$';
		else if ( nGleitartModus == 2 ) 
			strLabel = '$IDC_ROHRST_LABEL$';
		cbGleitart.getEl().up( 'div.x-form-element' ).prev( 'label' ).update( strLabel );
		
		// setze Daten
		var data = _storeGleitart;
		if ( nGleitartModus == 1 )
			data = _storeLeitungsart;
		else if ( nGleitartModus == 2 ) 
			data = _storeRohrstuetzenart;
		cbGleitart.bindStore( data );			
		
		// setze defaultwert
		if ( strDefaultValue )
			cbGleitart.setValue( strDefault );
		else
		{
			// wenn noch kein Wert vorhanden ist, setze den ersten Wert des stores als Defaultwert
			var strValue = cbGleitart.getValue();
			if ( ( strValue == '' ) || ( data.find( 'value', strValue ) < 0 ) )
			{
				strValue = data.getAt( 0 ).get( 'value' );
				cbGleitart.setValue( strValue );
			}			
			else if ( data.find( 'value', strValue ) >= 0 )
			{
                // Beim laden der Form werden die Werte (ID's !) gesetzt, bevor der richtige Store da ist
                // Deshalb hier nochmal setzen, damit auch die bersetzte Bezeichnung in der Combo steht und
                // nicht die ID
				cbGleitart.setValue( strValue );
			}			
		}
	}
	
	/**
	 * worker handler, wenn der Benutzer die Lagerart gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onChangedLagerart()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var cbLagerart = f.findField( 'IDC_LAGERART' );
		var cbIsolierung = f.findField( 'IDC_ISOLIERUNG' );
		var cbGleitart = f.findField( 'IDC_GLEITART' );
		var strLagerart = cbLagerart.getValue();
		var strIsolierung = cbIsolierung.getValue();
		var strGleitart = cbGleitart.getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();

		// fr Rohrsttzen mu die Isolierung wrmegedmmte sein
		if ( strLagerart == 'ID_ROHRSTUETZE' )
			cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );

		// Anzeigeoptionen fr Combobox bei Gleitart
		// Modus: 0 - Gleitart
		//        1 - Leitungsart
		//        2 - Rohrsttzenart
		var nGleitartModus = 0;
		if ( ( strLagerart == 'ID_FESTLAGER' ) || ( strLagerart == 'ID_FESTLAGER_D' ) )
		{
			//if ( ( _betriebsbedingungen.wx != 0 ) || ( _betriebsbedingungen.wy != 0 ) )
			if (((_betriebsbedingungen.wx >= 1.4 ) || (_betriebsbedingungen.wx <= -1.4 )) ||
				(( _betriebsbedingungen.wy >= 1.4 ) || (_betriebsbedingungen.wy <= -1.4 )))
			{
				if( _meldungen.msgVerschiebungBeiFestlager )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgVerschiebungBeiFestlager );
				cbLagerart.setValue( 'ID_LOSLAGER' );
			}
			nGleitartModus = 1;
		}
		else if ( strLagerart == 'ID_ROHRSTUETZE' )
			nGleitartModus = 2;
		// else nGleitartModus = 0;
	
		// teste Umgebungsbedingungen bei einfachen Fhrungslagern
		if ( ( strLagerart == 'ID_FUEHRUNGSLAGER' ) || ( strLagerart == 'ID_FUEHRUNG_W2_180_PLUS' ) )
		{
			if ( _betriebsbedingungen.temperatur > 450 )
			{
				if( _meldungen.msgFuehrungslagerBei450Grad )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungslagerBei450Grad );
				if ( strLagerart == 'ID_FUEHRUNGSLAGER' )
					cbLagerart.setValue( 'ID_LOSLAGER' );
				else cbLagerart.setValue( 'ID_FUEHRUNG_W4' );
			}
			if ( strNennweite > 700 )
			{
				if( _meldungen.msgFuehrungslagerBeiDN600 )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungslagerBeiDN600 );
				if ( strLagerart == 'ID_FUEHRUNGSLAGER' )
					cbLagerart.setValue( 'ID_LOSLAGER' );
				else cbLagerart.setValue( 'ID_FUEHRUNG_W4' );
			}

			//if ( _betriebsbedingungen.wx != 0 )
			if ((_betriebsbedingungen.wx >= 5.4 ) || (_betriebsbedingungen.wx <= -5.4 ))
			{
				if( _meldungen.msgVerschiebungBeiFuehrungslager )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgVerschiebungBeiFuehrungslager );
				if ( strLagerart == 'ID_FUEHRUNGSLAGER' )
					cbLagerart.setValue( 'ID_LOSLAGER' );
				else cbLagerart.setValue( 'ID_FUEHRUNG_W2_180' );
			}
		}
// neu Schmidsberger
		// teste Umgebungsbedingungen bei einfachen Fhrungslagern mit Abhebesicherung zum Anschweien
		if ( strLagerart == 'ID_FUEHRUNGSLAGER_W' )
		{
			//if ( _betriebsbedingungen.wx != 0 )
			if ((_betriebsbedingungen.wx >= 5.4 ) || (_betriebsbedingungen.wx <= -5.4 ))
			{
				if( _meldungen.msgVerschiebungBeiFuehrungslager )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgVerschiebungBeiFuehrungslager );
				if ( strLagerart == 'ID_FUEHRUNGSLAGER' )
					cbLagerart.setValue( 'ID_LOSLAGER' );
				else cbLagerart.setValue( 'ID_FUEHRUNG_W2_180' );
			}

			if ( ( strGleitart == 'ID_REIBUNGSARM' ) || ( strGleitart == 'ID_GLEITBLECH') )
			{
			//	if ( _meldungen.msgReibungsarmGleitend )
			//		Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitend );

					cbGleitart.setValue( 'ID_EINFACH' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
			}
			if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || ( strIsolierung == 'ID_KAELTEGEDAEMMT' ) )
			{
			//	if( _meldungen.msgFuehrungBeiDaemmung )
			//		Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungBeiDaemmung );
				cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
				bShowManteldurchmesser = false;
			}
		}
//


		if ( ( strLagerart == 'ID_FUEHRUNG_W2_090' ) || ( strLagerart == 'ID_FUEHRUNG_W3' ) || ( strLagerart == 'ID_FUEHRUNG_W4' ) )
		{
			if ( _betriebsbedingungen.wx != 0 )
			{
				if( _meldungen.msgVerschiebungBeiFuehrungslager )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgVerschiebungBeiFuehrungslager );
				cbLagerart.setValue( 'ID_FUEHRUNG_W2_180' );
			}
		}

		// teste Sichtbarkeit von Manteldurchmesser bei Vorisolierung und verschiedenen Lagerarten
		var bShowManteldurchmesser = false;
		if ( strIsolierung == 'ID_VORISOLIERT' )
		{
			// bei Vorisolierung ist der Manteldurchmesser sicht- und whlbar, bis auf untenstehende Ausnahmen
			if ( ( strLagerart != 'ID_ROHRSTUETZE' ) && ( strLagerart != 'ID_FESTLAGER_D' ) && 
			     !f.findField( 'IDC_SCHRAUBBAR' ).getValue() )
				bShowManteldurchmesser = true;
			else cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
		}
		
		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		if ( bFuehrungVorhanden )
		{
			// spezielle Fhrungslagervarianten gibt es nur mit wrmegedmmter Isolierung
			if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || ( strIsolierung == 'ID_KAELTEGEDAEMMT' ) )
			{
				if( _meldungen.msgFuehrungBeiDaemmung )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungBeiDaemmung );
				cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
				bShowManteldurchmesser = false;
			}
		}

		if ( ( strLagerart == 'ID_LOSLAGER' ) && ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) &&
			 ( strNennweite > 800 ) && ( strGleitart == 'ID_REIBUNGSARM') )
		{
			if( _meldungen.msgReibungsarmGleitendDN800 )
				Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitendDN800 );
			cbGleitart.setValue( 'ID_EINFACH' );
		}

		// jetzt das Abhebesicherungs-Thema
		var checkAbhebesicherung = f.findField( 'IDC_ABHEBESICHERUNG' );
		if ( ( strLagerart == 'ID_LOSLAGER' ) || bFuehrungVorhanden )
			checkAbhebesicherung.setValue( false );
		else checkAbhebesicherung.setValue( true );
		checkAbhebesicherung.disable();

		// Zusatzfunktionen berprfen
		_testeHoehenverstellung();
		_testeGleitunterlage();
		_testeTraegerbefestigung();
		_testeBuegelausfuehrung();
		_testeEinschellig();
		
		// spezielle Verriegelungen fr 'einfach gleitend' testen - mu nach allen anderen Test gemacht werden
		_testeEinfachGleitend();
		
		// teste Sichtbarkeit von Gleitelement bei Wrmedmmung, 'mit Gleitblech' und verschiedenen Lagerarten
		var bShowGleitelement = false;		
		strIsolierung = cbIsolierung.getValue();
		strGleitart = cbGleitart.getValue();
		if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strGleitart == 'ID_GLEITBLECH' ) && ( _strAuswahlKontext == 'EINZEL_LAGER' ) )
		{
			strLagerart = cbLagerart.getValue();
			// bei Wrmedmmung mit Gleitblech ist das Gleitelement fr Loslager und Fhrungslager sichtbar
			if ( ( strLagerart != 'ID_LEER' ) && ( strLagerart != 'ID_ROHRSTUETZE' ) && ( strLagerart != 'ID_FESTLAGER_D' ) && 
			     ( strLagerart != 'ID_FESTLAGER' ) )
				bShowGleitelement = true;
		}
		
		// anzeigen/verstecken von comboboxen
		_showManteldurchmesser( bShowManteldurchmesser );
		_showGleitelement( bShowGleitelement );
		_showGleitart( nGleitartModus );

		// aktuelles Bild setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * worker handler, wenn der Benutzer die Gleitart gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onChangedGleitart()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var cbGleitart = f.findField( 'IDC_GLEITART' );
		var strGleitart = cbGleitart.getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();

		// bei allen Lagern auer Festlagern darf die Nennweite bei reibungsarmen Los- und Fhrungslagern nicht grer als 800 mm sein
		if ( ( strLagerart != 'ID_FESTLAGER' ) && ( strLagerart != 'ID_FESTLAGER_D' ) )
		{
			var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		
			if ( ( strGleitart == 'ID_REIBUNGSARM' ) && ( strNennweite > 800 ) )
			{
				if( _meldungen.msgReibungsarmGleitendDN800 )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitendDN800 );
				cbGleitart.setValue( 'ID_EINFACH' );
			}
		}
// neu Schmidsberger
		// nur Gleitart einfach ist zulssig
		if ( strLagerart == 'ID_FUEHRUNGSLAGER_W' )  
		{
			if ( ( strGleitart == 'ID_REIBUNGSARM' ) || ( strGleitart == 'ID_GLEITBLECH' ))
			{
			//	if( _meldungen.msgReibungsarmGleitendDN800 )
			//		Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitendDN800 );
				cbGleitart.setValue( 'ID_EINFACH' );
			}
		}
//

		// Zusatzfunktionen berprfen
		_testeHoehenverstellung();
		_testeGleitunterlage();
		_testeTraegerbefestigung();
		_testeBuegelausfuehrung();
		_testeEinschellig();
		
		// spezielle Verriegelungen fr 'einfach gleitend' testen - mu nach allen anderen Test gemacht werden
		_testeEinfachGleitend();
		
		// teste Sichtbarkeit von Gleitelement bei Wrmedmmung, 'mit Gleitblech' und verschiedenen Lagerarten
		var bShowGleitelement = false;		
		strGleitart = cbGleitart.getValue();
		if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strGleitart == 'ID_GLEITBLECH' )  && ( _strAuswahlKontext == 'EINZEL_LAGER' ))
		{
			// bei Wrmedmmung mit Gleitblech ist das Gleitelement fr Loslager und Fhrungslager sichtbar
			if ( ( strLagerart != 'ID_LEER' ) && ( strLagerart != 'ID_ROHRSTUETZE' ) && ( strLagerart != 'ID_FESTLAGER_D' ) && 
			     ( strLagerart != 'ID_FESTLAGER' ) )
				bShowGleitelement = true;
		}

		// anzeigen/verstecken von comboboxen
		_showGleitelement( bShowGleitelement );
		
		// aktuelles Bild setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}
	
	function _onChangedGleitelement()		//scb
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		var f = _form.getForm();
		
		// aktuelles Bild setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}
	
	/**
	 * worker handler, wenn der Benutzer die Isolierung gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onChangedIsolierung()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var cbLagerart = f.findField( 'IDC_LAGERART' );
		var cbIsolierung = f.findField( 'IDC_ISOLIERUNG' );
		var cbGleitart = f.findField( 'IDC_GLEITART' );
		var strLagerart = cbLagerart.getValue();
		var strIsolierung = cbIsolierung.getValue();
		var strGleitart = cbGleitart.getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();

		var bShowManteldurchmesser = false;
		if ( strIsolierung == 'ID_VORISOLIERT' )
		{
			if ( ( strLagerart != 'ID_ROHRSTUETZE' ) && ( strLagerart != 'ID_FESTLAGER_D' ) && 
			     !f.findField( 'IDC_SCHRAUBBAR' ).getValue() )
				bShowManteldurchmesser = true;
			else
			{
				cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
				strIsolierung = 'ID_WAERMEGEDAEMMT';
			}
		}

		if ( ( _betriebsbedingungen.daemmdicke > 0 ) &&  ( strIsolierung == 'ID_UNGEDAEMMT' ) )
		{
			if ( _meldungen.msgDaemmungMitUngedaemmt )
				Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgDaemmungMitUngedaemmt );
			cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
			strIsolierung = 'ID_WAERMEGEDAEMMT';
		}

		// bei Lagerart Rohrsttze mu die Isolierung wrmegedmmt sein
		if ( strLagerart == 'ID_ROHRSTUETZE' )
		{
			cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
			strIsolierung = 'ID_WAERMEGEDAEMMT';
			bShowManteldurchmesser = false;
		}
// neu Schmidsberger
		// bei Lagerart Fhrungslager_W mu die Isolierung wrmegedmmt sein
		if ( strLagerart == 'ID_FUEHRUNGSLAGER_W' )  
		{
			if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || ( strIsolierung == 'ID_KAELTEGEDAEMMT' ) )
			{
			//	if( _meldungen.msgFuehrungBeiDaemmung )
			//		Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungBeiDaemmung );
				cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
				strIsolierung = 'ID_WAERMEGEDAEMMT';
				bShowManteldurchmesser = false;
			}
		}
//

		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		if ( bFuehrungVorhanden )
		{
			// spezielle Fhrungslagervarianten gibt es nur mit wrmegedmmter Isolierung
			if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || ( strIsolierung == 'ID_KAELTEGEDAEMMT' ) )
			{
				if( _meldungen.msgFuehrungBeiDaemmung )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFuehrungBeiDaemmung );
				cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
				strIsolierung = 'ID_WAERMEGEDAEMMT';
				bShowManteldurchmesser = false;
			}
		}

		// fr Los-und Fhrungslager ist bei ungedmmter Isolierung und Nennweite <= 300 mm eine Gleitunterlage mglich und wird empfohlen,
		// bei Wrmedmmung dagegen wird sie nicht empfohlen
		if ( ( strLagerart == 'ID_LOSLAGER' ) || ( strLagerart == 'ID_FUEHRUNGSLAGER' ) )
		{
			var checkGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE' );
			if ( ( strIsolierung == 'ID_UNGEDAEMMT' ) && ( strNennweite <= 300 ) )
			{
				checkGleitunterlage.enable();
				checkGleitunterlage.setValue( true );
			}
			if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
			{
				checkGleitunterlage.enable();
				checkGleitunterlage.setValue( false );
			}
		}
		
		// teste Sichtbarkeit von Gleitelement bei Wrmedmmung, 'mit Gleitblech' und verschiedenen Lagerarten
		var bShowGleitelement = false;		
		if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strGleitart == 'ID_GLEITBLECH' )  && ( _strAuswahlKontext == 'EINZEL_LAGER' ))
		{
			// bei Wrmedmmung mit Gleitblech ist das Gleitelement fr Loslager und Fhrungslager sichtbar
			if ( ( strLagerart != 'ID_LEER' ) && ( strLagerart != 'ID_ROHRSTUETZE' ) && ( strLagerart != 'ID_FESTLAGER_D' ) && 
			     ( strLagerart != 'ID_FESTLAGER' ) )
				bShowGleitelement = true;
		}

		// anzeigen/verstecken von comboboxen
		_showManteldurchmesser( bShowManteldurchmesser );		
		_showGleitelement( bShowGleitelement );

		// Zusatzfunktionen berprfen
		_testeHoehenverstellung();
		_testeGleitunterlage();
		_testeTraegerbefestigung();
		_testeBuegelausfuehrung();
		_testeEinschellig();
		
		// spezielle Verriegelungen fr 'einfach gleitend' testen - mu nach allen anderen Test gemacht werden
		_testeEinfachGleitend();
		
		// aktuelles Bild setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}
	
	/**
	 * worker handler, wenn der Benutzer die Nennweite oder den Auendurchmesser gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onChangedDurchmesser()
	{
		_modifyComboManteldurchmesser( true );
		
        if ( _strAuswahlKontext == 'EINZEL_LAGER' )
        {
            // teste Auswirkungen auf Lagerart, Gleitart und Isolierung
            _onChangedLagerart();
            _onChangedGleitart();
            _onChangedIsolierung();
            
            // teste Auswirkungen auf Zusatzfunktionen
            _testeHoehenverstellung();
            _testeEinschellig();
            _testeGleitunterlage();
            _testeBuegelausfuehrung();
            _testeTraegerbefestigung();
        } else if (_strAuswahlKontext == 'STUETZE_STD') {
			_testeEinschellig();
		}
        
		_setzeBild();
		_resetTable();
	}

	/**
	 * teste, ob Gleitunterlagen bei den aktuellen Lagereinstellungen mglich/verboten bzw. ntig/empfohlen sind
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeHoehenverstellung()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var checkHoehenverstellung = f.findField( 'IDC_HOEHENVERSTELLUNG' );

		// bei einfachem schraubbarem Festlager oder doppeltem Festlager darf keine Hhenverstellung vorgenommen werden
		if ( ( ( strLagerart == 'ID_FESTLAGER' ) && f.findField( 'IDC_SCHRAUBBAR' ).getValue() ) ||
			 ( strLagerart == 'ID_FESTLAGER_D' ) || ( strLagerart == 'ID_FUEHRUNGSLAGER_W' ))
		{
			checkHoehenverstellung.setValue( false );
			checkHoehenverstellung.disable();
		}

		if ( ( ( strNennweite <= 600 ) && ( strLagerart == 'ID_FESTLAGER' ) && ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) &&
				 !f.findField( 'IDC_SCHRAUBBAR' ).getValue() && ( _betriebsbedingungen.temperatur <= 300 ) ) ||
			 ( ( strNennweite <= 600 ) && 
			   ( ( strLagerart == 'ID_FUEHRUNGSLAGER' ) || ( strLagerart == 'ID_LOSLAGER' ) ) &&
			   ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strGleitart == 'ID_REIBUNGSARM' ) ) )
			checkHoehenverstellung.enable();
		else
		{
			checkHoehenverstellung.setValue( false );
			checkHoehenverstellung.disable();
		}
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * teste, ob Gleitunterlagen bei den aktuellen Lagereinstellungen mglich/verboten bzw. ntig/empfohlen sind
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeGleitunterlage()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var checkGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE' );

		// bei speziellen Fhrungslagern und Festlagern oder einfacher Gleitart oder bei Kombination gleitarm und vorisoliert ist keine Gleitunterlage mglich
		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		if ( ( strLagerart == 'ID_FESTLAGER' ) || ( strLagerart == 'ID_FESTLAGER_D' ) || ( strGleitart == 'ID_EINFACH' ) || bFuehrungVorhanden || ( strGleitart == 'ID_GLEITBLECH') ||
			 ( ( strGleitart == 'ID_REIBUNGSARM' ) && ( strIsolierung == 'ID_VORISOLIERT' ) ) )
		{
			checkGleitunterlage.setValue( false );
			checkGleitunterlage.disable();
		}
		else
		{
			checkGleitunterlage.enable();
			// bei ungedmmten reibungarmen Lagern mit Nennweite > 300 oder generell bei Nennweite > 600 ist keine Gleitunterloage mglich
			if ( ( ( strGleitart == 'ID_REIBUNGSARM' ) && ( strIsolierung == 'ID_UNGEDAEMMT' ) && ( strNennweite > 300 ) ) ||
				( strNennweite > 600 )||
					strLagerart == 'ID_FUEHRUNGSLAGER_W')
			{
				checkGleitunterlage.setValue( false );
				checkGleitunterlage.disable();
			}
		}

		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * teste, ob Trgerbefestigungen klemmbar bzw. schraubbar bei den aktuellen Lagereinstellungen mglich/verboten bzw. ntig/empfohlen sind
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeTraegerbefestigung()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
		var checkSchraubbar = f.findField( 'IDC_SCHRAUBBAR' );
		var checkGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE' );

		// bei wrmegedmmtenm oder vorisolierten Loslagern ohne Gleitunterlage oder spezielen Fuehrungslagern oder ungedmmten und nicht reibungsarmen Loslagern
		// sind keine Trgerbefestigungen mglich
		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		if ( ( ( strLagerart == 'ID_LOSLAGER' ) && ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) || ( strIsolierung == 'ID_VORISOLIERT' ) ) && !checkGleitunterlage.getValue() ) ||
		     bFuehrungVorhanden || 
			 ( ( strLagerart == 'ID_LOSLAGER' ) && ( strIsolierung == 'ID_UNGEDAEMMT' ) && ( strGleitart != 'ID_REIBUNGSARM' ) ) )
		{
			checkKlemmbar.setValue( false );
			checkKlemmbar.disable();

			checkSchraubbar.setValue( false );
			checkSchraubbar.disable();
		}
		else
		{
			// bei Loslagern ist schraubbar nicht mglich
			if ( strLagerart == 'ID_LOSLAGER' )
			{
				checkSchraubbar.setValue( false );
				checkSchraubbar.disable();
				
				// bei Loslagern mit Gleitunterlage ist klemmbar unbedingt notwendig,
				// bei Loslagern ohne Gleitunterlage ist klemmbar nicht mglich
				if ( checkGleitunterlage.getValue() )
				{
					checkKlemmbar.setValue( true );
					checkKlemmbar.disable();
				}
				else
				{
					checkKlemmbar.setValue( false );
					checkKlemmbar.disable();
				}
			}
		}

		// bei dieen Fhrungslagern ist klemmbar je nach temperatur notwendig oder nicht mglich, schraubbar ist generell nicht mglich
		if ( ( strLagerart == 'ID_FUEHRUNGSLAGER' ) || ( strLagerart == 'ID_FUEHRUNG_W2_180_PLUS' ) )
		{
			if ( _betriebsbedingungen.temperatur > 450 )
				checkKlemmbar.setValue( false );
			else checkKlemmbar.setValue( true );
			checkKlemmbar.disable();

			checkSchraubbar.setValue( false );
			checkSchraubbar.disable();
		}
		
		if (strLagerart == 'ID_FUEHRUNGSLAGER_W')
		{
			checkKlemmbar.setValue( false );
			checkKlemmbar.disable();
			checkSchraubbar.setValue( false );
			checkSchraubbar.disable();
		}

		// fr einfache Festlager sind Trgerbefestigungen grundstzlich mglich
		if ( strLagerart == 'ID_FESTLAGER' )
		{
			checkKlemmbar.enable();
			checkSchraubbar.enable();

			// allerdings mu genau eine Trgerbefestigung ausgewhlt werden
			if ( !checkSchraubbar.getValue() && !checkKlemmbar.getValue() )
				checkKlemmbar.setValue( true );
			if ( checkSchraubbar.getValue() && checkKlemmbar.getValue() )
				checkSchraubbar.setValue( false );

			// bei Nennweiten < 80mm ist klemmbar notwendig und schraubbar nicht mglich
			if ( strNennweite < 80 )
			{
				checkKlemmbar.setValue( true );
				checkKlemmbar.disable();
				
				checkSchraubbar.setValue( false );
				checkSchraubbar.disable();
			}

			// bei Nennweiten > 600mm oder Betriebstemperaturen >600 C ist schraubbar notwendig und klemmbar nicht mglich
			if ( ( _betriebsbedingungen.temperatur > 450 ) || ( strNennweite > 600 ) )
			{
				checkKlemmbar.setValue( false );
				checkKlemmbar.disable();
				
				checkSchraubbar.setValue( true );
				checkSchraubbar.disable();
			}
		}

		// bei doppelten Festlagern ist schraubbar notwendig und klemmbar nicht mglich
		if ( strLagerart == 'ID_FESTLAGER_D' )
		{
			checkKlemmbar.setValue( false );
			checkKlemmbar.disable();
			
			checkSchraubbar.setValue( true );
			checkSchraubbar.disable();
		}

		// mu nochmal getestet werden, da die Hhenverstellung von Trgerbefestigung schraubbar abhngig ist
		_testeHoehenverstellung();

		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * teste, ob Bgelbefestigung als Rohrbefestigung bei den aktuellen Lagereinstellungen mglich/verboten bzw. ntig/empfohlen sind
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeBuegelausfuehrung()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var checkBuegelausfuehrung = f.findField( 'IDC_BUEGELAUSFUEHRUNG' );

		// nennweite <= 300 mm
		if ( strNennweite <= 300 && strLagerart != 'ID_FUEHRUNGSLAGER_W')
		{
			// bei ungedmmten Festlagern kann Bgelausfhrung gewhlt werden
			if ( ( strLagerart == 'ID_FESTLAGER' ) && ( strIsolierung == 'ID_UNGEDAEMMT' ) )
				checkBuegelausfuehrung.enable();
			else
			{
				// bei ungedmmten reibungsarmen einfachen Fhrungslagern ohne einschellig ist eine Bgelausfhrung notwendig,
				// bei sonstigen Lagern und zusatzfunktionen darf keine Bgelausfhrung gewhlt werden
				if ( ( strLagerart == 'ID_FUEHRUNGSLAGER' ) && ( strGleitart == 'ID_REIBUNGSARM' ) &&
					 ( strIsolierung == 'ID_UNGEDAEMMT' ) && !f.findField( 'IDC_BUEGELAUSFUEHRUNG' ).getValue() )
					checkBuegelausfuehrung.setValue( true );
				else checkBuegelausfuehrung.setValue( false );
				checkBuegelausfuehrung.disable();
			}
		}
		else
		{
			// bei greren Nennweiten ist keine Bgelausfhrung mglich
			checkBuegelausfuehrung.setValue( false );
			checkBuegelausfuehrung.disable();
		}
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * teste, ob Einschellig als Rohrbefestigung bei den aktuellen Lagereinstellungen mglich/verboten bzw. ntig/empfohlen sind
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeEinschellig()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );

		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		// bei Wrmedmmung und Nennweiten > 150mm oder Lager mit Edelstahlgleitplatte oder speziellen Fhrungslagern oder Betriebstemperatur > 300C oder vorisoliert oder schraubbar oder 
		// Bgelausfhrung darf kein einschellig gewhlt werden
		if ( ( ( strNennweite > 150 ) && ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) ) || ( strGleitart == 'ID_GLEITBLECH') || ( ( strLagerart == 'ID_FUEHRUNGSLAGER_W') && ( strNennweite > 150 ) ) ||
		     bFuehrungVorhanden || f.findField( 'IDC_SCHRAUBBAR' ).getValue() || f.findField( 'IDC_BUEGELAUSFUEHRUNG' ).getValue() ||
		    (_betriebsbedingungen.temperatur > 300 ) || ( strIsolierung == 'ID_VORISOLIERT' ) )
		{
			checkEinschellig.setValue( false );
			checkEinschellig.disable();
		}
		else
		{
			checkEinschellig.enable();
			
			// wenn die Lagerart kein Festlager ist, gibt es je nach Isolierung einige Ausnahmen
			if ( strLagerart != 'ID_FESTLAGER' )
			{
				if ( strIsolierung == 'ID_UNGEDAEMMT' )
				{
					if ( strGleitart == 'ID_EINFACH' )
					{
						if ( strNennweite <= 80 )
							checkEinschellig.setValue( true );
						else checkEinschellig.setValue( false );
						checkEinschellig.disable();
					}
					else
					{
						// reibungsarm ohne gleitunterlage
						if ( ( strGleitart == 'ID_REIBUNGSARM' ) && !f.findField( 'IDC_GLEITUNTERLAGE' ).getValue() )
						{
							if ( strNennweite <= 40 )
								checkEinschellig.setValue( true );
							else checkEinschellig.setValue( false );
							checkEinschellig.disable();
						}
						else
						{
							checkEinschellig.setValue( false );
							checkEinschellig.disable();
						}
					}
				}
				else if ( strIsolierung != 'ID_WAERMEGEDAEMMT' )
				{
					checkEinschellig.setValue( false );
					checkEinschellig.disable();
				}
			}
		}
		
		if ( ( strLagerart == 'ID_FESTLAGER' ) && ( strIsolierung == 'ID_UNGEDAEMMT' ) )
		{
			if ( strNennweite <= 300 )
			{
				if ( f.findField( 'IDC_KLEMMBAR' ).getValue() )
					checkEinschellig.enable();
				else if ( f.findField( 'IDC_BUEGELAUSFUEHRUNG' ).getValue() )
				{
					checkEinschellig.setValue( false );
					checkEinschellig.disable();
				}
			}
			else
			{
				checkEinschellig.setValue( false );
				checkEinschellig.disable();
			}
		}
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * zustzliche Tests fr Gleitart, insbesondere auf 'einfach gleitend'
	 *
	 * @params -
	 * @returns	-
	 */
	function _testeEinfachGleitend()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var cbGleitart = f.findField( 'IDC_GLEITART' );
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = cbGleitart.getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();

		if ( strLagerart == 'ID_LOSLAGER' ) 
		{
			if (( strGleitart == 'ID_EINFACH' ) || (( strGleitart == 'ID_GLEITBLECH') && ( _betriebsbedingungen.temperatur <= 300 )) )
			{
				// bei vorsolierten oder ungedmmten Los- oder Fhrungslagern oder wrmegedmmten Los- oder Fhrungslagern bei maximal 300C
				// mu reibungsarme Gleitart gewhlt werden
				if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || 
					 ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strNennweite < 10 ) && ( _betriebsbedingungen.temperatur <= 300 ) ) )
				{
					if ( _meldungen.msgEinfachGleitend )
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgEinfachGleitend );
					cbGleitart.setValue( 'ID_REIBUNGSARM' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
				}
			}
//neu scb ******************************************************************
			else if ( strGleitart == 'ID_REIBUNGSARM' )
			{
				// bei wrmegedmmter Isolierung und einer Temperatur > 300 C mu einfache Gleitart gewhlt werden
				if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( _betriebsbedingungen.temperatur > 300 ) )
				{
					if ( _meldungen.msgReibungsarmGleitend )
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitend );
					cbGleitart.setValue( 'ID_EINFACH' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
				}
			}
			else if ( strGleitart == 'ID_GLEITBLECH' )
			{
				// bei wrmegedmmter Isolierung und einer Temperatur > 480 C mu einfache Gleitart gewhlt werden
				if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( _betriebsbedingungen.temperatur > 480 ) )
				{
					if ( _meldungen.msgGLEITBLECH )
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgGLEITBLECH );
					cbGleitart.setValue( 'ID_EINFACH' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
				}
			}
//neu scb ******************************************************************
		}
		if ( strLagerart == 'ID_FUEHRUNGSLAGER' ) 
		{
			if (( strGleitart == 'ID_EINFACH' ) || ( strGleitart == 'ID_GLEITBLECH'))
			{
				// bei vorsolierten oder ungedmmten Los- oder Fhrungslagern oder wrmegedmmten Los- oder Fhrungslagern bei maximal 300C und 600mm Nennweite
				// mu reibungsarme Gleitart gewhlt werden
				if ( ( strIsolierung == 'ID_VORISOLIERT' ) || ( strIsolierung == 'ID_UNGEDAEMMT' ) || 
					 ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( strNennweite <= 600 ) && ( _betriebsbedingungen.temperatur <= 300 ) ) )  // DN 500 in 600 gendert
				{
					if ( _meldungen.msgEinfachGleitend )
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgEinfachGleitend );
					cbGleitart.setValue( 'ID_REIBUNGSARM' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
				}
			}
			else // if ( strGleitart == 'ID_REIBUNGSARM' )
			{
				// bei wrmegedmmter Isolierung und einer Temperatur > 300 C mu einfache Gleitart gewhlt werden
				if ( ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( _betriebsbedingungen.temperatur > 300 ) )
				{
					if ( _meldungen.msgReibungsarmGleitend )
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitend );
					cbGleitart.setValue( 'ID_EINFACH' );

					_testeHoehenverstellung();
					_testeGleitunterlage();
				}
			}
		}

		// fr spezielle Fhrungen gibt es ebenfalls eine Sonderbehandlung
		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		if ( bFuehrungVorhanden )
		{
			// bei einer Nennweite < 80mm und einer Betriebstemperatur <= 300C mu reibungsarme Gleitart gewhlt werden
			if ( ((( strGleitart == 'ID_EINFACH' ) && ( strNennweite <= 80 )) || ( strGleitart == 'ID_GLEITBLECH')) && ( _betriebsbedingungen.temperatur <= 300 ) )
			{
				if ( _meldungen.msgEinfachGleitend )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgEinfachGleitend );
				cbGleitart.setValue( 'ID_REIBUNGSARM' );

				_testeHoehenverstellung();
				_testeGleitunterlage();
			}

			// bei einer wrmegedmmter Isolierung und einer Betriebstemperatur > 300C mu einfache Gleitart gewhlt werden
			if ((( strGleitart == 'ID_REIBUNGSARM' ) || ( strGleitart == 'ID_GLEITBLECH'))  && ( strIsolierung == 'ID_WAERMEGEDAEMMT' ) && ( _betriebsbedingungen.temperatur > 300 ) )
			{
				if ( _meldungen.msgReibungsarmGleitend )
					Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgReibungsarmGleitend );
				cbGleitart.setValue( 'ID_EINFACH' );

				_testeHoehenverstellung();
				_testeGleitunterlage();
			}
        	}
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * setze bersichtsbild fr aktuelles Lager
	 *
	 * @params -
	 * @returns	-
	 */
	function _setzeBild()
	{
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		var strGleitelement = f.findField( 'IDC_GLEITELEMENT' ).getValue();	// scb
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var strAussendurchmesser = f.findField( 'IDC_AUSSENDURCHMESSER' ).getValue();
		var strLGImgVar = f.findField( 'LG_IMG_VAR' ).getValue();
		var strLGRichtAkt = f.findField( 'LG_RICHT_AKT' ).getValue();
		var bFuehrungVorhanden = _isSpeziellesFuehrungslager( strLagerart );
		var bIsGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE' ).getValue();
		var bIsHoehenverstellung = f.findField( 'IDC_HOEHENVERSTELLUNG' ).getValue();
		var bIsEinschellig = f.findField( 'IDC_EINSCHELLIG' ).getValue();
		var bIsBuegelausfuehrung = f.findField( 'IDC_BUEGELAUSFUEHRUNG' ).getValue();
		var bIsKlemmbar = f.findField( 'IDC_KLEMMBAR' ).getValue();
		var bIsSchraubbar = f.findField( 'IDC_SCHRAUBBAR' ).getValue();

		var strBild = 'blank.gif';
		// kein bild fr Trennstriche als Lagerart
		if ( strLagerart == 'ID_LEER' )
         	strBild = 'B_Lager_NO.jpg';

		// Bilder fr Rohrsttze
        if ( strLagerart == 'ID_ROHRSTUETZE' )
        {
         	if ( strGleitart == 'ID_ROHR_GLATT')
                 	strBild = 'B_LST01_NO.jpg';
            else strBild = 'B_LST11_NO.jpg';
        }

		// Bilder fr einfache Festlager
		if ( strLagerart == 'ID_FESTLAGER' )
		{
			// Bilder fr einfache Festlager bei wrmegedmmter Isolierung
			if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
			{
				if ( bIsHoehenverstellung )
				{
					if ( bIsKlemmbar )
					{
						if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
						{
							if ( bIsEinschellig )
								strBild = 'B_FVN20_WD.jpg';
							else strBild = 'B_FVN21_22_WD.jpg';
						}
						else strBild = 'B_FVN23_WD.jpg';
					}
				}
				else
				{
					if ( bIsKlemmbar )
					{
						if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
						{
							if ( bIsEinschellig )
								strBild = 'B_FLN20_WD.jpg';
							else
							{
								if ( _betriebsbedingungen.temperatur > 300 )
									strBild = 'B_FLN21_22_WW.jpg';
								else strBild = 'B_FLN21_22_WD.jpg';
							}
						}
						else
						{
							if ( _betriebsbedingungen.temperatur > 300 )
								strBild = 'B_FLN23_WW.jpg';
							else strBild = 'B_FLN23_WD.jpg';
						}
					}
					else
					{
						if ( bIsSchraubbar )
						{
							if ( strNennweite >= 80 )
							{
								if ( strNennweite <= 300 )
									strBild = 'B_FSN01.jpg';
								else if ( strNennweite <= 1000 )
									strBild = 'B_FSN02.jpg';
								else strBild = 'B_FSN02_NO_1000.jpg';
							}
							else strBild = 'B_FSN01_NO_80.jpg';
						}
					}
				}
			}

			// Bilder fr einfache Festlager bei ungedmmter Isolierung
			if ( strIsolierung == 'ID_UNGEDAEMMT' )
			{
				if ( bIsKlemmbar )
				{
					if ( bIsBuegelausfuehrung )
					{
						if ( ( strNennweite >= 25 ) && ( strNennweite <= 300 ) )
						{
							if ( strNennweite <= 50 )
								strBild = 'B_FLN10_1_UD.jpg';
							else strBild = 'B_FLN10_2_UD.jpg';
						}
						else strBild = 'blank.gif';
					}
					else
					{
						if ( bIsEinschellig )
						{
							if ( ( strNennweite >= 20 ) && ( strNennweite <= 300 ) )
							{
								if ( strNennweite <= 40 )
									strBild = 'B_FLN11_1_UD.jpg';
								else
								{
									if ( strNennweite <= 80 )
										strBild = 'B_FLN11_2_UD.jpg';
									else strBild = 'B_FLN11_3_UD.jpg';
								}
							}
							else strBild = 'blank.gif';
						}
						else
						{
							if  ( strNennweite <= 600 )
							{
								if ( strNennweite <= 150 )
									strBild = 'B_FLN21_22_UD.jpg';
								else strBild = 'B_FLN23_UD.jpg';
							}
							else strBild = 'blank.gif';
						}
					}
				}
				else
				{
					if ( bIsSchraubbar )
					{
						if ( strNennweite >= 80 )
						{
							if ( strNennweite <= 300 )
								strBild = 'B_FSN01.jpg';
							else if ( strNennweite <= 600 )
								strBild = 'B_FSN02.jpg';
							else strBild = 'B_FSN02_NO_600.jpg';
						}
						else strBild = 'B_FSN01_NO_80.jpg';
					}
				}
			}

			// Bilder fr einfache Festlager bei Vorisolierung
			if ( strIsolierung == 'ID_VORISOLIERT' )
			{
				if ( bIsKlemmbar && ( _betriebsbedingungen.temperatur <= 450 ) )
				{
					if ( strNennweite == 15 )
						strBild = 'B_FLV21_22_NO_20.jpg';
					else if ( strNennweite <= 65 )
						strBild = 'B_FLV21_22.jpg';
					else if ( strNennweite <= 600 )
					{
						if ( _betriebsbedingungen.temperatur <= 300 )
						{
							if ( strNennweite <= 125 )
								strBild = 'B_FLV23_1.jpg';
							else strBild = 'B_FLV23_2.jpg';
						}
						else strBild = 'B_FLV23_1.jpg';
					}
					else strBild = 'B_FLV23_2_NO_600.jpg';
				}
				else strBild = 'blank.gif';
			}
		}

		// Bilder fr doppelte Festlager
		if ( strLagerart == 'ID_FESTLAGER_D' )
		{
			// Bilder fr doppelte Festlager bei wrmegedmmter Isolierung
			if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
			{
				if ( strNennweite >= 80 )
				{
					if ( strNennweite <= 300 )
						strBild = 'B_FSD01.jpg';
					else if ( strNennweite <= 1000 )
						strBild = 'B_FSD02.jpg';
					else strBild = 'B_FSD02_NO_1000.jpg';
				}
				else strBild = 'B_FSD01_NO_80.jpg';
			}
			
			// Bilder fr doppelte Festlager bei ungedmmter Isolierung
			if ( strIsolierung == 'ID_UNGEDAEMMT' )
			{
				if ( strNennweite >= 80 )
				{
					if ( strNennweite <= 300 )
						strBild = 'B_FSD01.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_FSD02.jpg';
					else strBild = 'B_FSD02_NO_600.jpg';
				}
				else strBild = 'B_FSD01_NO_80.jpg';
			}
		}

		// Bilder fr Loslager
		if ( strLagerart == 'ID_LOSLAGER' )
		{
			// Bilder fr Loslager bei wrmegedmmter Isolierung
			if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
			{
				// Bilder fr Loslager bei wrmegedmmter Isolierung und reibungsarmer Gleitart
				if ( strGleitart == 'ID_REIBUNGSARM' )
				{
					if ( !bIsGleitunterlage )
					{
						if ( bIsHoehenverstellung )
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( bIsEinschellig )
									strBild = 'B_LVL20_WD.jpg';
								else strBild = 'B_LVL21_22_WD.jpg';
							}
							else strBild = 'B_LVL23.jpg';
						}
						else
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( _betriebsbedingungen.daemmdicke <= 85 )
								{
									if ( bIsEinschellig )
										strBild = 'B_LKL20_1_WD.jpg';
									else strBild = 'B_LKL21_22_1_WD.jpg';
								}
								else
								{
									if ( _betriebsbedingungen.daemmdicke <= 190 ) // von 170 in 190 gendert
									{
										if ( bIsEinschellig )
											strBild = 'B_LKL20_2_WD.jpg';
										else strBild = 'B_LKL21_22_2_WD.jpg';
									}
								}
							}
							else strBild = 'B_LKL23_WD.jpg';
						}
					}
					else
					{
						if ( bIsHoehenverstellung )
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( bIsEinschellig )
									strBild = 'B_LVL40_WD.jpg';
								else strBild = 'B_LVL41_42_WD.jpg';
							}
							else strBild = 'B_LVL43_WD.jpg';
						}
						else
						{
							if ( ( strNennweite <= 300) || ( strAussendurchmesser <= 324 ) )
							{
								if ( _betriebsbedingungen.daemmdicke <= 85 )
								{
									if ( bIsEinschellig )
										strBild = 'B_LKL40_1_WD.jpg';
									else strBild = 'B_LKL41_42_1_WD.jpg';
								}
								else
								{
									if ( _betriebsbedingungen.daemmdicke <= 190 )	// von 170 in 190 gendert
									{
										if ( bIsEinschellig )
											strBild = 'B_LKL40_2_WD.jpg';
										else strBild = 'B_LKL41_42_2_WD.jpg';
									}
								}
							}
							else strBild = 'B_LKL43_WD.jpg';
						}
					}
				}
				
				// Bilder fr Loslager bei wrmegedmmter Isolierung und einfacher Gleitart
				if ( strGleitart == 'ID_EINFACH' )
				{
					if (_betriebsbedingungen.temperatur <= 300)
					{
						if ( strNennweite <= 150  )
						{
							if (_betriebsbedingungen.daemmdicke <= 190 )	// von 170 in 190 gendert
							{
								if ( bIsEinschellig )
									strBild = 'B_LSL20_3_WD.jpg';
								else strBild = 'B_LSL21_22_3_WD.jpg';
							}
							
							else strBild = 'blank.gif';
						}

						else if ( strNennweite <= 600 )  // war 800
						{
							if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
								strBild = 'B_LSL23_WW.jpg';
							else strBild = 'blank.gif';
						}
						else
						{
							if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
								strBild = 'B_LSL24_2_WW.jpg';
							else strBild = 'blank.gif';
						}
					}
					else
					{
						if ( strNennweite <= 300 )
						{
							if ( _betriebsbedingungen.daemmdicke <= 240 )	// von 220 in 240 gendert
								strBild = 'B_LSL21_22_WW.jpg';
							else strBild = 'blank.gif';
						}
						else if ( strNennweite <= 600 )  //  war 800
						{
							if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
								strBild = 'B_LSL23_WW.jpg';
							else strBild = 'blank.gif';
						}
						else
						{
							if ( _betriebsbedingungen.daemmdicke <= 290) 	// von 270 in 290 gendert
								strBild = 'B_LSL24_2_WW.jpg';
							else strBild = 'blank.gif';
						}
					}
				}

				// Bilder fr Loslager bei wrmegedmmter Isolierung und Edelstahlgleitplatte
				if ( strGleitart == 'ID_GLEITBLECH' )
				{
					if ( strGleitelement == 'ID_OHNE' )
					{
						if (_betriebsbedingungen.temperatur <= 300)
						{
							if ( strNennweite <= 150  )
							{
								if (_betriebsbedingungen.daemmdicke <= 190 )	// von 170 in 190 gendert
								{
									if ( bIsEinschellig )
										strBild = 'B_LSL20_WD.jpg';  // nicht whlbar
									else strBild = 'B_LXL21_22_2_WD.jpg';
								}
							
								else strBild = 'blank.gif';
							}

							else if ( strNennweite <= 600 )  // war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXL23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXL24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
						else
						{
							if ( strNennweite <= 300 )
							{
								if ( _betriebsbedingungen.daemmdicke <= 240 )	// von 220 in 240 gendert
									strBild = 'B_LXL21_22_WW.jpg';
								else strBild = 'blank.gif';
							}
							else if ( strNennweite <= 600 )  //  war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXL23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290)	// von 270 in 290 gendert 
									strBild = 'B_LXL24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
					}
					else if ( strGleitelement == 'ID_LGA' )
					{
						if (_betriebsbedingungen.temperatur <= 300)
						{
							if ( strNennweite <= 150  )
							{
								if (_betriebsbedingungen.daemmdicke <= 190 )	// von 170 in 190 gendert
								{
									if ( bIsEinschellig )
										strBild = 'B_LSL20_WD.jpg'; // nicht whlbar
									else strBild = 'B_LXA21_22_2_WD.jpg';
								}
							
								else strBild = 'blank.gif';
							}

							else if ( strNennweite <= 600 )  // war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXA23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXA24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
						else
						{
							if ( strNennweite <= 300 )
							{
								if ( _betriebsbedingungen.daemmdicke <= 240 )	// von 220 in 240 gendert
									strBild = 'B_LXA21_22_WW.jpg';
								else strBild = 'blank.gif';
							}
							else if ( strNennweite <= 600 )  //  war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXA23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290)	// von 270 in 290 gendert 
									strBild = 'B_LXA24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
					}
					else if ( strGleitelement == 'ID_LGV' )
					{
						if (_betriebsbedingungen.temperatur <= 300)
						{
							if ( strNennweite <= 150  )
							{
								if (_betriebsbedingungen.daemmdicke <= 190 )	// von 170 in 190 gendert
								{
									if ( bIsEinschellig )
										strBild = 'B_LSL20_WD.jpg';  // nicht whlbar
									else strBild = 'B_LXV21_22_2_WD.jpg';
								}
								else strBild = 'blank.gif';
							}
							else if ( strNennweite <= 600 )  // war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXV23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXV24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
						else
						{
							if ( strNennweite <= 300 )
							{
								if ( _betriebsbedingungen.daemmdicke <= 240 )	// von 220 in 240 gendert
									strBild = 'B_LXV21_22_WW.jpg';
								else strBild = 'blank.gif';
							}
							else if ( strNennweite <= 600 )  //  war 800
							{
								if ( _betriebsbedingungen.daemmdicke <= 290 )	// von 270 in 290 gendert
									strBild = 'B_LXV23.jpg';
								else strBild = 'blank.gif';
							}
							else
							{
								if ( _betriebsbedingungen.daemmdicke <= 290)	// von 270 in 290 gendert 
									strBild = 'B_LXV24_2.jpg';
								else strBild = 'blank.gif';
							}
						}
					}
				}

			}

			// Bilder fr Loslager bei ungedmmter Isolierung
			if ( strIsolierung == 'ID_UNGEDAEMMT' )
			{
				// Bilder fr Loslager bei ungedmmter Isolierung und reibungsarmer Gleitart
				if ( strGleitart == 'ID_REIBUNGSARM' )
				{
					if ( bIsGleitunterlage )
					{
						if ( strNennweite <= 300 )
							strBild = 'B_LKL10_UD.jpg';
						else strBild = 'blank.gif';
					}
					else
					{
						if ( strNennweite <= 40 )
							strBild = 'B_LKL20_UD.jpg';
						else if ( strNennweite <= 150 )
							strBild = 'B_LKL21_22_UD.jpg';
						else if ( strNennweite <= 700 )
							strBild = 'B_LKL23_UD.jpg';
						else strBild = 'B_LKL23_UD_NO_700.jpg';
					}
				}
				else
				{
					if ( strNennweite <= 80 )
						strBild = 'B_LSL20_UD.jpg';
					else strBild = 'B_LSL23_UD.jpg';
				}
			}

			// Bilder fr Loslager bei Vorisolierung
			if ( strIsolierung == 'ID_VORISOLIERT' )
			{
				if ( ( strGleitart == 'ID_REIBUNGSARM' ) && ( _betriebsbedingungen.temperatur <= 450 ) )
				{
					if ( strNennweite == 15 )
						strBild = 'B_IKL21_22_NO_20.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_IKL21_22.jpg';
					else if ( strNennweite <= 125 )
						strBild = 'B_IKL23.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_IKL24.jpg';
					else strBild = 'B_IKL24_NO_600.jpg';
				}
				else strBild = 'blank.gif';
			}
		}
// neu

		// Bilder fr einfache Fhrungslager mit schweibarer Abhebesicherung
		if ( strLagerart == 'ID_FUEHRUNGSLAGER_W' )
		{
			if (_betriebsbedingungen.temperatur <= 300)
			{
				if ( strNennweite <= 150  )
				{
					if (_betriebsbedingungen.daemmdicke <= 170 )
					{
						if ( bIsEinschellig )
							strBild = 'B_LSW20_1_WD.jpg';
						else strBild = 'B_LSW21_22_1_WD.jpg';
					}
							
					else strBild = 'blank.gif';
				}

				else if ( strNennweite <= 400 )
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW23_WW.jpg';
					else strBild = 'blank.gif';
				}
				else if ( strNennweite <= 700 )
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW24_1_WW.jpg';
					else strBild = 'blank.gif';
				}
				else
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW24_2_WW.jpg';
					else strBild = 'blank.gif';
				}
				strBild	= '2_' + strBild;	// momentan gibts nur Variante mit 2 AHS
			}
			else
			{
				if ( strNennweite <= 150 )
				{
					if ( _betriebsbedingungen.daemmdicke <= 220 )
						strBild = 'B_LSW21_22_2_WD.jpg';
					else strBild = 'blank.gif';
				}
				else if ( strNennweite <= 400 )
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW23_WW.jpg';
					else strBild = 'blank.gif';
				}
				else if ( strNennweite <= 700 )
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW24_1_WW.jpg';
					else strBild = 'blank.gif';
				}
				else
				{
					if ( _betriebsbedingungen.daemmdicke <= 270 )
						strBild = 'B_LSW24_2_WW.jpg';
					else strBild = 'blank.gif';
				}
				
				strBild	= '2_' + strBild;	// momentan gibts nur Variante mit 2 AHS
			}
		}
//


		// Bilder fr einfache Fhrungslager
		if ( strLagerart == 'ID_FUEHRUNGSLAGER' )
		{
			// Bilder fr einfache Fhrungslager mit wrmegedmmter Isolierung
			if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
			{
				// Bilder fr einfache Fhrungslager mit wrmegedmmter Isolierung und reibungsarmer Gleitart
				if ( strGleitart == 'ID_REIBUNGSARM' )
				{
					if ( !bIsGleitunterlage )
					{
						if ( bIsHoehenverstellung )
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( bIsEinschellig )
									strBild = 'B_LVG20_WD.jpg';
								else strBild = 'B_LVG21_22_WD.jpg';
							}
							else strBild = 'B_LVG23.jpg';
						}
						else
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( _betriebsbedingungen.daemmdicke <= 85 )
								{
									if ( bIsEinschellig )
										strBild = 'B_LKG20_1_WD.jpg';
									else strBild = 'B_LKG21_22_1_WD.jpg';
								}
								else
								{
									if ( _betriebsbedingungen.daemmdicke <= 170 )
									{
										if ( bIsEinschellig )
											strBild = 'B_LKG20_2_WD.jpg';
										else strBild = 'B_LKG21_22_1_WD.jpg';
									}
								}
							}
							else strBild = 'B_LKG23_WD.jpg';
						}
					}
					else
					{
						if ( bIsHoehenverstellung )
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( bIsEinschellig )
									strBild = 'B_LVG40_WD.jpg';
								else strBild = 'B_LVG41_42_WD.jpg';
							}
							else strBild = 'B_LVG43_WD.jpg';
						}
						else
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( _betriebsbedingungen.daemmdicke <= 85 )
								{
									if ( bIsEinschellig )
										strBild = 'B_LKG40_1_WD.jpg';
									else strBild = 'B_LKG41_42_1_WD.jpg';
								}
								else
								{
									if ( _betriebsbedingungen.daemmdicke <= 170 )
									{
										if ( bIsEinschellig )
											strBild = 'B_LKG40_2_WD.jpg';
										else strBild = 'B_LKG41_42_2_WD.jpg';
									}
								}
							}
							else strBild = 'B_LKG43_WD.jpg';
						}
					}
				}

				// Bilder fr einfache Fhrungslager mit wrmegedmmter Isolierung und einfacher Gleitart
				if ( strGleitart == 'ID_EINFACH' )
				{
					if ( _betriebsbedingungen.temperatur <= 300 )
					{
						if ( _betriebsbedingungen.daemmdicke <= 170 )
						{
							if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
							{
								if ( bIsEinschellig )
									strBild = 'B_LSG20_WD.jpg';
								else strBild = 'B_LSG21_22_WD.jpg';
							}
							else strBild = 'B_LSG23_WD.jpg';
						}
						else strBild = 'blank.gif';
					}
					else
					{
						if ( ( strNennweite <= 300 ) || ( strAussendurchmesser <= 324 ) )
						{
							if ( _betriebsbedingungen.daemmdicke <= 220 )
								strBild = 'B_LSG21_22_WW.jpg';
							else strBild = 'blank.gif';
						}
						else
						{
							if ( _betriebsbedingungen.daemmdicke <= 270 )
								strBild = 'B_LSG23_WW.jpg';
							else strBild = 'blank.gif';
						}
					}
				}
			}

			// Bilder fr einfache Fhrungslager mit ungedmmter Isolierung
			if ( strIsolierung == 'ID_UNGEDAEMMT' )
			{
				// Bilder fr einfache Fhrungslager mit ungedmmter Isolierung und reibungsarmer Gleitart
				if ( strGleitart == 'ID_REIBUNGSARM' )
				{
					if ( bIsGleitunterlage )
					{
						if ( strNennweite <= 80 )
							strBild = 'B_LKG10_1_UD.jpg';
						else
						{
							if ( strNennweite <= 300 )
								strBild = 'B_LKG10_2_UD.jpg';
							else strBild = 'blank.gif';
						}
					}
					else
					{
						if ( strNennweite <= 40 )
							strBild = 'B_LKG20_UD.jpg';
						else
						{
							if ( strNennweite <= 40 )
								strBild = 'B_LKG20_UD.jpg';
							else if ( strNennweite <= 150 )
								strBild = 'B_LKG21_22_UD.jpg';
							else if ( strNennweite <= 700 )
								strBild = 'B_LKG23_UD.jpg';
							else strBild = 'blank.gif';
						}
					}
				}
			}

			// Bilder fr einfache Fhrungslager mit Vorisolierung
			if ( strIsolierung == 'ID_VORISOLIERT' )
			{
				if ( ( strGleitart == 'ID_REIBUNGSARM' ) && ( _betriebsbedingungen.temperatur <= 450 ) )
				{
					if ( strNennweite == 15 )
						strBild = 'B_IKG21_22_NO_20.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_IKG21_22.jpg';
					else if ( strNennweite <= 125 )
						strBild = 'B_IKG23.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_IKG24.jpg';
					else strBild = 'B_IKG24_NO_600.jpg';
				}
				else strBild = 'blank.gif';
			}
		}

		// Bilder fr spezielle Fhrungslager
		if ( bFuehrungVorhanden )
		{
			// Bilder fr spezielle Fhrungslager bei reibungsarmer Gleitart
			if ( strGleitart == 'ID_REIBUNGSARM' )
			{
				if ( strLagerart == 'ID_FUEHRUNG_W2_180' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LKF21_1_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LKF21_1.jpg';
					else if ( strNennweite <= 200 )
						strBild = 'B_LKF21_1.jpg';
					else if ( strNennweite <= 800 )
						strBild = 'B_LKF23.jpg';
					else strBild = 'B_LKF23_NO_800.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W2_180_PLUS' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LKF51_1_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LKF51_1.jpg';
					else if ( strNennweite <= 200 )
						strBild = 'B_LKF51_1.jpg';
					else if ( strNennweite <= 800 )
						strBild = 'B_LKF53.jpg';
					else strBild = 'B_LKF53_NO_800.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W2_090' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LKF61_1_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LKF61_1.jpg';
					else if ( strNennweite <= 200 )
						strBild = 'B_LKF61_1.jpg';
					else if ( strNennweite <= 800 )
						strBild = 'B_LKF63.jpg';
					else strBild = 'B_LKF63_NO_800.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W3' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LKF31_1_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LKF31_1.jpg';
					else if ( strNennweite <= 200 )
						strBild = 'B_LKF31_1.jpg';
					else if ( strNennweite <= 800 )
						strBild = 'B_LKF33.jpg';
					else strBild = 'B_LKF33_NO_800.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W4' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LKF41_1_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LKF41_1.jpg';
					else if ( strNennweite <= 200 )
						strBild = 'B_LKF41_1.jpg';
					else if ( strNennweite <= 800 )
						strBild = 'B_LKF43.jpg';
					else strBild = 'B_LKF43_NO_800.jpg';
				}
			}
			
			// Bilder fr spezielle Fhrungslager bei einfacher Gleitart
			if ( strGleitart == 'ID_EINFACH' )
			{
				if ( strLagerart == 'ID_FUEHRUNG_W2_180' ) // bis 300C nur ab DN 100 whlbar
				{
					if ( strNennweite < 40 )
						strBild = 'B_LSF21_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LSF21.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_LSF23.jpg';
					else strBild = 'B_LSF24_2.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W2_180_PLUS' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LSF51_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LSF51.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_LSF53.jpg';
					else strBild = 'B_LSF53_NO.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W2_090' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LSF61_NO.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LSF61.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_LSF63.jpg';
					else strBild = 'B_LSF64_2.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W3' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LSF31_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LSF31.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_LSF33.jpg';
					else strBild = 'B_LSF34_2.jpg';
				}
				else if ( strLagerart == 'ID_FUEHRUNG_W4' )
				{
					if ( strNennweite < 40 )
						strBild = 'B_LSF41_NO_40.jpg';
					else if ( strNennweite <= 80 )
						strBild = 'B_LSF41.jpg';
					else if ( strNennweite <= 600 )
						strBild = 'B_LSF43.jpg';
					else strBild = 'B_LSF44_2.jpg';
				}
			}
		}
		if ( _betriebsbedingungen.temperatur > 650 )
			strBild = 'blank.gif';
		
		// setze das Bild
		strBild = strLGImgVar + strLGRichtAkt + '_' + strBild;
		var strFile = 'catalog/client/custom/img/WITgifs/RH/' + strBild;
		var openMode = '$*.OPEN_MODE_CASCADE$';
		if ((openMode == "NEW") || (openMode == "LAGER"))
			Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="' + strFile + '" /></center>' );
	}

	/**
	 * der Benutzer hat die Hhenverstellung gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedHoehenverstellung()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		
		// bei Festlager mit Hhenverstellung sind klemmbar und schraubbar erlaubt
		_bCheckboxHandlerNichtAktivieren = true;
		if ( strLagerart == 'ID_FESTLAGER' )
		{
			if ( f.findField( 'IDC_HOEHENVERSTELLUNG' ).getValue() )
			{
				var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
				var checkSchraubbar = f.findField( 'IDC_SCHRAUBBAR' );
				
				// Klemmbar wird empfohlen
				checkKlemmbar.enable();
				checkKlemmbar.setValue( true );
				checkSchraubbar.enable();
				checkSchraubbar.setValue( false );
			}
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}
	
	/**
	 * der Benutzer hat die Gleitunterlage gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedGleitunterlage()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strGleitart = f.findField( 'IDC_GLEITART' ).getValue();
		
		_bCheckboxHandlerNichtAktivieren = true;
		if ( strLagerart == 'ID_LOSLAGER')
		{
			// bei Loslagern mit Gleitunterlage ist klemmbar zwingend notwendig,
			// bei Loslagern ohne Gleitunterlage darf klemmbar nicht gewhlt werden
			var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
			if ( f.findField( 'IDC_GLEITUNTERLAGE' ).getValue() )
				checkKlemmbar.setValue( true );
			else checkKlemmbar.setValue( false );
			checkKlemmbar.disable();
		}
		
		// bei ungedmmter Isolierung mit reibungsarmer Gleitart 
		if ( ( strIsolierung == 'ID_UNGEDAEMMT' ) && ( strGleitart == 'ID_REIBUNGSARM' ) )
		{
			// ist Gleitunterlage gewhlt und die Nennweite ist <40mm, ist einschellig zwingend notwendig, 
			// ansonsten darf einschellig nicht gewhlt werden
			var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );
			if ( !f.findField( 'IDC_GLEITUNTERLAGE' ).getValue() )
			{
				var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
				if ( strNennweite <= 40 )
					checkEinschellig.setValue( true );
				else checkEinschellig.setValue( false );
			}
			else checkEinschellig.setValue( false );
			checkEinschellig.disable();
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * der Benutzer hat klemmbar oder schraubbar gewechselt; jetzt wird getestet, ob genau eine davon angewhlt ist
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedTraegerbefestigung()
	{
		var f = _form.getForm();
		var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
		var checkSchraubbar = f.findField( 'IDC_SCHRAUBBAR' );
		
		// es mu sichergestellt sein, da, wenn Trgerbefestigungen whlbar sind, genau eine davon immer ausgewhlt sind
		_bCheckboxHandlerNichtAktivieren = true;
		if ( !checkKlemmbar.getValue() && !checkSchraubbar.getValue() )
		{
			if ( _meldungen.msgFestlagerKlemmbarSchraubbar )
				Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgFestlagerKlemmbarSchraubbar );

			checkKlemmbar.enable();
			checkKlemmbar.setValue( true );
			checkSchraubbar.enable();
			checkSchraubbar.setValue( false );
			_testeHoehenverstellung();
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * der Benutzer hat 'klemmbar' gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedKlemmbar()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
		var strAussendurchmesser = f.findField( 'IDC_AUSSENDURCHMESSER' ).getValue();

		// sepzielle Behandlung fr Festlager, wenn klemmbar gewhlt ist
		_bCheckboxHandlerNichtAktivieren = true;
		if ( strLagerart == 'ID_FESTLAGER' )
		{
			var checkSchraubbar = f.findField( 'IDC_SCHRAUBBAR' );
			var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );
			var checkBuegelausfuehrung = f.findField( 'IDC_BUEGELAUSFUEHRUNG' );
			var checkHoehenverstellung = f.findField( 'IDC_HOEHENVERSTELLUNG' );
			
			_onClickedTraegerbefestigung();
			if ( f.findField( 'IDC_KLEMMBAR' ).getValue() )
			{
				checkSchraubbar.enable();
				checkSchraubbar.setValue( false );

				// bei wrmegedmmter Isolierung knnen Einschellig und Hhenausfhrung gewhlt werden, wenn die Betriebstemperaturen <= 300 C sind,
				// bei Betriebstemperaturen > 300 C drfen sie nicht gewhlt werden
				if ( strIsolierung == 'ID_WAERMEGEDAEMMT' )
				{
					if ( _betriebsbedingungen.temperatur <= 300 )
					{
						if ( ( strNennweite <= 150 ) || ( strAussendurchmesser <= 169 ) )
							checkEinschellig.enable();

						checkHoehenverstellung.enable();
					}
					else
					{
						checkEinschellig.setValue( false );
						checkEinschellig.disable();

						checkHoehenverstellung.setValue( false );
						checkHoehenverstellung.disable();
					}
				}
				
				// bei ungedmmter Isolierung drfen einschellig und Bgelausfhrung gewhlt werden, wenn die Nennweite <= 300 mm ist,
				// ansonsten drfen sie nicht gewhlt werden
				else if ( strIsolierung == 'ID_UNGEDAEMMT' )
				{
					if ( strNennweite <= 300 )
					{
						checkEinschellig.enable();
						checkBuegelausfuehrung.enable();
					}
					else
					{
						checkEinschellig.setValue( false );
						checkEinschellig.disable();

						checkBuegelausfuehrung.setValue( false );
						checkBuegelausfuehrung.disable();
					}
				}
			}
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * der Benutzer hat 'schraubbar' gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedSchraubbar()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();

		// sepzielle Behandlung fr Festlager, wenn schraubbar gewhlt ist
		_bCheckboxHandlerNichtAktivieren = true;
		if ( strLagerart == 'ID_FESTLAGER' )
		{
			var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
			_onClickedTraegerbefestigung();
			
			if ( f.findField( 'IDC_SCHRAUBBAR' ).getValue() )
			{
				var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );
				var checkBuegelausfuehrung = f.findField( 'IDC_BUEGELAUSFUEHRUNG' );
				var checkHoehenverstellung = f.findField( 'IDC_HOEHENVERSTELLUNG' );
				var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
				
				// kein klemmbar mehr
				checkKlemmbar.enable();
				checkKlemmbar.setValue( false );
				
				// Hhenverstellung und Einschellig darf nicht mehr gewhlt werden
				checkHoehenverstellung.disable();
				checkHoehenverstellung.setValue( false );
				checkEinschellig.disable();
				checkEinschellig.setValue( false );

				// bei ungedmmter Isolierung darf auch keine Bgelausfhrung mehr gewhlt werden,
				// anstelle von vorisoliert mu immer 'wrmegedmmt gewhlt werden
				if ( strIsolierung == 'ID_UNGEDAEMMT' )
				{
					checkBuegelausfuehrung.disable();
					checkBuegelausfuehrung.setValue( false );
				}
				else if ( strIsolierung == 'ID_VORISOLIERT' )
					f.findField( 'IDC_ISOLIERUNG' ).setValue( 'ID_WAERMEGEDAEMMT' );
			}
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * der Benutzer hat 'einschellig' gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedEinschellig()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		
		_bCheckboxHandlerNichtAktivieren = true;
		if ( ( strLagerart == 'ID_FESTLAGER' ) && ( strIsolierung == 'IDC_UNGEDAEMMT' ) )
		{
			var checkBuegelausfuehrung = f.findField( 'IDC_BUEGELAUSFUEHRUNG' );
			checkBuegelausfuehrung.enable();
			
			if ( f.findField( 'IDC_EINSCHELLIG' ).getValue() )
				checkBuegelausfuehrung.setValue( false );
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}
	
	
	/**
	 * der Benutzer hat die Bgelausfhrung gewechselt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedBuegelausfuehrung()
	{
		var f = _form.getForm();
		var strLagerart = f.findField( 'IDC_LAGERART' ).getValue();
		var strIsolierung = f.findField( 'IDC_ISOLIERUNG' ).getValue();
		
		_bCheckboxHandlerNichtAktivieren = true;
		if ( ( strLagerart == 'ID_FESTLAGER' ) && ( strIsolierung == 'IDC_UNGEDAEMMT' ) )
		{
			var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );
			var checkKlemmbar = f.findField( 'IDC_KLEMMBAR' );
			var checkSchraubbar = f.findField( 'IDC_SCHRAUBBAR' );
			
			checkEinschellig.enable();
			if ( f.findField( 'IDC_BUEGELAUSFUEHRUNG' ).getValue() )
			{
				checkKlemmbar.enable();
				checkKlemmbar.setValue( true );
				checkSchraubbar.enable();
				checkSchraubbar.setValue( false );
				checkEinschellig.setValue( false );
			}
		}
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * testet, ob eine Lagerart ein spezielles Fhrungslager bezeichnet
	 *
	 * @params string strLagerart - die Lagerart
	 * @returns	boolean true - Lagerart ist spezielles Fhrungslager
	 *                  false - Lagerart ist kein spezielles Fhrungslager
	 */
	function _isSpeziellesFuehrungslager( strLagerart )
	{
		var bFuehrung = false;
		if ( ( strLagerart == 'ID_FUEHRUNG_W2_180' ) || ( strLagerart == 'ID_FUEHRUNG_W2_180_PLUS' ) ||
			 ( strLagerart == 'ID_FUEHRUNG_W2_090' ) || ( strLagerart == 'ID_FUEHRUNG_W3' ) || ( strLagerart == 'ID_FUEHRUNG_W4' ) )
			bFuehrung = true;
			
		return( bFuehrung );
	}
	
	/**
	 * wird aufgerufen, wenn der Suchvorgang erfolgreich beendet wurde
	 *
	 * @params object response: Resultat des Suchvorgangs (gefundene Lager, evtl Suchmeldung etc.)
	 * @returns	-
	 */
	function _updateSuchresultate( response )
	{
		if ( response.success )
			_table.getStore().load();			
		else _resetTable();
		if ( response.data.strMeldung )
			Ext.Msg.alert( _meldungen.msgTitel, response.data.strMeldung );
	}	
	
	/**
	 * lscht alle Zeilen in der Tabelle
	 *
	 * @params -
	 * @returns	-
	 */
	function _resetTable()
	{
		_table.store.removeAll();
	}
	
	/**
	 * hole den Index der aktuell gewhlten Zeile in der Lagertabelle
	 *
	 * @params -
	 * @returns	integer - Index der aktuell gewhlten Zeile, 
	 *                    -1, wenn kein Lager gewhlt ist
	 */
	 function _holeLagerIndex()
	 {
		var rcSelected = _table.getSelectionModel().getSelected();
		var nIndex = -1;
		if ( rcSelected )
			nIndex = rcSelected.id - 1;
			
		return( nIndex );
	 }

	/**
	 * zustzliche Werte, die bei der Initialisierung vom Server bergeben und beim Bearbeiten der Produktlogik gebraucht werden,
	 * werden hier in private Variablen gespeichert
	 *
	 * @params object response: Resultat des Initialisierungsvorgangs (UI-Variablen, Betriebsbedingungen, Meldungen)
	 * @returns	-
	 */
	function _transferToInternalData( response )
	{
		// betriebsbedingungen
		_betriebsbedingungen = 
		{
			temperatur: response.data.temperatur,
			daemmdicke: response.data.daemmdicke,
			wx: response.data.wx,
			wy: response.data.wy
		};
	
		// Meldungstexte
		_meldungen = 
		{
			msgVerschiebungBeiFestlager : response.data.msgVerschiebungBeiFestlager,
			msgFuehrungslagerBei450Grad : response.data.msgFuehrungslagerBei450Grad,
			msgFuehrungslagerBeiDN600 : response.data.msgFuehrungslagerBeiDN600,
			msgVerschiebungBeiFuehrungslager : response.data.msgVerschiebungBeiFuehrungslager,
			msgFuehrungBeiDaemmung : response.data.msgFuehrungBeiDaemmung,
			msgReibungsarmGleitendDN800 : response.data.msgReibungsarmGleitendDN800,
			msgDaemmungMitUngedaemmt : response.data.msgDaemmungMitUngedaemmt,
			msgEinfachGleitend : response.data.msgEinfachGleitend,
			msgReibungsarmGleitend : response.data.msgReibungsarmGleitend,
			msgFestlagerKlemmbarSchraubbar : response.data.msgFestlagerKlemmbarSchraubbar,
			msgSuche : response.data.msgSuche,
			msgGLEITBLECH : response.data.msgGLEITBLECH
		};
        
        _strAuswahlKontext = response.data.strAuswahlKontext;
	}
	
	// public functions
	return {
		init: function( idx )
		{				
			// wenn noch kein Dialog erzeugt wurde - erster Aufruf der Funktion - mu das Panel erst erzeugt und in 
			// die bestehenden UI-Strukturen eingefgt werden
			if ( !_form ) 
			{				
				_bCheckboxHandlerNichtAktivieren = true;
				
				// private Daten fr Comboboxen etc. initialisieren
				_initStaticData();
				
				// erzeuge Tabelle fr Suchresultate Lager
				_table = new Ext.grid.GridPanel(
				{
					id: 'lager_tabelle',
					store: new Ext.data.Store(
					{
						proxy: new Ext.data.HttpProxy(
						{
							url: 'lager_auswahl/hole_lagerliste',
							success: function( response, options )
							{
								//_resetTable();
							}
						} ),
						reader: new Ext.data.JsonReader(
						{
							root: 'rows',
							id: 'id'
						},
						[
							{ name: 'typ' },
							{ name: 'nennweite' },
							{ name: 'nennhoehe' },
							{ name: 'emass' },
							{ name: 'max_daemmdicke' },
							{ name: 'auflagelast_minus_fz' },
							{ name: 'axiallast_fy' },
							{ name: 'querlast_fx' },
							{ name: 'abhebelast_fz' },
							{ name: 'gewicht' },
							{ name: 'preis' }
						] )
					} ),
					
					columns: [
						{ 	
							// Typ
							header: '$TCH_TYP$', 
							width: 120, 
							sortable: true, 
							dataIndex: 'typ'
						},
						{ 	
							// Nennweite
							header: '$TCH_RH_NENNWEITE$',
							width: 45,
							sortable: true,
							dataIndex: 'nennweite'
						},
						{ 	
							// Nennhhe
							header: '$TCH_NENNHOEHE$',
							width: 45, 
							sortable: true,
							dataIndex: 'nennhoehe'
						},
						{ 	
							// E-Mass
							header: '$TCH_EMASS$',
							width: 60, 
							sortable: true,
							dataIndex: 'emass'
						},
						{ 
							// maximale Dmmdicke J
							header: '$TCH_MAXDAEMMDICKE$', 
							width: 60, 
							sortable: true,
							dataIndex: 'max_daemmdicke'
						},
						{ 
							// Auflagelast -Fz
							header: '$TCH_AUFLAGELAST$', 
							width: 60, 
							sortable: true,
							dataIndex: 'auflagelast_minus_fz' 
						},
						{ 
							// Axiallast Fy
							header: '$TCH_AXIALLAST$', 
							width: 60, 
							sortable: true,
							dataIndex: 'axiallast_fy' 
						},
						{ 
							// Querlast Fx
							header: '$TCH_QUERLAST$', 
							width: 60, 
							sortable: true,
							dataIndex: 'querlast_fx' 
						},
						{ 
							// Abhebelast Fz
							header: '$TCH_ABHEBELAST$', 
							width: 60, 
							sortable: true,
							dataIndex: 'abhebelast_fz' 
						},
						{ 
							// Gewicht
							header: '$TCH_GEWICHT$', 
							width: 55, 
							sortable: true,
							dataIndex: 'gewicht' 
						},
						{ 
							// Preis
							header: '$*.TMP.HEADER.TCH_PREIS$', 
							width: 45, 
							sortable: true,
							dataIndex: 'preis' 
						}
					],
					/*
					viewConfig: {
						forceFit: true
					},
					*/
					sm: new Ext.grid.RowSelectionModel( { singleSelect: true} ),
										
					width: 690,
					//autoWidth: true,
					height: 190,
					frame: false,
					border: false,
					title: '',
					header: false
				} );
				
				// erzeuge Panel
				_form = new Ext.FormPanel( 
				{
					url:'lager_auswahl/set-values',
					title: '$LAGER_AUSWAHL$',
					id: 'lager_auswahl',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.LAGER_AUSWAHL' },
					listeners: 
					{
						'actioncomplete': this.onActionComplete,
						'beforeaction': this.onBeforeAction
					},
					
					labelAlign: 'top',
					labelStyle: 'font-size:11px',
					bodyStyle:'padding:0 5px 0',
					frame: true,
					
					items: [ 
					{
						layout: 'column',
						items: [
						{
							width: 170,
							layout: 'form',
							
							items: [
							{
								xtype: 'combo',
								hiddenName:'IDC_LAGERART',
								fieldLabel: '$IDC_LAGERART_LABEL$',
								labelWidth: 180,
								store: _storeLagerart,
								listeners: {
									'select' : this.onChangedLagerart 
								},
								displayField: 'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
                                listWidth: 130,
								editable: false
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_GLEIT_LABEL$',
								labelWidth: 180,
								hiddenName:'IDC_GLEITART',
								store: _storeGleitart,
								listeners: {
									'select' : this.onChangedGleitart 
								},
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
                                listWidth: 130,
								editable: false
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_ISOLIERUNG_LABEL$',
								labelWidth: 180,
								hiddenName:'IDC_ISOLIERUNG',
								store: _storeIsolierung,
								listeners: {
									'select' : this.onChangedIsolierung
								},
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
                                listWidth: 130,
								editable: false
							},
							{
								xtype: 'button',
								minWidth: 130,
								style: 'margin-top: 35px;',
								text: '$IDC_SUCHEN_BUT$',
								handler: function() 
								{
									_form.getForm().submit(
									{
										url : 'lager_auswahl/suche_lager',
										success: function( response, options ) 
										{
											_updateSuchresultate( options.result );
										},
										failure: function( response, options ) 
										{
											_updateSuchresultate( options.result );
										}
									} );
								}
							},{
							xtype: 'fieldset',
							style: 'padding: 5px',
							autoWidth: true,
							autoHeight: true,
							//hidden: false,
							hidden: true,
							defaultType: 'textfield',
							hideLabels: true,
							disabled: true,
							items: [{
								id: 'LG_IMG_VAR',
								name: 'LG_IMG_VAR'
								},{
								id: 'LG_RICHT_AKT',
								name: 'LG_RICHT_AKT'
								}]
						}]
						},
						{
							width: 130,
							layout: 'form',
							
							items: [
							{
								xtype: 'combo',
								fieldLabel: '$IDC_WERKSTOFF_LABEL$',
								labelWidth: 110,
								hiddenName:'IDC_WERKSTOFF',
								store: _storeWerkstoff,
								
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 60,
                                listWidth: 60,
								editable: false,
								listeners: 
								{
									'select': this.onChangedWerkstoff
								}
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_NENNWEITE_LABEL$',
								labelWidth: 110,
								labelSeparator: '',
								hiddenName:'IDC_NENNWEITE',
								store: _storeNennweite,
								
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 60,
                                listWidth: 60,
								editable: false,
								listeners: 
								{
									'select': this.onChangedNennweite
								}
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_AUSSENDURCH_LABEL$',
								labelWidth: 110,
								hiddenName:'IDC_AUSSENDURCHMESSER',
								store: _storeAussendurchmesser,
								
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 60,
                                listWidth: 60,
								editable: false,
								listeners: 
								{
									'select': this.onChangedAussendurchmesser
								}
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_GLEITELEMENT_LABEL$',
								labelWidth: 110,
								hiddenName:'IDC_GLEITELEMENT',
								store: _storeGleitelement,
								listeners: 
								{
									'select' : this.onChangedGleitelement
								},
								hideParent: true,
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 60,
                                listWidth: 60,
								editable: false
							},
							{
								xtype: 'combo',
								fieldLabel: '$IDC_MANTELDURCH_LABEL$',
								labelWidth: 110,
								hiddenName:'IDC_MANTELDURCHMESSER',
								store: new Ext.data.SimpleStore( {
									fields: ['value', 'text'],
									data : []
								} ),
								listeners: 
								{
									'select' : this.onChangedManteldurchmesser
								},
								hideParent: true,
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 60,
                                listWidth: 60,
								editable: false
							} ]
						},
						{
							width: 180,
							layout: 'form',
							items: [
							{							
								xtype: 'fieldset',
								autoHeight: true,
								hideLabels: true,
								//width: 175,
								title: '$IDC_ZUSATZFUNKTIONEN_LABEL$',
								defaultType: 'checkbox',
								items: [
								{
									id:'IDC_ABHEBESICHERUNG',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_ABHEBESICHERUNG_LABEL$',
									listeners: {
										'check' : this.onCheckAbhebesicherung
									}
								},
								{
									id:'IDC_HOEHENVERSTELLUNG',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_HOEHENVERSTELLUNG_LABEL$',
									listeners: {
										'check' : this.onCheckHoehenverstellung
									}
								},
								{
									id:'IDC_GLEITUNTERLAGE',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_GLEITUNTERLAGE_LABEL$',
									listeners: {
										'check' : this.onCheckGleitunterlage 
									}
								},
								{
									id:'IDC_KLEMMBAR',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_KLEMMBAR_LABEL$',
									listeners: {
										'check' : this.onCheckKlemmbar
									}
								},
								{
									id:'IDC_SCHRAUBBAR',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_SCHRAUBBAR_LABEL$',
									listeners: {
										'check' : this.onCheckSchraubbar
									}
								},
								{
									id:'IDC_EINSCHELLIG',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_EINSCHELLIG_LABEL$',
									listeners: {
										'check' : this.onCheckEinschellig
									}
								},
								{
									id:'IDC_BUEGELAUSFUEHRUNG',
									inputValue: 'true',
									autoWidth: true,
									disabled: true,
									boxLabel:'$IDC_BUEGELAUSFUEHRUNG_LABEL$',
									listeners: {
										'check' : this.onCheckBuegelausfuehrung
									}
								} ]
							} ]
						},
						{
							xtype: 'panel',
							id: 'IDC_LAGER_IMAGE',
							style: "margin-left: 15px; margin-top:20px",
							html: '<img src="catalog/client/custom/img/WITgifs/RH/blank.png" />'
						} ]
					},
					{						
						layout: 'fit',
						width: 690,
						items: [ 
							_table,
							{
								xtype: 'hidden',
								id: 'IDC_LAGER_TABLE_INDEX'
							} ]
					}]
                } );
				
				// insert panel into main form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, _form );
				cp.doLayout();
				_bCheckboxHandlerNichtAktivieren = false;
			}
			
			_bCheckboxHandlerNichtAktivieren = true;
			_table.getStore().load();
			//_form.getForm().reset();
			_form.load( {
				url: 'lager-auswahl/get-values',
 				success: function( response, options ) 
				{
					_transferToInternalData( options.result );
                    var f = _form.getForm();
                    var cbLagerart = f.findField( 'IDC_LAGERART' );
                    var cbIsolierung = f.findField( 'IDC_ISOLIERUNG' );
                    var cbGleitart = f.findField( 'IDC_GLEITART' );
                    var checkEinschellig = f.findField( 'IDC_EINSCHELLIG' );
					var strNennweite = f.findField( 'IDC_NENNWEITE' ).getValue();
					var strAussendurchmesser = f.findField( 'IDC_AUSSENDURCHMESSER' ).getValue();
                    if ( _strAuswahlKontext != 'EINZEL_LAGER' )
                    {
                        cbLagerart.setValue( 'ID_LOSLAGER' );
                        cbIsolierung.setValue( 'ID_WAERMEGEDAEMMT' );
						if ( _strAuswahlKontext == 'STUETZE_PTFE' )
							cbGleitart.setValue( 'ID_GLEITBLECH' );
						else cbGleitart.setValue( 'ID_EINFACH' );
                        checkEinschellig.setValue( false );
                        cbLagerart.disable();
                        cbIsolierung.disable();
                        cbGleitart.disable();
						if ( (( strNennweite <= 150 ) || ( strAussendurchmesser <= 169 )) && (_strAuswahlKontext != 'STUETZE_PTFE') )
							checkEinschellig.enable();
						else checkEinschellig.disable();
                        _showManteldurchmesser( false );
						_showGleitelement( false );
                        // aktuelles Bild setzen
                        _setzeBild();
                    }
                    else
                    {
                        cbLagerart.enable();
                        cbIsolierung.enable();
                        cbGleitart.enable();
                        checkEinschellig.enable();
                        _onChangedLagerart();
                        _onChangedGleitart();
                        _onChangedIsolierung();
                    }
					_modifyComboManteldurchmesser( false );
                    _resetTable();
				}
			} );
			
			Ext.getCmp( 'move-next' ).enable();
			_bCheckboxHandlerNichtAktivieren = false;
		},
		
		/**
		 * Event, wenn der Benutzer die Lagerart gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedLagerart: function( combo, record, idx )
		{
			_onChangedLagerart();
			_resetTable();
		},

		/**
		 * Event, wenn der Benutzer die Gleitart gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedGleitart : function( combo, record, idx )
		{
			_onChangedGleitart();
			_resetTable();
		},

		/**
		 * Event, wenn der Benutzer die Isolierung gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedIsolierung : function( combo, record, idx )
		{
			_onChangedIsolierung();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer den Werkstoff gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */		
		onChangedWerkstoff : function( combo, record, idx )
		{
			// zur Zeit keine Abhngigkeiten der Werkstoffe zu anderen Filtermglichkeiten
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Nennweite gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedNennweite : function( combo, record, idx )
		{			
			// eine gewhlte Nennweite macht einen bestimmten Auendurtchmesser zwingend notwendig
			var cbAussendurchmesser = _form.getForm().findField( 'IDC_AUSSENDURCHMESSER' );
			var record = cbAussendurchmesser.store.getAt( idx );
			cbAussendurchmesser.setValue( record.get( 'value' ) );
			
			// nderungen an anderen auswahlrelevanten Werten testen
			_onChangedDurchmesser();
		},
		
		/**
		 * Event, wenn der Benutzer den Auendurchmesser gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedAussendurchmesser : function( combo, record, idx )
		{			
			// ein gewhlter Auendurchmesser macht eine bestimmte Nennweite zwingend notwendig
			var cbNennweite = f = _form.getForm().findField( 'IDC_NENNWEITE' );
			var record = cbNennweite.store.getAt( idx );
			cbNennweite.setValue( record.get( 'value' ) );
			
			// nderungen an anderen auswahlrelevanten Werten testen
			_onChangedDurchmesser();
		},
		
		/**
		 * Event, wenn der Benutzer den Manteldurchmesser gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedManteldurchmesser : function( combo, record, idx )
		{			
			_resetTable();
		},

		/**
		 * Event, wenn der Benutzer das Gleitelement gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedGleitelement : function( combo, record, idx )
		{
			_onChangedGleitelement();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Abhebesicherung angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckAbhebesicherung : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_ABHEBESICHERUNG' ).disabled )
				return;
			
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Hhenverstellung angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckHoehenverstellung : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_HOEHENVERSTELLUNG' ).disabled )
				return;

			_onClickedHoehenverstellung();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Gleitunterlage angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckGleitunterlage : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_GLEITUNTERLAGE' ).disabled )
				return;

			_onClickedGleitunterlage();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer 'klemmbar' angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckKlemmbar : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_KLEMMBAR' ).disabled )
				return;

			_onClickedKlemmbar();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer 'schraubbar' angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckSchraubbar : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_SCHRAUBBAR' ).disabled )
				return;

			_onClickedSchraubbar();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer 'einschellig' angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckEinschellig : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_EINSCHELLIG' ).disabled )
				return;

			_onClickedEinschellig();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Bgelausfhrung angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckBuegelausfuehrung : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_BUEGELAUSFUEHRUNG' ).disabled )
				return;

			_onClickedBuegelausfuehrung();
			_setzeBild();
			_resetTable();
		},
		
		/**
		 * Event, wenn ein Ajax-Request vollstndig bearbeitet ist
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
        onActionComplete : function( form, action ) 
		{
			// das Panel soll nur dann gewechselt werden, wenn der Submit wegen Click des 'next' Buttons erfolgt ist
			if ( action.options.url == form.url )
			{
				// teste, ob berhaupt ein Lager gesucht und ausgewhlt wurde
				var store = _table.getStore();
				if ( ( store.getCount() > 0 ) && _table.getSelectionModel().getSelected() )
					Cascade.app.getNextPanel( form, action );
			}
		},
		
		/**
		 * Event, der aufgerufen wird, bevor ein Ajax-Request ausgelst wird
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
		onBeforeAction : function( form, action ) 
		{
			if ( action.type == "submit"  ) 
			{
				var store = _table.getStore();
				
				// der Submit wegen Click des 'next' Buttons soll nur dann erfolgen, wenn ein Lager aus einer Lagerliste gewhlt ist
				if ( action.options.url == form.url )
				{
					// teste, ob berhaupt ein Lager gesucht und ausgewhlt wurde
					if ( ( store.getCount() <= 0 ) || !_table.getSelectionModel().getSelected() )
					{
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgSuche );
						return( false );
					}
				}
				store.commitChanges();
				
				// hole Index der selektierten Zeile
				var nIndex = _holeLagerIndex();
				if ( nIndex == -1 )
					nIndex = 0;
				
				// setze Index als Inhalt einer hidden-field
                _form.getForm().findField( 'IDC_LAGER_TABLE_INDEX' ).setValue( nIndex );				
			}
		}
	}
}();
