Ext.namespace('Cascade.panel.lager');
/**
 * @class Cascade.panel.lager.systemcharakteristik
 * <li>category   Client Lager
 * <li>package    Cascade.panel.lager
 * <li>copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 - new - 
 */
Cascade.panel.lager.systemcharakteristik = function() {
	var form;
	var bInital = false;
	
	var storeZubehoer = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	
	var _setShowCombo = function(strId){
		if(strId == "LAGER_ZUBEHOER")
			Ext.getCmp("LAGER_SYSTEMCHARAKTERISTIK_ZUBEHOER_COMBO").show();
		else
			Ext.getCmp("LAGER_SYSTEMCHARAKTERISTIK_ZUBEHOER_COMBO").hide();	
	}
	/**
	 * setze Dialog Daten
	 */	
	var _setGUI = function(message){
		bInital = true;
		var __showImg = function(strImage){
			Ext.getCmp( 'rohrrichtung-panel' ).body.update( '<center><img src="' + strImage + '" /></center>' );
		}
	
		var __setDisabledRadio = function(strId,bValue){
			if(bValue)
				Ext.getCmp(strId).disable();
			else
				Ext.getCmp(strId).enable();	
		}
		
		var __setValueRadio = function(strRadioGroupId,strValue){
			//Ext.getCmp(strRadioGroupId).suspendEvents(false);		
			Ext.getCmp(strValue).suspendEvents(false);			
			Ext.getCmp(strValue).setValue(true);			
			Ext.getCmp(strValue).resumeEvents();
			
			//Ext.getCmp(strRadioGroupId).resumeEvents();	
		}
				
		//LAGER
		if(message.lager){			
			if(message.lager.radiogroup.selection){
				__setValueRadio('IDC_LAGER',message.lager.radiogroup.selection);	
				_setShowCombo(message.lager.radiogroup.selection);
			}
			
			if(message.lager.store)
				storeZubehoer.loadData(message.lager.store);
			
			if(message.lager.value)
				Ext.getCmp("LAGER_SYSTEMCHARAKTERISTIK_ZUBEHOER_COMBO").setValue(message.lager.value)				
		}
		
		//ROHR
		if(message.rohr){
			if(message.rohr.krTDisable == true)
				Ext.getCmp("krT").disable();
			else if(message.rohr.krTDisable == false)
				Ext.getCmp("krT").enable();
			
			if(message.rohr.krTValue == true || message.rohr.krTValue == false)
				Ext.getCmp("krT").setValue(message.rohr.krTValue);		
			
			
			if(message.rohr.radiogroup){
				if(message.rohr.radiogroup.disable){
					if(message.rohr.radiogroup.disable.ROHR_W)
						__setDisabledRadio("ROHR_W",true);
					else
						__setDisabledRadio("ROHR_W",false);
							
					if(message.rohr.radiogroup.disable.ROHR_U)
						__setDisabledRadio("ROHR_U",true);
					else
						__setDisabledRadio("ROHR_U",false);
					
					if(message.rohr.radiogroup.disable.ROHR_vW)
						__setDisabledRadio("ROHR_vW",true);
					else
						__setDisabledRadio("ROHR_vW",false);
					
					if(message.rohr.radiogroup.disable.ROHR_vK)
						__setDisabledRadio("ROHR_vK",true);
					else
						__setDisabledRadio("ROHR_vK",false);
				}
				
				if(message.rohr.radiogroup.selection)
					__setValueRadio('IDC_ROHR',message.rohr.radiogroup.selection);
			}
		}
		
		if(message.rohrverlauf){
			if(message.rohrverlauf.selection)
				__setValueRadio('IDC_ROHRVERLAUF',message.rohrverlauf.selection);
		}
		
		if(message.rohrrichtung){
			if(message.rohrrichtung.selection)
				__setValueRadio('IDC_ROHRRICHTUNG',message.rohrrichtung.selection);
			
			if(message.rohrrichtung.disable){
				if(message.rohrrichtung.disable.LAGER_Z_ACHSE)
					__setDisabledRadio("LAGER_Z_ACHSE",true);
				else
					__setDisabledRadio("LAGER_Z_ACHSE",false);	
				
				if(message.rohrrichtung.disable.LAGER_X_ACHSE)
					__setDisabledRadio("LAGER_X_ACHSE",true);
				else
					__setDisabledRadio("LAGER_X_ACHSE",false);
				
				if(message.rohrrichtung.disable.LAGER_Y_ACHSE)
					__setDisabledRadio("LAGER_Y_ACHSE",true);
				else
					__setDisabledRadio("LAGER_Y_ACHSE",false);	
				
				if(message.rohrrichtung.disable.LAGER_SCHRAEG_ACHSE)
					__setDisabledRadio("LAGER_SCHRAEG_ACHSE",true);
				else
					__setDisabledRadio("LAGER_SCHRAEG_ACHSE",false);		
			}	
			
			if(message.rohrrichtung.hide){
				if(message.rohrrichtung.hide.LAGER_SCHRAEG_ALPHA)
					Ext.getCmp("LAGER_SCHRAEG_ALPHA_FORM").hide();
				else
					Ext.getCmp("LAGER_SCHRAEG_ALPHA_FORM").show();
				
				if(message.rohrrichtung.hide.LAGER_SCHRAEG_BETA)
					Ext.getCmp("LAGER_SCHRAEG_BETA_FORM").hide();
				else
					Ext.getCmp("LAGER_SCHRAEG_BETA_FORM").show();
			}
			
			if(message.rohrrichtung.value){
				if(!message.rohrrichtung.hide.LAGER_SCHRAEG_ALPHA)
					//Ext.getCmp("LAGER_SCHRAEG_ALPHA").setValue(message.rohrrichtung.hide.LAGER_SCHRAEG_ALPHA);
					Ext.getCmp("LAGER_SCHRAEG_ALPHA").setValue(message.rohrrichtung.value.LAGER_SCHRAEG_ALPHA);
				
				if(!message.rohrrichtung.hide.LAGER_SCHRAEG_BETA)
					//Ext.getCmp("LAGER_SCHRAEG_BETA").setValue(message.rohrrichtung.hide.LAGER_SCHRAEG_BETA);
					Ext.getCmp("LAGER_SCHRAEG_BETA").setValue(message.rohrrichtung.value.LAGER_SCHRAEG_BETA);
			}
		}
		
		//Picture
		if(message.picture)
			__showImg(message.picture.strImage);	//-Schu- jetz noch das korr. Bild
		
		if(message.TopologyPicture)
			Cascade.app.setTopologyPicture(message.TopologyPicture);
			
		bInital = false;	
	}	
	
	var _setNumberfieldEvent = function(field, newValue, oldValue){
		if(!bInital){
			Ext.Ajax.request( {
				url 	: 'lager.systemcharakteristik/setNumberfield',
				params  : {
					'numberfieldid'		: field.id,
					'numberfieldvalue' 	: newValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						_setGUI(message)
				}
			});	
		}
	};
	
	var _setComboBoxEvent = function(combo, record, idx){
		if(!bInital){
			var buildComboBoxId = combo.id.replace("LAGER_SYSTEMCHARAKTERISTIK_","");
				buildComboBoxId = buildComboBoxId.replace("_COMBO","");
			var strComboBoxId 		= buildComboBoxId;
			var strSelectionValueId	= combo.getValue();
			Ext.Ajax.request( {
				url 	: 'lager.systemcharakteristik/setComboBox',
				params  : {
					'comboboxid'	: strComboBoxId,
					'comboboxvalue' : strSelectionValueId
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
				}
			});	
		}
	}
	
	var _setCheckBoxEvent = function(strCheckboxId,strValue){		
		if(!bInital){
			Ext.Ajax.request( {
				url 	: 'lager.systemcharakteristik/setCheckBox',
				params  : {
					'checkboxid'	: strCheckboxId,
					'checkboxvalue' : strValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						_setGUI(message)
				}
			});
		}
	}
	
	var _setRadioEvent = function(oClicked, bChecked){
		if(!bInital && bChecked){
			Ext.Ajax.request( {
				url 	: 'lager.systemcharakteristik/setRadio',
				params  : {
					'radiogroup' : oClicked.name,
					'radiovalue' : oClicked.inputValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						_setGUI(message);
					
					if(Ext.getCmp("LAGER_ZUBEHOER").getValue())	
						_setShowCombo("LAGER_ZUBEHOER");
					else
						_setShowCombo();	
				}
			});	
		}
	}
	
	var _onActionComplete = function(strform, action){ //Wenn bentigt erweitern
		Ext.getCmp("move-prev").show();
		Cascade.app.getNextPanel(form,action); //Next Dialog		
	}
	
	/**
	 * @private initial function
	 */
	var _setInitial = function(){	
		Ext.Ajax.request({ 
		    url		: 'lager.systemcharakteristik/getInitalValues',
			success	: function( response, options){
				var message	= Ext.util.JSON.decode(response.responseText);
				_setGUI(message);
				Ext.getCmp('save').hide();
				Cascade.app.activateHeartbeat(message.sessionId);
			}
		});	
	}
	
	return {
		/**
		 * open initial - aufruf cascade2.js Zeile 143
		 */
		setActivInitial : function(){
			_setInitial();
		},
		setPicture : function(){
			Ext.Ajax.request({ 
			    url		: 'lager.systemcharakteristik/getImages2',
				success	: function( response, options){
					var message	= Ext.util.JSON.decode(response.responseText);
					_setGUI(message);
					Cascade.app.activateHeartbeat(message.sessionId);
				}
			});	
		},
		init : function( idx ){					
			Ext.getCmp('move-prev').hide();
			if ( !form ){	
				bInital = true;			
				form = new Ext.FormPanel({
					id			: 'lager.systemcharakteristik',
					title		: '$LAGER_SYSTEMCHARAKTERISTIK$',
					listeners: {
						'actioncomplete': _onActionComplete
					},					
					frame		: true,
					labelWidth	: 130,
					labelStyle	: 'font-size:11px',
					items		: [
					{
						layout	:'column',
						border	: false,
						items	: [{
							xtype		:'fieldset',
							width		: 250,
							autoHeight	: true,
							title		: '$IDC_LAGER_LABEL$',
							items       : [{
								hideLabels	: true,
								style		: 'padding: 10px',								
								items: [ 
								{
									xtype		: 'radio',
									id			: 'LAGER_SPG',
									inputValue	: 'LAGER_SPG',
									boxLabel	: '$LAGER_SPG$',
									name		: 'IDC_LAGER',
									listeners	: {
		                                'check': _setRadioEvent
		                            }									
								},{
									xtype		: 'radio',
									id			: 'LAGER_SSG',
									inputValue	: 'LAGER_SSG',
									boxLabel	: '$LAGER_SSG$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_EPG',
									inputValue	: 'LAGER_EPG',
									boxLabel	: '$LAGER_EPG$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_ROHRST',
									inputValue	: 'LAGER_ROHRST',
									boxLabel	: '$IDC_ROHRST_LABEL$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									disabled	: true,
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_ROLL',
									inputValue	: 'LAGER_ROLL',
									boxLabel	: '$IDC_ROLL_LABEL$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_SAROLL',
									inputValue	: 'LAGER_SAROLL',
									boxLabel	: '$IDC_SAROLL_LABEL$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_SYROLLSA',
									inputValue	: 'LAGER_SYROLLSA',
									boxLabel	: '$IDC_SYROLLSA_LABEL$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_FS',
									inputValue	: 'LAGER_FS',
									boxLabel	: '$IDC_FS_LABEL$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px;',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype		: 'radio',
									id			: 'LAGER_ZUBEHOER',
									inputValue	: 'LAGER_ZUBEHOER',
									boxLabel	: '$IDC_LABEL_TABHEADER_ZUBEHOER$',
									name		: 'IDC_LAGER',	
									style		: 'margin-top:5px;',									
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
									xtype			: 'combo',
									id				: 'LAGER_SYSTEMCHARAKTERISTIK_ZUBEHOER_COMBO',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		: 'LAGER_SYSTEMCHARAKTERISTIK_ZUBEHOER_NAME',
									store			: storeZubehoer,
									listWidth		: 350,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 180,
									editable		: false	
								}/*,{ //macht an der Stelle nur rger
									xtype		: 'radio',
									id			: 'LAGER_HS',
									inputValue	: 'LAGER_HS',
									boxLabel	: '$LASTKETTE$',
									name		: 'IDC_LAGER',
									style		: 'margin-top:5px;',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}*/]
							}]
						},{
							xtype		:'fieldset',
							title		: '$IDC_ROHR_LABEL$',
							width		: 450,
							autoHeight	: true,							
							hideLabels	: true,
							style		: 'margin-left: 10px ; padding: 10px',							
							items: [{
								xtype			: 'checkbox',
								id				: 'krT',
								hiddenName		: 'krT',
								boxLabel		: '$KEIN_ROHRUMSCHLIESSENDES_TEIL$',
								valueField		: 'id',
								displayField	: 'krT',
								mode			: 'local',
								triggerAction	: 'all'	,
								hideLabel		: true,
								listeners		: {
									render : function(a,value,c) {
										this.on({
		                                    check : function(a,value,c) {
		                                        _setCheckBoxEvent(this.id,value);
		                                    }
		                                });
									}
								}
							}]
						},{
							xtype:'fieldset',
							title: '$ROHRVERLAUF$',
							width: 215,
							autoHeight: true,
							defaultType: 'radio',
							hideLabels: true,
							style: 'margin-left: 10px ; padding: 10px',
							
							items: [ {
								id: 'LAGER_HORIZONTAL',
								inputValue: 'HORIZONTAL',
								boxLabel:'$HORIZONTAL$',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': _setRadioEvent
                                }
							},{
								id: 'LAGER_VERTIKAL',
								inputValue: 'VERTIKAL',
								boxLabel:'$VERTIKAL$',
								style: 'margin-top: 10px',
								name:'IDC_ROHRVERLAUF',
                                listeners: {
                                    'check': _setRadioEvent
                                }
							}]
						},{
							xtype:'fieldset',
							width: 225,
							title: '$ROHRRICHTUNG$',
							autoHeight: true,							
							style: 'margin-left: 10px; padding: 10px',
							items: [ {
								xtype: 'radio',
								id: 'LAGER_X_ACHSE',
								hideLabel: true,
								inputValue: 'X_ACHSE',
								boxLabel:'$X_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': _setRadioEvent
                                }
							},{
								xtype: 'radio',
								id: 'LAGER_Y_ACHSE',
								hideLabel: true,
								inputValue: 'Y_ACHSE',
								boxLabel:'$Y_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': _setRadioEvent
                                }
							},{
								xtype: 'radio',
								id: 'LAGER_Z_ACHSE',
								hideLabel: true,
								inputValue: 'Z_ACHSE',
								boxLabel:'$Z_ACHSE$',
								name:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': _setRadioEvent
                                }
							},{
								xtype: 'radio',
								id			: 'LAGER_SCHRAEG_ACHSE',
								hideLabel	: true,
								inputValue	: 'SCHRAEG_ACHSE',
								boxLabel	:'$SCHRAEG_ACHSE$',
								name		:'IDC_ROHRRICHTUNG',
								listeners: {
                                    'check': _setRadioEvent
                                }
							},{
								layout			: 'form',
								border			: false,
								id				: 'LAGER_SCHRAEG_ALPHA_FORM',
								items			: [{
									xtype			: 'numberfield',
									id				: 'LAGER_SCHRAEG_ALPHA',
									inputValue		: 'SCHRAEG_ALPHA',
									fieldLabel		: '$ALPHA$',
									labelSeparator	: '',
									width			: 50,
									style			: 'margin: 0 0 0 -80px',
									maxValue		: 90,
									minValue		: -90,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								layout			: 'form',
								border			: false,
								id				: 'LAGER_SCHRAEG_BETA_FORM',
								items			: [{
									xtype			: 'numberfield',
									id				: 'LAGER_SCHRAEG_BETA',
									inputValue		: 'SCHRAEG_BETA',
									fieldLabel		: '$BETA$',
									labelSeparator	: '',
									width			: 50,
									style			: 'margin: 0 0 0 -80px',
									maxValue		: 45,
									minValue		: -45,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							}]
						}
						]
					}]
				});
				
				// First do the Layout and render the form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, form );
				cp.doLayout();
			}
			
			form.getForm().reset();
			bInital = false;				
			_setInitial();					
		}
	}
}();
