Ext.namespace('Cascade.panel.lager');
/**
 * @class Cascade.panel.lager.sollwerte_rohrumschliessendesteil
 * <li>category   Client Lager
 * <li>package    Cascade.panel.lager
 * <li>copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 - new - 
 */
Cascade.panel.lager.sollwerte_rohrumschliessendesteil = function()
{
	var form;
	var bBlock = false;
	var storeNennweite = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeAussendurchmesser = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeManteldurchmesser = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var _setGUI = function(message){
		bBlock = true;
		var __setDisabled = function(strId,bValue){
			if(bValue)
				Ext.getCmp(strId).disable();
			else if(bValue !== "undefined")
				Ext.getCmp(strId).enable();	
		}
		
		var __setValueRadio = function(strRadioGroupId,strValue){
			Ext.getCmp(strValue).suspendEvents(false);			
			Ext.getCmp(strValue).setValue(true);			
			Ext.getCmp(strValue).resumeEvents();
			
			if(Ext.getCmp(strValue).disabled){
				Ext.getCmp('move-next').hide();
				Cascade.base.Messages.Info_Message('$INFO_WERKSTOFF_NICHT_VORHANDEN$');
			}		
			else
				Ext.getCmp('move-next').show();	
		}
		
		if (message.SpecialStandardDIA.specDiaSel && message.SpecialStandardDIA.standDiaChosen){
			Cascade.base.Messages.Info_Message('$IDP_ABWEICHUNG_DMR_KLEIN$');
		}
		
		if(message.temperatur){
			if(message.temperatur.disable)
				__setDisabled("LAGER_IDC_TEMPERATUR_MEDIUM",message.temperatur.disable.Medium);
			
			if(message.temperatur.value)
				Ext.getCmp("LAGER_IDC_TEMPERATUR_MEDIUM").setValue(message.temperatur.value.Medium);
		}
		
		if(message.umgebungstemperatur){
			if(message.umgebungstemperatur.disable)
				__setDisabled("LAGER_UMGEBUNGSTEMPERATUR_CHECKBOX",message.umgebungstemperatur.disable.CheckBox);
			
			if(message.umgebungstemperatur.value)
				Ext.getCmp("LAGER_UMGEBUNGSTEMPERATUR_CHECKBOX").setValue(message.umgebungstemperatur.value.CheckBox);	
		}
		
		if(message.werkstoff){
			if(message.werkstoff.disable){
				for(var i=0;i<message.werkstoff.disable.length;i++){
					var aPart  = message.werkstoff.disable[i];
					__setDisabled(aPart[0],aPart[1]);
				}
			}
			
			if(message.werkstoff.selected){
				var bReset = false;
				if(!bBlock){
					bReset = true;
					bBlock = true;					
				}
				__setValueRadio("",message.werkstoff.selected);
				
				if(bReset)
					bBlock = false;	
			}
		}
		
		if(message.combo){
			if(message.combo.Nennweite){
				if(message.combo.Nennweite.store)
					storeNennweite.loadData(message.combo.Nennweite.store);
				
				if(message.combo.Nennweite.selected)
					Ext.getCmp("LAGER_IDC_NENNWEITE").setValue(message.combo.Nennweite.selected);	
			}
			
			if(message.combo.Aussendurchmesser){
				if(message.combo.Aussendurchmesser.store)
					storeAussendurchmesser.loadData(message.combo.Aussendurchmesser.store);
				
				if(message.combo.Aussendurchmesser.selected)
					Ext.getCmp("LAGER_IDC_AUSSENDURCHMESSER").setValue(message.combo.Aussendurchmesser.selected);	
			}
		}
		
		if(message.manteldurchmesser){
			if(message.manteldurchmesser.show){
				Ext.getCmp("LAGER_MANTELDURCHMESSER").show();
				//setCombo 
				if(message.manteldurchmesser.store)
					storeManteldurchmesser.loadData(message.manteldurchmesser.store);
				
				if(message.manteldurchmesser.selc)
					Ext.getCmp("LAGER_IDC_MANTELDURCHMESSER").setValue(message.manteldurchmesser.selc);
				if(message.manteldurchmesser.checkbox){
					//setSonderCheckbox
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX").setValue(true);
					//setSonderValue
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD").setValue(message.manteldurchmesser.value);
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD").enable();				
				}
				else{
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX").setValue(false);
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD").setValue('');
					Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD").disable();
				}
			}
			else
				Ext.getCmp("LAGER_MANTELDURCHMESSER").hide();	
		}
		
		if(message.daemmdicke){
			if(message.daemmdicke.disable)
				__setDisabled("LAGER_IDC_DAEMMDICKE",message.daemmdicke.disable.daemmdicke);
			if(message.daemmdicke.value)
				Ext.getCmp("LAGER_IDC_DAEMMDICKE").setValue(message.daemmdicke.value.daemmdicke);	
		}
		
		if(message.schelleneinlage){
			if(message.schelleneinlage.disable)
				__setDisabled("LAGER_IDC_SCHELLENEINLAGE",message.schelleneinlage.disable.schelleneinlage);
			if(message.schelleneinlage.value)
				Ext.getCmp("LAGER_IDC_SCHELLENEINLAGE").setValue(message.schelleneinlage.value.schelleneinlage);	
		}
		
		if(message.sonder){
			if(message.sonder.disable){
				__setDisabled("LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD",message.sonder.disable.sonder);
				__setDisabled("LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX",message.sonder.disable.sonder);
			}
			
			if(message.sonder.selected != undefined)	{			
				Ext.getCmp("LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX").setValue(message.sonder.selected);
				if(message.sonder.selected == false)
					Ext.getCmp("LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD").disable();
				else
					Ext.getCmp("LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD").enable();	
			}
			
			
			if(message.sonder.value != undefined){
				var strValue = (message.sonder.value == 0) ? '' : message.sonder.value;
				Ext.getCmp("LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD").setValue(strValue);
			}
			
			if(message.sonder.combodis){
				for(var a=0;a<message.sonder.combodis.length;a++){
					__setDisabled(message.sonder.combodis[a][0],message.sonder.combodis[a][1]);
				}
			}			
		}
		
		if(message.TopologyPicture)
			Cascade.app.setTopologyPicture(message.TopologyPicture);
		
		if(message.rechte){
			for(var a=0;a<message.rechte.disable.length;a++){
				__setDisabled(message.rechte.disable[a][0],message.rechte.disable[a][1]);
			}
		}
		
		bBlock = false;
	};
	
	var _setNumberfieldEvent = function(field, newValue, oldValue){
		var bOk = true;
		var _setStyle = function(strNumberfieldId,strColor){
			Ext.getCmp(strNumberfieldId).el.dom.style.backgroundColor = strColor;
	        Ext.getCmp(strNumberfieldId).el.dom.style.backgroundImage = 'none';	
		}
		
		var _testManteldurchmesser = function(){
			var dnewValue = Ext.getCmp('LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD').getValue()*1;
			bOk = true;	
			/*if(Ext.getCmp("LAGER_IDC_SCHELLENEINLAGE").getValue()){
				var dSchellenlaenge 	= (Ext.getCmp("LAGER_IDC_SCHELLENEINLAGE").getValue()*1);
				var dAussendurchmesser 	= (Ext.getCmp("LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD").getValue()*1);
				
				if(((dnewValue)> dSchellenlaenge) && ((dnewValue)<dAussendurchmesser)){
					bOk = true;					
	            	_setStyle('LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD','white');
	            	Ext.getCmp("move-next").show();
				}
				else{
					bOk = false;
					_setStyle('LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD','red');
	            	Cascade.base.Messages.Error_Message('$ERROR_MANTELDURCHMESSER$');
	            	Ext.getCmp("move-next").hide();
				}	
			}
			else{
				var dNenndurchmesser 	= (Ext.getCmp("LAGER_IDC_NENNWEITE").getValue()*1);
				var dAussendurchmesser 	= (Ext.getCmp("LAGER_IDC_AUSSENDURCHMESSER").getValue()*1);
				
				if(((dnewValue)> dNenndurchmesser) && ((dnewValue)<dAussendurchmesser)){
					bOk = true;					
	            	_setStyle('LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD','white');
				}
				else{
					bOk = false;
					_setStyle('LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD','red');
	            	Cascade.base.Messages.Error_Message('$ERROR_MANTELDURCHMESSER$');
				}
			}*/
		}
		
		if(field.id == 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD')
			_testManteldurchmesser();
		
		if(!bBlock && bOk){
			Ext.Ajax.request( {
				url 	: 'lager.sollwerte-rohrumschliessendesteil/setNumberfield',
				params  : {
					'numberfieldid'		: field.id,
					'numberfieldvalue' 	: newValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message){
						_setGUI(message);
						
						if(field.id == 'LAGER_IDC_SCHELLENEINLAGE' && Ext.getCmp("LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX").getValue())
							_testManteldurchmesser();
					}	
				}
			});	
		}
	};
	
	var _setComboBoxEvent = function(combo, record, idx){
		var strComboBoxId 		= combo.id;
		var strSelectionValueId	= combo.getValue();
		if(!bBlock){		
			Ext.Ajax.request( {
				url 	: 'lager.sollwerte-rohrumschliessendesteil/setComboBox',
				params  : {
					'comboboxid'	: strComboBoxId,
					'comboboxvalue' : strSelectionValueId
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						_setGUI(message)
				}
			});	
		}
	};
	
	var _setCheckBoxEvent = function(strCheckboxId,strValue){
		if(!bBlock){
			Ext.Ajax.request( {
				url 	: 'lager.sollwerte-rohrumschliessendesteil/setCheckBox',
				params  : {
					'checkboxid'	: strCheckboxId,
					'checkboxvalue' : strValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						_setGUI(message)
				}
			});		
		}
	};
	
	var _onActionComplete = function(strform, action){
		if(!bBlock){
			var actWerkstoff = form.getForm().findField('LAGER_IDC_WERKSTOFF').getGroupValue();
			Ext.Ajax.request( {
				url 	: 'lager.sollwerte-rohrumschliessendesteil/setWerkstoffValues',
				params  : {
					'actWerkstoff'	: actWerkstoff
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.app.getNextPanel(form,action); //Next Dialog
				}
			});		 
		}
	};
	
	return {
		init: function(idx){			
			if (!form) {
				bBlock = true;
				form = new Ext.FormPanel({
					frame		: true,
					id			: 'lager.sollwerte_rohrumschliessendesteil',
					title		: '$SOLLWERTE_ROHRUMSCHLIESSENDES_TEIL$',
					bodyStyle	: 'padding:5px 20px 0',
					listeners: {
						'actioncomplete': _onActionComplete
					},
					items: [
					{
						layout	: 'column',
						height	: '60', 
						border 	: false,
						width	: 700,
						items :[
						{
							layout 		: 'form',
							border 		: false,
							width		: 250,
							items		: [{
								xtype		: 'fieldset',
								height		: 55,
								title		: '$IDC_TEMPERATUR_LABEL$',					
								items:[{
									layout		:'column',									
									items:[{
										layout		: 'table',
										border		: false,	
										autoHeight	: true,								
										items: [{
											layout	: 'form',
											width	: 190,
											autoHeight	: true,	
												items   : [{
												xtype			: 'numberfield',
												id				: 'LAGER_IDC_TEMPERATUR_MEDIUM',
												fieldLabel		: '$MEDIUM$',
												labelWidth		: 75,
												labelSeparator	: '',
												width			: 45,
												maxValue		: 900,
												minValue		: -10,
												listeners: {
													'change': _setNumberfieldEvent
												}
											}]
										},{
											xtype		: 'textfield',
											value		: '$WS_UNIT_GRAD_CELSIUS$',
											hideLabels	: true,
											readOnly	: true,
											width		: 20,
											cls			: 'textfield-transparent',
											style		: 'margin-left: -30px; margin-top: -5px'	
										}]
									}]
								}]
							}]
						},{
							layout 		: 'form',
							border 		: false,
							width		: 400,
							items		: [{
								xtype	: 'fieldset',
								height		: 55,
								width		: 400,
								title	: '$UMGEBUNGSTEMPERATUR$',
								items: [{
									style			: 'margin-left: -105px',
									id				: 'LAGER_UMGEBUNGSTEMPERATUR_CHECKBOX',
									xtype			: 'checkbox',
									boxLabel		: '$UMGEBUNGSTEMP_GRENZEN$',
									labelSeparator	: '',
									checked			: true,
									disabled		: true
								}]
							}]
						}]
					},{
						layout: 'column',
						defaults: {
							labelWidth: 110
						},						
						items: [{
							width: 245,
							layout: 'form',							
							items: [{
								xtype			: 'combo',
								id				: 'LAGER_IDC_NENNWEITE',
								fieldLabel		: '$NENNWEITE_DN$',
								labelSeparator	: '',
								hiddenName		:'IDC_NENNWEITE_DN',
								store			: storeNennweite,								
								listeners: {
									'select': _setComboBoxEvent
								},
								valueField		: 'id',								
								displayField	:'text',
								typeAhead		: true,
								mode			: 'local',
								triggerAction	: 'all',
								selectOnFocus	: true,
								width			: 100,
								listWidth		: 140,
								editable		: false
							}]
						},{
							layout: 'table',
							autoWidth: true,
							border: false,							
							items: [{
								layout	: 'form',
								width	: 195,
								items   : [{
									xtype			: 'numberfield',
									id				: 'LAGER_IDC_DAEMMDICKE',
									fieldLabel		: '$DAEMMDICKE$',
									labelSeparator	: '&nbsp;',
									width			: 50,
									listeners		: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 50,
								cls			: 'textfield-transparent',
								style		: 'margin-left: -30px; margin-top: -5px'
							},{
								layout	: 'form',
								width	: 195,
								items   : [{
									xtype			: 'numberfield',
									id				: 'LAGER_IDC_SCHELLENEINLAGE',
									fieldLabel		: '$SCHELLENEINLAGE$',
									labelSeparator	: '&nbsp;',
									width			: 50,
									listeners		: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: -30px; margin-top: -5px'
							}] 
						}]
					},{ //Aussendurchmesser
						layout: 'column',
						defaults: {
							labelWidth: 110
						},						
						items: [{
							width: 245,
							layout: 'form',							
							items: [{
								xtype			: 'combo',
								id				: 'LAGER_IDC_AUSSENDURCHMESSER',
								fieldLabel		: '$AUSSENDURCHMESSER$',
								labelSeparator	: '',
								labelAlign		: 'left',
								hiddenName		:'IDC_AUSSENDURCHMESSER',
								store			: storeAussendurchmesser,
								listeners		: {
									'select': _setComboBoxEvent
								},
								valueField		: 'id',
								displayField	: 'text',
								typeAhead		: true,
								mode			: 'local',
								triggerAction	: 'all',
								selectOnFocus	: true,
								width			: 100,
								listWidth		: 140,
								editable		: false
							}]
						},{
							layout: 'table',
							border: false,
							width : 345,	
							items : [{
								width	: 115,
								layout	: 'form',							
								items	: [{										
									xtype			: 'checkbox',
									id				: 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',
									hiddenName		: 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',
									boxLabel		: '$SONDER$',
									valueField		: 'id',
									displayField	: 'LAGER_AUSSENDURCHMESSER_SONDER_CHECKBOX',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        if(!bBlock)
			                                        	_setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}										
								}]								 
							},{
								width	: 80,
								layout	: 'form',
								items: [{
									xtype			: 'numberfield',								
									id				: 'LAGER_AUSSENDURCHMESSER_SONDER_NUMBERFIELD',
									labelSeparator	: '',
									hideLabel		: true,
									width			: 50,
									minValue		: 20,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: -30px; margin-top: -5px'
							}]
						}]
					},{//MANTELDURCHMESSER
						layout	: 'column',
						defaults: {
							labelWidth: 110
						},
						id		: 'LAGER_MANTELDURCHMESSER',				
						items	: [{
								width: 245,
								layout: 'form',							
								items: [{
									xtype			: 'combo',
									id				: 'LAGER_IDC_MANTELDURCHMESSER',
									fieldLabel		: '$IDC_MANTELDURCH_LABEL$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'IDC_MANTELDURCHMESSE',
									store			: storeManteldurchmesser,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 100,
									listWidth		: 140,
									editable		: false
								}]
							},{
								layout: 'table',
								border: false,
								width : 345,	
								items : [{
									width	: 115,
									layout	: 'form',							
									items	: [{										
										xtype			: 'checkbox',
										id				: 'LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',
										hiddenName		: 'LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',
										boxLabel		: '$SONDER$',
										valueField		: 'id',
										displayField	: 'LAGER_MANTELDURCHMESSER_SONDER_CHECKBOX',
										mode			: 'local',
										triggerAction	: 'all'	,
										hideLabel		: true,
										listeners		: {
											render : function(a,value,c) {
												this.on({
				                                    check : function(a,value,c) {
				                                        if(!bBlock)
				                                        	_setCheckBoxEvent(this.id,value);
				                                    }
				                                });
											}
										}										
									}] 
								},{
									width	: 80,
									layout	: 'form',
									items: [{
										xtype			: 'numberfield',								
										id				: 'LAGER_MANTELDURCHMESSER_SONDER_NUMBERFIELD',
										labelSeparator	: '',
										hideLabel		: true,
										width			: 50,
										minValue		: 20,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent',
									style		: 'margin-left: -30px; margin-top: -5px'
								}]
							}]
						},{
						xtype		: 'fieldset',
						width		: 650,
						title		: '$WERKSTOFF_SCHELLE_LAGER$', 
						bodyStyle	:'margin-top: 5px ',
						style		:'margin-top: 10px ',
						autoHeight	: true,					
						items: [ {
							layout: 'column',
							defaults:{
								layout			: 'form',
								hideLabel		: true,
								width			: 200,
								defaultType		: 'radio',
								labelSeparator	: '',
								hideLabels		: true
							},							
							items: [{		
								items: [{
                                    id: 'LAGER_W_RST',
									inputValue: 'W_RST',
									boxLabel:'$S235 JRG2$',
									name:'LAGER_IDC_WERKSTOFF',
									checked: true
								},{
                                    id: 'LAGER_W_10CRMO',
									inputValue: 'W_10CRMO',
									boxLabel:'$10CrMo9-10$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_P91',
									inputValue: 'W_P91',
									boxLabel:'$X10CrMoVNb9-1$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_4301',
									inputValue: 'W_4301',
									boxLabel:'$X5CrNi18-10$',
									name:'LAGER_IDC_WERKSTOFF'
								}]
							},{						
								items: [{
                                    id: 'LAGER_W_15MO3',
									inputValue: 'W_15MO3',
									boxLabel:'$16Mo3$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_4541',
									inputValue: 'W_4541',
									boxLabel:'$X6CrNiTi18-10$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_INCOLOY',
									inputValue: 'W_INCOLOY',
									boxLabel:'$X5CrAITi31-20$',
									name:'LAGER_IDC_WERKSTOFF'
								}]
							},{
								
								items: [{
                                    id: 'LAGER_W_13CRMO',
									inputValue: 'W_13CRMO',
									boxLabel:'$13CrMo4-5$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_4571',
									inputValue: 'W_4571',
									boxLabel:'$X6CrNiMoTi17-12-2$',
									name:'LAGER_IDC_WERKSTOFF'
								},{
                                    id: 'LAGER_W_4878',
									inputValue: 'W_4878',
									boxLabel:'$X8CrNiTi18-10$',
									name:'LAGER_IDC_WERKSTOFF'
								}]
							}]
						}]
					}]
				});
				
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx, form);
				cp.doLayout();
			}
				
			bBlock = true;
			form.getForm().reset();					
			//bBlock = true;
			Ext.Ajax.request({   
			    url		: 'lager.sollwerte-rohrumschliessendesteil/getInitalValues',
				success	: function( response, options){				
					var message	= Ext.util.JSON.decode(response.responseText);
					_setGUI(message);					
					bBlock = false;
				}
			});	
		}
	}
}();