Ext.namespace('Cascade.panel.lager');
/**
 * @class Cascade.panel.lager.sollwerte_halterungspunkt
 * <li>category   Client Lager
 * <li>package    Cascade.panel.lager
 * <li>copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 - new - 
 */
Cascade.panel.lager.sollwerte_halterungspunkt = function()
{
	var form,myCm,myStore,myCellRenderer;
	var bBlock = false;
    //define a renderer to pass into the column model config later
    myCellRenderer = function(value, metaData, record, rowIndex, colIndex, store) {
        if ((colIndex == 1) && (record.get('axialDisabled') == 1)) 
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
        if ((colIndex == 2) && (record.get('querDisabled') == 1)) 
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
        if ((colIndex == 3) && (record.get('schiefDisabled') == 1))
            metaData.attr = 'style="color:red; background-color: darkgrey;"';
      return value;
    };

    myCm = new Ext.grid.ColumnModel(
        [{
            header: "&nbsp;",
            dataIndex: 'beschriftung',
            width: 160
        },{
            header: "$ID_HEADER_AXIAL$",
            dataIndex: 'axial',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "$ID_HEADER_QUER$",
            dataIndex: 'quer',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "$ID_HEADER_LASTRICHT$",
            dataIndex: 'schief',
            editor: new Ext.form.NumberField( {
                allowNegative: true
            } ),
            renderer: myCellRenderer
        },{
            header: "&nbsp;",
            dataIndex: 'einheit',
            width: 60
        }]
    );
    
    myCm.isCellEditable = function(col, row) {
        var field = this.getDataIndex(col);
        var record = myStore.getAt(row);

        if ((field == 'axial') && (record.get('axialDisabled') == 1)) 
            return false;
        if ((field == 'quer') && (record.get('querDisabled') == 1)) 
            return false;
        if ((field == 'schief') && (record.get('schiefDisabled') == 1)) 
            return false;

        return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
    };
	
	var _onActionComplete = function(strform, action){ //Wenn bentigt erweitern
		if(!bBlock){
			var oData = {};
			var aData = Ext.getCmp("SWHP_GRID").store.data.items;
			for(var a=0;a<aData.length;a++){
				var oPart = aData[a].data;
				oData[oPart.idx] = { 'axial' : oPart.axial , 'quer' : oPart.quer, 'schief' : oPart.schief } ;			
			}		
					
			Ext.Ajax.request( {
				url 	: 'lager.sollwerte-halterungspunkt/setTableData',
				params  : {
					'objTable' : Ext.util.JSON.encode(oData)
				},
				success : function(response, options) {
					Cascade.app.getNextPanel(form,action); //Next Dialog	
				}
			});
		}		
	}
	
	return {
		init: function(idx) {
			if (!form) {
				bBlock = true;
                myStore = new Ext.data.JsonStore({
					url: 'lager.sollwerte-halterungspunkt/getTable',
					root: 'rows',
					fields: [
						'idx', 
						'beschriftung', 
						{name:'axial', type: 'float'}, 
						{name:'quer', type: 'float'},
						{name:'schief', type: 'float'},
						'einheit',
                        'axialDisabled',
                        'querDisabled',
                        'schiefDisabled'
					]
				});
                        
				form = new Ext.FormPanel({
					id		: 'lager.sollwerte_halterungspunkt',
					//url		: 'lager.sollwerte-halterungspunkt/set-values',
					title	: '$SOLLWERTE_HALTERUNGSPUNKT$',
					
					frame:true,
					width: 350,
					labelWidth: 200, // label settings here cascade unless overridden
					bodyStyle: 'padding:5px 5px 0',
					listeners: {
						'actioncomplete': _onActionComplete
					},
					
					layout:'table',
					layoutConfig: {
						columns: 2
					},					
					items: [{
						xtype: 'editorgrid',
						id: 'SWHP_GRID',
						clicksToEdit: 1,
						width: 550,
						height:220,
						frame:true,
						store: myStore,
                        cm:  myCm,
						colspan: 2
					},{
						xtype: 'hidden',
						id: "IDC_TABLE",
						hidden: true,
						inputType: 'text'
					}]
				});
				
				
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx,form);
				cp.doLayout();				
			}
			
			Ext.getCmp('SWHP_GRID').getStore().load();
			bBlock = true;
			form.getForm().reset();
			//form.load({url: 'lager.sollwerte-halterungspunkt/get-values'});
			Ext.getCmp('move-next').enable();
			bBlock = false;
		}
	}
}();