Ext.namespace('Cascade.panel.lager');
Cascade.panel.lager.auswahl_standard_sonder = function()
{
	var editWin,form,store,storeL,storeB;
	var bBlock = false;
	var strEditWinId = 'lager.auswahl_standard_sonder';
	
	var _setInitial	= function(){		
		form.getForm().reset();		
		Ext.Ajax.request( {
			url 	: 'lager.auswahl-standard/getPopUpInitial',
			success : function(response, options) {
				var message	= Ext.util.JSON.decode(response.responseText);
				if(message){
					Cascade.panel.lager.auswahl_standard_setGuiValue(message);	
					bBlock = false;				
				}	
			}
		});	
	}
	
	var _setClose = function(){
		if(!bBlock){
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setPOPUPClose',
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
					
					editWin.close();	
				}
			});
		}
	}
	
	var _setApply = function(){
		if(!bBlock){
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setPOPUPApply',
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
					
					Cascade.panel.lager.auswahl_standard.setSearchButton();
					
					editWin.close();	
				}
			});
		}
	}
	
	var _setNumberfieldEvent = function(field, newValue, oldValue){
		if(!bBlock){
			bBlock = true;
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setNumberfieldSonder',
				params  : {
					'fieldid' 			: field.id,
					'numberfieldvalue' 	: newValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Ext.getCmp(message[0]).setValue(message[1]);
					bBlock = false;
				}
			});	
		}		
	}
	
	var _setComboBoxEvent = function(combo, record, idx){
		if(!bBlock){
			bBlock = true;
			var strComboBoxId 		= combo.id;
			var strSelectionValueId	= combo.getValue();
			if (strSelectionValueId == "-")
				Ext.getCmp(strComboBoxId.replace(/_LAGER/g,"_SONDER_LAGER")).enable();
			else
				Ext.getCmp(strComboBoxId.replace(/_LAGER/g,"_SONDER_LAGER")).disable();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setComboBoxSonder',
				params  : {
					'comboboxid'	: strComboBoxId,
					'comboboxvalue' : strSelectionValueId
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Ext.getCmp(message[0]).setValue(message[1]);
					bBlock = false;
				}
			});
		}
	}
	
	var _setCheckEvent = function(oClicked, bChecked){
		if(!bBlock){
			bBlock = true;
			var strCheckId = oClicked.id;
			switch(oClicked.inputValue){
				case "HOEHE"		:
						var strDeselect = strCheckId.replace(/HOEHE/g,"EINBAUMASS");
						Ext.getCmp(strDeselect).setValue(false);
						Ext.getCmp(strCheckId+"_Numberfield").enable();
						Ext.getCmp(strDeselect+"_Numberfield").disable();
					break;
				case "EINBAUMASS" 	:
						var strDeselect = strCheckId.replace(/EINBAUMASS/g,"HOEHE");
						Ext.getCmp(strDeselect).setValue(false);
						Ext.getCmp(strCheckId+"_Numberfield").enable();
						Ext.getCmp(strDeselect+"_Numberfield").disable();
					break;	
			}
			bBlock = false;
		}
		
		if(!bBlock && bChecked){
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setCheckBox',
				params  : {
					'checkboxid' : oClicked.name,
					'checkboxvalue' : oClicked.inputValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
				}
			});	
		}
	};
	
	var _onActionComplete = function(strform, action){
		if(!bBlock){
			Cascade.app.getNextPanel(form,action); //Next Dialog	 
		}
	};
	
	return {
		setBlock: function(bBlockAjax){
			bBlock	= bBlockAjax;
		},
		getDefaultId : function(){
			return strEditWinId;
		},
		setLoadComboStore : function(aData,strSelection,strType){
			if (strType == "LAGERLAENGE")
				storeL.loadData(aData);
			else if (strType == "LAGERBREITE")
				storeB.loadData(aData);
			else
				strType = "";
			
			if (strType != "")
				//Ext.getCmp(strEditWinId+'_LAGERLAENGE').setValue(strSelection);
				Ext.getCmp(strEditWinId+'_'+strType).setValue(strSelection);
		},
		init : function(idx){
			this.idx = idx;
			bBlock = true;
			if (!Ext.getCmp(strEditWinId)) {				
				storeL = new Ext.data.SimpleStore({
			        id: 'id',
			        fields: [
			            'id', 'SonderLaenge'
			        ]
			    });
				storeB = new Ext.data.SimpleStore({
			        id: 'id',
			        fields: [
						'id', 'SonderBreite'
			        ]
			    });
			    
			    var _fieldSet = function(strId,strFieldSetTitle){
					var _buildTable = function(strSubId,strLabel,bCheckBoxHide,strSC,strFieldSet){
						var oTablePanel = new Ext.Panel({			
							layout: 'table',
							border: false,
							columnWidth	: 1,
							layoutConfig 	: {
								//columns		: 3
								columns		: 4
							},	
							items : [{
								xtype 		: 'checkbox',
								hideLabels	: true,
								hidden		: bCheckBoxHide,
								width		: 25,
								id			: strId+"_"+strSubId,
								name		: strFieldSetTitle,
								style		: 'margin-top: -15px',
								inputValue  : strSubId,
								listeners	: {
			                        'check': _setCheckEvent
			                    }					
							},{ //numberfield
								layout		: 'form',
								border  	: false,
								labelWidth 	: 70,
								items   : [{ //das wird zu Combo!!--
									xtype			: 'numberfield',
									id				: strId+'_'+strSubId+'_Numberfield',
									//fieldLabel		: strLabel,
									fieldLabel		: strSC+strFieldSet.replace(/Q/g,"")+':',
									labelSeparator	: '',
									width			: 65,
									showNull		: true,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							},{//textfield (unit))
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							},{
								xtype		: 'textfield',
								value		: '',
								hideLabels	: true,
								readOnly	: true,
								width		: 95,
								id			: strEditWinId+'_MINMAX'+strSC+'_'+strFieldSet,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							}]
						});
						
						return oTablePanel;
					}	
					
					var buildFieldSet = new Ext.form.FieldSet({
						title		: strFieldSetTitle,
						id			: strEditWinId+"_"+strFieldSetTitle,
						height		: 90,
						width		: 300,
						items		: [
							_buildTable("HOEHE","$IDC_HOEHE$",false,"H",strFieldSetTitle),
							//_buildTable("HOEHE","$IDC_HOEHE$",true),
							_buildTable("EINBAUMASS","$EINBAUMASS$",false,"E",strFieldSetTitle)
							//_buildTable("EINBAUMASS","$IDC_EINBAUMASS$",true)
						]
					});
					
					return buildFieldSet;
				}
			    
				form = new Ext.FormPanel({
					frame		: true,
					id			: 'lager.auswahl-standard-sonder',
					//title		: '$LAGER_SONDERABMESSUNGEN_LABEL$',
					bodyStyle	: 'padding:5px 20px 0',
					listeners: {
						'actioncomplete': _onActionComplete
					},
					items : [{
						layout		: 'form',
						header		: false,
						border		: false,
						autoWidth	: true,
						items		: [{//lagerngen
							layout: 'table',
							border: false,	
							items : [{
								layout		: 'form',
								border  	: false,
								labelWidth 	: 135,
								items   : [{
									xtype			: 'combo',
									id				: strEditWinId+'_LAGERLAENGE',
									fieldLabel		: '$IDC_LAGERLAENGE$'+' L',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		: strEditWinId+'_LAGERLAENGE_NAME',
									store			: storeL,
									listWidth		: 65,
									width			: 65,
									listeners		: {
										//'select': _setNumberfieldEvent
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'SonderLaenge',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									editable		: false
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							},{
								layout		: 'form',
								border  	: false,
								labelWidth 	: 135,
								style		: 'margin-left: 100px',
								items   : [{
									xtype			: 'combo',
									id				: strEditWinId+'_LAGERBREITE',
									fieldLabel		: '$IDC_LAGERFUSSBREITE_LABEL$'+' B',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		: strEditWinId+'_LAGERBREITE_NAME',
									store			: storeB,
									listWidth		: 65,
									width			: 65,
									listeners		: {
										//'select': _setNumberfieldEvent
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'SonderBreite',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									editable		: false
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							}]
						},{
							layout 	: 'table',
							border	: false,
							items	: [{
								xtype		: 'textfield',
								value		: 'von bis',
								hideLabels	: true,
								readOnly	: true,
								width		: 100,
								id			: strEditWinId+'_MINMAXL',
								cls			: 'textfield-transparent',
								style		: 'margin-top: -5px'
							},{
								layout 		: 'form',
								border 		: false,
								labelWidth	: 35,
								items		: [{
									xtype			: 'numberfield',
									fieldLabel		: '',
									id				: strEditWinId+'_SONDER_LAGERLAENGE',
									labelSeparator	: '&nbsp;',
									width			: 65,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							},{
								xtype		: 'textfield',
								value		: 'von bis',
								hideLabels	: true,
								readOnly	: true,
								width		: 100,
								id			: strEditWinId+'_MINMAXB',
								cls			: 'textfield-transparent',
								style		: 'margin-left: 100px; margin-top: -5px'
							},{
								layout 		: 'form',
								border 		: false,
								labelWidth	: 35,
								//style		: 'margin-left: 35px',
								items		: [{
									xtype			: 'numberfield',
									fieldLabel		: '',
									id				: strEditWinId+'_SONDER_LAGERBREITE',
									labelSeparator	: '&nbsp;',
									width			: 65,
									listeners: {
										'change': _setNumberfieldEvent
									}
								}]
							},{
								xtype		: 'textfield',
								value		: 'mm',
								hideLabels	: true,
								readOnly	: true,
								width		: 30,
								cls			: 'textfield-transparent',
								style		: 'margin-left: 5px; margin-top: -5px'
							}]
						},{
							layout	: 'table',
							border  : false,
							columnWidth	: 1,
			                layoutConfig : {
		                        columns : 2
			                },
							items	: [{
								layout 		: 'form',
								width		: 340,
								height		: 110,
								items		: [
									_fieldSet(strEditWinId+"_Q1","Q1")
								]
							},{
								layout 		: 'form',
								width		: 340,
								height		: 110,
								items		: [	
									_fieldSet(strEditWinId+"_Q2","Q2")
								]
							},{
								layout 		: 'form',
								width		: 340,
								height		: 110,
								items		: [		
									_fieldSet(strEditWinId+"_Q3","Q3")
								]
							},{
								layout 		: 'form',
								width		: 340,
								height		: 110,
								items		: [		
									_fieldSet(strEditWinId+"_Q4","Q4")
								]
							}]
						},{//Bildchen1
							width 		: 230,
							height		: 200,
							layout		: 'form',
							frame  		: true,
							//frame  		: false,
							//style		: 'padding-left: 210px',
							style		: 'margin-left: 35px',
							id			: strEditWinId+'_PICTURE1',
							html		: ''
							//html		: '<img src="EasyKatImages/NO_PICTURE.jpg" style="cursor:pointer" />'
							//html		: '<img src="EasyKatImages/NO_PICTURE.png" style="cursor:pointer" />'
						},{//Bildchen2
							width 		: 230,
							height		: 200,
							layout		: 'form',
							frame  		: true,
							//frame  		: false,
							//style		: 'padding-left: 210px',
							style		: 'margin-left: 375px; margin-top: -200px',
							id			: strEditWinId+'_PICTURE2',
							html		: ''
							//html		: '<img src="EasyKatImages/NO_PICTURE.jpg" style="cursor:pointer" />'
							//html		: '<img src="EasyKatImages/NO_PICTURE.png" style="cursor:pointer" />'
						}]
					}]
				});
				
			   editWin = new Ext.Window ({
					border		: false,
					title		: '$LAGER_SONDERABMESSUNGEN_LABEL$',
					id			: strEditWinId,
					modal		: true,
					width		: 715,
					height		: 575,
					layout		: 'fit',
					items		: [form],
					bodyStyle	:'padding:5px;',			
					buttonAlign	: 'center',
					buttons		: [{
						text	: '$BUT_OK$',
						handler	: function () {
	                        Cascade.base.Tooltip.closeAllTooltips();
	                        _setApply();
						}
					},{
						text	: '$BUT_ABBRECHEN$',
						//hidden	: true,
						hidden	: false,
						handler	: function () {
	                        Cascade.base.Tooltip.closeAllTooltips();
	                        _setClose();
						}
					}]
				});
				/*
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx, form);
				cp.doLayout();	*/			
			}
			
			//form.getForm().reset();
			bBlock = false;
			editWin.show();
			_setInitial();
		}
	}
}();