Ext.namespace('Cascade.panel.lager');
/**
 * @class Cascade.panel.lager.auswahl_standard_setGuiValue
 * <li>category   Client Lager
 * <li>package    Cascade.panel.lager
 * <li>copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 - new - 
 */
Cascade.panel.lager.auswahl_standard_setGuiValue = function(message)
{
	if(!message)
		return;
	if(!message.fieldset){
		if(!message.resulttable)
			return;
		else
			message.fieldset = {};			
	}	
	
	Cascade.panel.lager.auswahl_standard.setBlockEvent(true);
	var oDialogStores = Cascade.panel.lager.auswahl_standard.getStore();
	/**
	 * @private function
	 */
	var _setDisabled = function(strId,bValue){	
		try{ //nur vorlufig
			if(bValue)
				Ext.getCmp(strId).disable();
			else if(bValue !== "undefined")
				Ext.getCmp(strId).enable();
		}	
		catch(err){}
	}
	
	var _setHide = function(strId,bValue){	
		if(bValue)
			Ext.getCmp(strId).hide();
		else if(bValue !== "undefined")
			Ext.getCmp(strId).show();	
	}
	
	var _setNumberfield = function(strId,strValue){
		Ext.getCmp(strId).setValue(strValue); 
	}
	
	var _setTextfield = function(strId,strValue){
		Ext.getCmp(strId).setValue(strValue); 
	}
	
	var _setCheckBox = function(strCheckId,strValue){
		Ext.getCmp(strCheckId).setValue(true);
		switch(strValue){
			case "HOEHE"		:
					var strDeselect = strCheckId.replace(/HOEHE/g,"EINBAUMASS");
					Ext.getCmp(strDeselect).setValue(false);	
					Ext.getCmp(strCheckId+"_Numberfield").enable();
					Ext.getCmp(strDeselect+"_Numberfield").disable();			
				break;
			case "EINBAUMASS" 	:
					var strDeselect = strCheckId.replace(/EINBAUMASS/g,"HOEHE");
					Ext.getCmp(strDeselect).setValue(false);
					Ext.getCmp(strCheckId+"_Numberfield").enable();
					Ext.getCmp(strDeselect+"_Numberfield").disable();
				break;	
		}	 
	}
	
	var _setFieldText = function(strId,strValue){
		try{
			Ext.getCmp(strId).setTitle(strValue,true);
		}
		catch(err){
		} 
	}
	
	/**
	 * @private function
	 */	
	var _setValueRadio = function(strValue){
		Ext.getCmp(strValue).suspendEvents(false);			
		Ext.getCmp(strValue).setValue(true);			
		Ext.getCmp(strValue).resumeEvents();	
	}
	
	var _setFieldSet_Function = function(message_lager){
		if(message_lager.disable){
			if(message_lager.disable.combo)
				_setDisabled("LAGER_GEFUEHRT_MEHRFACH",message_lager.disable.combo.value);
			if(message_lager.disable.radio){
				_setDisabled('LAGER_FUNCTION_LOSE',message_lager.disable.radio.vLOSE);
				_setDisabled('LAGER_FUNCTION_GEFUEHRT',message_lager.disable.radio.vGEFUEHRT);
				_setDisabled('LAGER_FUNCTION_GEFUEHRT_MEHRFACH',message_lager.disable.radio.vGEFUEHRT_MEHRFACH);
			}
		}
		
		if(message_lager.hide){
			if(message_lager.hide.combo)
				_setHide("LAGER_GEFUEHRT_MEHRFACH",message_lager.hide.combo.value);
			if(message_lager.hide.radio){
				_setHide('LAGER_FUNCTION_LOSE',message_lager.disable.radio.vLOSE);
				_setHide('LAGER_FUNCTION_GEFUEHRT',message_lager.disable.radio.vGEFUEHRT);
				_setHide('LAGER_FUNCTION_GEFUEHRT_MEHRFACH',message_lager.disable.radio.vGEFUEHRT_MEHRFACH);
			}	
		}
				
		if(message_lager.store){
			oDialogStores.storeGefuehrtMehrfach.loadData(message_lager.store);
		}
		
		if(message_lager.value){	
			if(message_lager.value.combo)
				Ext.getCmp("LAGER_GEFUEHRT_MEHRFACH").setValue(message_lager.value.combo);
			
			if(message_lager.value.radio)
				_setValueRadio('LAGER_FUNCTION_'+message_lager.value.radio);							
		}
	}
	
	var _setFieldSet_Merkmale = function(message_merkmale){
		if(message_merkmale.store){
			for(var a=0;a<message_merkmale.store.combo.length;a++){
				var aPart = message_merkmale.store.combo[a];
				var aPartD = message_merkmale.store.disable[a];
				var aPartH = message_merkmale.store.show[a];
				var aPartS = message_merkmale.store.sel[a];
				
				oDialogStores[aPart[0]].loadData(aPart[1]);
				_setDisabled("LAGER_MERKMALE_"+aPartD[0],aPartD[1]);
				//_setHide("LAGER_MERKMALE_"+aPartH[0]+"_FORM",!aPartH[1]);
				Ext.getCmp("LAGER_MERKMALE_"+aPartS[0]).setValue(aPartS[1]);
			}
		}
		
		if(message_merkmale.value){
			Ext.getCmp("LAGE_MERKMALE_HOEHENVERSTELLBAR").setValue(message_merkmale.value.vHoehenverstellbar);
			Ext.getCmp("LAGE_MERKMALE_GAT").setValue(message_merkmale.value.vGAT);
			Ext.getCmp("LAGE_MERKMALE_BUEGEL").setValue(message_merkmale.value.vBUEGEL);
		}
		
		if(message_merkmale.hide){
			_setHide("LAGE_MERKMALE_HOEHENVERSTELLBAR_FORM",message_merkmale.hide.vHoehenverstellbar);
			_setHide("LAGE_MERKMALE_GAT_FORM",message_merkmale.hide.vGAT);
			_setHide("LAGE_MERKMALE_BUEGEL_FORM",message_merkmale.hide.vBUEGEL);
		}
		
		if(message_merkmale.disabled){
			_setDisabled("LAGE_MERKMALE_HOEHENVERSTELLBAR",message_merkmale.disabled.vHoehenverstellbar);
			_setDisabled("LAGE_MERKMALE_GAT",message_merkmale.disabled.vGAT);
			_setDisabled("LAGE_MERKMALE_BUEGEL",message_merkmale.disabled.vBUEGEL);
		}
	}
	
	var _setFieldSet_BB = function(message_bb){
		if(message_bb.disabled){
			_setDisabled("LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_EINFACH",message_bb.disabled.vEINFACH);
			_setDisabled("LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_DOPPELT",message_bb.disabled.vDOPPELT);
			
			if(message_bb.disabled.vSCHRAUBBAR != undefined)
				_setDisabled("LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR",message_bb.disabled.vSCHRAUBBAR);
						
			if(message_bb.disabled.vKLEMMBAR != undefined)
				_setDisabled("LAGER_BEFESTIGUNG_BAUWERK_KLEMMBAR",message_bb.disabled.vKLEMMBAR);			
		}
		
		if(message_bb.value){
			var strHRadio = message_bb.value.SelBB;
			var strURadio = message_bb.value.SelSCHRAUBBAR;
			
			Ext.getCmp("LAGER_BEFESTIGUNG_BAUWERK_"+strHRadio).setValue(true);
			Ext.getCmp("LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_"+strURadio).setValue(true); 
		}
	}
	
	var _setFieldSet_Traeger = function(message_traeger){
		if(message_traeger.store){
			if(message_traeger.store.storeTArt)
				oDialogStores.storeTraegerArt.loadData(message_traeger.store.storeTArt);
			if(message_traeger.store.storeTGroesse)	
				oDialogStores.storeTraegerGroesse.loadData(message_traeger.store.storeTGroesse);
		}
		
		if(message_traeger.disabled){	
			_setDisabled("LAGER_TRAEGER_HOEHE",message_traeger.disabled.disHoehe);
			_setDisabled("LAGER_TRAEGER_BREITE",message_traeger.disabled.disBreite);
			_setDisabled("LAGER_TRAEGER_FLANSCHDICKE",message_traeger.disabled.disFDicke);			
			_setDisabled("LAGER_TRAEGER_ART",message_traeger.disabled.disTArt);
			_setDisabled("LAGER_TRAEGER_GROESSE",message_traeger.disabled.disTGroesse);
		}
		
		if(message_traeger.value){
			Ext.getCmp("LAGER_TRAEGER_HOEHE").setValue(message_traeger.value.vHoehe);
			Ext.getCmp("LAGER_TRAEGER_BREITE").setValue(message_traeger.value.vBreite);
			Ext.getCmp("LAGER_TRAEGER_FLANSCHDICKE").setValue(message_traeger.value.vFDicke);			
			Ext.getCmp("LAGER_TRAEGER_ART").setValue(message_traeger.value.vTArt);
			Ext.getCmp("LAGER_TRAEGER_GROESSE").setValue(message_traeger.value.vTGroesse);
		}
	}
	
	var _setFieldSet_Sonderabmessungen = function(message_sonderabmessungen){
		if(message_sonderabmessungen.disabled){
			_setDisabled("LAGER_SONDERABMESSUNGEN",message_sonderabmessungen.disabled.disChkSonder);
					
			_setDisabled("LAGER_LAGERLAENGE_CHECKBOX",message_sonderabmessungen.disabled.disChkLaenge);
			_setDisabled("LAGER_LAGERLAENGE_NUMBERFIELD",message_sonderabmessungen.disabled.disChkLaenge);
			
			_setDisabled("LAGER_LAGERHOEHE_CHECKBOX",message_sonderabmessungen.disabled.disChkHoehe);
			_setDisabled("LAGER_LAGERHOEHE_NUMBERFIELD",message_sonderabmessungen.disabled.disChkHoehe);
			
			_setDisabled("LAGER_LAGERBAUMASS_CHECKBOX",message_sonderabmessungen.disabled.disChkMass);
			_setDisabled("LAGER_LAGERBAUMASS_NUMBERFIELD",message_sonderabmessungen.disabled.disChkMass);
		}
		
		if(message_sonderabmessungen.value){
			if(message_sonderabmessungen.value.vSonder == true){
				Ext.getCmp("LAGER_SONDERABMESSUNGEN").expand();
				if(message_sonderabmessungen.value.vLaenge){
					Ext.getCmp("LAGER_LAGERLAENG_CHECKBOX").setValue(true);
					Ext.getCmp("LAGER_LAGERLAENGE_NUMBERFIELD").setValue(message_sonderabmessungen.value.vLaenge);
				}
				
				if(message_sonderabmessungen.value.vHoehe){
					Ext.getCmp("LAGER_LAGERHOEHE_CHECKBOX").setValue(true);
					Ext.getCmp("LAGER_LAGERHOEHE_NUMBERFIELD").setValue(message_sonderabmessungen.value.vHoehe);
				}
				
				if(message_sonderabmessungen.value.vMass){
					Ext.getCmp("LAGER_LAGERBAUMASS_CHECKBOX").setValue(true);
					Ext.getCmp("LAGER_LAGERBAUMASS_NUMBERFIELD").setValue(message_sonderabmessungen.value.vMass);
				}
			}
			else
				Ext.getCmp("LAGER_SONDERABMESSUNGEN").collapse();			
		}
	}
	
	var _setFieldSet_Tatsaechlichemass = function(message_tatsaechlichemass){
		if(message_tatsaechlichemass.disabled){
			_setDisabled("LAGER_TATSAECHLICHE_HOEHE",message_tatsaechlichemass.disabled.disTHoehe);
			_setDisabled("LAGER_TATSAECHLICHE_HOEHE_BEREICH",message_tatsaechlichemass.disabled.disZBHoehe);
			_setDisabled("LAGER_TATSAECHLICHE_EINBAUMASS",message_tatsaechlichemass.disabled.disTMass);
			_setDisabled("LAGER_TATSAECHLICHE_EINBAUMASS_BEREICH",message_tatsaechlichemass.disabled.disZBMass);
		}
		
		if(message_tatsaechlichemass.value){
			Ext.getCmp("LAGER_TATSAECHLICHE_HOEHE").setValue(message_tatsaechlichemass.value.vTHoehe);
			Ext.getCmp("LAGER_TATSAECHLICHE_EINBAUMASS").setValue(message_tatsaechlichemass.value.vTMass);
		}
	}
	
	//DATEN VERARBEITUNG	
	if(message.fieldset.lager_function){
		if(message.fieldset.lager_function.show == true){
			Ext.getCmp("LAGER_FUNCTION").show();	
			_setFieldSet_Function(message.fieldset.lager_function);
		}
		else
			Ext.getCmp("LAGER_FUNCTION").hide();	
	}
	
	if(message.fieldset.lager_merkmale){
		if(message.fieldset.lager_merkmale.show == true){
			Ext.getCmp("LAGER_MERKMALE").show();	
			_setFieldSet_Merkmale(message.fieldset.lager_merkmale);
		}
		else
			Ext.getCmp("LAGER_MERKMALE").hide();	
	}
	
	if(message.fieldset.lager_bb){
		if(message.fieldset.lager_bb.show == true){
			Ext.getCmp("LAGER_BEFESTIGUNG_BAUWERK").show();	
			_setFieldSet_BB(message.fieldset.lager_bb);
		}
		else
			Ext.getCmp("LAGER_BEFESTIGUNG_BAUWERK").hide();
		
	}
	
	if(message.fieldset.lager_traeger){
		if(message.fieldset.lager_traeger.show == true){
			Ext.getCmp("LAGER_TRAEGER").show();	
			_setFieldSet_Traeger(message.fieldset.lager_traeger);
		}
		else
			Ext.getCmp("LAGER_TRAEGER").hide();			
	}
	
	if(message.fieldset.lager_sonderabmessungen){
		if(message.fieldset.lager_sonderabmessungen.show == true && message.fieldset.lager_sonderabmessungen.Type == "STANDARD"){
			Ext.getCmp("LAGER_SONDERABMESSUNGEN").show();	
				
			if(message.fieldset.lager_sonderabmessungen.strHtmlTable)
				Cascade.panel.lager.auswahl_standard.setHTML_Table_SpecialDimension(message.fieldset.lager_sonderabmessungen.strHtmlTable);
						
			if(message.fieldset.lager_sonderabmessungen.disable  !== undefined)
				Cascade.panel.lager.auswahl_standard.updateFieldSetTitle("LAGER_SONDERABMESSUNGEN",message.fieldset.lager_sonderabmessungen.disable);
		}
		else if(message.fieldset.lager_sonderabmessungen.show == true && message.fieldset.lager_sonderabmessungen.Type == "POPUP"){
			Cascade.panel.lager.auswahl_standard_sonder.setBlock(true);
			var strDefaultId = Cascade.panel.lager.auswahl_standard_sonder.getDefaultId();			
			
			if(message.fieldset.lager_sonderabmessungen.value.BREITESTORE)
				Cascade.panel.lager.auswahl_standard_sonder.setLoadComboStore(message.fieldset.lager_sonderabmessungen.value.BREITESTORE,message.fieldset.lager_sonderabmessungen.value.BREITE,"LAGERBREITE");
			
			if(message.fieldset.lager_sonderabmessungen.value.LAENGESTORE)
				Cascade.panel.lager.auswahl_standard_sonder.setLoadComboStore(message.fieldset.lager_sonderabmessungen.value.LAENGESTORE,message.fieldset.lager_sonderabmessungen.value.LAENGE,"LAGERLAENGE");
			
			if(message.fieldset.lager_sonderabmessungen.value.LAENGE_MIN && message.fieldset.lager_sonderabmessungen.value.LAENGE_MAX)
				_setTextfield(strDefaultId+"_MINMAXL",message.fieldset.lager_sonderabmessungen.value.LAENGE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.LAENGE_MAX + " mm");
			
			if(message.fieldset.lager_sonderabmessungen.value.BREITE_MIN && message.fieldset.lager_sonderabmessungen.value.BREITE_MAX)
				_setTextfield(strDefaultId+"_MINMAXB",message.fieldset.lager_sonderabmessungen.value.BREITE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.BREITE_MAX + " mm");
			
		//	if(message.fieldset.lager_sonderabmessungen.value.HOEHE_MIN && message.fieldset.lager_sonderabmessungen.value.HOEHE_MAX)
		//		_setTextfield(strDefaultId+"_MINMAXH","(" + message.fieldset.lager_sonderabmessungen.value.HOEHE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.HOEHE_MAX + ")");
			
		//	if(message.fieldset.lager_sonderabmessungen.value.EMASS_MIN && message.fieldset.lager_sonderabmessungen.value.EMASS_MAX)
		//		_setTextfield(strDefaultId+"_MINMAXE","(" + message.fieldset.lager_sonderabmessungen.value.EMASS_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.EMASS_MAX + ")");
			
			if(message.fieldset.lager_sonderabmessungen.title){
				if(message.fieldset.lager_sonderabmessungen.title.Q1)
					_setFieldText(strDefaultId+"_Q1",message.fieldset.lager_sonderabmessungen.title.Q1);
				if(message.fieldset.lager_sonderabmessungen.title.Q2)
					_setFieldText(strDefaultId+"_Q2",message.fieldset.lager_sonderabmessungen.title.Q2);
				if(message.fieldset.lager_sonderabmessungen.title.Q3)
					_setFieldText(strDefaultId+"_Q3",message.fieldset.lager_sonderabmessungen.title.Q3);
				if(message.fieldset.lager_sonderabmessungen.title.Q4)
					_setFieldText(strDefaultId+"_Q4",message.fieldset.lager_sonderabmessungen.title.Q4);				
			}
			
			if(message.fieldset.lager_sonderabmessungen.checkbox){
				if(message.fieldset.lager_sonderabmessungen.checkbox.Q1)
					_setCheckBox(strDefaultId+"_Q1_"+message.fieldset.lager_sonderabmessungen.checkbox.Q1,message.fieldset.lager_sonderabmessungen.checkbox.Q1);
				if(message.fieldset.lager_sonderabmessungen.checkbox.Q2)
					_setCheckBox(strDefaultId+"_Q2_"+message.fieldset.lager_sonderabmessungen.checkbox.Q2,message.fieldset.lager_sonderabmessungen.checkbox.Q2);
				if(message.fieldset.lager_sonderabmessungen.checkbox.Q3)
					_setCheckBox(strDefaultId+"_Q3_"+message.fieldset.lager_sonderabmessungen.checkbox.Q3,message.fieldset.lager_sonderabmessungen.checkbox.Q3);
				if(message.fieldset.lager_sonderabmessungen.checkbox.Q4)
					_setCheckBox(strDefaultId+"_Q4_"+message.fieldset.lager_sonderabmessungen.checkbox.Q4,message.fieldset.lager_sonderabmessungen.checkbox.Q4);			
			}
			
			if(message.fieldset.lager_sonderabmessungen.value){				
				if(message.fieldset.lager_sonderabmessungen.value.Q1){
					try{
						_setNumberfield(strDefaultId+"_Q1_HOEHE_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q1.HOEHE);
						_setNumberfield(strDefaultId+"_Q1_EINBAUMASS_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q1.EINBAUMASS);
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q1) &&
								(message.fieldset.lager_sonderabmessungen.value.Q1.HOEHE_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q1.HOEHE_MAX))
							_setTextfield(strDefaultId+"_MINMAXH_Q1","(" + message.fieldset.lager_sonderabmessungen.value.Q1.HOEHE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q1.HOEHE_MAX + ")");
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q1) &&
								(message.fieldset.lager_sonderabmessungen.value.Q1.EMASS_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q1.EMASS_MAX))
							_setTextfield(strDefaultId+"_MINMAXE_Q1","(" + message.fieldset.lager_sonderabmessungen.value.Q1.EMASS_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q1.EMASS_MAX + ")");
					}
					catch(err){}
				}	
				
				if(message.fieldset.lager_sonderabmessungen.value.Q2){
					try{
						_setNumberfield(strDefaultId+"_Q2_HOEHE_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q2.HOEHE);						
						_setNumberfield(strDefaultId+"_Q2_EINBAUMASS_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q2.EINBAUMASS);						
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q2) &&
								(message.fieldset.lager_sonderabmessungen.value.Q2.HOEHE_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q2.HOEHE_MAX))
							_setTextfield(strDefaultId+"_MINMAXH_Q2","(" + message.fieldset.lager_sonderabmessungen.value.Q2.HOEHE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q2.HOEHE_MAX + ")");
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q2) &&
								(message.fieldset.lager_sonderabmessungen.value.Q2.EMASS_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q2.EMASS_MAX))
							_setTextfield(strDefaultId+"_MINMAXE_Q2","(" + message.fieldset.lager_sonderabmessungen.value.Q2.EMASS_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q2.EMASS_MAX + ")");
					}
					catch(err){}
				}	
				
				if(message.fieldset.lager_sonderabmessungen.value.Q3){
					try{
						_setNumberfield(strDefaultId+"_Q3_HOEHE_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q3.HOEHE);
						_setNumberfield(strDefaultId+"_Q3_EINBAUMASS_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q3.EINBAUMASS);
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q3) &&
								(message.fieldset.lager_sonderabmessungen.value.Q3.HOEHE_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q3.HOEHE_MAX))
							_setTextfield(strDefaultId+"_MINMAXH_Q3","(" + message.fieldset.lager_sonderabmessungen.value.Q3.HOEHE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q3.HOEHE_MAX + ")");
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q3) &&
								(message.fieldset.lager_sonderabmessungen.value.Q3.EMASS_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q3.EMASS_MAX))
							_setTextfield(strDefaultId+"_MINMAXE_Q3","(" + message.fieldset.lager_sonderabmessungen.value.Q3.EMASS_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q3.EMASS_MAX + ")");
					}
					catch(err){						
					}
				}	
				
				if(message.fieldset.lager_sonderabmessungen.value.Q4){
					try{
						_setNumberfield(strDefaultId+"_Q4_HOEHE_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q4.HOEHE);
						_setNumberfield(strDefaultId+"_Q4_EINBAUMASS_Numberfield",message.fieldset.lager_sonderabmessungen.value.Q4.EINBAUMASS);
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q4) &&
								(message.fieldset.lager_sonderabmessungen.value.Q4.HOEHE_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q4.HOEHE_MAX))
							_setTextfield(strDefaultId+"_MINMAXH_Q4","(" + message.fieldset.lager_sonderabmessungen.value.Q4.HOEHE_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q4.HOEHE_MAX + ")");
						if ((!message.fieldset.lager_sonderabmessungen.disable.Q4) &&
								(message.fieldset.lager_sonderabmessungen.value.Q4.EMASS_MIN) &&
								(message.fieldset.lager_sonderabmessungen.value.Q4.EMASS_MAX))
							_setTextfield(strDefaultId+"_MINMAXE_Q4","(" + message.fieldset.lager_sonderabmessungen.value.Q4.EMASS_MIN + " - " + message.fieldset.lager_sonderabmessungen.value.Q4.EMASS_MAX + ")");
					}
					catch(err){					
					}
				}
				
				if(message.fieldset.lager_sonderabmessungen.value.SONDER_LAENGE){
					try{
						_setNumberfield(strDefaultId+"_SONDER_LAGERLAENGE",message.fieldset.lager_sonderabmessungen.value.SONDER_LAENGE);
					}
					catch(err){					
					}
				}
				
				if(message.fieldset.lager_sonderabmessungen.value.SONDER_BREITE){
					try{
						_setNumberfield(strDefaultId+"_SONDER_LAGERBREITE",message.fieldset.lager_sonderabmessungen.value.SONDER_BREITE);
					}
					catch(err){					
					}
				}
			}		
			
			if(message.fieldset.lager_sonderabmessungen.picture1)
				//Ext.getCmp(strDefaultId+"_PICTURE1").updateBox(message.fieldset.lager_sonderabmessungen.picture1,true);
				Ext.getCmp(strDefaultId+"_PICTURE1").body.update(message.fieldset.lager_sonderabmessungen.picture1);
			if(message.fieldset.lager_sonderabmessungen.picture2)
				Ext.getCmp(strDefaultId+"_PICTURE2").body.update(message.fieldset.lager_sonderabmessungen.picture2);
				//Ext.getCmp(strDefaultId+"_PICTURE2").updateBox('<img src="catalog/client/custom/img/NO_PICTURE.png" style="cursor:pointer" />',true);
				
			if(message.fieldset.lager_sonderabmessungen.disable){				
				if(message.fieldset.lager_sonderabmessungen.disable.Q1)
					_setDisabled(strDefaultId+"_Q1",message.fieldset.lager_sonderabmessungen.disable.Q1);
				else
					_setDisabled(strDefaultId+"_Q1",message.fieldset.lager_sonderabmessungen.disable.Q1);
				
				if(message.fieldset.lager_sonderabmessungen.disable.Q2)
					_setDisabled(strDefaultId+"_Q2",message.fieldset.lager_sonderabmessungen.disable.Q2);
				else
					_setDisabled(strDefaultId+"_Q2",message.fieldset.lager_sonderabmessungen.disable.Q2);
					
				if(message.fieldset.lager_sonderabmessungen.disable.Q3)
					_setDisabled(strDefaultId+"_Q3",message.fieldset.lager_sonderabmessungen.disable.Q3);
				else
					_setDisabled(strDefaultId+"_Q3",message.fieldset.lager_sonderabmessungen.disable.Q3);	
					
				if(message.fieldset.lager_sonderabmessungen.disable.Q4)
					_setDisabled(strDefaultId+"_Q4",message.fieldset.lager_sonderabmessungen.disable.Q4);
				else
					_setDisabled(strDefaultId+"_Q4",message.fieldset.lager_sonderabmessungen.disable.Q4);	
				
				if(message.fieldset.lager_sonderabmessungen.disable.LAENGE)	
					_setDisabled(strDefaultId+"_LAGERLAENGE",message.fieldset.lager_sonderabmessungen.disable.LAENGE);
				else
					_setDisabled(strDefaultId+"_LAGERLAENGE",message.fieldset.lager_sonderabmessungen.disable.LAENGE);
				
				if (message.fieldset.lager_sonderabmessungen.disable.SONDER_LAENGE)
					_setDisabled(strDefaultId+"_SONDER_LAGERLAENGE",message.fieldset.lager_sonderabmessungen.disable.SONDER_LAENGE);
				else
					_setDisabled(strDefaultId+"_SONDER_LAGERLAENGE",message.fieldset.lager_sonderabmessungen.disable.SONDER_LAENGE);
				
				if (message.fieldset.lager_sonderabmessungen.disable.SONDER_BREITE)
					_setDisabled(strDefaultId+"_SONDER_LAGERBREITE",message.fieldset.lager_sonderabmessungen.disable.SONDER_BREITE);
				else
					_setDisabled(strDefaultId+"_SONDER_LAGERBREITE",message.fieldset.lager_sonderabmessungen.disable.SONDER_BREITE);
			}
			
			Cascade.panel.lager.auswahl_standard_sonder.setBlock(false);	
		}
		else
			Ext.getCmp("LAGER_SONDERABMESSUNGEN").hide();			
	}
	
	if(message.fieldset.lager_sonderabmessungen){		
		if(message.fieldset.lager_sonderabmessungen.checkbox){
			var oCheckbox = Ext.getCmp("LAGER_SONDERABMESSUNGEN").checkbox;
			if(message.fieldset.lager_sonderabmessungen.checkbox.bSonder != undefined){
				if(!message.fieldset.lager_sonderabmessungen.checkbox.bSonder){							
					Ext.getCmp("LAGER_SONDERABMESSUNGEN").onCollapse();
				}
				else{
					Ext.getCmp("LAGER_SONDERABMESSUNGEN").onExpand();
				}		
			}
			
			if(!message.fieldset.lager_sonderabmessungen.disable && message.fieldset.lager_sonderabmessungen.show)
				Ext.getCmp("LAGER_SONDERABMESSUNGEN").enable();
			else
				Ext.getCmp("LAGER_SONDERABMESSUNGEN").disable();	
		}
	}
	
	if(message.fieldset.lager_tatsaechlichemass){
		if(message.fieldset.lager_tatsaechlichemass.show == true){
			Ext.getCmp("LAGER_TATSAECHLICHE_MASS").show();	
			_setFieldSet_Tatsaechlichemass(message.fieldset.lager_tatsaechlichemass);
		}
		else
			Ext.getCmp("LAGER_TATSAECHLICHE_MASS").hide();			
	}
	
	if(message.resulttable){
		if(message.resulttable.store)
			oDialogStores.storeTable.loadData(message.resulttable.store);
		
		var oTable = Ext.getCmp("lager.auswahl_standard_tabelle");
		if(message.resulttable.strPriceLabel)			
			oTable.colModel.setColumnHeader(10,message.resulttable.strPriceLabel);
		
		if(message.resulttable.strLastEditionLabel)
			oTable.colModel.setColumnHeader(5,message.resulttable.strLastEditionLabel);
		
		if(message.resulttable.Error)
			Cascade.base.Messages.Warning_Message(message.resulttable.Error);
		
		if(message.resulttable.sel){
			oTable.selModel.selectRow(message.resulttable.sel);
			Ext.getCmp('move-next').show();
		}	
		
		oTable.getView().refresh();	
	}
	
	if(message.rechte){
		for(var a=0;a<message.rechte.disable.length;a++){
			_setDisabled(message.rechte.disable[a][0],message.rechte.disable[a][1]);
		}		
	}
	
	if(message.title)
		Ext.getCmp("lager.auswahl_standard").setTitle(message.title);
	
	//Gui Width correction
	var bShowFunction 	= !Ext.getCmp("LAGER_FUNCTION").hidden ? true : false;
	var bShowTraeg		= !Ext.getCmp("LAGER_TRAEGER").hidden ? true : false;
	
	if(!bShowFunction && bShowTraeg){
		var oMerkmale = Ext.getCmp("LAGER_MERKMALE");
		var dNewWidth = ((oMerkmale.getInnerWidth()-100) < 242) ? 243 : (oMerkmale.getInnerWidth()-100);
		oMerkmale.setWidth(dNewWidth);
	}
	
	if(message.TopologyPicture)
		Cascade.app.setTopologyPicture(message.TopologyPicture);
	
	Cascade.panel.lager.auswahl_standard.setResetName();	
	Cascade.panel.lager.auswahl_standard.setBlockEvent(false);			
}